/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.util.Enumeration;
import java.util.Vector;
import megamek.client.ui.AWT.Messages;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.WeaponType;

public class MechView {
    private Entity mech;
    private boolean isMech;
    private boolean isInf;
    private boolean isVehicle;
    private boolean isProto;
    StringBuffer sBasic = new StringBuffer();
    StringBuffer sLoadout = new StringBuffer();
    private static final String SPACES = "                                   ";

    public MechView(Entity entity) {
        this.mech = entity;
        this.isMech = entity instanceof Mech;
        this.isInf = entity instanceof Infantry;
        this.isVehicle = entity instanceof Tank;
        this.isProto = entity instanceof Protomech;
        this.sLoadout.append(this.getWeapons()).append("\r\n").append(this.getAmmo()).append("\r\n").append(this.getMisc()).append("\r\n").append(this.getFailed());
        this.sBasic.append(this.mech.getShortNameRaw());
        this.sBasic.append("\r\n");
        if (!this.isInf) {
            this.sBasic.append(Math.round(this.mech.getWeight())).append(Messages.getString("MechView.tons"));
        }
        if (this.mech.isMixedTech()) {
            if (this.mech.isClan()) {
                this.sBasic.append(Messages.getString("MechView.MixedClan"));
            } else {
                this.sBasic.append(Messages.getString("MechView.MixedIS"));
            }
        } else {
            this.sBasic.append(TechConstants.getLevelDisplayableName(this.mech.getTechLevel()));
        }
        this.sBasic.append("\n");
        if (this.mech.hasC3M() || this.mech.hasC3S() || this.mech.hasC3i()) {
            this.sBasic.append(Messages.getString("MechView.Linkedc3bv"));
            this.sBasic.append(this.mech.calculateBattleValue(true));
        }
        this.sBasic.append("\n");
        this.sBasic.append(Messages.getString("MechView.Movement")).append(this.mech.getWalkMP()).append("/").append(this.mech.getRunMPasString());
        if (this.mech.getJumpMP() > 0) {
            this.sBasic.append("/").append(this.mech.getJumpMP());
        }
        if (this.isVehicle) {
            this.sBasic.append(" (").append(entity.getMovementModeAsString()).append(")");
        }
        this.sBasic.append("\n");
        if (this.isMech) {
            Mech mech = (Mech)this.mech;
            this.sBasic.append(Messages.getString("MechView.Engine")).append(mech.engineRating());
            if (mech.hasXL()) {
                this.sBasic.append(Messages.getString("MechView.XL"));
            }
            if (mech.hasLightEngine()) {
                this.sBasic.append(Messages.getString("MechView.Light"));
            }
            this.sBasic.append("\n");
            this.sBasic.append(Messages.getString("MechView.HeatSinks")).append(mech.heatSinks());
            if (mech.getHeatCapacity() > mech.heatSinks()) {
                this.sBasic.append(" [").append(mech.getHeatCapacity()).append("]");
            }
            if (mech.getCockpitType() != 0) {
                this.sBasic.append("\n");
                this.sBasic.append(Messages.getString("MechView.Cockpit"));
                this.sBasic.append(mech.getCockpitTypeString());
            }
            if (mech.getGyroType() != 0) {
                this.sBasic.append("\n");
                this.sBasic.append(Messages.getString("MechView.Gyro"));
                this.sBasic.append(mech.getGyroTypeString());
            }
            this.sBasic.append("\n");
        }
        this.sBasic.append("\n").append(this.getInternalAndArmor());
    }

    public String getMechReadoutBasic() {
        return this.sBasic.toString();
    }

    public String getMechReadoutLoadout() {
        return this.sLoadout.toString();
    }

    public String getMechReadout() {
        return this.getMechReadoutBasic() + "\n" + this.getMechReadoutLoadout();
    }

    private String getInternalAndArmor() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.mech.getTotalInternal() * 2 + 3;
        stringBuffer.append(Messages.getString("MechView.Internal")).append(this.mech.getTotalInternal());
        if (this.isMech && ((Mech)this.mech).hasEndo()) {
            stringBuffer.append(Messages.getString("MechView.EndoSteel"));
        } else if (this.isMech && ((Mech)this.mech).hasReinforcedStructure()) {
            stringBuffer.append(Messages.getString("MechView.Reinforced"));
        } else if (this.isMech && ((Mech)this.mech).hasCompositeStructure()) {
            stringBuffer.append(Messages.getString("MechView.Composite"));
        }
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("MechView.Armor")).append(this.mech.getTotalArmor());
        if (this.isMech) {
            stringBuffer.append("/").append(n);
        }
        if (this.mech.getArmorType() != 0 && !this.isInf) {
            if (this.mech.getArmorType() != -1) {
                stringBuffer.append(" (");
                stringBuffer.append(EquipmentType.getArmorTypeName(this.mech.getArmorType()));
                stringBuffer.append(")");
            } else {
                stringBuffer.append(" (unknown)");
            }
        }
        stringBuffer.append("\n");
        for (int i = 0; i < this.mech.locations(); ++i) {
            if (-1 == this.mech.getInternal(i) || this.isVehicle && (i == 5 && ((Tank)this.mech).hasNoTurret() || i == 0)) continue;
            if (this.mech.getLocationAbbr(i).length() < 2) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.mech.getLocationAbbr(i)).append(": ");
            stringBuffer.append(MechView.renderArmor(this.mech.getInternal(i))).append("   ");
            if (-1 != this.mech.getArmor(i)) {
                stringBuffer.append(MechView.renderArmor(this.mech.getArmor(i)));
            }
            if (this.mech.hasRearArmor(i)) {
                stringBuffer.append(" (").append(MechView.renderArmor(this.mech.getArmor(i, true))).append(")");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String getWeapons() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.mech.getWeaponList();
        for (int i = 0; i < vector.size(); ++i) {
            Mounted mounted = (Mounted)vector.elementAt(i);
            WeaponType weaponType = (WeaponType)mounted.getType();
            stringBuffer.append(mounted.getDesc()).append("  [").append(this.mech.getLocationAbbr(mounted.getLocation())).append("]");
            if (this.mech.isClan() && mounted.getType().getInternalName().substring(0, 2).equals("IS")) {
                stringBuffer.append(Messages.getString("MechView.IS"));
            }
            if (!this.mech.isClan() && mounted.getType().getInternalName().substring(0, 2).equals("CL")) {
                stringBuffer.append(Messages.getString("MechView.Clan"));
            }
            if (weaponType.hasFlag(32768)) {
                stringBuffer.append(" <").append(mounted.getLinked().getDesc()).append(">");
            }
            stringBuffer.append(" ").append(weaponType.getHeat()).append(Messages.getString("MechView.Heat"));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String getAmmo() {
        Enumeration enumeration = this.mech.getAmmo();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.getLocation() == -1) continue;
            stringBuffer.append(mounted.getDesc()).append("  [").append(this.mech.getLocationAbbr(mounted.getLocation())).append("]\n");
        }
        return stringBuffer.toString();
    }

    private String getMisc() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.mech.getMisc();
        while (enumeration.hasMoreElements()) {
            object = (Mounted)enumeration.nextElement();
            String string = ((Mounted)object).getName();
            if (string.indexOf("Jump Jet") != -1 || string.indexOf("CASE") != -1 && this.mech.isClan() || string.indexOf("Heat Sink") != -1 || string.indexOf("Endo Steel") != -1 || string.indexOf("Ferro-Fibrous") != -1) continue;
            stringBuffer.append(((Mounted)object).getDesc()).append("  [").append(this.mech.getLocationAbbr(((Mounted)object).getLocation())).append("]");
            if (this.mech.isClan() && ((Mounted)object).getType().getInternalName().substring(0, 2).equals("IS")) {
                stringBuffer.append(Messages.getString("MechView.IS"));
            }
            if (!this.mech.isClan() && ((Mounted)object).getType().getInternalName().substring(0, 2).equals("CL")) {
                stringBuffer.append(Messages.getString("MechView.Clan"));
            }
            stringBuffer.append("\n");
        }
        object = this.mech.getUnusedString();
        if (object != null && ((String)object).length() > 0) {
            stringBuffer.append(Messages.getString("MechView.CarringCapacity")).append((String)object).append("\n");
        }
        return stringBuffer.toString();
    }

    private String getFailed() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.mech.getFailedEquipment();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append("The following equipment\n slots failed to load:\n");
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(enumeration.nextElement()).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private static String renderArmor(int n) {
        if (n <= 0) {
            return "xx";
        }
        return MechView.makeLength(String.valueOf(n), 2, true);
    }

    private static String makeLength(String string, int n, boolean bl) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 < n) {
            if (bl) {
                return SPACES.substring(0, n - n2) + string;
            }
            return string + SPACES.substring(0, n - n2);
        }
        return string.substring(0, n - 2) + "..";
    }
}

