/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.ConfirmDialog;
import megamek.client.ui.AWT.DoneButtoned;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.SingleChoiceDialog;
import megamek.client.ui.AWT.StatusBarPhaseDisplay;
import megamek.common.Building;
import megamek.common.BuildingTarget;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.BrushOffAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DodgeAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.ThrashAttackAction;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.DistractableAdapter;

public class PhysicalDisplay
extends StatusBarPhaseDisplay
implements GameListener,
ActionListener,
DoneButtoned,
KeyListener,
BoardViewListener,
Distractable {
    private DistractableAdapter distracted = new DistractableAdapter();
    public static final String PHYSICAL_PUNCH = "punch";
    public static final String PHYSICAL_KICK = "kick";
    public static final String PHYSICAL_CLUB = "club";
    public static final String PHYSICAL_BRUSH_OFF = "brushOff";
    public static final String PHYSICAL_THRASH = "thrash";
    public static final String PHYSICAL_DODGE = "dodge";
    public static final String PHYSICAL_PUSH = "push";
    public static final String PHYSICAL_NEXT = "next";
    public static final String PHYSICAL_PROTO = "protoPhysical";
    public static final String PHYSICAL_SEARCHLIGHT = "fireSearchlight";
    private static final int NUM_BUTTON_LAYOUTS = 2;
    private ClientGUI clientgui;
    private Client client;
    private Container panButtons;
    private Button butPunch;
    private Button butKick;
    private Button butPush;
    private Button butClub;
    private Button butBrush;
    private Button butThrash;
    private Button butDodge;
    private Button butProto;
    private Button butNext;
    private Button butDone;
    private Button butMore;
    private Button butSpace;
    private Button butSpace2;
    private Button butSearchlight;
    private int buttonLayout;
    private int cen = -1;
    private Targetable target;
    private Vector attacks;

    public PhysicalDisplay(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(this);
        clientGUI.getBoardView().addBoardViewListener(this);
        this.attacks = new Vector();
        this.setupStatusBar(Messages.getString("PhysicalDisplay.waitingForPhysicalAttackPhase"));
        this.butSpace = new Button(".");
        this.butSpace.setEnabled(false);
        this.butSpace2 = new Button(".");
        this.butSpace2.setEnabled(false);
        this.butPunch = new Button(Messages.getString("PhysicalDisplay.Punch"));
        this.butPunch.addActionListener(this);
        this.butPunch.setEnabled(false);
        this.butPunch.setActionCommand(PHYSICAL_PUNCH);
        this.butKick = new Button(Messages.getString("PhysicalDisplay.Kick"));
        this.butKick.addActionListener(this);
        this.butKick.setEnabled(false);
        this.butKick.setActionCommand(PHYSICAL_KICK);
        this.butPush = new Button(Messages.getString("PhysicalDisplay.Push"));
        this.butPush.addActionListener(this);
        this.butPush.setEnabled(false);
        this.butPush.setActionCommand(PHYSICAL_PUSH);
        this.butClub = new Button(Messages.getString("PhysicalDisplay.Clusb"));
        this.butClub.addActionListener(this);
        this.butClub.setEnabled(false);
        this.butClub.setActionCommand(PHYSICAL_CLUB);
        this.butBrush = new Button(Messages.getString("PhysicalDisplay.BrushOff"));
        this.butBrush.addActionListener(this);
        this.butBrush.setEnabled(false);
        this.butBrush.setActionCommand(PHYSICAL_BRUSH_OFF);
        this.butThrash = new Button(Messages.getString("PhysicalDisplay.Trash"));
        this.butThrash.addActionListener(this);
        this.butThrash.setEnabled(false);
        this.butThrash.setActionCommand(PHYSICAL_THRASH);
        this.butDodge = new Button(Messages.getString("PhysicalDisplay.Dodge"));
        this.butDodge.addActionListener(this);
        this.butDodge.setEnabled(false);
        this.butDodge.setActionCommand(PHYSICAL_DODGE);
        this.butProto = new Button(Messages.getString("PhysicalDisplay.ProtoPhysical"));
        this.butProto.addActionListener(this);
        this.butProto.setEnabled(false);
        this.butProto.setActionCommand(PHYSICAL_PROTO);
        this.butDone = new Button(Messages.getString("PhysicalDisplay.Done"));
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.butNext = new Button(Messages.getString("PhysicalDisplay.NextUnit"));
        this.butNext.addActionListener(this);
        this.butNext.setEnabled(false);
        this.butNext.setActionCommand(PHYSICAL_NEXT);
        this.butMore = new Button(Messages.getString("PhysicalDisplay.More"));
        this.butMore.addActionListener(this);
        this.butMore.setEnabled(false);
        this.butSearchlight = new Button(Messages.getString("FiringDisplay.Searchlight"));
        this.butSearchlight.addActionListener(this);
        this.butSearchlight.addKeyListener(this);
        this.butSearchlight.setActionCommand(PHYSICAL_SEARCHLIGHT);
        this.butSearchlight.setEnabled(false);
        this.panButtons = new Panel();
        this.buttonLayout = 0;
        this.setupButtonPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
        clientGUI.bv.addKeyListener(this);
        this.addKeyListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    private void setupButtonPanel() {
        this.panButtons.removeAll();
        this.panButtons.setLayout(new GridLayout(0, 8));
        switch (this.buttonLayout) {
            case 0: {
                this.panButtons.add(this.butNext);
                this.panButtons.add(this.butPunch);
                this.panButtons.add(this.butKick);
                this.panButtons.add(this.butPush);
                this.panButtons.add(this.butClub);
                this.panButtons.add(this.butSpace);
                this.panButtons.add(this.butMore);
                break;
            }
            case 1: {
                this.panButtons.add(this.butBrush);
                this.panButtons.add(this.butThrash);
                this.panButtons.add(this.butDodge);
                this.panButtons.add(this.butProto);
                this.panButtons.add(this.butSearchlight);
                this.panButtons.add(this.butSpace2);
                this.panButtons.add(this.butMore);
            }
        }
        this.validate();
    }

    public void selectEntity(int n) {
        if (this.client.game.getEntity(n) == null) {
            System.err.println("PhysicalDisplay: tried to select non-existant entity: " + n);
            return;
        }
        this.cen = n;
        this.clientgui.setSelectedEntityNum(n);
        Entity entity = this.ce();
        this.target(null);
        this.clientgui.getBoardView().highlight(this.ce().getPosition());
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.mechD.displayEntity(entity);
        this.clientgui.mechD.showPanel("movement");
        this.clientgui.bv.centerOnHex(entity.getPosition());
        this.clientgui.getMenuBar().setEntity(this.ce());
        Mounted mounted = Compute.clubMechHas(entity);
        if (mounted == null || mounted.getName().endsWith("Club")) {
            this.butClub.setLabel(Messages.getString("PhysicalDisplay.Club"));
        } else {
            this.butClub.setLabel(mounted.getName());
        }
        if (entity instanceof Mech && !entity.isProne() && entity.getCrew().getOptions().booleanOption("dodge_maneuver")) {
            this.setDodgeEnabled(true);
        }
    }

    private void beginMyTurn() {
        this.target(null);
        this.selectEntity(this.client.getFirstEntityNum());
        this.setNextEnabled(true);
        this.butDone.setEnabled(true);
        this.butMore.setEnabled(true);
        this.clientgui.setDisplayVisible(true);
        this.clientgui.getBoardView().select(null);
    }

    private void endMyTurn() {
        Entity entity = this.client.game.getNextEntity(this.client.game.getTurnIndex());
        if (14 == this.client.game.getPhase() && null != entity && null != this.ce() && entity.getOwnerId() != this.ce().getOwnerId()) {
            this.clientgui.setDisplayVisible(false);
        }
        this.cen = -1;
        this.target(null);
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.bv.clearMovementData();
        this.disableButtons();
    }

    private void disableButtons() {
        this.setKickEnabled(false);
        this.setPunchEnabled(false);
        this.setPushEnabled(false);
        this.setClubEnabled(false);
        this.setBrushOffEnabled(false);
        this.setThrashEnabled(false);
        this.setDodgeEnabled(false);
        this.setProtoEnabled(false);
        this.butDone.setEnabled(false);
        this.setNextEnabled(false);
    }

    private void ready() {
        if (this.attacks.isEmpty() && GUIPreferences.getInstance().getNagForNoAction()) {
            ConfirmDialog confirmDialog = this.clientgui.doYesNoBotherDialog(Messages.getString("PhysicalDisplay.DontPhysicalAttackDialog.title"), Messages.getString("PhysicalDisplay.DontPhysicalAttackDialog.message"));
            if (!confirmDialog.getShowAgain()) {
                GUIPreferences.getInstance().setNagForNoAction(false);
            }
            if (!confirmDialog.getAnswer()) {
                return;
            }
        }
        this.disableButtons();
        this.client.sendAttackData(this.cen, this.attacks);
        this.attacks.removeAllElements();
    }

    private void clearattacks() {
        if (this.attacks.size() > 0) {
            this.attacks.removeAllElements();
        }
        this.clientgui.mechD.wPan.displayMech(this.ce());
        this.updateTarget();
        Entity entity = this.client.game.getEntity(this.cen);
        entity.dodging = true;
    }

    private void punch() {
        String string;
        ToHitData toHitData = PunchAttackAction.toHit(this.client.game, this.cen, this.target, 1);
        ToHitData toHitData2 = PunchAttackAction.toHit(this.client.game, this.cen, this.target, 2);
        String string2 = Messages.getString("PhysicalDisplay.PunchDialog.title", new Object[]{this.target.getDisplayName()});
        if (this.clientgui.doYesNoDialog(string2, string = Messages.getString("PhysicalDisplay.PunchDialog.message", new Object[]{toHitData2.getValueAsString(), new Double(Compute.oddsAbove(toHitData2.getValue())), toHitData2.getDesc(), new Integer(PunchAttackAction.getDamageFor(this.ce(), 2)), toHitData2.getTableDesc(), toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), new Integer(PunchAttackAction.getDamageFor(this.ce(), 1)), toHitData.getTableDesc()}))) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            if (toHitData.getValue() != Integer.MAX_VALUE && toHitData2.getValue() != Integer.MAX_VALUE) {
                this.attacks.addElement(new PunchAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 0));
            } else if (toHitData.getValue() < toHitData2.getValue()) {
                this.attacks.addElement(new PunchAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 1));
            } else {
                this.attacks.addElement(new PunchAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 2));
            }
            this.ready();
        }
    }

    private void doSearchlight() {
        if (this.ce() == null || this.target == null) {
            throw new IllegalArgumentException("current searchlight parameters are invalid");
        }
        if (!SearchlightAttackAction.isPossible(this.client.game, this.cen, this.target, null)) {
            return;
        }
        SearchlightAttackAction searchlightAttackAction = new SearchlightAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId());
        this.attacks.addElement(searchlightAttackAction);
        this.client.game.addAction(searchlightAttackAction);
        this.clientgui.bv.addAttack(searchlightAttackAction);
        this.clientgui.bv.repaint(100L);
        this.clientgui.minimap.drawMap();
        this.setSearchlightEnabled(false);
        this.updateTarget();
    }

    private void kick() {
        String string;
        String string2;
        ToHitData toHitData = KickAttackAction.toHit(this.client.game, this.cen, this.target, 1);
        ToHitData toHitData2 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 2);
        ToHitData toHitData3 = null;
        ToHitData toHitData4 = null;
        if (this.client.game.getEntity(this.cen) instanceof QuadMech && this.client.game.getOptions().booleanOption("maxtech_mulekicks")) {
            toHitData3 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 4);
            toHitData4 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 3);
        }
        int n = 1;
        int n2 = toHitData.getValue();
        ToHitData toHitData5 = toHitData;
        if (n2 > toHitData2.getValue()) {
            n2 = toHitData2.getValue();
            n = 2;
            toHitData5 = toHitData2;
        }
        if (this.client.game.getEntity(this.cen) instanceof QuadMech && this.client.game.getOptions().booleanOption("maxtech_mulekicks")) {
            if (n2 > toHitData3.getValue()) {
                n2 = toHitData3.getValue();
                n = 4;
                toHitData5 = toHitData3;
            }
            if (n2 > toHitData4.getValue()) {
                n2 = toHitData4.getValue();
                n = 3;
                toHitData5 = toHitData4;
            }
        }
        if (this.clientgui.doYesNoDialog(string2 = Messages.getString("PhysicalDisplay.KickDialog.title", new Object[]{this.target.getDisplayName()}), string = Messages.getString("PhysicalDisplay.KickDialog.message", new Object[]{toHitData5.getValueAsString(), new Double(Compute.oddsAbove(toHitData5.getValue())), toHitData5.getDesc(), KickAttackAction.getDamageFor(this.ce(), n) + toHitData5.getTableDesc()}))) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new KickAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), n));
            this.ready();
        }
    }

    private void push() {
        ToHitData toHitData = PushAttackAction.toHit(this.client.game, this.cen, this.target);
        String string = Messages.getString("PhysicalDisplay.PushDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.PushDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new PushAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), this.target.getPosition()));
            this.ready();
        }
    }

    private void club() {
        Mounted mounted = Compute.clubMechHas(this.ce());
        ToHitData toHitData = ClubAttackAction.toHit(this.client.game, this.cen, this.target, mounted);
        String string = Messages.getString("PhysicalDisplay.ClubDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.ClubDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), ClubAttackAction.getDamageFor(this.ce(), mounted) + toHitData.getTableDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new ClubAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), mounted));
            this.ready();
        }
    }

    private void proto() {
        ToHitData toHitData = ProtomechPhysicalAttackAction.toHit(this.client.game, this.cen, this.target);
        String string = Messages.getString("PhysicalDisplay.ProtoMechAttackDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.ProtoMechAttackDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), ProtomechPhysicalAttackAction.getDamageFor(this.ce()) + toHitData.getTableDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            if (GUIPreferences.getInstance().getAutoDeclareSearchlight()) {
                this.doSearchlight();
            }
            this.attacks.addElement(new ProtomechPhysicalAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId()));
            this.ready();
        }
    }

    private void brush() {
        ToHitData toHitData = BrushOffAttackAction.toHit(this.client.game, this.cen, this.target, 1);
        ToHitData toHitData2 = BrushOffAttackAction.toHit(this.client.game, this.cen, this.target, 2);
        boolean bl = Integer.MAX_VALUE != toHitData.getValue();
        boolean bl2 = Integer.MAX_VALUE != toHitData2.getValue();
        int n = 0;
        int n2 = 0;
        String string = null;
        StringBuffer stringBuffer = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String[] stringArray = null;
        SingleChoiceDialog singleChoiceDialog = null;
        if (!bl && !bl2) {
            this.clientgui.doAlertDialog(Messages.getString("PhysicalDisplay.AlertDialog.title"), Messages.getString("PhysicalDisplay.AlertDialog.message"));
            return;
        }
        if (bl && bl2) {
            string4 = Messages.getString("PhysicalDisplay.bothArms");
            stringBuffer = new StringBuffer(Messages.getString("PhysicalDisplay.whichArm"));
            string = Messages.getString("PhysicalDisplay.chooseBrushOff");
        } else {
            stringBuffer = new StringBuffer(Messages.getString("PhysicalDisplay.confirmArm"));
            string = Messages.getString("PhysicalDisplay.confirmBrushOff");
        }
        if (11 == this.target.getTargetType()) {
            stringBuffer.append(Messages.getString("PhysicalDisplay.brushOff1"));
        } else {
            stringBuffer.append(Messages.getString("PhysicalDisplay.brushOff2"));
        }
        if (bl) {
            n = BrushOffAttackAction.getDamageFor(this.ce(), 1);
            string2 = Messages.getString("PhysicalDisplay.LAHit", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), new Integer(n)});
        }
        if (bl2) {
            n2 = BrushOffAttackAction.getDamageFor(this.ce(), 2);
            string3 = Messages.getString("PhysicalDisplay.RAHit", new Object[]{toHitData2.getValueAsString(), new Double(Compute.oddsAbove(toHitData2.getValue())), new Integer(n2)});
        }
        if (bl && bl2) {
            stringArray = new String[]{string2.toString(), string3.toString(), string4.toString()};
            singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, string, stringBuffer.toString(), stringArray);
            singleChoiceDialog.show();
            if (singleChoiceDialog.getAnswer()) {
                this.disableButtons();
                switch (singleChoiceDialog.getChoice()) {
                    case 0: {
                        this.attacks.addElement(new BrushOffAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 1));
                        break;
                    }
                    case 1: {
                        this.attacks.addElement(new BrushOffAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 2));
                        break;
                    }
                    case 2: {
                        this.attacks.addElement(new BrushOffAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 0));
                    }
                }
                this.ready();
            }
        } else if (bl) {
            stringArray = new String[]{string2.toString()};
            singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, string, stringBuffer.toString(), stringArray);
            singleChoiceDialog.show();
            if (singleChoiceDialog.getAnswer()) {
                this.disableButtons();
                this.attacks.addElement(new BrushOffAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 1));
                this.ready();
            }
        } else if (bl2) {
            stringArray = new String[]{string3.toString()};
            singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, string, stringBuffer.toString(), stringArray);
            singleChoiceDialog.show();
            if (singleChoiceDialog.getAnswer()) {
                this.disableButtons();
                this.attacks.addElement(new BrushOffAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId(), 2));
                this.ready();
            }
        }
    }

    private void thrash() {
        ThrashAttackAction thrashAttackAction = new ThrashAttackAction(this.cen, this.target.getTargetType(), this.target.getTargetId());
        ToHitData toHitData = thrashAttackAction.toHit(this.client.game);
        String string = Messages.getString("PhysicalDisplay.TrashDialog.title", new Object[]{this.target.getDisplayName()});
        String string2 = Messages.getString("PhysicalDisplay.TrashDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), ThrashAttackAction.getDamageFor(this.ce()) + toHitData.getTableDesc()});
        if (this.clientgui.doYesNoDialog(string, string2)) {
            this.disableButtons();
            this.attacks.addElement(thrashAttackAction);
            this.ready();
        }
    }

    private void dodge() {
        if (this.clientgui.doYesNoDialog(Messages.getString("PhysicalDisplay.DodgeDialog.title"), Messages.getString("PhysicalDisplay.DodgeDialog.message"))) {
            this.disableButtons();
            Entity entity = this.client.game.getEntity(this.cen);
            entity.dodging = true;
            DodgeAction dodgeAction = new DodgeAction(this.cen);
            this.attacks.addElement(dodgeAction);
            this.ready();
        }
    }

    void target(Targetable targetable) {
        this.target = targetable;
        this.updateTarget();
    }

    private void updateTarget() {
        if (this.cen != -1 && this.target != null) {
            boolean bl;
            ToHitData toHitData;
            ToHitData toHitData2;
            if (this.target.getTargetType() != 11) {
                ToHitData toHitData3;
                Serializable serializable;
                ToHitData toHitData4;
                boolean bl2;
                toHitData2 = PunchAttackAction.toHit(this.client.game, this.cen, this.target, 1);
                toHitData = PunchAttackAction.toHit(this.client.game, this.cen, this.target, 2);
                bl = toHitData2.getValue() != Integer.MAX_VALUE || toHitData.getValue() != Integer.MAX_VALUE;
                this.setPunchEnabled(bl);
                ToHitData toHitData5 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 1);
                ToHitData toHitData6 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 2);
                boolean bl3 = bl2 = toHitData5.getValue() != Integer.MAX_VALUE || toHitData6.getValue() != Integer.MAX_VALUE;
                if (this.client.game.getOptions().booleanOption("maxtech_mulekicks")) {
                    toHitData4 = KickAttackAction.toHit(this.client.game, this.cen, this.target, 4);
                    serializable = KickAttackAction.toHit(this.client.game, this.cen, this.target, 3);
                    bl2 |= serializable.getValue() != Integer.MAX_VALUE || toHitData4.getValue() != Integer.MAX_VALUE;
                }
                this.setKickEnabled(bl2);
                toHitData4 = PushAttackAction.toHit(this.client.game, this.cen, this.target);
                this.setPushEnabled(toHitData4.getValue() != Integer.MAX_VALUE);
                serializable = Compute.clubMechHas(this.ce());
                if (serializable != null) {
                    toHitData3 = ClubAttackAction.toHit(this.client.game, this.cen, this.target, (Mounted)serializable);
                    this.setClubEnabled(toHitData3.getValue() != Integer.MAX_VALUE);
                } else {
                    this.setClubEnabled(false);
                }
                toHitData3 = new ThrashAttackAction(this.cen, this.target).toHit(this.client.game);
                this.setThrashEnabled(toHitData3.getValue() != Integer.MAX_VALUE);
                ToHitData toHitData7 = ProtomechPhysicalAttackAction.toHit(this.client.game, this.cen, this.target);
                this.setProtoEnabled(toHitData7.getValue() != Integer.MAX_VALUE);
            }
            toHitData2 = BrushOffAttackAction.toHit(this.client.game, this.cen, this.target, 2);
            toHitData = BrushOffAttackAction.toHit(this.client.game, this.cen, this.target, 1);
            bl = toHitData2.getValue() != Integer.MAX_VALUE || toHitData.getValue() != Integer.MAX_VALUE;
            this.setBrushOffEnabled(bl);
        } else {
            this.setPunchEnabled(false);
            this.setPushEnabled(false);
            this.setKickEnabled(false);
            this.setClubEnabled(false);
            this.setBrushOffEnabled(false);
            this.setThrashEnabled(false);
            this.setProtoEnabled(false);
        }
        this.setSearchlightEnabled(this.ce() != null && this.target != null && this.ce().isUsingSpotlight());
    }

    private Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    public void hexMoused(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if ((boardViewEvent.getModifiers() & 2) != 0) {
            return;
        }
        if (this.client.isMyTurn() && (boardViewEvent.getModifiers() & 0x10) != 0) {
            if (boardViewEvent.getType() == 2) {
                if (!boardViewEvent.getCoords().equals(this.clientgui.getBoardView().getLastCursor())) {
                    this.clientgui.getBoardView().cursor(boardViewEvent.getCoords());
                }
            } else if (boardViewEvent.getType() == 0) {
                this.clientgui.getBoardView().select(boardViewEvent.getCoords());
            }
        }
    }

    public void hexSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && boardViewEvent.getCoords() != null && this.ce() != null) {
            Targetable targetable = this.chooseTarget(boardViewEvent.getCoords());
            if (targetable != null) {
                this.target(targetable);
            } else {
                this.target(null);
            }
        }
    }

    private Targetable chooseTarget(Coords coords) {
        String[] stringArray;
        Targetable targetable = null;
        Enumeration enumeration = this.client.game.getEntities(coords);
        Vector<Targetable> vector = new Vector<Targetable>();
        while (enumeration.hasMoreElements()) {
            targetable = (Targetable)enumeration.nextElement();
            if (this.ce().equals(targetable)) continue;
            vector.addElement(targetable);
        }
        Building building = this.client.game.getBoard().getBuildingAt(coords);
        if (building != null) {
            vector.addElement(new BuildingTarget(coords, this.client.game.getBoard(), false));
        }
        if (this.ce().getPosition().equals(coords)) {
            stringArray = this.ce().getINarcPodsAttached();
            while (stringArray.hasMoreElements()) {
                targetable = (Targetable)stringArray.nextElement();
                vector.addElement(targetable);
            }
        }
        if (vector.size() == 1) {
            targetable = (Targetable)vector.elementAt(0);
        } else if (vector.size() > 1) {
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((Targetable)vector.elementAt(i)).getDisplayName();
            }
            SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("PhysicalDisplay.ChooseTargetDialog.title"), Messages.getString("PhysicalDisplay.ChooseTargetDialog.message", new Object[]{coords.getBoardNum()}), stringArray);
            singleChoiceDialog.show();
            if (singleChoiceDialog.getAnswer()) {
                targetable = (Targetable)vector.elementAt(singleChoiceDialog.getChoice());
            }
        }
        return targetable;
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.game.getPhase() == 14) {
            this.endMyTurn();
            if (this.client.isMyTurn()) {
                this.beginMyTurn();
                this.setStatusBarText(Messages.getString("PhysicalDisplay.its_your_turn"));
            } else {
                this.setStatusBarText(Messages.getString("PhysicalDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
            }
        } else {
            System.err.println("PhysicalDisplay: got turnchange event when it's not the physical attacks phase");
        }
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.client.game.getPhase() != 14) {
            this.endMyTurn();
        }
        if (this.client.game.getPhase() == 14) {
            this.setStatusBarText(Messages.getString("PhysicalDisplay.waitingForPhysicalAttackPhase"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource() == this.butDone) {
            this.ready();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_PUNCH)) {
            this.punch();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_KICK)) {
            this.kick();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_PUSH)) {
            this.push();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_CLUB)) {
            this.club();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_BRUSH_OFF)) {
            this.brush();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_THRASH)) {
            this.thrash();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_DODGE)) {
            this.dodge();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_PROTO)) {
            this.proto();
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_NEXT)) {
            this.selectEntity(this.client.getNextEntityNum(this.cen));
        } else if (actionEvent.getActionCommand().equals(PHYSICAL_SEARCHLIGHT)) {
            this.doSearchlight();
        } else if (actionEvent.getSource() == this.butMore) {
            ++this.buttonLayout;
            if (this.buttonLayout >= 2) {
                this.buttonLayout = 0;
            }
            this.setupButtonPanel();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (keyEvent.getKeyCode() == 27) {
            this.clearattacks();
        } else if (keyEvent.getKeyCode() != 10 || !keyEvent.isControlDown() || this.client.isMyTurn()) {
            // empty if block
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void finishedMovingUnits(BoardViewEvent boardViewEvent) {
    }

    public void unitSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        Entity entity = this.client.game.getEntity(boardViewEvent.getEntityId());
        if (this.client.isMyTurn()) {
            if (this.client.game.getTurn().isValidEntity(entity, this.client.game)) {
                this.selectEntity(entity.getId());
            }
        } else {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.mechD.displayEntity(entity);
            if (entity.isDeployed()) {
                this.clientgui.bv.centerOnHex(entity.getPosition());
            }
        }
    }

    public void setThrashEnabled(boolean bl) {
        this.butThrash.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalThrashEnabled(bl);
    }

    public void setPunchEnabled(boolean bl) {
        this.butPunch.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalPunchEnabled(bl);
    }

    public void setKickEnabled(boolean bl) {
        this.butKick.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalKickEnabled(bl);
    }

    public void setPushEnabled(boolean bl) {
        this.butPush.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalPushEnabled(bl);
    }

    public void setClubEnabled(boolean bl) {
        this.butClub.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalClubEnabled(bl);
    }

    public void setBrushOffEnabled(boolean bl) {
        this.butBrush.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalBrushOffEnabled(bl);
    }

    public void setDodgeEnabled(boolean bl) {
        this.butDodge.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalDodgeEnabled(bl);
    }

    public void setProtoEnabled(boolean bl) {
        this.butProto.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalProtoEnabled(bl);
    }

    public void setNextEnabled(boolean bl) {
        this.butNext.setEnabled(bl);
        this.clientgui.getMenuBar().setPhysicalNextEnabled(bl);
    }

    private void setSearchlightEnabled(boolean bl) {
        this.butSearchlight.setEnabled(bl);
        this.clientgui.getMenuBar().setFireSearchlightEnabled(bl);
    }

    public boolean isIgnoringEvents() {
        return this.distracted.isIgnoringEvents();
    }

    public void setIgnoringEvents(boolean bl) {
        this.distracted.setIgnoringEvents(bl);
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
    }

    public Button getDoneButton() {
        return this.butDone;
    }
}

