/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import megamek.client.ui.AWT.MechDisplay;
import megamek.client.ui.AWT.widget.PMPicPolygonalArea;
import megamek.client.ui.AWT.widget.PicMap;

public class MechPanelTabStrip
extends PicMap {
    private static final String IMAGE_DIR = "data/images/widgets";
    private PMPicPolygonalArea[] tabs = new PMPicPolygonalArea[5];
    private static final Image[] idleImage = new Image[5];
    private static final Image[] activeImage = new Image[5];
    private Image idleCorner;
    private Image selectedCorner;
    private int activeTab = 0;
    MechDisplay md;
    private Polygon firstTab = new Polygon(new int[]{0, 43, 59, 59, 0}, new int[]{0, 0, 16, 17, 17}, 5);
    private int[] pointsX = new int[]{0, 43, 59, 59, 13, 0};
    private int[] pointsY = new int[]{0, 0, 16, 17, 17, 4};

    public MechPanelTabStrip(MechDisplay mechDisplay) {
        this.md = mechDisplay;
    }

    public void setTab(int n) {
        if (n > 4) {
            n = 4;
        }
        this.activeTab = n;
        this.redrawImages();
        this.update();
    }

    public void addNotify() {
        super.addNotify();
        this.setImages();
        this.setAreas();
        this.setListeners();
        this.update();
    }

    private void setImages() {
        MediaTracker mediaTracker = new MediaTracker(this);
        Toolkit toolkit = this.getToolkit();
        MechPanelTabStrip.idleImage[0] = toolkit.getImage("data/images/widgets/tab_general_idle.gif");
        MechPanelTabStrip.idleImage[1] = toolkit.getImage("data/images/widgets/tab_armor_idle.gif");
        MechPanelTabStrip.idleImage[2] = toolkit.getImage("data/images/widgets/tab_systems_idle.gif");
        MechPanelTabStrip.idleImage[3] = toolkit.getImage("data/images/widgets/tab_weapon_idle.gif");
        MechPanelTabStrip.idleImage[4] = toolkit.getImage("data/images/widgets/tab_extras_idle.gif");
        MechPanelTabStrip.activeImage[0] = toolkit.getImage("data/images/widgets/tab_general_active.gif");
        MechPanelTabStrip.activeImage[1] = toolkit.getImage("data/images/widgets/tab_armor_active.gif");
        MechPanelTabStrip.activeImage[2] = toolkit.getImage("data/images/widgets/tab_systems_active.gif");
        MechPanelTabStrip.activeImage[3] = toolkit.getImage("data/images/widgets/tab_weapon_active.gif");
        MechPanelTabStrip.activeImage[4] = toolkit.getImage("data/images/widgets/tab_extras_active.gif");
        this.idleCorner = toolkit.getImage("data/images/widgets/idle_corner.gif");
        this.selectedCorner = toolkit.getImage("data/images/widgets/active_corner.gif");
        for (int i = 0; i < 5; ++i) {
            mediaTracker.addImage(idleImage[i], 0);
            mediaTracker.addImage(activeImage[i], 0);
        }
        mediaTracker.addImage(this.idleCorner, 0);
        mediaTracker.addImage(this.selectedCorner, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("TabStrip: Error while image loading.");
        }
        if (mediaTracker.isErrorID(0)) {
            System.out.println("TabStrip: Could Not load Image.");
        }
    }

    private void setAreas() {
        int n;
        int n2 = 47;
        this.tabs[0] = new PMPicPolygonalArea(this.firstTab, this.createImage(47, 18));
        for (n = 1; n < 4; ++n) {
            this.tabs[n] = new PMPicPolygonalArea(new Polygon(this.pointsX, this.pointsY, 6), this.createImage(47, 18));
        }
        this.tabs[4] = new PMPicPolygonalArea(new Polygon(this.pointsX, this.pointsY, 6), this.createImage(60, 18));
        for (n = 0; n < 5; ++n) {
            this.drawIdleImage(n);
            this.tabs[n].translate(n * n2, 0);
            this.addElement(this.tabs[n]);
        }
    }

    private void setListeners() {
        this.tabs[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "mouse_down") {
                    MechPanelTabStrip.this.setTab(0);
                    MechPanelTabStrip.this.md.showPanel("movement");
                }
            }
        });
        this.tabs[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "mouse_down") {
                    MechPanelTabStrip.this.setTab(1);
                    MechPanelTabStrip.this.md.showPanel("armor");
                }
            }
        });
        this.tabs[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "mouse_down") {
                    MechPanelTabStrip.this.setTab(2);
                    MechPanelTabStrip.this.md.showPanel("systems");
                }
            }
        });
        this.tabs[3].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "mouse_down") {
                    MechPanelTabStrip.this.setTab(3);
                    MechPanelTabStrip.this.md.showPanel("weapons");
                }
            }
        });
        this.tabs[4].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "mouse_down") {
                    MechPanelTabStrip.this.setTab(4);
                    MechPanelTabStrip.this.md.showPanel("extras");
                }
            }
        });
    }

    private void redrawImages() {
        for (int i = 0; i < 5; ++i) {
            this.drawIdleImage(i);
        }
    }

    private void drawIdleImage(int n) {
        if (this.tabs[n] == null) {
            return;
        }
        Graphics graphics = this.tabs[n].getIdleImage().getGraphics();
        if (this.activeTab == n) {
            graphics.drawImage(activeImage[n], 0, 0, null);
        } else {
            graphics.drawImage(idleImage[n], 0, 0, null);
            if (n - this.activeTab == 1) {
                graphics.drawImage(this.selectedCorner, 0, 4, null);
            } else if (n > 0) {
                graphics.drawImage(this.idleCorner, 0, 4, null);
            }
        }
        graphics.dispose();
    }

    public void onResize() {
    }
}

