/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.DisplayMapSet;
import megamek.client.ui.AWT.widget.PMAreasGroup;
import megamek.client.ui.AWT.widget.PMSimplePolygonArea;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.PMValueLabel;
import megamek.common.Entity;
import megamek.common.Protomech;

public class ProtomechMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private PMValueLabel[] sectionLabels = new PMValueLabel[6];
    private PMValueLabel[] armorLabels = new PMValueLabel[6];
    private PMValueLabel[] internalLabels = new PMValueLabel[6];
    private PMSimplePolygonArea[] areas = new PMSimplePolygonArea[6];
    private Polygon head = new Polygon(new int[]{50, 50, 60, 80, 90, 90, 80, 60}, new int[]{40, 20, 10, 10, 20, 40, 50, 50}, 8);
    private Polygon mainGun = new Polygon(new int[]{20, 20, 50, 50}, new int[]{30, 0, 0, 30}, 4);
    private Polygon leftArm = new Polygon(new int[]{0, 0, 20, 30, 40, 30, 20, 20, 10}, new int[]{100, 40, 30, 30, 60, 60, 70, 110, 110}, 9);
    private Polygon rightArm = new Polygon(new int[]{120, 120, 110, 100, 110, 120, 140, 140, 130}, new int[]{110, 70, 60, 60, 30, 30, 40, 100, 110, 110}, 9);
    private Polygon torso = new Polygon(new int[]{40, 40, 30, 50, 50, 60, 80, 90, 90, 110, 100, 100}, new int[]{130, 60, 30, 30, 40, 50, 50, 40, 30, 30, 60, 130}, 12);
    private Polygon legs = new Polygon(new int[]{0, 0, 10, 30, 30, 40, 100, 110, 110, 130, 140, 140, 100, 90, 90, 80, 60, 50, 50, 40}, new int[]{240, 230, 220, 220, 160, 130, 130, 160, 220, 220, 230, 240, 240, 230, 190, 170, 170, 190, 230, 240}, 20);
    private Component comp;
    private PMAreasGroup content = new PMAreasGroup();
    private Vector bgDrawers = new Vector();
    private int stepY = 53;
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public ProtomechMapSet(Component component) {
        this.comp = component;
        this.setAreas();
        this.setBackGround();
    }

    private void setAreas() {
        this.areas[0] = new PMSimplePolygonArea(this.head);
        this.areas[4] = new PMSimplePolygonArea(this.legs);
        this.areas[3] = new PMSimplePolygonArea(this.leftArm);
        this.areas[2] = new PMSimplePolygonArea(this.rightArm);
        this.areas[1] = new PMSimplePolygonArea(this.torso);
        this.areas[5] = new PMSimplePolygonArea(this.mainGun);
        for (int i = 0; i <= 5; ++i) {
            this.content.addArea(this.areas[i]);
        }
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        for (int i = 0; i < 6; ++i) {
            this.sectionLabels[i] = new PMValueLabel(fontMetrics, Color.black);
            this.content.addArea(this.sectionLabels[i]);
            this.armorLabels[i] = new PMValueLabel(fontMetrics, Color.yellow.brighter());
            this.content.addArea(this.armorLabels[i]);
            this.internalLabels[i] = new PMValueLabel(fontMetrics, Color.red.brighter());
            this.content.addArea(this.internalLabels[i]);
        }
        this.sectionLabels[0].moveTo(70, 30);
        this.armorLabels[0].moveTo(60, 45);
        this.internalLabels[0].moveTo(80, 45);
        this.sectionLabels[1].moveTo(70, 70);
        this.armorLabels[1].moveTo(70, 85);
        this.internalLabels[1].moveTo(70, 100);
        this.sectionLabels[2].moveTo(125, 55);
        this.armorLabels[2].moveTo(125, 70);
        this.internalLabels[2].moveTo(125, 85);
        this.sectionLabels[3].moveTo(15, 55);
        this.armorLabels[3].moveTo(15, 70);
        this.internalLabels[3].moveTo(15, 85);
        this.sectionLabels[4].moveTo(70, 150);
        this.armorLabels[4].moveTo(60, 165);
        this.internalLabels[4].moveTo(80, 165);
        this.sectionLabels[5].moveTo(35, 15);
        this.armorLabels[5].moveTo(25, 30);
        this.internalLabels[5].moveTo(45, 30);
    }

    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    public Vector getBackgroundDrawers() {
        return this.bgDrawers;
    }

    public void setEntity(Entity entity) {
        Protomech protomech = (Protomech)entity;
        int n = 0;
        int n2 = 0;
        int n3 = protomech.locations();
        if (n3 != 6) {
            this.armorLabels[5].setVisible(false);
            this.internalLabels[5].setVisible(false);
            this.sectionLabels[5].setVisible(false);
        } else {
            this.armorLabels[5].setVisible(true);
            this.internalLabels[5].setVisible(true);
            this.sectionLabels[5].setVisible(true);
        }
        for (int i = 0; i < n3; ++i) {
            n = protomech.getArmor(i);
            n2 = protomech.getInternal(i);
            this.armorLabels[i].setValue(protomech.getArmorString(i));
            this.internalLabels[i].setValue(protomech.getInternalString(i));
            this.sectionLabels[i].setValue(protomech.getLocationAbbr(i));
        }
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }
}

