/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.EquipmentType;
import megamek.common.Mounted;
import megamek.common.RangeType;
import megamek.common.TechConstants;
import megamek.common.WeaponType;

public class AmmoType
extends EquipmentType {
    public static final int T_BA_SMALL_LASER = -3;
    public static final int T_BA_MG = -2;
    public static final int T_NA = -1;
    public static final int T_AC = 1;
    public static final int T_VEHICLE_FLAMER = 2;
    public static final int T_MG = 3;
    public static final int T_MG_HEAVY = 4;
    public static final int T_MG_LIGHT = 5;
    public static final int T_GAUSS = 6;
    public static final int T_LRM = 7;
    public static final int T_LRM_TORPEDO = 8;
    public static final int T_SRM = 9;
    public static final int T_SRM_TORPEDO = 10;
    public static final int T_SRM_STREAK = 11;
    public static final int T_MRM = 12;
    public static final int T_NARC = 13;
    public static final int T_AMS = 14;
    public static final int T_ARROW_IV = 15;
    public static final int T_LONG_TOM = 16;
    public static final int T_SNIPER = 17;
    public static final int T_THUMPER = 18;
    public static final int T_AC_LBX = 19;
    public static final int T_AC_ULTRA = 20;
    public static final int T_GAUSS_LIGHT = 21;
    public static final int T_GAUSS_HEAVY = 22;
    public static final int T_AC_ROTARY = 23;
    public static final int T_SRM_ADVANCED = 24;
    public static final int T_BA_INFERNO = 25;
    public static final int T_BA_MICRO_BOMB = 26;
    public static final int T_LRM_TORPEDO_COMBO = 27;
    public static final int T_MINE = 28;
    public static final int T_ATM = 29;
    public static final int T_ROCKET_LAUNCHER = 30;
    public static final int T_INARC = 31;
    public static final int T_LRM_STREAK = 32;
    public static final int T_AC_LBX_THB = 33;
    public static final int T_AC_ULTRA_THB = 34;
    public static final int T_LAC = 35;
    public static final int T_HEAVY_FLAMER = 36;
    public static final int T_COOLANT_POD = 37;
    public static final int NUM_TYPES = 38;
    public static final int F_MG = 1;
    public static final int F_BATTLEARMOR = 4096;
    public static final int F_PROTOMECH = 64;
    public static final long M_STANDARD = 0L;
    public static final long M_CLUSTER = 1L;
    public static final long M_ARMOR_PIERCING = 2L;
    public static final long M_FLECHETTE = 4L;
    public static final long M_INCENDIARY_AC = 8L;
    public static final long M_PRECISION = 16L;
    public static final long M_TRACER = 0x400000000L;
    public static final long M_EXTENDED_RANGE = 32L;
    public static final long M_HIGH_EXPLOSIVE = 64L;
    public static final long M_FRAGMENTATION = 128L;
    public static final long M_LISTEN_KILL = 256L;
    public static final long M_ANTI_TSM = 512L;
    public static final long M_NARC_CAPABLE = 1024L;
    public static final long M_ARTEMIS_CAPABLE = 2048L;
    public static final long M_INCENDIARY_LRM = 4096L;
    public static final long M_FLARE = 8192L;
    public static final long M_SEMIGUIDED = 16384L;
    public static final long M_SWARM = 32768L;
    public static final long M_SWARM_I = 65536L;
    public static final long M_THUNDER = 131072L;
    public static final long M_THUNDER_AUGMENTED = 262144L;
    public static final long M_THUNDER_INFERNO = 524288L;
    public static final long M_THUNDER_VIBRABOMB = 0x100000L;
    public static final long M_THUNDER_ACTIVE = 0x200000L;
    public static final long M_INFERNO = 0x400000L;
    public static final long M_AX_HEAD = 0x800000L;
    public static final long M_EXPLOSIVE = 0x1000000L;
    public static final long M_ECM = 0x2000000L;
    public static final long M_HAYWIRE = 0x4000000L;
    public static final long M_NEMESIS = 0x8000000L;
    public static final long M_NARC_EX = 0x10000000L;
    public static final long M_HOMING = 0x20000000L;
    public static final long M_FASCAM = 0x40000000L;
    public static final long M_INFERNO_IV = 0x80000000L;
    public static final long M_VIBRABOMB_IV = 0x100000000L;
    public static final long M_SMOKE = 0x200000000L;
    private static Vector[] m_vaMunitions = new Vector[38];
    protected int damagePerShot;
    protected int rackSize;
    private int ammoType;
    private long munitionType;
    protected int shots;
    protected int heat;
    protected RangeType range;
    protected int tech;

    public static Vector getMunitionsFor(int n) {
        return m_vaMunitions[n];
    }

    public AmmoType() {
        this.criticals = 1;
        this.tonnage = 1.0f;
        this.explosive = true;
        this.instantModeSwitch = false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AmmoType)) {
            return false;
        }
        return this.getAmmoType() == ((AmmoType)object).getAmmoType() && this.getRackSize() == ((AmmoType)object).getRackSize();
    }

    public int getAmmoType() {
        return this.ammoType;
    }

    public long getMunitionType() {
        return this.munitionType;
    }

    public int getDamagePerShot() {
        return this.damagePerShot;
    }

    public int getRackSize() {
        return this.rackSize;
    }

    public int getShots() {
        return this.shots;
    }

    public static AmmoType getOneshotAmmo(Mounted mounted) {
        WeaponType weaponType = (WeaponType)mounted.getType();
        Vector vector = AmmoType.getMunitionsFor(weaponType.getAmmoType());
        AmmoType ammoType = null;
        for (int i = 0; i < vector.size(); ++i) {
            ammoType = (AmmoType)vector.elementAt(i);
            if (ammoType.getRackSize() != weaponType.getRackSize() || !TechConstants.isLegal(mounted.getType().getTechLevel(), ammoType.getTechLevel())) continue;
            return ammoType;
        }
        return null;
    }

    public static void initializeTypes() {
        Vector<AmmoType> vector = new Vector<AmmoType>(11);
        Vector<AmmoType> vector2 = new Vector<AmmoType>();
        Vector<AmmoType> vector3 = new Vector<AmmoType>(26);
        Vector<AmmoType> vector4 = new Vector<AmmoType>();
        Vector<AmmoType> vector5 = new Vector<AmmoType>(4);
        Vector<AmmoType> vector6 = new Vector<AmmoType>(4);
        Vector<AmmoType> vector7 = new Vector<AmmoType>(4);
        Vector<AmmoType> vector8 = new Vector<AmmoType>(2);
        Vector<AmmoType> vector9 = new Vector<AmmoType>(6);
        Vector<AmmoType> vector10 = new Vector<AmmoType>(6);
        Vector<MunitionMutator> vector11 = new Vector<MunitionMutator>();
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        AmmoType ammoType = null;
        MunitionMutator munitionMutator = null;
        EquipmentType.addType(AmmoType.createISVehicleFlamerAmmo());
        EquipmentType.addType(AmmoType.createISMGAmmo());
        EquipmentType.addType(AmmoType.createISMGAmmoHalf());
        ammoType = AmmoType.createISAC2Ammo();
        vector5.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISAC5Ammo();
        vector5.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISAC10Ammo();
        vector5.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISAC20Ammo();
        vector5.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLRM5Ammo();
        vector3.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLRM10Ammo();
        vector3.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLRM15Ammo();
        vector3.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISLRM20Ammo();
        vector3.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISSRM2Ammo();
        vector.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISSRM4Ammo();
        vector.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISSRM6Ammo();
        vector.addElement(ammoType);
        EquipmentType.addType(ammoType);
        EquipmentType.addType(AmmoType.createISLAC2Ammo());
        EquipmentType.addType(AmmoType.createISLAC5Ammo());
        EquipmentType.addType(AmmoType.createISHeavyFlamerAmmo());
        EquipmentType.addType(AmmoType.createCoolantPod());
        EquipmentType.addType(AmmoType.createISLB2XAmmo());
        EquipmentType.addType(AmmoType.createISLB5XAmmo());
        EquipmentType.addType(AmmoType.createISLB10XAmmo());
        EquipmentType.addType(AmmoType.createISLB20XAmmo());
        EquipmentType.addType(AmmoType.createISLB2XClusterAmmo());
        EquipmentType.addType(AmmoType.createISLB5XClusterAmmo());
        EquipmentType.addType(AmmoType.createISLB10XClusterAmmo());
        EquipmentType.addType(AmmoType.createISLB20XClusterAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB2XAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB5XAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB20XAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB2XClusterAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB5XClusterAmmo());
        EquipmentType.addType(AmmoType.createISTHBLB20XClusterAmmo());
        EquipmentType.addType(AmmoType.createISUltra2Ammo());
        EquipmentType.addType(AmmoType.createISUltra5Ammo());
        EquipmentType.addType(AmmoType.createISUltra10Ammo());
        EquipmentType.addType(AmmoType.createISUltra20Ammo());
        EquipmentType.addType(AmmoType.createISTHBUltra2Ammo());
        EquipmentType.addType(AmmoType.createISTHBUltra10Ammo());
        EquipmentType.addType(AmmoType.createISTHBUltra20Ammo());
        EquipmentType.addType(AmmoType.createISRotary2Ammo());
        EquipmentType.addType(AmmoType.createISRotary5Ammo());
        EquipmentType.addType(AmmoType.createISGaussAmmo());
        EquipmentType.addType(AmmoType.createISLTGaussAmmo());
        EquipmentType.addType(AmmoType.createISHVGaussAmmo());
        EquipmentType.addType(AmmoType.createISStreakSRM2Ammo());
        EquipmentType.addType(AmmoType.createISStreakSRM4Ammo());
        EquipmentType.addType(AmmoType.createISStreakSRM6Ammo());
        EquipmentType.addType(AmmoType.createISMRM10Ammo());
        EquipmentType.addType(AmmoType.createISMRM20Ammo());
        EquipmentType.addType(AmmoType.createISMRM30Ammo());
        EquipmentType.addType(AmmoType.createISMRM40Ammo());
        EquipmentType.addType(AmmoType.createISRL10Ammo());
        EquipmentType.addType(AmmoType.createISRL15Ammo());
        EquipmentType.addType(AmmoType.createISRL20Ammo());
        EquipmentType.addType(AmmoType.createISAMSAmmo());
        EquipmentType.addType(AmmoType.createISNarcAmmo());
        EquipmentType.addType(AmmoType.createISNarcExplosiveAmmo());
        EquipmentType.addType(AmmoType.createISiNarcAmmo());
        EquipmentType.addType(AmmoType.createISiNarcECMAmmo());
        EquipmentType.addType(AmmoType.createISiNarcExplosiveAmmo());
        EquipmentType.addType(AmmoType.createISiNarcHaywireAmmo());
        EquipmentType.addType(AmmoType.createISiNarcNemesisAmmo());
        EquipmentType.addType(AmmoType.createISLRT5Ammo());
        EquipmentType.addType(AmmoType.createISLRT10Ammo());
        EquipmentType.addType(AmmoType.createISLRT15Ammo());
        EquipmentType.addType(AmmoType.createISLRT20Ammo());
        EquipmentType.addType(AmmoType.createISSRT2Ammo());
        EquipmentType.addType(AmmoType.createISSRT4Ammo());
        EquipmentType.addType(AmmoType.createISSRT6Ammo());
        ammoType = AmmoType.createISLongTomAmmo();
        vector9.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISSniperAmmo();
        vector9.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISThumperAmmo();
        vector8.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createISArrowIVAmmo();
        vector6.addElement(ammoType);
        EquipmentType.addType(ammoType);
        EquipmentType.addType(AmmoType.createCLLB2XAmmo());
        EquipmentType.addType(AmmoType.createCLLB5XAmmo());
        EquipmentType.addType(AmmoType.createCLLB10XAmmo());
        EquipmentType.addType(AmmoType.createCLLB20XAmmo());
        EquipmentType.addType(AmmoType.createCLLB2XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLLB5XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLLB10XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLLB20XClusterAmmo());
        EquipmentType.addType(AmmoType.createCLUltra2Ammo());
        EquipmentType.addType(AmmoType.createCLUltra5Ammo());
        EquipmentType.addType(AmmoType.createCLUltra10Ammo());
        EquipmentType.addType(AmmoType.createCLUltra20Ammo());
        EquipmentType.addType(AmmoType.createCLRotary2Ammo());
        EquipmentType.addType(AmmoType.createCLRotary5Ammo());
        EquipmentType.addType(AmmoType.createCLRotary10Ammo());
        EquipmentType.addType(AmmoType.createCLRotary20Ammo());
        EquipmentType.addType(AmmoType.createCLGaussAmmo());
        EquipmentType.addType(AmmoType.createCLStreakSRM1Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM2Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM3Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM4Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM5Ammo());
        EquipmentType.addType(AmmoType.createCLStreakSRM6Ammo());
        EquipmentType.addType(AmmoType.createCLVehicleFlamerAmmo());
        EquipmentType.addType(AmmoType.createCLMGAmmo());
        EquipmentType.addType(AmmoType.createCLMGAmmoHalf());
        EquipmentType.addType(AmmoType.createCLHeavyMGAmmo());
        EquipmentType.addType(AmmoType.createCLHeavyMGAmmoHalf());
        EquipmentType.addType(AmmoType.createCLLightMGAmmo());
        EquipmentType.addType(AmmoType.createCLLightMGAmmoHalf());
        EquipmentType.addType(AmmoType.createCLAMSAmmo());
        EquipmentType.addType(AmmoType.createCLNarcAmmo());
        EquipmentType.addType(AmmoType.createCLNarcExplosiveAmmo());
        EquipmentType.addType(AmmoType.createCLATM3Ammo());
        EquipmentType.addType(AmmoType.createCLATM3ERAmmo());
        EquipmentType.addType(AmmoType.createCLATM3HEAmmo());
        EquipmentType.addType(AmmoType.createCLATM6Ammo());
        EquipmentType.addType(AmmoType.createCLATM6ERAmmo());
        EquipmentType.addType(AmmoType.createCLATM6HEAmmo());
        EquipmentType.addType(AmmoType.createCLATM9Ammo());
        EquipmentType.addType(AmmoType.createCLATM9ERAmmo());
        EquipmentType.addType(AmmoType.createCLATM9HEAmmo());
        EquipmentType.addType(AmmoType.createCLATM12Ammo());
        EquipmentType.addType(AmmoType.createCLATM12ERAmmo());
        EquipmentType.addType(AmmoType.createCLATM12HEAmmo());
        EquipmentType.addType(AmmoType.createCLStreakLRM5Ammo());
        EquipmentType.addType(AmmoType.createCLStreakLRM10Ammo());
        EquipmentType.addType(AmmoType.createCLStreakLRM15Ammo());
        EquipmentType.addType(AmmoType.createCLStreakLRM20Ammo());
        EquipmentType.addType(AmmoType.createCLSRT1Ammo());
        EquipmentType.addType(AmmoType.createCLSRT2Ammo());
        EquipmentType.addType(AmmoType.createCLSRT3Ammo());
        EquipmentType.addType(AmmoType.createCLSRT4Ammo());
        EquipmentType.addType(AmmoType.createCLSRT5Ammo());
        EquipmentType.addType(AmmoType.createCLSRT6Ammo());
        EquipmentType.addType(AmmoType.createCLLRT1Ammo());
        EquipmentType.addType(AmmoType.createCLLRT2Ammo());
        EquipmentType.addType(AmmoType.createCLLRT3Ammo());
        EquipmentType.addType(AmmoType.createCLLRT4Ammo());
        EquipmentType.addType(AmmoType.createCLLRT5Ammo());
        EquipmentType.addType(AmmoType.createCLLRT6Ammo());
        EquipmentType.addType(AmmoType.createCLLRT7Ammo());
        EquipmentType.addType(AmmoType.createCLLRT8Ammo());
        EquipmentType.addType(AmmoType.createCLLRT9Ammo());
        EquipmentType.addType(AmmoType.createCLLRT10Ammo());
        EquipmentType.addType(AmmoType.createCLLRT11Ammo());
        EquipmentType.addType(AmmoType.createCLLRT12Ammo());
        EquipmentType.addType(AmmoType.createCLLRT13Ammo());
        EquipmentType.addType(AmmoType.createCLLRT14Ammo());
        EquipmentType.addType(AmmoType.createCLLRT15Ammo());
        EquipmentType.addType(AmmoType.createCLLRT16Ammo());
        EquipmentType.addType(AmmoType.createCLLRT17Ammo());
        EquipmentType.addType(AmmoType.createCLLRT18Ammo());
        EquipmentType.addType(AmmoType.createCLLRT19Ammo());
        EquipmentType.addType(AmmoType.createCLLRT20Ammo());
        ammoType = AmmoType.createCLLongTomAmmo();
        vector10.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSniperAmmo();
        vector10.addElement(ammoType);
        ammoType = AmmoType.createCLThumperAmmo();
        EquipmentType.addType(ammoType);
        vector10.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLArrowIVAmmo();
        vector7.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM1Ammo();
        vector2.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM2Ammo();
        vector2.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM3Ammo();
        vector2.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM4Ammo();
        vector2.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM5Ammo();
        vector2.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLSRM6Ammo();
        vector2.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM1Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM2Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM3Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM4Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM5Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM6Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM7Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM8Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM9Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM10Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM11Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM12Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM13Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM14Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM15Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM16Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM17Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM18Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM19Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        ammoType = AmmoType.createCLLRM20Ammo();
        vector4.addElement(ammoType);
        EquipmentType.addType(ammoType);
        EquipmentType.addType(AmmoType.createBASRM2Ammo());
        EquipmentType.addType(AmmoType.createBASRM2OSAmmo());
        EquipmentType.addType(AmmoType.createBAInfernoSRMAmmo());
        EquipmentType.addType(AmmoType.createBAMicroBombAmmo());
        EquipmentType.addType(AmmoType.createCLTorpedoLRM5Ammo());
        EquipmentType.addType(AmmoType.createFenrirSRM4Ammo());
        EquipmentType.addType(AmmoType.createBACompactNarcAmmo());
        EquipmentType.addType(AmmoType.createBAMineLauncherAmmo());
        EquipmentType.addType(AmmoType.createBALRM5Ammo());
        EquipmentType.addType(AmmoType.createPhalanxSRM4Ammo());
        EquipmentType.addType(AmmoType.createGrenadierSRM4Ammo());
        EquipmentType.addType(AmmoType.createBAInfernoSRMAmmo());
        EquipmentType.addType(AmmoType.createAdvancedSRM1Ammo());
        EquipmentType.addType(AmmoType.createAdvancedSRM2Ammo());
        EquipmentType.addType(AmmoType.createAdvancedSRM3Ammo());
        EquipmentType.addType(AmmoType.createAdvancedSRM4Ammo());
        EquipmentType.addType(AmmoType.createAdvancedSRM5Ammo());
        EquipmentType.addType(AmmoType.createAdvancedSRM6Ammo());
        EquipmentType.addType(AmmoType.createISLAWLauncherAmmo());
        EquipmentType.addType(AmmoType.createISLAW2LauncherAmmo());
        EquipmentType.addType(AmmoType.createISLAW3LauncherAmmo());
        EquipmentType.addType(AmmoType.createISLAW4LauncherAmmo());
        EquipmentType.addType(AmmoType.createISLAW5LauncherAmmo());
        EquipmentType.addType(AmmoType.createISMRM1Ammo());
        EquipmentType.addType(AmmoType.createISMRM2Ammo());
        EquipmentType.addType(AmmoType.createISMRM3Ammo());
        EquipmentType.addType(AmmoType.createISMRM4Ammo());
        EquipmentType.addType(AmmoType.createISMRM5Ammo());
        EquipmentType.addType(AmmoType.createBAISLRM1Ammo());
        EquipmentType.addType(AmmoType.createBAISLRM2Ammo());
        EquipmentType.addType(AmmoType.createBAISLRM3Ammo());
        EquipmentType.addType(AmmoType.createBAISLRM4Ammo());
        EquipmentType.addType(AmmoType.createBAISLRM5Ammo());
        EquipmentType.addType(AmmoType.createBACLLRM1Ammo());
        EquipmentType.addType(AmmoType.createBACLLRM2Ammo());
        EquipmentType.addType(AmmoType.createBACLLRM3Ammo());
        EquipmentType.addType(AmmoType.createBACLLRM4Ammo());
        EquipmentType.addType(AmmoType.createBACLLRM5Ammo());
        EquipmentType.addType(AmmoType.createBASRM1Ammo());
        EquipmentType.addType(AmmoType.createBASRM2Ammo());
        EquipmentType.addType(AmmoType.createBASRM3Ammo());
        EquipmentType.addType(AmmoType.createBASRM4Ammo());
        EquipmentType.addType(AmmoType.createBASRM5Ammo());
        EquipmentType.addType(AmmoType.createBASRM6Ammo());
        EquipmentType.addType(AmmoType.createCLPROHeavyMGAmmo());
        EquipmentType.addType(AmmoType.createCLPROMGAmmo());
        EquipmentType.addType(AmmoType.createCLPROLightMGAmmo());
        vector11.removeAllElements();
        vector11.addElement(new MunitionMutator("Inferno", 1, 0x400000L, 1));
        vector11.addElement(new MunitionMutator("Fragmentation", 1, 128L, 1));
        vector11.addElement(new MunitionMutator("Narc capable", 1, 1024L, 1));
        vector11.addElement(new MunitionMutator("Artemis capable", 1, 2048L, 1));
        vector11.addElement(new MunitionMutator("Listen-Kill", 1, 256L, 5));
        vector11.addElement(new MunitionMutator("Anti-TSM", 1, 512L, 5));
        vector11.addElement(new MunitionMutator("Acid", 1, 0x800000L, 5));
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ammoType = (AmmoType)enumeration.nextElement();
            enumeration2 = vector11.elements();
            while (enumeration2.hasMoreElements()) {
                munitionMutator = (MunitionMutator)enumeration2.nextElement();
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
        vector11.removeAllElements();
        vector11.addElement(new MunitionMutator("(Clan) Inferno", 1, 0x400000L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Fragmentation", 1, 128L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Narc capable", 1, 1024L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Artemis capable", 1, 2048L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Listen-Kill", 1, 256L, 6));
        vector11.addElement(new MunitionMutator("(Clan) Anti-TSM", 1, 512L, 6));
        vector11.addElement(new MunitionMutator("(Clan) Acid", 1, 0x800000L, 6));
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            ammoType = (AmmoType)enumeration.nextElement();
            enumeration2 = vector11.elements();
            while (enumeration2.hasMoreElements()) {
                munitionMutator = (MunitionMutator)enumeration2.nextElement();
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
        vector11.removeAllElements();
        vector11.addElement(new MunitionMutator("Flare", 1, 8192L, 1));
        vector11.addElement(new MunitionMutator("Fragmentation", 1, 128L, 1));
        vector11.addElement(new MunitionMutator("Thunder", 1, 131072L, 1));
        vector11.addElement(new MunitionMutator("Thunder-Augmented", 2, 262144L, 1));
        vector11.addElement(new MunitionMutator("Thunder-Inferno", 2, 524288L, 1));
        vector11.addElement(new MunitionMutator("Thunder-Active", 2, 0x200000L, 1));
        vector11.addElement(new MunitionMutator("Thunder-Vibrabomb", 2, 0x100000L, 1));
        vector11.addElement(new MunitionMutator("Narc capable", 1, 1024L, 1));
        vector11.addElement(new MunitionMutator("Artemis capable", 1, 2048L, 1));
        vector11.addElement(new MunitionMutator("Semi guided", 1, 16384L, 1));
        vector11.addElement(new MunitionMutator("Swarm", 1, 32768L, 1));
        vector11.addElement(new MunitionMutator("Swarm-I", 1, 65536L, 1));
        vector11.addElement(new MunitionMutator("Listen-Kill", 1, 256L, 5));
        vector11.addElement(new MunitionMutator("Anti-TSM", 1, 512L, 5));
        enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            ammoType = (AmmoType)enumeration.nextElement();
            enumeration2 = vector11.elements();
            while (enumeration2.hasMoreElements()) {
                munitionMutator = (MunitionMutator)enumeration2.nextElement();
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
        vector11.removeAllElements();
        vector11.addElement(new MunitionMutator("(Clan) Flare", 1, 8192L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Fragmentation", 1, 128L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Thunder", 1, 131072L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Thunder-Augmented", 2, 262144L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Thunder-Inferno", 2, 524288L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Thunder-Active", 2, 0x200000L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Thunder-Vibrabomb", 2, 0x100000L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Narc capable", 1, 1024L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Artemis capable", 1, 2048L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Semi guided", 1, 16384L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Swarm", 1, 32768L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Swarm-I", 1, 65536L, 2));
        vector11.addElement(new MunitionMutator("(Clan) Listen-Kill", 1, 256L, 6));
        vector11.addElement(new MunitionMutator("(Clan) Anti-TSM", 1, 512L, 6));
        enumeration = vector4.elements();
        while (enumeration.hasMoreElements()) {
            ammoType = (AmmoType)enumeration.nextElement();
            enumeration2 = vector11.elements();
            while (enumeration2.hasMoreElements()) {
                munitionMutator = (MunitionMutator)enumeration2.nextElement();
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
        vector11.removeAllElements();
        vector11.addElement(new MunitionMutator("Precision", 2, 16L, 1));
        vector11.addElement(new MunitionMutator("Armor-Piercing", 2, 2L, 1));
        vector11.addElement(new MunitionMutator("Flechette", 1, 4L, 1));
        vector11.addElement(new MunitionMutator("Incendiary", 1, 8L, 1));
        vector11.addElement(new MunitionMutator("Tracer", 1, 0x400000000L, 5));
        enumeration = vector5.elements();
        while (enumeration.hasMoreElements()) {
            ammoType = (AmmoType)enumeration.nextElement();
            enumeration2 = vector11.elements();
            while (enumeration2.hasMoreElements()) {
                munitionMutator = (MunitionMutator)enumeration2.nextElement();
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
        vector11.removeAllElements();
        vector11.addElement(new MunitionMutator("Homing", 1, 0x20000000L, 1));
        vector11.addElement(new MunitionMutator("FASCAM", 1, 0x40000000L, 1));
        vector11.addElement(new MunitionMutator("Inferno-IV", 1, 0x80000000L, 1));
        vector11.addElement(new MunitionMutator("Vibrabomb-IV", 1, 0x100000000L, 1));
        vector11.addElement(new MunitionMutator("Illumination", 1, 8192L, 5));
        enumeration = vector6.elements();
        while (enumeration.hasMoreElements()) {
            ammoType = (AmmoType)enumeration.nextElement();
            enumeration2 = vector11.elements();
            while (enumeration2.hasMoreElements()) {
                munitionMutator = (MunitionMutator)enumeration2.nextElement();
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
        vector11.removeAllElements();
        vector11.addElement(new MunitionMutator("Homing", 1, 0x20000000L, 2));
        vector11.addElement(new MunitionMutator("FASCAM", 1, 0x40000000L, 2));
        vector11.addElement(new MunitionMutator("Inferno-IV", 1, 0x80000000L, 2));
        vector11.addElement(new MunitionMutator("Vibrabomb-IV", 1, 0x100000000L, 2));
        enumeration = vector7.elements();
        while (enumeration.hasMoreElements()) {
            ammoType = (AmmoType)enumeration.nextElement();
            enumeration2 = vector11.elements();
            while (enumeration2.hasMoreElements()) {
                munitionMutator = (MunitionMutator)enumeration2.nextElement();
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
        vector11.removeAllElements();
        vector11.addElement(new MunitionMutator("Smoke", 1, 0x200000000L, 1));
        enumeration = vector8.elements();
        while (enumeration.hasMoreElements()) {
            ammoType = (AmmoType)enumeration.nextElement();
            enumeration2 = vector11.elements();
            while (enumeration2.hasMoreElements()) {
                munitionMutator = (MunitionMutator)enumeration2.nextElement();
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
        vector11.addElement(new MunitionMutator("Copperhead", 1, 0x20000000L, 5));
        vector11.addElement(new MunitionMutator("Illumination", 1, 8192L, 5));
        enumeration = vector9.elements();
        while (enumeration.hasMoreElements()) {
            ammoType = (AmmoType)enumeration.nextElement();
            enumeration2 = vector11.elements();
            while (enumeration2.hasMoreElements()) {
                munitionMutator = (MunitionMutator)enumeration2.nextElement();
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
        vector11.removeAllElements();
        vector11.addElement(new MunitionMutator("(Clan) Smoke", 1, 0x200000000L, 2));
        enumeration = vector10.elements();
        while (enumeration.hasMoreElements()) {
            ammoType = (AmmoType)enumeration.nextElement();
            enumeration2 = vector11.elements();
            while (enumeration2.hasMoreElements()) {
                munitionMutator = (MunitionMutator)enumeration2.nextElement();
                EquipmentType.addType(munitionMutator.createMunitionType(ammoType));
            }
        }
        Enumeration enumeration3 = EquipmentType.getAllTypes();
        while (enumeration3.hasMoreElements()) {
            EquipmentType equipmentType = (EquipmentType)enumeration3.nextElement();
            if (!(equipmentType instanceof AmmoType)) continue;
            AmmoType ammoType2 = (AmmoType)equipmentType;
            int n = ammoType2.getAmmoType();
            if (m_vaMunitions[n] == null) {
                AmmoType.m_vaMunitions[n] = new Vector();
            }
            m_vaMunitions[n].addElement(ammoType2);
        }
    }

    public static AmmoType createISAC2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "AC/2 Ammo";
        ammoType.setInternalName("IS Ammo AC/2");
        ammoType.addLookupName("ISAC2 Ammo");
        ammoType.addLookupName("IS Autocannon/2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 1;
        ammoType.shots = 45;
        ammoType.bv = 5.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    public static AmmoType createISAC5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "AC/5 Ammo";
        ammoType.setInternalName("IS Ammo AC/5");
        ammoType.addLookupName("ISAC5 Ammo");
        ammoType.addLookupName("IS Autocannon/5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 1;
        ammoType.shots = 20;
        ammoType.bv = 9.0;
        ammoType.cost = 4500.0;
        return ammoType;
    }

    public static AmmoType createISAC10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "AC/10 Ammo";
        ammoType.setInternalName("IS Ammo AC/10");
        ammoType.addLookupName("ISAC10 Ammo");
        ammoType.addLookupName("IS Autocannon/10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 1;
        ammoType.shots = 10;
        ammoType.bv = 15.0;
        ammoType.cost = 6000.0;
        return ammoType;
    }

    public static AmmoType createISAC20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "AC/20 Ammo";
        ammoType.setInternalName("IS Ammo AC/20");
        ammoType.addLookupName("ISAC20 Ammo");
        ammoType.addLookupName("IS Autocannon/20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 1;
        ammoType.shots = 5;
        ammoType.bv = 20.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    public static AmmoType createISVehicleFlamerAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "Vehicle Flamer Ammo";
        ammoType.setInternalName("IS Vehicle Flamer Ammo");
        ammoType.addLookupName("IS Ammo Vehicle Flamer");
        ammoType.addLookupName("ISVehicleFlamer Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 2;
        ammoType.shots = 20;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    public static AmmoType createISMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "Machine Gun Ammo";
        ammoType.setInternalName("IS Ammo MG - Full");
        ammoType.addLookupName("ISMG Ammo (200)");
        ammoType.addLookupName("IS Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 1;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    public static AmmoType createISMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "Half Machine Gun Ammo";
        ammoType.setInternalName("IS Machine Gun Ammo - Half");
        ammoType.addLookupName("IS Ammo MG - Half");
        ammoType.addLookupName("ISMG Ammo (100)");
        ammoType.addLookupName("IS Machine Gun Ammo (1/2 ton)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 1;
        ammoType.shots = 100;
        ammoType.bv = 0.5;
        ammoType.tonnage = 0.5f;
        ammoType.cost = 500.0;
        return ammoType;
    }

    public static AmmoType createISLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRM 5 Ammo";
        ammoType.setInternalName("IS Ammo LRM-5");
        ammoType.addLookupName("ISLRM5 Ammo");
        ammoType.addLookupName("IS LRM 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.shots = 24;
        ammoType.bv = 6.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createISLRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRM 10 Ammo";
        ammoType.setInternalName("IS Ammo LRM-10");
        ammoType.addLookupName("ISLRM10 Ammo");
        ammoType.addLookupName("IS LRM 10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 7;
        ammoType.shots = 12;
        ammoType.bv = 11.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createISLRM15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRM 15 Ammo";
        ammoType.setInternalName("IS Ammo LRM-15");
        ammoType.addLookupName("ISLRM15 Ammo");
        ammoType.addLookupName("IS LRM 15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 7;
        ammoType.shots = 8;
        ammoType.bv = 17.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createISLRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRM 20 Ammo";
        ammoType.setInternalName("IS Ammo LRM-20");
        ammoType.addLookupName("ISLRM20 Ammo");
        ammoType.addLookupName("IS LRM 20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 7;
        ammoType.shots = 6;
        ammoType.bv = 23.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createISSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "SRM 2 Ammo";
        ammoType.setInternalName("IS Ammo SRM-2");
        ammoType.addLookupName("ISSRM2 Ammo");
        ammoType.addLookupName("IS SRM 2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.shots = 50;
        ammoType.bv = 3.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createISSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "SRM 4 Ammo";
        ammoType.setInternalName("IS Ammo SRM-4");
        ammoType.addLookupName("ISSRM4 Ammo");
        ammoType.addLookupName("IS SRM 4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 9;
        ammoType.shots = 25;
        ammoType.bv = 5.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createISSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "SRM 6 Ammo";
        ammoType.setInternalName("IS Ammo SRM-6");
        ammoType.addLookupName("ISSRM6 Ammo");
        ammoType.addLookupName("IS SRM 6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 9;
        ammoType.shots = 15;
        ammoType.bv = 7.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createISLRT5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRT 5 Ammo";
        ammoType.setInternalName("IS Ammo LRTorpedo-5");
        ammoType.addLookupName("ISLRTorpedo5 Ammo");
        ammoType.addLookupName("IS LRTorpedo 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 8;
        ammoType.shots = 24;
        ammoType.bv = 6.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createISLRT10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRT 10 Ammo";
        ammoType.setInternalName("IS Ammo LRTorpedo-10");
        ammoType.addLookupName("ISLRTorpedo10 Ammo");
        ammoType.addLookupName("IS LRTorpedo 10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 8;
        ammoType.shots = 12;
        ammoType.bv = 11.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createISLRT15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRT 15 Ammo";
        ammoType.setInternalName("IS Ammo LRTorpedo-15");
        ammoType.addLookupName("ISLRTorpedo15 Ammo");
        ammoType.addLookupName("IS LRv 15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 8;
        ammoType.shots = 8;
        ammoType.bv = 17.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createISLRT20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "LRT 20 Ammo";
        ammoType.setInternalName("IS Ammo LRTorpedo-20");
        ammoType.addLookupName("ISLRTorpedo20 Ammo");
        ammoType.addLookupName("IS LRTorpedo 20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 8;
        ammoType.shots = 6;
        ammoType.bv = 23.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createISSRT2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "SRT 2 Ammo";
        ammoType.setInternalName("IS Ammo SRTorpedo-2");
        ammoType.addLookupName("ISSRTorpedo2 Ammo");
        ammoType.addLookupName("IS SRTorpedo 2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 10;
        ammoType.shots = 50;
        ammoType.bv = 3.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createISSRT4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "SRT 4 Ammo";
        ammoType.setInternalName("IS Ammo SRTorpedo-4");
        ammoType.addLookupName("ISSRTorpedo4 Ammo");
        ammoType.addLookupName("IS SRTorpedo 4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 10;
        ammoType.shots = 25;
        ammoType.bv = 5.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createISSRT6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "SRT 6 Ammo";
        ammoType.setInternalName("IS Ammo SRTorpedo-6");
        ammoType.addLookupName("ISSRTorpedo6 Ammo");
        ammoType.addLookupName("IS SRTorpedo 6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 10;
        ammoType.shots = 15;
        ammoType.bv = 7.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createISLongTomAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Long Tom Ammo";
        ammoType.setInternalName("ISLongTomAmmo");
        ammoType.addLookupName("ISLongTom Ammo");
        ammoType.addLookupName("ISLongTomArtillery Ammo");
        ammoType.addLookupName("IS Ammo Long Tom");
        ammoType.addLookupName("IS Long Tom Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 16;
        ammoType.shots = 5;
        ammoType.bv = 11.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    public static AmmoType createISSniperAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Sniper Ammo";
        ammoType.setInternalName("ISSniperAmmo");
        ammoType.addLookupName("ISSniper Ammo");
        ammoType.addLookupName("ISSniperArtillery Ammo");
        ammoType.addLookupName("IS Ammo Sniper");
        ammoType.addLookupName("IS Sniper Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 17;
        ammoType.shots = 10;
        ammoType.bv = 5.0;
        ammoType.cost = 6000.0;
        return ammoType;
    }

    public static AmmoType createISThumperAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Thumper Ammo";
        ammoType.setInternalName("ISThumperAmmo");
        ammoType.addLookupName("ISThumper Ammo");
        ammoType.addLookupName("ISThumperArtillery Ammo");
        ammoType.addLookupName("IS Ammo Thumper");
        ammoType.addLookupName("IS Thumper Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 18;
        ammoType.shots = 20;
        ammoType.bv = 3.0;
        ammoType.cost = 4500.0;
        return ammoType;
    }

    public static AmmoType createISLB2XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 2-X AC Ammo";
        ammoType.setInternalName("IS LB 2-X AC Ammo");
        ammoType.addLookupName("IS Ammo 2-X");
        ammoType.addLookupName("ISLBXAC2 Ammo");
        ammoType.addLookupName("IS LB 2-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.shots = 45;
        ammoType.bv = 5.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    public static AmmoType createISLB5XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 5-X AC Ammo";
        ammoType.setInternalName("IS LB 5-X AC Ammo");
        ammoType.addLookupName("IS Ammo 5-X");
        ammoType.addLookupName("ISLBXAC5 Ammo");
        ammoType.addLookupName("IS LB 5-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.shots = 20;
        ammoType.bv = 10.0;
        ammoType.cost = 9000.0;
        return ammoType;
    }

    public static AmmoType createISLB10XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 10-X AC Ammo";
        ammoType.setInternalName("IS LB 10-X AC Ammo");
        ammoType.addLookupName("IS Ammo 10-X");
        ammoType.addLookupName("ISLBXAC10 Ammo");
        ammoType.addLookupName("IS LB 10-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        ammoType.cost = 12000.0;
        return ammoType;
    }

    public static AmmoType createISLB20XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 20-X AC Ammo";
        ammoType.setInternalName("IS LB 20-X AC Ammo");
        ammoType.addLookupName("IS Ammo 20-X");
        ammoType.addLookupName("ISLBXAC20 Ammo");
        ammoType.addLookupName("IS LB 20-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.shots = 5;
        ammoType.bv = 27.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createISLB2XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 2-X Cluster Ammo";
        ammoType.setInternalName("IS LB 2-X Cluster Ammo");
        ammoType.addLookupName("IS Ammo 2-X (CL)");
        ammoType.addLookupName("ISLBXAC2 CL Ammo");
        ammoType.addLookupName("IS LB 2-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 45;
        ammoType.bv = 5.0;
        ammoType.cost = 3300.0;
        return ammoType;
    }

    public static AmmoType createISLB5XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 5-X Cluster Ammo";
        ammoType.setInternalName("IS LB 5-X Cluster Ammo");
        ammoType.addLookupName("IS Ammo 5-X (CL)");
        ammoType.addLookupName("ISLBXAC5 CL Ammo");
        ammoType.addLookupName("IS LB 5-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 20;
        ammoType.bv = 10.0;
        ammoType.cost = 15000.0;
        return ammoType;
    }

    public static AmmoType createISLB10XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 10-X Cluster Ammo";
        ammoType.setInternalName("IS LB 10-X Cluster Ammo");
        ammoType.addLookupName("IS Ammo 10-X (CL)");
        ammoType.addLookupName("ISLBXAC10 CL Ammo");
        ammoType.addLookupName("IS LB 10-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createISLB20XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LB 20-X Cluster Ammo";
        ammoType.setInternalName("IS LB 20-X Cluster Ammo");
        ammoType.addLookupName("IS Ammo 20-X (CL)");
        ammoType.addLookupName("ISLBXAC20 CL Ammo");
        ammoType.addLookupName("IS LB 20-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 5;
        ammoType.bv = 27.0;
        ammoType.cost = 34000.0;
        return ammoType;
    }

    public static AmmoType createISTHBLB2XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LB 2-X AC Ammo (THB)";
        ammoType.setInternalName("IS LB 2-X AC Ammo (THB)");
        ammoType.addLookupName("IS Ammo 2-X (THB)");
        ammoType.addLookupName("ISLBXAC2 Ammo (THB)");
        ammoType.addLookupName("IS LB 2-X AC Ammo - Slug (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 33;
        ammoType.shots = 40;
        ammoType.bv = 5.0;
        ammoType.cost = 3000.0;
        return ammoType;
    }

    public static AmmoType createISTHBLB5XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LB 5-X AC Ammo (THB)";
        ammoType.setInternalName("IS LB 5-X AC Ammo (THB)");
        ammoType.addLookupName("IS Ammo 5-X (THB)");
        ammoType.addLookupName("ISLBXAC5 Ammo (THB)");
        ammoType.addLookupName("IS LB 5-X AC Ammo - Slug (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 33;
        ammoType.shots = 16;
        ammoType.bv = 11.0;
        ammoType.cost = 15000.0;
        return ammoType;
    }

    public static AmmoType createISTHBLB20XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LB 20-X AC Ammo (THB)";
        ammoType.setInternalName("IS LB 20-X AC Ammo (THB)");
        ammoType.addLookupName("IS Ammo 20-X (THB)");
        ammoType.addLookupName("ISLBXAC20 Ammo (THB)");
        ammoType.addLookupName("IS LB 20-X AC Ammo - Slug (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 33;
        ammoType.shots = 4;
        ammoType.bv = 26.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createISTHBLB2XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LB 2-X Cluster Ammo (THB)";
        ammoType.setInternalName("IS LB 2-X Cluster Ammo (THB)");
        ammoType.addLookupName("IS Ammo 2-X (CL) (THB)");
        ammoType.addLookupName("ISLBXAC2 CL Ammo (THB)");
        ammoType.addLookupName("IS LB 2-X AC Ammo - Cluster (THB)");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 33;
        ammoType.munitionType = 1L;
        ammoType.shots = 40;
        ammoType.bv = 5.0;
        ammoType.cost = 4950.0;
        return ammoType;
    }

    public static AmmoType createISTHBLB5XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LB 5-X Cluster Ammo (THB)";
        ammoType.setInternalName("IS LB 5-X Cluster Ammo (THB)");
        ammoType.addLookupName("IS Ammo 5-X (CL) (THB)");
        ammoType.addLookupName("ISLBXAC5 CL Ammo (THB)");
        ammoType.addLookupName("IS LB 5-X AC Ammo - Cluster (THB)");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 33;
        ammoType.munitionType = 1L;
        ammoType.shots = 16;
        ammoType.bv = 11.0;
        ammoType.cost = 25000.0;
        return ammoType;
    }

    public static AmmoType createISTHBLB20XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LB 20-X Cluster Ammo (THB)";
        ammoType.setInternalName("IS LB 20-X Cluster Ammo (THB)");
        ammoType.addLookupName("IS Ammo 20-X (CL) (THB)");
        ammoType.addLookupName("ISLBXAC20 CL Ammo (THB)");
        ammoType.addLookupName("IS LB 20-X AC Ammo - Cluster (THB)");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 33;
        ammoType.munitionType = 1L;
        ammoType.shots = 4;
        ammoType.bv = 26.0;
        ammoType.cost = 51000.0;
        return ammoType;
    }

    public static AmmoType createISUltra2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Ultra AC/2 Ammo";
        ammoType.setInternalName("IS Ultra AC/2 Ammo");
        ammoType.addLookupName("IS Ammo Ultra AC/2");
        ammoType.addLookupName("ISUltraAC2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 20;
        ammoType.shots = 45;
        ammoType.bv = 7.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    public static AmmoType createISUltra5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Ultra AC/5 Ammo";
        ammoType.setInternalName("IS Ultra AC/5 Ammo");
        ammoType.addLookupName("IS Ammo Ultra AC/5");
        ammoType.addLookupName("ISUltraAC5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 20;
        ammoType.shots = 20;
        ammoType.bv = 14.0;
        ammoType.cost = 9000.0;
        return ammoType;
    }

    public static AmmoType createISUltra10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Ultra AC/10 Ammo";
        ammoType.setInternalName("IS Ultra AC/10 Ammo");
        ammoType.addLookupName("IS Ammo Ultra AC/10");
        ammoType.addLookupName("ISUltraAC10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 20;
        ammoType.shots = 10;
        ammoType.bv = 29.0;
        ammoType.cost = 12000.0;
        return ammoType;
    }

    public static AmmoType createISUltra20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Ultra AC/20 Ammo";
        ammoType.setInternalName("IS Ultra AC/20 Ammo");
        ammoType.addLookupName("IS Ammo Ultra AC/20");
        ammoType.addLookupName("ISUltraAC20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 20;
        ammoType.shots = 5;
        ammoType.bv = 32.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createISTHBUltra2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Ultra AC/2 Ammo (THB)";
        ammoType.setInternalName("IS Ultra AC/2 Ammo (THB)");
        ammoType.addLookupName("IS Ammo Ultra AC/2 (THB)");
        ammoType.addLookupName("ISUltraAC2 Ammo (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 34;
        ammoType.shots = 45;
        ammoType.bv = 8.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    public static AmmoType createISTHBUltra10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Ultra AC/10 Ammo (THB)";
        ammoType.setInternalName("IS Ultra AC/10 Ammo (THB)");
        ammoType.addLookupName("IS Ammo Ultra AC/10 (THB)");
        ammoType.addLookupName("ISUltraAC10 Ammo (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 34;
        ammoType.shots = 10;
        ammoType.bv = 31.0;
        ammoType.cost = 15000.0;
        return ammoType;
    }

    public static AmmoType createISTHBUltra20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Ultra AC/20 Ammo (THB)";
        ammoType.setInternalName("IS Ultra AC/20 Ammo (THB)");
        ammoType.addLookupName("IS Ammo Ultra AC/20 (THB)");
        ammoType.addLookupName("ISUltraAC20 Ammo (THB)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 34;
        ammoType.shots = 5;
        ammoType.bv = 42.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createISRotary2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Rotary AC/2 Ammo";
        ammoType.setInternalName("ISRotaryAC2 Ammo");
        ammoType.addLookupName("IS Rotary AC/2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 23;
        ammoType.shots = 45;
        ammoType.bv = 15.0;
        ammoType.cost = 3000.0;
        return ammoType;
    }

    public static AmmoType createISRotary5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Rotary AC/5 Ammo";
        ammoType.setInternalName("ISRotaryAC5 Ammo");
        ammoType.addLookupName("IS Rotary AC/5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 23;
        ammoType.shots = 20;
        ammoType.bv = 31.0;
        ammoType.cost = 12000.0;
        return ammoType;
    }

    public static AmmoType createISGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Gauss Ammo";
        ammoType.setInternalName("IS Gauss Ammo");
        ammoType.addLookupName("IS Ammo Gauss");
        ammoType.addLookupName("ISGauss Ammo");
        ammoType.addLookupName("IS Gauss Rifle Ammo");
        ammoType.damagePerShot = 15;
        ammoType.explosive = false;
        ammoType.ammoType = 6;
        ammoType.shots = 8;
        ammoType.bv = 37.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createISLTGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Light Gauss Ammo";
        ammoType.setInternalName("IS Light Gauss Ammo");
        ammoType.addLookupName("ISLightGauss Ammo");
        ammoType.addLookupName("IS Light Gauss Rifle Ammo");
        ammoType.damagePerShot = 8;
        ammoType.explosive = false;
        ammoType.ammoType = 21;
        ammoType.shots = 16;
        ammoType.bv = 20.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createISHVGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Heavy Gauss Ammo";
        ammoType.setInternalName("ISHeavyGauss Ammo");
        ammoType.addLookupName("IS Heavy Gauss Rifle Ammo");
        ammoType.damagePerShot = 25;
        ammoType.explosive = false;
        ammoType.ammoType = 22;
        ammoType.shots = 4;
        ammoType.bv = 43.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createISStreakSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Streak SRM 2 Ammo";
        ammoType.setInternalName("IS Streak SRM 2 Ammo");
        ammoType.addLookupName("IS Ammo Streak-2");
        ammoType.addLookupName("ISStreakSRM2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 11;
        ammoType.shots = 50;
        ammoType.bv = 4.0;
        ammoType.cost = 54000.0;
        return ammoType;
    }

    public static AmmoType createISStreakSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Streak SRM 4 Ammo";
        ammoType.setInternalName("IS Streak SRM 4 Ammo");
        ammoType.addLookupName("IS Ammo Streak-4");
        ammoType.addLookupName("ISStreakSRM4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 11;
        ammoType.shots = 25;
        ammoType.bv = 7.0;
        ammoType.cost = 54000.0;
        return ammoType;
    }

    public static AmmoType createISStreakSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Streak SRM 6 Ammo";
        ammoType.setInternalName("IS Streak SRM 6 Ammo");
        ammoType.addLookupName("IS Ammo Streak-6");
        ammoType.addLookupName("ISStreakSRM6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 11;
        ammoType.shots = 15;
        ammoType.bv = 11.0;
        ammoType.cost = 54000.0;
        return ammoType;
    }

    public static AmmoType createISMRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 10 Ammo";
        ammoType.setInternalName("IS MRM 10 Ammo");
        ammoType.addLookupName("ISMRM10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 12;
        ammoType.shots = 24;
        ammoType.bv = 7.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    public static AmmoType createISMRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 20 Ammo";
        ammoType.setInternalName("IS MRM 20 Ammo");
        ammoType.addLookupName("ISMRM20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 12;
        ammoType.shots = 12;
        ammoType.bv = 14.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    public static AmmoType createISMRM30Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 30 Ammo";
        ammoType.setInternalName("IS MRM 30 Ammo");
        ammoType.addLookupName("ISMRM30 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 30;
        ammoType.ammoType = 12;
        ammoType.shots = 8;
        ammoType.bv = 21.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    public static AmmoType createISMRM40Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 40 Ammo";
        ammoType.setInternalName("IS MRM 40 Ammo");
        ammoType.addLookupName("ISMRM40 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 40;
        ammoType.ammoType = 12;
        ammoType.shots = 6;
        ammoType.bv = 28.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    public static AmmoType createISRL10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 10 Ammo";
        ammoType.setInternalName("IS Ammo RL-10");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 30;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    public static AmmoType createISRL15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 15 Ammo";
        ammoType.setInternalName("IS Ammo RL-15");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 30;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 1500.0;
        return ammoType;
    }

    public static AmmoType createISRL20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "RL 20 Ammo";
        ammoType.setInternalName("IS Ammo RL-20");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 30;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    public static AmmoType createISAMSAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "AMS Ammo";
        ammoType.setInternalName("ISAMS Ammo");
        ammoType.addLookupName("IS Ammo AMS");
        ammoType.addLookupName("IS AMS Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 14;
        ammoType.shots = 12;
        ammoType.bv = 11.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    public static AmmoType createISNarcAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Narc Pods";
        ammoType.setInternalName("ISNarc Pods");
        ammoType.addLookupName("IS Ammo Narc");
        ammoType.addLookupName("IS Narc Missile Beacon Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 13;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        ammoType.cost = 6000.0;
        return ammoType;
    }

    public static AmmoType createISNarcExplosiveAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Narc Explosive Pods";
        ammoType.setInternalName("ISNarc ExplosivePods");
        ammoType.damagePerShot = 4;
        ammoType.rackSize = 1;
        ammoType.ammoType = 13;
        ammoType.munitionType = 0x10000000L;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        ammoType.cost = 1500.0;
        return ammoType;
    }

    public static AmmoType createISiNarcAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "iNarc Pods";
        ammoType.setInternalName("ISiNarc Pods");
        ammoType.addLookupName("IS Ammo iNarc");
        ammoType.addLookupName("IS iNarc Missile Beacon Ammo");
        ammoType.addLookupName("iNarc Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 1;
        ammoType.ammoType = 31;
        ammoType.shots = 4;
        ammoType.bv = 0.0;
        ammoType.cost = 7500.0;
        return ammoType;
    }

    public static AmmoType createISiNarcExplosiveAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "iNarc Explosive Pods";
        ammoType.setInternalName("ISiNarc Explosive Pods");
        ammoType.addLookupName("iNarc Explosive Ammo");
        ammoType.damagePerShot = 6;
        ammoType.rackSize = 1;
        ammoType.ammoType = 31;
        ammoType.munitionType = 0x1000000L;
        ammoType.shots = 4;
        ammoType.bv = 0.0;
        ammoType.cost = 1500.0;
        return ammoType;
    }

    public static AmmoType createISiNarcECMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "iNarc ECM Pods";
        ammoType.setInternalName("ISiNarc ECM Pods");
        ammoType.addLookupName("iNarc ECM Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 1;
        ammoType.ammoType = 31;
        ammoType.munitionType = 0x2000000L;
        ammoType.shots = 4;
        ammoType.bv = 0.0;
        ammoType.cost = 15000.0;
        return ammoType;
    }

    public static AmmoType createISiNarcHaywireAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "iNarc Haywire Pods";
        ammoType.setInternalName("ISiNarc Haywire Pods");
        ammoType.addLookupName("iNarc Haywire Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 1;
        ammoType.ammoType = 31;
        ammoType.munitionType = 0x4000000L;
        ammoType.shots = 4;
        ammoType.bv = 0.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createISiNarcNemesisAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "iNarc Nemesis Pods";
        ammoType.setInternalName("ISiNarc Nemesis Pods");
        ammoType.addLookupName("iNarc Nemesis Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 1;
        ammoType.ammoType = 31;
        ammoType.munitionType = 0x8000000L;
        ammoType.shots = 4;
        ammoType.bv = 0.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    public static AmmoType createCLGaussAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Gauss Ammo";
        ammoType.setInternalName("Clan Gauss Ammo");
        ammoType.addLookupName("Clan Ammo Gauss");
        ammoType.addLookupName("CLGauss Ammo");
        ammoType.addLookupName("Clan Gauss Rifle Ammo");
        ammoType.damagePerShot = 15;
        ammoType.explosive = false;
        ammoType.ammoType = 6;
        ammoType.shots = 8;
        ammoType.bv = 33.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createCLLB2XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 2-X AC Ammo";
        ammoType.setInternalName("Clan LB 2-X AC Ammo");
        ammoType.addLookupName("Clan Ammo 2-X");
        ammoType.addLookupName("CLLBXAC2 Ammo");
        ammoType.addLookupName("Clan LB 2-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.shots = 45;
        ammoType.bv = 6.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    public static AmmoType createCLLB5XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 5-X AC Ammo";
        ammoType.setInternalName("Clan LB 5-X AC Ammo");
        ammoType.addLookupName("Clan Ammo 5-X");
        ammoType.addLookupName("CLLBXAC5 Ammo");
        ammoType.addLookupName("Clan LB 5-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.shots = 20;
        ammoType.bv = 12.0;
        ammoType.cost = 9000.0;
        return ammoType;
    }

    public static AmmoType createCLLB10XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 10-X AC Ammo";
        ammoType.setInternalName("Clan LB 10-X AC Ammo");
        ammoType.addLookupName("Clan Ammo 10-X");
        ammoType.addLookupName("CLLBXAC10 Ammo");
        ammoType.addLookupName("Clan LB 10-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        ammoType.cost = 12000.0;
        return ammoType;
    }

    public static AmmoType createCLLB20XAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 20-X AC Ammo";
        ammoType.setInternalName("Clan LB 20-X AC Ammo");
        ammoType.addLookupName("Clan Ammo 20-X");
        ammoType.addLookupName("CLLBXAC20 Ammo");
        ammoType.addLookupName("Clan LB 20-X AC Ammo - Slug");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.shots = 5;
        ammoType.bv = 33.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createCLLB2XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 2-X Cluster Ammo";
        ammoType.setInternalName("Clan LB 2-X Cluster Ammo");
        ammoType.addLookupName("Clan Ammo 2-X (CL)");
        ammoType.addLookupName("CLLBXAC2 CL Ammo");
        ammoType.addLookupName("Clan LB 2-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 45;
        ammoType.bv = 6.0;
        ammoType.cost = 3300.0;
        return ammoType;
    }

    public static AmmoType createCLLB5XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 5-X Cluster Ammo";
        ammoType.setInternalName("Clan LB 5-X Cluster Ammo");
        ammoType.addLookupName("Clan Ammo 5-X (CL)");
        ammoType.addLookupName("CLLBXAC5 CL Ammo");
        ammoType.addLookupName("Clan LB 5-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 20;
        ammoType.bv = 12.0;
        ammoType.cost = 15000.0;
        return ammoType;
    }

    public static AmmoType createCLLB10XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 10-X Cluster Ammo";
        ammoType.setInternalName("Clan LB 10-X Cluster Ammo");
        ammoType.addLookupName("Clan Ammo 10-X (CL)");
        ammoType.addLookupName("CLLBXAC10 CL Ammo");
        ammoType.addLookupName("Clan LB 10-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 10;
        ammoType.bv = 19.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createCLLB20XClusterAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LB 20-X Cluster Ammo";
        ammoType.setInternalName("Clan LB 20-X Cluster Ammo");
        ammoType.addLookupName("Clan Ammo 20-X (CL)");
        ammoType.addLookupName("CLLBXAC20 CL Ammo");
        ammoType.addLookupName("Clan LB 20-X AC Ammo - Cluster");
        ammoType.damagePerShot = 1;
        ammoType.toHitModifier = -1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 19;
        ammoType.munitionType = 1L;
        ammoType.shots = 5;
        ammoType.bv = 33.0;
        ammoType.cost = 34000.0;
        return ammoType;
    }

    public static AmmoType createCLVehicleFlamerAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Vehicle Flamer Ammo";
        ammoType.setInternalName("Clan Vehicle Flamer Ammo");
        ammoType.addLookupName("Clan Ammo Vehicle Flamer");
        ammoType.addLookupName("CLVehicleFlamer Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 2;
        ammoType.shots = 20;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    public static AmmoType createCLHeavyMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Heavy Machine Gun Ammo";
        ammoType.setInternalName("Clan Heavy Machine Gun Ammo - Full");
        ammoType.addLookupName("CLHeavyMG Ammo (100)");
        ammoType.addLookupName("Clan Heavy Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 4;
        ammoType.flags |= 1;
        ammoType.shots = 100;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    public static AmmoType createCLHeavyMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Half Heavy Machine Gun Ammo";
        ammoType.setInternalName("Clan Heavy Machine Gun Ammo - Half");
        ammoType.addLookupName("CLHeavyMG Ammo (50)");
        ammoType.addLookupName("Clan Heavy Machine Gun Ammo (1/2 ton)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 4;
        ammoType.flags |= 1;
        ammoType.shots = 50;
        ammoType.tonnage = 0.5f;
        ammoType.bv = 1.0;
        ammoType.cost = 500.0;
        return ammoType;
    }

    public static AmmoType createCLMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Machine Gun Ammo";
        ammoType.setInternalName("Clan Machine Gun Ammo - Full");
        ammoType.addLookupName("Clan Ammo MG - Full");
        ammoType.addLookupName("CLMG Ammo (200)");
        ammoType.addLookupName("Clan Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 1;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    public static AmmoType createCLMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Half Machine Gun Ammo";
        ammoType.setInternalName("Clan Machine Gun Ammo - Half");
        ammoType.addLookupName("Clan Ammo MG - Half");
        ammoType.addLookupName("CLMG Ammo (100)");
        ammoType.addLookupName("Clan Machine Gun Ammo (1/2 ton)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 1;
        ammoType.shots = 100;
        ammoType.tonnage = 0.5f;
        ammoType.bv = 1.0;
        ammoType.cost = 500.0;
        return ammoType;
    }

    public static AmmoType createCLLightMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Light Machine Gun Ammo";
        ammoType.setInternalName("Clan Light Machine Gun Ammo - Full");
        ammoType.addLookupName("CLLightMG Ammo (200)");
        ammoType.addLookupName("Clan Light Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 5;
        ammoType.flags |= 1;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        ammoType.cost = 500.0;
        return ammoType;
    }

    public static AmmoType createCLLightMGAmmoHalf() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Half Light Machine Gun Ammo";
        ammoType.setInternalName("Clan Light Machine Gun Ammo - Half");
        ammoType.addLookupName("CLLightMG Ammo (100)");
        ammoType.addLookupName("Clan Light Machine Gun Ammo (1/2 ton)");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 5;
        ammoType.flags |= 1;
        ammoType.shots = 100;
        ammoType.tonnage = 0.5f;
        ammoType.bv = 1.0;
        ammoType.cost = 250.0;
        return ammoType;
    }

    public static AmmoType createCLUltra2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Ultra AC/2 Ammo";
        ammoType.setInternalName("Clan Ultra AC/2 Ammo");
        ammoType.addLookupName("Clan Ammo Ultra AC/2");
        ammoType.addLookupName("CLUltraAC2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 20;
        ammoType.shots = 45;
        ammoType.bv = 6.0;
        ammoType.cost = 1000.0;
        return ammoType;
    }

    public static AmmoType createCLUltra5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Ultra AC/5 Ammo";
        ammoType.setInternalName("Clan Ultra AC/5 Ammo");
        ammoType.addLookupName("Clan Ammo Ultra AC/5");
        ammoType.addLookupName("CLUltraAC5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 20;
        ammoType.shots = 20;
        ammoType.bv = 15.0;
        ammoType.cost = 9000.0;
        return ammoType;
    }

    public static AmmoType createCLUltra10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Ultra AC/10 Ammo";
        ammoType.setInternalName("Clan Ultra AC/10 Ammo");
        ammoType.addLookupName("Clan Ammo Ultra AC/10");
        ammoType.addLookupName("CLUltraAC10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 20;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        ammoType.cost = 12000.0;
        return ammoType;
    }

    public static AmmoType createCLUltra20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Ultra AC/20 Ammo";
        ammoType.setInternalName("Clan Ultra AC/20 Ammo");
        ammoType.addLookupName("Clan Ammo Ultra AC/20");
        ammoType.addLookupName("CLUltraAC20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 20;
        ammoType.shots = 5;
        ammoType.bv = 35.0;
        ammoType.cost = 20000.0;
        return ammoType;
    }

    public static AmmoType createCLRotary2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Rotary AC/2 Ammo";
        ammoType.setInternalName("CLRotaryAC2 Ammo");
        ammoType.addLookupName("CL Rotary AC/2 Ammo");
        ammoType.addLookupName("Rotary Assault Cannon/2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 23;
        ammoType.shots = 45;
        ammoType.bv = 22.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    public static AmmoType createCLRotary5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Rotary AC/5 Ammo";
        ammoType.setInternalName("CLRotaryAC5 Ammo");
        ammoType.addLookupName("CL Rotary AC/5 Ammo");
        ammoType.addLookupName("Rotary Assault Cannon/5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 23;
        ammoType.shots = 20;
        ammoType.bv = 43.0;
        ammoType.cost = 13000.0;
        return ammoType;
    }

    public static AmmoType createCLRotary10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Rotary AC/10 Ammo";
        ammoType.setInternalName("CLRotaryAC10 Ammo");
        ammoType.addLookupName("CL Rotary AC/10 Ammo");
        ammoType.addLookupName("Rotary Assault Cannon/10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 23;
        ammoType.shots = 10;
        ammoType.bv = 74.0;
        ammoType.cost = 16000.0;
        return ammoType;
    }

    public static AmmoType createCLRotary20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Rotary AC/20 Ammo";
        ammoType.setInternalName("CLRotaryAC20 Ammo");
        ammoType.addLookupName("CL Rotary AC/20 Ammo");
        ammoType.addLookupName("Rotary Assault Cannon/20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 23;
        ammoType.shots = 5;
        ammoType.bv = 118.0;
        ammoType.cost = 24000.0;
        return ammoType;
    }

    public static AmmoType createCLLRT1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 1 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-1");
        ammoType.addLookupName("Clan Ammo LRTorpedo-1");
        ammoType.addLookupName("CLLRTorpedo1 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 1 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 2.0;
        return ammoType;
    }

    public static AmmoType createCLLRT2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 2 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-2");
        ammoType.addLookupName("Clan Ammo LRTorpedo-2");
        ammoType.addLookupName("CLLRTorpedo2 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 3.0;
        return ammoType;
    }

    public static AmmoType createCLLRT3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 3 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-3");
        ammoType.addLookupName("Clan Ammo LRTorpedo-3");
        ammoType.addLookupName("CLLRTorpedo3 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 3 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 5.0;
        return ammoType;
    }

    public static AmmoType createCLLRT4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 4 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-4");
        ammoType.addLookupName("Clan Ammo LRTorpedo-4");
        ammoType.addLookupName("CLLRTorpedo4 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 4 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 6.0;
        return ammoType;
    }

    public static AmmoType createCLLRT5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 5 Ammo";
        ammoType.setInternalName("Clan Ammo LRTorpedo-5");
        ammoType.addLookupName("CLLRTorpedo5 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.shots = 24;
        ammoType.bv = 7.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createCLLRT6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 6 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-6");
        ammoType.addLookupName("Clan Ammo LRTorpedo-6");
        ammoType.addLookupName("CLLRTorpedo6 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 6 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 6;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 9.0;
        return ammoType;
    }

    public static AmmoType createCLLRT7Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 7 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-7");
        ammoType.addLookupName("Clan Ammo LRTorpedo-7");
        ammoType.addLookupName("CLLRTorpedo7 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 7 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 7;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 12.0;
        return ammoType;
    }

    public static AmmoType createCLLRT8Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 8 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-8");
        ammoType.addLookupName("Clan Ammo LRTorpedo-8");
        ammoType.addLookupName("CLLRTorpedo8 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 8 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 8;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 12.0;
        return ammoType;
    }

    public static AmmoType createCLLRT9Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 9 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-9");
        ammoType.addLookupName("Clan Ammo LRTorpedo-9");
        ammoType.addLookupName("CLLRTorpedo9 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 9 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 9;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 12.0;
        return ammoType;
    }

    public static AmmoType createCLLRT10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 10 Ammo";
        ammoType.setInternalName("Clan Ammo LRTorpedo-10");
        ammoType.addLookupName("CLLRTorpedo10 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 8;
        ammoType.shots = 12;
        ammoType.bv = 14.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createCLLRT11Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 11 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-11");
        ammoType.addLookupName("Clan Ammo LRTorpedo-11");
        ammoType.addLookupName("CLLRTorpedo11 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 11 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 11;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 18.0;
        return ammoType;
    }

    public static AmmoType createCLLRT12Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 12 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-12");
        ammoType.addLookupName("Clan Ammo LRTorpedo-12");
        ammoType.addLookupName("CLLRTorpedo12 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 12 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 12;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 18.0;
        return ammoType;
    }

    public static AmmoType createCLLRT13Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 13 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-13");
        ammoType.addLookupName("Clan Ammo LRTorpedo-13");
        ammoType.addLookupName("CLLRTorpedo13 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 13 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 13;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 20.0;
        return ammoType;
    }

    public static AmmoType createCLLRT14Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 14 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-14");
        ammoType.addLookupName("Clan Ammo LRTorpedo-14");
        ammoType.addLookupName("CLLRTorpedo14 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 14 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 14;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 21.0;
        return ammoType;
    }

    public static AmmoType createCLLRT15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 15 Ammo";
        ammoType.setInternalName("Clan Ammo LRTorpedo-15");
        ammoType.addLookupName("CLLRTorpedo15 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 8;
        ammoType.shots = 8;
        ammoType.bv = 21.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createCLLRT16Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 16 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-16");
        ammoType.addLookupName("Clan Ammo LRTorpedo-16");
        ammoType.addLookupName("CLLRTorpedo16 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 16 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 16;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        return ammoType;
    }

    public static AmmoType createCLLRT17Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 17 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-17");
        ammoType.addLookupName("Clan Ammo LRTorpedo-17");
        ammoType.addLookupName("CLLRTorpedo17 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 17 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 17;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        return ammoType;
    }

    public static AmmoType createCLLRT18Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 18 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-18");
        ammoType.addLookupName("Clan Ammo LRTorpedo-18");
        ammoType.addLookupName("CLLRTorpedo18 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 18 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 18;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        return ammoType;
    }

    public static AmmoType createCLLRT19Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 19 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRTorpedo-19");
        ammoType.addLookupName("Clan Ammo LRTorpedo-19");
        ammoType.addLookupName("CLLRTorpedo19 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 19 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 19;
        ammoType.ammoType = 8;
        ammoType.shots = 100;
        ammoType.bv = 28.0;
        return ammoType;
    }

    public static AmmoType createCLLRT20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRT 20 Ammo";
        ammoType.setInternalName("Clan Ammo LRTorpedo-20");
        ammoType.addLookupName("CLLRTorpedo20 Ammo");
        ammoType.addLookupName("Clan LRTorpedo 20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 8;
        ammoType.shots = 6;
        ammoType.bv = 27.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createCLSRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 1 Ammo";
        ammoType.setInternalName("Clan Ammo SRM-1");
        ammoType.addLookupName("CLSRM1 Ammo");
        ammoType.addLookupName("Clan SRM 1 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 9;
        ammoType.shots = 100;
        ammoType.bv = 2.0;
        return ammoType;
    }

    public static AmmoType createCLSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 2 Ammo";
        ammoType.setInternalName("Clan Ammo SRM-2");
        ammoType.addLookupName("CLSRM2 Ammo");
        ammoType.addLookupName("Clan SRM 2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.shots = 50;
        ammoType.bv = 3.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createCLSRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 3 Ammo";
        ammoType.setInternalName("Clan Ammo SRM-3");
        ammoType.addLookupName("CLSRM3 Ammo");
        ammoType.addLookupName("Clan SRM 3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 9;
        ammoType.shots = 100;
        ammoType.bv = 4.0;
        return ammoType;
    }

    public static AmmoType createCLSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 4 Ammo";
        ammoType.setInternalName("Clan Ammo SRM-4");
        ammoType.addLookupName("CLSRM4 Ammo");
        ammoType.addLookupName("Clan SRM 4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 9;
        ammoType.shots = 25;
        ammoType.bv = 5.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createCLSRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 5 Ammo";
        ammoType.setInternalName("Clan Ammo SRM-5");
        ammoType.addLookupName("CLSRM5 Ammo");
        ammoType.addLookupName("Clan SRM 5 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 9;
        ammoType.shots = 100;
        ammoType.bv = 5.0;
        return ammoType;
    }

    public static AmmoType createCLSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRM 6 Ammo";
        ammoType.setInternalName("Clan Ammo SRM-6");
        ammoType.addLookupName("CLSRM6 Ammo");
        ammoType.addLookupName("Clan SRM 6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 9;
        ammoType.shots = 15;
        ammoType.bv = 7.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createCLLRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 1 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-1");
        ammoType.addLookupName("Clan Ammo LRM-1");
        ammoType.addLookupName("CLLRM1 Ammo");
        ammoType.addLookupName("Clan LRM 1 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 2.0;
        return ammoType;
    }

    public static AmmoType createCLLRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 2 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-2");
        ammoType.addLookupName("Clan Ammo LRM-2");
        ammoType.addLookupName("CLLRM2 Ammo");
        ammoType.addLookupName("Clan LRM 2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 3.0;
        return ammoType;
    }

    public static AmmoType createCLLRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 3 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-3");
        ammoType.addLookupName("Clan Ammo LRM-3");
        ammoType.addLookupName("CLLRM3 Ammo");
        ammoType.addLookupName("Clan LRM 3 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 5.0;
        return ammoType;
    }

    public static AmmoType createCLLRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 4 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-4");
        ammoType.addLookupName("Clan Ammo LRM-4");
        ammoType.addLookupName("CLLRM4 Ammo");
        ammoType.addLookupName("Clan LRM 4 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 6.0;
        return ammoType;
    }

    public static AmmoType createCLLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 5 Ammo";
        ammoType.setInternalName("Clan Ammo LRM-5");
        ammoType.addLookupName("CLLRM5 Ammo");
        ammoType.addLookupName("Clan LRM 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.shots = 24;
        ammoType.bv = 7.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createCLLRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 6 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-6");
        ammoType.addLookupName("Clan Ammo LRM-6");
        ammoType.addLookupName("CLLRM6 Ammo");
        ammoType.addLookupName("Clan LRM 6 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 6;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 9.0;
        return ammoType;
    }

    public static AmmoType createCLLRM7Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 7 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-7");
        ammoType.addLookupName("Clan Ammo LRM-7");
        ammoType.addLookupName("CLLRM7 Ammo");
        ammoType.addLookupName("Clan LRM 7 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 7;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 12.0;
        return ammoType;
    }

    public static AmmoType createCLLRM8Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 8 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-8");
        ammoType.addLookupName("Clan Ammo LRM-8");
        ammoType.addLookupName("CLLRM8 Ammo");
        ammoType.addLookupName("Clan LRM 8 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 8;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 12.0;
        return ammoType;
    }

    public static AmmoType createCLLRM9Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 9 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-9");
        ammoType.addLookupName("Clan Ammo LRM-9");
        ammoType.addLookupName("CLLRM9 Ammo");
        ammoType.addLookupName("Clan LRM 9 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 9;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 12.0;
        return ammoType;
    }

    public static AmmoType createCLLRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 10 Ammo";
        ammoType.setInternalName("Clan Ammo LRM-10");
        ammoType.addLookupName("CLLRM10 Ammo");
        ammoType.addLookupName("Clan LRM 10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 7;
        ammoType.shots = 12;
        ammoType.bv = 14.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createCLLRM11Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 11 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-11");
        ammoType.addLookupName("Clan Ammo LRM-11");
        ammoType.addLookupName("CLLRM11 Ammo");
        ammoType.addLookupName("Clan LRM 11 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 11;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 18.0;
        return ammoType;
    }

    public static AmmoType createCLLRM12Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 12 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-12");
        ammoType.addLookupName("Clan Ammo LRM-12");
        ammoType.addLookupName("CLLRM12 Ammo");
        ammoType.addLookupName("Clan LRM 12 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 12;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 18.0;
        return ammoType;
    }

    public static AmmoType createCLLRM13Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 13 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-13");
        ammoType.addLookupName("Clan Ammo LRM-13");
        ammoType.addLookupName("CLLRM13 Ammo");
        ammoType.addLookupName("Clan LRM 13 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 13;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 20.0;
        return ammoType;
    }

    public static AmmoType createCLLRM14Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 14 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-14");
        ammoType.addLookupName("Clan Ammo LRM-14");
        ammoType.addLookupName("CLLRM14 Ammo");
        ammoType.addLookupName("Clan LRM 14 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 14;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 21.0;
        return ammoType;
    }

    public static AmmoType createCLLRM15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 15 Ammo";
        ammoType.setInternalName("Clan Ammo LRM-15");
        ammoType.addLookupName("CLLRM15 Ammo");
        ammoType.addLookupName("Clan LRM 15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 7;
        ammoType.shots = 8;
        ammoType.bv = 21.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createCLLRM16Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 16 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-16");
        ammoType.addLookupName("Clan Ammo LRM-16");
        ammoType.addLookupName("CLLRM16 Ammo");
        ammoType.addLookupName("Clan LRM 16 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 16;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        return ammoType;
    }

    public static AmmoType createCLLRM17Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 17 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-17");
        ammoType.addLookupName("Clan Ammo LRM-17");
        ammoType.addLookupName("CLLRM17 Ammo");
        ammoType.addLookupName("Clan LRM 17 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 17;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        return ammoType;
    }

    public static AmmoType createCLLRM18Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 18 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-18");
        ammoType.addLookupName("Clan Ammo LRM-18");
        ammoType.addLookupName("CLLRM18 Ammo");
        ammoType.addLookupName("Clan LRM 18 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 18;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 27.0;
        return ammoType;
    }

    public static AmmoType createCLLRM19Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 19 Ammo";
        ammoType.setInternalName("Clan Ammo Protomech LRM-19");
        ammoType.addLookupName("Clan Ammo LRM-19");
        ammoType.addLookupName("CLLRM19 Ammo");
        ammoType.addLookupName("Clan LRM 19 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 19;
        ammoType.ammoType = 7;
        ammoType.shots = 100;
        ammoType.bv = 28.0;
        return ammoType;
    }

    public static AmmoType createCLLRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "LRM 20 Ammo";
        ammoType.setInternalName("Clan Ammo LRM-20");
        ammoType.addLookupName("CLLRM20 Ammo");
        ammoType.addLookupName("Clan LRM 20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 7;
        ammoType.shots = 6;
        ammoType.bv = 27.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createCLSRT1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 1 Ammo";
        ammoType.setInternalName("Clan Ammo SRTorpedo-1");
        ammoType.addLookupName("CLSRTorpedo1 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 1 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 10;
        ammoType.shots = 100;
        ammoType.bv = 2.0;
        return ammoType;
    }

    public static AmmoType createCLSRT2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 2 Ammo";
        ammoType.setInternalName("Clan Ammo SRTorpedo-2");
        ammoType.addLookupName("CLSRTorpedo2 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 10;
        ammoType.shots = 50;
        ammoType.bv = 3.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createCLSRT3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 3 Ammo";
        ammoType.setInternalName("Clan Ammo SRTorpedo-3");
        ammoType.addLookupName("CLSRTorpedo3 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 10;
        ammoType.shots = 100;
        ammoType.bv = 4.0;
        return ammoType;
    }

    public static AmmoType createCLSRT4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 4 Ammo";
        ammoType.setInternalName("Clan Ammo SRTorpedo-4");
        ammoType.addLookupName("CLSRTorpedo4 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 10;
        ammoType.shots = 25;
        ammoType.bv = 5.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createCLSRT5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 5 Ammo";
        ammoType.setInternalName("Clan Ammo SRTorpedo-5");
        ammoType.addLookupName("CLSRTorpedo5 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 5 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 10;
        ammoType.shots = 100;
        ammoType.bv = 5.0;
        return ammoType;
    }

    public static AmmoType createCLSRT6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "SRT 6 Ammo";
        ammoType.setInternalName("Clan Ammo SRTorpedo-6");
        ammoType.addLookupName("CLSRTorpedo6 Ammo");
        ammoType.addLookupName("Clan SRTorpedo 6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 10;
        ammoType.shots = 15;
        ammoType.bv = 7.0;
        ammoType.cost = 27000.0;
        return ammoType;
    }

    public static AmmoType createCLStreakSRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 1 Ammo";
        ammoType.setInternalName("Clan Streak SRM 1 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-1");
        ammoType.addLookupName("CLStreakSRM1 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 11;
        ammoType.shots = 100;
        ammoType.bv = 3.0;
        return ammoType;
    }

    public static AmmoType createCLStreakSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 2 Ammo";
        ammoType.setInternalName("Clan Streak SRM 2 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-2");
        ammoType.addLookupName("CLStreakSRM2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 11;
        ammoType.shots = 50;
        ammoType.bv = 5.0;
        ammoType.cost = 54000.0;
        return ammoType;
    }

    public static AmmoType createCLStreakSRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 3 Ammo";
        ammoType.setInternalName("Clan Streak SRM 3 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-3");
        ammoType.addLookupName("CLStreakSRM3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 11;
        ammoType.shots = 100;
        ammoType.bv = 8.0;
        return ammoType;
    }

    public static AmmoType createCLStreakSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 4 Ammo";
        ammoType.setInternalName("Clan Streak SRM 4 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-4");
        ammoType.addLookupName("CLStreakSRM4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 11;
        ammoType.shots = 25;
        ammoType.bv = 10.0;
        ammoType.cost = 54000.0;
        return ammoType;
    }

    public static AmmoType createCLStreakSRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 5 Ammo";
        ammoType.setInternalName("Clan Streak SRM 5 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-5");
        ammoType.addLookupName("CLStreakSRM5 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 11;
        ammoType.shots = 100;
        ammoType.bv = 13.0;
        return ammoType;
    }

    public static AmmoType createCLStreakSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Streak SRM 6 Ammo";
        ammoType.setInternalName("Clan Streak SRM 6 Ammo");
        ammoType.addLookupName("Clan Ammo Streak-6");
        ammoType.addLookupName("CLStreakSRM6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 11;
        ammoType.shots = 15;
        ammoType.bv = 15.0;
        ammoType.cost = 54000.0;
        return ammoType;
    }

    public static AmmoType createCLAMSAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "AMS Ammo";
        ammoType.setInternalName("CLAMS Ammo");
        ammoType.addLookupName("Clan Ammo AMS");
        ammoType.addLookupName("Clan AMS Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 14;
        ammoType.shots = 24;
        ammoType.bv = 21.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    public static AmmoType createCLNarcAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Narc Pods";
        ammoType.setInternalName("CLNarc Pods");
        ammoType.addLookupName("Clan Ammo Narc");
        ammoType.addLookupName("Clan Narc Missile Beacon Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 13;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        ammoType.cost = 6000.0;
        return ammoType;
    }

    public static AmmoType createCLNarcExplosiveAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Narc Explosive Pods";
        ammoType.setInternalName("CLNarc Explosive Pods");
        ammoType.damagePerShot = 4;
        ammoType.rackSize = 1;
        ammoType.ammoType = 13;
        ammoType.munitionType = 0x10000000L;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        ammoType.cost = 1500.0;
        return ammoType;
    }

    public static AmmoType createCLATM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 3 Ammo";
        ammoType.setInternalName("Clan Ammo ATM-3");
        ammoType.addLookupName("CLATM3 Ammo");
        ammoType.addLookupName("Clan ATM-3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 29;
        ammoType.shots = 20;
        ammoType.bv = 14.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM3ERAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 3 ER Ammo";
        ammoType.setInternalName("Clan Ammo ATM-3 ER");
        ammoType.addLookupName("CLATM3 ER Ammo");
        ammoType.addLookupName("Clan ATM-3 ER Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 29;
        ammoType.munitionType = 32L;
        ammoType.shots = 20;
        ammoType.bv = 14.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM3HEAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 3 HE Ammo";
        ammoType.setInternalName("Clan Ammo ATM-3 HE");
        ammoType.addLookupName("CLATM3 HE Ammo");
        ammoType.addLookupName("Clan ATM-3 HE Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 3;
        ammoType.ammoType = 29;
        ammoType.munitionType = 64L;
        ammoType.shots = 20;
        ammoType.bv = 14.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 6 Ammo";
        ammoType.setInternalName("Clan Ammo ATM-6");
        ammoType.addLookupName("CLATM6 Ammo");
        ammoType.addLookupName("Clan ATM-6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 29;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM6ERAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 6 ER Ammo";
        ammoType.setInternalName("Clan Ammo ATM-6 ER");
        ammoType.addLookupName("CLATM6 ER Ammo");
        ammoType.addLookupName("Clan ATM-6 ER Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 6;
        ammoType.ammoType = 29;
        ammoType.munitionType = 32L;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM6HEAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 6 HE Ammo";
        ammoType.setInternalName("Clan Ammo ATM-6 HE");
        ammoType.addLookupName("CLATM6 HE Ammo");
        ammoType.addLookupName("Clan ATM-6 HE Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 6;
        ammoType.ammoType = 29;
        ammoType.munitionType = 64L;
        ammoType.shots = 10;
        ammoType.bv = 26.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM9Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 9 Ammo";
        ammoType.setInternalName("Clan Ammo ATM-9");
        ammoType.addLookupName("CLATM9 Ammo");
        ammoType.addLookupName("Clan ATM-9 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 9;
        ammoType.ammoType = 29;
        ammoType.shots = 7;
        ammoType.bv = 36.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM9ERAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 9 ER Ammo";
        ammoType.setInternalName("Clan Ammo ATM-9 ER");
        ammoType.addLookupName("CLATM9 ER Ammo");
        ammoType.addLookupName("Clan ATM-9 ER Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 9;
        ammoType.ammoType = 29;
        ammoType.munitionType = 32L;
        ammoType.shots = 7;
        ammoType.bv = 36.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM9HEAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 9 HE Ammo";
        ammoType.setInternalName("Clan Ammo ATM-9 HE");
        ammoType.addLookupName("CLATM9 HE Ammo");
        ammoType.addLookupName("Clan ATM-9 HE Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 9;
        ammoType.ammoType = 29;
        ammoType.munitionType = 64L;
        ammoType.shots = 7;
        ammoType.bv = 36.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM12Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 12 Ammo";
        ammoType.setInternalName("Clan Ammo ATM-12");
        ammoType.addLookupName("CLATM12 Ammo");
        ammoType.addLookupName("Clan ATM-12 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 12;
        ammoType.ammoType = 29;
        ammoType.shots = 5;
        ammoType.bv = 52.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM12ERAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 12 ER Ammo";
        ammoType.setInternalName("Clan Ammo ATM-12 ER");
        ammoType.addLookupName("CLATM12 ER Ammo");
        ammoType.addLookupName("Clan ATM-12 ER Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 12;
        ammoType.ammoType = 29;
        ammoType.munitionType = 32L;
        ammoType.shots = 5;
        ammoType.bv = 52.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLATM12HEAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "ATM 12 HE Ammo";
        ammoType.setInternalName("Clan Ammo ATM-12 HE");
        ammoType.addLookupName("CLATM12 HE Ammo");
        ammoType.addLookupName("Clan ATM-12 HE Ammo");
        ammoType.damagePerShot = 3;
        ammoType.rackSize = 12;
        ammoType.ammoType = 29;
        ammoType.munitionType = 64L;
        ammoType.shots = 5;
        ammoType.bv = 52.0;
        ammoType.cost = 75000.0;
        return ammoType;
    }

    public static AmmoType createCLStreakLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Streak LRM 5 Ammo";
        ammoType.setInternalName("Clan Streak LRM 5 Ammo");
        ammoType.addLookupName("CLStreakLRM5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 32;
        ammoType.shots = 24;
        ammoType.bv = 11.0;
        ammoType.cost = 60000.0;
        return ammoType;
    }

    public static AmmoType createCLStreakLRM10Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Streak LRM 10 Ammo";
        ammoType.setInternalName("Clan Streak LRM 10 Ammo");
        ammoType.addLookupName("CLStreakLRM10 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 32;
        ammoType.shots = 12;
        ammoType.bv = 22.0;
        ammoType.cost = 60000.0;
        return ammoType;
    }

    public static AmmoType createCLStreakLRM15Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Streak LRM 15 Ammo";
        ammoType.setInternalName("Clan Streak LRM 15 Ammo");
        ammoType.addLookupName("CLStreakLRM15 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 15;
        ammoType.ammoType = 32;
        ammoType.shots = 8;
        ammoType.bv = 32.0;
        ammoType.cost = 60000.0;
        return ammoType;
    }

    public static AmmoType createCLStreakLRM20Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 6;
        ammoType.name = "Streak LRM 20 Ammo";
        ammoType.setInternalName("Clan Streak LRM 20 Ammo");
        ammoType.addLookupName("CLStreakLRM20 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 32;
        ammoType.shots = 6;
        ammoType.bv = 43.0;
        ammoType.cost = 60000.0;
        return ammoType;
    }

    public static AmmoType createBASRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "SRM 2 Ammo";
        ammoType.setInternalName("BA-SRM2 Ammo");
        ammoType.addLookupName("BASRM2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.flags |= 0x1000;
        ammoType.shots = 2;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBASRM2OSAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "SRM 2 Ammo";
        ammoType.setInternalName("BA-SRM2 (one shot) Ammo");
        ammoType.addLookupName("BASRM2OS Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBAInfernoSRMAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Inferno SRM Ammo";
        ammoType.setInternalName("BA-Inferno SRM Ammo");
        ammoType.addLookupName("BAInfernoSRM Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 25;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        ammoType.munitionType = 0x400000L;
        return ammoType;
    }

    public static AmmoType createBAMicroBombAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Micro Bomb Ammo";
        ammoType.setInternalName("BA-Micro Bomb Ammo");
        ammoType.addLookupName("BAMicroBomb Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 26;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createCLTorpedoLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Torpedo/LRM 5 Ammo";
        ammoType.setInternalName("Clan Torpedo/LRM5 Ammo");
        ammoType.addLookupName("CLTorpedoLRM5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 27;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        ammoType.cost = 30000.0;
        return ammoType;
    }

    public static AmmoType createFenrirSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "SRM 4 Ammo";
        ammoType.setInternalName("Fenrir SRM-4 Ammo");
        ammoType.addLookupName("FenrirSRM4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.flags |= 0x1000;
        ammoType.shots = 4;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createPhalanxSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "SRM 4 Ammo";
        ammoType.setInternalName("PhalanxSRM4Ammo");
        ammoType.addLookupName("Phalanx SRM4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 9;
        ammoType.flags |= 0x1000;
        ammoType.shots = 2;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createGrenadierSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "SRM 4 Ammo";
        ammoType.setInternalName("BA-SRM4 Grenadier Ammo");
        ammoType.addLookupName("BA-SRM4 Grenadier Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 9;
        ammoType.flags |= 0x1000;
        ammoType.shots = 7;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBACompactNarcAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Compact Narc Ammo";
        ammoType.setInternalName("BA-Compact Narc Ammo");
        ammoType.addLookupName("BACompactNarc Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 13;
        ammoType.flags |= 0x1000;
        ammoType.shots = 2;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBAMineLauncherAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Mine Launcher Ammo";
        ammoType.setInternalName("BA-Mine Launcher Ammo");
        ammoType.addLookupName("BAMineLauncher Ammo");
        ammoType.damagePerShot = 4;
        ammoType.rackSize = 1;
        ammoType.ammoType = 28;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBALRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LRM 5 Ammo";
        ammoType.setInternalName("BA Ammo LRM-5");
        ammoType.addLookupName("BALRM5 Ammo");
        ammoType.addLookupName("BA LRM 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 6;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createCLPROHeavyMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Heavy Machine Gun Ammo";
        ammoType.setInternalName("Clan Heavy Machine Gun Ammo - Proto");
        ammoType.addLookupName("CLHeavyMG Ammo");
        ammoType.addLookupName("Clan Heavy Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 4;
        ammoType.flags |= 0x41;
        ammoType.shots = 100;
        ammoType.bv = 1.0;
        return ammoType;
    }

    public static AmmoType createCLPROMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Machine Gun Ammo";
        ammoType.setInternalName("Clan Machine Gun Ammo - Proto");
        ammoType.addLookupName("CLMG Ammo");
        ammoType.addLookupName("Clan Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 3;
        ammoType.flags |= 0x41;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        return ammoType;
    }

    public static AmmoType createCLPROLightMGAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Light Machine Gun Ammo";
        ammoType.setInternalName("Clan Light Machine Gun Ammo - Proto");
        ammoType.addLookupName("CLLightMG Ammo");
        ammoType.addLookupName("Clan Light Machine Gun Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 5;
        ammoType.flags |= 0x41;
        ammoType.shots = 200;
        ammoType.bv = 1.0;
        return ammoType;
    }

    public static AmmoType createISArrowIVAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "Arrow IV Ammo";
        ammoType.setInternalName("ISArrowIVAmmo");
        ammoType.addLookupName("ISArrowIV Ammo");
        ammoType.addLookupName("IS Ammo Arrow");
        ammoType.addLookupName("IS Arrow IV Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 15;
        ammoType.shots = 5;
        ammoType.bv = 11.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    public static AmmoType createCLArrowIVAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Arrow IV Ammo";
        ammoType.setInternalName("CLArrowIVAmmo");
        ammoType.addLookupName("CLArrowIV Ammo");
        ammoType.addLookupName("Clan Ammo Arrow");
        ammoType.addLookupName("Clan Arrow IV Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 15;
        ammoType.shots = 5;
        ammoType.bv = 11.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    public static AmmoType createCLLongTomAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Long Tom Ammo";
        ammoType.setInternalName("CLLongTomAmmo");
        ammoType.addLookupName("CLLongTom Ammo");
        ammoType.addLookupName("CLLongTomArtillery Ammo");
        ammoType.addLookupName("Clan Ammo Long Tom");
        ammoType.addLookupName("Clan Long Tom Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 20;
        ammoType.ammoType = 16;
        ammoType.shots = 5;
        ammoType.bv = 11.0;
        ammoType.cost = 10000.0;
        return ammoType;
    }

    public static AmmoType createCLSniperAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Sniper Ammo";
        ammoType.setInternalName("CLSniperAmmo");
        ammoType.addLookupName("CLSniper Ammo");
        ammoType.addLookupName("CLSniperArtillery Ammo");
        ammoType.addLookupName("Clan Ammo Sniper");
        ammoType.addLookupName("Clan Sniper Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 10;
        ammoType.ammoType = 17;
        ammoType.shots = 10;
        ammoType.bv = 5.0;
        ammoType.cost = 6000.0;
        return ammoType;
    }

    public static AmmoType createCLThumperAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Thumper Ammo";
        ammoType.setInternalName("CLThumperAmmo");
        ammoType.addLookupName("CLThumper Ammo");
        ammoType.addLookupName("CLThumperArtillery Ammo");
        ammoType.addLookupName("Clan Ammo Thumper");
        ammoType.addLookupName("Clan Thumper Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 18;
        ammoType.shots = 20;
        ammoType.bv = 3.0;
        ammoType.cost = 4500.0;
        return ammoType;
    }

    public static AmmoType createBAISLRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "BA LRM 1 Ammo";
        ammoType.setInternalName("IS BA Ammo LRM-1");
        ammoType.addLookupName("BAISLRM1 Ammo");
        ammoType.addLookupName("BAISLRM1 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 3;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBAISLRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "BA LRM 2 Ammo";
        ammoType.setInternalName("IS BA Ammo LRM-2");
        ammoType.addLookupName("BAISLRM2 Ammo");
        ammoType.addLookupName("BAISLRM2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 3;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBAISLRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "BA LRM 3 Ammo";
        ammoType.setInternalName("IS BA Ammo LRM-3");
        ammoType.addLookupName("BAISLRM3 Ammo");
        ammoType.addLookupName("BAISLRM3 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 3;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBAISLRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "BA LRM 4 Ammo";
        ammoType.setInternalName("IS BA Ammo LRM-4");
        ammoType.addLookupName("BAISLRM4 Ammo");
        ammoType.addLookupName("BAISLRM4 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 3;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBAISLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 0;
        ammoType.name = "BA LRM 5 Ammo";
        ammoType.setInternalName("IS BA Ammo LRM-5");
        ammoType.addLookupName("BAISLRM5 Ammo");
        ammoType.addLookupName("BAISLRM5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 3;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBACLLRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "BA LRM 1 Ammo";
        ammoType.setInternalName("BACL Ammo LRM-1");
        ammoType.addLookupName("BACLLRM1 Ammo");
        ammoType.addLookupName("BACL LRM 1 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 3;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBACLLRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "BA LRM 2 Ammo";
        ammoType.setInternalName("BACL Ammo LRM-2");
        ammoType.addLookupName("BACLLRM2 Ammo");
        ammoType.addLookupName("BACL LRM 2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 3;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBACLLRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "BA LRM 3 Ammo";
        ammoType.setInternalName("BACL Ammo LRM-3");
        ammoType.addLookupName("BACLLRM3 Ammo");
        ammoType.addLookupName("BACL LRM 3 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 3;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBACLLRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "BA LRM 4 Ammo";
        ammoType.setInternalName("BACL Ammo LRM-4");
        ammoType.addLookupName("BACLLRM4 Ammo");
        ammoType.addLookupName("BACL LRM 4 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 3;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBACLLRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "BA LRM 5 Ammo";
        ammoType.setInternalName("BACL Ammo LRM-5");
        ammoType.addLookupName("BACLLRM5 Ammo");
        ammoType.addLookupName("BACL LRM 5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 7;
        ammoType.flags |= 0x1000;
        ammoType.shots = 3;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBASRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "BA SRM 6 Ammo";
        ammoType.setInternalName("BA Ammo SRM-6");
        ammoType.addLookupName("BASRM-6 Ammo");
        ammoType.addLookupName("BASRM-6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 9;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBASRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "BA SRM 5 Ammo";
        ammoType.setInternalName("BA Ammo SRM-5");
        ammoType.addLookupName("BASRM-5 Ammo");
        ammoType.addLookupName("BASRM-5 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 9;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBASRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "BA SRM 4 Ammo";
        ammoType.setInternalName("BA Ammo SRM-4");
        ammoType.addLookupName("BASRM-4 Ammo");
        ammoType.addLookupName("BASRM-4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 9;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBASRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "BA SRM 3 Ammo";
        ammoType.setInternalName("BA Ammo SRM-3");
        ammoType.addLookupName("BASRM-3 Ammo");
        ammoType.addLookupName("BASRM-3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 9;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createBASRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "BA SRM 1 Ammo";
        ammoType.setInternalName("BA Ammo SRM-1");
        ammoType.addLookupName("BASRM-1 Ammo");
        ammoType.addLookupName("BASRM-1 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 9;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISMRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 1 Ammo";
        ammoType.setInternalName("IS MRM 1 Ammo");
        ammoType.addLookupName("ISMRM1 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 12;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISMRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 2 Ammo";
        ammoType.setInternalName("IS MRM 2 Ammo");
        ammoType.addLookupName("ISMRM2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 12;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISMRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 3 Ammo";
        ammoType.setInternalName("IS MRM 3 Ammo");
        ammoType.addLookupName("ISMRM3 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 12;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISMRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 4 Ammo";
        ammoType.setInternalName("IS MRM 4 Ammo");
        ammoType.addLookupName("ISMRM4 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 12;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISMRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "MRM 5 Ammo";
        ammoType.setInternalName("IS MRM 5 Ammo");
        ammoType.addLookupName("ISMRM5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 12;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISLAWLauncherAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LAW Launcher Ammo";
        ammoType.setInternalName("IS Ammo LAW Launcher");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 1;
        ammoType.ammoType = 30;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISLAW2LauncherAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LAW 2 Launcher Ammo";
        ammoType.setInternalName("IS Ammo LAW-2 Launcher");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 30;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISLAW3LauncherAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LAW 3 Launcher Ammo";
        ammoType.setInternalName("IS Ammo LAW-3 Launcher");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 3;
        ammoType.ammoType = 30;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISLAW4LauncherAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LAW 4 Launcher Ammo";
        ammoType.setInternalName("IS Ammo LAW-4 Launcher");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 4;
        ammoType.ammoType = 30;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISLAW5LauncherAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 1;
        ammoType.name = "LAW 5 Launcher Ammo";
        ammoType.setInternalName("IS Ammo LAW-5 Launcher");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 30;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createAdvancedSRM1Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 1 Ammo";
        ammoType.setInternalName("BA-Advanced SRM-1 Ammo");
        ammoType.addLookupName("BAAdvanced SRM1 Ammo");
        ammoType.addLookupName("BAAdvancedSRM1 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 1;
        ammoType.ammoType = 24;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createAdvancedSRM5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 5 Ammo";
        ammoType.setInternalName("BA-Advanced SRM-5 Ammo");
        ammoType.addLookupName("BAAdvancedSRM5 Ammo");
        ammoType.addLookupName("BAAdvanced SRM5 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 5;
        ammoType.ammoType = 24;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createAdvancedSRM3Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 3 Ammo";
        ammoType.setInternalName("BA-Advanced SRM-3 Ammo");
        ammoType.addLookupName("BAAdvanced SRM3 Ammo");
        ammoType.addLookupName("BAAdvancedSRM3 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 3;
        ammoType.ammoType = 24;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createAdvancedSRM2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 2 Ammo";
        ammoType.setInternalName("BA-Advanced SRM-2 Ammo");
        ammoType.addLookupName("BA-Advanced SRM-2 Ammo OS");
        ammoType.addLookupName("BAAdvancedSRM2 Ammo");
        ammoType.addLookupName("BAAdvanced SRM2 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 2;
        ammoType.ammoType = 24;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createAdvancedSRM4Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 4 Ammo";
        ammoType.setInternalName("BA-Advanced SRM-4 Ammo");
        ammoType.addLookupName("BAAdvanced SRM4 Ammo");
        ammoType.addLookupName("BAAdvancedSRM4 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 4;
        ammoType.ammoType = 24;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createAdvancedSRM6Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 2;
        ammoType.name = "Advanced SRM 6 Ammo";
        ammoType.setInternalName("BA-Advanced SRM-6 Ammo");
        ammoType.addLookupName("BAAdvanced SRM6 Ammo");
        ammoType.addLookupName("BAAdvancedSRM6 Ammo");
        ammoType.damagePerShot = 2;
        ammoType.rackSize = 6;
        ammoType.ammoType = 24;
        ammoType.flags |= 0x1000;
        ammoType.shots = 1;
        ammoType.hittable = false;
        ammoType.bv = 0.0;
        return ammoType;
    }

    public static AmmoType createISLAC2Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LAC/2 Ammo";
        ammoType.setInternalName("IS Ammo LAC/2");
        ammoType.addLookupName("ISLAC2 Ammo");
        ammoType.addLookupName("IS Light Autocannon/2 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 35;
        ammoType.shots = 45;
        ammoType.bv = 3.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    public static AmmoType createISLAC5Ammo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "LAC/5 Ammo";
        ammoType.setInternalName("IS Ammo LAC/5");
        ammoType.addLookupName("ISLAC5 Ammo");
        ammoType.addLookupName("IS Light Autocannon/5 Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 5;
        ammoType.ammoType = 35;
        ammoType.shots = 20;
        ammoType.bv = 5.0;
        ammoType.cost = 5000.0;
        return ammoType;
    }

    public static AmmoType createISHeavyFlamerAmmo() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Heavy Flamer Ammo";
        ammoType.setInternalName("IS Heavy Flamer Ammo");
        ammoType.addLookupName("IS Ammo Heavy Flamer");
        ammoType.addLookupName("ISHeavyFlamer Ammo");
        ammoType.damagePerShot = 1;
        ammoType.rackSize = 2;
        ammoType.ammoType = 36;
        ammoType.shots = 10;
        ammoType.bv = 3.0;
        ammoType.cost = 2000.0;
        return ammoType;
    }

    public static AmmoType createCoolantPod() {
        AmmoType ammoType = new AmmoType();
        ammoType.techLevel = 5;
        ammoType.name = "Coolant Pod";
        ammoType.setInternalName(ammoType.name);
        ammoType.damagePerShot = 10;
        ammoType.rackSize = 1;
        ammoType.ammoType = 37;
        ammoType.shots = 1;
        ammoType.bv = 0.0;
        ammoType.cost = 50000.0;
        String[] stringArray = new String[]{"safe", "efficient", "off", "dump"};
        ammoType.setModes(stringArray);
        ammoType.setInstantModeSwitch(true);
        return ammoType;
    }

    public String toString() {
        return "Ammo: " + this.name;
    }

    public static boolean canClearMinefield(AmmoType ammoType) {
        return ammoType != null && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 12) && ammoType.getRackSize() >= 20 && ammoType.getMunitionType() == 0L;
    }

    public static boolean canDeliverMinefield(AmmoType ammoType) {
        return ammoType != null && ammoType.getAmmoType() == 7 && (ammoType.getMunitionType() == 131072L || ammoType.getMunitionType() == 524288L || ammoType.getMunitionType() == 262144L || ammoType.getMunitionType() == 0x100000L || ammoType.getMunitionType() == 0x200000L);
    }

    private void addToBegining() {
    }

    private void addToEnd(AmmoType ammoType, String string) {
        Enumeration enumeration = ammoType.getNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.addLookupName(string2 + string);
        }
    }

    private void addBeforeString(AmmoType ammoType, String string, String string2) {
        Enumeration enumeration = ammoType.getNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.insert(string3.lastIndexOf(string), string2);
            this.addLookupName(stringBuffer.toString());
        }
    }

    private static class MunitionMutator {
        private String name;
        private int weight;
        private long type;
        private int techLevel = -1;

        public MunitionMutator(String string, int n, long l, int n2) {
            this.name = string;
            this.weight = n;
            this.type = l;
            this.techLevel = n2;
        }

        public MunitionMutator(String string, int n, long l) {
            this.name = string;
            this.weight = n;
            this.type = l;
        }

        public AmmoType createMunitionType(AmmoType ammoType) {
            AmmoType ammoType2 = new AmmoType();
            switch (ammoType.ammoType) {
                case 1: {
                    StringBuffer stringBuffer = new StringBuffer(this.name);
                    stringBuffer.append(" ");
                    stringBuffer.append(ammoType.name);
                    ammoType2.name = stringBuffer.toString();
                    stringBuffer = new StringBuffer(" - ");
                    stringBuffer.append(this.name);
                    ammoType2.addToEnd(ammoType, " - " + this.name);
                    stringBuffer = new StringBuffer(ammoType.internalName);
                    int n = ammoType.internalName.lastIndexOf("Ammo");
                    stringBuffer.insert(n, ' ');
                    stringBuffer.insert(n, this.name);
                    ammoType2.setInternalName(stringBuffer.toString());
                    ammoType2.addBeforeString(ammoType, "Ammo", this.name + " ");
                    stringBuffer = null;
                    break;
                }
                case 15: {
                    StringBuffer stringBuffer = new StringBuffer(ammoType.name);
                    int n = ammoType.name.lastIndexOf("Ammo");
                    stringBuffer.insert(n, ' ');
                    if (this.name.endsWith("-IV")) {
                        StringBuffer stringBuffer2 = new StringBuffer(this.name);
                        stringBuffer2.setLength(stringBuffer2.length() - 3);
                        stringBuffer.insert(n, stringBuffer2.toString());
                    } else {
                        stringBuffer.insert(n, this.name);
                    }
                    ammoType2.name = stringBuffer.toString();
                    stringBuffer = new StringBuffer(ammoType.internalName);
                    n = ammoType.internalName.lastIndexOf("Ammo");
                    stringBuffer.insert(n, this.name);
                    ammoType2.setInternalName(stringBuffer.toString());
                    ammoType2.addBeforeString(ammoType, "Ammo", this.name + " ");
                    ammoType2.addToEnd(ammoType, " - " + this.name);
                    if (this.name.equals("Homing")) {
                        ammoType2.addToEnd(ammoType, " (HO)");
                    }
                    stringBuffer = null;
                    break;
                }
                case 9: {
                    StringBuffer stringBuffer = new StringBuffer(" ");
                    stringBuffer.append(this.name);
                    ammoType2.setInternalName(ammoType.internalName + stringBuffer.toString());
                    ammoType2.addToEnd(ammoType, stringBuffer.toString());
                    stringBuffer.insert(0, " -");
                    ammoType2.addToEnd(ammoType, stringBuffer.toString());
                    stringBuffer = new StringBuffer(ammoType.name);
                    int n = ammoType.name.lastIndexOf("Ammo");
                    stringBuffer.insert(n, ' ');
                    stringBuffer.insert(n, this.name);
                    ammoType2.name = stringBuffer.toString();
                    stringBuffer = null;
                    ammoType2.addBeforeString(ammoType, "Ammo", this.name + " ");
                    break;
                }
                case 7: {
                    StringBuffer stringBuffer = new StringBuffer(this.name);
                    stringBuffer.append(" ");
                    stringBuffer.append(ammoType.name);
                    ammoType2.name = stringBuffer.toString();
                    stringBuffer = new StringBuffer(" ");
                    stringBuffer.append(this.name);
                    ammoType2.setInternalName(ammoType.internalName + stringBuffer.toString());
                    ammoType2.addToEnd(ammoType, stringBuffer.toString());
                    stringBuffer.insert(0, " -");
                    ammoType2.addToEnd(ammoType, stringBuffer.toString());
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    StringBuffer stringBuffer = new StringBuffer(this.name);
                    stringBuffer.append(" ");
                    stringBuffer.append(ammoType.name);
                    ammoType2.name = stringBuffer.toString();
                    ammoType2.setInternalName(ammoType2.name);
                    ammoType2.addToEnd(ammoType, ammoType2.name);
                    ammoType2.addBeforeString(ammoType, "Ammo", this.name + " ");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Don't know how to create munitions for " + ammoType.ammoType);
                }
            }
            ammoType2.munitionType = this.type;
            ammoType2.techLevel = this.techLevel != -1 ? this.techLevel : ammoType.techLevel;
            ammoType2.shots = ammoType.shots / this.weight;
            double d = ammoType.cost;
            if (ammoType2.getAmmoType() == 1 && ammoType2.getMunitionType() == 2L) {
                d *= 4.0;
            }
            if (ammoType2.getAmmoType() == 1 && ammoType2.getMunitionType() == 4L) {
                d *= 1.5;
            }
            if (ammoType2.getAmmoType() == 1 && ammoType2.getMunitionType() == 8L) {
                d *= 2.0;
            }
            if (ammoType2.getAmmoType() == 1 && ammoType2.getMunitionType() == 16L) {
                d *= 6.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 128L) {
                d *= 2.0;
            }
            if (ammoType2.getAmmoType() == 9 && ammoType2.getMunitionType() == 0x400000L) {
                d = 13500.0;
            }
            if (ammoType2.getAmmoType() == 7 && ammoType2.getMunitionType() == 16384L) {
                d *= 3.0;
            }
            if (ammoType2.getAmmoType() == 7 && ammoType2.getMunitionType() == 32768L) {
                d *= 2.0;
            }
            if (ammoType2.getAmmoType() == 7 && ammoType2.getMunitionType() == 65536L) {
                d *= 3.0;
            }
            if (ammoType2.getAmmoType() == 7 && ammoType2.getMunitionType() == 131072L) {
                d *= 2.0;
            }
            if (ammoType2.getAmmoType() == 7 && ammoType2.getMunitionType() == 262144L) {
                d *= 4.0;
            }
            if (ammoType2.getAmmoType() == 7 && ammoType2.getMunitionType() == 524288L) {
                d *= 1.0;
            }
            if (ammoType2.getAmmoType() == 7 && ammoType2.getMunitionType() == 0x100000L) {
                d *= 2.5;
            }
            if (ammoType2.getAmmoType() == 7 && ammoType2.getMunitionType() == 0x200000L) {
                d *= 3.0;
            }
            if (ammoType2.getMunitionType() == 0x20000000L) {
                d = 15000.0;
            }
            if (ammoType2.getMunitionType() == 0x40000000L) {
                d *= 1.5;
            }
            if (ammoType2.getMunitionType() == 0x80000000L) {
                d *= 1.0;
            }
            if (ammoType2.getMunitionType() == 0x100000000L) {
                d *= 2.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 1024L) {
                d *= 2.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 2048L) {
                d *= 2.0;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 256L) {
                d *= 1.1;
            }
            if ((ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 512L) {
                d *= 2.0;
            }
            ammoType2.cost = d;
            ammoType2.damagePerShot = ammoType.damagePerShot;
            ammoType2.rackSize = ammoType.rackSize;
            ammoType2.ammoType = ammoType.ammoType;
            ammoType2.bv = ammoType.bv;
            ammoType2.flags = ammoType.flags;
            ammoType2.hittable = ammoType.hittable;
            ammoType2.explosive = ammoType.explosive;
            ammoType2.toHitModifier = ammoType.toHitModifier;
            return ammoType2;
        }
    }
}

