/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mounted;
import megamek.common.Transporter;

class BattleArmorHandles
implements Transporter {
    private Entity troopers = null;
    private static final int[] BLOCKED_LOCATIONS_FRONT = new int[]{1, 2, 3};
    private static final int[] BLOCKED_LOCATIONS_REAR = new int[]{1, 2, 3};
    private static final int[] EXTERIOR_LOCATIONS_FRONT = new int[]{2, 3};
    private static final int[] EXTERIOR_LOCATIONS_REAR = new int[]{1, 2, 3};
    private static final String NO_VACANCY_STRING = "A squad is loaded";
    private static final String HAVE_VACANCY_STRING = "One battle armor squad";

    protected int[] getBlockedLocs(boolean bl) {
        if (bl) {
            return BLOCKED_LOCATIONS_REAR;
        }
        return BLOCKED_LOCATIONS_FRONT;
    }

    protected int[] getExteriorLocs(boolean bl) {
        if (bl) {
            return EXTERIOR_LOCATIONS_REAR;
        }
        return EXTERIOR_LOCATIONS_FRONT;
    }

    protected String getBoardingEquipment() {
        return "BA-Boarding Claw";
    }

    protected String getVacancyString(boolean bl) {
        if (bl) {
            return NO_VACANCY_STRING;
        }
        return HAVE_VACANCY_STRING;
    }

    public final boolean canLoad(Entity entity) {
        boolean bl = true;
        if (!(entity instanceof BattleArmor)) {
            bl = false;
        } else if (null != this.troopers) {
            bl = false;
        } else {
            Enumeration enumeration = entity.getMisc();
            bl = false;
            while (!bl && enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                EquipmentType equipmentType = mounted.getType();
                bl = equipmentType.getInternalName().equals(this.getBoardingEquipment()) && (!equipmentType.hasModes() || mounted.curMode().equals("On"));
            }
        }
        return bl;
    }

    public final void load(Entity entity) throws IllegalArgumentException {
        if (!this.canLoad(entity)) {
            throw new IllegalArgumentException("Can not load " + entity.getShortName() + " onto this OmniMech.");
        }
        this.troopers = entity;
    }

    public final Vector getLoadedUnits() {
        Vector<Entity> vector = new Vector<Entity>(1);
        if (null != this.troopers) {
            vector.addElement(this.troopers);
        }
        return vector;
    }

    public final boolean unload(Entity entity) {
        if (this.troopers == null || !this.troopers.equals(entity)) {
            return false;
        }
        this.troopers = null;
        return true;
    }

    public final String getUnusedString() {
        return this.getVacancyString(null != this.troopers);
    }

    public final boolean isWeaponBlockedAt(int n, boolean bl) {
        boolean bl2 = false;
        if (null != this.troopers) {
            int[] nArray = this.getBlockedLocs(bl);
            for (int i = 0; !bl2 && i < nArray.length; ++i) {
                bl2 = n == nArray[i];
            }
        }
        return bl2;
    }

    public final Entity getExteriorUnitAt(int n, boolean bl) {
        if (null != this.troopers) {
            int[] nArray = this.getExteriorLocs(bl);
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return this.troopers;
            }
        }
        return null;
    }
}

