/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.Hex;
import megamek.common.IBoard;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.IdealHex;
import megamek.common.InfernoTracker;
import megamek.common.Player;
import megamek.common.Terrains;
import megamek.common.event.BoardEvent;
import megamek.common.event.BoardListener;

public class Board
implements Serializable,
IBoard {
    public static final String BOARD_REQUEST_ROTATION = "rotate:";
    public static final int BOARD_MAX_WIDTH = 1048575;
    public static final int BOARD_MAX_HEIGHT = 511;
    protected int width;
    protected int height;
    private IHex[] data;
    private Vector buildings = new Vector();
    private transient Hashtable bldgByCoords = new Hashtable();
    protected transient Vector boardListeners = new Vector();
    private Hashtable infernos = new Hashtable();
    private boolean roadsAutoExit = true;

    public Board() {
        this(0, 0);
    }

    public Board(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.data = new IHex[n * n2];
    }

    public Board(int n, int n2, IHex[] iHexArray) {
        this.width = n;
        this.height = n2;
        this.data = new IHex[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.data[i * n + j] = iHexArray[i * n + j];
            }
        }
    }

    public Board(int n, int n2, IHex[] iHexArray, Vector vector, Hashtable hashtable) {
        this.width = n;
        this.height = n2;
        this.data = iHexArray;
        this.buildings = vector;
        this.infernos = hashtable;
        this.createBldgByCoords();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void newData(int n, int n2, IHex[] iHexArray) {
        this.width = n;
        this.height = n2;
        this.data = iHexArray;
        this.initializeAll();
        this.processBoardEvent(new BoardEvent(this, null, 0));
    }

    public void newData(int n, int n2) {
        this.newData(n, n2, new IHex[n * n2]);
    }

    public IHex getHex(int n, int n2) {
        if (this.contains(n, n2)) {
            return this.data[n2 * this.width + n];
        }
        return null;
    }

    public IHex getHexInDir(Coords coords, int n) {
        return this.getHexInDir(coords.x, coords.y, n);
    }

    public IHex getHexInDir(int n, int n2, int n3) {
        return this.getHex(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
    }

    protected void initializeAll() {
        int n;
        int n2;
        this.buildings.removeAllElements();
        if (this.bldgByCoords == null) {
            this.bldgByCoords = new Hashtable();
        } else {
            this.bldgByCoords.clear();
        }
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                Coords coords;
                IHex iHex = this.getHex(n, n2);
                if (iHex == null || !iHex.containsTerrain(10) || this.bldgByCoords.containsKey(coords = new Coords(n, n2))) continue;
                try {
                    Building building = new Building(coords, this);
                    this.buildings.addElement(building);
                    Enumeration enumeration = building.getCoords();
                    while (enumeration.hasMoreElements()) {
                        this.bldgByCoords.put(enumeration.nextElement(), building);
                    }
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Unable to create building.");
                    illegalArgumentException.printStackTrace();
                    iHex.removeTerrain(10);
                }
            }
        }
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                this.initializeHex(n, n2);
            }
        }
        IdealHex.ensureCacheSize(this.width + 1, this.height + 1);
    }

    public void initializeAround(int n, int n2) {
        this.initializeHex(n, n2);
        for (int i = 0; i < 6; ++i) {
            this.initializeInDir(n, n2, i);
        }
    }

    private void initializeInDir(int n, int n2, int n3) {
        this.initializeHex(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
    }

    private void initializeHex(int n, int n2) {
        IHex iHex = this.getHex(n, n2);
        if (iHex == null) {
            return;
        }
        iHex.clearExits();
        for (int i = 0; i < 6; ++i) {
            IHex iHex2 = this.getHexInDir(n, n2, i);
            iHex.setExits(iHex2, i, this.roadsAutoExit);
        }
    }

    public boolean contains(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.width && n2 < this.height;
    }

    public boolean contains(Coords coords) {
        if (coords == null) {
            return false;
        }
        return this.contains(coords.x, coords.y);
    }

    public IHex getHex(Coords coords) {
        if (coords == null) {
            return null;
        }
        return this.getHex(coords.x, coords.y);
    }

    public void setHex(int n, int n2, IHex iHex) {
        this.data[n2 * this.width + n] = iHex;
        this.initializeAround(n, n2);
        this.processBoardEvent(new BoardEvent(this, new Coords(n, n2), 1));
    }

    public void setHex(Coords coords, IHex iHex) {
        this.setHex(coords.x, coords.y, iHex);
    }

    public static boolean boardIsSize(String string, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("data/boards" + File.separator + string));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.wordChars(95, 95);
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("size")) continue;
                streamTokenizer.nextToken();
                n3 = (int)streamTokenizer.nval;
                streamTokenizer.nextToken();
                n4 = (int)streamTokenizer.nval;
                break;
            }
            ((Reader)bufferedReader).close();
        }
        catch (IOException iOException) {
            return false;
        }
        return n3 == n && n4 == n2;
    }

    public boolean isLegalDeployment(Coords coords, Player player) {
        if (coords == null || player == null || !this.contains(coords)) {
            return false;
        }
        int n = 3;
        int n2 = player.getStartingPos();
        switch (n2) {
            case 0: {
                return true;
            }
            case 1: {
                return coords.x < n && coords.y < this.height / 2 || coords.y < n && coords.x < this.width / 2;
            }
            case 2: {
                return coords.y < n;
            }
            case 3: {
                return coords.x > this.width - n && coords.y < this.height / 2 || coords.y < n && coords.x > this.width / 2;
            }
            case 4: {
                return coords.x >= this.width - n;
            }
            case 5: {
                return coords.x >= this.width - n && coords.y > this.height / 2 || coords.y >= this.height - n && coords.x > this.width / 2;
            }
            case 6: {
                return coords.y >= this.height - n;
            }
            case 7: {
                return coords.x < n && coords.y > this.height / 2 || coords.y >= this.height - n && coords.x < this.width / 2;
            }
            case 8: {
                return coords.x < n;
            }
        }
        return false;
    }

    public void load(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File("data/boards", string));
            this.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("error opening file to load board!");
            System.err.println(iOException);
        }
    }

    public void load(InputStream inputStream) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        IHex[] iHexArray = new IHex[]{};
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.wordChars(95, 95);
            int n4 = 1;
            int n5 = 1;
            while (streamTokenizer.nextToken() != -1) {
                int n6;
                String[] stringArray;
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("size")) {
                    stringArray = new String[]{"0", "0"};
                    n6 = 0;
                    while (streamTokenizer.nextToken() == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == -2) {
                        stringArray[n6++] = streamTokenizer.ttype == -2 ? (int)streamTokenizer.nval + "" : streamTokenizer.sval;
                    }
                    n = Integer.parseInt(stringArray[0]);
                    n2 = Integer.parseInt(stringArray[1]);
                    iHexArray = new IHex[n * n2];
                    n3 = 0;
                    continue;
                }
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("option")) {
                    stringArray = new String[]{"", ""};
                    n6 = 0;
                    while (streamTokenizer.nextToken() == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == -2) {
                        stringArray[n6++] = streamTokenizer.ttype == -2 ? (int)streamTokenizer.nval + "" : streamTokenizer.sval;
                    }
                    if (!stringArray[0].equalsIgnoreCase("exit_roads_to_pavement")) continue;
                    if (stringArray[1].equalsIgnoreCase("false")) {
                        this.roadsAutoExit = false;
                        continue;
                    }
                    this.roadsAutoExit = true;
                    continue;
                }
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("hex")) {
                    stringArray = new String[]{"", "0", "", ""};
                    n6 = 0;
                    while (streamTokenizer.nextToken() == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == -2) {
                        stringArray[n6++] = streamTokenizer.ttype == -2 ? (int)streamTokenizer.nval + "" : streamTokenizer.sval;
                    }
                    int n7 = Integer.parseInt(stringArray[1]);
                    int n8 = this.indexFor(stringArray[0], n, n5);
                    iHexArray[n8] = new Hex(n7, stringArray[2], stringArray[3]);
                    if (++n4 <= n) continue;
                    ++n5;
                    n4 = 1;
                    continue;
                }
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("end")) continue;
                break;
            }
        }
        catch (IOException iOException) {
            System.err.println("i/o error reading board");
            System.err.println(iOException);
        }
        for (int i = 0; i < iHexArray.length; ++i) {
            if (iHexArray[i] != null) continue;
            iHexArray[i] = new Hex();
        }
        if (n > 1 || n2 > 1 || n3 == n * n2) {
            this.newData(n, n2, iHexArray);
        } else {
            System.err.println("board data invalid");
        }
    }

    private int indexFor(String string, int n, int n2) {
        int n3 = 2;
        if (n2 > 99) {
            n3 = Integer.toString(n).length();
        }
        int n4 = Integer.parseInt(string.substring(0, string.length() - n3)) - 1;
        int n5 = Integer.parseInt(string.substring(string.length() - n3)) - 1;
        return n5 * n + n4;
    }

    public void save(OutputStream outputStream) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write("size " + this.width + " " + this.height + "\r\n");
            if (!this.roadsAutoExit) {
                outputStreamWriter.write("option exit_roads_to_pavement false\r\n");
            }
            for (int i = 0; i < this.data.length; ++i) {
                IHex iHex = this.data[i];
                boolean bl = true;
                StringBuffer stringBuffer = new StringBuffer("hex ");
                stringBuffer.append(new Coords(i % this.width, i / this.width).getBoardNum());
                stringBuffer.append(" ");
                stringBuffer.append(iHex.getElevation());
                stringBuffer.append(" \"");
                for (int j = 0; j < Terrains.SIZE; ++j) {
                    ITerrain iTerrain = iHex.getTerrain(j);
                    if (iTerrain == null) continue;
                    if (!bl) {
                        stringBuffer.append(";");
                    }
                    stringBuffer.append(iTerrain.toString());
                    if (10 == j && !iTerrain.hasExitsSpecified() && iTerrain.getExits() != 0) {
                        stringBuffer.append(":").append(iTerrain.getExits());
                    }
                    bl = false;
                }
                stringBuffer.append("\" \"");
                if (iHex.getTheme() != null) {
                    stringBuffer.append(iHex.getTheme());
                }
                stringBuffer.append("\"\r\n");
                outputStreamWriter.write(stringBuffer.toString());
            }
            outputStreamWriter.write("end\r\n");
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            System.err.println("i/o error writing board");
            System.err.println(iOException);
        }
    }

    public void save2(OutputStream outputStream) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("i/o error writing board");
            System.err.println(iOException);
        }
    }

    public void addInfernoTo(Coords coords, InfernoTracker.Inferno inferno, int n) {
        InfernoTracker infernoTracker = null;
        if (n < 0) {
            throw new IllegalArgumentException("Board can't track negative hits. ");
        }
        if (!this.contains(coords)) {
            return;
        }
        infernoTracker = (InfernoTracker)this.infernos.get(coords);
        if (null == infernoTracker) {
            infernoTracker = new InfernoTracker();
            this.infernos.put(coords, infernoTracker);
        }
        infernoTracker.add(inferno, n);
    }

    public boolean isInfernoBurning(Coords coords) {
        boolean bl = false;
        InfernoTracker infernoTracker = null;
        infernoTracker = (InfernoTracker)this.infernos.get(coords);
        if (null != infernoTracker && infernoTracker.isStillBurning()) {
            bl = true;
        }
        return bl;
    }

    public boolean burnInferno(Coords coords) {
        boolean bl = false;
        InfernoTracker infernoTracker = null;
        infernoTracker = (InfernoTracker)this.infernos.get(coords);
        if (null != infernoTracker) {
            infernoTracker.newRound(-1);
            if (infernoTracker.isStillBurning()) {
                bl = true;
            }
        }
        return bl;
    }

    public Enumeration getInfernoBurningCoords() {
        Vector<Coords> vector = new Vector<Coords>();
        Enumeration enumeration = this.infernos.keys();
        while (enumeration.hasMoreElements()) {
            Coords coords = (Coords)enumeration.nextElement();
            if (!this.isInfernoBurning(coords)) continue;
            vector.addElement(coords);
        }
        return vector.elements();
    }

    public int getInfernoBurnTurns(Coords coords) {
        int n = 0;
        InfernoTracker infernoTracker = null;
        infernoTracker = (InfernoTracker)this.infernos.get(coords);
        if (null != infernoTracker) {
            n = infernoTracker.getTurnsLeftToBurn();
        }
        return n;
    }

    public int getInfernoIVBurnTurns(Coords coords) {
        int n = 0;
        InfernoTracker infernoTracker = null;
        infernoTracker = (InfernoTracker)this.infernos.get(coords);
        if (null != infernoTracker) {
            n = infernoTracker.getArrowIVTurnsLeftToBurn();
        }
        return n;
    }

    public Enumeration getBuildings() {
        return this.buildings.elements();
    }

    public Building getBuildingAt(Coords coords) {
        return (Building)this.bldgByCoords.get(coords);
    }

    private Building getLocalBuilding(Building building) {
        if (building == null) {
            return null;
        }
        Building building2 = null;
        Enumeration enumeration = building.getCoords();
        if (enumeration.hasMoreElements() && !building.equals(building2 = (Building)this.bldgByCoords.get(enumeration.nextElement()))) {
            building2 = null;
        }
        return building2;
    }

    public void collapseBuilding(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Building building = (Building)enumeration.nextElement();
            Building building2 = this.getLocalBuilding(building);
            if (building2 == null) {
                System.err.print("Could not find a match for ");
                System.err.print(building);
                System.err.println(" to collapse.");
                continue;
            }
            this.collapseBuilding(building2);
        }
    }

    public void collapseBuilding(Building building) {
        this.buildings.removeElement(building);
        Enumeration enumeration = building.getCoords();
        while (enumeration.hasMoreElements()) {
            Coords coords = (Coords)enumeration.nextElement();
            IHex iHex = this.getHex(coords);
            int n = iHex.getElevation();
            this.bldgByCoords.remove(coords);
            iHex.removeTerrain(10);
            iHex.removeTerrain(11);
            iHex.removeTerrain(12);
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(3, building.getType()));
            if (iHex.containsTerrain(13)) {
                iHex.removeTerrain(13);
                iHex.setElevation(n -= iHex.terrainLevel(13));
            }
            this.setHex(coords, iHex);
        }
    }

    public void updateBuildingCF(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Building building = (Building)enumeration.nextElement();
            Building building2 = this.getLocalBuilding(building);
            if (building2 == null) {
                System.err.print("Could not find a match for ");
                System.err.print(building);
                System.err.println(" to update.");
                continue;
            }
            building2.setCurrentCF(building.getCurrentCF());
            building2.setPhaseCF(building.getPhaseCF());
        }
    }

    public boolean getRoadsAutoExit() {
        return this.roadsAutoExit;
    }

    public void setRoadsAutoExit(boolean bl) {
        this.roadsAutoExit = bl;
    }

    private void createBldgByCoords() {
        this.bldgByCoords = new Hashtable();
        Enumeration enumeration = this.buildings.elements();
        while (enumeration.hasMoreElements()) {
            Building building = (Building)enumeration.nextElement();
            Enumeration enumeration2 = building.getCoords();
            while (enumeration2.hasMoreElements()) {
                this.bldgByCoords.put(enumeration2.nextElement(), building);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createBldgByCoords();
    }

    public void addBoardListener(BoardListener boardListener) {
        this.getListeners().addElement(boardListener);
    }

    public void removeBoardListener(BoardListener boardListener) {
        if (this.boardListeners != null) {
            this.boardListeners.removeElement(boardListener);
        }
    }

    protected void processBoardEvent(BoardEvent boardEvent) {
        if (this.boardListeners == null) {
            return;
        }
        Enumeration enumeration = this.boardListeners.elements();
        while (enumeration.hasMoreElements()) {
            BoardListener boardListener = (BoardListener)enumeration.nextElement();
            switch (boardEvent.getType()) {
                case 1: {
                    boardListener.boardChangedHex(boardEvent);
                    break;
                }
                case 0: {
                    boardListener.boardNewBoard(boardEvent);
                }
            }
        }
    }

    protected Vector getListeners() {
        if (this.boardListeners == null) {
            this.boardListeners = new Vector();
        }
        return this.boardListeners;
    }

    public Hashtable getInfernos() {
        return this.infernos;
    }
}

