/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Vector;
import megamek.common.IdealHex;

public class Coords
implements Serializable {
    public static final double HEXSIDE = 1.0471975511965976;
    public int x;
    public int y;
    private static final int SHIFT = 9;
    private static final int MASK = 511;
    public static final int MAX_BOARD_HEIGHT = 511;
    public static final int MAX_BOARD_WIDTH = 1048575;

    public Coords() {
        this(0, 0);
    }

    public Coords(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Coords(Coords coords) {
        this(coords.x, coords.y);
    }

    public final Coords translated(int n) {
        return new Coords(Coords.xInDir(this.x, this.y, n), Coords.yInDir(this.x, this.y, n));
    }

    public static final int xInDir(int n, int n2, int n3) {
        switch (n3) {
            case 1: 
            case 2: {
                return n + 1;
            }
            case 4: 
            case 5: {
                return n - 1;
            }
        }
        return n;
    }

    public static final int yInDir(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                return n2 - 1;
            }
            case 1: 
            case 5: {
                return n2 - (n + 1 & 1);
            }
            case 2: 
            case 4: {
                return n2 + (n & 1);
            }
            case 3: {
                return n2 + 1;
            }
        }
        return n2;
    }

    public boolean isXOdd() {
        return (this.x & 1) == 1;
    }

    public int direction(Coords coords) {
        return (int)Math.round(this.radian(coords) / 1.0471975511965976) % 6;
    }

    public double radian(Coords coords) {
        IdealHex idealHex = IdealHex.get(this);
        IdealHex idealHex2 = IdealHex.get(coords);
        if (idealHex.cy == idealHex2.cy) {
            return idealHex.cx < idealHex2.cx ? 1.5707963267948966 : 4.71238898038469;
        }
        double d = Math.atan((idealHex2.cx - idealHex.cx) / (idealHex.cy - idealHex2.cy));
        if (idealHex.cy < idealHex2.cy) {
            d = (d + Math.PI) % (Math.PI * 2);
        }
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    public int degree(Coords coords) {
        return (int)Math.round(57.29577951308232 * this.radian(coords));
    }

    public int distance(Coords coords) {
        int n = Math.abs(this.x - coords.x);
        int n2 = n / 2 + (!this.isXOdd() && coords.isXOdd() ? 1 : 0);
        int n3 = this.y - n2;
        int n4 = n3 + n;
        int n5 = 0;
        if (coords.y < n3) {
            n5 = n3 - coords.y;
        }
        if (coords.y > n4) {
            n5 = coords.y - n4;
        }
        return n + n5;
    }

    public final String getBoardNum() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((this.x > -1 && this.x < 9 ? "0" : "") + (this.x + 1));
        stringBuffer.append((this.y > -1 && this.y < 9 ? "0" : "") + (this.y + 1));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Coords coords = (Coords)object;
        return coords.x == this.x && coords.y == this.y;
    }

    public int hashCode() {
        boolean bl = this.y < 0;
        boolean bl2 = this.x < 0;
        int n = 0;
        int n2 = this.x;
        int n3 = this.y;
        if (bl) {
            ++n;
            n3 = -this.y;
        }
        if (bl2) {
            n += 2;
            n2 = -this.x;
        }
        return ((n2 << 9 ^ n3) << 2) + n;
    }

    public static Coords getFromHashCode(int n) {
        boolean bl = (n & 1) > 0;
        boolean bl2 = (n & 2) > 0;
        int n2 = n >>> 2;
        int n3 = n2 & 0x1FF;
        int n4 = (n2 ^ n3) >>> 9;
        if (bl2) {
            n4 = -n4;
        }
        if (bl) {
            n3 = -n3;
        }
        return new Coords(n4, n3);
    }

    public String toString() {
        return "Coords (" + this.x + ", " + this.y + "); " + this.getBoardNum();
    }

    public static Coords[] intervening(Coords coords, Coords coords2) {
        return Coords.intervening(coords, coords2, false);
    }

    public static Coords[] intervening(Coords coords, Coords coords2, boolean bl) {
        IdealHex idealHex = IdealHex.get(coords);
        IdealHex idealHex2 = IdealHex.get(coords2);
        int[] nArray = new int[3];
        int n = coords.direction(coords2);
        if (bl) {
            n = (int)Math.round(coords.radian(coords2) + 9.549296585513722E-5) % 6;
        }
        nArray[2] = n;
        nArray[1] = (n + 5) % 6;
        nArray[0] = (n + 1) % 6;
        Vector<Coords> vector = new Vector<Coords>();
        Coords coords3 = coords;
        vector.addElement(coords3);
        while (!coords2.equals(coords3)) {
            coords3 = Coords.nextHex(coords3, idealHex, idealHex2, nArray);
            vector.addElement(coords3);
        }
        Object[] objectArray = new Coords[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static Coords nextHex(Coords coords, IdealHex idealHex, IdealHex idealHex2, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            Coords coords2 = coords.translated(nArray[i]);
            if (!IdealHex.get(coords2).isIntersectedBy(idealHex.cx, idealHex.cy, idealHex2.cx, idealHex2.cy)) continue;
            return coords2;
        }
        throw new RuntimeException("Couldn't find the next hex!");
    }
}

