/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import gd.xml.ParseException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.WeaponType;
import megamek.common.XMLStreamParser;

public class EntityListFile {
    private static String formatArmor(int n) {
        if (n == -2 || n == -3) {
            return "Destroyed";
        }
        if (n == -1) {
            return "N/A";
        }
        return String.valueOf(n);
    }

    private static String formatSlot(String string, Mounted mounted, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("         <slot index=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" type=\"");
        if (mounted == null) {
            stringBuffer.append("System");
        } else {
            stringBuffer.append(mounted.getType().getInternalName());
            if (mounted.isRearMounted()) {
                stringBuffer.append("\" isRear=\"true");
            }
            if (mounted.getType() instanceof AmmoType) {
                stringBuffer.append("\" shots=\"");
                stringBuffer.append(String.valueOf(mounted.getShotsLeft()));
            }
            if (mounted.getType() instanceof WeaponType && ((WeaponType)mounted.getType()).hasFlag(32768)) {
                stringBuffer.append("\" munition=\"");
                stringBuffer.append(mounted.getLinked().getType().getInternalName());
            }
        }
        if (bl) {
            stringBuffer.append("\" isHit=\"");
            stringBuffer.append(String.valueOf(bl));
        }
        stringBuffer.append("\" isDestroyed=\"");
        stringBuffer.append(String.valueOf(bl2));
        stringBuffer.append("\"/>");
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    private static String getLocString(Entity entity) {
        boolean bl = entity instanceof Mech;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < entity.locations(); ++i) {
            Serializable serializable;
            if (entity.getOInternal(i) != -1 && entity.getInternal(i) <= 0) {
                bl3 = true;
            }
            if (!bl3) {
                if (entity.getOArmor(i) != entity.getArmor(i)) {
                    stringBuffer2.append("         <armor points=\"");
                    stringBuffer2.append(EntityListFile.formatArmor(entity.getArmor(i)));
                    stringBuffer2.append("\"/>");
                    stringBuffer2.append("\r\n");
                }
                if (entity.getOInternal(i) != entity.getInternal(i)) {
                    stringBuffer2.append("         <armor points=\"");
                    stringBuffer2.append(EntityListFile.formatArmor(entity.getInternal(i)));
                    stringBuffer2.append("\" type=\"Internal\"/>");
                    stringBuffer2.append("\r\n");
                }
                if (entity.hasRearArmor(i) && entity.getOArmor(i, true) != entity.getArmor(i, true)) {
                    stringBuffer2.append("         <armor points=\"");
                    stringBuffer2.append(EntityListFile.formatArmor(entity.getArmor(i, true)));
                    stringBuffer2.append("\" type=\"Rear\"/>");
                    stringBuffer2.append("\r\n");
                }
            }
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                serializable = entity.getCritical(i, j);
                if (null == serializable) {
                    if (!bl || entity.entityIsQuad() || i != 4 && i != 5 || j != 2 && j != 3) continue;
                    stringBuffer2.append("         <slot index=\"");
                    stringBuffer2.append(String.valueOf(j + 1));
                    stringBuffer2.append("\" type=\"Empty\"/>");
                    stringBuffer2.append("\r\n");
                    bl2 = true;
                    continue;
                }
                Mounted mounted = null;
                if (1 == ((CriticalSlot)serializable).getType()) {
                    mounted = entity.getEquipment(((CriticalSlot)serializable).getIndex());
                }
                if (bl3 && bl && ((CriticalSlot)serializable).isMissing() && !((CriticalSlot)serializable).isHit() && !((CriticalSlot)serializable).isDestroyed()) {
                    stringBuffer2.append(EntityListFile.formatSlot(String.valueOf(j + 1), mounted, ((CriticalSlot)serializable).isHit(), ((CriticalSlot)serializable).isDestroyed()));
                    bl2 = true;
                    bl4 = true;
                    continue;
                }
                if (!bl3 && ((CriticalSlot)serializable).isDamaged()) {
                    stringBuffer2.append(EntityListFile.formatSlot(String.valueOf(j + 1), mounted, ((CriticalSlot)serializable).isHit(), ((CriticalSlot)serializable).isDestroyed()));
                    bl2 = true;
                    continue;
                }
                if (!bl3 && mounted != null && mounted.getType() instanceof AmmoType) {
                    stringBuffer2.append("         <slot index=\"");
                    stringBuffer2.append(String.valueOf(j + 1));
                    stringBuffer2.append("\" type=\"");
                    stringBuffer2.append(mounted.getType().getInternalName());
                    stringBuffer2.append("\" shots=\"");
                    stringBuffer2.append(String.valueOf(mounted.getShotsLeft()));
                    stringBuffer2.append("\"/>");
                    stringBuffer2.append("\r\n");
                    bl2 = true;
                    continue;
                }
                if (bl3 || mounted == null || !(mounted.getType() instanceof WeaponType) || !((WeaponType)mounted.getType()).hasFlag(32768)) continue;
                stringBuffer2.append(EntityListFile.formatSlot(String.valueOf(j + 1), mounted, ((CriticalSlot)serializable).isHit(), ((CriticalSlot)serializable).isDestroyed()));
                bl2 = true;
            }
            if (entity instanceof Tank || entity instanceof Protomech) {
                Enumeration enumeration = entity.getAmmo();
                while (enumeration.hasMoreElements()) {
                    serializable = (Mounted)enumeration.nextElement();
                    if (((Mounted)serializable).getLocation() != i) continue;
                    stringBuffer2.append(EntityListFile.formatSlot("N/A", (Mounted)serializable, false, false));
                    bl2 = true;
                }
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append("      <location index=\"");
                stringBuffer.append(String.valueOf(i));
                if (bl3) {
                    stringBuffer.append("\" isDestroyed=\"true");
                }
                stringBuffer.append("\"> ");
                stringBuffer.append(entity.getLocationName(i));
                if (bl4) {
                    stringBuffer.append(" has been blown off.");
                }
                stringBuffer.append("\r\n");
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append("      </location>");
                stringBuffer.append("\r\n");
                stringBuffer2 = new StringBuffer();
                bl4 = false;
            } else if (bl3) {
                stringBuffer.append("      <location index=\"");
                stringBuffer.append(String.valueOf(i));
                stringBuffer.append("\" isDestroyed=\"true\" /> ");
                stringBuffer.append(entity.getLocationName(i));
                stringBuffer.append("\r\n");
            }
            bl3 = false;
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        if (bl2) {
            stringBuffer.insert(0, "\r\n");
            stringBuffer.insert(0, "      The first slot in a location is at index=\"1\".");
            if (entity instanceof Tank) {
                stringBuffer.insert(0, "\r\n");
                stringBuffer.insert(0, "      Tanks have special needs, so don't delete any ammo slots.");
            }
        }
        return stringBuffer.toString();
    }

    public static void saveTo(String string, String string2, Vector vector) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(string, string2))));
        bufferedWriter.write("<?xml version=\"1.0\"?>");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("<unit>");
        bufferedWriter.write("\r\n");
        bufferedWriter.write("\r\n");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Entity entity = (Entity)enumeration.nextElement();
            bufferedWriter.write("   <entity chassis=\"");
            bufferedWriter.write(entity.getChassis());
            bufferedWriter.write("\" model=\"");
            bufferedWriter.write(entity.getModel());
            bufferedWriter.write("\" type=\"");
            bufferedWriter.write(entity.getMovementModeAsString());
            bufferedWriter.write("\">");
            bufferedWriter.write("\r\n");
            Pilot pilot = entity.getCrew();
            bufferedWriter.write("      <pilot name=\"");
            bufferedWriter.write(pilot.getName());
            bufferedWriter.write("\" gunnery=\"");
            bufferedWriter.write(String.valueOf(pilot.getGunnery()));
            bufferedWriter.write("\" piloting=\"");
            bufferedWriter.write(String.valueOf(pilot.getPiloting()));
            if (pilot.isDead() || pilot.getHits() > 5) {
                bufferedWriter.write("\" hits=\"Dead");
            } else if (pilot.getHits() > 0) {
                bufferedWriter.write("\" hits=\"");
                bufferedWriter.write(String.valueOf(pilot.getHits()));
            }
            if (pilot.countAdvantages() > 0) {
                bufferedWriter.write("\" advantages=\"");
                bufferedWriter.write(String.valueOf(pilot.getAdvantageList("::")));
            }
            if (entity instanceof Mech) {
                if (((Mech)entity).isAutoEject()) {
                    bufferedWriter.write("\" autoeject=\"true");
                } else {
                    bufferedWriter.write("\" autoeject=\"false");
                }
            }
            bufferedWriter.write("\"/>");
            bufferedWriter.write("\r\n");
            if (entity instanceof Tank) {
                object = (Tank)entity;
                bufferedWriter.write(EntityListFile.getMovementString((Tank)object));
                if (((Tank)object).isTurretLocked()) {
                    bufferedWriter.write(EntityListFile.getTurretLockedString((Tank)object));
                }
            }
            if (null != (object = EntityListFile.getLocString(entity))) {
                bufferedWriter.write((String)object);
            }
            bufferedWriter.write("   </entity>");
            bufferedWriter.write("\r\n");
            bufferedWriter.write("\r\n");
        }
        bufferedWriter.write("</unit>");
        bufferedWriter.write("\r\n");
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
    }

    private static String getTurretLockedString(Tank tank) {
        String string = "      <turretlock direction=\"";
        string = string.concat(Integer.toString(tank.getSecondaryFacing()));
        string = string.concat("\"/>\n");
        return string;
    }

    private static String getMovementString(Tank tank) {
        String string = "      <movement speed=\"";
        string = tank.isImmobile() ? string.concat("immobile") : string.concat(Integer.toString(tank.getOriginalWalkMP()));
        string = string.concat("\"/>\n");
        return string;
    }

    public static Vector loadFrom(String string, String string2) throws IOException {
        XMLStreamParser xMLStreamParser = new XMLStreamParser();
        FileInputStream fileInputStream = new FileInputStream(new File(string, string2));
        try {
            xMLStreamParser.parse(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace(System.err);
            throw new IOException("Unable to read from: " + string2);
        }
        if (xMLStreamParser.hasWarningMessage()) {
            System.out.println(xMLStreamParser.getWarningMessage());
        }
        return xMLStreamParser.getEntities();
    }
}

