/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Board;
import megamek.common.BuildingTarget;
import megamek.common.ClampMountMech;
import megamek.common.ClampMountTank;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.Flare;
import megamek.common.GameReports;
import megamek.common.GameTurn;
import megamek.common.HexTarget;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.INarcPod;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Minefield;
import megamek.common.MinefieldTarget;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.Report;
import megamek.common.TagInfo;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.Team;
import megamek.common.TurnOrdered;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.LayMinefieldAction;
import megamek.common.event.GameBoardChangeEvent;
import megamek.common.event.GameBoardNewEvent;
import megamek.common.event.GameEndEvent;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityNewOffboardEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameMapQueryEvent;
import megamek.common.event.GameNewActionEvent;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GamePlayerConnectedEvent;
import megamek.common.event.GamePlayerDisconnectedEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.options.GameOptions;
import megamek.debug.Assert;

public class Game
implements Serializable,
IGame {
    private GameOptions options = new GameOptions();
    public IBoard board = new Board();
    private Vector entities = new Vector();
    private Hashtable entityIds = new Hashtable();
    private Vector vOutOfGame = new Vector();
    private Vector players = new Vector();
    private Vector teams = new Vector();
    private Hashtable playerIds = new Hashtable();
    private boolean deploymentComplete = false;
    private int windDirection = -1;
    private int windStrength = -1;
    private String stringWindDirection;
    private String stringWindStrength;
    private int roundCount = 0;
    private Vector turnVector = new Vector();
    private int turnIndex = 0;
    private int phase = -1;
    private int lastPhase = -1;
    private Vector actions = new Vector();
    private Vector pendingCharges = new Vector();
    private Vector pendingLayMinefieldActions = new Vector();
    private Vector pilotRolls = new Vector();
    private Vector extremeGravityRolls = new Vector();
    private Vector initiativeRerollRequests = new Vector();
    private GameReports gameReports = new GameReports();
    private boolean forceVictory = false;
    private int victoryPlayerId = -1;
    private int victoryTeam = 0;
    private Hashtable deploymentTable = new Hashtable();
    private int lastDeploymentRound = 0;
    private Hashtable minefields = new Hashtable();
    private Vector vibrabombs = new Vector();
    private Vector offboardArtilleryAttacks = new Vector();
    private int lastEntityId;
    private Vector tagInfoForTurn = new Vector();
    private Vector flares = new Vector();
    private Vector gameListeners = new Vector();

    public IBoard getBoard() {
        return this.board;
    }

    public void setBoard(IBoard iBoard) {
        IBoard iBoard2 = this.board;
        this.board = iBoard;
        this.processGameEvent(new GameBoardNewEvent(this, iBoard2, iBoard));
    }

    public boolean containsMinefield(Coords coords) {
        return this.minefields.containsKey(coords);
    }

    public Vector getMinefields(Coords coords) {
        Vector vector = (Vector)this.minefields.get(coords);
        if (vector == null) {
            return new Vector();
        }
        return vector;
    }

    public int getNbrMinefields(Coords coords) {
        Vector vector = (Vector)this.minefields.get(coords);
        if (vector == null) {
            return 0;
        }
        return vector.size();
    }

    public Enumeration getMinedCoords() {
        return this.minefields.keys();
    }

    public void addMinefield(Minefield minefield) {
        this.addMinefieldHelper(minefield);
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    public void addMinefields(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Minefield minefield = (Minefield)vector.elementAt(i);
            this.addMinefieldHelper(minefield);
        }
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    public void setMinefields(Vector vector) {
        this.clearMinefieldsHelper();
        for (int i = 0; i < vector.size(); ++i) {
            Minefield minefield = (Minefield)vector.elementAt(i);
            this.addMinefieldHelper(minefield);
        }
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    protected void addMinefieldHelper(Minefield minefield) {
        Vector<Minefield> vector = (Vector<Minefield>)this.minefields.get(minefield.getCoords());
        if (vector == null) {
            vector = new Vector<Minefield>();
            vector.addElement(minefield);
            this.minefields.put(minefield.getCoords(), vector);
            return;
        }
        vector.addElement(minefield);
    }

    public void removeMinefield(Minefield minefield) {
        this.removeMinefieldHelper(minefield);
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    public void removeMinefieldHelper(Minefield minefield) {
        Vector vector = (Vector)this.minefields.get(minefield.getCoords());
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = (Minefield)enumeration.nextElement();
            if (!minefield2.equals(minefield)) continue;
            vector.removeElement(minefield2);
            break;
        }
        if (vector.isEmpty()) {
            this.minefields.remove(minefield.getCoords());
        }
    }

    public void clearMinefields() {
        this.clearMinefieldsHelper();
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    protected void clearMinefieldsHelper() {
        this.minefields.clear();
    }

    public Vector getVibrabombs() {
        return this.vibrabombs;
    }

    public void addVibrabomb(Minefield minefield) {
        this.vibrabombs.addElement(minefield);
    }

    public void removeVibrabomb(Minefield minefield) {
        this.vibrabombs.removeElement(minefield);
    }

    public boolean containsVibrabomb(Minefield minefield) {
        return this.vibrabombs.contains(minefield);
    }

    public GameOptions getOptions() {
        return this.options;
    }

    public void setOptions(GameOptions gameOptions) {
        if (null == gameOptions) {
            System.err.println("Can't set the game options to null!");
        } else {
            this.options = gameOptions;
            this.processGameEvent(new GameSettingsChangeEvent(this));
        }
    }

    public Enumeration getTeams() {
        return this.teams.elements();
    }

    public int getNoOfTeams() {
        return this.teams.size();
    }

    public Vector getTeamsVector() {
        return (Vector)this.teams.clone();
    }

    public Team getTeamForPlayer(Player player) {
        Enumeration enumeration = this.teams.elements();
        while (enumeration.hasMoreElements()) {
            Team team = (Team)enumeration.nextElement();
            Enumeration enumeration2 = team.getPlayers();
            while (enumeration2.hasMoreElements()) {
                Player player2 = (Player)enumeration2.nextElement();
                if (player != player2) continue;
                return team;
            }
        }
        return null;
    }

    public void setupTeams() {
        Object object;
        TurnOrdered turnOrdered;
        Vector<Object> vector = new Vector<Object>();
        boolean bl = this.getOptions().getOption("team_initiative").booleanValue();
        Enumeration enumeration = this.getPlayers();
        while (enumeration.hasMoreElements()) {
            turnOrdered = (Player)enumeration.nextElement();
            if (bl && turnOrdered.getTeam() != 0) continue;
            object = new Team(0);
            ((Team)object).addPlayer((Player)turnOrdered);
            vector.addElement(object);
        }
        if (bl) {
            for (int i = 1; i < Player.MAX_TEAMS; ++i) {
                turnOrdered = null;
                object = this.getPlayers();
                while (object.hasMoreElements()) {
                    Player player = (Player)object.nextElement();
                    if (player.getTeam() != i) continue;
                    if (turnOrdered == null) {
                        turnOrdered = new Team(i);
                    }
                    ((Team)turnOrdered).addPlayer(player);
                }
                if (turnOrdered == null) continue;
                vector.addElement(turnOrdered);
            }
        }
        this.teams = vector;
    }

    public Enumeration getPlayers() {
        return this.players.elements();
    }

    public Vector getPlayersVector() {
        return this.players;
    }

    public int getNoOfPlayers() {
        return this.players.size();
    }

    public Player getPlayer(int n) {
        if (-1 == n) {
            return null;
        }
        return (Player)this.playerIds.get(new Integer(n));
    }

    public void addPlayer(int n, Player player) {
        player.setGame(this);
        this.players.addElement(player);
        this.playerIds.put(new Integer(n), player);
        this.updatePlayer(player);
    }

    public void setPlayer(int n, Player player) {
        Player player2 = this.getPlayer(n);
        player.setGame(this);
        this.players.setElementAt(player, this.players.indexOf(player2));
        this.playerIds.put(new Integer(n), player);
        this.updatePlayer(player);
    }

    protected void updatePlayer(Player player) {
        this.processGameEvent(new GamePlayerChangeEvent((Object)this, player));
    }

    public void removePlayer(int n) {
        Player player = this.getPlayer(n);
        this.players.removeElement(player);
        this.playerIds.remove(new Integer(n));
        this.processGameEvent(new GamePlayerChangeEvent((Object)this, player));
    }

    public int getEntitiesOwnedBy(Player player) {
        int n = 0;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().equals(player)) continue;
            ++n;
        }
        return n;
    }

    public int getLiveEntitiesOwnedBy(Player player) {
        int n = 0;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().equals(player) || entity.isDestroyed()) continue;
            ++n;
        }
        return n;
    }

    public int getLiveDeployedEntitiesOwnedBy(Player player) {
        int n = 0;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().equals(player) || entity.isDestroyed() || !entity.isDeployed() || entity.isOffBoard() || entity.isCaptured()) continue;
            ++n;
        }
        return n;
    }

    public boolean hasTacticalGenius(Player player) {
        boolean bl = false;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.getCrew().getOptions().booleanOption("tactical_genius") || !entity.getOwner().equals(player) || entity.isDestroyed() || !entity.isDeployed() || entity.getCrew().isUnconscious()) continue;
            return true;
        }
        return false;
    }

    public int getTemperatureDifference() {
        int n = 0;
        if (this.getOptions().intOption("temperature") >= -30 && this.getOptions().intOption("temperature") <= 50) {
            return n;
        }
        if (this.getOptions().intOption("temperature") < -30) {
            while (this.getOptions().intOption("temperature") + ++n * 10 < -30) {
            }
            return n;
        }
        while (this.getOptions().intOption("temperature") - ++n * 10 > 50) {
        }
        return n;
    }

    public Vector getValidTargets(Entity entity) {
        Vector<Entity> vector = new Vector<Entity>();
        boolean bl = this.getOptions().booleanOption("friendly_fire");
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            if (entity2.getPosition() == null || entity2.isOffBoard() || !entity.isEnemyOf(entity2) && (!bl || entity.getId() == entity2.getId())) continue;
            vector.addElement(entity2);
        }
        return vector;
    }

    public boolean phaseHasTurns(int n) {
        switch (n) {
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    public GameTurn getTurn() {
        if (this.turnIndex < 0 || this.turnIndex >= this.turnVector.size()) {
            return null;
        }
        return (GameTurn)this.turnVector.elementAt(this.turnIndex);
    }

    public GameTurn changeToNextTurn() {
        ++this.turnIndex;
        return this.getTurn();
    }

    public void resetTurnIndex() {
        this.turnIndex = -1;
    }

    public boolean hasMoreTurns() {
        return this.turnVector.size() > this.turnIndex + 1;
    }

    public void insertNextTurn(GameTurn gameTurn) {
        this.turnVector.insertElementAt(gameTurn, this.turnIndex + 1);
    }

    public Enumeration getTurns() {
        return this.turnVector.elements();
    }

    public int getTurnIndex() {
        return this.turnIndex;
    }

    public void setTurnIndex(int n) {
        this.turnIndex = n;
        this.processGameEvent(new GameTurnChangeEvent((Object)this, this.getPlayer(this.getTurn().getPlayerNum())));
    }

    public Vector getTurnVector() {
        return this.turnVector;
    }

    public void setTurnVector(Vector vector) {
        this.turnVector = vector;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int n) {
        int n2 = this.phase;
        this.phase = n;
        switch (n) {
            case 1: {
                this.reset();
                break;
            }
            case 8: {
                this.resetActions();
                break;
            }
            case 12: {
                this.resetActions();
                break;
            }
            case 14: {
                this.resetActions();
                break;
            }
            case 5: {
                this.resetActions();
                this.resetCharges();
                this.resetLayMinefieldActions();
                break;
            }
            case 15: 
            case 16: {
                this.resetCharges();
                this.resetLayMinefieldActions();
            }
        }
        this.processGameEvent(new GamePhaseChangeEvent(this, n2, n));
    }

    public int getLastPhase() {
        return this.lastPhase;
    }

    public void setLastPhase(int n) {
        this.lastPhase = n;
    }

    public void setDeploymentComplete(boolean bl) {
        this.deploymentComplete = bl;
    }

    public boolean isDeploymentComplete() {
        return this.deploymentComplete;
    }

    public void setupRoundDeployment() {
        this.deploymentTable = new Hashtable();
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity entity = (Entity)this.entities.elementAt(i);
            if (entity.isDeployed()) continue;
            Vector<Entity> vector = (Vector<Entity>)this.deploymentTable.get(new Integer(entity.getDeployRound()));
            if (null == vector) {
                vector = new Vector<Entity>();
                this.deploymentTable.put(new Integer(entity.getDeployRound()), vector);
            }
            vector.addElement(entity);
            this.lastDeploymentRound = Math.max(this.lastDeploymentRound, entity.getDeployRound());
        }
    }

    public void checkForCompleteDeployment() {
        this.setDeploymentComplete(this.lastDeploymentRound < this.getRoundCount());
    }

    public boolean shouldDeployThisRound() {
        return this.shouldDeployForRound(this.getRoundCount());
    }

    public boolean shouldDeployForRound(int n) {
        Vector vector = this.getEntitiesToDeployForRound(n);
        return null != vector && vector.size() != 0;
    }

    private Vector getEntitiesToDeployForRound(int n) {
        return (Vector)this.deploymentTable.get(new Integer(n));
    }

    public void clearDeploymentThisRound() {
        this.deploymentTable.remove(new Integer(this.getRoundCount()));
    }

    public Vector getUndeployedEntities() {
        Vector vector = new Vector();
        Enumeration enumeration = this.deploymentTable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration.nextElement();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addElement(vector2.elementAt(i));
            }
        }
        return vector;
    }

    public Enumeration getEntities() {
        return this.entities.elements();
    }

    public Entity getPreviousEntityFromList(Entity entity) {
        if (entity != null && this.entities != null && this.entities.contains(entity)) {
            int n = this.entities.indexOf(entity) - 1;
            if (n < 0) {
                n = this.entities.size() - 1;
            }
            return (Entity)this.entities.elementAt(n);
        }
        return null;
    }

    public Entity getNextEntityFromList(Entity entity) {
        if (entity != null && this.entities != null && this.entities.contains(entity)) {
            int n = this.entities.indexOf(entity) + 1;
            if (n >= this.entities.size()) {
                n = 0;
            }
            return (Entity)this.entities.elementAt(n);
        }
        return null;
    }

    public Vector getEntitiesVector() {
        return this.entities;
    }

    public void setEntitiesVector(Vector vector) {
        this.entities = vector;
        this.reindexEntities();
        this.processGameEvent(new GameEntityNewEvent((Object)this, vector));
    }

    public Vector getOutOfGameEntitiesVector() {
        return this.vOutOfGame;
    }

    public void setOutOfGameEntitiesVector(Vector vector) {
        Assert.assertTrue(vector != null, "New out-of-game list should not be null.");
        Vector<Entity> vector2 = new Vector<Entity>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            int n = entity.getOwnerId();
            if (n == -1 || this.getPlayer(n) == null) continue;
            entity.setGame(this);
            vector2.addElement(entity);
        }
        this.vOutOfGame = vector2;
        this.processGameEvent(new GameEntityNewOffboardEvent(this));
    }

    public Entity getOutOfGameEntity(int n) {
        Entity entity = null;
        Enumeration enumeration = this.vOutOfGame.elements();
        while (null == entity && enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            if (n != entity2.getId()) continue;
            entity = entity2;
        }
        return entity;
    }

    public Vector getC3NetworkMembers(Entity entity) {
        Vector<Entity> vector = new Vector<Entity>();
        if (entity != null && (entity.hasC3() || entity.hasC3i())) {
            Enumeration enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity2 = (Entity)enumeration.nextElement();
                if (!entity.equals(entity2) && !entity.onSameC3NetworkAs(entity2)) continue;
                vector.addElement(entity2);
            }
        }
        return vector;
    }

    public Vector getC3SubNetworkMembers(Entity entity) {
        if (entity == null || entity.hasC3i() || entity.C3MasterIs(entity)) {
            return this.getC3NetworkMembers(entity);
        }
        Vector<Entity> vector = new Vector<Entity>();
        if (entity.hasC3()) {
            Enumeration enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity2 = (Entity)enumeration.nextElement();
                if (!entity.equals(entity2) && !entity2.C3MasterIs(entity)) continue;
                vector.addElement(entity2);
            }
        }
        return vector;
    }

    public Hashtable getPositionMap() {
        Hashtable<Coords, Vector<Entity>> hashtable = new Hashtable<Coords, Vector<Entity>>();
        Vector<Entity> vector = null;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            Coords coords = entity.getPosition();
            if (coords == null) continue;
            vector = (Vector<Entity>)hashtable.get(coords);
            if (vector == null) {
                vector = new Vector<Entity>();
                hashtable.put(coords, vector);
            }
            vector.addElement(entity);
        }
        return hashtable;
    }

    public Enumeration getGraveyardEntities() {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getRemovalCondition() != 512 && entity.getRemovalCondition() != 528) continue;
            vector.addElement(entity);
        }
        return vector.elements();
    }

    public Enumeration getWreckedEntities() {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getRemovalCondition() != 512 && entity.getRemovalCondition() != 528 && entity.getRemovalCondition() != 1024) continue;
            vector.addElement(entity);
        }
        return vector.elements();
    }

    public Enumeration getRetreatedEntities() {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getRemovalCondition() != 256 && entity.getRemovalCondition() != 288 && entity.getRemovalCondition() != 272) continue;
            vector.addElement(entity);
        }
        return vector.elements();
    }

    public Enumeration getDevastatedEntities() {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getRemovalCondition() != 1024) continue;
            vector.addElement(entity);
        }
        return vector.elements();
    }

    public int getNoOfEntities() {
        return this.entities.size();
    }

    public Targetable getTarget(int n, int n2) {
        try {
            switch (n) {
                case 0: {
                    return this.getEntity(n2);
                }
                case 1: 
                case 2: 
                case 6: 
                case 13: 
                case 14: {
                    return new HexTarget(HexTarget.idToCoords(n2), this.board, n);
                }
                case 3: 
                case 4: {
                    return new BuildingTarget(BuildingTarget.idToCoords(n2), this.board, n);
                }
                case 5: {
                    return new MinefieldTarget(MinefieldTarget.idToCoords(n2), this.board);
                }
                case 7: {
                    return new HexTarget(HexTarget.idToCoords(n2), this.board, n);
                }
                case 8: {
                    return new HexTarget(HexTarget.idToCoords(n2), this.board, n);
                }
                case 9: {
                    return new HexTarget(HexTarget.idToCoords(n2), this.board, n);
                }
                case 10: {
                    return new HexTarget(HexTarget.idToCoords(n2), this.board, n);
                }
                case 11: {
                    return INarcPod.idToInstance(n2);
                }
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Entity getEntity(int n) {
        return (Entity)this.entityIds.get(new Integer(n));
    }

    public void addEntity(int n, Entity entity) {
        entity.setGame(this);
        this.entities.addElement(entity);
        this.entityIds.put(new Integer(n), entity);
        if (n > this.lastEntityId) {
            this.lastEntityId = n;
        }
        Assert.assertTrue(this.entities.size() == this.entityIds.size());
        this.processGameEvent(new GameEntityNewEvent((Object)this, entity));
    }

    public void setEntity(int n, Entity entity) {
        this.setEntity(n, entity, null);
        Assert.assertTrue(this.entities.size() == this.entityIds.size());
    }

    public void setEntity(int n, Entity entity, Vector vector) {
        Entity entity2 = this.getEntity(n);
        if (entity2 == null) {
            this.addEntity(n, entity);
        } else {
            entity.setGame(this);
            this.entities.setElementAt(entity, this.entities.indexOf(entity2));
            this.entityIds.put(new Integer(n), entity);
            if (n > this.lastEntityId) {
                this.lastEntityId = n;
            }
            this.processGameEvent(new GameEntityChangeEvent((Object)this, entity, vector));
        }
        Assert.assertTrue(this.entities.size() == this.entityIds.size());
    }

    public int getNextEntityId() {
        return this.lastEntityId + 1;
    }

    public boolean hasEntity(int n) {
        return this.entityIds.containsKey(new Integer(n));
    }

    public void removeEntity(int n, int n2) {
        Entity entity = this.getEntity(n);
        if (entity == null) {
            return;
        }
        this.entities.removeElement(entity);
        this.entityIds.remove(new Integer(n));
        entity.setRemovalCondition(n2);
        if (this.vOutOfGame != null && n2 != 2048) {
            this.vOutOfGame.addElement(entity);
        }
        if (this.deploymentTable.size() > 0) {
            Enumeration enumeration = this.deploymentTable.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = (Vector)enumeration.nextElement();
                for (int i = vector.size() - 1; i >= 0; --i) {
                    Entity entity2 = (Entity)vector.elementAt(i);
                    if (entity2.getId() != n) continue;
                    vector.removeElementAt(i);
                }
            }
        }
        this.processGameEvent(new GameEntityRemoveEvent((Object)this, entity));
    }

    public void reset() {
        this.roundCount = 0;
        this.entities.removeAllElements();
        this.entityIds.clear();
        this.vOutOfGame.removeAllElements();
        this.resetActions();
        this.resetCharges();
        this.resetPSRs();
        this.resetArtilleryAttacks();
        this.removeMinefields();
        this.removeArtyAutoHitHexes();
        this.resetLayMinefieldActions();
        this.flares.removeAllElements();
        this.clearAllReports();
        this.forceVictory = false;
        this.victoryPlayerId = -1;
        this.victoryTeam = 0;
    }

    private void removeArtyAutoHitHexes() {
        Enumeration enumeration = this.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            player.removeArtyAutoHitHexes();
        }
    }

    private void removeMinefields() {
        this.minefields.clear();
        this.vibrabombs.removeAllElements();
        Enumeration enumeration = this.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            player.removeMinefields();
        }
    }

    private void reindexEntities() {
        this.entityIds.clear();
        this.lastEntityId = 0;
        if (this.entities != null) {
            Enumeration enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity = (Entity)enumeration.nextElement();
                int n = entity.getId();
                this.entityIds.put(new Integer(n), entity);
                entity.setGame(this);
                if (n <= this.lastEntityId) continue;
                this.lastEntityId = n;
            }
        }
    }

    public Entity getFirstEntity(Coords coords) {
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!coords.equals(entity.getPosition()) || !entity.isTargetable()) continue;
            return entity;
        }
        return null;
    }

    public Entity getFirstEnemyEntity(Coords coords, Entity entity) {
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            if (!coords.equals(entity2.getPosition()) || !entity2.isTargetable() || !entity2.isEnemyOf(entity)) continue;
            return entity2;
        }
        return null;
    }

    public Enumeration getEntities(Coords coords) {
        Vector<Entity> vector = new Vector<Entity>();
        if (this.board.contains(coords)) {
            Enumeration enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity = (Entity)enumeration.nextElement();
                if (!coords.equals(entity.getPosition()) || !entity.isTargetable()) continue;
                vector.addElement(entity);
            }
        }
        return vector.elements();
    }

    public Entity getAffaTarget(Coords coords) {
        Vector<Entity> vector = new Vector<Entity>();
        if (this.board.contains(coords)) {
            Enumeration enumeration = this.entities.elements();
            while (enumeration.hasMoreElements()) {
                Entity entity = (Entity)enumeration.nextElement();
                if (!coords.equals(entity.getPosition()) || !entity.isTargetable() || entity instanceof Infantry) continue;
                vector.addElement(entity);
            }
        }
        if (!vector.isEmpty()) {
            int n = vector.size();
            int n2 = Compute.randomInt(n);
            return (Entity)vector.elementAt(n2);
        }
        return null;
    }

    public Enumeration getEnemyEntities(final Coords coords, final Entity entity) {
        return this.getSelectedEntities(new EntitySelector(){
            private Coords coords;
            private Entity friendly;
            {
                this.coords = coords;
                this.friendly = entity;
            }

            public boolean accept(Entity entity2) {
                return this.coords.equals(entity2.getPosition()) && entity2.isTargetable() && entity2.isEnemyOf(this.friendly);
            }
        });
    }

    public Enumeration getFriendlyEntities(final Coords coords, final Entity entity) {
        return this.getSelectedEntities(new EntitySelector(){
            private Coords coords;
            private Entity friendly;
            {
                this.coords = coords;
                this.friendly = entity;
            }

            public boolean accept(Entity entity2) {
                return this.coords.equals(entity2.getPosition()) && entity2.isTargetable() && !entity2.isEnemyOf(this.friendly);
            }
        });
    }

    public void moveToGraveyard(int n) {
        this.removeEntity(n, 512);
    }

    public boolean isOutOfGame(int n) {
        Enumeration enumeration = this.vOutOfGame.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getId() != n) continue;
            return true;
        }
        return false;
    }

    public boolean isOutOfGame(Entity entity) {
        return this.isOutOfGame(entity.getId());
    }

    public Entity getFirstEntity() {
        return this.getFirstEntity(this.getTurn());
    }

    public Entity getFirstEntity(GameTurn gameTurn) {
        return this.getEntity(this.getFirstEntityNum(this.getTurn()));
    }

    public int getFirstEntityNum() {
        return this.getFirstEntityNum(this.getTurn());
    }

    public int getFirstEntityNum(GameTurn gameTurn) {
        if (gameTurn == null) {
            return -1;
        }
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!gameTurn.isValidEntity(entity, this)) continue;
            return entity.getId();
        }
        return -1;
    }

    public Entity getNextEntity(int n) {
        return this.getEntity(this.getNextEntityNum(this.getTurn(), n));
    }

    public int getNextEntityNum(int n) {
        return this.getNextEntityNum(this.getTurn(), n);
    }

    public int getNextEntityNum(GameTurn gameTurn, int n) {
        boolean bl = false;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getId() == n) {
                bl = true;
                continue;
            }
            if (!bl || !gameTurn.isValidEntity(entity, this)) continue;
            return entity.getId();
        }
        return this.getFirstEntityNum(gameTurn);
    }

    public int getFirstDeployableEntityNum() {
        return this.getFirstDeployableEntityNum(this.getTurn());
    }

    public int getFirstDeployableEntityNum(GameTurn gameTurn) {
        if (gameTurn == null) {
            return -1;
        }
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!gameTurn.isValidEntity(entity, this) || !entity.shouldDeploy(this.getRoundCount())) continue;
            return entity.getId();
        }
        return -1;
    }

    public int getNextDeployableEntityNum(int n) {
        return this.getNextDeployableEntityNum(this.getTurn(), n);
    }

    public int getNextDeployableEntityNum(GameTurn gameTurn, int n) {
        boolean bl = false;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getId() == n) {
                bl = true;
                continue;
            }
            if (!bl || !gameTurn.isValidEntity(entity, this) || !entity.shouldDeploy(this.getRoundCount())) continue;
            return entity.getId();
        }
        return this.getFirstDeployableEntityNum(gameTurn);
    }

    public void determineWind() {
        String[] stringArray = new String[]{"North", "Northeast", "Southeast", "South", "Southwest", "Northwest"};
        String[] stringArray2 = new String[]{"Calm", "Light", "Moderate", "High"};
        if (this.windDirection == -1) {
            this.windDirection = Compute.d6(1) - 1;
        } else if (this.getOptions().booleanOption("maxtech_fire")) {
            switch (Compute.d6()) {
                case 1: {
                    this.windDirection = (this.windDirection + 1) % 6;
                    break;
                }
                case 6: {
                    this.windDirection = (this.windDirection + 5) % 6;
                }
            }
        }
        if (this.getOptions().booleanOption("maxtech_fire")) {
            if (this.windStrength == -1) {
                switch (Compute.d6()) {
                    case 1: {
                        this.windStrength = 0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.windStrength = 1;
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.windStrength = 2;
                        break;
                    }
                    case 6: {
                        this.windStrength = 3;
                    }
                }
            } else {
                switch (Compute.d6()) {
                    case 1: {
                        if (this.windStrength <= 0) break;
                        --this.windStrength;
                        break;
                    }
                    case 6: {
                        if (this.windStrength >= 3) break;
                        ++this.windStrength;
                    }
                }
            }
            this.stringWindStrength = stringArray2[this.windStrength];
        }
        this.stringWindDirection = stringArray[this.windDirection];
    }

    public int getWindDirection() {
        return this.windDirection;
    }

    public String getStringWindDirection() {
        return this.stringWindDirection;
    }

    public int getWindStrength() {
        return this.windStrength;
    }

    public String getStringWindStrength() {
        return this.stringWindStrength;
    }

    public Vector getPlayerEntities(Player player) {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!player.equals(entity.getOwner())) continue;
            vector.addElement(entity);
        }
        return vector;
    }

    public boolean isEntityStranded(Entity entity) {
        int n = entity.getTransportId();
        Entity entity2 = this.getEntity(n);
        return -1 != n && null != entity2 && (entity2.isImmobile() || 0 == entity2.getWalkMP());
    }

    public int getInfantryLeft(int n) {
        Player player = this.getPlayer(n);
        int n2 = 0;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!player.equals(entity.getOwner()) || !entity.isSelectableThisTurn() || !(entity instanceof Infantry)) continue;
            ++n2;
        }
        return n2;
    }

    public int getProtomechsLeft(int n) {
        Player player = this.getPlayer(n);
        int n2 = 0;
        Enumeration enumeration = this.entities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!player.equals(entity.getOwner()) || !entity.isSelectableThisTurn() || !(entity instanceof Protomech)) continue;
            ++n2;
        }
        return n2;
    }

    public void removeTurnFor(Entity entity) {
        for (int i = this.turnVector.size() - 1; i >= this.turnIndex; --i) {
            GameTurn gameTurn = (GameTurn)this.turnVector.elementAt(i);
            if (!gameTurn.isValidEntity(entity, this)) continue;
            this.turnVector.removeElementAt(i);
            break;
        }
    }

    public boolean checkForMagneticClamp() {
        Player player = null;
        Entity entity = null;
        Hashtable<Player, Boolean> hashtable = null;
        Enumeration enumeration = null;
        Mounted mounted = null;
        String string = null;
        boolean bl = false;
        hashtable = new Hashtable<Player, Boolean>(this.getNoOfPlayers());
        Enumeration enumeration2 = this.entities.elements();
        block0: while (enumeration2.hasMoreElements()) {
            entity = (Entity)enumeration2.nextElement();
            if (!(entity instanceof BattleArmor)) continue;
            enumeration = entity.getMisc();
            while (enumeration.hasMoreElements()) {
                mounted = (Mounted)enumeration.nextElement();
                string = mounted.getType().getInternalName();
                if (!"BA-Magnetic Clamp".equals(string)) continue;
                bl = true;
                hashtable.put(entity.getOwner(), Boolean.TRUE);
                continue block0;
            }
        }
        if (bl) {
            enumeration2 = this.entities.elements();
            while (enumeration2.hasMoreElements()) {
                entity = (Entity)enumeration2.nextElement();
                player = entity.getOwner();
                if (!Boolean.TRUE.equals(hashtable.get(player))) continue;
                if (!entity.isOmni() && entity instanceof Mech) {
                    entity.addTransporter(new ClampMountMech());
                    continue;
                }
                if (!(entity instanceof Tank)) continue;
                entity.addTransporter(new ClampMountTank());
            }
        }
        return bl;
    }

    public void addAction(EntityAction entityAction) {
        this.actions.addElement(entityAction);
        this.processGameEvent(new GameNewActionEvent((Object)this, entityAction));
    }

    public void addArtilleryAttack(ArtilleryAttackAction artilleryAttackAction) {
        this.offboardArtilleryAttacks.addElement(artilleryAttackAction);
    }

    public void removeArtilleryAttack(ArtilleryAttackAction artilleryAttackAction) {
        this.offboardArtilleryAttacks.removeElement(artilleryAttackAction);
    }

    public Vector getArtilleryVector() {
        return this.offboardArtilleryAttacks;
    }

    public void setArtilleryVector(Vector vector) {
        this.offboardArtilleryAttacks = vector;
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    public void resetArtilleryAttacks() {
        this.offboardArtilleryAttacks.removeAllElements();
    }

    public Enumeration getArtilleryAttacks() {
        return this.offboardArtilleryAttacks.elements();
    }

    public int getArtillerySize() {
        return this.offboardArtilleryAttacks.size();
    }

    public Enumeration getActions() {
        return this.actions.elements();
    }

    public void resetActions() {
        this.actions.removeAllElements();
    }

    public void removeActionsFor(int n) {
        Vector<EntityAction> vector = new Vector<EntityAction>(this.actions.size());
        Enumeration enumeration = this.actions.elements();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            if (entityAction.getEntityId() == n) continue;
            vector.addElement(entityAction);
        }
        this.actions = vector;
    }

    public void removeAction(Object object) {
        this.actions.removeElement(object);
    }

    public int actionsSize() {
        return this.actions.size();
    }

    public Vector getActionsVector() {
        return this.actions;
    }

    public void addInitiativeRerollRequest(Team team) {
        this.initiativeRerollRequests.addElement(team);
    }

    public void rollInitAndResolveTies() {
        TurnOrdered.rollInitAndResolveTies(this.teams, this.initiativeRerollRequests);
        this.initiativeRerollRequests.removeAllElements();
    }

    public int getNoOfInitiativeRerollRequests() {
        return this.initiativeRerollRequests.size();
    }

    public void addCharge(AttackAction attackAction) {
        this.pendingCharges.addElement(attackAction);
        this.processGameEvent(new GameNewActionEvent((Object)this, attackAction));
    }

    public Enumeration getCharges() {
        return this.pendingCharges.elements();
    }

    public void resetCharges() {
        this.pendingCharges.removeAllElements();
    }

    public Vector getChargesVector() {
        return this.pendingCharges;
    }

    public void addLayMinefieldAction(LayMinefieldAction layMinefieldAction) {
        this.pendingLayMinefieldActions.addElement(layMinefieldAction);
        this.processGameEvent(new GameNewActionEvent((Object)this, layMinefieldAction));
    }

    public Enumeration getLayMinefieldActions() {
        return this.pendingLayMinefieldActions.elements();
    }

    public void resetLayMinefieldActions() {
        this.pendingLayMinefieldActions.removeAllElements();
    }

    public Vector getLayMinefieldActionsVector() {
        return this.pendingLayMinefieldActions;
    }

    public void addPSR(PilotingRollData pilotingRollData) {
        this.pilotRolls.addElement(pilotingRollData);
    }

    public Enumeration getPSRs() {
        return this.pilotRolls.elements();
    }

    public void addExtremeGravityPSR(PilotingRollData pilotingRollData) {
        this.extremeGravityRolls.addElement(pilotingRollData);
    }

    public Enumeration getExtremeGravityPSRs() {
        return this.extremeGravityRolls.elements();
    }

    public void resetPSRs(Entity entity) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        for (n = 0; n < this.pilotRolls.size(); ++n) {
            PilotingRollData pilotingRollData = (PilotingRollData)this.pilotRolls.elementAt(n);
            if (pilotingRollData.getEntityId() != entity.getId()) continue;
            vector.addElement(new Integer(n));
        }
        for (n = vector.size() - 1; n > -1; --n) {
            this.pilotRolls.removeElementAt((Integer)vector.elementAt(n));
        }
    }

    public void resetExtremeGravityPSRs() {
        this.extremeGravityRolls.removeAllElements();
    }

    public void resetExtremeGravityPSRs(Entity entity) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        for (n = 0; n < this.extremeGravityRolls.size(); ++n) {
            PilotingRollData pilotingRollData = (PilotingRollData)this.extremeGravityRolls.elementAt(n);
            if (pilotingRollData.getEntityId() != entity.getId()) continue;
            vector.addElement(new Integer(n));
        }
        for (n = vector.size() - 1; n > -1; --n) {
            this.extremeGravityRolls.removeElementAt((Integer)vector.elementAt(n));
        }
    }

    public void resetPSRs() {
        this.pilotRolls.removeAllElements();
    }

    public int getRoundCount() {
        return this.roundCount;
    }

    public void setRoundCount(int n) {
        this.roundCount = n;
    }

    public void incrementRoundCount() {
        ++this.roundCount;
    }

    public boolean isForceVictory() {
        return this.forceVictory;
    }

    public void setForceVictory(boolean bl) {
        this.forceVictory = bl;
    }

    public void addReports(Vector vector) {
        if (vector.size() == 0) {
            System.out.println("Game.addReports() received blank vector.");
            return;
        }
        this.gameReports.add(this.roundCount, vector);
    }

    public Vector getReports(int n) {
        return this.gameReports.get(n);
    }

    public Vector getAllReports() {
        return this.gameReports.get();
    }

    public void setAllReports(Vector vector) {
        this.gameReports.set(vector);
    }

    public void clearAllReports() {
        this.gameReports.clear();
    }

    public void end(int n, int n2) {
        this.setVictoryPlayerId(n);
        this.setVictoryTeam(n2);
        this.processGameEvent(new GameEndEvent(this));
    }

    public int getVictoryPlayerId() {
        return this.victoryPlayerId;
    }

    public void setVictoryPlayerId(int n) {
        this.victoryPlayerId = n;
    }

    public int getVictoryTeam() {
        return this.victoryTeam;
    }

    public void setVictoryTeam(int n) {
        this.victoryTeam = n;
    }

    public boolean isPlayerVictor(Player player) {
        if (player.getTeam() == 0) {
            return player.getId() == this.victoryPlayerId;
        }
        return player.getTeam() == this.victoryTeam;
    }

    public boolean isPlayerVictor(int n) {
        return this.isPlayerVictor(this.getPlayer(n));
    }

    public Enumeration getSelectedEntities(EntitySelector entitySelector) {
        Enumeration enumeration;
        if (null == entitySelector) {
            enumeration = this.getEntities();
        } else {
            final EntitySelector entitySelector2 = entitySelector;
            enumeration = new Enumeration(){
                private EntitySelector selector;
                private Entity current;
                private Enumeration iter;
                {
                    this.selector = entitySelector2;
                    this.current = null;
                    this.iter = Game.this.getEntities();
                }

                public boolean hasMoreElements() {
                    if (null == this.current) {
                        while (null == this.current && this.iter.hasMoreElements()) {
                            this.current = (Entity)this.iter.nextElement();
                            if (this.selector.accept(this.current)) continue;
                            this.current = null;
                        }
                    }
                    return null != this.current;
                }

                public Object nextElement() {
                    if (!this.hasMoreElements()) {
                        return null;
                    }
                    Entity entity = this.current;
                    this.current = null;
                    return entity;
                }
            };
        }
        return enumeration;
    }

    public int getSelectedEntityCount(EntitySelector entitySelector) {
        int n = 0;
        if (null == entitySelector) {
            n = this.getNoOfEntities();
        } else {
            Enumeration enumeration = this.getEntities();
            while (enumeration.hasMoreElements()) {
                if (!entitySelector.accept((Entity)enumeration.nextElement())) continue;
                ++n;
            }
        }
        return n;
    }

    public Enumeration getSelectedOutOfGameEntities(EntitySelector entitySelector) {
        Enumeration enumeration;
        if (null == entitySelector) {
            enumeration = this.vOutOfGame.elements();
        } else {
            final EntitySelector entitySelector2 = entitySelector;
            enumeration = new Enumeration(){
                private EntitySelector selector;
                private Entity current;
                private Enumeration iter;
                {
                    this.selector = entitySelector2;
                    this.current = null;
                    this.iter = Game.this.vOutOfGame.elements();
                }

                public boolean hasMoreElements() {
                    if (null == this.current) {
                        while (null == this.current && this.iter.hasMoreElements()) {
                            this.current = (Entity)this.iter.nextElement();
                            if (this.selector.accept(this.current)) continue;
                            this.current = null;
                        }
                    }
                    return null != this.current;
                }

                public Object nextElement() {
                    if (!this.hasMoreElements()) {
                        return null;
                    }
                    Entity entity = this.current;
                    this.current = null;
                    return entity;
                }
            };
        }
        return enumeration;
    }

    public int getSelectedOutOfGameEntityCount(EntitySelector entitySelector) {
        int n = 0;
        if (null == entitySelector) {
            n = this.vOutOfGame.size();
        } else {
            Enumeration enumeration = this.vOutOfGame.elements();
            while (enumeration.hasMoreElements()) {
                if (!entitySelector.accept((Entity)enumeration.nextElement())) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean checkForValidNonInfantryAndOrProtomechs(int n) {
        Vector vector = this.getPlayerEntities(this.getPlayer(n));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            boolean bl = false;
            if (entity instanceof Infantry && this.getOptions().booleanOption("inf_move_later")) {
                bl = true;
            } else if (entity instanceof Protomech && this.getOptions().booleanOption("protos_move_later")) {
                bl = true;
            }
            if (bl || !this.getTurn().isValidEntity(entity, this)) continue;
            return true;
        }
        return false;
    }

    public Enumeration getNemesisTargets(Entity entity, Coords coords) {
        Coords coords2 = entity.getPosition();
        Coords[] coordsArray = Coords.intervening(coords2, coords);
        Vector<Entity> vector = new Vector<Entity>();
        for (int i = 0; i < coordsArray.length; ++i) {
            Enumeration enumeration = this.getEntities(coordsArray[i]);
            while (enumeration.hasMoreElements()) {
                Entity entity2 = (Entity)enumeration.nextElement();
                if (!entity2.isINarcedWith(8L) || entity2.isEnemyOf(entity)) continue;
                vector.addElement(entity2);
            }
        }
        return vector.elements();
    }

    public void addGameListener(GameListener gameListener) {
        this.gameListeners.addElement(gameListener);
    }

    public void removeGameListener(GameListener gameListener) {
        this.gameListeners.removeElement(gameListener);
    }

    public void processGameEvent(GameEvent gameEvent) {
        Enumeration enumeration = this.gameListeners.elements();
        while (enumeration.hasMoreElements()) {
            GameListener gameListener = (GameListener)enumeration.nextElement();
            switch (gameEvent.getType()) {
                case 0: {
                    gameListener.gamePlayerConnected((GamePlayerConnectedEvent)gameEvent);
                    break;
                }
                case 1: {
                    gameListener.gamePlayerDisconnected((GamePlayerDisconnectedEvent)gameEvent);
                    break;
                }
                case 2: {
                    gameListener.gamePlayerChange((GamePlayerChangeEvent)gameEvent);
                    break;
                }
                case 3: {
                    gameListener.gamePlayerChat((GamePlayerChatEvent)gameEvent);
                    break;
                }
                case 4: {
                    gameListener.gamePhaseChange((GamePhaseChangeEvent)gameEvent);
                    break;
                }
                case 5: {
                    gameListener.gameTurnChange((GameTurnChangeEvent)gameEvent);
                    break;
                }
                case 6: {
                    gameListener.gameReport((GameReportEvent)gameEvent);
                    break;
                }
                case 7: {
                    gameListener.gameEnd((GameEndEvent)gameEvent);
                    break;
                }
                case 8: {
                    gameListener.gameBoardNew((GameBoardNewEvent)gameEvent);
                    break;
                }
                case 9: {
                    gameListener.gameBoardChanged((GameBoardChangeEvent)gameEvent);
                    break;
                }
                case 10: {
                    gameListener.gameSettingsChange((GameSettingsChangeEvent)gameEvent);
                    break;
                }
                case 11: {
                    gameListener.gameMapQuery((GameMapQueryEvent)gameEvent);
                    break;
                }
                case 12: {
                    gameListener.gameEntityNew((GameEntityNewEvent)gameEvent);
                    break;
                }
                case 13: {
                    gameListener.gameEntityRemove((GameEntityRemoveEvent)gameEvent);
                    break;
                }
                case 14: {
                    gameListener.gameEntityNewOffboard((GameEntityNewOffboardEvent)gameEvent);
                    break;
                }
                case 15: {
                    gameListener.gameEntityChange((GameEntityChangeEvent)gameEvent);
                    break;
                }
                case 16: {
                    gameListener.gameNewAction((GameNewActionEvent)gameEvent);
                }
            }
        }
    }

    public Vector getTagInfo() {
        return this.tagInfoForTurn;
    }

    public void addTagInfo(TagInfo tagInfo) {
        this.tagInfoForTurn.addElement(tagInfo);
    }

    public void updateTagInfo(TagInfo tagInfo, int n) {
        this.tagInfoForTurn.setElementAt(tagInfo, n);
    }

    public void resetTagInfo() {
        this.tagInfoForTurn.removeAllElements();
    }

    public void clearTagInfoShots(Entity entity, Coords coords) {
        for (int i = 0; i < this.tagInfoForTurn.size(); ++i) {
            TagInfo tagInfo = (TagInfo)this.tagInfoForTurn.elementAt(i);
            Entity entity2 = this.getEntity(tagInfo.attackerId);
            Entity entity3 = this.getEntity(tagInfo.targetId);
            if (entity.isEnemyOf(entity2) || !entity3.isOnSameSheet(coords)) continue;
            tagInfo.shots = 0;
            this.tagInfoForTurn.setElementAt(tagInfo, i);
        }
    }

    public Vector getFlares() {
        return this.flares;
    }

    public void setFlares(Vector vector) {
        this.flares = vector;
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    public void addFlare(Flare flare) {
        this.flares.addElement(flare);
        this.processGameEvent(new GameBoardChangeEvent(this));
    }

    public boolean isPositionIlluminated(Coords coords) {
        Enumeration enumeration = this.flares.elements();
        while (enumeration.hasMoreElements()) {
            Flare flare = (Flare)enumeration.nextElement();
            if (!flare.illuminates(coords)) continue;
            return true;
        }
        return false;
    }

    public Vector ageFlares() {
        Vector<Report> vector = new Vector<Report>();
        for (int i = this.flares.size() - 1; i >= 0; --i) {
            Flare flare = (Flare)this.flares.elementAt(i);
            Report report = new Report(5235);
            report.add(flare.position.getBoardNum());
            report.newlines = 0;
            vector.addElement(report);
            if ((flare.flags & Flare.F_IGNITED) != 0) {
                --flare.turnsToBurn;
                if ((flare.flags & Flare.F_DRIFTING) != 0) {
                    int n = this.getWindDirection();
                    int n2 = this.getWindStrength();
                    if (n2 > 0) {
                        flare.position = flare.position.translated(n);
                        if (n2 == 3) {
                            flare.position = flare.position.translated(n);
                        }
                        report = new Report(5236);
                        report.add(flare.position.getBoardNum());
                        report.newlines = 0;
                        vector.addElement(report);
                    }
                }
            } else {
                report = new Report(5237);
                report.newlines = 0;
                vector.addElement(report);
                flare.flags |= Flare.F_IGNITED;
            }
            if (flare.turnsToBurn <= 0) {
                report = new Report(5238);
                vector.addElement(report);
                this.flares.removeElementAt(i);
                continue;
            }
            report = new Report(5239);
            report.add(flare.turnsToBurn);
            vector.addElement(report);
            this.flares.setElementAt(flare, i);
        }
        this.processGameEvent(new GameBoardChangeEvent(this));
        return vector;
    }
}

