/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Vector;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.LocationFullException;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.Report;
import megamek.common.WeaponType;

public class Infantry
extends Entity
implements Serializable {
    private int menStarting = 0;
    private int menShooting = 0;
    private int men = 0;
    private int weapons = 1;
    private int[] damage = new int[29];
    private static final int[] NUM_OF_SLOTS = new int[]{0};
    private static final String[] LOCATION_ABBRS = new String[]{"Men"};
    private static final String[] LOCATION_NAMES = new String[]{"Men"};
    private boolean antiMek = false;
    protected int runMP = 1;
    public static final int INF_PLT_MAX_MEN = 28;
    public static final int INF_PLT_JUMP_MAX_MEN = 21;
    public static final int INF_PLT_CLAN_MAX_MEN = 25;
    public static final int INF_UNKNOWN = -1;
    public static final int INF_RIFLE = 1;
    public static final int INF_MG = 3;
    public static final int INF_FLAMER = 2;
    public static final int INF_LASER = 4;
    public static final int INF_SRM = 9;
    public static final int INF_LRM = 7;
    public static final int LOC_INFANTRY = 0;
    public static final String LEG_ATTACK = "LegAttack";
    public static final String SWARM_MEK = "SwarmMek";
    public static final String STOP_SWARM = "StopSwarm";

    private void setDamage(int n) {
        double d;
        this.damage[0] = 0;
        switch (n) {
            case 1: {
                d = 4.0;
                break;
            }
            case 2: 
            case 3: {
                d = 3.0;
                break;
            }
            case 4: 
            case 9: {
                d = 2.0;
                break;
            }
            case 7: {
                d = 4.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown infantry weapon: " + n);
            }
        }
        int n2 = 1;
        int n3 = 1;
        while (n2 <= 28) {
            this.damage[n2] = (int)Math.ceil((double)n3 / d);
            if (1 == n2 && (3 == n || 2 == n)) {
                --n3;
            }
            ++n2;
            ++n3;
        }
        if (3 == n || 2 == n) {
            this.damage[28] = (int)Math.ceil(28.0 / d);
        }
    }

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public int locations() {
        return 1;
    }

    public Infantry() {
        this.setMovementMode(10);
        this.setDamage(this.weapons);
        this.setOriginalWalkMP(1);
        this.weapons = -1;
    }

    public int getSecondaryFacing() {
        return -1;
    }

    public boolean canChangeSecondaryFacing() {
        return false;
    }

    public boolean isValidSecondaryFacing(int n) {
        return false;
    }

    public int clipSecondaryFacing(int n) {
        return -1;
    }

    public void setCrew(Pilot pilot) {
        super.setCrew(pilot);
        this.getCrew().setPiloting(5);
    }

    public int getRunMP(boolean bl) {
        if (bl) {
            return this.applyGravityEffectsOnMP(this.getOriginalRunMP());
        }
        return this.getOriginalRunMP();
    }

    public int getRunMPwithoutMASC(boolean bl) {
        return this.getRunMP(bl);
    }

    protected int getOriginalRunMP() {
        return this.runMP;
    }

    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(30)) {
            return true;
        }
        if (iHex.containsTerrain(24)) {
            return true;
        }
        return iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20);
    }

    public String getMovementString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 1: 
            case 2: {
                switch (this.getMovementMode()) {
                    case 10: {
                        return "Walked";
                    }
                    case 11: {
                        return "Biked";
                    }
                }
                return "Unknown!";
            }
            case 4: 
            case 5: {
                return "Flew";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 1: {
                return "W";
            }
            case 2: {
                switch (this.getMovementMode()) {
                    case 10: {
                        return "R";
                    }
                    case 11: {
                        return "B";
                    }
                }
                return "?";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        return this.rollHitLocation(n, n2);
    }

    public HitData rollHitLocation(int n, int n2) {
        return new HitData(0);
    }

    public HitData getTransferLocation(HitData hitData) {
        return new HitData(-2);
    }

    public int getDependentLocation(int n) {
        return -1;
    }

    public boolean hasRearArmor(int n) {
        return false;
    }

    protected boolean isPlatoon() {
        return true;
    }

    public int getArmor(int n, boolean bl) {
        if (!this.isPlatoon()) {
            return super.getArmor(n, bl);
        }
        return -1;
    }

    public int getOArmor(int n, boolean bl) {
        if (!this.isPlatoon()) {
            return super.getOArmor(n, bl);
        }
        return -1;
    }

    public double getArmorRemainingPercent() {
        if (!this.isPlatoon()) {
            return super.getArmorRemainingPercent();
        }
        return -1.0;
    }

    public int getInternal(int n) {
        if (!this.isPlatoon()) {
            return super.getInternal(n);
        }
        return this.men > 0 ? this.men : -3;
    }

    public int getOInternal(int n) {
        if (!this.isPlatoon()) {
            return super.getOInternal(n);
        }
        return this.menStarting;
    }

    public void setInternal(int n, int n2) {
        super.setInternal(n, n2);
        this.men = n;
    }

    public double getInternalRemainingPercent() {
        if (!this.isPlatoon()) {
            return super.getInternalRemainingPercent();
        }
        int n = this.men > 0 ? this.men : 0;
        return (double)n / (double)this.menStarting;
    }

    public void initializeInternal(int n, int n2) {
        this.menStarting = n;
        this.menShooting = n;
        super.initializeInternal(n, n2);
    }

    public void autoSetInternal() {
        if (this.isClan()) {
            this.initializeInternal(25, 0);
            return;
        }
        switch (this.getMovementMode()) {
            case 10: 
            case 11: {
                this.initializeInternal(28, 0);
                break;
            }
            case 12: {
                this.initializeInternal(21, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
            }
        }
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        EquipmentType equipmentType = mounted.getType();
        if (SWARM_MEK.equals(equipmentType.getInternalName())) {
            this.antiMek = true;
        } else if (!LEG_ATTACK.equals(equipmentType.getInternalName()) && !STOP_SWARM.equals(equipmentType.getInternalName())) {
            if (mounted.getType() instanceof WeaponType && equipmentType.hasFlag(2048)) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (this.weapons != -1) {
                    throw new LocationFullException("Unit is already equiped with an infantry weapon and does not need a " + weaponType.getName());
                }
                int n2 = weaponType.getAmmoType() != -1 ? weaponType.getAmmoType() : weaponType.getFlags() & 6;
                this.weapons = n2;
                this.setDamage(n2);
                if (weaponType.hasFlag(1024)) {
                    for (int i = 1; i < this.damage.length; ++i) {
                        this.damage[i] = (int)Math.floor((double)this.damage[i] / 2.0);
                    }
                }
            } else if (this.isPlatoon()) {
                throw new LocationFullException("Infantry platoons can not be equiped with a " + mounted.getName());
            }
        }
        super.addEquipment(mounted, n, bl);
    }

    public int getWeaponArc(int n) {
        return 0;
    }

    public boolean isSecondaryArcWeapon(int n) {
        return false;
    }

    public int getHeatCapacity() {
        return 999;
    }

    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    public int getEngineCritHeat() {
        return 0;
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    public boolean hasHittableCriticals(int n) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int calculateBattleValue() {
        block55: {
            double d;
            block54: {
                d = 0.0;
                if (!this.antiMek) break block54;
                switch (this.weapons) {
                    case 1: {
                        if (10 == this.getMovementMode()) {
                            d = 32.0;
                        } else if (11 == this.getMovementMode()) {
                            d = 42.0;
                        } else {
                            if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                            d = 46.0;
                        }
                        break block55;
                    }
                    case 3: {
                        if (10 == this.getMovementMode()) {
                            d = 47.0;
                        } else if (11 == this.getMovementMode()) {
                            d = 63.0;
                        } else {
                            if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                            d = 62.0;
                        }
                        break block55;
                    }
                    case 2: {
                        if (10 == this.getMovementMode()) {
                            d = 41.0;
                        } else if (11 == this.getMovementMode()) {
                            d = 54.0;
                        } else {
                            if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                            d = 51.0;
                        }
                        break block55;
                    }
                    case 4: {
                        if (10 == this.getMovementMode()) {
                            d = 60.0;
                        } else if (11 == this.getMovementMode()) {
                            d = 70.0;
                        } else {
                            if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                            d = 71.0;
                        }
                        break block55;
                    }
                    case 9: {
                        if (10 == this.getMovementMode()) {
                            d = 60.0;
                        } else if (11 == this.getMovementMode()) {
                            d = 70.0;
                        } else {
                            if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                            d = 71.0;
                        }
                        break block55;
                    }
                    case 7: {
                        if (10 == this.getMovementMode()) {
                            d = 56.0;
                        } else if (11 == this.getMovementMode()) {
                            d = 75.0;
                        } else {
                            if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                            d = 87.0;
                        }
                        break block55;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown infantry weapon: " + this.weapons);
                    }
                }
            }
            switch (this.weapons) {
                case 1: {
                    if (10 == this.getMovementMode()) {
                        d = 23.0;
                        break;
                    }
                    if (11 == this.getMovementMode()) {
                        d = 28.0;
                        break;
                    }
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 29.0;
                    break;
                }
                case 3: {
                    if (10 == this.getMovementMode()) {
                        d = 31.0;
                        break;
                    }
                    if (11 == this.getMovementMode()) {
                        d = 39.0;
                        break;
                    }
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 37.0;
                    break;
                }
                case 2: {
                    if (10 == this.getMovementMode()) {
                        d = 28.0;
                        break;
                    }
                    if (11 == this.getMovementMode()) {
                        d = 35.0;
                        break;
                    }
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 32.0;
                    break;
                }
                case 4: {
                    if (10 == this.getMovementMode()) {
                        d = 37.0;
                        break;
                    }
                    if (11 == this.getMovementMode()) {
                        d = 42.0;
                        break;
                    }
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 41.0;
                    break;
                }
                case 9: {
                    if (10 == this.getMovementMode()) {
                        d = 60.0;
                        break;
                    }
                    if (11 == this.getMovementMode()) {
                        d = 70.0;
                        break;
                    }
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 71.0;
                    break;
                }
                case 7: {
                    if (10 == this.getMovementMode()) {
                        d = 56.0;
                        break;
                    }
                    if (11 == this.getMovementMode()) {
                        d = 75.0;
                        break;
                    }
                    if (12 != this.getMovementMode()) throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
                    d = 87.0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown infantry weapon: " + this.weapons);
                }
            }
        }
        d *= this.getInternalRemainingPercent();
        if (this.getsTagBVPenalty()) {
            d += 200.0;
        }
        if (this.getsHomingBVPenalty()) {
            d += 200.0;
        }
        double d = this.crew.getBVSkillMultiplier();
        return (int)Math.round(d *= d);
    }

    public Vector victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7040);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        Entity.combineVectors(vector, this.crew.getDescVector(true));
        report = new Report(7070, 0);
        report.newlines = 2;
        report.add(this.getKillNumber());
        vector.addElement(report);
        return vector;
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        return pilotingRollData;
    }

    public int getMaxElevationChange() {
        return 1;
    }

    public void applyDamage() {
        super.applyDamage();
        this.menShooting = this.men;
    }

    public int getDamage(int n) {
        return this.damage[n];
    }

    public int getShootingStrength() {
        return this.menShooting;
    }

    public boolean canCharge() {
        return false;
    }

    public boolean canDFA() {
        return false;
    }

    public void setOriginalRunMP(int n) {
        this.runMP = n;
    }

    public double getCost() {
        double d = 0.0;
        double d2 = 0.0;
        d2 = this.antiMek ? 5.0 : 1.0;
        switch (this.weapons) {
            case 1: {
                if (10 == this.getMovementMode()) {
                    d = 600000.0;
                    break;
                }
                if (11 == this.getMovementMode()) {
                    d = 960000.0;
                    break;
                }
                if (12 == this.getMovementMode()) {
                    d = 1200000.0;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
            }
            case 3: {
                if (10 == this.getMovementMode()) {
                    d = 800000.0;
                    break;
                }
                if (11 == this.getMovementMode()) {
                    d = 1280000.0;
                    break;
                }
                if (12 == this.getMovementMode()) {
                    d = 1600000.0;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
            }
            case 2: {
                if (10 == this.getMovementMode()) {
                    d = 800000.0;
                    break;
                }
                if (11 == this.getMovementMode()) {
                    d = 1280000.0;
                    break;
                }
                if (12 == this.getMovementMode()) {
                    d = 1600000.0;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
            }
            case 4: {
                if (10 == this.getMovementMode()) {
                    d = 1200000.0;
                    break;
                }
                if (11 == this.getMovementMode()) {
                    d = 1920000.0;
                    break;
                }
                if (12 == this.getMovementMode()) {
                    d = 2400000.0;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
            }
            case 9: {
                if (10 == this.getMovementMode()) {
                    d = 1400000.0;
                    break;
                }
                if (11 == this.getMovementMode()) {
                    d = 2240000.0;
                    break;
                }
                if (12 == this.getMovementMode()) {
                    d = 2800000.0;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
            }
            case 7: {
                if (10 == this.getMovementMode()) {
                    d = 1400000.0;
                    break;
                }
                if (11 == this.getMovementMode()) {
                    d = 2240000.0;
                    break;
                }
                if (12 == this.getMovementMode()) {
                    d = 2800000.0;
                    break;
                }
                throw new IllegalArgumentException("Unknown movement type: " + this.getMovementMode());
            }
            default: {
                throw new IllegalArgumentException("Unknown infantry weapon: " + this.weapons);
            }
        }
        return d * d2;
    }

    public boolean doomedInVacuum() {
        return false;
    }

    public boolean canAssaultDrop() {
        return this.game.getOptions().booleanOption("paratroopers");
    }
}

