/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Compute;

public class MapSettings
implements Serializable {
    public static final String BOARD_RANDOM = "[RANDOM]";
    public static final String BOARD_SURPRISE = "[SURPRISE]";
    public static final String BOARD_GENERATED = "[GENERATED]";
    private int boardWidth = 16;
    private int boardHeight = 17;
    private int mapWidth = 1;
    private int mapHeight = 1;
    private Vector boardsSelected = new Vector();
    private Vector boardsAvailable = new Vector();
    private Vector boardBuildings = new Vector();
    private int hilliness = 40;
    private int range = 5;
    private int probInvert = 5;
    private int minWaterSpots = 1;
    private int maxWaterSpots = 3;
    private int minWaterSize = 5;
    private int maxWaterSize = 10;
    private int probDeep = 33;
    private int minForestSpots = 3;
    private int maxForestSpots = 8;
    private int minForestSize = 4;
    private int maxForestSize = 12;
    private int probHeavy = 30;
    private int minRoughSpots = 2;
    private int maxRoughSpots = 10;
    private int minRoughSize = 1;
    private int maxRoughSize = 2;
    private int minSwampSpots = 2;
    private int maxSwampSpots = 10;
    private int minSwampSize = 1;
    private int maxSwampSize = 2;
    private int minPavementSpots = 0;
    private int maxPavementSpots = 0;
    private int minPavementSize = 1;
    private int maxPavementSize = 6;
    private int minRubbleSpots = 0;
    private int maxRubbleSpots = 0;
    private int minRubbleSize = 1;
    private int maxRubbleSize = 6;
    private int minFortifiedSpots = 0;
    private int maxFortifiedSpots = 0;
    private int minFortifiedSize = 1;
    private int maxFortifiedSize = 2;
    private int minIceSpots = 0;
    private int maxIceSpots = 0;
    private int minIceSize = 1;
    private int maxIceSize = 6;
    private int probRoad = 0;
    private int probRiver = 0;
    private int probCrater = 0;
    private int minRadius = 2;
    private int maxRadius = 7;
    private int maxCraters = 2;
    private int minCraters = 1;
    private int algorithmToUse = 0;
    private String theme = "";
    private int probFlood = 0;
    private int probForestFire = 0;
    private int probFreeze = 0;
    private int probDrought = 0;
    private int fxMod = 0;

    public MapSettings() {
        this(16, 17, 1, 1);
    }

    public MapSettings(int n, int n2, int n3, int n4) {
        this.setBoardSize(n, n2);
        this.setMapSize(n3, n4);
    }

    public MapSettings(MapSettings mapSettings) {
        this.boardWidth = mapSettings.getBoardWidth();
        this.boardHeight = mapSettings.getBoardHeight();
        this.mapWidth = mapSettings.getMapWidth();
        this.mapHeight = mapSettings.getMapHeight();
        this.boardsSelected = (Vector)mapSettings.getBoardsSelectedVector().clone();
        this.boardsAvailable = (Vector)mapSettings.getBoardsAvailableVector().clone();
        this.hilliness = mapSettings.getHilliness();
        this.range = mapSettings.getRange();
        this.probInvert = mapSettings.getProbInvert();
        this.minWaterSpots = mapSettings.getMinWaterSpots();
        this.maxWaterSpots = mapSettings.getMaxWaterSpots();
        this.minWaterSize = mapSettings.getMinWaterSize();
        this.maxWaterSize = mapSettings.getMaxWaterSize();
        this.probDeep = mapSettings.getProbDeep();
        this.minForestSpots = mapSettings.getMinForestSpots();
        this.maxForestSpots = mapSettings.getMaxForestSpots();
        this.minForestSize = mapSettings.getMinForestSize();
        this.maxForestSize = mapSettings.getMaxForestSize();
        this.probHeavy = mapSettings.getProbHeavy();
        this.minRoughSpots = mapSettings.getMinRoughSpots();
        this.maxRoughSpots = mapSettings.getMaxRoughSpots();
        this.minRoughSize = mapSettings.getMinRoughSize();
        this.maxRoughSize = mapSettings.getMaxRoughSize();
        this.minSwampSpots = mapSettings.getMinSwampSpots();
        this.maxSwampSpots = mapSettings.getMaxSwampSpots();
        this.minSwampSize = mapSettings.getMinSwampSize();
        this.maxSwampSize = mapSettings.getMaxSwampSize();
        this.minPavementSpots = mapSettings.getMinPavementSpots();
        this.maxPavementSpots = mapSettings.getMaxPavementSpots();
        this.minPavementSize = mapSettings.getMinPavementSize();
        this.maxPavementSize = mapSettings.getMaxPavementSize();
        this.minRubbleSpots = mapSettings.getMinRubbleSpots();
        this.maxRubbleSpots = mapSettings.getMaxRubbleSpots();
        this.minRubbleSize = mapSettings.getMinRubbleSize();
        this.maxRubbleSize = mapSettings.getMaxRubbleSize();
        this.minFortifiedSpots = mapSettings.getMinFortifiedSpots();
        this.maxFortifiedSpots = mapSettings.getMaxFortifiedSpots();
        this.minFortifiedSize = mapSettings.getMinFortifiedSize();
        this.maxFortifiedSize = mapSettings.getMaxFortifiedSize();
        this.minIceSpots = mapSettings.getMinIceSpots();
        this.maxIceSpots = mapSettings.getMaxIceSpots();
        this.minIceSize = mapSettings.getMinIceSize();
        this.maxIceSize = mapSettings.getMaxIceSize();
        this.probRoad = mapSettings.getProbRoad();
        this.probRiver = mapSettings.getProbRiver();
        this.probCrater = mapSettings.getProbCrater();
        this.minRadius = mapSettings.getMinRadius();
        this.maxRadius = mapSettings.getMaxRadius();
        this.minCraters = mapSettings.getMinCraters();
        this.maxCraters = mapSettings.getMaxCraters();
        this.algorithmToUse = mapSettings.getAlgorithmToUse();
        this.theme = mapSettings.getTheme();
        this.probFlood = mapSettings.getProbFlood();
        this.probForestFire = mapSettings.getProbForestFire();
        this.probFreeze = mapSettings.getProbFreeze();
        this.probDrought = mapSettings.getProbDrought();
        this.fxMod = mapSettings.getFxMod();
        this.boardBuildings = mapSettings.getBoardBuildings();
    }

    public int getBoardWidth() {
        return this.boardWidth;
    }

    public int getBoardHeight() {
        return this.boardHeight;
    }

    public void setBoardSize(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Total board area must be positive");
        }
        if (this.boardWidth != n || this.boardHeight != n2) {
            this.boardWidth = n;
            this.boardHeight = n2;
            this.boardsAvailable.removeAllElements();
        }
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String string) {
        this.theme = string;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapSize(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Total map area must be positive");
        }
        this.mapWidth = n;
        this.mapHeight = n2;
        this.boardsSelected.setSize(n * n2);
    }

    public Enumeration getBoardsSelected() {
        return this.boardsSelected.elements();
    }

    public Vector getBoardsSelectedVector() {
        return this.boardsSelected;
    }

    public void setBoardsSelectedVector(Vector vector) {
        this.boardsSelected = vector;
    }

    public void setNullBoards(String string) {
        for (int i = 0; i < this.boardsSelected.size(); ++i) {
            if (this.boardsSelected.elementAt(i) != null) continue;
            this.boardsSelected.setElementAt(string, i);
        }
    }

    public Vector getBoardBuildings() {
        return this.boardBuildings;
    }

    public void setBoardBuildings(Vector vector) {
        this.boardBuildings = vector;
    }

    public void replaceBoardWithRandom(String string) {
        for (int i = 0; i < this.boardsSelected.size(); ++i) {
            if (!this.boardsSelected.elementAt(i).equals(string)) continue;
            int n = Compute.randomInt(this.boardsAvailable.size() - 3) + 3;
            if (0 == Compute.randomInt(2)) {
                this.boardsSelected.setElementAt("rotate:" + this.boardsAvailable.elementAt(n), i);
                continue;
            }
            this.boardsSelected.setElementAt(this.boardsAvailable.elementAt(n), i);
        }
    }

    public void removeUnavailable() {
        for (int i = 0; i < this.boardsSelected.size(); ++i) {
            if (this.boardsSelected.elementAt(i) != null && this.boardsAvailable.size() != 0 && this.boardsAvailable.indexOf(this.boardsSelected.elementAt(i)) != -1) continue;
            this.boardsSelected.setElementAt(null, i);
        }
    }

    public Enumeration getBoardsAvailable() {
        return this.boardsAvailable.elements();
    }

    public Vector getBoardsAvailableVector() {
        return this.boardsAvailable;
    }

    public void setBoardsAvailableVector(Vector vector) {
        this.boardsAvailable = vector;
    }

    public void validateMapGenParameters() {
        if (this.hilliness < 0) {
            this.hilliness = 0;
        }
        if (this.hilliness > 99) {
            this.hilliness = 99;
        }
        if (this.range < 0) {
            this.range = 0;
        }
        if (this.minWaterSpots < 0) {
            this.minWaterSpots = 0;
        }
        if (this.maxWaterSpots < this.minWaterSpots) {
            this.maxWaterSpots = this.minWaterSpots;
        }
        if (this.minWaterSize < 0) {
            this.minWaterSize = 0;
        }
        if (this.maxWaterSize < this.minWaterSize) {
            this.maxWaterSize = this.minWaterSize;
        }
        if (this.probDeep < 0) {
            this.probDeep = 0;
        }
        if (this.probDeep > 100) {
            this.probDeep = 100;
        }
        if (this.minForestSpots < 0) {
            this.minForestSpots = 0;
        }
        if (this.maxForestSpots < this.minForestSpots) {
            this.maxForestSpots = this.minForestSpots;
        }
        if (this.minForestSize < 0) {
            this.minForestSize = 0;
        }
        if (this.maxForestSize < this.minForestSize) {
            this.maxForestSize = this.minForestSize;
        }
        if (this.probHeavy < 0) {
            this.probHeavy = 0;
        }
        if (this.probHeavy > 100) {
            this.probHeavy = 100;
        }
        if (this.minRoughSpots < 0) {
            this.minRoughSpots = 0;
        }
        if (this.maxRoughSpots < this.minRoughSpots) {
            this.maxRoughSpots = this.minRoughSpots;
        }
        if (this.minRoughSize < 0) {
            this.minRoughSize = 0;
        }
        if (this.maxRoughSize < this.minRoughSize) {
            this.maxRoughSize = this.minRoughSize;
        }
        if (this.minSwampSpots < 0) {
            this.minSwampSpots = 0;
        }
        if (this.maxSwampSpots < this.minSwampSpots) {
            this.maxSwampSpots = this.minSwampSpots;
        }
        if (this.minSwampSize < 0) {
            this.minSwampSize = 0;
        }
        if (this.maxSwampSize < this.minSwampSize) {
            this.maxSwampSize = this.minSwampSize;
        }
        if (this.minPavementSpots < 0) {
            this.minPavementSpots = 0;
        }
        if (this.maxPavementSpots < this.minPavementSpots) {
            this.maxPavementSpots = this.minPavementSpots;
        }
        if (this.minPavementSize < 0) {
            this.minPavementSize = 0;
        }
        if (this.maxPavementSize < this.minPavementSize) {
            this.maxPavementSize = this.minPavementSize;
        }
        if (this.minRubbleSpots < 0) {
            this.minRubbleSpots = 0;
        }
        if (this.maxRubbleSpots < this.minRubbleSpots) {
            this.maxRubbleSpots = this.minRubbleSpots;
        }
        if (this.minRubbleSize < 0) {
            this.minRubbleSize = 0;
        }
        if (this.maxRubbleSize < this.minRubbleSize) {
            this.maxRubbleSize = this.minRubbleSize;
        }
        if (this.minFortifiedSpots < 0) {
            this.minFortifiedSpots = 0;
        }
        if (this.maxFortifiedSpots < this.minFortifiedSpots) {
            this.maxFortifiedSpots = this.minFortifiedSpots;
        }
        if (this.minFortifiedSize < 0) {
            this.minFortifiedSize = 0;
        }
        if (this.maxFortifiedSize < this.minFortifiedSize) {
            this.maxFortifiedSize = this.minFortifiedSize;
        }
        if (this.minIceSpots < 0) {
            this.minIceSpots = 0;
        }
        if (this.maxIceSpots < this.minIceSpots) {
            this.maxIceSpots = this.minIceSpots;
        }
        if (this.minIceSize < 0) {
            this.minIceSize = 0;
        }
        if (this.maxIceSize < this.minIceSize) {
            this.maxIceSize = this.minIceSize;
        }
        if (this.probRoad < 0) {
            this.probRoad = 0;
        }
        if (this.probRoad > 100) {
            this.probRoad = 100;
        }
        if (this.probInvert < 0) {
            this.probInvert = 0;
        }
        if (this.probInvert > 100) {
            this.probInvert = 100;
        }
        if (this.probRiver < 0) {
            this.probRiver = 0;
        }
        if (this.probRiver > 100) {
            this.probRiver = 100;
        }
        if (this.probCrater < 0) {
            this.probCrater = 0;
        }
        if (this.probCrater > 100) {
            this.probCrater = 100;
        }
        if (this.minRadius < 0) {
            this.minRadius = 0;
        }
        if (this.maxRadius < this.minRadius) {
            this.maxRadius = this.minRadius;
        }
        if (this.minCraters < 0) {
            this.minCraters = 0;
        }
        if (this.maxCraters < this.minCraters) {
            this.maxCraters = this.minCraters;
        }
        if (this.algorithmToUse < 0) {
            this.algorithmToUse = 0;
        }
        if (this.algorithmToUse > 2) {
            this.algorithmToUse = 2;
        }
    }

    public boolean equalMapGenParameters(MapSettings mapSettings) {
        return this.boardWidth == mapSettings.getBoardWidth() && this.boardHeight == mapSettings.getBoardHeight() && this.mapWidth == mapSettings.getMapWidth() && this.mapHeight == mapSettings.getMapHeight() && this.hilliness == mapSettings.getHilliness() && this.range == mapSettings.getRange() && this.minWaterSpots == mapSettings.getMinWaterSpots() && this.maxWaterSpots == mapSettings.getMaxWaterSpots() && this.minWaterSize == mapSettings.getMinWaterSize() && this.maxWaterSize == mapSettings.getMaxWaterSize() && this.probDeep == mapSettings.getProbDeep() && this.minForestSpots == mapSettings.getMinForestSpots() && this.maxForestSpots == mapSettings.getMaxForestSpots() && this.minForestSize == mapSettings.getMinForestSize() && this.maxForestSize == mapSettings.getMaxForestSize() && this.probHeavy == mapSettings.getProbHeavy() && this.minRoughSpots == mapSettings.getMinRoughSpots() && this.maxRoughSpots == mapSettings.getMaxRoughSpots() && this.minRoughSize == mapSettings.getMinRoughSize() && this.maxRoughSize == mapSettings.getMaxRoughSize() && this.minSwampSpots == mapSettings.getMinSwampSpots() && this.maxSwampSpots == mapSettings.getMaxSwampSpots() && this.minSwampSize == mapSettings.getMinSwampSize() && this.maxSwampSize == mapSettings.getMaxSwampSize() && this.minPavementSpots == mapSettings.getMinPavementSpots() && this.maxPavementSpots == mapSettings.getMaxPavementSpots() && this.minPavementSize == mapSettings.getMinPavementSize() && this.maxPavementSize == mapSettings.getMaxPavementSize() && this.minRubbleSpots == mapSettings.getMinRubbleSpots() && this.maxRubbleSpots == mapSettings.getMaxRubbleSpots() && this.minRubbleSize == mapSettings.getMinRubbleSize() && this.maxRubbleSize == mapSettings.getMaxRubbleSize() && this.minFortifiedSpots == mapSettings.getMinFortifiedSpots() && this.maxFortifiedSpots == mapSettings.getMaxFortifiedSpots() && this.minFortifiedSize == mapSettings.getMinFortifiedSize() && this.maxFortifiedSize == mapSettings.getMaxFortifiedSize() && this.minIceSpots == mapSettings.getMinIceSpots() && this.maxIceSpots == mapSettings.getMaxIceSpots() && this.minIceSize == mapSettings.getMinIceSize() && this.maxIceSize == mapSettings.getMaxIceSize() && this.probRoad == mapSettings.getProbRoad() && this.probInvert == mapSettings.getProbInvert() && this.probRiver == mapSettings.getProbRiver() && this.probCrater == mapSettings.getProbCrater() && this.minRadius == mapSettings.getMinRadius() && this.maxRadius == mapSettings.getMaxRadius() && this.minCraters == mapSettings.getMinCraters() && this.maxCraters == mapSettings.getMaxCraters() && this.theme == mapSettings.getTheme() && this.fxMod == mapSettings.getFxMod() && this.probFlood == mapSettings.getProbFlood() && this.probForestFire == mapSettings.getProbForestFire() && this.probFreeze == mapSettings.getProbFreeze() && this.probDrought == mapSettings.getProbDrought() && this.algorithmToUse == mapSettings.getAlgorithmToUse() && this.boardBuildings == mapSettings.getBoardBuildings();
    }

    public Object clone() {
        return new MapSettings(this);
    }

    public int getHilliness() {
        return this.hilliness;
    }

    public int getRange() {
        return this.range;
    }

    public int getProbInvert() {
        return this.probInvert;
    }

    public int getMinWaterSpots() {
        return this.minWaterSpots;
    }

    public int getMaxWaterSpots() {
        return this.maxWaterSpots;
    }

    public int getMinWaterSize() {
        return this.minWaterSize;
    }

    public int getMaxWaterSize() {
        return this.maxWaterSize;
    }

    public int getProbDeep() {
        return this.probDeep;
    }

    public int getMinForestSpots() {
        return this.minForestSpots;
    }

    public int getMaxForestSpots() {
        return this.maxForestSpots;
    }

    public int getMinForestSize() {
        return this.minForestSize;
    }

    public int getMaxForestSize() {
        return this.maxForestSize;
    }

    public int getProbHeavy() {
        return this.probHeavy;
    }

    public int getMinRoughSpots() {
        return this.minRoughSpots;
    }

    public int getMaxRoughSpots() {
        return this.maxRoughSpots;
    }

    public int getMinRoughSize() {
        return this.minRoughSize;
    }

    public int getMaxRoughSize() {
        return this.maxRoughSize;
    }

    public int getMinSwampSpots() {
        return this.minSwampSpots;
    }

    public int getMaxSwampSpots() {
        return this.maxSwampSpots;
    }

    public int getMinSwampSize() {
        return this.minSwampSize;
    }

    public int getMaxSwampSize() {
        return this.maxSwampSize;
    }

    public int getMinPavementSpots() {
        return this.minPavementSpots;
    }

    public int getMaxPavementSpots() {
        return this.maxPavementSpots;
    }

    public int getMinPavementSize() {
        return this.minPavementSize;
    }

    public int getMaxPavementSize() {
        return this.maxPavementSize;
    }

    public int getMinRubbleSpots() {
        return this.minRubbleSpots;
    }

    public int getMaxRubbleSpots() {
        return this.maxRubbleSpots;
    }

    public int getMinRubbleSize() {
        return this.minRubbleSize;
    }

    public int getMaxRubbleSize() {
        return this.maxRubbleSize;
    }

    public int getMinFortifiedSpots() {
        return this.minFortifiedSpots;
    }

    public int getMaxFortifiedSpots() {
        return this.maxFortifiedSpots;
    }

    public int getMinFortifiedSize() {
        return this.minFortifiedSize;
    }

    public int getMaxFortifiedSize() {
        return this.maxFortifiedSize;
    }

    public int getMinIceSpots() {
        return this.minIceSpots;
    }

    public int getMaxIceSpots() {
        return this.maxIceSpots;
    }

    public int getMinIceSize() {
        return this.minIceSize;
    }

    public int getMaxIceSize() {
        return this.maxIceSize;
    }

    public int getProbRoad() {
        return this.probRoad;
    }

    public int getProbRiver() {
        return this.probRiver;
    }

    public int getProbCrater() {
        return this.probCrater;
    }

    public int getMinRadius() {
        return this.minRadius;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public int getMinCraters() {
        return this.minCraters;
    }

    public int getMaxCraters() {
        return this.maxCraters;
    }

    public int getAlgorithmToUse() {
        return this.algorithmToUse;
    }

    public int getProbFlood() {
        return this.probFlood;
    }

    public int getProbForestFire() {
        return this.probForestFire;
    }

    public int getProbFreeze() {
        return this.probFreeze;
    }

    public int getProbDrought() {
        return this.probDrought;
    }

    public int getFxMod() {
        return this.fxMod;
    }

    public void setElevationParams(int n, int n2, int n3) {
        this.hilliness = n;
        this.range = n2;
        this.probInvert = n3;
    }

    public void setWaterParams(int n, int n2, int n3, int n4, int n5) {
        this.minWaterSpots = n;
        this.maxWaterSpots = n2;
        this.minWaterSize = n3;
        this.maxWaterSize = n4;
        this.probDeep = n5;
    }

    public void setForestParams(int n, int n2, int n3, int n4, int n5) {
        this.minForestSpots = n;
        this.maxForestSpots = n2;
        this.minForestSize = n3;
        this.maxForestSize = n4;
        this.probHeavy = n5;
    }

    public void setRoughParams(int n, int n2, int n3, int n4) {
        this.minRoughSpots = n;
        this.maxRoughSpots = n2;
        this.minRoughSize = n3;
        this.maxRoughSize = n4;
    }

    public void setSwampParams(int n, int n2, int n3, int n4) {
        this.minSwampSpots = n;
        this.maxSwampSpots = n2;
        this.minSwampSize = n3;
        this.maxSwampSize = n4;
    }

    public void setPavementParams(int n, int n2, int n3, int n4) {
        this.minPavementSpots = n;
        this.maxPavementSpots = n2;
        this.minPavementSize = n3;
        this.maxPavementSize = n4;
    }

    public void setRubbleParams(int n, int n2, int n3, int n4) {
        this.minRubbleSpots = n;
        this.maxRubbleSpots = n2;
        this.minRubbleSize = n3;
        this.maxRubbleSize = n4;
    }

    public void setFortifiedParams(int n, int n2, int n3, int n4) {
        this.minFortifiedSpots = n;
        this.maxFortifiedSpots = n2;
        this.minFortifiedSize = n3;
        this.maxFortifiedSize = n4;
    }

    public void setIceParams(int n, int n2, int n3, int n4) {
        this.minIceSpots = n;
        this.maxIceSpots = n2;
        this.minIceSize = n3;
        this.maxIceSize = n4;
    }

    public void setRiverParam(int n) {
        this.probRiver = n;
    }

    public void setRoadParam(int n) {
        this.probRoad = n;
    }

    public void setCraterParam(int n, int n2, int n3, int n4, int n5) {
        this.probCrater = n;
        this.maxCraters = n3;
        this.minCraters = n2;
        this.minRadius = n4;
        this.maxRadius = n5;
    }

    public void setSpecialFX(int n, int n2, int n3, int n4, int n5) {
        this.fxMod = n;
        this.probForestFire = n2;
        this.probFreeze = n3;
        this.probFlood = n4;
        this.probDrought = n5;
    }

    public void setAlgorithmToUse(int n) {
        this.algorithmToUse = n;
    }
}

