/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmorHandles;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentMessages;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.LocationFullException;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.PilotingRollData;
import megamek.common.QuadMech;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.WeaponType;
import megamek.common.preference.PreferenceManager;

public abstract class Mech
extends Entity
implements Serializable {
    public static final int NUM_MECH_LOCATIONS = 8;
    public static final int SYSTEM_LIFE_SUPPORT = 0;
    public static final int SYSTEM_SENSORS = 1;
    public static final int SYSTEM_COCKPIT = 2;
    public static final int SYSTEM_ENGINE = 3;
    public static final int SYSTEM_GYRO = 4;
    public static final int ACTUATOR_SHOULDER = 7;
    public static final int ACTUATOR_UPPER_ARM = 8;
    public static final int ACTUATOR_LOWER_ARM = 9;
    public static final int ACTUATOR_HAND = 10;
    public static final int ACTUATOR_HIP = 11;
    public static final int ACTUATOR_UPPER_LEG = 12;
    public static final int ACTUATOR_LOWER_LEG = 13;
    public static final int ACTUATOR_FOOT = 14;
    public static final String[] systemNames = new String[]{"Life Support", "Sensors", "Cockpit", "Engine", "Gyro", null, null, "Shoulder", "Upper Arm", "Lower Arm", "Hand", "Hip", "Upper Leg", "Lower Leg", "Foot"};
    public static final int LOC_HEAD = 0;
    public static final int LOC_CT = 1;
    public static final int LOC_RT = 2;
    public static final int LOC_LT = 3;
    public static final int LOC_RARM = 4;
    public static final int LOC_LARM = 5;
    public static final int LOC_RLEG = 6;
    public static final int LOC_LLEG = 7;
    public static final int COCKPIT_OFF = 0;
    public static final int COCKPIT_ON = 1;
    public static final int COCKPIT_AIMED_SHOT = 2;
    public static final int GYRO_UNKNOWN = -1;
    public static final int GYRO_STANDARD = 0;
    public static final int GYRO_XL = 1;
    public static final int GYRO_COMPACT = 2;
    public static final int GYRO_HEAVY_DUTY = 3;
    public static final String[] GYRO_STRING = new String[]{"Standard Gyro", "XL Gyro", "Compact Gyro", "Heavy Duty Gyro"};
    public static final String[] GYRO_SHORT_STRING = new String[]{"Standard", "XL", "Compact", "Heavy Duty"};
    public static final int COCKPIT_UNKNOWN = -1;
    public static final int COCKPIT_STANDARD = 0;
    public static final int COCKPIT_TORSO_MOUNTED = 1;
    public static final int COCKPIT_SMALL = 2;
    public static final int COCKPIT_COMMAND_CONSOLE = 3;
    public static final int COCKPIT_DUAL = 4;
    public static final String[] COCKPIT_STRING = new String[]{"Standard Cockpit", "Torso-Mounted Cockpit", "Small Cockpit", "Command Console", "Dual Cockpit"};
    public static final String[] COCKPIT_SHORT_STRING = new String[]{"Standard", "Torso Mounted", "Small", "Command Console", "Dual"};
    public static final String STEALTH = "Mek Stealth";
    public static final String NULLSIG = "Mek Null Signature System";
    private int[] rearArmor;
    private int[] orig_rearArmor;
    private static int[] MASC_FAILURE = new int[]{2, 4, 6, 10, 12, 12, 12};
    private int nMASCLevel = 0;
    private boolean usedMASC = false;
    private int sinksOn;
    private int sinksOnNextRound;
    private boolean sinksChanged = false;
    private boolean autoEject = true;
    private int cockpitStatus = 1;
    private int cockpitStatusNextRound = 1;
    private int improvedJJ = -1;
    private int gyroType = 0;
    private int cockpitType = 0;
    private boolean hasCowl = false;
    private int cowlArmor = 0;
    private boolean hasICE = false;

    public Mech() {
        this(0, 0);
    }

    public Mech(int n, int n2) {
        int n3;
        this.gyroType = n;
        this.cockpitType = n2;
        this.rearArmor = new int[this.locations()];
        this.orig_rearArmor = new int[this.locations()];
        for (n3 = 0; n3 < this.locations(); ++n3) {
            if (this.hasRearArmor(n3)) continue;
            this.initializeRearArmor(-1, n3);
        }
        if (this.cockpitType != 1) {
            this.setCritical(0, 0, new CriticalSlot(0, 0));
        }
        this.setCritical(0, 1, new CriticalSlot(0, 1));
        this.setCritical(0, 2, new CriticalSlot(0, 2));
        if (this.cockpitType == 3 || this.cockpitType == 4) {
            // empty if block
        }
        this.setCritical(0, 4, new CriticalSlot(0, 1));
        if (this.cockpitType != 2 && this.cockpitType != 1) {
            this.setCritical(0, 5, new CriticalSlot(0, 0));
        }
        n3 = 0;
        this.setCritical(1, n3++, new CriticalSlot(0, 3));
        this.setCritical(1, n3++, new CriticalSlot(0, 3));
        this.setCritical(1, n3++, new CriticalSlot(0, 3));
        this.setCritical(1, n3++, new CriticalSlot(0, 4));
        this.setCritical(1, n3++, new CriticalSlot(0, 4));
        if (this.gyroType != 2) {
            this.setCritical(1, n3++, new CriticalSlot(0, 4));
            this.setCritical(1, n3++, new CriticalSlot(0, 4));
            if (this.gyroType == 1) {
                this.setCritical(1, n3++, new CriticalSlot(0, 4));
                this.setCritical(1, n3++, new CriticalSlot(0, 4));
            }
        }
        this.setCritical(1, n3++, new CriticalSlot(0, 3));
        this.setCritical(1, n3++, new CriticalSlot(0, 3));
        this.setCritical(1, n3++, new CriticalSlot(0, 3));
        if (this.cockpitType == 1) {
            this.setCritical(1, n3++, new CriticalSlot(0, 2));
            this.setCritical(1, n3++, new CriticalSlot(0, 1));
        }
        if (this.cockpitType == 1) {
            this.setCritical(2, 0, new CriticalSlot(0, 0));
            this.setCritical(3, 0, new CriticalSlot(0, 0));
        }
        this.setCritical(6, 0, new CriticalSlot(0, 11));
        this.setCritical(6, 1, new CriticalSlot(0, 12));
        this.setCritical(6, 2, new CriticalSlot(0, 13));
        this.setCritical(6, 3, new CriticalSlot(0, 14));
        this.setCritical(7, 0, new CriticalSlot(0, 11));
        this.setCritical(7, 1, new CriticalSlot(0, 12));
        this.setCritical(7, 2, new CriticalSlot(0, 13));
        this.setCritical(7, 3, new CriticalSlot(0, 14));
        this.autoEject = !PreferenceManager.getClientPreferences().defaultAutoejectDisabled();
    }

    public void setCowl(int n) {
        this.hasCowl = true;
        this.cowlArmor = n;
    }

    public int getCowlArmor() {
        if (this.hasCowl) {
            return this.cowlArmor;
        }
        return 0;
    }

    public boolean hasCowl() {
        return this.hasCowl;
    }

    public int damageCowl(int n) {
        if (this.hasCowl) {
            if (n < this.cowlArmor) {
                this.cowlArmor -= n;
                return 0;
            }
            this.cowlArmor = 0;
            return n -= this.cowlArmor;
        }
        return n;
    }

    public static int getInnerLocation(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return 1;
            }
            case 5: 
            case 7: {
                return 3;
            }
            case 4: 
            case 6: {
                return 2;
            }
        }
        return n;
    }

    public static int mostRestrictiveLoc(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if (Mech.restrictScore(n) >= Mech.restrictScore(n2)) {
            return n;
        }
        return n2;
    }

    public static int restrictScore(int n) {
        switch (n) {
            case 4: 
            case 5: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 3;
    }

    public int getMASCTurns() {
        return this.nMASCLevel;
    }

    public void setMASCTurns(int n) {
        this.nMASCLevel = n;
    }

    public boolean isMASCUsed() {
        return this.usedMASC;
    }

    public void setMASCUsed(boolean bl) {
        this.usedMASC = bl;
    }

    public int getMASCTarget() {
        return MASC_FAILURE[this.nMASCLevel] + 1;
    }

    public boolean checkForMASCFailure(MovePath movePath, Vector vector) {
        if (movePath.hasActiveMASC()) {
            boolean bl = false;
            if (!this.usedMASC) {
                int n = Compute.d6(2);
                this.usedMASC = true;
                Report report = new Report(2365);
                report.subject = this.getId();
                report.addDesc(this);
                vector.addElement(report);
                report = new Report(2370);
                report.subject = this.getId();
                report.indent();
                report.add(this.getMASCTarget());
                report.add(n);
                if (n < this.getMASCTarget()) {
                    bl = true;
                    report.choose(false);
                    this.getCritical(6, 0).setDestroyed(true);
                    this.getCritical(7, 0).setDestroyed(true);
                    if (this instanceof QuadMech) {
                        this.getCritical(4, 0).setDestroyed(true);
                        this.getCritical(5, 0).setDestroyed(true);
                    }
                    Enumeration enumeration = this.getEquipment();
                    while (enumeration.hasMoreElements()) {
                        Mounted mounted = (Mounted)enumeration.nextElement();
                        if (!mounted.getType().hasFlag(16)) continue;
                        mounted.setDestroyed(true);
                        mounted.setMode("Off");
                    }
                } else {
                    report.choose(true);
                }
                vector.addElement(report);
            }
            return bl;
        }
        return false;
    }

    public void setOmni(boolean bl) {
        super.setOmni(bl);
        if (bl) {
            this.addTransporter(new BattleArmorHandles());
        }
    }

    public int locations() {
        return 8;
    }

    public void newRound(int n) {
        Enumeration enumeration = this.getMisc();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            MiscType miscType = (MiscType)mounted.getType();
            if (!STEALTH.equals(miscType.getInternalName()) || !mounted.getLinked().isDestroyed() || !mounted.getLinked().isBreached()) continue;
            mounted.setMode("Off");
        }
        super.newRound(n);
        this.nMASCLevel = this.usedMASC ? ++this.nMASCLevel : Math.max(0, this.nMASCLevel - 1);
        this.usedMASC = false;
        this.setSecondaryFacing(this.getFacing());
        this.sinksOn = this.sinksOnNextRound;
        this.cockpitStatus = this.cockpitStatusNextRound;
    }

    public boolean locationIsTorso(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    public boolean locationIsLeg(int n) {
        return n == 7 || n == 6;
    }

    public int countBadLegs() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            n += this.locationIsLeg(i) && this.isLocationBad(i) ? 1 : 0;
        }
        return n;
    }

    public boolean hasHipCrit() {
        for (int i = 0; i < 8; ++i) {
            if (!this.legHasHipCrit(i)) continue;
            return true;
        }
        return false;
    }

    public boolean legHasHipCrit(int n) {
        if (this.isLocationBad(n)) {
            return false;
        }
        if (this.locationIsLeg(n)) {
            return this.getGoodCriticals(0, 11, n) == 0;
        }
        return false;
    }

    public int countLegActuatorCrits(int n) {
        if (this.isLocationBad(n)) {
            return 0;
        }
        int n2 = 0;
        if (this.locationIsLeg(n)) {
            if (this.getGoodCriticals(0, 12, n) == 0) {
                ++n2;
            }
            if (this.getGoodCriticals(0, 13, n) == 0) {
                ++n2;
            }
            if (this.getGoodCriticals(0, 14, n) == 0) {
                ++n2;
            }
        }
        return n2;
    }

    public boolean hasXL() {
        int n = this.getNumberOfCriticals(0, 3, 2);
        return this.isClan() && n == 2 || this.getEngineTechLevel() == 2 && n == 2 || !this.isClan() && n == 3;
    }

    public boolean hasLightEngine() {
        int n = this.getNumberOfCriticals(0, 3, 2);
        return (!this.isClan() || this.getEngineTechLevel() == 2) && n == 2;
    }

    public boolean hasICE() {
        return this.hasICE;
    }

    public void setICE(boolean bl) {
        this.hasICE = bl;
    }

    public void giveXL() {
        this.giveXL(this.isClan());
    }

    public void giveXL(boolean bl) {
        int n = bl ? 2 : 3;
        for (int i = 0; i < n; ++i) {
            this.setCritical(2, i, new CriticalSlot(0, 3));
            this.setCritical(3, i, new CriticalSlot(0, 3));
        }
    }

    public boolean hasEndo() {
        if (this.getStructureType() == -1) {
            Enumeration enumeration = this.getMisc();
            while (enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                if (mounted.getDesc().indexOf(EquipmentType.getStructureTypeName(1)) != -1) {
                    this.setStructureType(1);
                    break;
                }
                if (mounted.getDesc().indexOf(EquipmentType.getStructureTypeName(2)) == -1) continue;
                this.setStructureType(2);
                break;
            }
        }
        return this.getStructureType() == 1 || this.getStructureType() == 2;
    }

    public boolean hasCompositeStructure() {
        if (this.getStructureType() == -1) {
            Enumeration enumeration = this.getMisc();
            while (enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                if (mounted.getDesc().indexOf(EquipmentType.getStructureTypeName(4)) == -1) continue;
                this.setStructureType(4);
                break;
            }
        }
        return this.getStructureType() == 4;
    }

    public boolean hasReinforcedStructure() {
        if (this.getStructureType() == -1) {
            Enumeration enumeration = this.getMisc();
            while (enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                if (mounted.getDesc().indexOf(EquipmentType.getStructureTypeName(3)) == -1) continue;
                this.setStructureType(3);
                break;
            }
        }
        return this.getStructureType() == 3;
    }

    public boolean hasFerro() {
        Enumeration enumeration = this.getMisc();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(1)) == -1 && mounted.getDesc().indexOf(EquipmentType.getArmorTypeName(9)) == -1) continue;
            return true;
        }
        return false;
    }

    public boolean hasMASC() {
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            MiscType miscType = (MiscType)((Mounted)enumeration.nextElement()).getType();
            if (!miscType.hasFlag(16)) continue;
            return true;
        }
        return false;
    }

    public boolean hasArmedMASC() {
        Enumeration enumeration = this.getEquipment();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.isDestroyed() || mounted.isBreached() || !(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(16) || !mounted.curMode().equals("Armed")) continue;
            return true;
        }
        return false;
    }

    public boolean hasTSM() {
        Enumeration enumeration = this.getEquipment();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(32)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStealth() {
        Enumeration enumeration = this.getMisc();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(262144)) continue;
            return true;
        }
        return false;
    }

    public int getRunMP(boolean bl) {
        if (this.hasArmedMASC()) {
            return this.getWalkMP(bl) * 2;
        }
        return super.getRunMP(bl);
    }

    public int getRunMPwithoutMASC(boolean bl) {
        return super.getRunMP(bl);
    }

    public int getOriginalRunMPwithoutMASC() {
        return super.getRunMP(false);
    }

    public String getRunMPasString() {
        if (this.hasArmedMASC()) {
            return this.getRunMPwithoutMASC() + "(" + this.getRunMP() + ")";
        }
        return Integer.toString(this.getRunMP());
    }

    public int getJumpMP() {
        int n = 0;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.getType().hasFlag(4) || mounted.isDestroyed() || mounted.isBreached()) continue;
            ++n;
        }
        return this.applyGravityEffectsOnMP(n);
    }

    public int getJumpHeat(int n) {
        if (this.improvedJJ < 0) {
            for (Object e : this.miscList) {
                Mounted mounted = (Mounted)e;
                if (!mounted.getType().hasFlag(4) || mounted.getType().getTechLevel() != 5 && mounted.getType().getTechLevel() != 6) continue;
                this.improvedJJ = 1;
                break;
            }
        }
        if (this.improvedJJ > 0) {
            return n / 2 + n % 2;
        }
        return super.getJumpHeat(n);
    }

    public int getJumpMPWithTerrain() {
        if (this.getPosition() == null) {
            return this.getJumpMP();
        }
        int n = 0;
        if (!this.isOffBoard()) {
            n = this.game.getBoard().getHex(this.getPosition()).terrainLevel(4);
        }
        if (n <= 0 || this.getElevation() >= 0) {
            return this.getJumpMP();
        }
        if (n > 1) {
            return 0;
        }
        return this.applyGravityEffectsOnMP(this.torsoJumpJets());
    }

    public int torsoJumpJets() {
        int n = 0;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.getType().hasFlag(4) || mounted.isDestroyed() || mounted.isBreached() || !this.locationIsTorso(mounted.getLocation())) continue;
            ++n;
        }
        return n;
    }

    public int getElevation() {
        int n = super.getElevation();
        if (!this.isMakingDfa()) {
            return n;
        }
        int n2 = this.game.getBoard().getHex(this.displacementAttack.getTargetPos()).floor();
        return Math.max(n, n2) + 1;
    }

    public int height() {
        return this.isProne() ? 0 : 1;
    }

    public void addEngineSinks(int n, boolean bl) {
        this.addEngineSinks(n, bl, this.isClan());
    }

    public void addEngineSinks(int n, boolean bl, boolean bl2) {
        int n2;
        EquipmentType equipmentType = bl ? EquipmentType.get(bl2 ? "CLDoubleHeatSink" : "ISDoubleHeatSink") : EquipmentType.get("Heat Sink");
        if (equipmentType == null) {
            System.out.println("Mech: can't find heat sink to add to engine");
        }
        if ((n2 = Math.min(n, this.integralSinkCapacity())) == 0 && !this.hasICE) {
            System.out.println("Mech: not putting any heat sinks in the engine?!?!");
        }
        for (int i = 0; i < n2; ++i) {
            try {
                this.addEquipment(new Mounted(this, equipmentType), -1, false);
                continue;
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
    }

    public int integralSinkCapacity() {
        if (this.hasICE) {
            return 0;
        }
        return this.engineRating() / 25;
    }

    public int getEngineCritHeat() {
        int n = 0;
        if (!this.isShutDown() && !this.hasICE) {
            n += 5 * this.getHitCriticals(0, 3, 1);
            n += 5 * this.getHitCriticals(0, 3, 3);
            n += 5 * this.getHitCriticals(0, 3, 2);
        }
        return n;
    }

    public int engineRating() {
        return Math.round((float)this.walkMP * this.weight);
    }

    public int heatSinks() {
        int n = 0;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            EquipmentType equipmentType = mounted.getType();
            if (!equipmentType.hasFlag(1) && !equipmentType.hasFlag(2)) continue;
            ++n;
        }
        return n;
    }

    public int getHeatCapacity() {
        int n = 0;
        boolean bl = false;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.isDestroyed() || mounted.isBreached()) continue;
            if (mounted.getType().hasFlag(1)) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(2)) continue;
            bl = true;
            n += 2;
        }
        if (this.sinksChanged) {
            n -= (this.getNumberOfSinks() - this.sinksOn) * (bl ? 2 : 1);
        }
        return n;
    }

    public int getHeatCapacityWithWater() {
        if (this.hasLaserHeatSinks()) {
            return this.getHeatCapacity();
        }
        return this.getHeatCapacity() + Math.min(this.sinksUnderwater(), 6);
    }

    private int sinksUnderwater() {
        if (this.getPosition() == null || this.isOffBoard()) {
            return 0;
        }
        IHex iHex = this.game.getBoard().getHex(this.getPosition());
        if (iHex.terrainLevel(4) <= 0 || this.getElevation() >= 0) {
            return 0;
        }
        if (this.isProne() || iHex.terrainLevel(4) >= 2) {
            return this.getHeatCapacity();
        }
        int n = 0;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.isDestroyed() || mounted.isBreached() || !this.locationIsLeg(mounted.getLocation())) continue;
            if (mounted.getType().hasFlag(1)) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(2)) continue;
            n += 2;
        }
        return n;
    }

    public String getMovementString(int n) {
        switch (n) {
            case -2: {
                return "Skidded";
            }
            case 0: {
                return "None";
            }
            case 1: {
                return "Walked";
            }
            case 2: {
                return "Ran";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case -2: {
                return "S";
            }
            case 0: {
                return "N";
            }
            case 1: {
                return "W";
            }
            case 2: {
                return "R";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    public boolean canChangeSecondaryFacing() {
        return !this.isProne();
    }

    public boolean isValidSecondaryFacing(int n) {
        int n2 = n - this.getFacing();
        if (this.canChangeSecondaryFacing()) {
            return n2 == 0 || n2 == 1 || n2 == -1 || n2 == -5;
        }
        return n2 == 0;
    }

    public int clipSecondaryFacing(int n) {
        if (this.isValidSecondaryFacing(n)) {
            return n;
        }
        if (!this.canChangeSecondaryFacing()) {
            return this.getFacing();
        }
        int n2 = (n + (6 - this.getFacing())) % 6;
        return n2 >= 3 ? (this.getFacing() + 5) % 6 : (this.getFacing() + 1) % 6;
    }

    public boolean hasRearArmor(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    public int getArmor(int n, boolean bl) {
        if (bl && this.hasRearArmor(n)) {
            return this.rearArmor[n];
        }
        return super.getArmor(n, bl);
    }

    public int getOArmor(int n, boolean bl) {
        if (bl && this.hasRearArmor(n)) {
            return this.orig_rearArmor[n];
        }
        return super.getOArmor(n, bl);
    }

    public void setArmor(int n, int n2, boolean bl) {
        if (bl && this.hasRearArmor(n2)) {
            this.rearArmor[n2] = n;
        } else {
            super.setArmor(n, n2, bl);
        }
    }

    public void initializeRearArmor(int n, int n2) {
        this.orig_rearArmor[n2] = n;
        this.setArmor(n, n2, true);
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.isRearMounted()) {
            return 4;
        }
        switch (mounted.getLocation()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return 1;
            }
            case 4: {
                return this.getArmsFlipped() ? 4 : 3;
            }
            case 5: {
                return this.getArmsFlipped() ? 4 : 2;
            }
        }
        return 0;
    }

    public boolean isSecondaryArcWeapon(int n) {
        return this.getEquipment(n).getLocation() != 6 && this.getEquipment(n).getLocation() != 7;
    }

    public HitData rollHitLocation(int n, int n2) {
        return this.rollHitLocation(n, n2, -1, 0);
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        PrintWriter printWriter;
        int n5 = -1;
        if (n3 != -1 && n4 == 2) {
            return new HitData(n3, n2 == 1, true);
        }
        if (n3 != -1 && n4 == 1 && 5 < (n5 = Compute.d6(2)) && n5 < 9) {
            return new HitData(n3, n2 == 1, true);
        }
        if (n == 0 || n == 6) {
            n5 = Compute.d6(2);
            try {
                printWriter = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (printWriter != null) {
                    printWriter.print(n);
                    printWriter.print("\t");
                    printWriter.print(n2);
                    printWriter.print("\t");
                    printWriter.println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0) {
                if (this.game.getOptions().booleanOption("quad_hit_location") && this.isProne()) {
                    switch (n5) {
                        case 2: {
                            return this.tac(n, n2, 1, false);
                        }
                        case 3: {
                            return new HitData(6);
                        }
                        case 4: 
                        case 5: {
                            return new HitData(4);
                        }
                        case 6: {
                            return new HitData(2);
                        }
                        case 7: {
                            return new HitData(1);
                        }
                        case 8: {
                            return new HitData(3);
                        }
                        case 9: 
                        case 10: {
                            return new HitData(5);
                        }
                        case 11: {
                            return new HitData(7);
                        }
                        case 12: {
                            return new HitData(0);
                        }
                    }
                } else {
                    switch (n5) {
                        case 2: {
                            return this.tac(n, n2, 1, false);
                        }
                        case 3: 
                        case 4: {
                            return new HitData(4);
                        }
                        case 5: {
                            return new HitData(6);
                        }
                        case 6: {
                            return new HitData(2);
                        }
                        case 7: {
                            return new HitData(1);
                        }
                        case 8: {
                            return new HitData(3);
                        }
                        case 9: {
                            return new HitData(7);
                        }
                        case 10: 
                        case 11: {
                            return new HitData(5);
                        }
                        case 12: {
                            return new HitData(0);
                        }
                    }
                }
            } else if (n2 == 2) {
                switch (n5) {
                    case 2: {
                        return this.tac(n, n2, 3, false);
                    }
                    case 3: {
                        return new HitData(7);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(5);
                    }
                    case 6: {
                        return new HitData(7);
                    }
                    case 7: {
                        return new HitData(3);
                    }
                    case 8: {
                        return new HitData(1);
                    }
                    case 9: {
                        return new HitData(2);
                    }
                    case 10: {
                        return new HitData(4);
                    }
                    case 11: {
                        return new HitData(6);
                    }
                    case 12: {
                        return new HitData(0);
                    }
                }
            } else if (n2 == 3) {
                switch (n5) {
                    case 2: {
                        return this.tac(n, n2, 2, false);
                    }
                    case 3: {
                        return new HitData(6);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(6);
                    }
                    case 7: {
                        return new HitData(2);
                    }
                    case 8: {
                        return new HitData(1);
                    }
                    case 9: {
                        return new HitData(3);
                    }
                    case 10: {
                        return new HitData(5);
                    }
                    case 11: {
                        return new HitData(7);
                    }
                    case 12: {
                        return new HitData(0);
                    }
                }
            } else if (n2 == 1) {
                if (this.game.getOptions().booleanOption("quad_hit_location") && this.isProne()) {
                    switch (n5) {
                        case 2: {
                            return this.tac(n, n2, 1, true);
                        }
                        case 3: {
                            return new HitData(4, true);
                        }
                        case 4: 
                        case 5: {
                            return new HitData(6, true);
                        }
                        case 6: {
                            return new HitData(2, true);
                        }
                        case 7: {
                            return new HitData(1, true);
                        }
                        case 8: {
                            return new HitData(3, true);
                        }
                        case 9: 
                        case 10: {
                            return new HitData(7, true);
                        }
                        case 11: {
                            return new HitData(5, true);
                        }
                        case 12: {
                            return new HitData(0, true);
                        }
                    }
                } else {
                    switch (n5) {
                        case 2: {
                            return this.tac(n, n2, 1, true);
                        }
                        case 3: 
                        case 4: {
                            return new HitData(4, true);
                        }
                        case 5: {
                            return new HitData(6, true);
                        }
                        case 6: {
                            return new HitData(2, true);
                        }
                        case 7: {
                            return new HitData(1, true);
                        }
                        case 8: {
                            return new HitData(3, true);
                        }
                        case 9: {
                            return new HitData(7, true);
                        }
                        case 10: 
                        case 11: {
                            return new HitData(5, true);
                        }
                        case 12: {
                            return new HitData(0, true);
                        }
                    }
                }
            }
        }
        if (n == 1) {
            n5 = Compute.d6(1);
            try {
                printWriter = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (printWriter != null) {
                    printWriter.print(n);
                    printWriter.print("\t");
                    printWriter.print(n2);
                    printWriter.print("\t");
                    printWriter.println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0) {
                switch (n5) {
                    case 1: {
                        return new HitData(5);
                    }
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: {
                        return new HitData(2);
                    }
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 2) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(5);
                    }
                    case 6: {
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 3) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        return new HitData(2);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 1) {
                switch (n5) {
                    case 1: {
                        return new HitData(5, true);
                    }
                    case 2: {
                        return new HitData(3, true);
                    }
                    case 3: {
                        return new HitData(1, true);
                    }
                    case 4: {
                        return new HitData(2, true);
                    }
                    case 5: {
                        return new HitData(4, true);
                    }
                    case 6: {
                        return new HitData(0, true);
                    }
                }
            }
        }
        if (n == 2) {
            n5 = Compute.d6(1);
            try {
                printWriter = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (printWriter != null) {
                    printWriter.print(n);
                    printWriter.print("\t");
                    printWriter.print(n2);
                    printWriter.print("\t");
                    printWriter.println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0 || n2 == 1) {
                switch (n5) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return new HitData(6, n2 == 1);
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        return new HitData(7, n2 == 1);
                    }
                }
            }
            if (n2 == 2) {
                return new HitData(7);
            }
            if (n2 == 3) {
                return new HitData(6);
            }
        }
        if (n == 3) {
            n5 = Compute.d6(2);
            try {
                printWriter = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (printWriter != null) {
                    printWriter.print(n);
                    printWriter.print("\t");
                    printWriter.print(n2);
                    printWriter.print("\t");
                    printWriter.println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 2: {
                    return new HitData(0, false, 1);
                }
                case 3: {
                    return new HitData(1, true, 1);
                }
                case 4: {
                    return new HitData(2, true, 1);
                }
                case 5: {
                    return new HitData(2, false, 1);
                }
                case 6: {
                    return new HitData(4, false, 1);
                }
                case 7: {
                    return new HitData(1, false, 1);
                }
                case 8: {
                    return new HitData(5, false, 1);
                }
                case 9: {
                    return new HitData(3, false, 1);
                }
                case 10: {
                    return new HitData(3, true, 1);
                }
                case 11: {
                    return new HitData(1, true, 1);
                }
                case 12: {
                    return new HitData(0, false, 1);
                }
            }
        }
        if (n == 4) {
            n5 = Compute.d6(1);
            try {
                printWriter = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (printWriter != null) {
                    printWriter.print(n);
                    printWriter.print("\t");
                    printWriter.print(n2);
                    printWriter.print("\t");
                    printWriter.println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 1: {
                    return new HitData(5, n2 == 1);
                }
                case 2: {
                    return new HitData(3, n2 == 1);
                }
                case 3: {
                    return new HitData(1, n2 == 1);
                }
                case 4: {
                    return new HitData(2, n2 == 1);
                }
                case 5: {
                    return new HitData(4, n2 == 1);
                }
                case 6: {
                    return new HitData(0, n2 == 1);
                }
            }
        }
        if (n == 5) {
            n5 = Compute.d6(1);
            try {
                printWriter = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (printWriter != null) {
                    printWriter.print(n);
                    printWriter.print("\t");
                    printWriter.print(n2);
                    printWriter.print("\t");
                    printWriter.println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 1: {
                    return new HitData(7, n2 == 1);
                }
                case 2: {
                    return new HitData(7, n2 == 1);
                }
                case 3: {
                    return new HitData(3, n2 == 1);
                }
                case 4: {
                    return new HitData(2, n2 == 1);
                }
                case 5: {
                    return new HitData(6, n2 == 1);
                }
                case 6: {
                    return new HitData(6, n2 == 1);
                }
            }
        }
        return null;
    }

    protected HitData tac(int n, int n2, int n3, boolean bl) {
        if (this.game.getOptions().booleanOption("no_tac")) {
            return new HitData(n3, bl);
        }
        if (this.game.getOptions().booleanOption("floating_crits")) {
            HitData hitData = this.rollHitLocation(n, n2);
            return new HitData(hitData.getLocation(), hitData.isRear(), 1);
        }
        return new HitData(n3, bl, 1);
    }

    public HitData getTransferLocation(HitData hitData) {
        switch (hitData.getLocation()) {
            case 2: 
            case 3: {
                return new HitData(1, hitData.isRear());
            }
            case 5: 
            case 7: {
                return new HitData(3, hitData.isRear());
            }
            case 4: 
            case 6: {
                return new HitData(2, hitData.isRear());
            }
        }
        return new HitData(-2);
    }

    public int getDependentLocation(int n) {
        switch (n) {
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
        }
        return -1;
    }

    public abstract void setInternal(int var1, int var2, int var3, int var4, int var5);

    public void autoSetInternal() {
        switch ((int)this.weight) {
            case 10: {
                this.setInternal(3, 4, 3, 1, 2);
                break;
            }
            case 15: {
                this.setInternal(3, 5, 4, 2, 3);
                break;
            }
            case 20: {
                this.setInternal(3, 6, 5, 3, 4);
                break;
            }
            case 25: {
                this.setInternal(3, 8, 6, 4, 6);
                break;
            }
            case 30: {
                this.setInternal(3, 10, 7, 5, 7);
                break;
            }
            case 35: {
                this.setInternal(3, 11, 8, 6, 8);
                break;
            }
            case 40: {
                this.setInternal(3, 12, 10, 6, 10);
                break;
            }
            case 45: {
                this.setInternal(3, 14, 11, 7, 11);
                break;
            }
            case 50: {
                this.setInternal(3, 16, 12, 8, 12);
                break;
            }
            case 55: {
                this.setInternal(3, 18, 13, 9, 13);
                break;
            }
            case 60: {
                this.setInternal(3, 20, 14, 10, 14);
                break;
            }
            case 65: {
                this.setInternal(3, 21, 15, 10, 15);
                break;
            }
            case 70: {
                this.setInternal(3, 22, 15, 11, 15);
                break;
            }
            case 75: {
                this.setInternal(3, 23, 16, 12, 16);
                break;
            }
            case 80: {
                this.setInternal(3, 25, 17, 13, 17);
                break;
            }
            case 85: {
                this.setInternal(3, 27, 18, 14, 18);
                break;
            }
            case 90: {
                this.setInternal(3, 29, 19, 15, 19);
                break;
            }
            case 95: {
                this.setInternal(3, 30, 20, 16, 20);
                break;
            }
            case 100: {
                this.setInternal(3, 31, 21, 17, 21);
            }
        }
    }

    public void addClanCase() {
        boolean bl = false;
        EquipmentType equipmentType = EquipmentType.get("CLCASE");
        for (int i = 0; i < this.locations(); ++i) {
            bl = false;
            Enumeration enumeration = this.getEquipment();
            while (enumeration.hasMoreElements()) {
                Mounted mounted = (Mounted)enumeration.nextElement();
                if (!mounted.getType().isExplosive() || mounted.getLocation() != i) continue;
                bl = true;
            }
            if (!bl) continue;
            try {
                this.addEquipment(new Mounted(this, equipmentType), i, false);
                continue;
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
    }

    public void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        if (n == -1) {
            super.addEquipment(mounted, n, bl);
            return;
        }
        int n2 = mounted.getType().getCriticals(this);
        if (mounted.getType().isSpreadable() || mounted.isSplit()) {
            n2 = 1;
        }
        if (this.getEmptyCriticals(n) < n2) {
            throw new LocationFullException(mounted.getName() + " does not fit in " + this.getLocationAbbr(n) + " on " + this.getDisplayName() + "\n        free criticals in location: " + this.getEmptyCriticals(n) + ", criticals needed: " + n2);
        }
        if (this.getEquipmentNum(mounted) == -1) {
            super.addEquipment(mounted, n, bl);
        }
        int n3 = this.getEquipmentNum(mounted);
        for (int i = 0; i < n2; ++i) {
            this.addCritical(n, new CriticalSlot(1, n3, mounted.getType().isHittable()));
        }
    }

    public int calculateBattleValue() {
        return this.calculateBattleValue(false);
    }

    public int calculateBattleValue(boolean bl) {
        Object object;
        Mounted mounted;
        Object object2;
        int n;
        int n2;
        int n3;
        Object object3;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl2 = this.hasStealth();
        boolean bl3 = this.hasEiCockpit() && this.getCrew().getOptions().booleanOption("ei_implant");
        d += (double)this.getTotalArmor() * 2.0;
        double d3 = this.hasXL() ? (this.isClan() ? 1.125 : 0.75) : (this.hasLightEngine() ? 1.125 : 1.5);
        d += (double)this.getTotalInternal() * d3;
        d += (double)this.getWeight();
        if (this.getGyroType() == 3) {
            d += 30.0;
        }
        double d4 = 0.0;
        Enumeration enumeration = this.equipmentList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted2 = (Mounted)enumeration.nextElement();
            object3 = mounted2.getType();
            if (mounted2.isDestroyed() || !(object3 instanceof WeaponType && ((EquipmentType)object3).hasFlag(0x1000000) || object3 instanceof AmmoType && ((AmmoType)object3).getAmmoType() == 14) && !((EquipmentType)object3).hasFlag(1024)) continue;
            d4 += ((EquipmentType)object3).getBV(this);
        }
        d += d4;
        if (bl3) {
            d -= 25.0;
        }
        double d5 = 0.0;
        object3 = this.equipmentList.elements();
        while (object3.hasMoreElements()) {
            Mounted mounted3 = (Mounted)object3.nextElement();
            int n4 = mounted3.getLocation();
            EquipmentType equipmentType = mounted3.getType();
            if (!equipmentType.isExplosive() || n4 == -1 || (this.isClan() ? n4 != 1 && n4 != 6 && n4 != 7 && n4 != 0 : !this.hasXL() && ((n4 == 2 || n4 == 3) && this.locationHasCase(n4) || n4 == 5 && (this.locationHasCase(n4) || this.locationHasCase(3)) || n4 == 4 && (this.locationHasCase(n4) || this.locationHasCase(2))))) continue;
            float f = equipmentType.getTonnage(this);
            if (equipmentType instanceof WeaponType && equipmentType.getName().indexOf("Gauss") != -1) {
                f = 1.0f;
            }
            if (equipmentType instanceof WeaponType && ((WeaponType)equipmentType).getAmmoType() == 23) {
                f = 0.0f;
            }
            if (equipmentType instanceof WeaponType && ((WeaponType)equipmentType).getAmmoType() == 1) {
                f = 0.0f;
            }
            d5 += 20.0 * (double)f;
        }
        d = Math.max(1.0, d - d5);
        double d6 = 0.0;
        double d7 = 0.0;
        Enumeration enumeration2 = this.weaponList.elements();
        while (enumeration2.hasMoreElements()) {
            Mounted mounted4 = (Mounted)enumeration2.nextElement();
            WeaponType weaponType = (WeaponType)mounted4.getType();
            double d8 = weaponType.getHeat();
            if (weaponType.getAmmoType() == 30) continue;
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34) {
                d8 *= 2.0;
            }
            if (weaponType.getAmmoType() == 23) {
                d8 *= 6.0;
            }
            if (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 32) {
                d8 *= 0.5;
            }
            if (mounted4.isRearMounted()) {
                d7 += d8;
                continue;
            }
            d6 += d8;
        }
        double d9 = Math.max(d6, d7);
        d9 = this.getJumpMP() > 0 ? (d9 += (double)Math.max(3, this.getJumpMP())) : (d9 += 2.0);
        if (bl2) {
            d9 += 10.0;
        }
        if (d9 > (double)this.getHeatCapacity()) {
            double d10 = (d9 - (double)this.getHeatCapacity()) * 5.0;
            d = Math.max(1.0, d - d10);
        }
        int n5 = this.getOriginalRunMPwithoutMASC();
        if (this.hasMASC()) {
            n5 = this.getWalkMP() * 2;
        }
        if (this.hasTSM()) {
            n5 = (int)Math.ceil((double)(this.getWalkMP() + 1) * 1.5);
        }
        if ((n3 = Math.max(n2 = Compute.getTargetMovementModifier(n5, false, false, false).getValue(), n = Compute.getTargetMovementModifier(this.getOriginalJumpMP(), true, false, false).getValue())) > 5) {
            n3 = 5;
        }
        double[] dArray = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5};
        double d11 = dArray[n3];
        if (bl2) {
            d11 += 0.2;
        }
        d *= d11;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        boolean bl4 = this.hasTargComp();
        Enumeration enumeration3 = this.weaponList.elements();
        while (enumeration3.hasMoreElements()) {
            Mounted mounted5 = (Mounted)enumeration3.nextElement();
            object2 = (WeaponType)mounted5.getType();
            double d15 = ((EquipmentType)object2).getBV(this);
            if (mounted5.isDestroyed() || ((EquipmentType)object2).hasFlag(0x1000000)) continue;
            if (mounted5.getLinkedBy() != null && (mounted = mounted5.getLinkedBy()).getType() instanceof MiscType && mounted.getType().hasFlag(512)) {
                d15 *= 1.2;
            }
            if (((EquipmentType)object2).hasFlag(1)) {
                if (bl3 && bl4) {
                    d15 *= 1.25;
                } else if (bl4) {
                    d15 *= 1.2;
                } else if (bl3) {
                    d15 *= 1.05;
                }
            }
            if (mounted5.isRearMounted()) {
                d14 += d15;
                continue;
            }
            d13 += d15;
        }
        if (d13 > d14) {
            d12 += d13;
            d12 += d14 * 0.5;
        } else {
            d12 += d14;
            d12 += d13 * 0.5;
        }
        double d16 = 0.0;
        object2 = this.miscList.elements();
        while (object2.hasMoreElements()) {
            Mounted mounted6 = (Mounted)object2.nextElement();
            object = (MiscType)mounted6.getType();
            if (mounted6.isDestroyed() || (!((EquipmentType)object).hasFlag(0x8000000) || !((EquipmentType)object).hasSubType(4) && !((EquipmentType)object).hasSubType(8) && !((EquipmentType)object).hasSubType(16) && !((EquipmentType)object).hasSubType(64) && !((EquipmentType)object).hasSubType(262144) && !((EquipmentType)object).hasSubType(512) && !((EquipmentType)object).hasSubType(0x100000) && !((EquipmentType)object).hasSubType(128)) && !((EquipmentType)object).hasFlag(8192) && !((EquipmentType)object).hasFlag(0x2000000)) continue;
            d16 += ((MiscType)object).getBV(this);
        }
        d12 += d16;
        double d17 = 0.0;
        object = this.ammoList.elements();
        while (object.hasMoreElements()) {
            mounted = (Mounted)object.nextElement();
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || mounted.getLocation() == -1) continue;
            d17 += ammoType.getBV(this);
        }
        d12 += d17;
        if (d9 > (double)this.getHeatCapacity()) {
            double d18 = (double)this.getHeatCapacity() * d12 / d9;
            double d19 = (d12 - d18) / 2.0;
            d12 = d18 + d19;
        }
        double d20 = this.getOriginalRunMPwithoutMASC() + this.getOriginalJumpMP() - 5;
        if (this.hasMASC() || this.hasTSM()) {
            d20 += 1.0;
        }
        d20 /= 10.0;
        d20 += 1.0;
        d20 = Math.pow(d20, 1.2);
        d20 = (double)Math.round(d20 * 100.0) / 100.0;
        d2 = d12 * d20;
        double d21 = 0.0;
        if (this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) {
            d21 = Math.round(0.35 * d13 + 0.5 * d14);
        }
        if (this.getsTagBVPenalty()) {
            d += 200.0;
        }
        if (this.getsHomingBVPenalty()) {
            d += 200.0;
        }
        double d22 = this.crew.getBVSkillMultiplier();
        if (bl3) {
            d22 += 0.05;
        }
        if (this.getCockpitType() == 2) {
            d22 -= 0.05;
        }
        return (int)Math.round((d + d2 + d21) * d22);
    }

    public Vector victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7030);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        Entity.combineVectors(vector, this.crew.getDescVector(false));
        report = new Report(7070, 0);
        report.newlines = 2;
        report.add(this.getKillNumber());
        vector.addElement(report);
        return vector;
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        if (this.getBadCriticals(0, 4, 1) > 0) {
            pilotingRollData.addModifier(3, "Gyro damaged");
        }
        if (this.hasActiveEiCockpit()) {
            pilotingRollData.addModifier(-1, "Enhanced Imaging");
        }
        if (this.getCockpitType() == 2) {
            pilotingRollData.addModifier(1, "Small Cockpit");
        }
        return pilotingRollData;
    }

    public int getMaxElevationChange() {
        return 2;
    }

    public boolean isStealthActive() {
        Enumeration enumeration = this.getMisc();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            MiscType miscType = (MiscType)mounted.getType();
            if (!(STEALTH.equals(miscType.getInternalName()) ? mounted.curMode().equals("On") && this.hasActiveECM() : NULLSIG.equals(miscType.getInternalName()) && mounted.curMode().equals("On") && mounted.isReady())) continue;
            return true;
        }
        return false;
    }

    public TargetRoll getStealthModifier(int n) {
        TargetRoll targetRoll = null;
        if (!this.isStealthActive()) {
            targetRoll = new TargetRoll(0, "stealth not active");
        } else {
            switch (n) {
                case 0: 
                case 1: {
                    targetRoll = new TargetRoll(0, "stealth");
                    break;
                }
                case 2: {
                    targetRoll = new TargetRoll(1, "stealth");
                    break;
                }
                case 3: 
                case 4: {
                    targetRoll = new TargetRoll(2, "stealth");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown range constant: " + n);
                }
            }
        }
        return targetRoll;
    }

    public boolean isRepairable() {
        int n = this.getInternal(1);
        return this.isSalvage() && n != -2 && n != -3;
    }

    public boolean canCharge() {
        return super.canCharge() && (!this.game.getOptions().booleanOption("no_clan_physical") || !this.isClan());
    }

    public boolean canDFA() {
        return super.canDFA() && (!this.game.getOptions().booleanOption("no_clan_physical") || !this.isClan());
    }

    public int getNumberOfSinks() {
        int n = 0;
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.isDestroyed() || mounted.isBreached()) continue;
            if (mounted.getType().hasFlag(1)) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(2)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasDoubleHeatSinks() {
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.getType().hasFlag(1)) {
                return false;
            }
            if (!mounted.getType().hasFlag(2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLaserHeatSinks() {
        Enumeration enumeration = this.miscList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (mounted.getType().hasFlag(1)) {
                return false;
            }
            if (!mounted.getType().hasFlag(64)) continue;
            return true;
        }
        return false;
    }

    public void setActiveSinksNextRound(int n) {
        this.sinksChanged = n != this.getNumberOfSinks();
        this.sinksOnNextRound = n;
    }

    public int getActiveSinks() {
        if (this.sinksChanged) {
            return this.sinksOn;
        }
        return this.getNumberOfSinks();
    }

    public boolean isAutoEject() {
        return this.autoEject;
    }

    public void setAutoEject(boolean bl) {
        this.autoEject = bl;
    }

    public boolean removePartialCoverHits(int n, int n2, int n3) {
        if (n3 == 0) {
            if ((n2 & 2) != 0 && n == 7) {
                return true;
            }
            if ((n2 & 1) != 0 && n == 6) {
                return true;
            }
            if ((n2 & 8) != 0 && (n == 5 || n == 3)) {
                return true;
            }
            if ((n2 & 4) != 0 && (n == 4 || n == 2)) {
                return true;
            }
        } else {
            if ((n2 & 1) != 0 && n == 7) {
                return true;
            }
            if ((n2 & 2) != 0 && n == 6) {
                return true;
            }
            if ((n2 & 4) != 0 && (n == 5 || n == 3)) {
                return true;
            }
            if ((n2 & 8) != 0 && (n == 4 || n == 2)) {
                return true;
            }
        }
        return false;
    }

    public boolean doomedInVacuum() {
        return false;
    }

    public boolean hasEiCockpit() {
        return this.isClan() || super.hasEiCockpit();
    }

    public boolean hasActiveEiCockpit() {
        if (this.cockpitStatus == 0) {
            return false;
        }
        if (this.getBadCriticals(0, 1, 0) > 0) {
            return false;
        }
        return super.hasActiveEiCockpit();
    }

    public int getCockpitStatus() {
        return this.cockpitStatus;
    }

    public int getCockpitStatusNextRound() {
        return this.cockpitStatusNextRound;
    }

    public void setCockpitStatus(int n) {
        this.cockpitStatusNextRound = n;
        if (n != 0 && this.cockpitStatus != 0) {
            this.cockpitStatus = n;
        }
    }

    public int getGyroType() {
        return this.gyroType;
    }

    public int getCockpitType() {
        return this.cockpitType;
    }

    public void setGyroType(int n) {
        this.gyroType = n;
    }

    public void setCockpitType(int n) {
        this.cockpitType = n;
    }

    public String getGyroTypeString() {
        return Mech.getGyroTypeString(this.getGyroType());
    }

    public String getCockpitTypeString() {
        return Mech.getCockpitTypeString(this.getCockpitType());
    }

    public static String getGyroTypeString(int n) {
        if (n < 0 || n >= GYRO_STRING.length) {
            return "Unknown";
        }
        return GYRO_STRING[n];
    }

    public static String getGyroTypeShortString(int n) {
        if (n < 0 || n >= GYRO_SHORT_STRING.length) {
            return "Unknown";
        }
        return GYRO_SHORT_STRING[n];
    }

    public static String getCockpitTypeString(int n) {
        if (n < 0 || n >= COCKPIT_STRING.length) {
            return "Unknown";
        }
        return COCKPIT_STRING[n];
    }

    public static int getGyroTypeForString(String string) {
        if (string == null || string.length() < 1) {
            return -1;
        }
        for (int i = 0; i < GYRO_STRING.length; ++i) {
            if (!string.equals(GYRO_STRING[i]) && !string.equals(GYRO_SHORT_STRING[i])) continue;
            return i;
        }
        return -1;
    }

    public static int getCockpitTypeForString(String string) {
        if (string == null || string.length() < 1) {
            return -1;
        }
        for (int i = 0; i < COCKPIT_STRING.length; ++i) {
            if (!string.equals(COCKPIT_STRING[i]) && !string.equals(COCKPIT_SHORT_STRING[i])) continue;
            return i;
        }
        return -1;
    }

    public String getSystemName(int n) {
        if (n == 4) {
            return Mech.getGyroDisplayString(this.gyroType);
        }
        if (n == 2) {
            return Mech.getCockpitDisplayString(this.cockpitType);
        }
        return systemNames[n];
    }

    public static String getGyroDisplayString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "GYRO_XL";
                break;
            }
            case 2: {
                string = "GYRO_COMPACT";
                break;
            }
            case 3: {
                string = "GYRO_HEAVY_DUTY";
                break;
            }
            case 0: {
                string = "GYRO_STANDARD";
                break;
            }
            default: {
                string = "GYRO_UNKNOWN";
            }
        }
        String string2 = EquipmentMessages.getString("SystemType.Gyro." + string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static String getCockpitDisplayString(int n) {
        String string = "";
        switch (n) {
            case 3: {
                string = "COCKPIT_COMMAND_CONSOLE";
                break;
            }
            case 2: {
                string = "COCKPIT_SMALL";
                break;
            }
            case 1: {
                string = "COCKPIT_TORSO_MOUNTED";
                break;
            }
            case 4: {
                string = "COCKPIT_DUAL";
                break;
            }
            case 0: {
                string = "COCKPIT_STANDARD";
                break;
            }
            default: {
                string = "GYRO_UNKNOWN";
            }
        }
        String string2 = EquipmentMessages.getString("SystemType.Cockpit." + string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public boolean canAssaultDrop() {
        return true;
    }

    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(30)) {
            return true;
        }
        return iHex.terrainLevel(1) > 2 || iHex.terrainLevel(23) > 2;
    }
}

