/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipFile;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.WeaponType;
import megamek.common.loaders.BLKBattleArmorFile;
import megamek.common.loaders.BLKInfantryFile;
import megamek.common.loaders.BLKMechFile;
import megamek.common.loaders.BLKProtoFile;
import megamek.common.loaders.BLKTankFile;
import megamek.common.loaders.BLKVTOLFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.HmpFile;
import megamek.common.loaders.HmvFile;
import megamek.common.loaders.MepFile;
import megamek.common.loaders.MtfFile;
import megamek.common.loaders.TdbFile;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.BuildingBlock;

public class MechFileParser {
    private Entity m_entity = null;
    private static Vector canonUnitNames = null;
    private static final File ROOT = new File(PreferenceManager.getClientPreferences().getMechDirectory());
    private static final File OFFICIALUNITS = new File(ROOT, "OfficialUnitList.txt");

    public MechFileParser(File file) throws EntityLoadingException {
        this(file, null);
    }

    public MechFileParser(File file, String string) throws EntityLoadingException {
        if (string == null) {
            try {
                this.parse(new FileInputStream(file), file.getName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (exception instanceof EntityLoadingException) {
                    throw new EntityLoadingException("While parsing file " + file.getName() + ", " + exception.getMessage());
                }
                throw new EntityLoadingException("Exception from " + exception.getClass() + ": " + exception.getMessage());
            }
        }
        try {
            ZipFile zipFile = new ZipFile(file);
            this.parse(zipFile.getInputStream(zipFile.getEntry(string)), string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof EntityLoadingException) {
                throw new EntityLoadingException(exception.getMessage());
            }
            throw new EntityLoadingException("Exception from " + exception.getClass() + ": " + exception.getMessage());
        }
    }

    public MechFileParser(InputStream inputStream, String string) throws EntityLoadingException {
        try {
            this.parse(inputStream, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof EntityLoadingException) {
                throw new EntityLoadingException(exception.getMessage());
            }
            throw new EntityLoadingException("Exception from " + exception.getClass() + ": " + exception.getMessage());
        }
    }

    public Entity getEntity() {
        return this.m_entity;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(InputStream inputStream, String string) throws EntityLoadingException {
        void var4_18;
        String string2 = string.toLowerCase();
        if (string2.endsWith(".mep")) {
            MepFile mepFile = new MepFile(inputStream);
        } else if (string2.endsWith(".mtf")) {
            MtfFile mtfFile = new MtfFile(inputStream);
        } else if (string2.endsWith(".hmp")) {
            HmpFile hmpFile = new HmpFile(inputStream);
        } else if (string2.endsWith(".hmv")) {
            HmvFile hmvFile = new HmvFile(inputStream);
        } else if (string2.endsWith(".xml")) {
            TdbFile tdbFile = new TdbFile(inputStream);
        } else if (string2.endsWith(".blk")) {
            BuildingBlock buildingBlock = new BuildingBlock(inputStream);
            if (buildingBlock.exists("UnitType")) {
                String string3 = buildingBlock.getDataAsString("UnitType")[0];
                if (string3.equals("Tank") || string3.equals("Naval") || string3.equals("Surface") || string3.equals("Hydrofoil")) {
                    BLKTankFile bLKTankFile = new BLKTankFile(buildingBlock);
                } else if (string3.equals("Infantry")) {
                    BLKInfantryFile bLKInfantryFile = new BLKInfantryFile(buildingBlock);
                } else if (string3.equals("BattleArmor")) {
                    BLKBattleArmorFile bLKBattleArmorFile = new BLKBattleArmorFile(buildingBlock);
                } else if (string3.equals("ProtoMech")) {
                    BLKProtoFile bLKProtoFile = new BLKProtoFile(buildingBlock);
                } else if (string3.equals("Mech")) {
                    BLKMechFile bLKMechFile = new BLKMechFile(buildingBlock);
                } else {
                    if (!string3.equals("VTOL")) throw new EntityLoadingException("Unknown UnitType: " + string3);
                    BLKVTOLFile bLKVTOLFile = new BLKVTOLFile(buildingBlock);
                }
            } else {
                BLKMechFile bLKMechFile = new BLKMechFile(buildingBlock);
            }
        } else {
            if (!string2.endsWith(".dbm")) throw new EntityLoadingException("Unsupported file suffix");
            throw new EntityLoadingException("In order to use mechs from The Drawing Board with MegaMek, you must save your mech as an XML file (look in the 'File' menu of TDB.)  Then use the resulting '.xml' file instead of the '.dbm' file.  Note that only version 2.0.23 or later of TDB is compatible with MegaMek.");
        }
        this.m_entity = var4_18.getEntity();
        this.postLoadInit(this.m_entity);
    }

    private void postLoadInit(Entity entity) throws EntityLoadingException {
        Object object;
        Object object2;
        block11: {
            Object object3;
            object2 = entity.getMisc();
            while (object2.hasMoreElements()) {
                EquipmentType equipmentType;
                Mounted mounted;
                object = (Mounted)object2.nextElement();
                if (((Mounted)object).getType().hasFlag(512) && ((Mounted)object).getLinked() == null) {
                    object3 = entity.getWeapons();
                    while (object3.hasMoreElements()) {
                        mounted = (Mounted)object3.nextElement();
                        equipmentType = (WeaponType)mounted.getType();
                        if (((WeaponType)equipmentType).getAmmoType() != 7 && ((WeaponType)equipmentType).getAmmoType() != 9 || mounted.getLinkedBy() != null) continue;
                        if (mounted.getLocation() == ((Mounted)object).getLocation()) {
                            ((Mounted)object).setLinked(mounted);
                            break;
                        }
                        if (!(entity instanceof Mech) || ((Mounted)object).getLocation() != 0 || mounted.getLocation() != 1) continue;
                        ((Mounted)object).setLinked(mounted);
                        break;
                    }
                    if (((Mounted)object).getLinked() != null) continue;
                    throw new EntityLoadingException("Unable to match Artemis to launcher");
                }
                if (!"Mek Stealth".equals(((Mounted)object).getType().getInternalName()) || ((Mounted)object).getLinked() != null) continue;
                object3 = entity.getMisc();
                while (object3.hasMoreElements()) {
                    mounted = (Mounted)object3.nextElement();
                    equipmentType = (MiscType)mounted.getType();
                    if (!equipmentType.hasFlag(1024)) continue;
                    ((Mounted)object).setLinked(mounted);
                    break;
                }
                if (((Mounted)object).getLinked() != null) continue;
                throw new EntityLoadingException("Unable to find an ECM Suite.  Mechs with Stealth Armor must also be equipped with an ECM Suite.");
            }
            entity.setCanon(false);
            try {
                if (canonUnitNames != null) break block11;
                canonUnitNames = new Vector();
                object2 = null;
                try {
                    object2 = new BufferedReader(new FileReader(OFFICIALUNITS));
                    while ((object = ((BufferedReader)object2).readLine()) != null) {
                        int n = ((String)object).indexOf(124);
                        object3 = ((String)object).substring(0, n);
                        canonUnitNames.addElement(object3);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object2 = canonUnitNames.elements();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (!((String)object).equals(entity.getShortNameRaw())) continue;
            entity.setCanon(true);
            break;
        }
    }
}

