/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.Entity;
import megamek.common.ReportMessages;

public class Report
implements Serializable {
    public int messageId = -1;
    private static final int MESSAGE_NONE = -1;
    private int indentation = 0;
    public int newlines = 1;
    private Vector tagData = new Vector();
    public transient int type = 2;
    public static final int PUBLIC = 0;
    public static final int OBSCURED = 1;
    public static final int HIDDEN = 2;
    public static final int TESTING = 3;
    public transient int subject = -1;
    private Hashtable obscuredIndexes = new Hashtable();
    private Vector obscuredRecipients = new Vector();
    private transient int tagCounter = 0;
    private static final String OBSCURED_STRING = "???";
    private static final int DEFAULT_INDENTATION = 4;

    public Report() {
    }

    public Report(int n) {
        this.messageId = n;
    }

    public Report(int n, int n2) {
        this.messageId = n;
        this.type = n2;
    }

    public Report(Report report) {
        this.messageId = report.messageId;
        this.indentation = report.indentation;
        this.newlines = report.newlines;
        this.tagData = (Vector)report.tagData.clone();
        this.type = report.type;
        this.subject = report.subject;
        this.obscuredIndexes = (Hashtable)report.obscuredIndexes.clone();
        this.obscuredRecipients = (Vector)report.obscuredRecipients.clone();
        this.tagCounter = report.tagCounter;
    }

    public void add(int n) {
        this.add(n, false);
    }

    public void add(int n, boolean bl) {
        if (bl) {
            this.obscuredIndexes.put(new Integer(this.tagData.size()), new Boolean(true));
        }
        this.tagData.addElement(String.valueOf(n));
    }

    public void add(String string) {
        this.add(string, false);
    }

    public void add(String string, boolean bl) {
        if (bl) {
            this.obscuredIndexes.put(new Integer(this.tagData.size()), new Boolean(true));
        }
        this.tagData.addElement(string);
    }

    public void choose(boolean bl) {
        this.tagData.addElement(String.valueOf(bl));
    }

    private void choose(boolean bl, boolean bl2) {
        if (bl2) {
            this.obscuredIndexes.put(new Integer(this.tagData.size()), new Boolean(true));
        }
        this.tagData.addElement(String.valueOf(bl));
    }

    public void addDesc(Entity entity) {
        this.add(entity.getShortName(), true);
        this.add(entity.getOwner().getName());
    }

    public boolean isValueObscured(int n) {
        return this.obscuredIndexes.get(new Integer(n)) != null;
    }

    public void hideData(int n) {
        this.tagData.setElementAt(null, n);
    }

    public void indent() {
        this.indent(1);
    }

    public void indent(int n) {
        this.indentation += n * 4;
    }

    public int dataCount() {
        return this.tagData.size();
    }

    private String getTag() {
        return this.getTag(this.tagCounter);
    }

    private String getTag(int n) {
        try {
            String string = (String)this.tagData.elementAt(n);
            if (string == null) {
                return OBSCURED_STRING;
            }
            return string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Error: Report#getText --> Array Index out of Bounds Exception (index: " + n + ") for a report with ID " + this.messageId + ".  Maybe Report#add wasn't called enough times for the amount of tags in the message?");
            return "[Reporting Error: see MegaMek.log for details]";
        }
    }

    public String getText() {
        String string = ReportMessages.getString(String.valueOf(this.messageId));
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            System.out.println("Error: No message found for ID " + this.messageId);
            stringBuffer.append("[Reporting Error for message ID ").append(this.messageId).append("]");
        } else {
            int n = 0;
            int n2 = 0;
            while (n < string.length()) {
                if (string.charAt(n) == '<') {
                    int n3;
                    int n4 = string.indexOf(62, n);
                    if (string.indexOf(60, n + 1) != -1 && string.indexOf(60, n + 1) < n4) {
                        ++n;
                        continue;
                    }
                    stringBuffer.append(string.substring(n2, n));
                    if (string.substring(n + 1, n4).equals("data")) {
                        stringBuffer.append(this.getTag());
                        ++this.tagCounter;
                    } else if (string.substring(n + 1, n4).equals("list")) {
                        for (n3 = this.tagCounter; n3 < this.tagData.size(); ++n3) {
                            stringBuffer.append(this.getTag(n3)).append(", ");
                        }
                        stringBuffer.setLength(stringBuffer.length() - 2);
                    } else if (string.substring(n + 1, n4).startsWith("msg:")) {
                        n3 = Boolean.valueOf(this.getTag()).booleanValue() ? 1 : 0;
                        if (n3 != 0) {
                            stringBuffer.append(ReportMessages.getString(string.substring(n + 5, string.indexOf(44, n))));
                        } else {
                            stringBuffer.append(ReportMessages.getString(string.substring(string.indexOf(44, n) + 1, n4)));
                        }
                    } else if (string.substring(n + 1, n4).equals("newline")) {
                        stringBuffer.append("\n");
                    } else {
                        stringBuffer.append(string.substring(n, n4 + 1));
                    }
                    n2 = n4 + 1;
                    n = n4;
                }
                ++n;
            }
            stringBuffer.append(string.substring(n2));
            this.handleIndentation(stringBuffer);
            stringBuffer.append(this.getNewlines());
        }
        this.tagCounter = 0;
        if (this.type == 3) {
            Report.mark(stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void handleIndentation(StringBuffer stringBuffer) {
        if (this.indentation == 0 || stringBuffer.length() == 0) {
            return;
        }
        int n = 0;
        while (stringBuffer.charAt(n) == '\n') {
            if (++n != stringBuffer.length()) continue;
        }
        stringBuffer.insert(n, this.getSpaces());
    }

    private String getSpaces() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.indentation; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private String getNewlines() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.newlines; ++i) {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void addNewline(Vector vector) {
        ++((Report)vector.elementAt((int)(vector.size() - 1))).newlines;
    }

    public void addObscuredRecipient(String string) {
        this.obscuredRecipients.addElement(string);
    }

    public boolean isObscuredRecipient(String string) {
        for (int i = 0; i < this.obscuredRecipients.size(); ++i) {
            String string2 = (String)this.obscuredRecipients.elementAt(i);
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String string = new String();
        string = "Report(messageId=";
        string = string + this.messageId;
        string = string + ")";
        return string;
    }

    public void markForTesting() {
        this.type = 3;
    }

    private static StringBuffer mark(StringBuffer stringBuffer) {
        stringBuffer.insert(0, "<hidden>");
        int n = stringBuffer.length() - 1;
        while (stringBuffer.charAt(n) == '\n') {
            if (--n != 0) continue;
        }
        stringBuffer.insert(n + 1, "</hidden>");
        return stringBuffer;
    }
}

