/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.Report;
import megamek.common.WeaponType;

public class Tank
extends Entity
implements Serializable {
    private boolean m_bHasNoTurret = false;
    private boolean m_bTurretLocked = false;
    private int m_nTurretOffset = 0;
    private int m_nStunnedTurns = 0;
    private int m_nJammedTurns = 0;
    private Mounted m_jammedGun = null;
    private boolean m_bImmobile = false;
    private boolean m_bImmobileHit = false;
    private int burningLocations = 0;
    private int movementDamage = 0;
    public static final int LOC_BODY = 0;
    public static final int LOC_FRONT = 1;
    public static final int LOC_RIGHT = 2;
    public static final int LOC_LEFT = 3;
    public static final int LOC_REAR = 4;
    public static final int LOC_TURRET = 5;
    private static final int[] NUM_OF_SLOTS = new int[]{0, 0, 0, 0, 0, 0};
    protected static String[] LOCATION_ABBRS = new String[]{"BD", "FR", "RS", "LS", "RR", "TU"};
    protected static String[] LOCATION_NAMES = new String[]{"Body", "Front", "Right", "Left", "Rear", "Turret"};
    private int engineType = 0;
    private int armorType = 0;
    private int structureType = 0;

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public boolean hasNoTurret() {
        return this.m_bHasNoTurret;
    }

    public void setHasNoTurret(boolean bl) {
        this.m_bHasNoTurret = bl;
    }

    public int getWalkMP(boolean bl) {
        int n = bl ? this.applyGravityEffectsOnMP(this.getOriginalWalkMP()) : this.getOriginalWalkMP();
        if (this.game != null) {
            int n2 = this.game.getTemperatureDifference();
            return Math.max(n - n2, 0);
        }
        return n;
    }

    public boolean isTurretLocked() {
        return this.m_bTurretLocked;
    }

    public int locations() {
        return this.m_bHasNoTurret ? 5 : 6;
    }

    public boolean canChangeSecondaryFacing() {
        return !this.m_bHasNoTurret && !this.m_bTurretLocked;
    }

    public boolean isValidSecondaryFacing(int n) {
        return !this.m_bTurretLocked;
    }

    public int clipSecondaryFacing(int n) {
        return n;
    }

    public void setSecondaryFacing(int n) {
        if (!this.m_bTurretLocked) {
            super.setSecondaryFacing(n);
            if (!this.m_bHasNoTurret) {
                this.m_nTurretOffset = n - this.getFacing();
            }
        }
    }

    public void setFacing(int n) {
        super.setFacing(n);
        if (this.m_bTurretLocked) {
            int n2 = (n + this.m_nTurretOffset + 6) % 6;
            super.setSecondaryFacing(n2);
        }
    }

    public boolean isMovementHit() {
        return this.m_bImmobile;
    }

    public boolean isMovementHitPending() {
        return this.m_bImmobileHit;
    }

    public void immobilize() {
        this.m_bImmobileHit = true;
        this.setOriginalWalkMP(0);
    }

    public boolean isImmobile() {
        if (this.game.getOptions().booleanOption("no_immobile_vehicles")) {
            return super.isImmobile();
        }
        return super.isImmobile() || this.m_bImmobile;
    }

    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(30)) {
            return true;
        }
        switch (this.movementMode) {
            case 3: {
                return iHex.terrainLevel(1) > 1 || iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20) || iHex.containsTerrain(23) || iHex.terrainLevel(24) > 1;
            }
            case 4: {
                return iHex.containsTerrain(1) || iHex.containsTerrain(2) || iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20) || iHex.containsTerrain(3) || iHex.containsTerrain(24) || iHex.containsTerrain(23) || iHex.containsTerrain(28) || iHex.terrainLevel(22) == 2;
            }
            case 5: {
                return iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.terrainLevel(24) > 1;
            }
            case 7: 
            case 8: {
                return iHex.terrainLevel(4) <= 0 || iHex.containsTerrain(20);
            }
            case 9: {
                return iHex.terrainLevel(4) <= 0;
            }
        }
        return false;
    }

    public void lockTurret() {
        this.m_bTurretLocked = true;
    }

    public int getStunnedTurns() {
        return this.m_nStunnedTurns;
    }

    public void setStunnedTurns(int n) {
        this.m_nStunnedTurns = n;
        this.crew.setUnconscious(true);
    }

    public void stunCrew() {
        this.setStunnedTurns(3);
    }

    public int getJammedTurns() {
        return this.m_nJammedTurns;
    }

    public void setJammedTurns(int n) {
        if (null == this.m_jammedGun) {
            this.m_jammedGun = this.getMainWeapon();
            if (null != this.m_jammedGun) {
                this.m_jammedGun.setJammed(true);
            }
        }
        this.m_nJammedTurns = n;
    }

    public void applyDamage() {
        this.m_bImmobile |= this.m_bImmobileHit;
    }

    public void newRound(int n) {
        super.newRound(n);
        if (this.m_nStunnedTurns > 0) {
            --this.m_nStunnedTurns;
            if (this.m_nStunnedTurns == 0) {
                this.crew.setUnconscious(false);
            }
        }
        if (this.m_jammedGun != null) {
            if (this.m_nJammedTurns > 0) {
                --this.m_nJammedTurns;
            } else {
                this.m_jammedGun.setJammed(false);
                this.m_jammedGun = null;
            }
        }
        if (!this.m_bTurretLocked) {
            this.setSecondaryFacing(this.getFacing());
        }
    }

    public Mounted getMainWeapon() {
        double d = -1.0;
        Mounted mounted = null;
        Enumeration enumeration = this.getWeapons();
        while (enumeration.hasMoreElements()) {
            double d2;
            Mounted mounted2 = (Mounted)enumeration.nextElement();
            if (mounted2.isDestroyed() || !((d2 = mounted2.getType().getBV(this)) > d)) continue;
            d = d2;
            mounted = mounted2;
        }
        return mounted;
    }

    public String getMovementString(int n) {
        switch (n) {
            case -2: {
                return "Skidded";
            }
            case 0: {
                return "None";
            }
            case 1: {
                return "Cruised";
            }
            case 2: {
                return "Flanked";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case -2: {
                return "S";
            }
            case 0: {
                return "N";
            }
            case 1: {
                return "C";
            }
            case 2: {
                return "F";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    public boolean hasRearArmor(int n) {
        return false;
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.getLocation() == 1) {
            return 1;
        }
        if (mounted.getLocation() == 2) {
            return 6;
        }
        if (mounted.getLocation() == 3) {
            return 5;
        }
        if (mounted.getLocation() == 4) {
            return 4;
        }
        if (mounted.getLocation() == 5) {
            return 1;
        }
        return 0;
    }

    public boolean isSecondaryArcWeapon(int n) {
        return this.getEquipment(n).getLocation() == 5;
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        return this.rollHitLocation(n, n2);
    }

    public HitData rollHitLocation(int n, int n2) {
        int n3 = 1;
        boolean bl = false;
        if (n2 == 0 && this.isHullDown() && !this.m_bHasNoTurret) {
            n3 = 5;
        }
        if (n2 == 2) {
            n3 = 3;
            bl = true;
        } else if (n2 == 3) {
            n3 = 2;
            bl = true;
        } else if (n2 == 1) {
            n3 = 4;
        }
        switch (Compute.d6(2)) {
            case 2: {
                return new HitData(n3, false, 1);
            }
            case 3: {
                return new HitData(n3, false, 2);
            }
            case 4: {
                return new HitData(n3, false, 3);
            }
            case 5: {
                if (bl || this.getMovementMode() == 5 || this.getMovementMode() == 8) {
                    return new HitData(n3, false, 3);
                }
                return new HitData(n3);
            }
            case 6: 
            case 7: 
            case 8: {
                return new HitData(n3);
            }
            case 9: {
                if (bl && (this.getMovementMode() == 5 || this.getMovementMode() == 8)) {
                    return new HitData(n3, false, 3);
                }
                return new HitData(n3);
            }
            case 10: {
                if (this.m_bHasNoTurret) {
                    return new HitData(n3);
                }
                return new HitData(5);
            }
            case 11: {
                if (this.m_bHasNoTurret) {
                    return new HitData(n3);
                }
                return new HitData(5, false, 4);
            }
            case 12: {
                if (this.m_bHasNoTurret || bl) {
                    return new HitData(n3, false, 1);
                }
                return new HitData(5, false, 1);
            }
        }
        return null;
    }

    public HitData getTransferLocation(HitData hitData) {
        return new HitData(-2);
    }

    public int getDependentLocation(int n) {
        return -1;
    }

    public int calculateBattleValue() {
        return this.calculateBattleValue(false);
    }

    public int calculateBattleValue(boolean bl) {
        Object object;
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        d2 += (double)this.getTotalArmor();
        d2 += (double)(this.getTotalInternal() / 2);
        double d4 = 0.0;
        Enumeration enumeration = this.equipmentList.elements();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            EquipmentType equipmentType = mounted.getType();
            if (mounted.isDestroyed() || !(equipmentType instanceof WeaponType && equipmentType.hasFlag(0x1000000) || equipmentType instanceof AmmoType && ((AmmoType)equipmentType).getAmmoType() == 14) && !equipmentType.hasFlag(1024)) continue;
            d4 += equipmentType.getBV(this);
        }
        d2 += d4;
        switch (this.getMovementMode()) {
            case 3: {
                d = 0.8;
                break;
            }
            case 4: {
                d = 0.7;
                break;
            }
            case 5: {
                d = 0.6;
                break;
            }
            default: {
                d = 0.5;
            }
        }
        d2 *= d;
        int n = Compute.getTargetMovementModifier(this.getOriginalRunMP(), false, false, false).getValue();
        if (n > 5) {
            n = 5;
        }
        double[] dArray = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5};
        d2 *= dArray[n];
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl2 = this.hasTargComp();
        Enumeration enumeration2 = this.weaponList.elements();
        while (enumeration2.hasMoreElements()) {
            Mounted mounted;
            Mounted mounted2 = (Mounted)enumeration2.nextElement();
            object = (WeaponType)mounted2.getType();
            double d8 = ((EquipmentType)object).getBV(this);
            if (mounted2.isDestroyed() || ((EquipmentType)object).hasFlag(0x1000000)) continue;
            if (mounted2.getLinkedBy() != null && (mounted = mounted2.getLinkedBy()).getType() instanceof MiscType && mounted.getType().hasFlag(512)) {
                d8 *= 1.2;
            }
            if (((EquipmentType)object).hasFlag(1) && bl2) {
                d8 *= 1.2;
            }
            if (mounted2.getLocation() == 4) {
                d7 += d8;
                continue;
            }
            d6 += d8;
        }
        if (d6 > d7) {
            d5 += d6;
            d5 += d7 * 0.5;
        } else {
            d5 += d7;
            d5 += d6 * 0.5;
        }
        double d9 = 0.0;
        object = this.ammoList.elements();
        while (object.hasMoreElements()) {
            Mounted mounted = (Mounted)object.nextElement();
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14) continue;
            d9 += ammoType.getBV(this);
        }
        d5 += d9;
        double d10 = this.getOriginalRunMP() - 5;
        d10 /= 10.0;
        d10 += 1.0;
        d10 = Math.pow(d10, 1.2);
        d10 = (double)Math.round(d10 * 100.0) / 100.0;
        d3 = d5 * d10;
        double d11 = 0.0;
        if (this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) {
            d11 = Math.round(0.35 * d6 + 0.5 * d7);
        }
        if (this.getsTagBVPenalty()) {
            d2 += 200.0;
        }
        if (this.getsHomingBVPenalty()) {
            d2 += 200.0;
        }
        double d12 = this.crew.getBVSkillMultiplier();
        return (int)Math.round((d2 + d3 + d11) * d12);
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        if (this.movementDamage > 0) {
            pilotingRollData.addModifier(this.movementDamage, "Steering Damage");
        }
        return pilotingRollData;
    }

    public Vector victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7035);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        Entity.combineVectors(vector, this.crew.getDescVector(false));
        report = new Report(7070, 0);
        report.newlines = 2;
        report.add(this.getKillNumber());
        vector.addElement(report);
        return vector;
    }

    public int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    public int getRunMPwithoutMASC(boolean bl) {
        return this.getRunMP(bl);
    }

    public int getHeatCapacity() {
        return 999;
    }

    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    public int getEngineCritHeat() {
        return 0;
    }

    public void autoSetInternal() {
        int n = (int)Math.ceil((double)this.weight / 10.0);
        this.initializeInternal(-1, 0);
        for (int i = 1; i < this.locations(); ++i) {
            this.initializeInternal(n, i);
        }
    }

    public int getMaxElevationChange() {
        return 1;
    }

    public boolean isRepairable() {
        boolean bl = this.isSalvage();
        for (int i = 1; bl && i < 5; ++i) {
            int n = this.getInternal(i);
            bl = n != -2 && n != -3;
        }
        return bl;
    }

    public void restore() {
        super.restore();
        if (this.m_nJammedTurns > 0 && null == this.m_jammedGun) {
            this.m_jammedGun = this.getMainWeapon();
        }
    }

    public boolean canCharge() {
        return super.canCharge() && (!this.game.getOptions().booleanOption("no_hover_charge") || 5 != this.getMovementMode());
    }

    public boolean canDFA() {
        return false;
    }

    public int getEngineType() {
        return this.engineType;
    }

    public void setEngineType(int n) {
        this.engineType = n;
    }

    public int getArmorType() {
        return this.armorType;
    }

    public void setArmorType(int n) {
        this.armorType = n;
    }

    public int getStructureType() {
        return this.structureType;
    }

    public void setStructureType(int n) {
        this.structureType = n;
    }

    private double getSuspensionFactor() {
        switch (this.movementMode) {
            case 5: {
                if (this.weight <= 10.0f) {
                    return 40.0;
                }
                if (this.weight <= 20.0f) {
                    return 85.0;
                }
                if (this.weight <= 30.0f) {
                    return 130.0;
                }
                if (this.weight <= 40.0f) {
                    return 175.0;
                }
                return 235.0;
            }
            case 8: {
                if (this.weight <= 10.0f) {
                    return 60.0;
                }
                if (this.weight <= 20.0f) {
                    return 105.0;
                }
                if (this.weight <= 30.0f) {
                    return 150.0;
                }
                if (this.weight <= 40.0f) {
                    return 195.0;
                }
                if (this.weight <= 50.0f) {
                    return 255.0;
                }
                if (this.weight <= 60.0f) {
                    return 300.0;
                }
                if (this.weight <= 70.0f) {
                    return 345.0;
                }
                if (this.weight <= 80.0f) {
                    return 390.0;
                }
                if (this.weight <= 90.0f) {
                    return 435.0;
                }
                return 480.0;
            }
            case 7: 
            case 9: {
                return 30.0;
            }
            case 3: {
                return 0.0;
            }
            case 4: {
                return 20.0;
            }
            case 6: {
                if (this.weight <= 10.0f) {
                    return 50.0;
                }
                if (this.weight <= 20.0f) {
                    return 95.0;
                }
                return 140.0;
            }
        }
        return 0.0;
    }

    public double getCost() {
        double d;
        double d2 = 0.0;
        double d3 = (double)(this.weight * (float)this.getOriginalWalkMP()) - this.getSuspensionFactor();
        double d4 = 0.0;
        switch (this.engineType) {
            case 0: {
                d4 = 5000.0;
                break;
            }
            case 1: {
                d4 = 1250.0;
                break;
            }
            case 2: {
                d4 = 20000.0;
                break;
            }
            case 3: {
                d4 = 15000.0;
                break;
            }
            default: {
                d4 = 0.0;
            }
        }
        d2 += d3 * (double)this.weight * d4 / 75.0;
        double d5 = Math.ceil((double)this.weight * 0.05 * 2.0) / 2.0;
        d2 += 10000.0 * d5;
        d2 += (double)this.weight / 10.0 * 10000.0;
        double d6 = 10.0;
        if (this.engineType == 1) {
            d6 = 0.0;
        }
        int n = 0;
        double d7 = 0.0;
        double d8 = 0.0;
        Enumeration enumeration = this.getWeapons();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.hasFlag(4) || weaponType.hasFlag(8)) {
                n += weaponType.getHeat();
                d8 += (double)weaponType.getTonnage(this) / 10.0;
            }
            if (this.hasNoTurret() || mounted.getLocation() != 5) continue;
            d7 += (double)weaponType.getTonnage(this) / 10.0;
        }
        if (this.engineType != 1) {
            d8 = 0.0;
        }
        d8 = Math.ceil(d8 * 10.0) / 10.0;
        d7 = Math.ceil(d7 * 2.0) / 2.0;
        d2 += 20000.0 * d8;
        d2 += 2000.0 * Math.max(0.0, (double)n - d6);
        d2 += d7 * 5000.0;
        d2 += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        switch (this.movementMode) {
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                d = (double)this.weight / 10.0;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        d2 = this.movementMode != 6 ? (d2 += d * 20000.0) : (d2 += d * 40000.0);
        d2 += (double)this.getWeaponsAndEquipmentCost();
        double d9 = 1.0;
        switch (this.movementMode) {
            case 5: 
            case 9: {
                d9 += (double)this.weight / 50.0;
                break;
            }
            case 8: {
                d9 += (double)this.weight / 75.0;
                break;
            }
            case 4: 
            case 7: {
                d9 += (double)this.weight / 200.0;
                break;
            }
            case 3: {
                d9 += (double)this.weight / 100.0;
                break;
            }
            case 6: {
                d9 += (double)this.weight / 30.0;
            }
        }
        return Math.round(d2 * d9);
    }

    public boolean doomedInVacuum() {
        Enumeration enumeration = this.getEquipment();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(32768)) continue;
            return true;
        }
        return false;
    }

    public boolean canGoHullDown() {
        return this.game.getOptions().booleanOption("hull_down");
    }

    public void setOnFire() {
        this.burningLocations = (1 << this.locations()) - 1;
        this.extinguishLocation(0);
    }

    public boolean isOnFire() {
        return this.burningLocations != 0 || this.infernos.isStillBurning();
    }

    public boolean isLocationBurning(int n) {
        int n2 = 1 << n;
        return (this.burningLocations & n2) == n2;
    }

    public void extinguishLocation(int n) {
        int n2 = ~(1 << n);
        this.burningLocations &= n2;
    }

    public void addMovementDamage(int n) {
        this.movementDamage += n;
    }
}

