/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.IGame;
import megamek.common.Player;
import megamek.common.TurnOrdered;
import megamek.common.TurnVectors;

public final class Team
extends TurnOrdered
implements Serializable {
    private Vector players = new Vector();
    private int id;

    public Team(int n) {
        this.id = n;
    }

    public int getSize() {
        return this.players.size();
    }

    public Enumeration getPlayers() {
        return this.players.elements();
    }

    public void resetTeam() {
        this.players.removeAllElements();
    }

    public void addPlayer(Player player) {
        this.players.addElement(player);
    }

    public void clearInitiative() {
        this.getInitiative().clear();
        TurnOrdered.rollInitiative(this.players);
    }

    public TurnVectors determineTeamOrder(IGame iGame) {
        return TurnOrdered.generateTurnOrder(this.players, iGame);
    }

    public int getId() {
        return this.id;
    }

    public int getNormalTurns(IGame iGame) {
        int n = this.getMultiTurns(iGame) + this.getOtherTurns();
        if (0 == n) {
            n = this.getEvenTurns();
        }
        return n;
    }

    public int getEvenTurns() {
        int n = 0;
        Enumeration enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Player)enumeration.nextElement()).getEvenTurns();
        }
        return n;
    }

    public int getOtherTurns() {
        int n = 0;
        Enumeration enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Player)enumeration.nextElement()).getOtherTurns();
        }
        return n;
    }

    public int getMultiTurns(IGame iGame) {
        int n = 0;
        Enumeration enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += ((Player)enumeration.nextElement()).getMultiTurns(iGame);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Team team = (Team)object;
        if (team.getId() != this.getId() || team.getSize() != this.getSize()) {
            return false;
        }
        Enumeration enumeration = this.getPlayers();
        Enumeration enumeration2 = team.getPlayers();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().equals(enumeration2.nextElement())) continue;
            return false;
        }
        return true;
    }

    public boolean hasTAG(IGame iGame) {
        Enumeration enumeration = iGame.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (this.getId() != player.getTeam() || !player.hasTAG()) continue;
            return true;
        }
        return false;
    }

    public boolean hasHomingRounds(IGame iGame) {
        Enumeration enumeration = iGame.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (this.getId() != player.getTeam() || !player.hasHomingRounds()) continue;
            return true;
        }
        return false;
    }
}

