/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Messages;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.VTOL;

public class UnitType {
    public static final int MEK = 0;
    public static final int TANK = 1;
    public static final int INFANTRY = 2;
    public static final int PROTOMEK = 3;
    public static final int VTOL = 4;
    public static final int NAVAL = 5;
    private static String[] names = new String[]{"Mek", "Tank", "Infantry", "ProtoMek", "VTOL", "Naval"};
    public static final int SIZE = names.length;

    public static String determineUnitType(Entity entity) {
        return names[UnitType.determineUnitTypeCode(entity)];
    }

    public static int determineUnitTypeCode(Entity entity) {
        int n = entity.getMovementMode();
        if (entity instanceof Infantry) {
            return 2;
        }
        if (entity instanceof VTOL) {
            return 4;
        }
        if (n == 7 || n == 8 || n == 9) {
            return 5;
        }
        if (entity instanceof Tank) {
            return 1;
        }
        if (entity instanceof Mech) {
            return 0;
        }
        if (entity instanceof Protomech) {
            return 3;
        }
        throw new IllegalArgumentException("Unknown unit type");
    }

    public static String getTypeName(int n) {
        if (n >= 0 && n < SIZE) {
            return names[n];
        }
        throw new IllegalArgumentException("Unknown unit type");
    }

    public static String getTypeDisplayableName(int n) {
        if (n >= 0 && n < SIZE) {
            return Messages.getString("UnitType." + names[n]);
        }
        throw new IllegalArgumentException("Unknown unit type");
    }
}

