/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.AbstractAttackAction;

public class ClubAttackAction
extends AbstractAttackAction {
    private Mounted club;

    public ClubAttackAction(int n, int n2, Mounted mounted) {
        super(n, n2);
        this.club = mounted;
    }

    public ClubAttackAction(int n, int n2, int n3, Mounted mounted) {
        super(n, n2, n3);
        this.club = mounted;
    }

    public static int getDamageFor(Entity entity, Mounted mounted) {
        int n;
        MiscType miscType = (MiscType)mounted.getType();
        int n2 = (int)Math.floor((double)entity.getWeight() / 5.0);
        if (miscType.hasSubType(8)) {
            n2 = (int)(Math.ceil((double)entity.getWeight() / 10.0) + 1.0);
        } else if (miscType.hasSubType(16)) {
            n2 *= 2;
        } else if (miscType.hasSubType(64)) {
            n2 = (int)Math.floor((double)entity.getWeight() / 4.0);
        } else if (miscType.hasSubType(512)) {
            n2 = 9;
        } else if (miscType.hasSubType(128)) {
            n2 = 7;
        } else if (miscType.hasSubType(0x100000)) {
            n2 = 5;
        } else if (miscType.hasSubType(262144)) {
            n2 = 6;
        }
        if (entity.heat >= 9 && !miscType.hasSubType(128) && !miscType.hasSubType(0x100000) && !miscType.hasSubType(512) && ((Mech)entity).hasTSM()) {
            n2 *= 2;
        }
        if ((n = mounted.getLocation()) == -1) {
            n = 4;
        }
        if (entity.getLocationStatus(n) == 2) {
            n2 = (int)((float)n2 / 2.0f);
        }
        return n2 + entity.getCrew().modifyPhysicalDamagaForMeleeSpecialist();
    }

    public ToHitData toHit(IGame iGame) {
        return ClubAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getClub());
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, Mounted mounted) {
        int n2;
        Entity entity = iGame.getEntity(n);
        int n3 = -1;
        if (entity == null || targetable == null) {
            throw new IllegalArgumentException("Attacker or target not valid");
        }
        if (mounted == null) {
            throw new IllegalArgumentException("Club is null");
        }
        if (mounted.getType() == null) {
            throw new IllegalArgumentException("Club type is null");
        }
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n3 = targetable.getTargetId();
        }
        if (entity2 != null && -1 != entity2.getTransportId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is a passenger.");
        }
        if (entity.equals(entity2)) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target yourself");
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't club");
        }
        if (entity.entityIsQuad()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is a quad");
        }
        if (entity.isSpotting()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is spotting this turn");
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is swarming a Mek.");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n4 = entity.getElevation() + iHex.getElevation();
        int n5 = n4 + entity.height();
        int n6 = targetable.getElevation() + iHex2.getElevation();
        int n7 = n6 + targetable.getHeight();
        boolean bl = mounted.getType().hasFlag(0x8000000) && ((MiscType)mounted.getType()).hasSubType(1);
        boolean bl2 = Compute.isInBuilding(iGame, entity2);
        Building building = null;
        if (bl2) {
            building = iGame.getBoard().getBuildingAt(entity2.getPosition());
        }
        if (bl2) {
            if (!Compute.isInBuilding(iGame, entity)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside building");
            }
            if (!iGame.getBoard().getBuildingAt(entity.getPosition()).equals(building)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside differnt building");
            }
        }
        if (bl) {
            if (entity.isLocationBad(4) || entity.isLocationBad(5)) {
                return new ToHitData(Integer.MAX_VALUE, "Arm missing");
            }
            if (entity.weaponFiredFrom(4) || entity.weaponFiredFrom(5)) {
                return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
            }
            if (!entity.hasWorkingSystem(7, 4) || !entity.hasWorkingSystem(7, 5)) {
                return new ToHitData(Integer.MAX_VALUE, "Shoulder actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, 4) || !entity.hasWorkingSystem(10, 5)) {
                return new ToHitData(Integer.MAX_VALUE, "Hand actuator destroyed");
            }
        } else {
            if (entity.isLocationBad(mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Arm missing");
            }
            if (entity.weaponFiredFrom(mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
            }
            if (!entity.hasWorkingSystem(7, mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Shoulder actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Hand actuator destroyed");
            }
        }
        if (entity.getBadCriticals(1, entity.getEquipmentNum(mounted), mounted.getLocation()) > 0) {
            return new ToHitData(Integer.MAX_VALUE, "Club is damaged");
        }
        if (entity.getPosition().distance(targetable.getPosition()) > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (n7 < n4 || n6 > n5) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (entity2 != null && entity2.isMakingDfa()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a DFA attack");
        }
        int n8 = bl ? 1 : (n2 = mounted.getLocation() == 5 ? 2 : 3);
        if (!Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), n2)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (targetable.getTargetType() == 3) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        if (targetable.getTargetType() == 4 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return new ToHitData(Integer.MAX_VALUE, "Invalid attack");
        }
        int n9 = 4;
        if (iGame.getOptions().booleanOption("maxtech_physical_BTH")) {
            n9 = entity.getCrew().getPiloting() - 1;
        }
        if (((MiscType)mounted.getType()).hasSubType(8)) {
            --n9;
        } else if (((MiscType)mounted.getType()).hasSubType(128) || ((MiscType)mounted.getType()).hasSubType(0x100000)) {
            ++n9;
        } else if (((MiscType)mounted.getType()).hasSubType(16) || ((MiscType)mounted.getType()).hasSubType(64) || ((MiscType)mounted.getType()).hasSubType(262144)) {
            n9 += 2;
        } else if (((MiscType)mounted.getType()).hasSubType(512)) {
            n9 += 3;
        }
        ToHitData toHitData = new ToHitData(n9, "base");
        if (entity2 instanceof BattleArmor) {
            toHitData.addModifier(1, "battle armor target");
        }
        toHitData.append(Compute.getAttackerMovementModifier(iGame, n));
        toHitData.append(Compute.getTargetMovementModifier(iGame, n3));
        toHitData.append(Compute.getAttackerTerrainModifier(iGame, n));
        toHitData.append(Compute.getTargetTerrainModifier(iGame, entity2));
        if (bl) {
            if (!entity.hasWorkingSystem(8, 4)) {
                toHitData.addModifier(2, "Upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(8, 5)) {
                toHitData.addModifier(2, "Upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, 4)) {
                toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
            }
            if (!entity.hasWorkingSystem(9, 5)) {
                toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
            }
        } else {
            if (!entity.hasWorkingSystem(8, mounted.getLocation())) {
                toHitData.addModifier(2, "Upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, mounted.getLocation())) {
                toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
            }
        }
        if (entity2.isProne()) {
            toHitData.addModifier(-2, "target prone and adjacent");
        }
        if (entity2.height() > 0 && entity2.getElevation() == -1 && iHex2.terrainLevel(4) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        toHitData.append(Compute.getImmobileMod(entity2));
        toHitData.append(ClubAttackAction.nightModifiers(iGame, targetable, null, entity));
        Compute.modifyPhysicalBTHForAdvantages(entity, entity2, toHitData, iGame);
        if (n4 == n6) {
            toHitData.setHitTable(0);
        } else if (n4 < n6) {
            if (entity2.height() == 0) {
                toHitData.setHitTable(0);
            } else {
                toHitData.setHitTable(2);
            }
        } else {
            toHitData.setHitTable(1);
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, entity2));
        return toHitData;
    }

    public Mounted getClub() {
        return this.club;
    }

    public void setClub(Mounted mounted) {
        this.club = mounted;
    }
}

