/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.Entity;
import megamek.common.TroopSpace;
import megamek.common.VTOL;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKVTOLFile
extends BLKFile
implements IMechLoader {
    private static final String[] MOVES = new String[]{"", "", "", "Tracked", "Wheeled", "Hover", "VTOL"};

    public BLKVTOLFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        VTOL vTOL = new VTOL();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        vTOL.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            vTOL.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            vTOL.setModel("");
        }
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        vTOL.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find type block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (vTOL.getYear() == 3025) {
                vTOL.setTechLevel(0);
            } else {
                vTOL.setTechLevel(1);
            }
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 1")) {
            vTOL.setTechLevel(0);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 2")) {
            vTOL.setTechLevel(1);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 3")) {
            vTOL.setTechLevel(5);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan")) {
            vTOL.setTechLevel(2);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan Level 3")) {
            vTOL.setTechLevel(6);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (IS Chassis)")) {
            vTOL.setTechLevel(5);
            vTOL.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (Clan Chassis)")) {
            vTOL.setTechLevel(6);
            vTOL.setMixedTech(true);
        } else {
            if (this.dataFile.getDataAsString("type")[0].equals("Mixed")) {
                throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
            }
            throw new EntityLoadingException("Unsupported tech level: " + this.dataFile.getDataAsString("type")[0]);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        vTOL.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n = -1;
        for (int i = 0; i < MOVES.length; ++i) {
            if (!string.equals(MOVES[i])) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new EntityLoadingException("Invalid movment type: " + string);
        }
        vTOL.setMovementMode(n);
        if (this.dataFile.exists("transporters")) {
            String[] stringArray = this.dataFile.getDataAsString("transporters");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("TroopSpace:", 0)) continue;
                Double d = new Double(stringArray[i].substring(11));
                int n2 = d.intValue();
                vTOL.addTransporter(new TroopSpace(n2));
            }
        }
        if (this.dataFile.exists("engine_type")) {
            vTOL.setEngineType(this.dataFile.getDataAsInt("engine_type")[0]);
        }
        if (this.dataFile.exists("armor_type")) {
            vTOL.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            vTOL.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        vTOL.setOriginalWalkMP(this.dataFile.getDataAsInt("cruiseMP")[0]);
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length < 4 || nArray.length > 5) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = 0;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        for (int i = 0; i < nArray2.length; ++i) {
            vTOL.initializeArmor(nArray2[i], i);
        }
        vTOL.autoSetInternal();
        this.loadEquipment(vTOL, "Front", 1);
        this.loadEquipment(vTOL, "Right", 2);
        this.loadEquipment(vTOL, "Left", 3);
        this.loadEquipment(vTOL, "Rear", 4);
        this.loadEquipment(vTOL, "Body", 0);
        return vTOL;
    }
}

