/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.BipedMech;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.WeaponType;
import megamek.common.loaders.ArmorType;
import megamek.common.loaders.ChassisType;
import megamek.common.loaders.DesignType;
import megamek.common.loaders.EngineType;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.HeatSinkType;
import megamek.common.loaders.IMechLoader;
import megamek.common.loaders.InternalStructureType;
import megamek.common.loaders.MyomerType;
import megamek.common.loaders.TechType;
import megamek.common.loaders.WeaponLocation;

public class HmpFile
implements IMechLoader {
    private String name;
    private String model;
    private ChassisType chassisType;
    private TechType techType;
    private TechType mixedBaseTechType;
    private TechType engineTechType;
    private TechType heatSinkTechType;
    private TechType physicalWeaponTechType;
    private TechType targetingComputerTechType;
    private TechType myomerTechType;
    private TechType armorTechType;
    private int year;
    private int rulesLevel;
    private int tonnage;
    private InternalStructureType internalStructureType;
    private int engineRating;
    private EngineType engineType;
    private ArmorType armorType;
    private int heatSinks;
    private HeatSinkType heatSinkType;
    private int walkMP;
    private int jumpMP;
    private int laArmor;
    private ArmorType laArmorType;
    private int ltArmor;
    private ArmorType ltArmorType;
    private int ltrArmor;
    private ArmorType ltrArmorType;
    private int llArmor;
    private ArmorType llArmorType;
    private int raArmor;
    private ArmorType raArmorType;
    private int rtArmor;
    private ArmorType rtArmorType;
    private int rtrArmor;
    private ArmorType rtrArmorType;
    private int rlArmor;
    private ArmorType rlArmorType;
    private int headArmor;
    private ArmorType headArmorType;
    private int ctArmor;
    private ArmorType ctArmorType;
    private int ctrArmor;
    private ArmorType ctrArmorType;
    private MyomerType myomerType;
    private int totalWeaponCount;
    private int[][] weaponArray;
    private long[] laCriticals = new long[12];
    private long[] ltCriticals = new long[12];
    private long[] llCriticals = new long[12];
    private long[] raCriticals = new long[12];
    private long[] rtCriticals = new long[12];
    private long[] rlCriticals = new long[12];
    private long[] headCriticals = new long[12];
    private long[] ctCriticals = new long[12];
    private Hashtable spreadEquipment = new Hashtable();
    private Vector vSplitWeapons = new Vector();
    private int gyroType = 0;
    private int cockpitType = 0;
    private static final Hashtable criticals = new Hashtable();

    public HmpFile(InputStream inputStream) throws EntityLoadingException {
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[5];
            dataInputStream.read(byArray);
            String string = new String(byArray);
            DesignType designType = DesignType.getType(this.readUnsignedByte(dataInputStream));
            dataInputStream.skipBytes(3);
            dataInputStream.skipBytes(3);
            dataInputStream.skipBytes(1);
            dataInputStream.skipBytes(3);
            dataInputStream.skipBytes(1);
            this.tonnage = this.readUnsignedShort(dataInputStream);
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.name = new String(byArray);
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.model = new String(byArray);
            this.year = this.readUnsignedShort(dataInputStream);
            this.rulesLevel = this.readUnsignedShort(dataInputStream);
            long l = this.readUnsignedInt(dataInputStream);
            dataInputStream.skipBytes(22);
            int n2 = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(n2);
            this.techType = TechType.getType(this.readUnsignedShort(dataInputStream));
            if (this.techType == TechType.MIXED) {
                this.mixedBaseTechType = TechType.getType(this.readUnsignedShort(dataInputStream));
                this.engineTechType = TechType.getType(this.readUnsignedShort(dataInputStream));
                this.heatSinkTechType = TechType.getType(this.readUnsignedShort(dataInputStream));
                this.physicalWeaponTechType = TechType.getType(this.readUnsignedShort(dataInputStream));
                this.myomerTechType = TechType.getType(this.readUnsignedShort(dataInputStream));
                this.targetingComputerTechType = TechType.getType(this.readUnsignedShort(dataInputStream));
                this.armorTechType = TechType.getType(this.readUnsignedShort(dataInputStream));
            }
            this.chassisType = ChassisType.getType(this.readUnsignedShort(dataInputStream));
            this.internalStructureType = InternalStructureType.getType(this.readUnsignedShort(dataInputStream));
            this.engineRating = this.readUnsignedShort(dataInputStream);
            this.engineType = EngineType.getType(this.readUnsignedShort(dataInputStream));
            this.walkMP = this.readUnsignedShort(dataInputStream);
            this.jumpMP = this.readUnsignedShort(dataInputStream);
            this.heatSinks = this.readUnsignedShort(dataInputStream);
            this.heatSinkType = HeatSinkType.getType(this.readUnsignedShort(dataInputStream));
            this.armorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
            if (this.armorType == ArmorType.PATCHWORK) {
                this.laArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
                this.ltArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
                this.llArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
                this.raArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
                this.rtArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
                this.rlArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
                this.headArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
                this.ctArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
                this.ltrArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
                this.rtrArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
                this.ctrArmorType = ArmorType.getType(this.readUnsignedShort(dataInputStream));
            }
            dataInputStream.skipBytes(2);
            this.laArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(4);
            this.ltArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(4);
            this.llArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(4);
            this.raArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(4);
            this.rtArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(4);
            this.rlArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(4);
            this.headArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(4);
            this.ctArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(2);
            this.ltrArmor = this.readUnsignedShort(dataInputStream);
            this.rtrArmor = this.readUnsignedShort(dataInputStream);
            this.ctrArmor = this.readUnsignedShort(dataInputStream);
            this.myomerType = MyomerType.getType(this.readUnsignedShort(dataInputStream));
            this.totalWeaponCount = this.readUnsignedShort(dataInputStream);
            this.weaponArray = new int[this.totalWeaponCount][4];
            for (n = 0; n < this.totalWeaponCount; ++n) {
                this.weaponArray[n][0] = this.readUnsignedShort(dataInputStream);
                this.weaponArray[n][1] = this.readUnsignedShort(dataInputStream);
                this.weaponArray[n][2] = this.readUnsignedShort(dataInputStream);
                this.weaponArray[n][3] = this.readUnsignedShort(dataInputStream);
                dataInputStream.skipBytes(2);
                dataInputStream.skipBytes(this.readUnsignedShort(dataInputStream));
            }
            for (n = 0; n < 12; ++n) {
                this.laCriticals[n] = this.readUnsignedInt(dataInputStream);
            }
            for (n = 0; n < 12; ++n) {
                this.ltCriticals[n] = this.readUnsignedInt(dataInputStream);
            }
            for (n = 0; n < 12; ++n) {
                this.llCriticals[n] = this.readUnsignedInt(dataInputStream);
            }
            for (n = 0; n < 12; ++n) {
                this.raCriticals[n] = this.readUnsignedInt(dataInputStream);
            }
            for (n = 0; n < 12; ++n) {
                this.rtCriticals[n] = this.readUnsignedInt(dataInputStream);
            }
            for (n = 0; n < 12; ++n) {
                this.rlCriticals[n] = this.readUnsignedInt(dataInputStream);
            }
            for (n = 0; n < 12; ++n) {
                this.headCriticals[n] = this.readUnsignedInt(dataInputStream);
            }
            for (n = 0; n < 12; ++n) {
                this.ctCriticals[n] = this.readUnsignedInt(dataInputStream);
            }
            dataInputStream.skipBytes(36);
            if (this.rulesLevel > 2) {
                this.gyroType = this.readUnsignedShort(dataInputStream);
                this.cockpitType = this.readUnsignedShort(dataInputStream);
            } else {
                this.gyroType = 0;
                this.cockpitType = 0;
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new EntityLoadingException("I/O Error reading file");
        }
    }

    private short readUnsignedByte(DataInputStream dataInputStream) throws IOException {
        short s;
        s = (short)(s + ((s = (short)dataInputStream.readByte()) < 0 ? 256 : 0));
        return s;
    }

    private int readUnsignedShort(DataInputStream dataInputStream) throws IOException {
        short s = this.readUnsignedByte(dataInputStream);
        int n = this.readUnsignedByte(dataInputStream);
        return (n <<= 8) + s;
    }

    private long readUnsignedInt(DataInputStream dataInputStream) throws IOException {
        long l = this.readUnsignedByte(dataInputStream);
        long l2 = this.readUnsignedByte(dataInputStream);
        long l3 = this.readUnsignedByte(dataInputStream);
        long l4 = this.readUnsignedByte(dataInputStream);
        return (l4 <<= 32) + (l3 <<= 16) + (l2 <<= 8) + l;
    }

    public Entity getEntity() throws EntityLoadingException {
        try {
            Mech mech;
            block18: {
                block19: {
                    block17: {
                        Mech mech2 = mech = this.chassisType == ChassisType.QUADRAPED ? new QuadMech(this.gyroType, this.cockpitType) : new BipedMech(this.gyroType, this.cockpitType);
                        if (this.engineType == EngineType.ICE) {
                            mech.setICE(true);
                        }
                        mech.setChassis(this.name);
                        mech.setModel(this.model);
                        mech.setYear(this.year);
                        mech.setOmni(this.chassisType == ChassisType.BIPED_OMNI || this.chassisType == ChassisType.QUADRAPED_OMNI);
                        if (this.techType != TechType.INNER_SPHERE) break block17;
                        switch (this.rulesLevel) {
                            case 1: {
                                mech.setTechLevel(0);
                                break block18;
                            }
                            case 2: {
                                mech.setTechLevel(1);
                                break block18;
                            }
                            case 3: {
                                mech.setTechLevel(5);
                                break block18;
                            }
                            default: {
                                throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel);
                            }
                        }
                    }
                    if (this.techType != TechType.CLAN) break block19;
                    switch (this.rulesLevel) {
                        case 2: {
                            mech.setTechLevel(2);
                            break block18;
                        }
                        case 3: {
                            mech.setTechLevel(6);
                            break block18;
                        }
                        default: {
                            throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel);
                        }
                    }
                }
                if (this.techType == TechType.MIXED && this.mixedBaseTechType == TechType.INNER_SPHERE) {
                    mech.setTechLevel(5);
                    mech.setMixedTech(true);
                } else if (this.techType == TechType.MIXED && this.mixedBaseTechType == TechType.CLAN) {
                    mech.setTechLevel(6);
                    mech.setMixedTech(true);
                } else {
                    throw new EntityLoadingException("Unsupported tech base: " + this.techType);
                }
            }
            mech.setWeight(this.tonnage);
            mech.setOriginalWalkMP(this.walkMP);
            mech.setOriginalJumpMP(this.jumpMP);
            mech.setStructureType(this.internalStructureType.toString());
            mech.autoSetInternal();
            mech.setArmorType(this.armorType.toString());
            mech.initializeArmor(this.laArmor, 5);
            mech.initializeArmor(this.ltArmor, 3);
            mech.initializeRearArmor(this.ltrArmor, 3);
            mech.initializeArmor(this.llArmor, 7);
            mech.initializeArmor(this.raArmor, 4);
            mech.initializeArmor(this.rtArmor, 2);
            mech.initializeRearArmor(this.rtrArmor, 2);
            mech.initializeArmor(this.rlArmor, 6);
            mech.initializeArmor(this.headArmor, 0);
            mech.initializeArmor(this.ctArmor, 1);
            mech.initializeRearArmor(this.ctrArmor, 1);
            this.setupCriticals(mech);
            if (mech.isClan()) {
                mech.addClanCase();
            }
            mech.addEngineSinks(this.heatSinks - mech.heatSinks(), this.heatSinkType == HeatSinkType.DOUBLE);
            return mech;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EntityLoadingException(exception.getMessage());
        }
    }

    private void removeArmActuators(Mech mech, long[] lArray, int n) {
        if (mech.getMovementMode() == 2) {
            if (!HmpFile.isLowerLegActuator(lArray[2])) {
                mech.setCritical(n, 2, null);
            }
            if (!HmpFile.isFootActuator(lArray[3])) {
                mech.setCritical(n, 3, null);
            }
        } else {
            if (!this.isLowerArmActuator(lArray[2])) {
                mech.setCritical(n, 2, null);
            }
            if (!HmpFile.isHandActuator(lArray[3])) {
                mech.setCritical(n, 3, null);
            }
        }
    }

    private void setupCriticals(Mech mech) throws EntityLoadingException {
        this.removeArmActuators(mech, this.laCriticals, 5);
        this.removeArmActuators(mech, this.raCriticals, 4);
        this.compactCriticals(this.rlCriticals);
        this.setupCriticals(mech, this.rlCriticals, 6);
        this.compactCriticals(this.llCriticals);
        this.setupCriticals(mech, this.llCriticals, 7);
        this.compactCriticals(this.raCriticals);
        this.setupCriticals(mech, this.raCriticals, 4);
        this.compactCriticals(this.laCriticals);
        this.setupCriticals(mech, this.laCriticals, 5);
        this.compactCriticals(this.rtCriticals);
        this.setupCriticals(mech, this.rtCriticals, 2);
        this.compactCriticals(this.ltCriticals);
        this.setupCriticals(mech, this.ltCriticals, 3);
        this.compactCriticals(this.ctCriticals);
        this.setupCriticals(mech, this.ctCriticals, 1);
        this.setupCriticals(mech, this.headCriticals, 0);
    }

    private void setupCriticals(Mech mech, long[] lArray, int n) throws EntityLoadingException {
        long[] lArray2 = (long[])lArray.clone();
        for (int i = 0; i < mech.getNumberOfCriticals(n); ++i) {
            if (mech.getCritical(n, i) != null) continue;
            long l = lArray2[i];
            String string = this.getCriticalName(l);
            if (HmpFile.isFusionEngine(l)) {
                mech.setCritical(n, i, new CriticalSlot(0, 3));
                continue;
            }
            if (string == null) continue;
            EquipmentType equipmentType = null;
            try {
                equipmentType = EquipmentType.get(string);
                if (equipmentType != null) {
                    Mounted mounted;
                    boolean bl;
                    boolean bl2 = bl = equipmentType instanceof WeaponType && HmpFile.isRearMounted(l);
                    if (equipmentType.isSpreadable()) {
                        mounted = (Mounted)this.spreadEquipment.get(equipmentType);
                        if (mounted != null) {
                            CriticalSlot criticalSlot = new CriticalSlot(1, mech.getEquipmentNum(mounted), equipmentType.isHittable());
                            mech.addCritical(n, criticalSlot);
                            if (!string.equalsIgnoreCase("Armored Cowl")) continue;
                            mech.setCowl(5);
                            continue;
                        }
                        mounted = mech.addEquipment(equipmentType, n, bl);
                        this.spreadEquipment.put(equipmentType, mounted);
                        continue;
                    }
                    if (equipmentType instanceof WeaponType && equipmentType.hasFlag(256)) {
                        mounted = null;
                        boolean bl3 = false;
                        int n2 = this.vSplitWeapons.size();
                        for (int j = 0; j < n2; ++j) {
                            mounted = (Mounted)this.vSplitWeapons.elementAt(j);
                            int n3 = mounted.getLocation();
                            if (n3 != n && n != Mech.getInnerLocation(n3) || mounted.getType() != equipmentType) continue;
                            bl3 = true;
                            break;
                        }
                        if (bl3) {
                            mounted.setFoundCrits(mounted.getFoundCrits() + 1);
                            if (mounted.getFoundCrits() >= equipmentType.getCriticals(mech)) {
                                this.vSplitWeapons.removeElement(mounted);
                            }
                            mounted.setLocation(Mech.mostRestrictiveLoc(n, mounted.getLocation()));
                        } else {
                            mounted = new Mounted(mech, equipmentType);
                            mounted.setSplit(true);
                            mounted.setFoundCrits(1);
                            this.vSplitWeapons.addElement(mounted);
                        }
                        mech.addEquipment(mounted, n, bl);
                        continue;
                    }
                    mech.addEquipment(equipmentType, n, bl);
                    continue;
                }
                if (string.equals("-Empty-")) continue;
                mech.addFailedEquipment(string);
                lArray2[i] = 0L;
                this.compactCriticals(lArray2);
                --i;
                continue;
            }
            catch (LocationFullException locationFullException) {
                System.err.print("Location was full when adding ");
                System.err.print(equipmentType.getInternalName());
                System.err.print(" to slot #");
                System.err.print(i);
                System.err.print(" of location ");
                System.err.println(n);
                locationFullException.printStackTrace(System.err);
                System.err.println("... aborting entity loading.");
                throw new EntityLoadingException(locationFullException.getMessage());
            }
        }
    }

    private boolean isLowerArmActuator(long l) {
        return l == 3L;
    }

    private static boolean isHandActuator(long l) {
        return l == 4L;
    }

    private static boolean isLowerLegActuator(long l) {
        return l == 7L;
    }

    private static boolean isFootActuator(long l) {
        return l == 8L;
    }

    private static boolean isFusionEngine(long l) {
        return l == 15L;
    }

    private static boolean isRearMounted(long l) {
        return (l & 0xFFFFFFFFFFFF0000L) != 0L;
    }

    private String getCriticalName(long l) {
        return this.getCriticalName(new Long(l));
    }

    private String getCriticalName(Long l) {
        String string;
        short s = 0;
        if (l > 32767L) {
            s = (short)(l >> 16 & 0xFFL);
            l = new Long((long)(l & 0xFFFFL));
        }
        if ((string = (String)criticals.get(l)) == null) {
            Hashtable hashtable;
            TechType techType = this.techType;
            if (techType == TechType.MIXED) {
                techType = l.intValue() == 10 ? this.heatSinkTechType : (l.intValue() == 17 || l.intValue() == 31 ? this.physicalWeaponTechType : (l.intValue() == 18 ? this.targetingComputerTechType : (l.intValue() == 23 ? this.myomerTechType : this.mixedBaseTechType)));
            }
            if ((hashtable = (Hashtable)criticals.get(techType)) != null) {
                string = (String)hashtable.get(l);
            }
        }
        if (string != null && string.endsWith("MG Ammo")) {
            string = string + " (" + s + ")";
        }
        if (string == null) {
            string = "UnknownCritical(0x" + Integer.toHexString(l.intValue()) + ")";
        }
        if (string == null && l == 0L) {
            return "-Empty-";
        }
        return string;
    }

    private void compactCriticals(long[] lArray) {
        int n = -1;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L) {
                n = i;
            }
            if (n == -1 || lArray[i] == 0L) continue;
            lArray[n] = lArray[i];
            lArray[i] = 0L;
            i = n;
            n = -1;
        }
    }

    public String getMtf() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "\r\n";
        stringBuffer.append("Version:1.0").append(string);
        stringBuffer.append(this.name).append(string);
        stringBuffer.append(this.model).append(string);
        stringBuffer.append(string);
        stringBuffer.append("Config:").append(this.chassisType);
        stringBuffer.append(string);
        stringBuffer.append("TechBase:").append(this.techType);
        if (this.techType == TechType.MIXED) {
            stringBuffer.append(" (");
            if (this.mixedBaseTechType == TechType.INNER_SPHERE) {
                stringBuffer.append("IS");
            } else {
                stringBuffer.append(this.mixedBaseTechType);
            }
            stringBuffer.append(" Chassis)");
        }
        stringBuffer.append(string);
        stringBuffer.append("Era:").append(this.year).append(string);
        stringBuffer.append("Rules Level:").append(this.rulesLevel);
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append("Mass:").append(this.tonnage).append(string);
        stringBuffer.append("Engine:").append(this.engineRating).append(" ").append(this.engineType).append(" Engine");
        if (this.mixedBaseTechType != this.engineTechType) {
            stringBuffer.append(" (").append(this.engineTechType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("Structure:").append(this.internalStructureType).append(string);
        stringBuffer.append("Myomer:").append(this.myomerType).append(string);
        stringBuffer.append(string);
        stringBuffer.append("Heat Sinks:").append(this.heatSinks).append(" ").append(this.heatSinkType).append(string);
        stringBuffer.append("Walk MP:").append(this.walkMP).append(string);
        stringBuffer.append("Jump MP:").append(this.jumpMP).append(string);
        stringBuffer.append(string);
        stringBuffer.append("Armor:").append(this.armorType);
        if (this.mixedBaseTechType != this.armorTechType) {
            stringBuffer.append(" (").append(this.armorTechType).append(")");
        }
        stringBuffer.append(string);
        boolean bl = false;
        if (this.armorType == ArmorType.PATCHWORK) {
            bl = true;
        }
        stringBuffer.append("LA Armor:").append(this.laArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.laArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("RA Armor:").append(this.raArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.raArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("LT Armor:").append(this.ltArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.ltArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("RT Armor:").append(this.rtArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.rtArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("CT Armor:").append(this.ctArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.ctArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("HD Armor:").append(this.headArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.headArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("LL Armor:").append(this.llArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.llArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("RL Armor:").append(this.rlArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.rlArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("RTL Armor:").append(this.ltrArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.ltrArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("RTR Armor:").append(this.rtrArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.rtrArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append("RTC Armor:").append(this.ctrArmor);
        if (bl) {
            stringBuffer.append(" (").append(this.ctrArmorType).append(")");
        }
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append("Weapons:").append(this.totalWeaponCount).append(string);
        for (n = 0; n < this.totalWeaponCount; ++n) {
            stringBuffer.append(this.weaponArray[n][0]).append(" ").append(this.getCriticalName(this.weaponArray[n][1])).append(", ").append(WeaponLocation.getType(this.weaponArray[n][2]));
            if (this.weaponArray[n][3] > 0) {
                stringBuffer.append(", Ammo:").append(this.weaponArray[n][3]);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Left Arm:").append(string);
        for (n = 0; n < 12; ++n) {
            stringBuffer.append(this.getCriticalName(this.laCriticals[n])).append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Right Arm:").append(string);
        for (n = 0; n < 12; ++n) {
            stringBuffer.append(this.getCriticalName(this.raCriticals[n])).append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Left Torso:").append(string);
        for (n = 0; n < 12; ++n) {
            stringBuffer.append(this.getCriticalName(this.ltCriticals[n])).append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Right Torso:").append(string);
        for (n = 0; n < 12; ++n) {
            stringBuffer.append(this.getCriticalName(this.rtCriticals[n])).append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Center Torso:").append(string);
        for (n = 0; n < 12; ++n) {
            stringBuffer.append(this.getCriticalName(this.ctCriticals[n])).append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Head:").append(string);
        for (n = 0; n < 12; ++n) {
            stringBuffer.append(this.getCriticalName(this.headCriticals[n])).append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Left Leg:").append(string);
        for (n = 0; n < 12; ++n) {
            stringBuffer.append(this.getCriticalName(this.llCriticals[n])).append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Right Leg:").append(string);
        for (n = 0; n < 12; ++n) {
            stringBuffer.append(this.getCriticalName(this.rlCriticals[n])).append(string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Hmpread (Java Edition) version 0.9");
            System.out.println("--------------------------------------");
            System.out.println();
            System.out.println("Drag and drop \".hmp\" files onto this exe to convert them to \".mtf\" files.\nMultiple files may be processed at once.  Files may also be specified on\nthe command line.");
            System.out.println();
            System.out.println("Press <enter> to quit...");
            try {
                System.in.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.endsWith(".hmp")) {
                System.out.println("Error: Input file must have Heavy Metal Pro extension '.hmp'");
                System.out.println();
                System.out.println("Press <enter> to quit...");
                try {
                    System.in.read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            HmpFile hmpFile = null;
            try {
                hmpFile = new HmpFile(new FileInputStream(stringArray[i]));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            string = string.substring(0, string.lastIndexOf(".hmp"));
            string = string + ".mtf";
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(new File(string)));
                bufferedWriter.write(hmpFile.getMtf());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    static {
        criticals.put(new Long(0L), "-Empty-");
        criticals.put(new Long(1L), "Shoulder");
        criticals.put(new Long(2L), "Upper Arm Actuator");
        criticals.put(new Long(3L), "Lower Arm Actuator");
        criticals.put(new Long(4L), "Hand Actuator");
        criticals.put(new Long(5L), "Hip");
        criticals.put(new Long(6L), "Upper Leg Actuator");
        criticals.put(new Long(7L), "Lower Leg Actuator");
        criticals.put(new Long(8L), "Foot Actuator");
        criticals.put(new Long(9L), "Heat Sink");
        criticals.put(new Long(11L), "Jump Jet");
        criticals.put(new Long(12L), "Life Support");
        criticals.put(new Long(13L), "Sensors");
        criticals.put(new Long(14L), "Cockpit");
        criticals.put(new Long(15L), "Fusion Engine");
        criticals.put(new Long(16L), "Gyro");
        criticals.put(new Long(20L), "Endo Steel");
        criticals.put(new Long(21L), "Ferro-Fibrous");
        criticals.put(new Long(22L), "Triple Strength Myomer");
        criticals.put(new Long(28L), "Reactive Armor");
        criticals.put(new Long(29L), "Laser-Reflective Armor");
        criticals.put(new Long(33L), "Light Ferro-Fibrous");
        criticals.put(new Long(34L), "Heavy Ferro-Fibrous");
        criticals.put(new Long(40L), "Coolant Pod");
        criticals.put(new Long(45L), "Armored Cowl");
        Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
        criticals.put(TechType.INNER_SPHERE, hashtable);
        hashtable.put(new Long(10L), "ISDouble Heat Sink");
        hashtable.put(new Long(17L), "Hatchet");
        hashtable.put(new Long(18L), "ISTargeting Computer");
        hashtable.put(new Long(23L), "ISMASC");
        hashtable.put(new Long(24L), "ISArtemisIV");
        hashtable.put(new Long(25L), "ISCASE");
        hashtable.put(new Long(31L), "Sword");
        hashtable.put(new Long(35L), "Stealth Armor");
        hashtable.put(new Long(39L), "Null Signature System");
        hashtable.put(new Long(43L), "Claw (THB)");
        hashtable.put(new Long(44L), "Mace (THB)");
        hashtable.put(new Long(51L), "ISERLargeLaser");
        hashtable.put(new Long(52L), "ISERPPC");
        hashtable.put(new Long(53L), "ISFlamer");
        hashtable.put(new Long(55L), "ISLargeLaser");
        hashtable.put(new Long(56L), "ISMediumLaser");
        hashtable.put(new Long(57L), "ISSmallLaser");
        hashtable.put(new Long(58L), "ISPPC");
        hashtable.put(new Long(59L), "ISLargePulseLaser");
        hashtable.put(new Long(60L), "ISMediumPulseLaser");
        hashtable.put(new Long(61L), "ISSmallPulseLaser");
        hashtable.put(new Long(62L), "ISAC2");
        hashtable.put(new Long(63L), "ISAC5");
        hashtable.put(new Long(64L), "ISAC10");
        hashtable.put(new Long(65L), "ISAC20");
        hashtable.put(new Long(66L), "ISAntiMissileSystem");
        hashtable.put(new Long(70L), "ISLightGaussRifle");
        hashtable.put(new Long(71L), "ISGaussRifle");
        hashtable.put(new Long(72L), "ISLargeXPulseLaser");
        hashtable.put(new Long(73L), "ISMediumXPulseLaser");
        hashtable.put(new Long(74L), "ISSmallXPulseLaser");
        hashtable.put(new Long(75L), "ISLBXAC2");
        hashtable.put(new Long(76L), "ISLBXAC5");
        hashtable.put(new Long(77L), "ISLBXAC10");
        hashtable.put(new Long(78L), "ISLBXAC20");
        hashtable.put(new Long(79L), "ISMachine Gun");
        hashtable.put(new Long(80L), "ISLAC2");
        hashtable.put(new Long(81L), "ISLAC5");
        hashtable.put(new Long(82L), "ISHeavyFlamer");
        hashtable.put(new Long(84L), "ISUltraAC2");
        hashtable.put(new Long(85L), "ISUltraAC5");
        hashtable.put(new Long(86L), "ISUltraAC10");
        hashtable.put(new Long(87L), "ISUltraAC20");
        hashtable.put(new Long(88L), "CLERMicroLaser");
        hashtable.put(new Long(90L), "ISERMediumLaser");
        hashtable.put(new Long(91L), "ISERSmallLaser");
        hashtable.put(new Long(92L), "ISAntiPersonnelPod");
        hashtable.put(new Long(96L), "ISLRM5");
        hashtable.put(new Long(97L), "ISLRM10");
        hashtable.put(new Long(98L), "ISLRM15");
        hashtable.put(new Long(99L), "ISLRM20");
        hashtable.put(new Long(100L), "CLLightActiveProbe");
        hashtable.put(new Long(101L), "CLLightTAG");
        hashtable.put(new Long(102L), "ISImprovedNarc");
        hashtable.put(new Long(103L), "ISSRM2");
        hashtable.put(new Long(104L), "ISSRM4");
        hashtable.put(new Long(105L), "ISSRM6");
        hashtable.put(new Long(106L), "ISStreakSRM2");
        hashtable.put(new Long(107L), "ISStreakSRM4");
        hashtable.put(new Long(108L), "ISStreakSRM6");
        hashtable.put(new Long(113L), "ISArrowIVSystem");
        hashtable.put(new Long(114L), "ISAngelECMSuite");
        hashtable.put(new Long(115L), "ISBeagleActiveProbe");
        hashtable.put(new Long(116L), "ISBloodhoundActiveProbe");
        hashtable.put(new Long(117L), "ISC3MasterComputer");
        hashtable.put(new Long(118L), "ISC3SlaveUnit");
        hashtable.put(new Long(119L), "ISImprovedC3CPU");
        hashtable.put(new Long(120L), "ISGuardianECM");
        hashtable.put(new Long(121L), "ISNarcBeacon");
        hashtable.put(new Long(122L), "ISTAG");
        hashtable.put(new Long(123L), "ISLRM5 (OS)");
        hashtable.put(new Long(124L), "ISLRM10 (OS)");
        hashtable.put(new Long(125L), "ISLRM15 (OS)");
        hashtable.put(new Long(126L), "ISLRM20 (OS)");
        hashtable.put(new Long(127L), "ISSRM2 (OS)");
        hashtable.put(new Long(128L), "ISSRM4 (OS)");
        hashtable.put(new Long(129L), "ISSRM6 (OS)");
        hashtable.put(new Long(130L), "ISStreakSRM2 (OS)");
        hashtable.put(new Long(131L), "ISStreakSRM4 (OS)");
        hashtable.put(new Long(132L), "ISStreakSRM6 (OS)");
        hashtable.put(new Long(133L), "ISVehicleFlamer");
        hashtable.put(new Long(135L), "ISSniperArtillery");
        hashtable.put(new Long(136L), "ISThumperArtillery");
        hashtable.put(new Long(137L), "ISMRM10");
        hashtable.put(new Long(138L), "ISMRM20");
        hashtable.put(new Long(139L), "ISMRM30");
        hashtable.put(new Long(140L), "ISMRM40");
        hashtable.put(new Long(142L), "ISMRM10 (OS)");
        hashtable.put(new Long(143L), "ISMRM20 (OS)");
        hashtable.put(new Long(144L), "ISMRM30 (OS)");
        hashtable.put(new Long(145L), "ISMRM40 (OS)");
        hashtable.put(new Long(146L), "ISLRTorpedo5");
        hashtable.put(new Long(147L), "ISLRTorpedo10");
        hashtable.put(new Long(148L), "ISLRTorpedo15");
        hashtable.put(new Long(149L), "ISLRTorpedo20");
        hashtable.put(new Long(150L), "ISSRTorpedo2");
        hashtable.put(new Long(151L), "ISSRTorpedo4");
        hashtable.put(new Long(152L), "ISSRTorpedo6");
        hashtable.put(new Long(167L), "CLERLargeLaser");
        hashtable.put(new Long(168L), "CLERMediumLaser");
        hashtable.put(new Long(169L), "CLERSmallLaser");
        hashtable.put(new Long(170L), "CLERPPC");
        hashtable.put(new Long(171L), "CLFlamer");
        hashtable.put(new Long(176L), "CLLargePulseLaser");
        hashtable.put(new Long(177L), "CLMediumPulseLaser");
        hashtable.put(new Long(178L), "CLSmallPulseLaser");
        hashtable.put(new Long(180L), "CLAntiMissileSystem");
        hashtable.put(new Long(181L), "CLGaussRifle");
        hashtable.put(new Long(182L), "CLLBXAC2");
        hashtable.put(new Long(183L), "CLLBXAC5");
        hashtable.put(new Long(184L), "CLLBXAC10");
        hashtable.put(new Long(185L), "CLLBXAC20");
        hashtable.put(new Long(186L), "CLMG");
        hashtable.put(new Long(187L), "CLUltraAC2");
        hashtable.put(new Long(188L), "CLUltraAC5");
        hashtable.put(new Long(189L), "CLUltraAC10");
        hashtable.put(new Long(190L), "CLUltraAC20");
        hashtable.put(new Long(191L), "CLLRM5");
        hashtable.put(new Long(192L), "CLLRM10");
        hashtable.put(new Long(193L), "CLLRM15");
        hashtable.put(new Long(194L), "CLLRM20");
        hashtable.put(new Long(195L), "CLSRM2");
        hashtable.put(new Long(196L), "CLSRM4");
        hashtable.put(new Long(197L), "CLSRM6");
        hashtable.put(new Long(198L), "CLStreakSRM2");
        hashtable.put(new Long(199L), "CLStreakSRM4");
        hashtable.put(new Long(200L), "CLStreakSRM6");
        hashtable.put(new Long(201L), "CLArrowIVSystem");
        hashtable.put(new Long(202L), "CLAntiPersonnelPod");
        hashtable.put(new Long(203L), "CLActiveProbe");
        hashtable.put(new Long(204L), "CLECMSuite");
        hashtable.put(new Long(205L), "CLNarcBeacon");
        hashtable.put(new Long(206L), "CLTAG");
        hashtable.put(new Long(208L), "CLLRM5 (OS)");
        hashtable.put(new Long(209L), "CLLRM10 (OS)");
        hashtable.put(new Long(210L), "CLLRM15 (OS)");
        hashtable.put(new Long(211L), "CLLRM20 (OS)");
        hashtable.put(new Long(212L), "CLSRM2 (OS)");
        hashtable.put(new Long(213L), "CLSRM2 (OS)");
        hashtable.put(new Long(214L), "CLSRM2 (OS)");
        hashtable.put(new Long(215L), "CLStreakSRM2 (OS)");
        hashtable.put(new Long(216L), "CLStreakSRM4 (OS)");
        hashtable.put(new Long(217L), "CLStreakSRM6 (OS)");
        hashtable.put(new Long(218L), "CLVehicleFlamer");
        hashtable.put(new Long(220L), "CLSniperArtillery");
        hashtable.put(new Long(221L), "CLThumperArtillery");
        hashtable.put(new Long(222L), "CLLRTorpedo5");
        hashtable.put(new Long(223L), "CLLRTorpedo10");
        hashtable.put(new Long(224L), "CLLRTorpedo15");
        hashtable.put(new Long(225L), "CLLRTorpedo20");
        hashtable.put(new Long(226L), "CLSRTorpedo2");
        hashtable.put(new Long(227L), "CLSRTorpedo4");
        hashtable.put(new Long(228L), "CLSRTorpedo6");
        hashtable.put(new Long(244L), "CLHeavyLargeLaser");
        hashtable.put(new Long(245L), "CLHeavyMediumLaser");
        hashtable.put(new Long(246L), "CLHeavySmallLaser");
        hashtable.put(new Long(264L), "ISTHBLBXAC2");
        hashtable.put(new Long(265L), "ISTHBLBXAC5");
        hashtable.put(new Long(266L), "ISTHBLBXAC20");
        hashtable.put(new Long(267L), "ISUltraAC2 (THB)");
        hashtable.put(new Long(268L), "ISUltraAC10 (THB)");
        hashtable.put(new Long(269L), "ISUltraAC20 (THB)");
        hashtable.put(new Long(285L), "ISTHBAngelECMSuite");
        hashtable.put(new Long(286L), "ISTHBBloodhoundActiveProbe");
        hashtable.put(new Long(289L), "ISRotaryAC2");
        hashtable.put(new Long(290L), "ISRotaryAC5");
        hashtable.put(new Long(291L), "ISHeavyGaussRifle");
        hashtable.put(new Long(297L), "ISRocketLauncher10");
        hashtable.put(new Long(298L), "ISRocketLauncher15");
        hashtable.put(new Long(299L), "ISRocketLauncher20");
        hashtable.put(new Long(462L), "ISAC2 Ammo");
        hashtable.put(new Long(463L), "ISAC5 Ammo");
        hashtable.put(new Long(464L), "ISAC10 Ammo");
        hashtable.put(new Long(465L), "ISAC20 Ammo");
        hashtable.put(new Long(466L), "ISAMS Ammo");
        hashtable.put(new Long(470L), "ISLightGauss Ammo");
        hashtable.put(new Long(471L), "ISGauss Ammo");
        hashtable.put(new Long(475L), "ISLBXAC2 Ammo");
        hashtable.put(new Long(476L), "ISLBXAC5 Ammo");
        hashtable.put(new Long(477L), "ISLBXAC10 Ammo");
        hashtable.put(new Long(478L), "ISLBXAC20 Ammo");
        hashtable.put(new Long(479L), "ISMG Ammo");
        hashtable.put(new Long(480L), "ISLAC2 Ammo");
        hashtable.put(new Long(481L), "ISLAC5 Ammo");
        hashtable.put(new Long(482L), "ISHeavyFlamer Ammo");
        hashtable.put(new Long(484L), "ISUltraAC2 Ammo");
        hashtable.put(new Long(485L), "ISUltraAC5 Ammo");
        hashtable.put(new Long(486L), "ISUltraAC10 Ammo");
        hashtable.put(new Long(487L), "ISUltraAC20 Ammo");
        hashtable.put(new Long(496L), "ISLRM5 Ammo");
        hashtable.put(new Long(497L), "ISLRM10 Ammo");
        hashtable.put(new Long(498L), "ISLRM15 Ammo");
        hashtable.put(new Long(499L), "ISLRM20 Ammo");
        hashtable.put(new Long(502L), "ISiNarc Pods");
        hashtable.put(new Long(503L), "ISSRM2 Ammo");
        hashtable.put(new Long(504L), "ISSRM4 Ammo");
        hashtable.put(new Long(505L), "ISSRM6 Ammo");
        hashtable.put(new Long(506L), "ISStreakSRM2 Ammo");
        hashtable.put(new Long(507L), "ISStreakSRM4 Ammo");
        hashtable.put(new Long(508L), "ISStreakSRM6 Ammo");
        hashtable.put(new Long(513L), "ISArrowIV Ammo");
        hashtable.put(new Long(521L), "ISNarc Pods");
        hashtable.put(new Long(533L), "ISFlamer Ammo");
        hashtable.put(new Long(535L), "ISSniper Ammo");
        hashtable.put(new Long(536L), "ISThumper Ammo");
        hashtable.put(new Long(537L), "ISMRM10 Ammo");
        hashtable.put(new Long(538L), "ISMRM20 Ammo");
        hashtable.put(new Long(539L), "ISMRM30 Ammo");
        hashtable.put(new Long(540L), "ISMRM40 Ammo");
        hashtable.put(new Long(546L), "ISLRTorpedo5 Ammo");
        hashtable.put(new Long(547L), "ISLRTorpedo10 Ammo");
        hashtable.put(new Long(548L), "ISLRTorpedo15 Ammo");
        hashtable.put(new Long(549L), "ISLRTorpedo20 Ammo");
        hashtable.put(new Long(550L), "ISSRTorpedo2 Ammo");
        hashtable.put(new Long(551L), "ISSRTorpedo4 Ammo");
        hashtable.put(new Long(552L), "ISSRTorpedo6 Ammo");
        hashtable.put(new Long(580L), "CLAMS Ammo");
        hashtable.put(new Long(581L), "CLGauss Ammo");
        hashtable.put(new Long(582L), "CLLBXAC2 Ammo");
        hashtable.put(new Long(583L), "CLLBXAC5 Ammo");
        hashtable.put(new Long(584L), "CLLBXAC10 Ammo");
        hashtable.put(new Long(585L), "CLLBXAC20 Ammo");
        hashtable.put(new Long(586L), "CLMG Ammo");
        hashtable.put(new Long(587L), "CLUltraAC2 Ammo");
        hashtable.put(new Long(588L), "CLUltraAC5 Ammo");
        hashtable.put(new Long(589L), "CLUltraAC10 Ammo");
        hashtable.put(new Long(590L), "CLUltraAC20 Ammo");
        hashtable.put(new Long(591L), "CLLRM5 Ammo");
        hashtable.put(new Long(592L), "CLLRM10 Ammo");
        hashtable.put(new Long(593L), "CLLRM15 Ammo");
        hashtable.put(new Long(594L), "CLLRM20 Ammo");
        hashtable.put(new Long(595L), "CLSRM2 Ammo");
        hashtable.put(new Long(596L), "CLSRM4 Ammo");
        hashtable.put(new Long(597L), "CLSRM6 Ammo");
        hashtable.put(new Long(598L), "CLStreakSRM2 Ammo");
        hashtable.put(new Long(599L), "CLStreakSRM4 Ammo");
        hashtable.put(new Long(600L), "CLStreakSRM6 Ammo");
        hashtable.put(new Long(601L), "CLArrowIV Ammo");
        hashtable.put(new Long(605L), "CLNarc Pods");
        hashtable.put(new Long(618L), "CLVehicleFlamer Ammo");
        hashtable.put(new Long(620L), "CLSniper Ammo");
        hashtable.put(new Long(621L), "CLThumper Ammo");
        hashtable.put(new Long(622L), "CLLRTorpedo5 Ammo");
        hashtable.put(new Long(623L), "CLLRTorpedo10 Ammo");
        hashtable.put(new Long(624L), "CLLRTorpedo15 Ammo");
        hashtable.put(new Long(625L), "CLLRTorpedo20 Ammo");
        hashtable.put(new Long(626L), "CLSRTorpedo2 Ammo");
        hashtable.put(new Long(627L), "CLSRTorpedo4 Ammo");
        hashtable.put(new Long(628L), "CLSRTorpedo6 Ammo");
        hashtable.put(new Long(664L), "ISLBXAC2 Ammo (THB)");
        hashtable.put(new Long(665L), "ISLBXAC5 Ammo (THB)");
        hashtable.put(new Long(666L), "ISLBXAC20 Ammo (THB)");
        hashtable.put(new Long(667L), "IS Ultra AC/2 Ammo (THB)");
        hashtable.put(new Long(668L), "IS Ultra AC/10 Ammo (THB)");
        hashtable.put(new Long(669L), "IS Ultra AC/20 Ammo (THB)");
        hashtable.put(new Long(689L), "ISRotaryAC2 Ammo");
        hashtable.put(new Long(690L), "ISRotaryAC5 Ammo");
        hashtable.put(new Long(691L), "ISHeavyGauss Ammo");
        Hashtable<Long, String> hashtable2 = new Hashtable<Long, String>();
        criticals.put(TechType.CLAN, hashtable2);
        hashtable2.put(new Long(10L), "CLDouble Heat Sink");
        hashtable2.put(new Long(18L), "CLTargeting Computer");
        hashtable2.put(new Long(23L), "CLMASC");
        hashtable2.put(new Long(24L), "CLArtemisIV");
        hashtable2.put(new Long(33L), "Light Ferro-Fibrous");
        hashtable2.put(new Long(34L), "Heavy Ferro-Fibrous");
        hashtable2.put(new Long(51L), "CLERLargeLaser");
        hashtable2.put(new Long(52L), "CLERMediumLaser");
        hashtable2.put(new Long(53L), "CLERSmallLaser");
        hashtable2.put(new Long(54L), "CLERPPC");
        hashtable2.put(new Long(55L), "CLFlamer");
        hashtable2.put(new Long(56L), "CLERLargePulseLaser");
        hashtable2.put(new Long(57L), "CLERMediumPulseLaser");
        hashtable2.put(new Long(58L), "CLERSmallPulseLaser");
        hashtable2.put(new Long(60L), "CLLargePulseLaser");
        hashtable2.put(new Long(61L), "CLMediumPulseLaser");
        hashtable2.put(new Long(62L), "CLSmallPulseLaser");
        hashtable2.put(new Long(63L), "CLAngelECMSuite");
        hashtable2.put(new Long(64L), "CLAntiMissileSystem");
        hashtable2.put(new Long(65L), "CLGaussRifle");
        hashtable2.put(new Long(66L), "CLLBXAC2");
        hashtable2.put(new Long(67L), "CLLBXAC5");
        hashtable2.put(new Long(68L), "CLLBXAC10");
        hashtable2.put(new Long(69L), "CLLBXAC20");
        hashtable2.put(new Long(70L), "CLMG");
        hashtable2.put(new Long(71L), "CLUltraAC2");
        hashtable2.put(new Long(72L), "CLUltraAC5");
        hashtable2.put(new Long(73L), "CLUltraAC10");
        hashtable2.put(new Long(74L), "CLUltraAC20");
        hashtable2.put(new Long(75L), "CLLRM5");
        hashtable2.put(new Long(76L), "CLLRM10");
        hashtable2.put(new Long(77L), "CLLRM15");
        hashtable2.put(new Long(78L), "CLLRM20");
        hashtable2.put(new Long(79L), "CLSRM2");
        hashtable2.put(new Long(80L), "CLSRM4");
        hashtable2.put(new Long(81L), "CLSRM6");
        hashtable2.put(new Long(82L), "CLStreakSRM2");
        hashtable2.put(new Long(83L), "CLStreakSRM4");
        hashtable2.put(new Long(84L), "CLStreakSRM6");
        hashtable2.put(new Long(85L), "CLArrowIVSystem");
        hashtable2.put(new Long(86L), "CLAntiPersonnelPod");
        hashtable2.put(new Long(87L), "CLActiveProbe");
        hashtable2.put(new Long(88L), "CLECMSuite");
        hashtable2.put(new Long(89L), "CLNarcBeacon");
        hashtable2.put(new Long(90L), "CLTAG");
        hashtable2.put(new Long(91L), "CLERMicroLaser");
        hashtable2.put(new Long(92L), "CLLRM5 (OS)");
        hashtable2.put(new Long(93L), "CLLRM10 (OS)");
        hashtable2.put(new Long(94L), "CLLRM15 (OS)");
        hashtable2.put(new Long(95L), "CLLRM20 (OS)");
        hashtable2.put(new Long(96L), "CLSRM2 (OS)");
        hashtable2.put(new Long(97L), "CLSRM4 (OS)");
        hashtable2.put(new Long(98L), "CLSRM6 (OS)");
        hashtable2.put(new Long(99L), "CLStreakSRM2 (OS)");
        hashtable2.put(new Long(100L), "CLStreakSRM4 (OS)");
        hashtable2.put(new Long(101L), "CLStreakSRM6 (OS)");
        hashtable2.put(new Long(102L), "CLVehicleFlamer");
        hashtable2.put(new Long(103L), "CLSRM2");
        hashtable2.put(new Long(104L), "CLSniperArtillery");
        hashtable2.put(new Long(105L), "CLThumperArtillery");
        hashtable2.put(new Long(106L), "CLLRTorpedo5");
        hashtable2.put(new Long(107L), "CLLRTorpedo10");
        hashtable2.put(new Long(108L), "CLLRTorpedo15");
        hashtable2.put(new Long(109L), "CLLRTorpedo20");
        hashtable2.put(new Long(110L), "CLSRTorpedo2");
        hashtable2.put(new Long(111L), "CLSRTorpedo4");
        hashtable2.put(new Long(112L), "CLSRTorpedo6");
        hashtable2.put(new Long(113L), "CLStreakLRM5");
        hashtable2.put(new Long(114L), "CLStreakLRM10");
        hashtable2.put(new Long(115L), "CLStreakLRM15");
        hashtable2.put(new Long(116L), "CLStreakLRM20");
        hashtable2.put(new Long(123L), "CLLRM5 (OS)");
        hashtable2.put(new Long(124L), "CLLRM10 (OS)");
        hashtable2.put(new Long(125L), "CLLRM15 (OS)");
        hashtable2.put(new Long(126L), "CLLRM20 (OS)");
        hashtable2.put(new Long(127L), "CLSRM2 (OS)");
        hashtable2.put(new Long(128L), "CLHeavyLargeLaser");
        hashtable2.put(new Long(129L), "CLHeavyMediumLaser");
        hashtable2.put(new Long(130L), "CLHeavySmallLaser");
        hashtable2.put(new Long(131L), "ISERLargeLaser");
        hashtable2.put(new Long(132L), "ISERPPC");
        hashtable2.put(new Long(133L), "ISFlamer");
        hashtable2.put(new Long(135L), "ISLargeLaser");
        hashtable2.put(new Long(136L), "ISMediumLaser");
        hashtable2.put(new Long(137L), "ISSmallLaser");
        hashtable2.put(new Long(138L), "ISPPC");
        hashtable2.put(new Long(139L), "ISLargePulseLaser");
        hashtable2.put(new Long(140L), "ISMediumPulseLaser");
        hashtable2.put(new Long(141L), "ISSmallPulseLaser");
        hashtable2.put(new Long(142L), "ISAC2");
        hashtable2.put(new Long(143L), "ISAC5");
        hashtable2.put(new Long(144L), "ISAC10");
        hashtable2.put(new Long(145L), "ISAC20");
        hashtable2.put(new Long(146L), "ISAntiMissileSystem");
        hashtable2.put(new Long(150L), "ISLightGaussRifle");
        hashtable2.put(new Long(151L), "ISGaussRifle");
        hashtable2.put(new Long(155L), "ISLBXAC2");
        hashtable2.put(new Long(156L), "ISLBXAC5");
        hashtable2.put(new Long(157L), "ISLBXAC10");
        hashtable2.put(new Long(158L), "ISLBXAC20");
        hashtable2.put(new Long(159L), "ISMachine Gun");
        hashtable2.put(new Long(164L), "ISUltraAC2");
        hashtable2.put(new Long(165L), "ISUltraAC5");
        hashtable2.put(new Long(166L), "ISUltraAC10");
        hashtable2.put(new Long(167L), "ISUltraAC20");
        hashtable2.put(new Long(168L), "CLMicroPulseLaser");
        hashtable2.put(new Long(170L), "ISERMediumLaser");
        hashtable2.put(new Long(171L), "ISERSmallLaser");
        hashtable2.put(new Long(172L), "ISAntiPersonnelPod");
        hashtable2.put(new Long(173L), "CLLightMG");
        hashtable2.put(new Long(174L), "CLHeavyMG");
        hashtable2.put(new Long(175L), "CLLightActiveProbe");
        hashtable2.put(new Long(176L), "ISLRM5");
        hashtable2.put(new Long(177L), "ISLRM10");
        hashtable2.put(new Long(178L), "ISLRM15");
        hashtable2.put(new Long(179L), "ISLRM20");
        hashtable2.put(new Long(180L), "CLLightTAG");
        hashtable2.put(new Long(182L), "ISImprovedNarc");
        hashtable2.put(new Long(183L), "ISSRM2");
        hashtable2.put(new Long(184L), "ISSRM4");
        hashtable2.put(new Long(185L), "ISSRM6");
        hashtable2.put(new Long(186L), "ISStreakSRM2");
        hashtable2.put(new Long(187L), "ISStreakSRM4");
        hashtable2.put(new Long(188L), "ISStreakSRM6");
        hashtable2.put(new Long(195L), "ISBeagleActiveProbe");
        hashtable2.put(new Long(197L), "ISC3MasterComputer");
        hashtable2.put(new Long(198L), "ISC3SlaveUnit");
        hashtable2.put(new Long(199L), "ISImprovedC3CPU");
        hashtable2.put(new Long(200L), "ISGuardianECM");
        hashtable2.put(new Long(201L), "ISNarcBeacon");
        hashtable2.put(new Long(202L), "ISTAG");
        hashtable2.put(new Long(203L), "ISLRM5 (OS)");
        hashtable2.put(new Long(204L), "ISLRM10 (OS)");
        hashtable2.put(new Long(205L), "ISLRM15 (OS)");
        hashtable2.put(new Long(206L), "ISLRM20 (OS)");
        hashtable2.put(new Long(207L), "ISSRM2 (OS)");
        hashtable2.put(new Long(208L), "ISSRM4 (OS)");
        hashtable2.put(new Long(209L), "ISSRM6 (OS)");
        hashtable2.put(new Long(210L), "ISStreakSRM2 (OS)");
        hashtable2.put(new Long(211L), "ISStreakSRM4 (OS)");
        hashtable2.put(new Long(212L), "ISStreakSRM6 (OS)");
        hashtable2.put(new Long(213L), "ISVehicleFlamer");
        hashtable2.put(new Long(226L), "ISLRTorpedo5");
        hashtable2.put(new Long(227L), "ISLRTorpedo10");
        hashtable2.put(new Long(228L), "ISLRTorpedo15");
        hashtable2.put(new Long(229L), "ISLRTorpedo20");
        hashtable2.put(new Long(230L), "ISSRTorpedo2");
        hashtable2.put(new Long(231L), "ISSRTorpedo4");
        hashtable2.put(new Long(232L), "ISSRTorpedo6");
        hashtable2.put(new Long(252L), "CLATM3");
        hashtable2.put(new Long(253L), "CLATM6");
        hashtable2.put(new Long(254L), "CLATM9");
        hashtable2.put(new Long(255L), "CLATM12");
        hashtable2.put(new Long(289L), "ISRotaryAC2");
        hashtable2.put(new Long(290L), "ISRotaryAC5");
        hashtable2.put(new Long(292L), "CLRotaryAC2");
        hashtable2.put(new Long(293L), "CLRotaryAC5");
        hashtable2.put(new Long(294L), "CLRotaryAC10");
        hashtable2.put(new Long(295L), "CLRotaryAC20");
        hashtable2.put(new Long(464L), "CLAMS Ammo");
        hashtable2.put(new Long(465L), "CLGauss Ammo");
        hashtable2.put(new Long(466L), "CLLBXAC2 Ammo");
        hashtable2.put(new Long(467L), "CLLBXAC5 Ammo");
        hashtable2.put(new Long(468L), "CLLBXAC10 Ammo");
        hashtable2.put(new Long(469L), "CLLBXAC20 Ammo");
        hashtable2.put(new Long(470L), "CLMG Ammo");
        hashtable2.put(new Long(471L), "CLUltraAC2 Ammo");
        hashtable2.put(new Long(472L), "CLUltraAC5 Ammo");
        hashtable2.put(new Long(473L), "CLUltraAC10 Ammo");
        hashtable2.put(new Long(474L), "CLUltraAC20 Ammo");
        hashtable2.put(new Long(475L), "CLLRM5 Ammo");
        hashtable2.put(new Long(476L), "CLLRM10 Ammo");
        hashtable2.put(new Long(477L), "CLLRM15 Ammo");
        hashtable2.put(new Long(478L), "CLLRM20 Ammo");
        hashtable2.put(new Long(479L), "CLSRM2 Ammo");
        hashtable2.put(new Long(480L), "CLSRM4 Ammo");
        hashtable2.put(new Long(481L), "CLSRM6 Ammo");
        hashtable2.put(new Long(482L), "CLStreakSRM2 Ammo");
        hashtable2.put(new Long(483L), "CLStreakSRM4 Ammo");
        hashtable2.put(new Long(484L), "CLStreakSRM6 Ammo");
        hashtable2.put(new Long(485L), "CLArrowIV Ammo");
        hashtable2.put(new Long(489L), "CLNarc Pods");
        hashtable2.put(new Long(496L), "CLLRM5 Ammo");
        hashtable2.put(new Long(497L), "CLLRM10 Ammo");
        hashtable2.put(new Long(498L), "CLLRM15 Ammo");
        hashtable2.put(new Long(499L), "CLLRM20 Ammo");
        hashtable2.put(new Long(502L), "CLVehicleFlamer Ammo");
        hashtable2.put(new Long(503L), "CLSRM2 Ammo");
        hashtable2.put(new Long(504L), "CLSniper Ammo");
        hashtable2.put(new Long(505L), "CLThumper Ammo");
        hashtable2.put(new Long(506L), "CLLRTorpedo5 Ammo");
        hashtable2.put(new Long(507L), "CLLRTorpedo10 Ammo");
        hashtable2.put(new Long(508L), "CLLRTorpedo15 Ammo");
        hashtable2.put(new Long(509L), "CLLRTorpedo20 Ammo");
        hashtable2.put(new Long(510L), "CLSRTorpedo2 Ammo");
        hashtable2.put(new Long(511L), "CLSRTorpedo4 Ammo");
        hashtable2.put(new Long(512L), "CLSRTorpedo6 Ammo");
        hashtable2.put(new Long(513L), "CLStreakLRM5 Ammo");
        hashtable2.put(new Long(514L), "CLStreakLRM10 Ammo");
        hashtable2.put(new Long(515L), "CLStreakLRM15 Ammo");
        hashtable2.put(new Long(516L), "CLStreakLRM20 Ammo");
        hashtable2.put(new Long(689L), "ISRotaryAC2 Ammo");
        hashtable2.put(new Long(690L), "ISRotaryAC5 Ammo");
        hashtable2.put(new Long(692L), "CLRotaryAC2 Ammo");
        hashtable2.put(new Long(693L), "CLRotaryAC5 Ammo");
        hashtable2.put(new Long(694L), "CLRotaryAC10 Ammo");
        hashtable2.put(new Long(695L), "CLRotaryAC20 Ammo");
        hashtable2.put(new Long(542L), "ISAC2 Ammo");
        hashtable2.put(new Long(543L), "ISAC5 Ammo");
        hashtable2.put(new Long(544L), "ISAC10 Ammo");
        hashtable2.put(new Long(545L), "ISAC20 Ammo");
        hashtable2.put(new Long(546L), "ISAMS Ammo");
        hashtable2.put(new Long(550L), "ISLightGauss Ammo");
        hashtable2.put(new Long(551L), "ISGauss Ammo");
        hashtable2.put(new Long(555L), "ISLBXAC2 Ammo");
        hashtable2.put(new Long(556L), "ISLBXAC5 Ammo");
        hashtable2.put(new Long(557L), "ISLBXAC10 Ammo");
        hashtable2.put(new Long(558L), "ISLBXAC20 Ammo");
        hashtable2.put(new Long(559L), "ISMG Ammo");
        hashtable2.put(new Long(564L), "ISUltraAC2 Ammo");
        hashtable2.put(new Long(565L), "ISUltraAC5 Ammo");
        hashtable2.put(new Long(566L), "ISUltraAC10 Ammo");
        hashtable2.put(new Long(567L), "ISUltraAC20 Ammo");
        hashtable2.put(new Long(573L), "CLLightMG Ammo");
        hashtable2.put(new Long(574L), "CLHeavyMG Ammo");
        hashtable2.put(new Long(576L), "ISLRM5 Ammo");
        hashtable2.put(new Long(577L), "ISLRM10 Ammo");
        hashtable2.put(new Long(578L), "ISLRM15 Ammo");
        hashtable2.put(new Long(579L), "ISLRM20 Ammo");
        hashtable2.put(new Long(582L), "ISiNarc Pods");
        hashtable2.put(new Long(583L), "ISSRM2 Ammo");
        hashtable2.put(new Long(584L), "ISSRM4 Ammo");
        hashtable2.put(new Long(585L), "ISSRM6 Ammo");
        hashtable2.put(new Long(586L), "ISStreakSRM2 Ammo");
        hashtable2.put(new Long(587L), "ISStreakSRM4 Ammo");
        hashtable2.put(new Long(588L), "ISStreakSRM6 Ammo");
        hashtable2.put(new Long(601L), "ISNarc Pods");
        hashtable2.put(new Long(613L), "ISVehicleFlamer Ammo");
        hashtable2.put(new Long(626L), "ISLRTorpedo15 Ammo");
        hashtable2.put(new Long(627L), "ISLRTorpedo20 Ammo");
        hashtable2.put(new Long(628L), "ISLRTorpedo5 Ammo");
        hashtable2.put(new Long(629L), "ISLRTorpedo10 Ammo");
        hashtable2.put(new Long(630L), "ISSRTorpedo4 Ammo");
        hashtable2.put(new Long(631L), "ISSRTorpedo2 Ammo");
        hashtable2.put(new Long(632L), "ISSRTorpedo6 Ammo");
        hashtable2.put(new Long(652L), "CLATM3 Ammo");
        hashtable2.put(new Long(653L), "CLATM6 Ammo");
        hashtable2.put(new Long(654L), "CLATM9 Ammo");
        hashtable2.put(new Long(655L), "CLATM12 Ammo");
    }
}

