/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.options;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.options.IOptionInfo;
import megamek.common.options.IOptionsInfo;
import megamek.common.options.Messages;
import megamek.common.options.OptionGroup;

public class AbstractOptionsInfo
implements IOptionsInfo {
    protected static final String GROUP_SUFFIX = ".group.";
    protected static final String OPTION_SUFFIX = ".option.";
    protected static final String DISPLAYABLE_NAME_SUFFIX = ".displayableName";
    protected static final String DESCRIPTION_SUFFIX = ".description";
    private String name;
    private Hashtable optionsHash = new Hashtable();
    private Vector groups = new Vector();
    private boolean finished;
    private static HashSet names = new HashSet();

    protected AbstractOptionsInfo(String string) {
        if (names.contains(string)) {
            throw new IllegalArgumentException("OptionsInfo '" + string + "' is already registered");
        }
        this.name = string;
    }

    public IOptionInfo getOptionInfo(String string) {
        return (IOptionInfo)this.optionsHash.get(string);
    }

    public Enumeration getGroups() {
        return this.groups.elements();
    }

    OptionGroup addGroup(String string) {
        return this.addGroup(string, null);
    }

    OptionGroup addGroup(String string, String string2) {
        OptionGroup optionGroup = null;
        if (!this.finished) {
            for (int i = 0; i < this.groups.size(); ++i) {
                OptionGroup optionGroup2 = (OptionGroup)this.groups.elementAt(i);
                if (optionGroup2 == null || !optionGroup2.getName().equals(string)) continue;
                optionGroup = (OptionGroup)this.groups.elementAt(i);
                break;
            }
            if (optionGroup == null) {
                optionGroup = string2 == null ? new OptionGroup(string) : new OptionGroup(string, string2);
                this.groups.addElement(optionGroup);
            }
        }
        return optionGroup;
    }

    void addOptionInfo(OptionGroup optionGroup, String string) {
        if (!this.finished) {
            optionGroup.addOptionName(string);
            this.setOptionInfo(string, new OptionInfo(string));
        }
    }

    protected String getGroupDisplayableName(String string) {
        for (int i = 0; i < this.groups.size(); ++i) {
            OptionGroup optionGroup = (OptionGroup)this.groups.elementAt(i);
            if (optionGroup == null || !optionGroup.getName().equals(string)) continue;
            return Messages.getString(this.name + GROUP_SUFFIX + string + DISPLAYABLE_NAME_SUFFIX);
        }
        return null;
    }

    void finish() {
        this.finished = true;
    }

    private void setOptionInfo(String string, OptionInfo optionInfo) {
        this.optionsHash.put(string, optionInfo);
    }

    private String getOptionDisplayableName(String string) {
        return Messages.getString(this.name + OPTION_SUFFIX + string + DISPLAYABLE_NAME_SUFFIX);
    }

    private String getOptionDescription(String string) {
        return Messages.getString(this.name + OPTION_SUFFIX + string + DESCRIPTION_SUFFIX);
    }

    private class OptionInfo
    implements IOptionInfo {
        private String name;
        private int textFieldLength = 2;
        private boolean labelBeforeTextField = false;

        public OptionInfo(String string) {
            this.name = string;
        }

        public String getDisplayableName() {
            return AbstractOptionsInfo.this.getOptionDisplayableName(this.name);
        }

        public String getDescription() {
            return AbstractOptionsInfo.this.getOptionDescription(this.name);
        }

        public int getTextFieldLength() {
            return this.textFieldLength;
        }

        public boolean isLabelBeforeTextField() {
            return this.labelBeforeTextField;
        }
    }
}

