/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.options;

import gd.xml.ParseException;
import gd.xml.tiny.ParsedXML;
import gd.xml.tiny.TinyParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.options.AbstractOptions;
import megamek.common.options.AbstractOptionsInfo;
import megamek.common.options.IBasicOption;
import megamek.common.options.IOption;
import megamek.common.options.OptionGroup;

public class GameOptions
extends AbstractOptions
implements Serializable {
    private static final String GAME_OPTIONS_FILE_NAME = "mmconf/gameoptions.xml";

    public void initialize() {
        OptionGroup optionGroup = this.addGroup("base");
        this.addOption(optionGroup, "friendly_fire", false);
        this.addOption(optionGroup, "skip_ineligable_movement", false);
        this.addOption(optionGroup, "skip_ineligable_firing", false);
        this.addOption(optionGroup, "skip_ineligable_physical", true);
        this.addOption(optionGroup, "push_off_board", true);
        this.addOption(optionGroup, "check_victory", true);
        this.addOption(optionGroup, "rng_type", 1);
        this.addOption(optionGroup, "team_initiative", true);
        this.addOption(optionGroup, "is_eq_limits", true);
        this.addOption(optionGroup, "autosave_msg", true);
        this.addOption(optionGroup, "paranoid_autosave", false);
        this.addOption(optionGroup, "maps_include_subdir", false);
        this.addOption(optionGroup, "exclusive_db_deployment", true);
        OptionGroup optionGroup2 = this.addGroup("level2");
        this.addOption(optionGroup2, "flamer_heat", true);
        this.addOption(optionGroup2, "fire", true);
        this.addOption(optionGroup2, "indirect_fire", true);
        this.addOption(optionGroup2, "minefields", true);
        this.addOption(optionGroup2, "temperature", 25);
        this.addOption(optionGroup2, "gravity", 1.0f);
        this.addOption(optionGroup2, "vacuum", false);
        this.addOption(optionGroup2, "night_battle", false);
        this.addOption(optionGroup2, "assault_drop", false);
        OptionGroup optionGroup3 = this.addGroup("level3");
        this.addOption(optionGroup3, "allow_level_3_units", false);
        this.addOption(optionGroup3, "allow_level_3_ammo", false);
        this.addOption(optionGroup3, "double_blind", false);
        this.addOption(optionGroup3, "dusk", false);
        this.addOption(optionGroup3, "team_vision", true);
        this.addOption(optionGroup3, "floating_crits", false);
        this.addOption(optionGroup3, "engine_explosions", false);
        this.addOption(optionGroup3, "pilot_advantages", false);
        this.addOption(optionGroup3, "maxtech_physical_BTH", false);
        this.addOption(optionGroup3, "maxtech_physical_psr", false);
        this.addOption(optionGroup3, "maxtech_round_damage", false);
        this.addOption(optionGroup3, "maxtech_prone_fire", false);
        this.addOption(optionGroup3, "maxtech_target_modifiers", false);
        this.addOption(optionGroup3, "maxtech_leg_damage", false);
        this.addOption(optionGroup3, "maxtech_fire", false);
        this.addOption(optionGroup3, "maxtech_range", false);
        this.addOption(optionGroup3, "maxtech_LOS1", false);
        this.addOption(optionGroup3, "maxtech_altdmg", false);
        this.addOption(optionGroup3, "maxtech_mslhitpen", false);
        this.addOption(optionGroup3, "maxtech_ppc_inhibitors", false);
        this.addOption(optionGroup3, "maxtech_charge_damage", false);
        this.addOption(optionGroup3, "maxtech_glancing_blows", false);
        this.addOption(optionGroup3, "maxtech_burst", false);
        this.addOption(optionGroup3, "maxtech_heat", false);
        this.addOption(optionGroup3, "maxtech_mulekicks", false);
        this.addOption(optionGroup3, "maxtech_partial_cover", false);
        this.addOption(optionGroup3, "allow_level_3_targsys", false);
        this.addOption(optionGroup3, "quad_hit_location", false);
        this.addOption(optionGroup3, "hull_down", false);
        this.addOption(optionGroup3, "vehicle_fires", false);
        this.addOption(optionGroup3, "paratroopers", false);
        OptionGroup optionGroup4 = this.addGroup("ruleBreakers");
        this.addOption(optionGroup4, "no_tac", false);
        this.addOption(optionGroup4, "no_immobile_vehicles", false);
        this.addOption(optionGroup4, "vehicles_can_eject", false);
        this.addOption(optionGroup4, "inf_move_even", false);
        this.addOption(optionGroup4, "inf_deploy_even", false);
        this.addOption(optionGroup4, "inf_move_later", false);
        this.addOption(optionGroup4, "inf_move_multi", false);
        this.addOption(optionGroup4, "protos_move_even", false);
        this.addOption(optionGroup4, "protos_deploy_even", false);
        this.addOption(optionGroup4, "protos_move_later", false);
        this.addOption(optionGroup4, "protos_move_multi", false);
        this.addOption(optionGroup4, "inf_proto_move_multi", 3);
        this.addOption(optionGroup4, "blind_drop", false);
        this.addOption(optionGroup4, "real_blind_drop", false);
        this.addOption(optionGroup4, "clan_ignore_eq_limits", false);
        this.addOption(optionGroup4, "no_clan_physical", false);
        this.addOption(optionGroup4, "no_hover_charge", false);
        this.addOption(optionGroup4, "woods_burn_down", false);
        this.addOption(optionGroup4, "vehicles_safe_from_infernos", false);
        this.addOption(optionGroup4, "protos_safe_from_infernos", false);
        this.addOption(optionGroup4, "lobby_ammo_dump", false);
        this.addOption(optionGroup4, "set_arty_player_homeedge", false);
        this.addOption(optionGroup4, "no_premove_vibra", false);
        this.addOption(optionGroup4, "auto_spot", false);
        this.addOption(optionGroup4, "margin_scatter_distance", false);
        this.addOption(optionGroup4, "allow_illegal_units", false);
        this.addOption(optionGroup4, "ejected_pilots_flee", false);
        this.addOption(optionGroup4, "a4homing_target_area", false);
        this.addOption(optionGroup4, "all_have_ei_cockpit", false);
        this.addOption(optionGroup4, "canon_only", false);
        this.addOption(optionGroup4, "indirect_always_possible", false);
        this.addOption(optionGroup4, "quad_hit_location_plus", false);
    }

    public Vector loadOptions(String string) {
        ParsedXML parsedXML = null;
        FileInputStream fileInputStream = null;
        Vector<IOption> vector = new Vector<IOption>();
        try {
            fileInputStream = new FileInputStream(new File(GAME_OPTIONS_FILE_NAME));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return vector;
        }
        try {
            parsedXML = TinyParser.parseXML((InputStream)fileInputStream);
        }
        catch (ParseException parseException) {
            System.out.println("Error parsing game options xml file.");
            parseException.printStackTrace(System.out);
        }
        Enumeration enumeration = parsedXML.elements();
        ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
        if (parsedXML2.getName().equals("options")) {
            Enumeration enumeration2 = parsedXML2.elements();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = this.parseOptionNode((ParsedXML)enumeration2.nextElement());
                if (null == iOption) continue;
                vector.addElement(iOption);
            }
            return vector;
        }
        System.out.println("Root node of game options file is incorrectly named. Name should be 'options' but name is '" + parsedXML2.getName() + "'");
        return vector;
    }

    private IOption parseOptionNode(ParsedXML parsedXML) {
        Object object = null;
        if (parsedXML.getName().equals("gameoption")) {
            Object object2;
            Enumeration enumeration = parsedXML.elements();
            String string = null;
            Object object3 = null;
            while (enumeration.hasMoreElements()) {
                object2 = (ParsedXML)enumeration.nextElement();
                if (object2.getName().equals("optionname")) {
                    string = ((ParsedXML)object2.elements().nextElement()).getContent();
                    continue;
                }
                if (!object2.getName().equals("optionvalue")) continue;
                object3 = ((ParsedXML)object2.elements().nextElement()).getContent();
            }
            if (null != string && null != object3) {
                object2 = this.getOption(string);
                if (null != object2) {
                    if (!object2.getValue().toString().equals(object3.toString())) {
                        try {
                            switch (object2.getType()) {
                                case 3: {
                                    object2.setValue((String)object3);
                                    break;
                                }
                                case 0: {
                                    object2.setValue(new Boolean(object3.toString()));
                                    break;
                                }
                                case 1: {
                                    object2.setValue(new Integer(object3.toString()));
                                    break;
                                }
                                case 2: {
                                    object2.setValue(new Float(object3.toString()));
                                }
                            }
                            System.out.println("Set option '" + string + "' to '" + object3 + "'.");
                            object = object2;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            System.out.println("Error trying to load option '" + string + "' with a value of '" + object3 + "'.");
                        }
                    }
                } else {
                    System.out.println("Invalid option '" + string + "' when trying to load options file.");
                }
            }
        }
        return object;
    }

    public static void saveOptions(Vector vector) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(GAME_OPTIONS_FILE_NAME))));
            bufferedWriter.write("<?xml version=\"1.0\"?>");
            bufferedWriter.write("\r\n");
            bufferedWriter.write("<options>");
            bufferedWriter.write("\r\n");
            for (int i = 0; i < vector.size(); ++i) {
                IBasicOption iBasicOption = (IBasicOption)vector.elementAt(i);
                bufferedWriter.write("   <gameoption>");
                bufferedWriter.write("\r\n");
                bufferedWriter.write("      <optionname>");
                bufferedWriter.write(iBasicOption.getName());
                bufferedWriter.write("</optionname>");
                bufferedWriter.write("\r\n");
                bufferedWriter.write("      <optionvalue>");
                bufferedWriter.write(iBasicOption.getValue().toString());
                bufferedWriter.write("</optionvalue>");
                bufferedWriter.write("\r\n");
                bufferedWriter.write("   </gameoption>");
                bufferedWriter.write("\r\n");
            }
            bufferedWriter.write("</options>");
            bufferedWriter.write("\r\n");
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected AbstractOptionsInfo getOptionsInfoImp() {
        return GameOptionsInfo.getInstance();
    }

    private static class GameOptionsInfo
    extends AbstractOptionsInfo {
        private static AbstractOptionsInfo instance = new GameOptionsInfo();

        protected GameOptionsInfo() {
            super("GameOptionsInfo");
        }

        public static AbstractOptionsInfo getInstance() {
            return instance;
        }
    }
}

