/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.preference;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Locale;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.IPreferenceStore;
import megamek.common.preference.PreferenceStoreProxy;
import megamek.common.util.LocaleParser;

class ClientPreferences
extends PreferenceStoreProxy
implements IClientPreferences {
    public static final String LAST_CONNECT_ADDR = "LastConnectAddr";
    public static final String LAST_CONNECT_PORT = "LastConnectPort";
    public static final String LAST_PLAYER_CAMO_NAME = "LastPlayerCamoName";
    public static final String LAST_PLAYER_CATEGORY = "LastPlayerCategory";
    public static final String LAST_PLAYER_COLOR = "LastPlayerColor";
    public static final String LAST_PLAYER_NAME = "LastPlayerName";
    public static final String LAST_SERVER_PASS = "LastServerPass";
    public static final String LAST_SERVER_PORT = "LastServerPort";
    public static final String LOCALE = "Locale";
    public static final String MAP_TILESET = "MapTileset";
    public static final String MAX_PATHFINDER_TIME = "MaxPathfinderTime";
    public static final String DATA_DIRECTORY = "DataDirectory";
    public static final String LOG_DIRECTORY = "LogDirectory";
    public static final String MECH_DIRECTORY = "MechDirectory";
    public static final String MEK_HIT_LOC_LOG = "MekHitLocLog";
    public static final String MEMORY_DUMP_ON = "MemoryDumpOn";
    public static final String GAMELOG_KEEP = "KeepGameLog";
    public static final String GAMELOG_FILENAME = "GameLogFilename";
    public static final String STAMP_FILENAMES = "StampFilenames";
    public static final String STAMP_FORMAT = "StampFormat";
    public static final String SHOW_UNIT_ID = "ShowUnitId";
    public static final String UNIT_START_CHAR = "UnitStartChar";
    public static final String DEFAULT_AUTOEJECT_DISABLED = "DefaultAutoejectDisabled";
    public static final String METASERVER_NAME = "MetaServerName";
    public static final String GOAL_PLAYERS = "GoalPlayers";
    public static final String GUI_NAME = "GUIName";
    protected PrintWriter mekHitLocLog = null;
    protected Locale locale = null;

    ClientPreferences(IPreferenceStore iPreferenceStore) {
        this.store = iPreferenceStore;
        iPreferenceStore.setDefault(LAST_CONNECT_ADDR, "localhost");
        iPreferenceStore.setDefault(LAST_CONNECT_PORT, 2346);
        iPreferenceStore.setDefault(LAST_SERVER_PORT, 2346);
        iPreferenceStore.setDefault(MAP_TILESET, "defaulthexset.txt");
        iPreferenceStore.setDefault(MAX_PATHFINDER_TIME, 2000);
        iPreferenceStore.setDefault(DATA_DIRECTORY, "data");
        iPreferenceStore.setDefault(LOG_DIRECTORY, "logs");
        iPreferenceStore.setDefault(MECH_DIRECTORY, iPreferenceStore.getDefaultString(DATA_DIRECTORY) + File.separator + "mechfiles");
        iPreferenceStore.setDefault(METASERVER_NAME, "http://www.damour.info/cgi-bin/james/metaserver");
        iPreferenceStore.setDefault(GOAL_PLAYERS, 2);
        iPreferenceStore.setDefault(GAMELOG_KEEP, true);
        iPreferenceStore.setDefault(GAMELOG_FILENAME, "gamelog.txt");
        iPreferenceStore.setDefault(STAMP_FORMAT, "_yyyy-MM-dd_HH-mm-ss");
        iPreferenceStore.setDefault(UNIT_START_CHAR, 65);
        iPreferenceStore.setDefault(GUI_NAME, "AWT");
        this.setLocale(iPreferenceStore.getString(LOCALE));
        this.setMekHitLocLog();
    }

    public String[] getAdvancedProperties() {
        return this.store.getAdvancedProperties();
    }

    public boolean defaultAutoejectDisabled() {
        return this.store.getBoolean(DEFAULT_AUTOEJECT_DISABLED);
    }

    public String getLastConnectAddr() {
        return this.store.getString(LAST_CONNECT_ADDR);
    }

    public int getLastConnectPort() {
        return this.store.getInt(LAST_CONNECT_PORT);
    }

    public String getLastPlayerName() {
        return this.store.getString(LAST_PLAYER_NAME);
    }

    public String getLastServerPass() {
        return this.store.getString(LAST_SERVER_PASS);
    }

    public int getLastServerPort() {
        return this.store.getInt(LAST_SERVER_PORT);
    }

    public String getMapTileset() {
        return this.store.getString(MAP_TILESET);
    }

    public int getMaxPathfinderTime() {
        return this.store.getInt(MAX_PATHFINDER_TIME);
    }

    public String getDataDirectory() {
        return this.store.getString(DATA_DIRECTORY);
    }

    public String getLogDirectory() {
        return this.store.getString(LOG_DIRECTORY);
    }

    public String getMechDirectory() {
        return this.store.getString(MECH_DIRECTORY);
    }

    public PrintWriter getMekHitLocLog() {
        return this.mekHitLocLog;
    }

    public String getMetaServerName() {
        return this.store.getString(METASERVER_NAME);
    }

    public void setMetaServerName(String string) {
        this.store.setValue(METASERVER_NAME, string);
    }

    public int getGoalPlayers() {
        return this.store.getInt(GOAL_PLAYERS);
    }

    public void setGoalPlayers(int n) {
        this.store.setValue(GOAL_PLAYERS, n);
    }

    public String getGameLogFilename() {
        return this.store.getString(GAMELOG_FILENAME);
    }

    public boolean stampFilenames() {
        return this.store.getBoolean(STAMP_FILENAMES);
    }

    public String getStampFormat() {
        return this.store.getString(STAMP_FORMAT);
    }

    public boolean getShowUnitId() {
        return this.store.getBoolean(SHOW_UNIT_ID);
    }

    public char getUnitStartChar() {
        return (char)this.store.getInt(UNIT_START_CHAR);
    }

    public boolean keepGameLog() {
        return this.store.getBoolean(GAMELOG_KEEP);
    }

    public boolean memoryDumpOn() {
        return this.store.getBoolean(MEMORY_DUMP_ON);
    }

    public void setDefaultAutoejectDisabled(boolean bl) {
        this.store.setValue(DEFAULT_AUTOEJECT_DISABLED, bl);
    }

    public void setKeepGameLog(boolean bl) {
        this.store.setValue(GAMELOG_KEEP, bl);
    }

    public void setLastConnectAddr(String string) {
        this.store.setValue(LAST_CONNECT_ADDR, string);
    }

    public void setLastConnectPort(int n) {
        this.store.setValue(LAST_CONNECT_PORT, n);
    }

    public void setLastPlayerCamoName(String string) {
        if (string != null) {
            this.store.setValue(LAST_PLAYER_CAMO_NAME, string);
        }
    }

    public void setLastPlayerCategory(String string) {
        this.store.setValue(LAST_PLAYER_CATEGORY, string);
    }

    public void setLastPlayerColor(int n) {
        this.store.setValue(LAST_PLAYER_COLOR, n);
    }

    public void setLastPlayerName(String string) {
        this.store.setValue(LAST_PLAYER_NAME, string);
    }

    public void setLastServerPass(String string) {
        this.store.setValue(LAST_SERVER_PASS, string);
    }

    public void setLastServerPort(int n) {
        this.store.setValue(LAST_SERVER_PORT, n);
    }

    public void setMaxPathfinderTime(int n) {
        this.store.setValue(MAX_PATHFINDER_TIME, n);
    }

    public void setGameLogFilename(String string) {
        this.store.setValue(GAMELOG_FILENAME, string);
    }

    public void setStampFilenames(boolean bl) {
        this.store.setValue(STAMP_FILENAMES, bl);
    }

    public void setStampFormat(String string) {
        this.store.setValue(STAMP_FORMAT, string);
    }

    public void setShowUnitId(boolean bl) {
        this.store.setValue(SHOW_UNIT_ID, bl);
    }

    public void setUnitStartChar(char c) {
        this.store.setValue(UNIT_START_CHAR, c);
    }

    public String getGUIName() {
        return this.store.getString(GUI_NAME);
    }

    public void setGUIName(String string) {
        this.store.setValue(GUI_NAME, string);
    }

    public void setLocale(String string) {
        LocaleParser localeParser = new LocaleParser();
        if (!localeParser.parse(string)) {
            this.locale = new Locale(localeParser.getLanguage(), localeParser.getCountry(), localeParser.getVariant());
            this.store.setValue(LOCALE, this.getLocaleString());
        }
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.US;
        }
        return this.locale;
    }

    public String getLocaleString() {
        if (this.locale == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.locale.getLanguage().length() != 0) {
            stringBuffer.append(this.locale.getLanguage());
            if (this.locale.getCountry().length() != 0) {
                stringBuffer.append("_" + this.locale.getCountry());
                if (this.locale.getVariant().length() != 0) {
                    stringBuffer.append("_" + this.locale.getVariant());
                }
            }
        }
        return stringBuffer.toString();
    }

    protected void setMekHitLocLog() {
        String string = this.store.getString(MEK_HIT_LOC_LOG);
        if (string.length() != 0) {
            try {
                this.mekHitLocLog = new PrintWriter(new BufferedWriter(new FileWriter(string)));
                this.mekHitLocLog.println("Table\tSide\tRoll");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.mekHitLocLog = null;
            }
        }
    }
}

