/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.verifier;

import megamek.common.verifier.TestEntity;

class Engine {
    public static final float[] ENGINE_RATINGS = new float[]{0.0f, 0.25f, 0.5f, 0.5f, 0.5f, 0.5f, 1.0f, 1.0f, 1.0f, 1.0f, 1.5f, 1.5f, 1.5f, 2.0f, 2.0f, 2.0f, 2.5f, 2.5f, 3.0f, 3.0f, 3.0f, 3.5f, 3.5f, 4.0f, 4.0f, 4.0f, 4.5f, 4.5f, 5.0f, 5.0f, 5.5f, 5.5f, 6.0f, 6.0f, 6.0f, 7.0f, 7.0f, 7.5f, 7.5f, 8.0f, 8.5f, 8.5f, 9.0f, 9.5f, 10.0f, 10.0f, 10.5f, 11.0f, 11.5f, 12.0f, 12.5f, 13.0f, 13.5f, 14.0f, 14.5f, 15.5f, 16.0f, 16.5f, 17.5f, 18.0f, 19.0f, 19.5f, 10.5f, 21.5f, 22.5f, 23.5f, 24.5f, 25.5f, 27.0f, 28.5f, 29.5f, 31.5f, 33.0f, 34.5f, 36.5f, 38.5f, 41.0f, 43.5f, 46.0f, 49.0f, 52.5f, 56.5f, 61.0f, -1.0f, 72.5f, 79.5f, 87.5f, 97.0f, 107.5f, -1.0f, 133.5f, -1.0f, 168.5f, -1.0f, 214.5f, -1.0f, 275.5f, -1.0f, 356.0f, 405.5f, 462.5f};
    public static final int TANK_ENGINE = 16;
    public static final int CLAN_ENGINE = 1;
    public static final int COMPUSTION_ENGINE = 0;
    public static final int NORMAL_ENGINE = 1;
    public static final int XL_ENGINE = 2;
    public static final int LIGHT_ENGINE = 3;
    public boolean engineValid;
    private int engineRating;
    private int engineType;
    private int engineFlags;
    public StringBuffer problem = new StringBuffer("Illegal engine: ");

    public Engine(int n, int n2, int n3) {
        if (!this.isValidEngine(n, n2, n3)) {
            this.engineValid = false;
            this.engineRating = 0;
            this.engineType = -1;
            this.engineFlags = -1;
        } else {
            this.engineValid = true;
            this.engineRating = n;
            this.engineType = n2;
            this.engineFlags = n3;
        }
    }

    private static boolean hasFlag(int n, int n2) {
        return (n & n2) != 0;
    }

    public boolean isValidEngine(int n, int n2, int n3) {
        if (Engine.hasFlag(n3, -18)) {
            this.problem.append("Flags:" + n3);
            return false;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                this.problem.append("Type:" + n2);
                return false;
            }
        }
        if ((int)Math.ceil(n / 5) > ENGINE_RATINGS.length || n < 0) {
            this.problem.append("Rating:" + n);
            return false;
        }
        return true;
    }

    public boolean isFusionEngine() {
        return Engine.isFusionEngine(this.engineType);
    }

    public static boolean isFusionEngine(int n) {
        return n != 0;
    }

    public float getWeightEngine() {
        return Engine.getWeightEngine(this.engineRating, this.engineType, this.engineFlags, 2.0f);
    }

    public float getWeightEngine(float f) {
        return Engine.getWeightEngine(this.engineRating, this.engineType, this.engineFlags, f);
    }

    public static float getWeightEngine(int n, int n2, int n3, float f) {
        float f2 = ENGINE_RATINGS[(int)Math.ceil(n / 5)];
        switch (n2) {
            case 0: {
                f2 *= 2.0f;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                f2 *= 0.5f;
                break;
            }
            case 3: {
                f2 *= 0.75f;
            }
        }
        if (Engine.hasFlag(n3, 16)) {
            f2 *= 1.5f;
        }
        return TestEntity.ceilMaxHalf(f2, f);
    }

    public int getCountEngineHeatSinks() {
        return Engine.getCountEngineHeatSinks(this.engineType);
    }

    public static int getCountEngineHeatSinks(int n) {
        if (!Engine.isFusionEngine(n)) {
            return 0;
        }
        return 10;
    }

    public int integralHeatSinkCapacity() {
        return Engine.integralHeatSinkCapacity(this.engineRating, this.engineType);
    }

    public static int integralHeatSinkCapacity(int n, int n2) {
        if (!Engine.isFusionEngine(n2)) {
            return 0;
        }
        return n / 25;
    }

    public String getShortEngineName() {
        return Engine.getShortEngineName(this.engineRating, this.engineType, this.engineFlags);
    }

    public static String getShortEngineName(int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                return Integer.toString(n) + " Comp";
            }
            case 1: {
                return Integer.toString(n);
            }
            case 2: {
                return Integer.toString(n) + " XL" + (Engine.hasFlag(n3, 1) ? " (Clan)" : "");
            }
            case 3: {
                return Integer.toString(n) + " Light" + (Engine.hasFlag(n3, 1) ? " (Clan)" : "");
            }
        }
        return "Invalid Engine!";
    }

    public static String getEngineName(int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                return Integer.toString(n) + " Compustion";
            }
            case 1: {
                return (Engine.hasFlag(n3, 16) ? "Tank " : "") + Integer.toString(n);
            }
            case 2: {
                return (Engine.hasFlag(n3, 16) ? "Tank " : "") + Integer.toString(n) + " XL" + (Engine.hasFlag(n3, 1) ? " (Clan)" : "");
            }
            case 3: {
                return (Engine.hasFlag(n3, 16) ? "Tank " : "") + Integer.toString(n) + " Light" + (Engine.hasFlag(n3, 1) ? " (Clan)" : "");
            }
        }
        return null;
    }

    public int getRating() {
        return this.engineRating;
    }
}

