/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.IGame;
import megamek.common.util.StringUtil;
import megamek.common.xml.CoordsEncoder;

public class BuildingEncoder {
    public static void encode(Building building, Writer writer) throws IOException {
        if (null == building) {
            throw new IllegalArgumentException("The board is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<building version=\"1.0\" >");
        writer.write("<buildingData id=\"");
        writer.write(Integer.toString(building.getId()));
        writer.write("\" type=\"");
        writer.write(Integer.toString(building.getType()));
        writer.write("\" currentCF=\"");
        writer.write(Integer.toString(building.getCurrentCF()));
        writer.write("\" phaseCF=\"");
        writer.write(Integer.toString(building.getPhaseCF()));
        writer.write("\" name=\"");
        writer.write(building.getName());
        writer.write("\" isBurning=\"");
        writer.write(building.isBurning() ? "true" : "false");
        writer.write("\" >");
        Enumeration enumeration = building.getCoords();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                Coords coords = (Coords)enumeration.nextElement();
                CoordsEncoder.encode(coords, writer);
            }
        }
        writer.write("</buildingData>");
        writer.write("</building>");
    }

    public static Building decode(ParsedXML parsedXML, IGame iGame) {
        String string = null;
        int n = 0;
        Building building = null;
        Vector<Coords> vector = new Vector<Coords>();
        Enumeration enumeration = null;
        ParsedXML parsedXML2 = null;
        Coords coords = null;
        int n2 = -1;
        int n3 = -1;
        String string2 = null;
        boolean bl = false;
        Enumeration enumeration2 = parsedXML.elements();
        while (enumeration2.hasMoreElements()) {
            ParsedXML parsedXML3 = (ParsedXML)enumeration2.nextElement();
            String string3 = parsedXML3.getName();
            if (null == string3 || !string3.equals("buildingData")) continue;
            if (null != building) {
                throw new IllegalStateException("More than one 'buildingData' node in a building node.");
            }
            enumeration = parsedXML3.elements();
            while (enumeration.hasMoreElements()) {
                parsedXML2 = (ParsedXML)enumeration.nextElement();
                if (!parsedXML2.getName().equals("coords") || null == (coords = CoordsEncoder.decode(parsedXML2, iGame))) continue;
                vector.addElement(coords);
            }
            if (0 >= vector.size()) {
                throw new IllegalStateException("Couldn't decode the coords for the building.");
            }
            string = parsedXML3.getAttribute("type");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode the buildingData for a building node.");
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Couldn't get an integer from " + string);
            }
            n2 = n;
            if (n2 < 0 || n2 > 4) {
                throw new IllegalStateException("Illegal value for type: " + string);
            }
            string = parsedXML3.getAttribute("id");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode the buildingData for a building node.");
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Couldn't get an integer from " + string);
            }
            n3 = n;
            if (0 >= n3) {
                throw new IllegalStateException("Illegal value for id: " + string);
            }
            string = parsedXML3.getAttribute("name");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode the buildingData for a building node.");
            }
            string2 = string;
            try {
                building = new Building(n2, n3, string2, vector);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException.getMessage());
            }
            string = parsedXML3.getAttribute("currentCF");
            if (null != string) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Couldn't get an integer from " + string);
                }
                if (0 > n) {
                    throw new IllegalStateException("Illegal value for currentCF: " + string);
                }
                building.setCurrentCF(n);
            }
            if (null != (string = parsedXML3.getAttribute("phaseCF"))) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Couldn't get an integer from " + string);
                }
                if (0 >= n) {
                    throw new IllegalStateException("Illegal value for phaseCF: " + string);
                }
                building.setPhaseCF(n);
            }
            building.setBurning(StringUtil.parseBoolean(parsedXML3.getAttribute("isBurning")));
        }
        return building;
    }
}

