/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.BipedMech;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.InfernoTracker;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.xml.BattleArmorEncoder;
import megamek.common.xml.BipedMechEncoder;
import megamek.common.xml.CoordsEncoder;
import megamek.common.xml.EntityActionEncoder;
import megamek.common.xml.InfantryEncoder;
import megamek.common.xml.ProtomechEncoder;
import megamek.common.xml.QuadMechEncoder;
import megamek.common.xml.TankEncoder;

public class EntityEncoder {
    public static void encode(Entity entity, Writer writer) throws IOException {
        String string;
        String string2;
        if (null == entity) {
            throw new IllegalArgumentException("The entity is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        Enumeration enumeration = entity.getLoadedUnits().elements();
        while (enumeration.hasMoreElements()) {
            EntityEncoder.encode((Entity)enumeration.nextElement(), writer);
        }
        writer.write("<entity chassis=\"");
        writer.write(entity.getChassis());
        writer.write("\" model=\"");
        writer.write(entity.getModel());
        writer.write("\" type=\"");
        writer.write(entity.getMovementModeAsString());
        writer.write("\" typeVal=\"");
        writer.write(String.valueOf(entity.getMovementMode()));
        writer.write("\" techBase=\"");
        writer.write(entity.getTechLevel() + ":" + TechConstants.getLevelName(entity.getTechLevel()));
        writer.write("\" year=\"");
        writer.write(String.valueOf(entity.getYear()));
        writer.write("\" mass=\"");
        writer.write(String.valueOf(entity.getWeight()));
        writer.write("\" walkMp=\"");
        writer.write(String.valueOf(entity.getOriginalWalkMP()));
        writer.write("\" jumpMp=\"");
        writer.write(String.valueOf(entity.getOriginalJumpMP()));
        writer.write("\">");
        Pilot pilot = entity.getCrew();
        writer.write("<pilot name=\"");
        writer.write(pilot.getName());
        writer.write("\" gunnery=\"");
        writer.write(String.valueOf(pilot.getGunnery()));
        writer.write("\" piloting=\"");
        writer.write(String.valueOf(pilot.getPiloting()));
        if (pilot.isDead() || pilot.getHits() > 5) {
            writer.write("\" hits=\"Dead");
        } else if (pilot.getHits() > 0) {
            writer.write("\" hits=\"");
            writer.write(String.valueOf(pilot.getHits()));
        }
        if (pilot.countAdvantages() > 0) {
            writer.write("\" advantages=\"");
            writer.write(String.valueOf(pilot.getAdvantageList(" ")));
        }
        writer.write("\"/>");
        writer.write("<entityData gameId=\"");
        writer.write(String.valueOf(entity.getId()));
        writer.write("\" externalId=\"");
        writer.write(String.valueOf(entity.getExternalId()));
        writer.write("\" ownerId=\"");
        writer.write(String.valueOf(entity.getOwnerId()));
        writer.write("\" facing=\"");
        writer.write(String.valueOf(entity.getFacing()));
        writer.write("\" secondaryFacing=\"");
        writer.write(String.valueOf(entity.getSecondaryFacing()));
        writer.write("\" walkMpCurrent=\"");
        writer.write(String.valueOf(entity.getWalkMP()));
        writer.write("\" isOmni=\"");
        writer.write(entity.isOmni() ? "true" : "false");
        writer.write("\" jumpMpCurrent=\"");
        writer.write(String.valueOf(entity.getJumpMP()));
        writer.write("\" C3MasterId=\"");
        writer.write(String.valueOf(entity.getC3MasterId()));
        writer.write("\" transportId=\"");
        writer.write(String.valueOf(entity.getTransportId()));
        writer.write("\" swarmTargetId=\"");
        writer.write(String.valueOf(entity.getSwarmTargetId()));
        writer.write("\" swarmAttackerId=\"");
        writer.write(String.valueOf(entity.getSwarmAttackerId()));
        writer.write("\" removalCondition=\"");
        writer.write(String.valueOf(entity.getRemovalCondition()));
        writer.write("\" deployRound=\"");
        writer.write(String.valueOf(entity.getDeployRound()));
        writer.write("\" isShutDown=\"");
        writer.write(entity.isShutDown() ? "true" : "false");
        writer.write("\" isDoomed=\"");
        writer.write(entity.isDoomed() ? "true" : "false");
        writer.write("\" isDestroyed=\"");
        writer.write(entity.isDestroyed() ? "true" : "false");
        writer.write("\" isDone=\"");
        writer.write(entity.isDone() ? "true" : "false");
        writer.write("\" isProne=\"");
        writer.write(entity.isProne() ? "true" : "false");
        writer.write("\" isFindingClub=\"");
        writer.write(entity.isFindingClub() ? "true" : "false");
        writer.write("\" isArmsFlipped=\"");
        writer.write(entity.getArmsFlipped() ? "true" : "false");
        writer.write("\" isUnjammingRAC=\"");
        writer.write(entity.isUnjammingRAC() ? "true" : "false");
        writer.write("\" isSpotting=\"");
        writer.write(entity.isSpotting() ? "true" : "false");
        writer.write("\" isClearingMinefield=\"");
        writer.write(entity.isClearingMinefield() ? "true" : "false");
        writer.write("\" isSalvage=\"");
        writer.write(entity.isSalvage() ? "true" : "false");
        writer.write("\" isDeployed=\"");
        writer.write(entity.isDeployed() ? "true" : "false");
        writer.write("\" isUnloadedThisTurn=\"");
        writer.write(entity.isUnloadedThisTurn() ? "true" : "false");
        writer.write("\" heat=\"");
        writer.write(String.valueOf(entity.heat));
        writer.write("\" heatBuildup=\"");
        writer.write(String.valueOf(entity.heatBuildup));
        writer.write("\" delta_distance=\"");
        writer.write(String.valueOf(entity.delta_distance));
        writer.write("\" mpUsed=\"");
        writer.write(String.valueOf(entity.mpUsed));
        writer.write("\" moved=\"");
        writer.write(String.valueOf(entity.moved));
        writer.write("\" damageThisPhase=\"");
        writer.write(String.valueOf(entity.damageThisPhase));
        writer.write("\" engineHitsThisRound=\"");
        writer.write(String.valueOf(entity.engineHitsThisRound));
        writer.write("\" rolledForEngineExplosion=\"");
        writer.write(entity.rolledForEngineExplosion ? "true" : "false");
        writer.write("\" dodging=\"");
        writer.write(entity.dodging ? "true" : "false");
        writer.write("\" >");
        Coords coords = entity.getPosition();
        if (null != coords) {
            CoordsEncoder.encode(coords, writer);
        }
        if (entity.hasDisplacementAttack()) {
            EntityActionEncoder.encode(entity.getDisplacementAttack(), writer);
        }
        if (null != (string2 = EntityEncoder.getNarcString(entity))) {
            writer.write(string2);
        }
        if (entity.infernos.isStillBurning()) {
            writer.write("<inferno>");
            int n = entity.infernos.getArrowIVTurnsLeftToBurn();
            if (n > 0) {
                writer.write("<arrowiv turns=\"");
                writer.write(String.valueOf(n));
                writer.write("\" />");
            }
            n -= entity.infernos.getTurnsLeftToBurn();
            if ((n = -n) > 0) {
                writer.write("<standard turns=\"");
                writer.write(String.valueOf(n));
                writer.write("\" />");
            }
            writer.write("</inferno>");
        }
        if (null != (string = Entity.encodeTransporters(entity)) && 0 == string.length()) {
            writer.write("<transporters value=\"");
            writer.write(string);
            writer.write("\" />");
        }
        if ((enumeration = entity.getLoadedUnits().elements()).hasMoreElements()) {
            writer.write("<loadedUnits>");
            while (enumeration.hasMoreElements()) {
                Entity entity2 = (Entity)enumeration.nextElement();
                writer.write("<entityRef gameId=\"");
                writer.write(String.valueOf(entity2.getId()));
                writer.write("\" />");
            }
            writer.write("</loadedUnits>");
        }
        writer.write("<class name=\"");
        if (entity instanceof BipedMech) {
            writer.write("BipedMech\">");
            BipedMechEncoder.encode(entity, writer);
        } else if (entity instanceof QuadMech) {
            writer.write("QuadMech\">");
            QuadMechEncoder.encode(entity, writer);
        } else if (entity instanceof Tank) {
            writer.write("Tank\">");
            TankEncoder.encode(entity, writer);
        } else if (entity instanceof BattleArmor) {
            writer.write("BattleArmor\">");
            BattleArmorEncoder.encode(entity, writer);
        } else if (entity instanceof Infantry) {
            writer.write("Infantry\">");
            InfantryEncoder.encode(entity, writer);
        } else if (entity instanceof Protomech) {
            writer.write("Protomech\">");
            ProtomechEncoder.encode(entity, writer);
        } else {
            throw new IllegalStateException("Unexpected entity type " + entity.getClass().getName());
        }
        writer.write("</class>");
        writer.write("</entityData>");
        enumeration = entity.getEquipment();
        if (enumeration.hasMoreElements()) {
            writer.write("<entityEquipment>");
            int n = 0;
            while (enumeration.hasMoreElements()) {
                string2 = EntityEncoder.formatEquipment(n, (Mounted)enumeration.nextElement(), entity);
                if (null != string2) {
                    writer.write(string2);
                }
                ++n;
            }
            writer.write("</entityEquipment>");
        }
        if (null != (string2 = EntityEncoder.getLocString(entity))) {
            writer.write(string2);
        }
        writer.write("</entity>");
    }

    private static String getNarcString(Entity entity) {
        if (null == entity) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < Player.MAX_TEAMS; ++i) {
            if (!entity.isNarcedBy(i)) continue;
            if (!bl) {
                stringBuffer.append("<narcs>");
                bl = true;
            }
            stringBuffer.append("<narc type=\"Standard\" team=\"");
            stringBuffer.append(String.valueOf(i));
            stringBuffer.append("\" />");
        }
        if (!bl) {
            return null;
        }
        stringBuffer.append("</narcs>");
        return stringBuffer.toString();
    }

    private static String formatEquipment(int n, Mounted mounted, Entity entity) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null == mounted) {
            return null;
        }
        stringBuffer.append("<equipment index=\"");
        stringBuffer.append(String.valueOf(n));
        stringBuffer.append("\" type=\"");
        stringBuffer.append(mounted.getType().getInternalName());
        stringBuffer.append("\" location=\"");
        stringBuffer.append(String.valueOf(mounted.getLocation()));
        stringBuffer.append("\" isRear=\"");
        stringBuffer.append(mounted.isRearMounted() ? "true" : "false");
        if (mounted.getType() instanceof AmmoType) {
            stringBuffer.append("\" shots=\"");
            stringBuffer.append(String.valueOf(mounted.getShotsLeft()));
        }
        stringBuffer.append("\" curMode=\"");
        stringBuffer.append(mounted.curMode().getName());
        stringBuffer.append("\" pendingMode=\"");
        stringBuffer.append(mounted.pendingMode().getName());
        stringBuffer.append("\" linkedRef=\"");
        if (null == mounted.getLinked()) {
            stringBuffer.append("N/A");
        } else {
            stringBuffer.append(String.valueOf(entity.getEquipmentNum(mounted.getLinked())));
        }
        stringBuffer.append("\" foundCrits=\"");
        stringBuffer.append(String.valueOf(mounted.getFoundCrits()));
        stringBuffer.append("\" isUsedThisRound=\"");
        stringBuffer.append(mounted.isUsedThisRound() ? "true" : "false");
        stringBuffer.append("\" isBreached=\"");
        stringBuffer.append(mounted.isBreached() ? "true" : "false");
        stringBuffer.append("\" isHit=\"");
        stringBuffer.append(mounted.isHit() ? "true" : "false");
        stringBuffer.append("\" isDestroyed=\"");
        stringBuffer.append(mounted.isDestroyed() ? "true" : "false");
        stringBuffer.append("\" isMissing=\"");
        stringBuffer.append(mounted.isMissing() ? "true" : "false");
        stringBuffer.append("\" isJammed=\"");
        stringBuffer.append(mounted.isJammed() ? "true" : "false");
        stringBuffer.append("\" isPendingDump=\"");
        stringBuffer.append(mounted.isPendingDump() ? "true" : "false");
        stringBuffer.append("\" isDumping=\"");
        stringBuffer.append(mounted.isDumping() ? "true" : "false");
        stringBuffer.append("\" isSplit=\"");
        stringBuffer.append(mounted.isSplit() ? "true" : "false");
        stringBuffer.append("\" isFired=\"");
        stringBuffer.append(mounted.isFired() ? "true" : "false");
        stringBuffer.append("\"/>");
        return stringBuffer.toString();
    }

    private static String formatSlot(CriticalSlot criticalSlot, Mounted mounted) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<slot index=\"");
        stringBuffer.append(String.valueOf(criticalSlot.getIndex() + 1));
        stringBuffer.append("\" type=\"");
        if (mounted == null) {
            stringBuffer.append("System");
        } else {
            stringBuffer.append(mounted.getType().getInternalName());
            if (mounted.isRearMounted()) {
                stringBuffer.append("\" isRear=\"true");
            }
            if (mounted.getType() instanceof AmmoType) {
                stringBuffer.append("\" shots=\"");
                stringBuffer.append(String.valueOf(mounted.getShotsLeft()));
            }
        }
        stringBuffer.append("\" isHit=\"");
        stringBuffer.append(criticalSlot.isHit() ? "true" : "false");
        stringBuffer.append("\" isDestroyed=\"");
        stringBuffer.append(criticalSlot.isDestroyed() ? "true" : "false");
        stringBuffer.append("\" isMissing=\"");
        stringBuffer.append(criticalSlot.isMissing() ? "true" : "false");
        stringBuffer.append("\" isBreached=\"");
        stringBuffer.append(criticalSlot.isBreached() ? "true" : "false");
        stringBuffer.append("\" isHittable=\"");
        stringBuffer.append(criticalSlot.isEverHittable() ? "true" : "false");
        stringBuffer.append("\"/>");
        return stringBuffer.toString();
    }

    private static String getLocString(Entity entity) {
        boolean bl = entity instanceof Mech;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < entity.locations(); ++i) {
            Serializable serializable;
            stringBuffer.append("<location index=\"");
            stringBuffer.append(String.valueOf(i));
            stringBuffer.append("\"> ");
            if (entity.getOInternal(i) != -1) {
                stringBuffer.append("<armor points=\"");
                stringBuffer.append(String.valueOf(entity.getArmor(i)));
                stringBuffer.append("\"/>");
                stringBuffer.append("<armor points=\"");
                stringBuffer.append(String.valueOf(entity.getInternal(i)));
                stringBuffer.append("\" type=\"Internal\"/>");
                if (entity.hasRearArmor(i)) {
                    stringBuffer.append("<armor points=\"");
                    stringBuffer.append(String.valueOf(entity.getArmor(i, true)));
                    stringBuffer.append("\" type=\"Rear\"/>");
                }
            }
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                serializable = entity.getCritical(i, j);
                if (null == serializable) {
                    if (!bl || entity.entityIsQuad() || i != 4 && i != 5 || j != 2 && j != 3) continue;
                    stringBuffer.append("<slot index=\"");
                    stringBuffer.append(String.valueOf(j + 1));
                    stringBuffer.append("\" type=\"Empty\"/>");
                    continue;
                }
                Mounted mounted = null;
                if (1 == ((CriticalSlot)serializable).getType()) {
                    mounted = entity.getEquipment(((CriticalSlot)serializable).getIndex());
                }
                stringBuffer.append(EntityEncoder.formatSlot((CriticalSlot)serializable, mounted));
            }
            if (entity instanceof Tank || entity instanceof Protomech) {
                Enumeration enumeration = entity.getAmmo();
                while (enumeration.hasMoreElements()) {
                    serializable = (Mounted)enumeration.nextElement();
                    if (((Mounted)serializable).getLocation() != i) continue;
                    stringBuffer.append("<slot index=\"N/A\" type=\"");
                    stringBuffer.append(((Mounted)serializable).getType().getInternalName());
                    stringBuffer.append("\" shots=\"");
                    stringBuffer.append(String.valueOf(((Mounted)serializable).getShotsLeft()));
                    stringBuffer.append("\"/>");
                }
            }
            stringBuffer.append("</location>");
        }
        return stringBuffer.toString();
    }

    private static void decodePilot(ParsedXML parsedXML, Entity entity) {
    }

    private static void decodeEntityEquipment(ParsedXML parsedXML, Entity entity) {
    }

    private static void decodeLocation(ParsedXML parsedXML, Entity entity) {
    }

    private static void decodeInferno(ParsedXML parsedXML, Entity entity) {
        String string = null;
        int n = 0;
        if (null == parsedXML) {
            throw new IllegalArgumentException("The inferno is null.");
        }
        if (!parsedXML.getName().equals("inferno")) {
            throw new IllegalStateException("Not passed a inferno node.");
        }
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            if (parsedXML2.getName().equals("arrowiv")) {
                string = parsedXML2.getAttribute("turns");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode the burn turns for an Arrow IV inferno round.");
                }
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Couldn't get an integer from " + string);
                }
                entity.infernos.add(InfernoTracker.INFERNO_IV_TURN, n);
                continue;
            }
            if (!parsedXML2.getName().equals("standard")) continue;
            string = parsedXML2.getAttribute("turns");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode the burn turns for a standard inferno round.");
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Couldn't get an integer from " + string);
            }
            entity.infernos.add(InfernoTracker.STANDARD_TURN, n);
        }
    }

    private static Entity decodeEntityData(ParsedXML parsedXML, IGame iGame) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        Entity entity = null;
        Coords coords = null;
        ParsedXML parsedXML2 = null;
        ParsedXML parsedXML3 = null;
        ParsedXML parsedXML4 = null;
        ParsedXML parsedXML5 = null;
        if (null == parsedXML) {
            throw new IllegalArgumentException("The entityData is null.");
        }
        if (!parsedXML.getName().equals("entityData")) {
            throw new IllegalStateException("Not passed a entityData node.");
        }
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            ParsedXML parsedXML6 = (ParsedXML)enumeration.nextElement();
            String string2 = parsedXML6.getName();
            if (null == string2) continue;
            if (string2.equals("coords")) {
                coords = CoordsEncoder.decode(parsedXML6, iGame);
                continue;
            }
            if (string2.equals("action")) {
                parsedXML2 = parsedXML6;
                continue;
            }
            if (string2.equals("narcs")) {
                parsedXML3 = parsedXML6;
                continue;
            }
            if (string2.equals("inferno")) {
                parsedXML4 = parsedXML6;
                continue;
            }
            if (string2.equals("loadedUnits")) {
                parsedXML5 = parsedXML6;
                continue;
            }
            if (!string2.equals("class")) continue;
            string = parsedXML6.getAttribute("name");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode the name of a class node.");
            }
            if (string.equals("BipedMech")) {
                entity = BipedMechEncoder.decode(parsedXML6, iGame);
                continue;
            }
            if (string.equals("QuadMech")) {
                entity = QuadMechEncoder.decode(parsedXML6, iGame);
                continue;
            }
            if (string.equals("Tank")) {
                entity = TankEncoder.decode(parsedXML6, iGame);
                continue;
            }
            if (string.equals("BattleArmor")) {
                entity = BattleArmorEncoder.decode(parsedXML6, iGame);
                continue;
            }
            if (string.equals("Infantry")) {
                entity = InfantryEncoder.decode(parsedXML6, iGame);
                continue;
            }
            if (string.equals("Protomech")) {
                entity = ProtomechEncoder.decode(parsedXML6, iGame);
                continue;
            }
            throw new IllegalStateException("Unexpected name for a class node: " + string);
        }
        if (null == entity) {
            throw new IllegalStateException("Couldn't locate the class for an entityData node.");
        }
        EntityEncoder.decodeInferno(parsedXML4, entity);
        return entity;
    }

    public static Entity decode(ParsedXML parsedXML, IGame iGame) {
        String string = null;
        int n = 0;
        Entity entity = null;
        Object var5_5 = null;
        Vector<ParsedXML> vector = new Vector<ParsedXML>();
        ParsedXML parsedXML2 = null;
        ParsedXML parsedXML3 = null;
        Enumeration enumeration = null;
        ParsedXML parsedXML4 = null;
        if (null == parsedXML) {
            throw new IllegalArgumentException("The entity is null.");
        }
        if (!parsedXML.getName().equals("entity")) {
            throw new IllegalStateException("Not passed a entity node.");
        }
        enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            parsedXML4 = (ParsedXML)enumeration.nextElement();
            String string2 = parsedXML4.getName();
            if (null == string2) continue;
            if (string2.equals("pilot")) {
                parsedXML2 = parsedXML4;
                continue;
            }
            if (string2.equals("entityData")) {
                if (null != entity) {
                    throw new IllegalStateException("Found two entityData nodes for an Entity node.");
                }
                entity = EntityEncoder.decodeEntityData(parsedXML4, iGame);
                continue;
            }
            if (string2.equals("entityEquipment")) {
                parsedXML3 = parsedXML4;
                continue;
            }
            if (!string2.equals("location")) continue;
            vector.addElement(parsedXML4);
        }
        if (null == entity) {
            throw new IllegalStateException("Couldn't locate the entityData for an Entity node.");
        }
        if (null == parsedXML2) {
            throw new IllegalStateException("Couldn't locate the pilot for an Entity node.");
        }
        if (null == parsedXML3) {
            throw new IllegalStateException("Couldn't locate the entityEquipment for an Entity node.");
        }
        if (vector.size() != entity.locations()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Found ").append(vector.size()).append(" locations for an Entity node. ").append("Was expecting to find ").append(entity.locations()).append(".");
            throw new IllegalStateException(stringBuffer.toString());
        }
        string = parsedXML.getAttribute("chassis");
        if (null == string) {
            throw new IllegalStateException("Couldn't decode the chassis from an Entity node.");
        }
        entity.setChassis(string);
        string = parsedXML.getAttribute("model");
        if (null == string) {
            throw new IllegalStateException("Couldn't decode the model from an Entity node.");
        }
        entity.setModel(string);
        string = parsedXML.getAttribute("typeVal");
        if (null == string) {
            throw new IllegalStateException("Couldn't decode the typeVal from an Entity node.");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Couldn't get an integer from " + string);
        }
        entity.setMovementMode(n);
        string = parsedXML.getAttribute("year");
        if (null == string) {
            throw new IllegalStateException("Couldn't decode the year from an Entity node.");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Couldn't get an integer from " + string);
        }
        entity.setYear(n);
        string = parsedXML.getAttribute("techBase");
        if (null == string) {
            throw new IllegalStateException("Couldn't decode the techBase from an Entity node.");
        }
        try {
            n = Integer.parseInt(string.substring(0, 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Couldn't get an integer from " + string.substring(0, 1));
        }
        entity.setTechLevel(n);
        string = parsedXML.getAttribute("mass");
        if (null == string) {
            throw new IllegalStateException("Couldn't decode the mass from an Entity node.");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Couldn't get an integer from " + string);
        }
        entity.setWeight(n);
        string = parsedXML.getAttribute("walkMp");
        if (null == string) {
            throw new IllegalStateException("Couldn't decode the walkMp from an Entity node.");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Couldn't get an integer from " + string);
        }
        entity.setOriginalWalkMP(n);
        string = parsedXML.getAttribute("jumpMp");
        if (null == string) {
            throw new IllegalStateException("Couldn't decode the jumpMp from an Entity node.");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Couldn't get an integer from " + string);
        }
        entity.setOriginalJumpMP(n);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Couldn't get an integer from " + string);
        }
        EntityEncoder.decodePilot(parsedXML2, entity);
        EntityEncoder.decodeEntityEquipment(parsedXML3, entity);
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            parsedXML4 = (ParsedXML)enumeration.nextElement();
            EntityEncoder.decodeLocation(parsedXML4, entity);
        }
        return entity;
    }
}

