/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.MegaMek;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.BipedMech;
import megamek.common.Board;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.EquipmentMode;
import megamek.common.EquipmentType;
import megamek.common.Flare;
import megamek.common.Game;
import megamek.common.GameTurn;
import megamek.common.HitData;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.INarcPod;
import megamek.common.Infantry;
import megamek.common.InfernoTracker;
import megamek.common.LocationFullException;
import megamek.common.LosEffects;
import megamek.common.MapSettings;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.Minefield;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.PhysicalResult;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Report;
import megamek.common.RoundUpdated;
import megamek.common.TagInfo;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.Team;
import megamek.common.Terrains;
import megamek.common.ToHitData;
import megamek.common.TurnOrdered;
import megamek.common.TurnVectors;
import megamek.common.UnitLocation;
import megamek.common.VTOL;
import megamek.common.WeaponResult;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.BrushOffAttackAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.ClearMinefieldAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.DisplacementAttackAction;
import megamek.common.actions.DodgeAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.FindClubAction;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.LayMinefieldAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.SpotAction;
import megamek.common.actions.ThrashAttackAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.TriggerAPPodAction;
import megamek.common.actions.UnjamAction;
import megamek.common.actions.UnloadStrandedAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.net.Connection;
import megamek.common.net.ConnectionFactory;
import megamek.common.net.ConnectionListenerAdapter;
import megamek.common.net.DisconnectedEvent;
import megamek.common.net.Packet;
import megamek.common.net.PacketReceivedEvent;
import megamek.common.options.IBasicOption;
import megamek.common.options.IOption;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.BoardUtilities;
import megamek.common.util.StringUtil;
import megamek.common.verifier.EntityVerifier;
import megamek.common.verifier.TestEntity;
import megamek.common.verifier.TestMech;
import megamek.common.verifier.TestTank;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.ElevatorProcessor;
import megamek.server.FireProcessor;
import megamek.server.GeyserProcessor;
import megamek.server.UnitStatusFormatter;
import megamek.server.commands.DefeatCommand;
import megamek.server.commands.FixElevationCommand;
import megamek.server.commands.HelpCommand;
import megamek.server.commands.KickCommand;
import megamek.server.commands.LocalSaveGameCommand;
import megamek.server.commands.ResetCommand;
import megamek.server.commands.RollCommand;
import megamek.server.commands.SaveGameCommand;
import megamek.server.commands.SeeAllCommand;
import megamek.server.commands.ServerCommand;
import megamek.server.commands.SkipCommand;
import megamek.server.commands.VictoryCommand;
import megamek.server.commands.WhoCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements Runnable {
    public static final String DEFAULT_BOARD = "[SURPRISE]";
    private static final String VERIFIER_CONFIG_FILENAME = "data/mechfiles/UnitVerifierOptions.xml";
    private String password;
    private ServerSocket serverSocket;
    private String motd;
    private Vector connections = new Vector(4);
    private Vector connectionsPending = new Vector(4);
    private Hashtable connectionIds = new Hashtable();
    private int connectionCounter = 0;
    private int entityCounter = 0;
    private IGame game = new Game();
    private Vector vPhaseReport = new Vector();
    private MapSettings mapSettings = new MapSettings();
    private Hashtable commandsHash = new Hashtable();
    private Thread connector;
    private Hashtable affectedBldgs = new Hashtable();
    private Vector physicalResults = new Vector();
    private Vector<DynamicTerrainProcessor> terrainProcessors = new Vector();
    private static EntityVerifier entityVerifier = null;
    private ConnectionListenerAdapter connectionListener = new ConnectionListenerAdapter(){

        public void disconnected(DisconnectedEvent disconnectedEvent) {
            Connection connection = disconnectedEvent.getConnection();
            System.out.println("s: connection " + connection.getId() + " disconnected");
            Server.this.connections.removeElement(connection);
            Server.this.connectionsPending.removeElement(connection);
            Server.this.connectionIds.remove(new Integer(connection.getId()));
            Player player = Server.this.getPlayer(connection.getId());
            if (null != player) {
                Server.this.disconnected(player);
            }
        }

        public void packetReceived(PacketReceivedEvent packetReceivedEvent) {
            Server.this.handle(packetReceivedEvent.getConnection().getId(), packetReceivedEvent.getPacket());
        }
    };
    private static final String DUNE_CALL = "They tried and failed?";
    private static final String DUNE_RESPONSE = "They tried and died!";
    private static final String STAR_WARS_CALL = "I'd just as soon kiss a Wookiee.";
    private static final String STAR_WARS_RESPONSE = "I can arrange that!";

    public Server(String string, int n) {
        this.password = string.length() > 0 ? string : null;
        try {
            this.serverSocket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            System.err.println("could not create server socket on port " + n);
        }
        this.motd = this.createMotd();
        this.game.getOptions().initialize();
        this.changePhase(1);
        System.out.println("s: starting a new server...");
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            System.out.print("s: hostname = '");
            System.out.print(string2);
            System.out.print("' port = ");
            System.out.println(this.serverSocket.getLocalPort());
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string2);
            for (int i = 0; i < inetAddressArray.length; ++i) {
                System.out.println("s: hosting on address = " + inetAddressArray[i].getHostAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        System.out.println("s: password = " + this.password);
        this.connector = new Thread((Runnable)this, "Connection Listener");
        this.connector.start();
        this.registerCommand(new DefeatCommand(this));
        this.registerCommand(new HelpCommand(this));
        this.registerCommand(new KickCommand(this));
        this.registerCommand(new ResetCommand(this));
        this.registerCommand(new RollCommand(this));
        this.registerCommand(new SaveGameCommand(this));
        this.registerCommand(new SkipCommand(this));
        this.registerCommand(new VictoryCommand(this));
        this.registerCommand(new WhoCommand(this));
        this.registerCommand(new SeeAllCommand(this));
        this.registerCommand(new LocalSaveGameCommand(this));
        this.registerCommand(new FixElevationCommand(this));
        this.terrainProcessors.add(new FireProcessor(this));
        this.terrainProcessors.add(new GeyserProcessor(this));
        this.terrainProcessors.add(new ElevatorProcessor(this));
    }

    public void setGame(IGame iGame) {
        Serializable serializable;
        this.game = iGame;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            ((Entity)serializable).setGame(this.game);
        }
        this.game.setOutOfGameEntitiesVector(this.game.getOutOfGameEntitiesVector());
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            serializable = (Player)enumeration.nextElement();
            ((Player)serializable).setGame(this.game);
            ((Player)serializable).setGhost(true);
        }
    }

    public IGame getGame() {
        return this.game;
    }

    private String createMotd() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Welcome to MegaMek.  Server is running version ");
        stringBuffer.append(MegaMek.VERSION);
        stringBuffer.append(", build date ");
        if (MegaMek.TIMESTAMP > 0L) {
            stringBuffer.append(new Date(MegaMek.TIMESTAMP).toString());
        } else {
            stringBuffer.append("unknown");
        }
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    public boolean isPassworded() {
        return this.password != null;
    }

    public boolean isPassword(Object object) {
        return this.password.equals(object);
    }

    private void registerCommand(ServerCommand serverCommand) {
        this.commandsHash.put(serverCommand.getName(), serverCommand);
    }

    public ServerCommand getCommand(String string) {
        return (ServerCommand)this.commandsHash.get(string);
    }

    public void die() {
        Connection connection;
        this.connector = null;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration enumeration = this.connectionsPending.elements();
        while (enumeration.hasMoreElements()) {
            connection = (Connection)enumeration.nextElement();
            connection.close();
        }
        this.connectionsPending.removeAllElements();
        enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            connection = (Connection)enumeration.nextElement();
            this.send(connection.getId(), new Packet(0));
        }
        enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            connection = (Connection)enumeration.nextElement();
            connection.close();
        }
        this.connections.removeAllElements();
        this.connectionIds.clear();
    }

    public Enumeration getAllCommandNames() {
        return this.commandsHash.keys();
    }

    private void greeting(int n) {
        this.sendToPending(n, new Packet(10));
    }

    public int getFreeConnectionId() {
        while (this.getPendingConnection(this.connectionCounter) != null || this.getConnection(this.connectionCounter) != null || this.getPlayer(this.connectionCounter) != null) {
            ++this.connectionCounter;
        }
        return this.connectionCounter;
    }

    public int getFreeEntityId() {
        return this.game.getNextEntityId();
    }

    private void receivePlayerInfo(Packet packet, int n) {
        Player player = (Player)packet.getObject(0);
        Player player2 = this.game.getPlayer(n);
        if (null != player2) {
            player2.setColorIndex(player.getColorIndex());
            player2.setStartingPos(player.getStartingPos());
            player2.setTeam(player.getTeam());
            player2.setCamoCategory(player.getCamoCategory());
            player2.setCamoFileName(player.getCamoFileName());
            player2.setNbrMFConventional(player.getNbrMFConventional());
            player2.setNbrMFCommand(player.getNbrMFCommand());
            player2.setNbrMFVibra(player.getNbrMFVibra());
        }
    }

    private String correctDupeName(String string) {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (!player.getName().equals(string)) continue;
            String string2 = string;
            int n = 2;
            try {
                n = Integer.parseInt(string.substring(string.lastIndexOf(".") + 1));
                ++n;
                string2 = string.substring(0, string.lastIndexOf("."));
            }
            catch (Exception exception) {
                n = 2;
            }
            string2 = string2.concat(".").concat(Integer.toString(n));
            return this.correctDupeName(string2);
        }
        return string;
    }

    private void receivePlayerName(Packet packet, int n) {
        Object object;
        Connection connection = this.getPendingConnection(n);
        String string = (String)packet.getObject(0);
        boolean bl = false;
        if (connection == null) {
            System.out.println("server: got a client name from a non-pending connection");
            return;
        }
        Object object2 = this.game.getPlayers();
        while (object2.hasMoreElements()) {
            object = (InetAddress[])object2.nextElement();
            if (!((Player)object).getName().equals(string) || !((Player)object).isGhost()) continue;
            bl = true;
            ((Player)object).setGhost(false);
            n = ((Player)object).getId();
            connection.setId(n);
        }
        if (!bl) {
            string = this.correctDupeName(string);
            this.send(n, new Packet(480, string));
        }
        this.connectionsPending.removeElement(connection);
        this.connections.addElement(connection);
        this.connectionIds.put(new Integer(connection.getId()), connection);
        if (!bl) {
            this.game.addPlayer(n, new Player(n, string));
            this.validatePlayerInfo(n);
        }
        object2 = this.getPlayer(n);
        if (this.game.getPhase() != 1 && null != object2 && this.game.getEntitiesOwnedBy((Player)object2) < 1) {
            ((Player)object2).setObserver(true);
        }
        this.sendServerChat(n, this.motd);
        this.send(this.createPlayerConnectPacket(n));
        this.send(n, new Packet(30, new Integer(n)));
        this.sendCurrentInfo(n);
        try {
            object = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            for (int i = 0; i < ((InetAddress[])object).length; ++i) {
                this.sendServerChat(n, "Machine IP is " + object[i].getHostAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.sendServerChat(n, "Listening on port " + this.serverSocket.getLocalPort());
        object2 = this.getPlayer(n);
        if (null != object2) {
            object = new StringBuffer();
            ((StringBuffer)object).append(((Player)object2).getName()).append(" connected from ").append(this.getClient(n).getInetAddress());
            String string2 = ((StringBuffer)object).toString();
            System.out.print("s: player #");
            System.out.print(n);
            System.out.print(", ");
            System.out.println(string2);
            this.sendServerChat(string2);
        }
    }

    private void sendCurrentInfo(int n) {
        this.transmitAllPlayerConnects(n);
        this.send(n, this.createGameSettingsPacket());
        Player player = this.game.getPlayer(n);
        if (null != player) {
            this.send(n, new Packet(420, player.getMinefields()));
            switch (this.game.getPhase()) {
                case 1: {
                    this.send(n, this.createMapSettingsPacket());
                    this.send(n, new Packet(240, new Integer(this.game.getPhase())));
                    if (this.doBlind()) {
                        this.send(n, this.createFilteredFullEntitiesPacket(player));
                        break;
                    }
                    this.send(n, this.createFullEntitiesPacket());
                    break;
                }
                default: {
                    this.send(n, new Packet(260, new Integer(this.game.getRoundCount())));
                    this.send(n, this.createAllReportsPacket(player));
                    if (this.doBlind()) {
                        this.send(n, this.createFilteredFullEntitiesPacket(player));
                    } else {
                        this.send(n, this.createFullEntitiesPacket());
                    }
                    player.setDone(this.game.getEntitiesOwnedBy(player) <= 0);
                    this.send(n, this.createBoardPacket());
                    this.send(n, new Packet(240, new Integer(this.game.getPhase())));
                }
            }
            if (this.game.getPhase() == 12 || this.game.getPhase() == 7 || this.game.getPhase() == 10 || this.game.getPhase() == 14) {
                this.send(n, this.createAttackPacket(this.game.getActionsVector(), 0));
                this.send(n, this.createAttackPacket(this.game.getChargesVector(), 1));
                this.send(n, this.createAttackPacket(this.game.getLayMinefieldActionsVector(), 2));
            }
            if (this.game.phaseHasTurns(this.game.getPhase())) {
                this.send(n, this.createTurnVectorPacket());
                this.send(n, this.createTurnIndexPacket());
            }
            this.send(n, this.createArtilleryPacket(player));
            this.send(n, this.createFlarePacket());
        }
    }

    public void validatePlayerInfo(int n) {
        Player player = this.getPlayer(n);
        boolean[] blArray = new boolean[Player.colorNames.length];
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player2 = (Player)enumeration.nextElement();
            if (player2.getId() == n) continue;
            blArray[player2.getColorIndex()] = true;
        }
        if (null != player && blArray[player.getColorIndex()]) {
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                player.setColorIndex(i);
                break;
            }
        }
    }

    void disconnected(Player player) {
        int n = this.game.getPhase();
        if (n == 1) {
            this.removeAllEntitesOwnedBy(player);
        }
        if (this.game.getEntitiesOwnedBy(player) > 0 && n != 18) {
            player.setGhost(true);
            player.setDone(true);
            this.send(this.createPlayerUpdatePacket(player.getId()));
        } else {
            this.game.removePlayer(player.getId());
            this.send(new Packet(50, new Integer(player.getId())));
        }
        if (this.game.phaseHasTurns(this.game.getPhase()) && null != this.game.getTurn()) {
            if (this.game.getTurn().isValid(player.getId(), this.game)) {
                this.sendGhostSkipMessage(player);
            }
        } else {
            this.checkReady();
        }
        this.sendServerChat(player.getName() + " disconnected.");
        System.out.println("s: removed player " + player.getName());
        if (0 == this.game.getNoOfPlayers()) {
            this.resetGame();
        }
    }

    public void checkForObservers() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player;
            player.setObserver(this.game.getEntitiesOwnedBy(player = (Player)enumeration.nextElement()) < 1 && this.game.getPhase() != 1);
        }
    }

    public void resetGame() {
        this.game.reset();
        this.send(this.createEntitiesPacket());
        this.send(new Packet(420, new Vector()));
        this.resetPlayersDone();
        this.transmitAllPlayerDones();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        System.out.print(simpleDateFormat.format(new Date()));
        System.out.println(" END OF GAME");
        this.changePhase(1);
    }

    public void autoSave() {
        String string = "autosave";
        if (PreferenceManager.getClientPreferences().stampFilenames()) {
            string = StringUtil.addDateTimeStamp(string);
        }
        this.saveGame(string, this.game.getOptions().booleanOption("autosave_msg"));
    }

    public void sendSaveGame(int n, String string) {
        this.saveGame(string, false);
        String string2 = string;
        if (!string2.endsWith(".sav")) {
            string2 = string + ".sav";
        }
        string2 = "savegames" + File.separator + string2;
        File file = new File(string2);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.send(n, new Packet(490, new Object[]{string2, objectInputStream.readObject()}));
            this.sendChat(n, "***Server", "Savegame has been sent to you.");
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to load file: " + file);
            exception.printStackTrace();
        }
    }

    public void saveGame(String string, boolean bl) {
        String string2 = string;
        if (!string2.endsWith(".sav")) {
            string2 = string + ".sav";
        }
        try {
            File file = new File("savegames");
            if (!file.exists()) {
                file.mkdir();
            }
            string2 = file + File.separator + string2;
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2));
            objectOutputStream.writeObject(this.game);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to save file: " + string2);
            exception.printStackTrace();
        }
        if (bl) {
            this.sendChat("MegaMek", "Game saved to " + string2);
        }
    }

    public void saveGame(String string) {
        this.saveGame(string, true);
    }

    public boolean loadGame(File file) {
        System.out.println("s: loading saved game file '" + file + "'");
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.game = (IGame)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to load file: " + file);
            exception.printStackTrace();
            return false;
        }
        this.setGame(this.game);
        return true;
    }

    public Player getPlayer(int n) {
        return this.game.getPlayer(n);
    }

    private void removeAllEntitesOwnedBy(Player player) {
        Entity entity;
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().equals(player)) continue;
            vector.addElement(entity);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            int n = entity.getId();
            this.game.removeEntity(n, 2048);
            this.send(this.createRemoveEntityPacket(n, 2048));
        }
    }

    private Connection getClient(int n) {
        return this.getConnection(n);
    }

    public Enumeration getConnections() {
        return this.connections.elements();
    }

    public Connection getConnection(int n) {
        return (Connection)this.connectionIds.get(new Integer(n));
    }

    private Connection getPendingConnection(int n) {
        Enumeration enumeration = this.connectionsPending.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            if (connection.getId() != n) continue;
            return connection;
        }
        return null;
    }

    private void resetEntityRound() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            entity.newRound(this.game.getRoundCount());
        }
    }

    private void resetEntityPhase(int n) {
        int n2;
        Entity entity;
        Vector<Entity> vector = new Vector<Entity>(0, 10);
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            if (entity.crew.isDoomed()) {
                entity.crew.setDead(true);
                entity.setDestroyed(true);
            }
            if (entity.isDoomed()) {
                entity.setDestroyed(true);
                n2 = entity.getSwarmTargetId();
                if (-1 != n2) {
                    Entity entity2 = this.game.getEntity(n2);
                    entity2.setSwarmAttackerId(-1);
                    entity.setSwarmTargetId(-1);
                    Report report = new Report(5165);
                    report.subject = n2;
                    report.addDesc(entity2);
                    this.vPhaseReport.addElement(report);
                    this.entityUpdate(n2);
                }
            }
            if (!entity.isDestroyed() && !entity.getCrew().isDead()) continue;
            vector.addElement(entity);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            n2 = 512;
            if (!entity.isSalvage()) {
                n2 = 1024;
            }
            this.entityUpdate(entity.getId());
            this.game.removeEntity(entity.getId(), n2);
            this.send(this.createRemoveEntityPacket(entity.getId(), n2));
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            entity.applyDamage();
            entity.reloadEmptyWeapons();
            entity.damageThisPhase = 0;
            entity.engineHitsThisRound = 0;
            entity.rolledForEngineExplosion = false;
            entity.dodging = false;
            if (n == 4) {
                entity.setDone(!entity.shouldDeploy(this.game.getRoundCount()));
            } else {
                entity.setDone(false);
            }
            entity.setIlluminated(false);
            entity.setUsedSearchlight(false);
        }
    }

    private void resetPlayersDone() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            player.setDone(false);
        }
    }

    private void resetActivePlayersDone() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player;
            player.setDone(this.game.getEntitiesOwnedBy(player = (Player)enumeration.nextElement()) <= 0);
        }
        this.transmitAllPlayerDones();
    }

    private void prepareVictoryReport() {
        Object object;
        Enumeration enumeration;
        Object object2;
        Object object3;
        Object object4;
        this.vPhaseReport.addElement(new Report(7000, 0));
        Report report = new Report();
        report.type = 0;
        if (this.game.getVictoryTeam() == 0) {
            object4 = this.getPlayer(this.game.getVictoryPlayerId());
            if (null == object4) {
                report.messageId = 7005;
            } else {
                report.messageId = 7010;
                report.add(((Player)object4).getName());
            }
        } else {
            report.messageId = 7015;
            report.add(this.game.getVictoryTeam());
        }
        this.vPhaseReport.addElement(report);
        object4 = this.game.getEntities();
        if (object4.hasMoreElements()) {
            this.vPhaseReport.addElement(new Report(7020, 0));
            while (object4.hasMoreElements()) {
                object3 = (Entity)object4.nextElement();
                if (!((Entity)object3).isDeployed()) continue;
                Server.combineVectors(this.vPhaseReport, ((Entity)object3).victoryReport());
            }
        }
        if ((object3 = this.game.getEntities()).hasMoreElements()) {
            boolean bl = false;
            while (object3.hasMoreElements()) {
                object2 = (Entity)object3.nextElement();
                if (((Entity)object2).isDeployed()) continue;
                if (!bl) {
                    this.vPhaseReport.addElement(new Report(7075, 0));
                    bl = true;
                }
                Server.combineVectors(this.vPhaseReport, ((Entity)object2).victoryReport());
            }
        }
        if ((enumeration = this.game.getRetreatedEntities()).hasMoreElements()) {
            this.vPhaseReport.addElement(new Report(7080, 0));
            while (enumeration.hasMoreElements()) {
                object2 = (Entity)enumeration.nextElement();
                Server.combineVectors(this.vPhaseReport, ((Entity)object2).victoryReport());
            }
        }
        if ((object2 = this.game.getGraveyardEntities()).hasMoreElements()) {
            this.vPhaseReport.addElement(new Report(7085, 0));
            while (object2.hasMoreElements()) {
                object = (Entity)object2.nextElement();
                Server.combineVectors(this.vPhaseReport, ((Entity)object).victoryReport());
            }
        }
        if ((object = this.game.getDevastatedEntities()).hasMoreElements()) {
            this.vPhaseReport.addElement(new Report(7090, 0));
            while (object.hasMoreElements()) {
                Entity entity = (Entity)object.nextElement();
                Server.combineVectors(this.vPhaseReport, entity.victoryReport());
            }
        }
        this.vPhaseReport.addElement(new Report(7095, 0));
    }

    private String getDetailedVictoryReport() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getRetreatedEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getGraveyardEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Entity entity;
            Player player = (Player)enumeration.nextElement();
            stringBuffer.append("++++++++++ ").append(player.getName()).append(" ++++++++++");
            stringBuffer.append("\r\n");
            for (int i = 0; i < vector.size(); ++i) {
                entity = (Entity)vector.elementAt(i);
                if (entity.getOwner() != player) continue;
                stringBuffer.append(UnitStatusFormatter.format(entity));
            }
            Enumeration enumeration2 = this.game.getDevastatedEntities();
            if (!enumeration2.hasMoreElements()) continue;
            stringBuffer.append("=============================================================");
            stringBuffer.append("\r\n");
            stringBuffer.append("The following utterly destroyed units are not available for salvage:");
            stringBuffer.append("\r\n");
            while (enumeration2.hasMoreElements()) {
                entity = (Entity)enumeration2.nextElement();
                if (entity.getOwner() != player) continue;
                stringBuffer.append(entity.getShortName()).append(", Pilot: ").append(entity.getCrew().getName()).append(" (").append(entity.getCrew().getGunnery()).append("/").append(entity.getCrew().getPiloting()).append(")");
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("=============================================================");
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public void forceVictory(Player player) {
        this.game.setForceVictory(true);
        if (player.getTeam() == 0) {
            this.game.setVictoryPlayerId(player.getId());
            this.game.setVictoryTeam(0);
        } else {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(player.getTeam());
        }
        Vector vector = this.game.getPlayersVector();
        for (int i = 0; i < vector.size(); ++i) {
            Player player2 = (Player)vector.elementAt(i);
            player2.setAdmitsDefeat(false);
        }
    }

    public void cancelVictory() {
        this.game.setForceVictory(false);
        this.game.setVictoryPlayerId(-1);
        this.game.setVictoryTeam(0);
    }

    private void checkReady() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player.isGhost() || player.isObserver() || player.isDone()) continue;
            return;
        }
        if (this.game.getNoOfInitiativeRerollRequests() > 0) {
            this.resetActivePlayersDone();
            this.game.rollInitAndResolveTies();
            this.determineTurnOrder(5);
            this.vPhaseReport.removeAllElements();
            this.writeInitiativeReport(true);
            this.sendReport(true);
            return;
        }
        if (!(this.game.phaseHasTurns(this.game.getPhase()) || this.game.getPhase() == 1 && this.game.getNoOfEntities() <= 0)) {
            this.endCurrentPhase();
        }
    }

    private void endCurrentTurn(Entity entity) {
        boolean bl;
        boolean bl2 = false;
        GameTurn gameTurn = this.game.getTurn();
        final int n = null == entity ? -1 : entity.getOwnerId();
        boolean bl3 = entity instanceof Infantry;
        boolean bl4 = this.game.getOptions().booleanOption("inf_move_multi") && (this.game.getPhase() == 8 || this.game.getPhase() == 5);
        boolean bl5 = entity instanceof Protomech;
        boolean bl6 = this.game.getOptions().booleanOption("protos_move_multi");
        int n2 = 0;
        if (bl4) {
            ++n2;
        }
        if (bl6) {
            n2 += 2;
        } else if (bl5 && this.game.getPhase() == 12) {
            n2 = 0;
        }
        boolean bl7 = bl = !(gameTurn instanceof GameTurn.SpecificEntityTurn) && !(gameTurn instanceof GameTurn.UnitNumberTurn) && !(gameTurn instanceof GameTurn.UnloadStrandedTurn) && (!(gameTurn instanceof GameTurn.EntityClassTurn) || gameTurn instanceof GameTurn.EntityClassTurn && ((GameTurn.EntityClassTurn)gameTurn).isValidClass(~n2));
        if (bl5 && !bl6 && bl && this.game.getPhase() == 12) {
            final char c = entity.getUnitNumber();
            final int n3 = entity.getId();
            int n4 = this.game.getSelectedEntityCount(new EntitySelector(){
                private final int ownerId;
                private final int entityId;
                private final char unitNum;
                {
                    this.ownerId = n;
                    this.entityId = n3;
                    this.unitNum = c;
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && entity.isSelectableThisTurn() && this.ownerId == entity.getOwnerId() && this.entityId != entity.getId() && this.unitNum == entity.getUnitNumber();
                }
            });
            for (int i = 0; i < n4; ++i) {
                GameTurn.UnitNumberTurn unitNumberTurn = new GameTurn.UnitNumberTurn(n, c);
                this.game.insertNextTurn(unitNumberTurn);
                bl2 = true;
            }
        } else if ((bl3 && bl4 || bl5 && bl6) && bl) {
            int n5 = 0;
            if (bl4) {
                n5 += this.game.getInfantryLeft(n);
            }
            if (bl6) {
                n5 += this.game.getProtomechsLeft(n);
            }
            int n6 = Math.min(this.game.getOptions().intOption("inf_proto_move_multi") - 1, n5);
            for (int i = 0; i < n6; ++i) {
                GameTurn.EntityClassTurn entityClassTurn = new GameTurn.EntityClassTurn(n, n2);
                this.game.insertNextTurn(entityClassTurn);
                bl2 = true;
            }
        }
        if (bl2) {
            this.send(this.createTurnVectorPacket());
        }
        this.changeToNextTurn();
    }

    private void changePhase(int n) {
        this.game.setLastPhase(this.game.getPhase());
        this.game.setPhase(n);
        this.prepareForPhase(n);
        if (this.isPhasePlayable(n)) {
            this.send(new Packet(240, new Integer(n)));
            this.executePhase(n);
        } else {
            this.endCurrentPhase();
        }
    }

    private void prepareForPhase(int n) {
        switch (n) {
            case 1: {
                this.vPhaseReport.removeAllElements();
                this.mapSettings.setBoardsAvailableVector(this.scanForBoards(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight()));
                this.mapSettings.setNullBoards(DEFAULT_BOARD);
                this.send(this.createMapSettingsPacket());
                break;
            }
            case 5: {
                this.game.resetActions();
                this.game.resetTagInfo();
                this.vPhaseReport.removeAllElements();
                this.resetEntityRound();
                this.resetEntityPhase(n);
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.rollInitiative();
                if (!this.game.shouldDeployThisRound()) {
                    this.incrementAndSendGameRound();
                }
                this.determineTurnOrder(n);
                this.writeInitiativeReport(false);
                System.out.println("Round " + this.game.getRoundCount() + " memory usage: " + MegaMek.getMemoryUsed());
                break;
            }
            case 20: {
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.setIneligible(n);
                Enumeration enumeration = this.game.getPlayers();
                Vector<GameTurn> vector = new Vector<GameTurn>();
                while (enumeration.hasMoreElements()) {
                    Player player = (Player)enumeration.nextElement();
                    if (!player.hasMinefields()) continue;
                    GameTurn gameTurn = new GameTurn(player.getId());
                    vector.addElement(gameTurn);
                }
                this.game.setTurnVector(vector);
                this.game.resetTurnIndex();
                this.send(this.createTurnVectorPacket());
                break;
            }
            case 22: {
                Serializable serializable;
                Enumeration enumeration = this.game.getEntities();
                while (enumeration.hasMoreElements()) {
                    serializable = (Entity)enumeration.nextElement();
                    ((Entity)serializable).deployOffBoard();
                }
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.setIneligible(n);
                enumeration = this.game.getPlayers();
                serializable = new Vector();
                while (enumeration.hasMoreElements()) {
                    final Player player = (Player)enumeration.nextElement();
                    EntitySelector entitySelector = new EntitySelector(){
                        private Player owner;
                        {
                            this.owner = player;
                        }

                        public boolean accept(Entity entity) {
                            return this.owner.equals(entity.getOwner()) && entity.isEligibleForTargetingPhase();
                        }
                    };
                    if (!this.game.getSelectedEntities(entitySelector).hasMoreElements()) continue;
                    GameTurn gameTurn = new GameTurn(player.getId());
                    ((Vector)serializable).addElement(gameTurn);
                }
                this.game.setTurnVector((Vector)serializable);
                this.game.resetTurnIndex();
                this.send(this.createTurnVectorPacket());
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                this.resetEntityPhase(n);
                this.checkForObservers();
                this.setIneligible(n);
                this.determineTurnOrder(n);
                this.resetActivePlayersDone();
                this.entityAllUpdate();
                this.vPhaseReport.removeAllElements();
                this.doTryUnstuck();
                break;
            }
            case 16: {
                this.resetEntityPhase(n);
                this.vPhaseReport.removeAllElements();
                this.resolveHeat();
                this.vPhaseReport.addElement(new Report(5005, 0));
                this.checkForSuffocation();
                if (this.game.getOptions().booleanOption("vacuum")) {
                    this.checkForVacuumDeath();
                }
                Enumeration<DynamicTerrainProcessor> enumeration = this.terrainProcessors.elements();
                while (enumeration.hasMoreElements()) {
                    DynamicTerrainProcessor dynamicTerrainProcessor = enumeration.nextElement();
                    dynamicTerrainProcessor.DoEndPhaseChanges(this.vPhaseReport);
                }
                Server.combineVectors(this.vPhaseReport, this.game.ageFlares());
                this.send(this.createFlarePacket());
                this.resolveExtremeTempInfantryDeath();
                this.resolveAmmoDumps();
                this.resolveCrewDamage();
                this.resolveCrewWakeUp();
                this.resolveMechWarriorPickUp();
                this.resolveVeeINarcPodRemoval();
                this.checkForObservers();
                this.entityAllUpdate();
                break;
            }
            case 6: {
                this.autoSave();
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                this.resetActivePlayersDone();
                this.sendReport();
                if (!this.game.getOptions().booleanOption("paranoid_autosave")) break;
                this.autoSave();
                break;
            }
            case 18: {
                this.resetPlayersDone();
                this.vPhaseReport.removeAllElements();
                this.prepareVictoryReport();
                this.game.addReports(this.vPhaseReport);
                this.send(this.createFullEntitiesPacket());
                this.send(this.createReportPacket(null));
                this.send(this.createEndOfGamePacket());
            }
        }
    }

    private boolean isPhasePlayable(int n) {
        switch (n) {
            case 5: 
            case 16: {
                return false;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 22: {
                return this.game.hasMoreTurns();
            }
        }
        return true;
    }

    private void executePhase(int n) {
        switch (n) {
            case 3: {
                this.resetPlayersDone();
                this.game.setupTeams();
                this.applyBoardSettings();
                this.game.setupRoundDeployment();
                this.game.determineWind();
                if (this.game.checkForMagneticClamp()) {
                    this.entityAllUpdate();
                }
                this.send(this.createBoardPacket());
                break;
            }
            case 8: {
                this.vPhaseReport.addElement(new Report(2000, 0));
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 22: {
                this.changeToNextTurn();
                if (!this.game.getOptions().booleanOption("paranoid_autosave")) break;
                this.autoSave();
            }
        }
    }

    private void endCurrentPhase() {
        switch (this.game.getPhase()) {
            case 1: {
                this.changePhase(3);
                break;
            }
            case 3: {
                this.changePhase(22);
                break;
            }
            case 21: {
                this.changePhase(22);
                break;
            }
            case 22: {
                Enumeration enumeration = this.game.getPlayers();
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    Player player = (Player)enumeration.nextElement();
                    if (!player.hasMinefields()) continue;
                    bl = true;
                }
                if (bl) {
                    this.changePhase(20);
                    break;
                }
                this.changePhase(5);
                break;
            }
            case 20: {
                this.changePhase(5);
                break;
            }
            case 4: {
                this.game.clearDeploymentThisRound();
                this.game.checkForCompleteDeployment();
                this.changePhase(5);
                break;
            }
            case 5: {
                this.game.addReports(this.vPhaseReport);
                this.changePhase(6);
                break;
            }
            case 6: {
                if (this.game.shouldDeployThisRound()) {
                    this.changePhase(4);
                    break;
                }
                this.changePhase(7);
                break;
            }
            case 8: {
                this.doAllAssaultDrops();
                this.addMovementHeat();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                this.checkForFlamingDeath();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(9);
                    break;
                }
                this.vPhaseReport.addElement(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(10);
                break;
            }
            case 9: {
                this.changePhase(10);
                break;
            }
            case 12: {
                this.resolveAllButWeaponAttacks();
                this.assignAMS();
                this.resolveOnlyWeaponAttacks();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(13);
                    break;
                }
                this.vPhaseReport.addElement(new Report(1205, 0));
                this.sendReport();
                this.game.addReports(this.vPhaseReport);
                this.changePhase(14);
                break;
            }
            case 13: {
                this.changePhase(14);
                break;
            }
            case 14: {
                this.resolvePhysicalAttacks();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                this.resolveSinkVees();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(15);
                    break;
                }
                this.vPhaseReport.addElement(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(16);
                break;
            }
            case 15: {
                this.changePhase(16);
                break;
            }
            case 7: {
                this.enqueueIndirectArtilleryAttacks();
                this.changePhase(8);
                break;
            }
            case 10: {
                this.vPhaseReport.addElement(new Report(1100, 0));
                this.resolveAllButWeaponAttacks();
                this.resolveOnlyWeaponAttacks();
                this.resolveIndirectArtilleryAttacks();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(11);
                    break;
                }
                this.vPhaseReport.addElement(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(12);
                break;
            }
            case 11: {
                this.changePhase(12);
                break;
            }
            case 16: {
                if (this.vPhaseReport.size() > 3 || ((Report)this.vPhaseReport.elementAt((int)1)).messageId != 1205) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(17);
                    break;
                }
                this.vPhaseReport.addElement(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                if (this.victory()) {
                    this.changePhase(18);
                    break;
                }
                this.changePhase(5);
                break;
            }
            case 17: {
                if (this.victory()) {
                    this.changePhase(18);
                    break;
                }
                this.changePhase(5);
                break;
            }
            case 18: {
                this.resetGame();
            }
        }
    }

    private static void combineVectors(Vector vector, Vector vector2) {
        if (vector2 == null || vector2.size() == 0) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            vector.addElement(vector2.elementAt(i));
        }
    }

    private void incrementAndSendGameRound() {
        this.game.incrementRoundCount();
        this.send(new Packet(260, new Integer(this.game.getRoundCount())));
    }

    private void changeToNextTurn() {
        if (!this.game.hasMoreTurns()) {
            this.endCurrentPhase();
            return;
        }
        GameTurn gameTurn = this.game.changeToNextTurn();
        this.send(this.createTurnIndexPacket());
        Player player = this.getPlayer(gameTurn.getPlayerNum());
        if (null != player && player.isGhost()) {
            this.sendGhostSkipMessage(player);
        } else if (null == this.game.getFirstEntity() && null != player && this.game.getPhase() != 20 && this.game.getPhase() != 22) {
            this.sendTurnErrorSkipMessage(player);
        }
    }

    private void sendGhostSkipMessage(Player player) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Player '").append(player.getName()).append("' is disconnected.  You may skip his/her current turn with the /skip command.");
        this.sendServerChat(stringBuffer.toString());
    }

    private void sendTurnErrorSkipMessage(Player player) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Player '").append(player.getName()).append("' has no units to move.  You should skip his/her/your current turn with the /skip command. You may want to report this error.  See the MegaMek homepage (http://megamek.sf.net/) for details.");
        this.sendServerChat(stringBuffer.toString());
    }

    public void skipCurrentTurn() {
        Entity entity = this.game.getFirstEntity();
        switch (this.game.getPhase()) {
            case 4: {
                this.sendServerChat("Turns cannot be skipped in the deployment phase.");
                break;
            }
            case 8: {
                if (entity != null) {
                    this.processMovement(entity, new MovePath(this.game, entity));
                }
                this.endCurrentTurn(entity);
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                if (entity != null) {
                    this.processAttack(entity, new Vector(0));
                }
                this.endCurrentTurn(entity);
                break;
            }
        }
    }

    public boolean isTurnSkippable() {
        GameTurn gameTurn = this.game.getTurn();
        if (null == gameTurn) {
            return false;
        }
        Player player = this.getPlayer(gameTurn.getPlayerNum());
        return null == player || player.isGhost() || this.game.getFirstEntity() == null;
    }

    public boolean victory() {
        Object object;
        int n;
        int n2;
        int n3;
        if (this.game.isForceVictory()) {
            n3 = this.game.getVictoryPlayerId();
            int n4 = this.game.getVictoryTeam();
            Vector vector = this.game.getPlayersVector();
            n2 = 1;
            if (n3 != -1) {
                for (n = 0; n < vector.size(); ++n) {
                    object = (Player)vector.elementAt(n);
                    if (((Player)object).getId() == n3 || ((Player)object).isObserver() || ((Player)object).admitsDefeat()) continue;
                    n2 = 0;
                    break;
                }
            }
            if (n4 != 0) {
                for (n = 0; n < vector.size(); ++n) {
                    object = (Player)vector.elementAt(n);
                    if (((Player)object).getTeam() == n4 || ((Player)object).isObserver() || ((Player)object).admitsDefeat()) continue;
                    n2 = 0;
                    break;
                }
            }
            for (n = 0; n < vector.size(); ++n) {
                object = (Player)vector.elementAt(n);
                ((Player)object).setAdmitsDefeat(false);
            }
            if (n2 != 0) {
                return true;
            }
            this.cancelVictory();
        }
        if (!this.game.getOptions().booleanOption("check_victory")) {
            return false;
        }
        n3 = 0;
        Player player = null;
        boolean bl = false;
        n2 = 0;
        n = 0;
        object = this.game.getPlayers();
        while (object.hasMoreElements()) {
            Player player2 = (Player)object.nextElement();
            int n5 = player2.getTeam();
            if (this.game.getLiveDeployedEntitiesOwnedBy(player2) <= 0) continue;
            ++n3;
            player = player2;
            if (n5 == 0) {
                n = 1;
                continue;
            }
            if (n2 == 0) {
                bl = true;
                n2 = n5;
                continue;
            }
            if (n5 == n2) continue;
            bl = false;
            n2 = n5;
        }
        if (n3 < 1) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(0);
            return true;
        }
        if (n3 == 1 && player.getTeam() == 0) {
            this.game.setVictoryPlayerId(player.getId());
            this.game.setVictoryTeam(0);
            return true;
        }
        if (bl && n == 0) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(n2);
            return true;
        }
        return false;
    }

    public void applyBoardSettings() {
        this.mapSettings.replaceBoardWithRandom("[RANDOM]");
        this.mapSettings.replaceBoardWithRandom(DEFAULT_BOARD);
        IBoard[] iBoardArray = new IBoard[this.mapSettings.getMapWidth() * this.mapSettings.getMapHeight()];
        for (int i = 0; i < this.mapSettings.getMapWidth() * this.mapSettings.getMapHeight(); ++i) {
            iBoardArray[i] = new Board();
            String string = (String)this.mapSettings.getBoardsSelectedVector().elementAt(i);
            boolean bl = false;
            if (string.startsWith("rotate:")) {
                bl = true;
                string = string.substring("rotate:".length());
            }
            if (string.startsWith("[GENERATED]")) {
                iBoardArray[i] = BoardUtilities.generateRandom(this.mapSettings);
                continue;
            }
            iBoardArray[i].load(string + ".board");
            BoardUtilities.flip(iBoardArray[i], bl, bl);
        }
        IBoard iBoard = BoardUtilities.combine(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight(), this.mapSettings.getMapWidth(), this.mapSettings.getMapHeight(), iBoardArray);
        this.game.setBoard(iBoard);
    }

    private void rollInitiative() {
        TurnOrdered.rollInitiative(this.game.getTeamsVector());
        this.transmitAllPlayerUpdates();
    }

    private void determineTurnOrder(int n) {
        Object object;
        Object object2;
        int n2;
        Serializable serializable;
        boolean bl = this.game.getOptions().booleanOption("inf_move_even") && (this.game.getPhase() == 5 || this.game.getPhase() == 8) || this.game.getOptions().booleanOption("inf_deploy_even") && this.game.getPhase() == 4;
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_multi") && (this.game.getPhase() == 5 || this.game.getPhase() == 8);
        boolean bl3 = this.game.getOptions().booleanOption("protos_move_even") && (this.game.getPhase() == 5 || this.game.getPhase() == 8) || this.game.getOptions().booleanOption("protos_deploy_even") && this.game.getPhase() == 4;
        boolean bl4 = this.game.getOptions().booleanOption("protos_move_multi");
        boolean bl5 = !bl4 && this.game.getPhase() == 12;
        int n3 = 0;
        if (bl) {
            ++n3;
        }
        if (bl3) {
            n3 += 2;
        }
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            serializable = (Player)enumeration.nextElement();
            ((TurnOrdered)serializable).resetEvenTurns();
            ((TurnOrdered)serializable).resetMultiTurns();
            ((TurnOrdered)serializable).resetOtherTurns();
            if (!bl5) continue;
            int n4 = this.game.getSelectedEntityCount(new EntitySelector((Player)serializable){
                private final int ownerId;
                final /* synthetic */ Player val$player;
                {
                    this.val$player = player;
                    this.ownerId = this.val$player.getId();
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && this.ownerId == entity.getOwnerId();
                }
            });
            n2 = (int)Math.ceil((double)n4 / 5.0);
            for (int i = 0; i < n2; ++i) {
                if (bl3) {
                    ((TurnOrdered)serializable).incrementEvenTurns();
                    continue;
                }
                ((TurnOrdered)serializable).incrementOtherTurns();
            }
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            if (!((Entity)serializable).isSelectableThisTurn()) continue;
            Player player = ((Entity)serializable).getOwner();
            if (serializable instanceof Infantry) {
                if (bl) {
                    player.incrementEvenTurns();
                    continue;
                }
                if (bl2) {
                    player.incrementMultiTurns();
                    continue;
                }
                player.incrementOtherTurns();
                continue;
            }
            if (serializable instanceof Protomech) {
                if (bl5) continue;
                if (bl3) {
                    player.incrementEvenTurns();
                    continue;
                }
                if (bl4) {
                    player.incrementMultiTurns();
                    continue;
                }
                player.incrementOtherTurns();
                continue;
            }
            player.incrementOtherTurns();
        }
        int n5 = this.game.getNoOfTeams();
        serializable = new Hashtable(n5);
        Hashtable<Object, int[]> hashtable = new Hashtable<Object, int[]>(n5);
        n2 = 0;
        Enumeration enumeration2 = this.game.getTeams();
        while (enumeration2.hasMoreElements()) {
            object2 = (Team)enumeration2.nextElement();
            ((Hashtable)serializable).put(object2, ((Team)object2).determineTeamOrder(this.game));
            object = new int[]{0, 0};
            hashtable.put(object2, (int[])object);
            if (((Team)object2).getNormalTurns(this.game) <= 0) continue;
            ++n2;
        }
        enumeration2 = TurnOrdered.generateTurnOrder(this.game.getTeamsVector(), this.game);
        object2 = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return Server.this.game.isEntityStranded(entity);
            }
        });
        if (object2.hasMoreElements() && this.game.getPhase() == 8) {
            object = new Vector(((TurnVectors)enumeration2).getNormalTurns() + ((TurnVectors)enumeration2).getEvenTurns() + 1);
            object.addElement(new GameTurn.UnloadStrandedTurn((Enumeration)object2));
        } else {
            object = new Vector(((TurnVectors)enumeration2).getNormalTurns() + ((TurnVectors)enumeration2).getEvenTurns());
        }
        Team team = null;
        int n6 = ((TurnVectors)enumeration2).getMin();
        int n7 = 0;
        while (((TurnVectors)enumeration2).hasMoreElements()) {
            Player player;
            Team team2 = (Team)((TurnVectors)enumeration2).nextElement();
            TurnVectors turnVectors = (TurnVectors)((Hashtable)serializable).get(team2);
            int[] nArray = (int[])hashtable.get(team2);
            float f = team2.getEvenTurns();
            int n8 = 0;
            if (1 == n2) {
                n8 = (int)((float)n8 + f);
            } else if (team == null) {
                nArray[0] = nArray[0] + 1;
                n8 = (int)((float)n8 + f / (float)n6);
            } else if (!team2.equals(team)) {
                nArray[0] = nArray[0] + 1;
                n8 = (int)((double)n8 + (Math.ceil((double)((float)nArray[0] * (f % (float)n6) / (float)n6) - 0.5) - (double)nArray[1]));
                nArray[1] = nArray[1] + n8;
                n8 = (int)((float)n8 + f / (float)n6);
            }
            team = team2;
            if (turnVectors.hasMoreElements()) {
                player = (Player)turnVectors.nextElement();
                GameTurn gameTurn = null;
                gameTurn = n7 >= ((TurnVectors)enumeration2).getNormalTurns() ? new GameTurn.EntityClassTurn(player.getId(), n3) : (bl || bl3 ? new GameTurn.EntityClassTurn(player.getId(), ~n3) : new GameTurn(player.getId()));
                object.addElement(gameTurn);
            }
            while (n8 > 0 && turnVectors.hasMoreEvenElements()) {
                player = (Player)turnVectors.nextEvenElement();
                object.addElement(new GameTurn.EntityClassTurn(player.getId(), n3));
                --n8;
            }
            ++n7;
        }
        this.game.setTurnVector((Vector)object);
        this.game.resetTurnIndex();
        this.send(this.createTurnVectorPacket());
    }

    private void writeInitiativeReport(boolean bl) {
        Serializable serializable;
        Object object;
        Report report;
        boolean bl2 = false;
        if (!bl) {
            report = new Report();
            report.type = 0;
            if (this.game.getLastPhase() == 4 || this.game.isDeploymentComplete() || !this.game.shouldDeployThisRound()) {
                report.messageId = 1000;
                report.add(this.game.getRoundCount());
            } else {
                bl2 = true;
                if (this.game.getRoundCount() == 0) {
                    report.messageId = 1005;
                } else {
                    report.messageId = 1010;
                    report.add(this.game.getRoundCount());
                }
            }
            this.vPhaseReport.addElement(report);
            this.vPhaseReport.addElement(new Report(1200, 0));
        } else {
            this.vPhaseReport.addElement(new Report(1210, 0));
        }
        Enumeration enumeration = this.game.getTeams();
        while (enumeration.hasMoreElements()) {
            Team team = (Team)enumeration.nextElement();
            if (team.getSize() == 1) {
                object = (Player)team.getPlayers().nextElement();
                report = new Report(1015, 0);
                report.add(((Player)object).getName());
                report.add(team.getInitiative().toString());
                this.vPhaseReport.addElement(report);
                continue;
            }
            report = new Report(1015, 0);
            report.add(Player.teamNames[team.getId()]);
            report.add(team.getInitiative().toString());
            this.vPhaseReport.addElement(report);
            object = team.getPlayers();
            while (object.hasMoreElements()) {
                serializable = (Player)object.nextElement();
                report = new Report(1015, 0);
                report.indent();
                report.add(((Player)serializable).getName());
                report.add(((TurnOrdered)serializable).getInitiative().toString());
                this.vPhaseReport.addElement(report);
            }
        }
        report = new Report(1020, 0);
        boolean bl3 = true;
        boolean bl4 = false;
        object = this.game.getTurns();
        while (object.hasMoreElements()) {
            serializable = (GameTurn)object.nextElement();
            Player player = this.getPlayer(((GameTurn)serializable).getPlayerNum());
            if (null == player) continue;
            report.add(player.getName());
            bl3 = false;
            if (player.getEvenTurns() <= 0) continue;
            bl4 = true;
        }
        report.newlines = 2;
        this.vPhaseReport.addElement(report);
        if (bl4) {
            report = new Report(1021, 0);
            if (this.game.getOptions().booleanOption("inf_deploy_even") || this.game.getOptions().booleanOption("protos_deploy_even")) {
                report.choose(true);
            } else {
                report.choose(false);
            }
            report.indent();
            report.newlines = 2;
            this.vPhaseReport.addElement(report);
        }
        if (!bl) {
            report = new Report(1025, 0);
            report.add(this.game.getStringWindDirection());
            if (this.game.getWindStrength() != -1) {
                object = new Report(1030, 0);
                ((Report)object).add(this.game.getStringWindStrength());
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
                this.vPhaseReport.addElement(object);
            } else {
                this.vPhaseReport.addElement(report);
            }
            if (bl2) {
                Report.addNewline(this.vPhaseReport);
            }
        }
    }

    private void setIneligible(int n) {
        Vector<Entity> vector = new Vector<Entity>();
        boolean bl = false;
        Entity entity = null;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            if (!entity.isEligibleFor(n)) {
                vector.addElement(entity);
                continue;
            }
            bl = true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            entity = (Entity)vector.elementAt(i);
            if (bl && entity.canAssist(n)) continue;
            entity.setDone(true);
        }
    }

    private void loadUnit(Entity entity, Entity entity2) {
        this.game.removeTurnFor(entity2);
        this.send(this.createTurnVectorPacket());
        entity.load(entity2);
        entity2.setTransportId(entity.getId());
        entity2.setPosition(null);
        this.entityUpdate(entity2.getId());
    }

    private boolean unloadUnit(Entity entity, Targetable targetable, Coords coords, int n, int n2) {
        Entity entity2 = null;
        if (!(targetable instanceof Entity)) {
            return false;
        }
        entity2 = (Entity)targetable;
        if (!entity.unload(entity2)) {
            return false;
        }
        entity2.setTransportId(-1);
        entity2.setPosition(coords);
        if (coords != null) {
            entity2.setDeployed(true);
        }
        entity2.setFacing(n);
        entity2.setSecondaryFacing(n);
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl = iHex.containsTerrain(5);
        if (entity.getMovementMode() == 6) {
            if (entity2.getMovementMode() == 6) {
                entity2.setElevation(n2);
            } else if (this.game.getBoard().getBuildingAt(coords) != null) {
                entity2.setElevation(iHex.terrainLevel(12));
            }
        } else if (this.game.getBoard().getBuildingAt(coords) != null) {
            entity2.setElevation(n2);
        } else if (iHex.terrainLevel(4) > 0) {
            if (entity2.getMovementMode() == 5 || entity2.getMovementMode() == 8 || entity2.getMovementMode() == 7 || entity2.getMovementMode() == 9 || iHex.containsTerrain(20) || bl) {
                entity2.setElevation(0);
            }
        } else {
            entity2.setElevation(iHex.floor() - iHex.surface());
        }
        this.doSetLocationsExposure(entity2, iHex, false, entity2.getElevation());
        this.entityUpdate(entity2.getId());
        return true;
    }

    private void addAffectedBldg(Building building, boolean bl) {
        if (bl) {
            System.err.print("Removing building from a list of " + this.affectedBldgs.size() + "\n");
            this.affectedBldgs.remove(building);
            System.err.print("... now list of " + this.affectedBldgs.size() + "\n");
        } else {
            this.affectedBldgs.put(building, Boolean.FALSE);
        }
    }

    private void applyAffectedBldgs() {
        Vector<Building> vector = new Vector<Building>();
        boolean bl = false;
        Enumeration enumeration = this.affectedBldgs.keys();
        while (enumeration.hasMoreElements()) {
            Building building = (Building)enumeration.nextElement();
            Enumeration enumeration2 = building.getCoords();
            while (enumeration2.hasMoreElements()) {
                Coords coords = (Coords)enumeration2.nextElement();
                Enumeration enumeration3 = this.game.getEntities(coords);
                while (enumeration3.hasMoreElements()) {
                    Entity entity = (Entity)enumeration3.nextElement();
                    if (!(entity instanceof Infantry)) continue;
                    if (entity.isDoomed() || entity.isDestroyed()) {
                        if (!entity.isDone()) {
                            this.game.removeTurnFor(entity);
                            bl = true;
                        }
                        entity.setDestroyed(true);
                        this.game.moveToGraveyard(entity.getId());
                        this.send(this.createRemoveEntityPacket(entity.getId()));
                        continue;
                    }
                    this.entityUpdate(entity.getId());
                }
            }
            vector.addElement(building);
        }
        if (bl) {
            this.send(this.createTurnVectorPacket());
        }
        if (!vector.isEmpty()) {
            this.sendChangedCFBuildings(vector);
            this.affectedBldgs.clear();
        }
    }

    private void receiveMovement(Packet packet, int n) {
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        MovePath movePath = (MovePath)packet.getObject(1);
        if (this.game.getPhase() != 8) {
            System.err.println("error: server got movement packet in wrong phase");
            return;
        }
        if (!this.game.getTurn().isValid(n, entity, this.game)) {
            System.err.println("error: server got invalid movement packet");
            return;
        }
        this.processMovement(entity, movePath);
        this.applyAffectedBldgs();
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private void processMovement(Entity entity, MovePath movePath) {
        Report report;
        Object object;
        PilotingRollData pilotingRollData;
        Serializable serializable;
        Serializable serializable2;
        boolean bl2 = false;
        if (movePath.contains(10)) {
            Entity entity2;
            Serializable serializable3;
            Enumeration enumeration;
            Report report2 = new Report(2005, 0);
            report2.addDesc(entity);
            this.vPhaseReport.addElement(report2);
            Vector vector = entity.getLoadedUnits();
            if (!vector.isEmpty()) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    serializable3 = (Entity)enumeration.nextElement();
                    report2 = new Report(2010, 0);
                    report2.indent();
                    report2.addDesc((Entity)serializable3);
                    this.vPhaseReport.addElement(report2);
                    this.game.removeEntity(((Entity)serializable3).getId(), 256);
                    this.send(this.createRemoveEntityPacket(((Entity)serializable3).getId(), 256));
                }
            }
            enumeration = entity.getPickedUpMechWarriors().elements();
            while (enumeration.hasMoreElements()) {
                serializable3 = (Integer)enumeration.nextElement();
                entity2 = this.game.getEntity((Integer)serializable3);
                int n = 256;
                report2 = new Report(2010);
                if (entity2.isCaptured()) {
                    report2 = new Report(2015);
                    n = 288;
                }
                this.game.removeEntity(entity2.getId(), n);
                this.send(this.createRemoveEntityPacket(entity2.getId(), n));
                report2.addDesc(entity2);
                report2.indent();
                this.vPhaseReport.addElement(report2);
            }
            int n = entity.getSwarmAttackerId();
            if (-1 != n) {
                entity2 = this.game.getEntity(n);
                if (!entity2.isDone()) {
                    this.game.removeTurnFor(entity2);
                    this.send(this.createTurnVectorPacket());
                }
                entity2.setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report2 = new Report(2015, 0);
                report2.indent();
                report2.addDesc(entity2);
                this.vPhaseReport.addElement(report2);
                this.game.removeEntity(n, 288);
                this.send(this.createRemoveEntityPacket(n, 288));
            }
            this.game.removeEntity(entity.getId(), 256);
            this.send(this.createRemoveEntityPacket(entity.getId(), 256));
            return;
        }
        if (movePath.contains(18)) {
            if (entity instanceof Mech) {
                Report report3 = new Report(2020);
                report3.subject = entity.getId();
                report3.add(entity.getCrew().getName());
                report3.addDesc(entity);
                this.vPhaseReport.addElement(report3);
            } else if (entity instanceof Tank) {
                Report report4 = new Report(2025);
                report4.subject = entity.getId();
                report4.addDesc(entity);
                this.vPhaseReport.addElement(report4);
            }
            Server.combineVectors(this.vPhaseReport, this.ejectEntity(entity, false));
            return;
        }
        Coords coords = entity.getPosition();
        Coords coords2 = entity.getPosition();
        int n = entity.getFacing();
        int n2 = entity.getElevation();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (entity.mpUsed > 0) {
            n5 = 1;
            n6 = 1;
            if (entity.mpUsed > entity.getWalkMP()) {
                n5 = 2;
                n6 = 2;
            }
        }
        int n7 = n;
        Object object2 = null;
        boolean bl3 = entity instanceof Infantry;
        DisplacementAttackAction displacementAttackAction = null;
        int n8 = 3 == n5 ? entity.getOriginalJumpMP() : entity.getRunMP(false);
        movePath.compile(this.game, entity);
        if (movePath.contains(19)) {
            serializable2 = new ClearMinefieldAction(entity.getId());
            entity.setClearingMinefield(true);
            this.game.addAction((EntityAction)((Object)serializable2));
        }
        if (entity instanceof Mech && ((Mech)entity).checkForMASCFailure(movePath, this.vPhaseReport)) {
            movePath.clear();
        }
        n6 = movePath.getLastStepMovementType();
        if (this.game.getBoard().getHex(entity.getPosition()).terrainLevel(24) == 2 && entity.getElevation() == 0) {
            this.doMagmaDamage(entity, false);
        }
        boolean bl4 = true;
        boolean bl5 = false;
        serializable2 = null;
        Vector<UnitLocation> vector = new Vector<UnitLocation>();
        Object object3 = movePath.getSteps();
        while (object3.hasMoreElements()) {
            Targetable mounted;
            Object object4;
            Object object5;
            serializable = (MoveStep)object3.nextElement();
            boolean bl6 = entity.isProne();
            boolean bl = ((MoveStep)serializable).isPavementStep();
            boolean bl7 = false;
            if (((MoveStep)serializable).getMovementType() == -1) break;
            pilotingRollData = entity.checkGetUp((MoveStep)serializable);
            if (pilotingRollData.getValue() != -2147483647) {
                ++entity.heatBuildup;
                entity.setProne(false);
                entity.setHullDown(false);
                bl6 = false;
                this.game.resetPSRs(entity);
                boolean bl8 = bl7 = !this.doSkillCheckInPlace(entity, pilotingRollData);
            }
            if (bl7) {
                n5 = ((MoveStep)serializable).getMovementType();
                n = entity.getFacing();
                coords2 = entity.getPosition();
                n4 = ((MoveStep)serializable).getMpUsed();
                bl5 = true;
                break;
            }
            if (((MoveStep)serializable).getType() == 15) {
                entity.setUnjammingRAC(true);
                this.game.addAction(new UnjamAction(entity.getId()));
                break;
            }
            if (((MoveStep)serializable).getType() == 23) {
                object = new LayMinefieldAction(entity.getId(), ((MoveStep)serializable).getMineToLay());
                this.game.addLayMinefieldAction((LayMinefieldAction)object);
                entity.setLayingMines(true);
                break;
            }
            if (((MoveStep)serializable).getType() == 22 && entity.hasSpotlight()) {
                boolean bl9 = !entity.isUsingSpotlight();
                entity.setSpotlightState(bl9);
                this.sendServerChat(entity.getDisplayName() + " switched searchlight " + (bl9 ? "on" : "off") + ".");
            }
            n5 = ((MoveStep)serializable).getMovementType();
            n3 = ((MoveStep)serializable).getDistance();
            n4 = ((MoveStep)serializable).getMpUsed();
            if (((MoveStep)serializable).getType() == 8) {
                if (entity.canCharge()) {
                    this.checkExtremeGravityMovement(entity, (MoveStep)serializable, coords2, n8);
                    object = ((MoveStep)serializable).getTarget(this.game);
                    object5 = new ChargeAttackAction(entity.getId(), object.getTargetType(), object.getTargetId(), object.getPosition());
                    entity.setDisplacementAttack((DisplacementAttackAction)object5);
                    this.game.addCharge((AttackAction)object5);
                    displacementAttackAction = object5;
                    break;
                }
                this.sendServerChat("Illegal charge!! I don't think " + entity.getDisplayName() + " should be allowed to charge," + " but the client of " + entity.getOwner().getName() + " disagrees.");
                this.sendServerChat("Please make sure " + entity.getOwner().getName() + " is running MegaMek " + MegaMek.VERSION + ", or if that is already the case, submit a bug report at http://megamek.sf.net/");
                return;
            }
            if (((MoveStep)serializable).getType() == 9) {
                if (entity.canDFA()) {
                    this.checkExtremeGravityMovement(entity, (MoveStep)serializable, coords2, n8);
                    object = ((MoveStep)serializable).getTarget(this.game);
                    object5 = new DfaAttackAction(entity.getId(), object.getTargetType(), object.getTargetId(), object.getPosition());
                    entity.setDisplacementAttack((DisplacementAttackAction)object5);
                    this.game.addCharge((AttackAction)object5);
                    displacementAttackAction = object5;
                    break;
                }
                this.sendServerChat("Illegal DFA!! I don't think " + entity.getDisplayName() + " should be allowed to DFA," + " but the client of " + entity.getOwner().getName() + " disagrees.");
                this.sendServerChat("Please make sure " + entity.getOwner().getName() + " is running MegaMek " + MegaMek.VERSION + ", or if that is already the case, submit a bug report at http://megamek.sf.net/");
                return;
            }
            coords2 = ((MoveStep)serializable).getPosition();
            n = ((MoveStep)serializable).getFacing();
            n2 = ((MoveStep)serializable).getElevation();
            object = this.game.getBoard().getHex(coords2);
            if (entity.canUnstickByJumping() && entity.isStuck() && n5 == 3) {
                entity.setStuck(false);
                entity.setCanUnstickByJumping(false);
            }
            if ((pilotingRollData = entity.checkSkid(n5, (IHex)object2, n6, (MoveStep)serializable2, n7, n, coords, coords2, bl3, n3)).getValue() != -2147483647) {
                boolean coords4 = true;
                coords4 = entity instanceof Mech ? this.doSkillCheckWhileMoving(entity, coords, coords, pilotingRollData, true) : this.doSkillCheckWhileMoving(entity, coords, coords, pilotingRollData, false);
                if (!coords4) {
                    int n9;
                    Coords enumeration = coords2 = coords;
                    IHex entity5 = null;
                    int bl12 = 0;
                    object4 = null;
                    Entity entity2 = null;
                    int n10 = n7;
                    entity.delta_distance = n3 - 1;
                    n5 = -2;
                    if (((MoveStep)serializable).isThisStepBackwards()) {
                        n10 = (n10 + 3) % 6;
                    }
                    enumeration = coords2.translated(n10);
                    entity5 = this.game.getBoard().getHex(enumeration);
                    for (bl12 = 0; bl12 < (int)Math.ceil((double)entity.delta_distance / 2.0); ++bl12) {
                        Object object6;
                        int n11;
                        if (!this.game.getBoard().contains(enumeration)) {
                            if (this.game.getOptions().booleanOption("push_off_board")) {
                                this.game.removeEntity(entity.getId(), 272);
                                this.send(this.createRemoveEntityPacket(entity.getId(), 272));
                                report = new Report(2030, 0);
                                report.addDesc(entity);
                                this.vPhaseReport.addElement(report);
                                return;
                            }
                            report = new Report(2035);
                            report.subject = entity.getId();
                            report.indent();
                            this.vPhaseReport.addElement(report);
                            break;
                        }
                        if ((entity.isHexProhibited((IHex)object) || entity.isHexProhibited(entity5)) && !Compute.canMoveOnPavement(this.game, coords2, enumeration)) {
                            report = new Report(2040);
                            report.subject = entity.getId();
                            report.indent();
                            report.add(enumeration.getBoardNum(), true);
                            this.vPhaseReport.addElement(report);
                            break;
                        }
                        int n12 = object.floor();
                        int n13 = entity5.floor();
                        if (entity instanceof Tank && entity.getMovementMode() == 5) {
                            if (object.containsTerrain(4)) {
                                n12 = object.surface();
                            }
                            if (entity5.containsTerrain(4)) {
                                n13 += entity5.surface();
                            }
                        } else {
                            if (object.containsTerrain(20)) {
                                n12 = object.surface();
                            }
                            if (entity5.containsTerrain(20)) {
                                n13 = entity5.surface();
                            }
                        }
                        if (n12 < n13) {
                            report = new Report(2045);
                            report.subject = entity.getId();
                            report.indent();
                            report.add(enumeration.getBoardNum(), true);
                            this.vPhaseReport.addElement(report);
                            break;
                        }
                        if (n12 > n13 + 1) {
                            this.doEntityFallsInto(entity, coords2, enumeration, entity.getBasePilotingRoll());
                            this.doEntityDisplacementMinefieldCheck(entity, coords2, enumeration);
                            break;
                        }
                        Building building = this.game.getBoard().getBuildingAt(enumeration);
                        n9 = 0;
                        boolean hitData = false;
                        object4 = this.game.getEntities(enumeration);
                        if (object4.hasMoreElements()) {
                            Serializable entity4;
                            n11 = 0;
                            while (object4.hasMoreElements()) {
                                entity2 = (Entity)object4.nextElement();
                                if (!(entity2 instanceof Infantry)) {
                                    object6 = new ChargeAttackAction(entity.getId(), entity2.getTargetType(), entity2.getTargetId(), entity2.getPosition());
                                    entity4 = ((ChargeAttackAction)object6).toHit(this.game, true);
                                    if (entity instanceof Tank && (entity.getMovementMode() == 5 || entity.getMovementMode() == 7 || entity.getMovementMode() == 8) && 0 < entity5.terrainLevel(4) && entity2.getElevation() < 0) {
                                        if (2 <= entity5.terrainLevel(4) || entity2.isProne()) continue;
                                        ((ToHitData)entity4).setHitTable(1);
                                    } else if (entity.getHeight() < entity2.getHeight()) {
                                        ((ToHitData)entity4).setHitTable(2);
                                    } else {
                                        ((ToHitData)entity4).setHitTable(0);
                                    }
                                    ((ToHitData)entity4).setSideTable(Compute.targetSideTable(entity, entity2));
                                    int n14 = Compute.d6(2);
                                    report = new Report(2050);
                                    report.subject = entity.getId();
                                    report.indent();
                                    report.add(entity2.getShortName(), true);
                                    report.add(enumeration.getBoardNum(), true);
                                    report.newlines = 0;
                                    this.vPhaseReport.addElement(report);
                                    if (((TargetRoll)entity4).getValue() == Integer.MAX_VALUE) {
                                        n14 = -12;
                                        report = new Report(2055);
                                        report.subject = entity.getId();
                                        report.add(((TargetRoll)entity4).getDesc());
                                        report.newlines = 0;
                                        this.vPhaseReport.addElement(report);
                                    } else if (((TargetRoll)entity4).getValue() == Integer.MIN_VALUE) {
                                        report = new Report(2060);
                                        report.subject = entity.getId();
                                        report.add(((TargetRoll)entity4).getDesc());
                                        report.newlines = 0;
                                        this.vPhaseReport.addElement(report);
                                        n14 = Integer.MAX_VALUE;
                                    } else {
                                        report = new Report(2065);
                                        report.subject = entity.getId();
                                        report.add(((TargetRoll)entity4).getValue());
                                        report.add(n14);
                                        report.newlines = 0;
                                        this.vPhaseReport.addElement(report);
                                    }
                                    if (n14 < ((TargetRoll)entity4).getValue()) {
                                        report = new Report(2070);
                                        report.subject = entity.getId();
                                        this.vPhaseReport.addElement(report);
                                    } else {
                                        this.resolveChargeDamage(entity, entity2, (ToHitData)entity4, n10);
                                        if (object4.hasMoreElements()) {
                                            entity.setPosition(coords2);
                                        }
                                        n9 = 1;
                                        n11 = 1;
                                    }
                                    if (!(entity2.isDoomed() || entity2.isDestroyed() || this.game.isOutOfGame(entity2))) {
                                        hitData = true;
                                    }
                                    if (!entity2.isDone()) {
                                        this.resolvePilotingRolls(entity2);
                                        this.game.resetPSRs(entity2);
                                        entity2.applyDamage();
                                        Report.addNewline(this.vPhaseReport);
                                    }
                                } else if (building != null) {
                                    report = new Report(2075);
                                    report.subject = entity.getId();
                                    report.indent();
                                    report.add(entity2.getShortName(), true);
                                    report.add(enumeration.getBoardNum(), true);
                                    report.newlines = 0;
                                    this.vPhaseReport.addElement(report);
                                    object6 = entity2.rollHitLocation(0, Compute.targetSideTable(entity, entity2));
                                    Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, (HitData)object6, Math.round(entity.getWeight() / 5.0f)));
                                    Report.addNewline(this.vPhaseReport);
                                }
                                if (entity2.isDoomed()) {
                                    if (!entity2.isDone()) {
                                        this.game.removeTurnFor(entity2);
                                        this.send(this.createTurnVectorPacket());
                                    }
                                    entity2.setDestroyed(true);
                                    this.game.moveToGraveyard(entity2.getId());
                                    this.send(this.createRemoveEntityPacket(entity2.getId()));
                                }
                                if (this.game.isOutOfGame(entity2)) continue;
                                this.entityUpdate(entity2.getId());
                            }
                            if (n11 == 0) {
                                object6 = entity.getPosition();
                                entity4 = Compute.getMissedChargeDisplacement(this.game, entity.getId(), (Coords)object6, n10);
                                this.doEntityDisplacement(entity, (Coords)object6, (Coords)entity4, null);
                            } else {
                                entity.setPosition(enumeration);
                            }
                        }
                        if (building != null) {
                            report = new Report(2080);
                            report.subject = entity.getId();
                            report.indent();
                            report.add(building.getName());
                            report.add(enumeration.getBoardNum(), true);
                            this.vPhaseReport.addElement(report);
                            n11 = ChargeAttackAction.getDamageFor(entity);
                            if (n9 == 0) {
                                object6 = this.damageBuilding(building, n11);
                                ((Report)object6).indent(2);
                                ((Report)object6).subject = entity.getId();
                                this.vPhaseReport.addElement(object6);
                                int n15 = ChargeAttackAction.getDamageTakenBy(entity, building);
                                HitData hitData2 = entity.rollHitLocation(0, entity.sideTable(enumeration));
                                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData2, n15));
                                Report.addNewline(this.vPhaseReport);
                                entity.setPosition(enumeration);
                                this.doEntityDisplacementMinefieldCheck(entity, coords2, enumeration);
                                coords2 = enumeration;
                            }
                            this.damageInfantryIn(building, n11);
                            if (building.getCurrentCF() > 0) {
                                hitData = true;
                                this.addAffectedBldg(building, false);
                            }
                        }
                        if (hitData) break;
                        pilotingRollData = entity.checkRubbleMove((MoveStep)serializable, entity5, coords2, enumeration);
                        if (pilotingRollData.getValue() != -2147483647) {
                            this.doSkillCheckWhileMoving(entity, coords2, enumeration, pilotingRollData, true);
                            if (entity.isProne()) break;
                        }
                        if (object.terrainLevel(24) == 1) {
                            n11 = Compute.d6(1);
                            report = new Report(2395);
                            report.addDesc(entity);
                            report.add(n11);
                            report.subject = entity.getId();
                            this.vPhaseReport.addElement(report);
                            if (n11 == 6) {
                                object.removeTerrain(24);
                                object.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                                this.sendChangedHex(coords2);
                                object6 = this.game.getEntities(coords2);
                                while (object6.hasMoreElements()) {
                                    Entity entity3 = (Entity)object6.nextElement();
                                    if (entity3 == entity) continue;
                                    this.doMagmaDamage(entity3, false);
                                }
                            }
                        }
                        if (object.terrainLevel(24) == 2) {
                            this.doMagmaDamage(entity, false);
                        }
                        if ((pilotingRollData = entity.checkSwampMove((MoveStep)serializable, entity5, coords2, enumeration)).getValue() != -2147483647 && !this.doSkillCheckWhileMoving(entity, coords2, enumeration, pilotingRollData, false)) {
                            entity.setStuck(true);
                            report = new Report(2081);
                            report.subject = entity.getId();
                            report.add(entity.getDisplayName(), true);
                            break;
                        }
                        entity.setPosition(enumeration);
                        this.doEntityDisplacementMinefieldCheck(entity, coords2, enumeration);
                        coords2 = enumeration;
                        report = new Report(2085);
                        report.subject = entity.getId();
                        report.indent();
                        report.add(coords2.getBoardNum(), true);
                        this.vPhaseReport.addElement(report);
                        enumeration = enumeration.translated(n10);
                        entity5 = this.game.getBoard().getHex(enumeration);
                    }
                    coords2 = entity.getPosition();
                    entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
                    while (entity2 != null) {
                        enumeration = Compute.getValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n10);
                        if (null == enumeration) {
                            System.err.println("The skid of " + entity.getShortName() + " should displace " + entity2.getShortName() + " in hex " + coords2.getBoardNum() + " but there is nowhere to go.");
                            break;
                        }
                        report = new Report(1210, 0);
                        report.indent();
                        report.newlines = 0;
                        this.vPhaseReport.addElement(report);
                        this.doEntityDisplacement(entity2, coords2, enumeration, null);
                        this.doEntityDisplacementMinefieldCheck(entity, coords2, enumeration);
                        entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
                    }
                    if (entity instanceof Mech) {
                        int n16;
                        report = new Report(2090);
                        report.subject = entity.getId();
                        report.indent();
                        report.addDesc(entity);
                        report.add(n16);
                        this.vPhaseReport.addElement(report);
                        for (n16 = bl12 * (int)Math.ceil((double)Math.round((double)entity.getWeight() / 10.0) / 2.0); n16 > 0; n16 -= n9) {
                            n9 = Math.min(5, n16);
                            HitData hitData = entity.rollHitLocation(0, 0);
                            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n9));
                        }
                        Report.addNewline(this.vPhaseReport);
                    }
                    if (entity.isDoomed()) {
                        entity.setDestroyed(true);
                        this.game.moveToGraveyard(entity.getId());
                        this.send(this.createRemoveEntityPacket(entity.getId()));
                        return;
                    }
                    report = new Report(2095);
                    report.subject = entity.getId();
                    report.indent();
                    this.vPhaseReport.addElement(report);
                    n = entity.getFacing();
                    coords2 = entity.getPosition();
                    entity.setSecondaryFacing(n);
                    n4 = movePath.hasActiveMASC() ? entity.getRunMP() : entity.getRunMPwithoutMASC();
                    entity.moved = n5;
                    bl5 = true;
                    n3 = entity.delta_distance;
                    break;
                }
            }
            if (entity instanceof VTOL && (pilotingRollData = ((VTOL)entity).checkSideSlip(n5, (IHex)object2, n6, (MoveStep)serializable2, n7, n, coords, coords2, n3)).getValue() != -2147483647 && !this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) {
                bl2 = true;
                report = new Report(2100);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.vPhaseReport.addElement(report);
                Coords enumeration = coords.translated(n7);
                if (!this.game.getBoard().contains(enumeration)) {
                    if (this.game.getOptions().booleanOption("push_off_board")) {
                        this.game.removeEntity(entity.getId(), 272);
                        this.send(this.createRemoveEntityPacket(entity.getId(), 272));
                        report = new Report(2030);
                        report.subject = entity.getId();
                        report.addDesc(entity);
                        this.vPhaseReport.addElement(report);
                        return;
                    }
                    report = new Report(2035);
                    report.subject = entity.getId();
                    this.vPhaseReport.addElement(report);
                    break;
                }
                int n22 = entity.calcElevation(this.game.getBoard().getHex(coords2), this.game.getBoard().getHex(enumeration), n2);
                if (n22 <= 0) {
                    report = new Report(2105);
                    report.subject = entity.getId();
                    report.add(enumeration.getBoardNum(), true);
                    this.vPhaseReport.addElement(report);
                    int minefield = n - n7 + 6;
                    minefield = 0;
                    switch (minefield %= 6) {
                        case 0: {
                            minefield = 0;
                            break;
                        }
                        case 1: 
                        case 2: {
                            minefield = 2;
                            break;
                        }
                        case 3: {
                            minefield = 1;
                            break;
                        }
                        case 4: 
                        case 5: {
                            minefield = 3;
                        }
                    }
                    coords2 = enumeration;
                    n2 = n22;
                    Server.combineVectors(this.vPhaseReport, this.crashVTOL((VTOL)entity, true, n3, coords2, n2, minefield));
                    n2 = 0;
                    object4 = this.game.getBoard().getHex(enumeration);
                    if (object4.containsTerrain(4) && !object4.containsTerrain(20) || object4.containsTerrain(1) || object4.containsTerrain(23)) {
                        Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity, "could not land in crash site"));
                    }
                } else {
                    report = new Report(2110);
                    report.subject = entity.getId();
                    report.add(enumeration.getBoardNum(), true);
                    this.vPhaseReport.addElement(report);
                    entity.setElevation(entity.calcElevation(this.game.getBoard().getHex(coords2), this.game.getBoard().getHex(enumeration), n2));
                    coords2 = enumeration;
                }
                if (entity.isDestroyed() || entity.isDoomed()) break;
                bl5 = true;
                break;
            }
            pilotingRollData = entity.checkRubbleMove((MoveStep)serializable, (IHex)object, coords, coords2);
            if (pilotingRollData.getValue() != -2147483647) {
                this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, true);
            }
            if (object.terrainLevel(24) == 1 && ((MoveStep)serializable).getElevation() == 0 && ((MoveStep)serializable).getMovementType() != 3) {
                int n27 = Compute.d6(1);
                report = new Report(2395);
                report.addDesc(entity);
                report.add(n27);
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
                if (n27 == 6) {
                    object.removeTerrain(24);
                    object.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                    this.sendChangedHex(coords2);
                    Enumeration enumeration = this.game.getEntities(coords2);
                    while (enumeration.hasMoreElements()) {
                        Entity enumeration2 = (Entity)enumeration.nextElement();
                        if (enumeration2 == entity) continue;
                        this.doMagmaDamage(enumeration2, false);
                    }
                }
            }
            if (object.terrainLevel(24) == 2 && ((MoveStep)serializable).getElevation() == 0 && ((MoveStep)serializable).getMovementType() != 3) {
                this.doMagmaDamage(entity, false);
            }
            if ((pilotingRollData = entity.checkSwampMove((MoveStep)serializable, (IHex)object, coords, coords2)).getValue() != -2147483647 && !this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) {
                entity.setStuck(true);
                entity.setCanUnstickByJumping(true);
                report = new Report(2081);
                report.add(entity.getDisplayName());
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
                break;
            }
            object5 = this.game.getBoard().getHex(coords);
            if (entity instanceof Mech && !coords.equals(coords2) && (object5.containsTerrain(7) || object5.containsTerrain(24)) && (((MoveStep)serializable).getMovementType() != 3 || 0 == ((MoveStep)serializable).getMpUsed() - ((MoveStep)serializable).getMp())) {
                int player = 0;
                if (object5.containsTerrain(7)) {
                    player += 2;
                }
                if (object5.terrainLevel(24) == 1) {
                    player += 2;
                } else if (object5.terrainLevel(24) == 2) {
                    player += 5;
                }
                entity.heatBuildup += player;
                report = new Report(2115);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(player);
                this.vPhaseReport.addElement(report);
            }
            if (!(entity instanceof Mech) && this.game.getBoard().getHex(coords2).containsTerrain(7) && !coords.equals(coords2) && ((MoveStep)serializable).getMovementType() != 3 && ((MoveStep)serializable).getElevation() <= 1) {
                if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                    this.checkForVehicleFire((Tank)entity, false);
                } else {
                    this.doFlamingDeath(entity);
                }
            }
            if (!object3.hasMoreElements() && !bl4) {
                this.checkExtremeGravityMovement(entity, (MoveStep)serializable, coords2, n8);
            }
            if (!coords.equals(coords2) && ((MoveStep)serializable).getMovementType() != 3 || n6 == 3 && !object3.hasMoreElements()) {
                this.checkVibrabombs(entity, coords2, false, coords, coords2);
                if (this.game.containsMinefield(coords2)) {
                    Enumeration n23 = this.game.getMinefields(coords2).elements();
                    while (n23.hasMoreElements()) {
                        Minefield bl13 = (Minefield)n23.nextElement();
                        boolean entity6 = !object3.hasMoreElements();
                        entity6 |= ((MoveStep)serializable).getMovementType() != 3;
                        if (entity6 &= entity.getElevation() == 0) {
                            this.enterMinefield(entity, bl13, coords2, coords2, true);
                            continue;
                        }
                        if (bl13.getType() != 5) continue;
                        this.enterMinefield(entity, bl13, coords2, coords2, true, 2);
                    }
                }
            }
            if (!coords.equals(coords2) && !object3.hasMoreElements() && bl3 && this.game.containsMinefield(coords2)) {
                Player n24 = entity.getOwner();
                Enumeration enumeration = this.game.getMinefields(coords2).elements();
                while (enumeration.hasMoreElements()) {
                    Minefield bl14 = (Minefield)enumeration.nextElement();
                    if (n24.containsMinefield(bl14)) continue;
                    report = new Report(2120);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    this.vPhaseReport.addElement(report);
                    this.revealMinefield(n24, bl14);
                }
            }
            if ((pilotingRollData = entity.checkWaterMove((MoveStep)serializable, (IHex)object, coords, coords2, bl)).getValue() != -2147483647) {
                int entity7 = entity.getSwarmAttackerId();
                boolean building2 = true;
                Entity entity4 = null;
                if (-1 != entity7) {
                    entity4 = this.game.getEntity(entity7);
                    building2 = entity4.isDone();
                }
                this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, true);
                if (object.terrainLevel(4) > 1) {
                    this.drownSwarmer(entity, coords2);
                }
                if (!building2 && (entity4.isDoomed() || entity4.isDestroyed())) {
                    entity4.setDone(false);
                    entity4.setUnloaded(false);
                    this.game.removeTurnFor(entity4);
                    this.send(this.createTurnVectorPacket());
                    entity4.setDone(true);
                    entity4.setUnloaded(true);
                }
                this.checkForWashedInfernos(entity, coords2);
            }
            this.doSetLocationsExposure(entity, (IHex)object, ((MoveStep)serializable).getMovementType() == 3, ((MoveStep)serializable).getElevation());
            if (object.containsTerrain(20) && object.containsTerrain(4) && !coords.equals(coords2) && ((MoveStep)serializable).getElevation() == 0 && ((MoveStep)serializable).getMovementType() != 3) {
                int targetable = Compute.d6(1);
                report = new Report(2118);
                report.addDesc(entity);
                report.add(targetable);
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
                if (targetable == 6) {
                    this.resolveIceBroken(coords2);
                    this.doEntityFallsInto(entity, coords, coords2, entity.getBasePilotingRoll(), false);
                }
            }
            if (((MoveStep)serializable).getType() == 16) {
                Entity building = null;
                Enumeration equipmentType = this.game.getEntities(coords2);
                while (equipmentType.hasMoreElements()) {
                    building = (Entity)equipmentType.nextElement();
                    if (entity.getOwner() == building.getOwner() && !entity.equals(building)) {
                        if (!entity.canLoad(building) || !building.isSelectableThisTurn()) {
                            System.err.println(entity.getShortName() + " can not load " + building.getShortName());
                            building = null;
                            continue;
                        }
                        this.loadUnit(entity, building);
                        break;
                    }
                    building = null;
                }
                if (building == null) {
                    System.err.println("Could not find unit for " + entity.getShortName() + " to load in " + coords2);
                }
            }
            if (((MoveStep)serializable).getType() == 17 && !this.unloadUnit(entity, mounted = ((MoveStep)serializable).getTarget(this.game), coords2, n, ((MoveStep)serializable).getElevation())) {
                System.err.println("Error! Server was told to unload " + mounted.getDisplayName() + " from " + entity.getDisplayName() + " into " + coords2.getBoardNum());
            }
            if (entity.checkMovementInBuilding(coords, coords2, (MoveStep)serializable, (IHex)object, (IHex)object2)) {
                Building building = this.game.getBoard().getBuildingAt(coords);
                Building building2 = this.game.getBoard().getBuildingAt(coords2);
                boolean bl10 = false;
                if (building == null) {
                    bl10 = this.passBuildingWall(entity, building2, coords, coords2, n3, "entering");
                    this.addAffectedBldg(building2, bl10);
                } else if (building.equals(building2)) {
                    bl10 = this.passBuildingWall(entity, building2, coords, coords2, n3, "moving in");
                    this.addAffectedBldg(building2, bl10);
                } else if (building != null && building2 != null) {
                    bl10 = this.passBuildingWall(entity, building, coords, coords2, n3, "exiting");
                    this.addAffectedBldg(building, bl10);
                    bl10 = this.passBuildingWall(entity, building2, coords, coords2, n3, "entering");
                    this.addAffectedBldg(building2, bl10);
                } else {
                    bl10 = this.passBuildingWall(entity, building, coords, coords2, n3, "exiting");
                    this.addAffectedBldg(building, bl10);
                }
                if (entity.isDoomed()) {
                    entity.setDestroyed(true);
                    this.game.moveToGraveyard(entity.getId());
                    this.send(this.createRemoveEntityPacket(entity.getId()));
                    return;
                }
            }
            if (!bl6 && entity.isProne()) {
                n = entity.getFacing();
                coords2 = entity.getPosition();
                n4 = ((MoveStep)serializable).getMpUsed();
                bl5 = true;
                break;
            }
            if (((MoveStep)serializable).getType() == 6) {
                n4 = ((MoveStep)serializable).getMpUsed();
                pilotingRollData = entity.checkDislodgeSwarmers((MoveStep)serializable);
                if (pilotingRollData.getValue() == -2147483647) {
                    entity.setProne(true);
                    this.checkForWashedInfernos(entity, coords2);
                    break;
                }
                entity.setPosition(coords2);
                if (this.doDislodgeSwarmerSkillCheck(entity, pilotingRollData, coords2)) {
                    n = entity.getFacing();
                    coords2 = entity.getPosition();
                    bl5 = true;
                    break;
                }
            }
            if (((MoveStep)serializable).getType() == 24) {
                n4 = ((MoveStep)serializable).getMpUsed();
                entity.setHullDown(true);
            }
            vector.addElement(new UnitLocation(entity.getId(), coords2, n));
            coords = new Coords(coords2);
            serializable2 = serializable;
            if (!object.equals(object2)) {
                n7 = n;
            }
            object2 = object;
            bl4 = false;
        }
        entity.setPosition(coords2);
        entity.setFacing(n);
        entity.setSecondaryFacing(n);
        entity.delta_distance = n3;
        entity.moved = n5;
        entity.mpUsed = n4;
        if (!bl2 && !bl5) {
            entity.setElevation(n2);
        }
        if ((pilotingRollData = entity.checkRunningWithDamage(n6)).getValue() != -2147483647) {
            this.doSkillCheckInPlace(entity, pilotingRollData);
        }
        if (n6 == 3 && !entity.isMakingDfa()) {
            int n17;
            object3 = this.game.getBoard().getHex(coords2);
            pilotingRollData = entity.checkLandingWithDamage();
            if (pilotingRollData.getValue() != -2147483647) {
                this.doSkillCheckInPlace(entity, pilotingRollData);
            }
            int n26 = object3.terrainLevel(4);
            if (object3.containsTerrain(20) && n26 > 0) {
                n26 = 0;
                int pilotingRollData2 = Compute.d6(1);
                report = new Report(2122);
                report.add(entity.getDisplayName(), true);
                report.add(pilotingRollData2);
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
                if (pilotingRollData2 >= 4) {
                    this.resolveIceBroken(coords2);
                    this.doEntityFallsInto(entity, coords, coords2, entity.getBasePilotingRoll(), false);
                }
            }
            if ((pilotingRollData = entity.checkWaterMove(n26)).getValue() != -2147483647) {
                this.doSkillCheckInPlace(entity, pilotingRollData);
            }
            if (n26 > 1) {
                this.drownSwarmer(entity, coords2);
            }
            if (object3.terrainLevel(24) == 1) {
                int n25 = Compute.d6(1);
                report = new Report(2395);
                report.addDesc(entity);
                report.add(n25);
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
                if (n25 == 6) {
                    object3.removeTerrain(24);
                    object3.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                    this.sendChangedHex(coords2);
                    Enumeration entity8 = this.game.getEntities(coords2);
                    while (entity8.hasMoreElements()) {
                        object = (Entity)entity8.nextElement();
                        if (object == entity) continue;
                        this.doMagmaDamage((Entity)object, false);
                    }
                }
            }
            if (object3.terrainLevel(24) == 2) {
                this.doMagmaDamage(entity, false);
            }
            if (object3.containsTerrain(9) || object3.containsTerrain(24) || object3.containsTerrain(28) || object3.containsTerrain(25) || object3.containsTerrain(29)) {
                if (entity instanceof Mech) {
                    entity.setStuck(true);
                    report = new Report(2121);
                    report.add(entity.getDisplayName(), true);
                    report.subject = entity.getId();
                    this.vPhaseReport.addElement(report);
                } else if (entity instanceof Infantry) {
                    PilotingRollData pilotingRollData2 = entity.getBasePilotingRoll();
                    pilotingRollData2.addModifier(5, "infantry jumping into swamp");
                    if (!this.doSkillCheckWhileMoving(entity, coords2, coords2, pilotingRollData2, false)) {
                        entity.setStuck(true);
                        report = new Report(2081);
                        report.add(entity.getDisplayName());
                        report.subject = entity.getId();
                        this.vPhaseReport.addElement(report);
                    }
                }
            }
            if (-1 != (n17 = entity.getSwarmAttackerId())) {
                Entity entity5 = this.game.getEntity(n17);
                object = entity.getBasePilotingRoll();
                entity.addPilotingModifierForTerrain((PilotingRollData)object);
                ((TargetRoll)object).addModifier(4, "dislodge swarming infantry");
                Enumeration enumeration = entity5.getMisc();
                while (enumeration.hasMoreElements()) {
                    Mounted mounted = (Mounted)enumeration.nextElement();
                    EquipmentType equipmentType = mounted.getType();
                    if (!"BA-Assault Claws".equals(equipmentType.getInternalName())) continue;
                    ((TargetRoll)object).addModifier(1, "swarmer has assault claws");
                    break;
                }
                report = new Report(2125);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.vPhaseReport.addElement(report);
                int n18 = Compute.d6(2);
                report = new Report(2130);
                report.subject = entity.getId();
                report.add(((TargetRoll)object).getValueAsString());
                report.add(((TargetRoll)object).getDesc());
                report.add(n18);
                if (n18 < ((TargetRoll)object).getValue()) {
                    report.choose(false);
                    this.vPhaseReport.addElement(report);
                } else {
                    this.game.removeTurnFor(entity5);
                    this.send(this.createTurnVectorPacket());
                    report.choose(true);
                    this.vPhaseReport.addElement(report);
                    entity.setSwarmAttackerId(-1);
                    entity5.setSwarmTargetId(-1);
                    if (object3.terrainLevel(4) > 0) {
                        entity5.setPosition(coords2);
                        report = new Report(2135);
                        report.subject = entity.getId();
                        report.indent();
                        report.addDesc(entity5);
                        this.vPhaseReport.addElement(report);
                        Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity5, "a watery grave", false));
                    } else {
                        report = new Report(2140);
                        report.subject = entity.getId();
                        report.indent();
                        report.addDesc(entity5);
                        this.vPhaseReport.addElement(report);
                        Server.combineVectors(this.vPhaseReport, this.damageEntity(entity5, entity5.rollHitLocation(0, 0), 11));
                        Report.addNewline(this.vPhaseReport);
                        entity5.setPosition(coords2);
                    }
                    this.entityUpdate(n17);
                }
            }
            this.checkForWashedInfernos(entity, coords2);
        }
        this.doSetLocationsExposure(entity, this.game.getBoard().getHex(coords2), false, entity.getElevation());
        if (bl5 && entity.mpUsed < entity.getRunMP() && entity.isSelectableThisTurn() && !entity.isDoomed()) {
            entity.applyDamage();
            entity.setDone(false);
            object3 = new GameTurn.SpecificEntityTurn(entity.getOwner().getId(), entity.getId());
            this.game.insertNextTurn((GameTurn)object3);
            this.send(this.createTurnVectorPacket());
            this.send(entity.getOwner().getId(), this.createSpecialReportPacket());
        } else {
            entity.setDone(true);
        }
        int n28 = entity.getSwarmAttackerId();
        if (-1 != n28) {
            serializable = this.game.getEntity(n28);
            ((Entity)serializable).setPosition(coords2);
            if (!(serializable instanceof BattleArmor) && this.game.getBoard().getHex(coords2).containsTerrain(7)) {
                ((Entity)serializable).setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report = new Report(2145);
                report.subject = entity.getId();
                report.indent();
                report.add(((Entity)serializable).getShortName(), true);
                this.vPhaseReport.addElement(report);
            }
            this.entityUpdate(n28);
        }
        if (!this.game.isOutOfGame(entity)) {
            this.entityUpdate(entity.getId(), vector);
            if (entity.isDoomed()) {
                this.send(this.createRemoveEntityPacket(entity.getId(), entity.getRemovalCondition()));
            }
        }
        if (this.doBlind()) {
            this.send(entity.getOwner().getId(), this.createFilteredEntitiesPacket(entity.getOwner()));
        }
        if (displacementAttackAction != null) {
            this.send(this.createAttackPacket(displacementAttackAction, 1));
        }
    }

    private void deliverThunderAugMinefield(Coords coords, int n, int n2) {
        Coords coords2 = null;
        for (int i = 0; i < 7; ++i) {
            switch (i) {
                case 6: {
                    coords2 = new Coords(coords);
                    break;
                }
                default: {
                    coords2 = coords.translated(i);
                }
            }
            if (!this.game.getBoard().contains(coords2)) continue;
            Minefield minefield = null;
            Enumeration enumeration = this.game.getMinefields(coords2).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield2 = (Minefield)enumeration.nextElement();
                if (minefield2.getType() != 3) continue;
                minefield = minefield2;
                break;
            }
            if (minefield == null) {
                minefield = Minefield.createThunderMF(coords2, n, n2 / 2 + n2 % 2);
                this.game.addMinefield(minefield);
                this.revealMinefield(minefield);
                continue;
            }
            if (minefield.getDamage() >= 20) continue;
            this.removeMinefield(minefield);
            int n3 = n2 / 2 + n2 % 2;
            if ((n3 += minefield.getDamage()) > 20) {
                n3 = 20;
            }
            minefield.setDamage(n3);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = (Minefield)enumeration.nextElement();
            if (minefield2.getType() != 3) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderInfernoMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = (Minefield)enumeration.nextElement();
            if (minefield2.getType() != 4) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderInfernoMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverFASCAMMinefield(Coords coords, int n) {
        if (this.game.getBoard().contains(coords)) {
            Minefield minefield = null;
            Enumeration enumeration = this.game.getMinefields(coords).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield2 = (Minefield)enumeration.nextElement();
                if (minefield2.getType() != 3) continue;
                minefield = minefield2;
                break;
            }
            if (minefield == null) {
                minefield = Minefield.createThunderMF(coords, n, 30);
            }
            this.removeMinefield(minefield);
            minefield.setDamage(30);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderActiveMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = (Minefield)enumeration.nextElement();
            if (minefield2.getType() != 5) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderActiveMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderVibraMinefield(Coords coords, int n, int n2, int n3) {
        Minefield minefield = null;
        Enumeration enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = (Minefield)enumeration.nextElement();
            if (minefield2.getType() != 6) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderVibrabombMF(coords, n, n2, n3);
            this.game.addVibrabomb(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n4 = minefield.getDamage();
            n2 = (n2 += n4) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addVibrabomb(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverFlare(Coords coords, int n) {
        Flare flare = new Flare(coords, Math.max(1, n / 5), 3, 0);
        this.game.addFlare(flare);
    }

    private void deliverArtilleryFlare(Coords coords, int n) {
        Flare flare = new Flare(coords, 12, n, Flare.F_DRIFTING);
        this.game.addFlare(flare);
    }

    private void enterMinefield(Entity entity, Minefield minefield, Coords coords, Coords coords2, boolean bl) {
        this.enterMinefield(entity, minefield, coords, coords2, bl, 0);
    }

    private void enterMinefield(Entity entity, Minefield minefield, Coords coords, Coords coords2, boolean bl, int n) {
        if (!this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(4) || this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(5) || this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(20)) {
            switch (minefield.getType()) {
                case 0: 
                case 3: 
                case 5: {
                    if (minefield.getTrigger() != 0 && Compute.d6(2) < minefield.getTrigger() + n) {
                        return;
                    }
                    Report report = new Report(2150);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    report.add(minefield.getCoords().getBoardNum(), true);
                    this.vPhaseReport.addElement(report);
                    HitData hitData = entity.rollHitLocation(2, 0);
                    Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, minefield.getDamage()));
                    Report.addNewline(this.vPhaseReport);
                    if (bl) {
                        this.resolvePilotingRolls(entity, true, coords, coords2);
                    }
                    if (!minefield.isOneUse()) {
                        this.revealMinefield(minefield);
                        break;
                    }
                    this.removeMinefield(minefield);
                    break;
                }
                case 4: {
                    if (minefield.getTrigger() != 0 && Compute.d6(2) < minefield.getTrigger() + n) {
                        return;
                    }
                    entity.infernos.add(InfernoTracker.STANDARD_ROUND, minefield.getDamage());
                    Report report = new Report(2155);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    report.add(minefield.getCoords().getBoardNum(), true);
                    report.addDesc(entity);
                    report.add(entity.infernos.getTurnsLeftToBurn());
                    this.vPhaseReport.addElement(report);
                    IHex iHex = this.game.getBoard().getHex(coords2);
                    if (!iHex.containsTerrain(7)) {
                        report = new Report(3005);
                        report.subject = entity.getId();
                        report.add(coords2.getBoardNum(), true);
                        this.vPhaseReport.addElement(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords2, InfernoTracker.STANDARD_ROUND, 1);
                    this.sendChangedHex(coords2);
                }
            }
        }
    }

    private void checkVibrabombs(Entity entity, Coords coords, boolean bl) {
        this.checkVibrabombs(entity, coords, bl, null, null);
    }

    private void checkVibrabombs(Entity entity, Coords coords, boolean bl, Coords coords2, Coords coords3) {
        if (!(entity instanceof Mech)) {
            return;
        }
        int n = (int)entity.getWeight();
        Enumeration enumeration = this.game.getVibrabombs().elements();
        while (enumeration.hasMoreElements()) {
            Report report;
            Minefield minefield = (Minefield)enumeration.nextElement();
            if (this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(4) && !this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(5) && !this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(20) || n <= minefield.getSetting() - 10) continue;
            int n2 = (n - minefield.getSetting()) / 10;
            int n3 = coords.distance(minefield.getCoords());
            if (n3 <= n2) {
                report = new Report(2156);
                report.subject = entity.getId();
                report.add(entity.getShortName(), true);
                report.add(minefield.getCoords().getBoardNum(), true);
                this.vPhaseReport.addElement(report);
                this.explodeVibrabomb(minefield);
            }
            if (bl || n3 != 0) continue;
            report = new Report(2160);
            report.subject = entity.getId();
            report.add(entity.getShortName(), true);
            this.vPhaseReport.addElement(report);
            HitData hitData = entity.rollHitLocation(2, 0);
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, minefield.getDamage()));
            Report.addNewline(this.vPhaseReport);
            this.resolvePilotingRolls(entity, true, coords2, coords3);
            entity.applyDamage();
        }
    }

    private void removeMinefieldsFrom(Coords coords) {
        Vector vector = this.game.getMinefields(coords);
        while (vector.elements().hasMoreElements()) {
            Minefield minefield = (Minefield)vector.elements().nextElement();
            this.removeMinefield(minefield);
        }
    }

    private void removeMinefield(Minefield minefield) {
        if (this.game.containsVibrabomb(minefield)) {
            this.game.removeVibrabomb(minefield);
        }
        this.game.removeMinefield(minefield);
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.removeMinefield(player, minefield);
        }
    }

    private void removeMinefield(Player player, Minefield minefield) {
        if (player.containsMinefield(minefield)) {
            player.removeMinefield(minefield);
            this.send(player.getId(), new Packet(410, minefield));
        }
    }

    private void revealMinefield(Minefield minefield) {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.revealMinefield(player, minefield);
        }
    }

    private void revealMinefield(Player player, Minefield minefield) {
        if (!player.containsMinefield(minefield)) {
            player.addMinefield(minefield);
            this.send(player.getId(), new Packet(400, minefield));
        }
    }

    private void explodeVibrabomb(Minefield minefield) {
        Enumeration enumeration = this.game.getEntities(minefield.getCoords());
        while (enumeration.hasMoreElements()) {
            Report report;
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.isDone() || !this.game.getOptions().booleanOption("no_premove_vibra")) {
                report = new Report(2157);
                report.subject = entity.getId();
                report.add(entity.getShortName(), true);
                this.vPhaseReport.addElement(report);
                continue;
            }
            report = new Report(2160);
            report.subject = entity.getId();
            report.add(entity.getShortName(), true);
            this.vPhaseReport.addElement(report);
            if (minefield.getType() == 2) {
                HitData hitData = entity.rollHitLocation(2, 0);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, minefield.getDamage()));
                Report.addNewline(this.vPhaseReport);
            } else if (minefield.getType() == 6) {
                int n = minefield.getDamage();
                HitData hitData = entity.rollHitLocation(2, 0);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n));
            }
            this.resolvePilotingRolls(entity, true, entity.getPosition(), entity.getPosition());
            this.game.resetPSRs(entity);
            entity.applyDamage();
            Report.addNewline(this.vPhaseReport);
            this.entityUpdate(entity.getId());
        }
        if (!minefield.isOneUse()) {
            this.revealMinefield(minefield);
        } else {
            this.removeMinefield(minefield);
        }
    }

    private void drownSwarmer(Entity entity, Coords coords) {
        Entity entity2;
        int n = entity.getSwarmAttackerId();
        if (-1 != n && !((entity2 = this.game.getEntity(n)) instanceof BattleArmor)) {
            entity2.setSwarmTargetId(-1);
            entity.setSwarmAttackerId(-1);
            entity2.setPosition(coords);
            Report report = new Report(2165);
            report.subject = entity.getId();
            report.indent();
            report.add(entity.getShortName(), true);
            this.vPhaseReport.addElement(report);
            Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity2, "a watery grave", false));
            this.entityUpdate(n);
        }
    }

    void checkForWashedInfernos(Entity entity, Coords coords) {
        IHex iHex = this.game.getBoard().getHex(coords);
        int n = iHex.terrainLevel(4);
        if (!(entity instanceof Mech) || !entity.infernos.isStillBurning()) {
            return;
        }
        if (n > 0 && entity.absHeight() < 0) {
            this.washInferno(entity, coords);
        }
    }

    void washInferno(Entity entity, Coords coords) {
        this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
        entity.infernos.clear();
        IHex iHex = this.game.getBoard().getHex(coords);
        Report report = new Report(2170);
        report.subject = entity.getId();
        report.addDesc(entity);
        if (!iHex.containsTerrain(7)) {
            report.messageId = 2175;
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
        }
        this.vPhaseReport.addElement(report);
        this.sendChangedHex(coords);
    }

    public void addMovementHeat() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.moved == 1 || entity.moved == 4) {
                ++entity.heatBuildup;
                continue;
            }
            if (entity.moved == 2 || entity.moved == 5 || entity.moved == -2) {
                entity.heatBuildup += 2;
                continue;
            }
            if (entity.moved != 3) continue;
            entity.heatBuildup += Math.max(3, entity.getJumpHeat(entity.delta_distance));
        }
    }

    public void doSetLocationsExposure(Entity entity, IHex iHex, boolean bl, int n) {
        block7: {
            block5: {
                block6: {
                    if (iHex.terrainLevel(4) <= 0 || bl || n >= 0) break block5;
                    if (!(entity instanceof Mech) || entity.isProne() || iHex.terrainLevel(4) != 1) break block6;
                    for (int i = 0; i < entity.locations(); ++i) {
                        if (this.game.getOptions().booleanOption("vacuum")) {
                            entity.setLocationStatus(i, 1);
                            continue;
                        }
                        entity.setLocationStatus(i, 0);
                    }
                    entity.setLocationStatus(6, 2);
                    entity.setLocationStatus(7, 2);
                    Server.combineVectors(this.vPhaseReport, this.breachCheck(entity, 6, iHex));
                    Server.combineVectors(this.vPhaseReport, this.breachCheck(entity, 7, iHex));
                    if (!(entity instanceof QuadMech)) break block7;
                    entity.setLocationStatus(4, 2);
                    entity.setLocationStatus(5, 2);
                    Server.combineVectors(this.vPhaseReport, this.breachCheck(entity, 4, iHex));
                    Server.combineVectors(this.vPhaseReport, this.breachCheck(entity, 5, iHex));
                    break block7;
                }
                for (int i = 0; i < entity.locations(); ++i) {
                    entity.setLocationStatus(i, 2);
                    Server.combineVectors(this.vPhaseReport, this.breachCheck(entity, i, iHex));
                }
                break block7;
            }
            for (int i = 0; i < entity.locations(); ++i) {
                if (this.game.getOptions().booleanOption("vacuum")) {
                    entity.setLocationStatus(i, 1);
                    continue;
                }
                entity.setLocationStatus(i, 0);
            }
        }
    }

    private boolean doSkillCheckInPlace(Entity entity, PilotingRollData pilotingRollData) {
        boolean bl;
        if (pilotingRollData.getValue() == Integer.MIN_VALUE) {
            return true;
        }
        if (!(entity instanceof Mech) || entity.isProne()) {
            return true;
        }
        Report report = new Report(2180);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.vPhaseReport.addElement(report);
        int n = Compute.d6(2);
        report = new Report(2185);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            report.choose(false);
            this.vPhaseReport.addElement(report);
            this.doEntityFall(entity, pilotingRollData);
            bl = false;
        } else {
            report.choose(true);
            this.vPhaseReport.addElement(report);
            bl = true;
        }
        return bl;
    }

    private boolean doDislodgeSwarmerSkillCheck(Entity entity, PilotingRollData pilotingRollData, Coords coords) {
        Report report = new Report(2180);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.vPhaseReport.addElement(report);
        int n = Compute.d6(2);
        report = new Report(2190);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            report.choose(false);
            this.vPhaseReport.addElement(report);
            return false;
        }
        int n2 = entity.getSwarmAttackerId();
        Entity entity2 = this.game.getEntity(n2);
        this.game.removeTurnFor(entity2);
        this.send(this.createTurnVectorPacket());
        report.choose(true);
        this.vPhaseReport.addElement(report);
        entity.setPosition(coords);
        this.doEntityFallsInto(entity, coords, coords, pilotingRollData, false);
        return true;
    }

    private boolean doSkillCheckWhileMoving(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData, boolean bl) {
        boolean bl2;
        boolean bl3 = true;
        Report report = new Report();
        report.subject = entity.getId();
        report.addDesc(entity);
        if (coords.equals(coords2)) {
            bl2 = true;
            report.messageId = 2195;
            report.add(coords.getBoardNum(), true);
        } else {
            bl2 = false;
            report.messageId = 2200;
            report.add(coords.getBoardNum(), true);
            report.add(coords2.getBoardNum(), true);
        }
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.vPhaseReport.addElement(report);
        int n = Compute.d6(2);
        report = new Report(2185);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            if (bl) {
                report.choose(false);
                this.vPhaseReport.addElement(report);
                this.doEntityFallsInto(entity, bl2 ? coords2 : coords, bl2 ? coords : coords2, pilotingRollData);
            } else {
                report.messageId = 2190;
                report.choose(false);
                this.vPhaseReport.addElement(report);
                entity.setPosition(bl2 ? coords : coords2);
            }
            bl3 = false;
        } else {
            report.choose(true);
            this.vPhaseReport.addElement(report);
        }
        return bl3;
    }

    private void doEntityFallsInto(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        this.doEntityFallsInto(entity, coords, coords2, pilotingRollData, true);
    }

    private void doEntityFallsInto(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData, boolean bl) {
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHex(coords2);
        int n = entity.getElevation() + iHex.depth();
        int n2 = Math.max(0, iHex.floor() + n - iHex2.floor());
        int n3 = coords.direction(coords2);
        Entity entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
        Entity entity3 = this.game.getAffaTarget(coords2);
        Report report = new Report(2205);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(n2);
        report.add(coords2.getBoardNum(), true);
        this.vPhaseReport.addElement(report);
        if (entity2 == null || entity3 == null) {
            this.doEntityFall(entity, coords2, n2, pilotingRollData);
            return;
        }
        if (n2 >= 2 && bl && entity3 != null) {
            report = new Report(2210);
            report.subject = entity.getId();
            report.addDesc(entity3);
            this.vPhaseReport.addElement(report);
            ToHitData toHitData = new ToHitData(7, "base");
            if (entity3 instanceof Tank) {
                toHitData = new ToHitData(0x7FFFFFFE, "Target is a Tank");
            } else {
                toHitData.append(Compute.getTargetMovementModifier(this.game, entity3.getId()));
                toHitData.append(Compute.getTargetTerrainModifier(this.game, entity3));
            }
            if (toHitData.getValue() != 0x7FFFFFFE) {
                int n4 = Compute.d6(2);
                report = new Report(2215);
                report.subject = entity.getId();
                report.add(toHitData.getValue());
                report.add(n4);
                if (n4 >= toHitData.getValue()) {
                    Object object;
                    int n5;
                    int n6;
                    report.choose(true);
                    this.vPhaseReport.addElement(report);
                    report = new Report(2220);
                    report.subject = entity3.getId();
                    report.addDesc(entity3);
                    report.add(n6);
                    this.vPhaseReport.addElement(report);
                    for (n6 = Compute.getAffaDamageFor(entity); n6 > 0; n6 -= n5) {
                        n5 = Math.min(5, n6);
                        object = entity3.rollHitLocation(1, 0);
                        Server.combineVectors(this.vPhaseReport, this.damageEntity(entity3, (HitData)object, n5));
                    }
                    Report.addNewline(this.vPhaseReport);
                    PilotingRollData pilotingRollData2 = entity.getBasePilotingRoll();
                    pilotingRollData2.append(pilotingRollData);
                    entity.addPilotingModifierForTerrain(pilotingRollData2, coords2);
                    this.doEntityFall(entity, coords2, n2, 3, pilotingRollData2);
                    this.doEntityDisplacementMinefieldCheck(entity, coords, coords2);
                    if (Compute.stackingViolation(this.game, entity.getId(), coords2) != null) {
                        object = Compute.getValidDisplacement(this.game, entity2.getId(), coords2, n3);
                        if (object != null) {
                            this.doEntityDisplacement(entity3, coords2, (Coords)object, new PilotingRollData(entity2.getId(), 2, "fallen on"));
                            this.entityUpdate(entity3.getId());
                        } else {
                            Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity3, "impossible displacement", entity2 instanceof Mech, entity2 instanceof Mech));
                        }
                    }
                } else {
                    report.choose(false);
                    this.vPhaseReport.addElement(report);
                }
            } else {
                report = new Report(2225);
                report.add(toHitData.getDesc());
                this.vPhaseReport.addElement(report);
            }
            Coords coords3 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, n3);
            if (coords3 != null) {
                this.doEntityFallsInto(entity, coords, coords3, new PilotingRollData(entity.getId(), Integer.MAX_VALUE, "pushed off a cliff"), false);
                this.entityUpdate(entity.getId());
            } else {
                Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity, "impossible displacement", entity instanceof Mech, entity instanceof Mech));
            }
        } else {
            this.doEntityFall(entity, coords2, n2, pilotingRollData);
            Coords coords4 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, n3);
            this.doEntityDisplacement(entity2, coords2, coords4, new PilotingRollData(entity2.getId(), 0, "domino effect"));
            this.entityUpdate(entity2.getId());
        }
    }

    private void doEntityDisplacement(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        if (!this.game.getBoard().contains(coords2)) {
            entity.setPosition(coords2);
            if (!entity.isDoomed()) {
                this.game.removeEntity(entity.getId(), 272);
                this.send(this.createRemoveEntityPacket(entity.getId(), 272));
                Report report = new Report(2230);
                report.addDesc(entity);
                this.vPhaseReport.addElement(report);
            }
            return;
        }
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHex(coords2);
        int n = coords.direction(coords2);
        if (iHex == null || iHex2 == null) {
            System.err.println("Can not displace " + entity.getShortName() + " from " + coords + " to " + coords2 + ".");
            return;
        }
        int n2 = entity.elevationOccupied(iHex) - entity.elevationOccupied(iHex2);
        if (n2 > 1) {
            this.doEntityFallsInto(entity, coords, coords2, pilotingRollData);
            return;
        }
        entity.setPosition(coords2);
        entity.setElevation(entity.elevationOccupied(iHex2) - iHex2.surface());
        Entity entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
        if (entity2 == null) {
            Report report = new Report(2235);
            report.indent();
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(coords2.getBoardNum(), true);
            this.vPhaseReport.addElement(report);
        } else {
            Report report = new Report(2240);
            report.indent();
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(coords2.getBoardNum(), true);
            report.addDesc(entity2);
            this.vPhaseReport.addElement(report);
        }
        this.doEntityDisplacementMinefieldCheck(entity, coords, coords2);
        this.doSetLocationsExposure(entity, iHex2, false, entity.getElevation());
        if (pilotingRollData != null) {
            this.game.addPSR(pilotingRollData);
        }
        this.entityUpdate(entity.getId());
        if (entity2 != null) {
            this.doEntityDisplacement(entity2, coords2, coords2.translated(n), new PilotingRollData(entity2.getId(), 0, "domino effect"));
            if (!this.game.isOutOfGame(entity2)) {
                this.entityUpdate(entity2.getId());
            }
        }
    }

    private void doEntityDisplacementMinefieldCheck(Entity entity, Coords coords, Coords coords2) {
        if (this.game.containsMinefield(coords2)) {
            Enumeration enumeration = this.game.getMinefields(coords2).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield = (Minefield)enumeration.nextElement();
                this.enterMinefield(entity, minefield, coords, coords2, false);
            }
        }
        this.checkVibrabombs(entity, coords2, true);
    }

    private void receiveDeployment(Packet packet, int n) {
        int n2;
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        Coords coords = (Coords)packet.getObject(1);
        int n3 = packet.getIntValue(2);
        int n4 = packet.getIntValue(3);
        Vector<Entity> vector = new Vector<Entity>();
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = packet.getIntValue(5 + n2);
            vector.addElement(this.game.getEntity(n5));
        }
        if (this.game.getPhase() != 4) {
            System.err.println("error: server got deployment packet in wrong phase");
            return;
        }
        n2 = packet.getBooleanValue(4) ? 1 : 0;
        if (!(this.game.getTurn().isValid(n, entity, this.game) && (this.game.getBoard().isLegalDeployment(coords, entity.getOwner()) || n2 != 0 && this.game.getOptions().booleanOption("assault_drop") && entity.canAssaultDrop()))) {
            System.err.println("error: server got invalid deployment packet");
            return;
        }
        this.processDeployment(entity, coords, n3, vector, n2 != 0);
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private void processDeployment(Entity entity, Coords coords, int n, Vector vector, boolean bl) {
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            Entity entity2 = (Entity)object.nextElement();
            if (entity2 == null || entity2.getPosition() != null || entity2.getTransportId() != -1) {
                System.err.println("error: " + entity + " can not load entity #" + entity2);
                break;
            }
            this.loadUnit(entity, entity2);
        }
        entity.setPosition(coords);
        entity.setFacing(n);
        entity.setSecondaryFacing(n);
        object = this.game.getBoard().getHex(coords);
        if (bl) {
            entity.setElevation(object.ceiling() - object.surface() + 100);
            entity.setAssaultDropInProgress(true);
        } else if (entity instanceof VTOL) {
            entity.setElevation(object.ceiling() - object.surface() + 1);
            while (Compute.stackingViolation(this.game, entity, coords, null) != null && entity.getElevation() <= 50) {
                entity.setElevation(entity.getElevation() + 1);
            }
            if (entity.getElevation() > 50) {
                throw new IllegalStateException("Entity #" + entity.getId() + " appears to be in an infinite loop trying to get a legal elevation.");
            }
        } else if (entity.getMovementMode() == 9) {
            entity.setElevation(0);
        } else if (entity.getMovementMode() == 5 || entity.getMovementMode() == 7 || entity.getMovementMode() == 8) {
            entity.setElevation(0);
        } else if (object.containsTerrain(20) || object.containsTerrain(14)) {
            entity.setElevation(0);
        } else {
            entity.setElevation(object.floor() - object.surface());
        }
        entity.setDone(true);
        entity.setDeployed(true);
        this.entityUpdate(entity.getId());
    }

    private void receiveArtyAutoHitHexes(Packet packet, int n) {
        Vector vector = (Vector)packet.getObject(0);
        Integer n2 = (Integer)vector.firstElement();
        vector.removeElementAt(0);
        if (this.game.getPhase() != 22) {
            System.err.println("error: server got set artyautohithexespacket in wrong phase");
            return;
        }
        this.game.getPlayer(n2).setArtyAutoHitHexes(vector);
        this.endCurrentTurn(null);
    }

    private void receiveDeployMinefields(Packet packet, int n) {
        Vector vector = (Vector)packet.getObject(0);
        if (this.game.getPhase() != 20) {
            System.err.println("error: server got deploy minefields packet in wrong phase");
            return;
        }
        this.processDeployMinefields(vector);
        this.endCurrentTurn(null);
    }

    private void processDeployMinefields(Vector vector) {
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            Minefield minefield = (Minefield)vector.elementAt(i);
            n = minefield.getPlayerId();
            this.game.addMinefield(minefield);
            if (minefield.getType() != 2) continue;
            this.game.addVibrabomb(minefield);
        }
        Player player = this.game.getPlayer(n);
        if (null != player) {
            int n2 = player.getTeam();
            if (n2 != 0) {
                Enumeration enumeration = this.game.getTeams();
                while (enumeration.hasMoreElements()) {
                    Team team = (Team)enumeration.nextElement();
                    if (team.getId() != n2) continue;
                    Enumeration enumeration2 = team.getPlayers();
                    while (enumeration2.hasMoreElements()) {
                        Player player2 = (Player)enumeration2.nextElement();
                        if (player2.getId() != player.getId()) {
                            this.send(player2.getId(), new Packet(390, vector));
                        }
                        player2.addMinefields(vector);
                    }
                    break;
                }
            } else {
                player.addMinefields(vector);
            }
        }
    }

    private void receiveAttack(Packet packet, int n) {
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        Vector vector = (Vector)packet.getObject(1);
        if (this.game.getPhase() != 12 && this.game.getPhase() != 14 && this.game.getPhase() != 7 && this.game.getPhase() != 10) {
            System.err.println("error: server got attack packet in wrong phase");
            return;
        }
        if (!this.game.getTurn().isValid(n, entity, this.game)) {
            System.err.println("error: server got invalid attack packet");
            return;
        }
        this.processAttack(entity, vector);
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private void processAttack(Entity entity, Vector vector) {
        boolean bl = !(this.game.getTurn() instanceof GameTurn.TriggerAPPodTurn);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AbstractEntityAction abstractEntityAction;
            Object object;
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            if (entityAction.getEntityId() != entity.getId()) {
                System.err.println("error: attack packet has wrong attacker");
                continue;
            }
            if (entityAction instanceof WeaponAttackAction && ("SwarmMek".equals(object = entity.getEquipment(((WeaponAttackAction)(abstractEntityAction = (WeaponAttackAction)entityAction)).getWeaponId()).getType().getInternalName()) || "LegAttack".equals(object))) {
                Entity entity2 = this.game.getEntity(((AbstractAttackAction)abstractEntityAction).getTargetId());
                Enumeration enumeration2 = entity2.getMisc();
                while (enumeration2.hasMoreElements()) {
                    Mounted mounted = (Mounted)enumeration2.nextElement();
                    if (!mounted.getType().hasFlag(0x2000000) || !mounted.canFire()) continue;
                    this.game.insertNextTurn(new GameTurn.TriggerAPPodTurn(entity2.getOwnerId(), entity2.getId()));
                    this.send(this.createTurnVectorPacket());
                    break;
                }
            }
            if (entityAction instanceof ClubAttackAction) {
                abstractEntityAction = (ClubAttackAction)entityAction;
                object = ((ClubAttackAction)abstractEntityAction).getClub();
                ((Mounted)object).restore();
            }
            if (entityAction instanceof PushAttackAction) {
                abstractEntityAction = (PushAttackAction)entityAction;
                entity.setDisplacementAttack((DisplacementAttackAction)abstractEntityAction);
                this.game.addCharge((AttackAction)((Object)abstractEntityAction));
            } else if (entityAction instanceof DodgeAction) {
                entity.dodging = true;
            } else if (entityAction instanceof SpotAction) {
                entity.setSpotting(true);
            } else {
                this.game.addAction(entityAction);
            }
            if (!(entityAction instanceof TriggerAPPodAction)) continue;
            abstractEntityAction = (TriggerAPPodAction)entityAction;
            object = entity.getEquipment(((TriggerAPPodAction)abstractEntityAction).getPodId());
            ((Mounted)object).setUsedThisRound(true);
        }
        if (bl) {
            entity.setDone(true);
        }
        this.entityUpdate(entity.getId());
        this.send(this.createAttackPacket(vector, 0));
    }

    private void assignAMS() {
        Serializable serializable;
        Object object;
        Hashtable<Entity, Vector<Serializable>> hashtable = new Hashtable<Entity, Vector<Serializable>>();
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof WeaponAttackAction)) continue;
            serializable = (WeaponAttackAction)object;
            Mounted mounted = this.game.getEntity(((AbstractEntityAction)serializable).getEntityId()).getEquipment(((WeaponAttackAction)serializable).getWeaponId());
            if (0 != ((AbstractAttackAction)serializable).getTargetType() || ((WeaponType)mounted.getType()).getDamage() != -2) continue;
            Entity entity = this.game.getEntity(((AbstractAttackAction)serializable).getTargetId());
            Vector<Serializable> vector = (Vector<Serializable>)hashtable.get(entity);
            if (vector == null) {
                vector = new Vector<Serializable>();
                hashtable.put(entity, vector);
            }
            vector.addElement(serializable);
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (Entity)enumeration.nextElement();
            serializable = (Vector)hashtable.get(object);
            ((Entity)object).assignAMS((Vector)serializable);
        }
    }

    private void resolveAllButWeaponAttacks() {
        Serializable serializable;
        RoundUpdated roundUpdated;
        Object object;
        Object object2;
        Object object3;
        if (this.game.getPhase() == 12) {
            this.vPhaseReport.addElement(new Report(3000, 0));
            object3 = this.game.getLayMinefieldActions();
            while (object3.hasMoreElements()) {
                object2 = (LayMinefieldAction)object3.nextElement();
                object = this.game.getEntity(((AbstractEntityAction)object2).getEntityId());
                roundUpdated = ((Entity)object).getEquipment(((LayMinefieldAction)object2).getMineId());
                if (((Mounted)roundUpdated).isMissing()) continue;
                switch (((Mounted)roundUpdated).getMineType()) {
                    case 0: {
                        this.deliverThunderMinefield(((Entity)object).getPosition(), ((Entity)object).getOwnerId(), 10);
                        ((Mounted)roundUpdated).setMissing(true);
                        serializable = new Report(3500);
                        ((Report)serializable).subject = ((Entity)object).getId();
                        ((Report)serializable).addDesc((Entity)object);
                        ((Report)serializable).add(((Entity)object).getPosition().getBoardNum());
                        this.vPhaseReport.addElement(serializable);
                        break;
                    }
                    case 1: {
                        this.deliverThunderVibraMinefield(((Entity)object).getPosition(), ((Entity)object).getOwnerId(), 10, ((Mounted)roundUpdated).getVibraSetting());
                        ((Mounted)roundUpdated).setMissing(true);
                        serializable = new Report(3505);
                        ((Report)serializable).subject = ((Entity)object).getId();
                        ((Report)serializable).addDesc((Entity)object);
                        ((Report)serializable).add(((Entity)object).getPosition().getBoardNum());
                        this.vPhaseReport.addElement(serializable);
                    }
                }
            }
            this.game.resetLayMinefieldActions();
        }
        serializable = new Vector<RoundUpdated>();
        object3 = new Vector();
        object2 = this.game.getActions();
        while (object2.hasMoreElements()) {
            AbstractEntityAction abstractEntityAction;
            object = (EntityAction)object2.nextElement();
            roundUpdated = this.game.getEntity(object.getEntityId());
            if (object instanceof TorsoTwistAction) {
                abstractEntityAction = (TorsoTwistAction)object;
                if (!((Entity)roundUpdated).canChangeSecondaryFacing()) continue;
                ((Entity)roundUpdated).setSecondaryFacing(((TorsoTwistAction)abstractEntityAction).getFacing());
                continue;
            }
            if (object instanceof FlipArmsAction) {
                abstractEntityAction = (FlipArmsAction)object;
                ((Entity)roundUpdated).setArmsFlipped(((FlipArmsAction)abstractEntityAction).getIsFlipped());
                continue;
            }
            if (object instanceof FindClubAction) {
                this.resolveFindClub((Entity)roundUpdated);
                continue;
            }
            if (object instanceof UnjamAction) {
                this.resolveUnjam((Entity)roundUpdated);
                continue;
            }
            if (object instanceof ClearMinefieldAction) {
                ((Vector)serializable).addElement(roundUpdated);
                continue;
            }
            if (object instanceof TriggerAPPodAction) {
                abstractEntityAction = (TriggerAPPodAction)object;
                if (!((Vector)object3).contains(abstractEntityAction)) {
                    this.triggerAPPod((Entity)roundUpdated, ((TriggerAPPodAction)abstractEntityAction).getPodId());
                    ((Vector)object3).addElement(abstractEntityAction);
                    continue;
                }
                System.err.print("AP Pod #");
                System.err.print(((TriggerAPPodAction)abstractEntityAction).getPodId());
                System.err.print(" on ");
                System.err.print(((Entity)roundUpdated).getDisplayName());
                System.err.println(" was already triggered this round!!");
                continue;
            }
            if (!(object instanceof SearchlightAttackAction)) continue;
            abstractEntityAction = (SearchlightAttackAction)object;
            Server.combineVectors(this.vPhaseReport, ((SearchlightAttackAction)abstractEntityAction).resolveAction(this.game));
        }
        this.resolveClearMinefieldAttempts((Vector)serializable);
    }

    private void resolveClearMinefieldAttempts(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            int n;
            Serializable serializable;
            int n2;
            Vector<Entity> vector2 = new Vector<Entity>();
            Entity entity = (Entity)vector.elementAt(i);
            Coords coords = entity.getPosition();
            vector2.addElement(entity);
            for (n2 = i + 1; n2 < vector.size(); ++n2) {
                Entity entity2 = (Entity)vector.elementAt(n2);
                if (!entity2.getPosition().equals(coords)) continue;
                vector2.addElement(entity2);
                vector.removeElement(entity2);
            }
            n2 = 0;
            boolean bl = false;
            for (int j = 0; j < vector2.size(); ++j) {
                Serializable serializable2;
                serializable = (Entity)vector2.elementAt(j);
                n = Compute.d6(2);
                int n3 = 10;
                int n4 = 5;
                object = ((Entity)serializable).getMisc();
                while (object.hasMoreElements()) {
                    serializable2 = (Mounted)object.nextElement();
                    if (!((Mounted)serializable2).getType().hasFlag(0x100000)) continue;
                    n3 = 6;
                    n4 = 2;
                    break;
                }
                serializable2 = new Report(2245);
                ((Report)serializable2).subject = ((Entity)serializable).getId();
                ((Report)serializable2).add(((Entity)serializable).getShortName(), true);
                ((Report)serializable2).add(coords.getBoardNum(), true);
                ((Report)serializable2).add(n3);
                ((Report)serializable2).add(n);
                ((Report)serializable2).newlines = 0;
                this.vPhaseReport.addElement(serializable2);
                if (n >= n3) {
                    serializable2 = new Report(2250);
                    ((Report)serializable2).subject = ((Entity)serializable).getId();
                    this.vPhaseReport.addElement(serializable2);
                    bl = true;
                    continue;
                }
                if (n <= n4) {
                    serializable2 = new Report(2255);
                    ((Report)serializable2).subject = ((Entity)serializable).getId();
                    this.vPhaseReport.addElement(serializable2);
                    n2 = 1;
                    continue;
                }
                serializable2 = new Report(2260);
                ((Report)serializable2).subject = ((Entity)serializable).getId();
                this.vPhaseReport.addElement(serializable2);
            }
            if (n2 != 0) {
                Enumeration enumeration = this.game.getMinefields(coords).elements();
                block8: while (enumeration.hasMoreElements()) {
                    serializable = (Minefield)enumeration.nextElement();
                    switch (((Minefield)serializable).getType()) {
                        case 0: 
                        case 3: {
                            for (n = 0; n < vector2.size(); ++n) {
                                Entity entity3 = (Entity)vector2.elementAt(n);
                                Report report = new Report(2265);
                                report.subject = entity3.getId();
                                report.add(entity3.getShortName(), true);
                                this.vPhaseReport.addElement(report);
                                object = entity3.rollHitLocation(2, 0);
                                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity3, (HitData)object, ((Minefield)serializable).getDamage()));
                                Report.addNewline(this.vPhaseReport);
                            }
                            continue block8;
                        }
                        case 2: {
                            this.explodeVibrabomb((Minefield)serializable);
                        }
                    }
                }
            }
            if (!bl) continue;
            this.removeMinefieldsFrom(coords);
        }
    }

    private void resolveOnlyWeaponAttacks() {
        Serializable serializable;
        Object object;
        Vector<WeaponResult> vector = new Vector<WeaponResult>(this.game.actionsSize());
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof WeaponAttackAction)) continue;
            serializable = (WeaponAttackAction)object;
            vector.addElement(this.preTreatWeaponAttack((WeaponAttackAction)serializable));
        }
        int n = -1;
        object = vector.elements();
        while (object.hasMoreElements()) {
            serializable = (WeaponResult)object.nextElement();
            this.resolveWeaponAttack((WeaponResult)serializable, n);
            n = ((WeaponResult)serializable).waa.getEntityId();
        }
        this.game.resetActions();
    }

    private void triggerAPPod(Entity entity, int n) {
        Mounted mounted = entity.getEquipment(n);
        if (null == mounted) {
            System.err.print("Expecting to find an AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.println(" but found NO equipment at all!!!");
            return;
        }
        EquipmentType equipmentType = mounted.getType();
        if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x2000000)) {
            System.err.print("Expecting to find an AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.print(" but found ");
            System.err.print(equipmentType.getName());
            System.err.println(" instead!!!");
            return;
        }
        boolean bl = mounted.isUsedThisRound();
        mounted.setUsedThisRound(false);
        boolean bl2 = mounted.canFire();
        mounted.setUsedThisRound(bl);
        if (!bl2) {
            System.err.print("Can not trigger the AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.println("!!!");
            return;
        }
        mounted.setFired(true);
        Report report = new Report(3010);
        report.newlines = 0;
        report.subject = entity.getId();
        report.addDesc(entity);
        this.vPhaseReport.addElement(report);
        Enumeration enumeration = this.game.getEntities(entity.getPosition());
        while (enumeration.hasMoreElements()) {
            Entity entity2 = (Entity)enumeration.nextElement();
            if (entity2 instanceof Infantry && !(entity2 instanceof BattleArmor)) {
                int n2 = Compute.d6() - 1;
                if (0 == n2) {
                    report = new Report(3015);
                    report.indent(2);
                    report.subject = entity2.getId();
                    report.addDesc(entity2);
                    this.vPhaseReport.addElement(report);
                    continue;
                }
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, new HitData(0), n2));
                entity2.applyDamage();
                continue;
            }
            if (entity.equals(entity2)) continue;
            report = new Report(3020);
            report.indent(2);
            report.subject = entity2.getId();
            report.addDesc(entity2);
            this.vPhaseReport.addElement(report);
        }
    }

    private void resolveUnjam(Entity entity) {
        int n = entity.getCrew().getGunnery() + 3;
        Report report = new Report(3025);
        report.subject = entity.getId();
        report.addDesc(entity);
        this.vPhaseReport.addElement(report);
        Enumeration enumeration = entity.getWeapons();
        while (enumeration.hasMoreElements()) {
            WeaponType weaponType;
            Mounted mounted = (Mounted)enumeration.nextElement();
            if (!mounted.isJammed() || (weaponType = (WeaponType)mounted.getType()).getAmmoType() != 23) continue;
            int n2 = Compute.d6(2);
            report = new Report(3030);
            report.indent();
            report.subject = entity.getId();
            report.add(weaponType.getName());
            report.add(n);
            report.add(n2);
            if (n2 >= n) {
                report.choose(true);
                mounted.setJammed(false);
            } else {
                report.choose(false);
            }
            this.vPhaseReport.addElement(report);
        }
    }

    private void resolveFindClub(Entity entity) {
        Report report;
        EquipmentType equipmentType = null;
        entity.setFindingClub(true);
        Coords coords = entity.getPosition();
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex.terrainLevel(18) > 0) {
            equipmentType = EquipmentType.get("Limb Club");
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex.terrainLevel(18) - 1));
            this.sendChangedHex(entity.getPosition());
            report = new Report(3035);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        } else if (iHex.terrainLevel(19) > 0) {
            equipmentType = EquipmentType.get("Limb Club");
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex.terrainLevel(19) - 1));
            this.sendChangedHex(entity.getPosition());
            report = new Report(3040);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        } else if (1 < iHex.terrainLevel(3)) {
            boolean bl = false;
            int n = Compute.d6(2);
            switch (iHex.terrainLevel(3)) {
                case 2: {
                    if (n < 7) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (n < 6) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (n < 5) break;
                    bl = true;
                }
            }
            if (bl) {
                equipmentType = EquipmentType.get("Girder Club");
                report = new Report(3045);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.vPhaseReport.addElement(report);
            } else {
                equipmentType = null;
                report = new Report(3050);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.vPhaseReport.addElement(report);
            }
        } else if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
            equipmentType = EquipmentType.get("Tree Club");
            report = new Report(3055);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        try {
            if (equipmentType != null) {
                entity.addEquipment(equipmentType, -1);
            }
        }
        catch (LocationFullException locationFullException) {
            report = new Report(3060);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
    }

    private WeaponResult preTreatWeaponAttack(WeaponAttackAction weaponAttackAction) {
        boolean bl;
        Entity entity = this.game.getEntity(weaponAttackAction.getEntityId());
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl2 = weaponType.getAmmoType() != -1 && weaponType.getAmmoType() != -2 && weaponType.getAmmoType() != -3 && !weaponType.hasFlag(2048);
        Mounted mounted2 = null;
        if (bl2) {
            if (weaponAttackAction.getAmmoId() > -1) {
                mounted2 = entity.getEquipment(weaponAttackAction.getAmmoId());
                mounted.setLinked(mounted2);
            } else {
                mounted2 = mounted.getLinked();
            }
        }
        WeaponResult weaponResult = new WeaponResult();
        weaponResult.waa = weaponAttackAction;
        if (mounted.isUsedThisRound()) {
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon has already been used this round");
            return weaponResult;
        }
        if (mounted.isDestroyed()) {
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon was destroyed in a previous round");
            return weaponResult;
        }
        if (mounted.isJammed()) {
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon is jammed");
            return weaponResult;
        }
        if (bl2 && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isDumping())) {
            entity.loadWeaponWithSameAmmo(mounted);
            mounted2 = mounted.getLinked();
        }
        weaponAttackAction.setAmmoId(entity.getEquipmentNum(mounted2));
        weaponResult.toHit = weaponAttackAction.toHit(this.game);
        if (weaponAttackAction.isNemesisConfused()) {
            weaponResult.toHit.addModifier(1, "iNarc Nemesis pod");
        }
        weaponResult.roll = Compute.d6(2);
        boolean bl3 = bl = (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 32) && weaponResult.roll < weaponResult.toHit.getValue();
        if (!(weaponResult.toHit.getValue() == Integer.MAX_VALUE || bl && !Compute.isAffectedByAngelECM(entity, entity.getPosition(), weaponAttackAction.getTarget(this.game).getPosition()) || weaponAttackAction.isNemesisConfused())) {
            weaponResult = this.addHeatUseAmmoFor(weaponAttackAction, weaponResult);
        }
        mounted.setUsedThisRound(true);
        if (!bl) {
            weaponResult = this.resolveAmsFor(weaponAttackAction, weaponResult);
        }
        return weaponResult;
    }

    private WeaponResult addHeatUseAmmoFor(WeaponAttackAction weaponAttackAction, WeaponResult weaponResult) {
        int n;
        if (weaponAttackAction.isSwarmingMissiles()) {
            return weaponResult;
        }
        Entity entity = this.game.getEntity(weaponAttackAction.getEntityId());
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl = weaponType.getAmmoType() != -1 && weaponType.getAmmoType() != -2 && weaponType.getAmmoType() != -3 && !weaponType.hasFlag(2048);
        Mounted mounted2 = mounted.getLinked();
        int n2 = mounted.howManyShots();
        if (bl && n2 > 1 && (n = entity.getTotalAmmoOfType(mounted2.getType())) < n2) {
            weaponResult.revertsToSingleShot = true;
            n2 = 1;
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                if (mounted2.getShotsLeft() <= 0) {
                    entity.loadWeaponWithSameAmmo(mounted);
                    mounted2 = mounted.getLinked();
                }
                mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
            }
        }
        entity.heatBuildup += weaponType.getHeat() * n2;
        return weaponResult;
    }

    private WeaponResult resolveAmsFor(WeaponAttackAction weaponAttackAction, WeaponResult weaponResult) {
        Entity entity = this.game.getEntity(weaponAttackAction.getTargetId());
        Vector vector = weaponAttackAction.getCounterEquipment();
        if (null != vector) {
            weaponResult.amsShotDown = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                weaponResult.amsShotDown[i] = 0;
                Mounted mounted = (Mounted)vector.elementAt(i);
                Mounted mounted2 = mounted.getLinked();
                if (!(mounted.getType() instanceof WeaponType) || !mounted.getType().hasFlag(0x1000000) || !mounted.isReady() || mounted.isMissing()) continue;
                int n = Compute.d6(((WeaponType)mounted.getType()).getDamage());
                entity.heatBuildup = mounted.getType().hasFlag(0x800000) ? (entity.heatBuildup += Compute.d6(((WeaponType)mounted.getType()).getHeat())) : (entity.heatBuildup += ((WeaponType)mounted.getType()).getHeat());
                if (mounted2 != null) {
                    mounted2.setShotsLeft(Math.max(0, mounted2.getShotsLeft() - n));
                }
                mounted.setUsedThisRound(true);
                weaponResult.amsShotDown[i] = n;
                weaponResult.amsShotDownTotal += n;
            }
        }
        return weaponResult;
    }

    private boolean tryIgniteHex(Coords coords, int n, boolean bl, int n2, boolean bl2) {
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl3 = false;
        if (iHex == null) {
            return false;
        }
        if (bl) {
            this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
            n2 = 0;
            bl3 = true;
        }
        if (iHex.containsTerrain(7)) {
            if (bl2) {
                Report report = new Report(3065);
                report.indent(3);
                report.subject = n;
                this.vPhaseReport.addElement(report);
            }
            return true;
        }
        if (this.ignite(iHex, n2, bl3, n)) {
            Report report = new Report(3070);
            report.indent(3);
            report.subject = n;
            this.vPhaseReport.addElement(report);
            this.sendChangedHex(coords);
            return true;
        }
        return false;
    }

    private boolean tryIgniteHex(Coords coords, int n, boolean bl, int n2) {
        return this.tryIgniteHex(coords, n, bl, n2, false);
    }

    private void tryClearHex(Coords coords, int n, int n2) {
        IHex iHex = this.game.getBoard().getHex(coords);
        int n3 = iHex.terrainLevel(1);
        int n4 = iHex.terrainLevel(23);
        boolean bl = iHex.containsTerrain(20);
        if (n3 == Integer.MIN_VALUE && n4 == Integer.MIN_VALUE && !bl) {
            Report report = new Report(3075);
            report.indent(3);
            report.subject = n2;
            this.vPhaseReport.addElement(report);
        } else {
            int n5 = Compute.d6(2);
            Report report = new Report(3080);
            report.indent(3);
            report.subject = n2;
            report.add(n);
            report.add(n5);
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (n5 >= n) {
                if (n3 > 2) {
                    iHex.removeTerrain(1);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(1, n3 - 1));
                    report = new Report(3082);
                    report.subject = n2;
                    this.vPhaseReport.addElement(report);
                } else if (n3 == 2) {
                    iHex.removeTerrain(1);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(1, n3 - 1));
                    report = new Report(3085);
                    report.subject = n2;
                    this.vPhaseReport.addElement(report);
                } else if (n3 == 1) {
                    iHex.removeTerrain(1);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(2, 1));
                    report = new Report(3090);
                    report.subject = n2;
                    this.vPhaseReport.addElement(report);
                } else if (n4 > 2) {
                    iHex.removeTerrain(23);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(23, n4 - 1));
                    report = new Report(3083);
                    report.subject = n2;
                    this.vPhaseReport.addElement(report);
                } else if (n4 == 2) {
                    iHex.removeTerrain(23);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(23, n4 - 1));
                    report = new Report(3086);
                    report.subject = n2;
                    this.vPhaseReport.addElement(report);
                } else if (n4 == 1) {
                    iHex.removeTerrain(23);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(2, 1));
                    report = new Report(3091);
                    report.subject = n2;
                    this.vPhaseReport.addElement(report);
                } else if (bl) {
                    iHex.removeTerrain(20);
                    report = new Report(3092);
                    report.subject = n2;
                    this.vPhaseReport.addElement(report);
                    this.resolveIceBroken(coords);
                }
                this.sendChangedHex(coords);
            } else {
                report = new Report(3095);
                report.subject = n2;
                this.vPhaseReport.addElement(report);
            }
        }
    }

    private void resolveWeaponAttack(WeaponResult weaponResult, int n) {
        this.resolveWeaponAttack(weaponResult, n, false);
    }

    private boolean resolveWeaponAttack(WeaponResult weaponResult, int n, boolean bl) {
        return this.resolveWeaponAttack(weaponResult, n, bl, 0);
    }

    private boolean resolveWeaponAttack(WeaponResult weaponResult, int n, boolean bl, int n2) {
        int n3;
        int n4;
        boolean bl2;
        Object object;
        Object object2;
        int n5;
        int n6;
        int n7;
        int n8;
        Serializable serializable;
        Report report;
        Targetable targetable;
        Entity entity = this.game.getEntity(weaponResult.waa.getEntityId());
        if (entity == null) {
            entity = this.game.getOutOfGameEntity(weaponResult.waa.getEntityId());
        }
        boolean bl3 = (targetable = this.game.getTarget(weaponResult.waa.getTargetType(), weaponResult.waa.getTargetId())) instanceof Mech ? Compute.isThroughFrontHex(this.game, weaponResult.waa.getEntityId(), (Entity)targetable) : true;
        int n9 = -1;
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n9 = entity2.getId();
        } else {
            n9 = entity.getId();
        }
        Mounted mounted = entity.getEquipment(weaponResult.waa.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl4 = weaponType.hasFlag(2048);
        boolean bl5 = weaponType.getAmmoType() != -1 && weaponType.getAmmoType() != -2 && weaponType.getAmmoType() != -3 && !bl4;
        Mounted mounted2 = bl5 ? entity.getEquipment(weaponResult.waa.getAmmoId()) : null;
        AmmoType ammoType = mounted2 == null ? null : (AmmoType)mounted2.getType();
        Infantry infantry = null;
        boolean bl6 = weaponType.hasFlag(4096);
        ToHitData toHitData = weaponResult.toHit;
        boolean bl7 = bl5 && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 25) && ammoType.getMunitionType() == 0x400000L;
        boolean bl8 = bl5 && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9) && ammoType.getMunitionType() == 128L;
        boolean bl9 = bl5 && ammoType.getAmmoType() == 9 && ammoType.getMunitionType() == 0x800000L;
        boolean bl10 = bl5 && ammoType.getAmmoType() == 1 && ammoType.getMunitionType() == 4L;
        boolean bl11 = targetable.getTargetType() == 7;
        boolean bl12 = targetable.getTargetType() == 0 && weaponType.hasFlag(65536) && bl5 && ammoType.getMunitionType() == 0L && entity2.getMovementMode() == 6 && entity2.getElevation() > 0;
        boolean bl13 = bl5 && ammoType.getAmmoType() == 1 && ammoType.getMunitionType() == 8L;
        boolean bl14 = bl5 && ammoType.getAmmoType() == 1 && ammoType.getMunitionType() == 0x400000000L;
        boolean bl15 = bl5 && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9) && ammoType.getMunitionType() == 512L;
        boolean bl16 = bl5 && ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 32768L;
        boolean bl17 = bl5 && ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 65536L;
        boolean bl18 = (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 8) && mounted.curMode().equals("Indirect");
        boolean bl19 = Compute.isAffectedByAngelECM(entity, entity.getPosition(), targetable.getPosition());
        if (bl18 && this.game.getOptions().booleanOption("indirect_fire") && !this.game.getOptions().booleanOption("indirect_always_possible") && LosEffects.calculateLos(this.game, entity.getId(), targetable).canSee()) {
            Report report2 = new Report(3470);
            report2.subject = n9;
            report2.addDesc(entity);
            this.vPhaseReport.addElement(report2);
            return false;
        }
        boolean bl20 = false;
        int n10 = 0;
        int n11 = 1;
        int n12 = 0;
        int n13 = 0;
        if (!bl7) {
            bl7 = bl4 && weaponType.hasFlag(1024);
        }
        boolean bl21 = Compute.isInBuilding(this.game, entity2);
        if ((bl11 || bl12) && this.game.getPhase() == 12) {
            weaponResult.artyAttackerCoords = entity.getPosition();
        }
        if ((bl16 || bl17) && entity2 != null) {
            entity2.addTargetedBySwarm(entity.getId(), weaponResult.waa.getWeaponId());
        }
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        boolean bl22 = false;
        Mounted mounted3 = mounted.getLinkedBy();
        if (weaponType.getAmmoType() == 29 || mounted3 != null && mounted3.getType() instanceof MiscType && !mounted3.isDestroyed() && !mounted3.isMissing() && !mounted3.isBreached() && mounted3.getType().hasFlag(512)) {
            if (!(mounted.getType().hasModes() && mounted.curMode().equals("Indirect") || (ammoType.getAmmoType() != 29 || ammoType.getMunitionType() != 0L && ammoType.getMunitionType() != 32L && ammoType.getMunitionType() != 64L) && (ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 2048L))) {
                bl22 = true;
            }
        } else if ((weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 9) && bl5 && ammoType.getMunitionType() == 1024L) {
            bl22 = true;
        }
        if (n != entity.getId()) {
            report = new Report(3100);
            report.subject = n9;
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        if ("StopSwarm".equals(weaponType.getInternalName())) {
            if (toHitData.getValue() == Integer.MAX_VALUE) {
                report = new Report(3105);
                report.subject = n9;
                report.add(toHitData.getDesc());
                this.vPhaseReport.addElement(report);
                return true;
            }
            report = new Report(3110);
            report.subject = n9;
            this.vPhaseReport.addElement(report);
            if (entity.getSwarmTargetId() != targetable.getTargetId()) {
                Entity entity3 = this.game.getEntity(entity.getSwarmTargetId());
                entity3.setSwarmAttackerId(-1);
            } else {
                entity2.setSwarmAttackerId(-1);
            }
            entity.setSwarmTargetId(-1);
            return true;
        }
        report = new Report(3115);
        report.indent();
        report.newlines = 0;
        report.subject = n9;
        report.add(weaponType.getName());
        if (entity2 != null) {
            report.addDesc(entity2);
        } else {
            report.messageId = 3120;
            report.add(targetable.getDisplayName(), true);
        }
        this.vPhaseReport.addElement(report);
        boolean bl23 = false;
        if (bl22 && !bl) {
            Enumeration enumeration = this.game.getNemesisTargets(entity, targetable.getPosition());
            while (enumeration.hasMoreElements()) {
                serializable = (Entity)enumeration.nextElement();
                report = new Report(3125);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
                mounted.setUsedThisRound(false);
                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(entity.getId(), ((Entity)serializable).getTargetId(), weaponResult.waa.getWeaponId());
                weaponAttackAction.setNemesisConfused(true);
                WeaponResult weaponResult2 = this.preTreatWeaponAttack(weaponAttackAction);
                if (this.resolveWeaponAttack(weaponResult2, entity.getId(), true)) {
                    return true;
                }
                bl23 = true;
            }
        }
        if (bl23) {
            report = new Report(3130);
            report.subject = n9;
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
        }
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(3135);
            report.subject = n9;
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
            return false;
        }
        if (toHitData.getValue() == 0x7FFFFFFE) {
            report = new Report(3140);
            report.newlines = 0;
            report.subject = n9;
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(3145);
            report.newlines = 0;
            report.subject = n9;
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
        } else {
            report = new Report(3150);
            report.newlines = 0;
            report.subject = n9;
            report.add(toHitData.getValue());
            this.vPhaseReport.addElement(report);
        }
        if (weaponType.getAmmoType() == 22 && entity.mpUsed > 0) {
            switch (entity.getWeightClass()) {
                case 0: {
                    int n14 = 2;
                }
                case 1: {
                    boolean bl24 = true;
                }
                case 2: {
                    boolean bl25 = false;
                }
            }
            int n15 = -1;
            serializable = new PilotingRollData(entity.getId(), n15, "fired HeavyGauss unbraced");
            ((PilotingRollData)serializable).setCumulative(false);
            this.game.addPSR((PilotingRollData)serializable);
        }
        report = new Report(3155);
        report.newlines = 0;
        report.subject = n9;
        report.add(weaponResult.roll);
        this.vPhaseReport.addElement(report);
        int n16 = mounted.howManyShots();
        if (n16 > 1 || weaponType.hasFlag(0x400000) && weaponType.getAmmoType() != -1) {
            int n17 = 0;
            if ((weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34) && mounted.curMode().equals("Ultra") || weaponType.hasFlag(0x400000)) {
                n17 = 2;
                if (mounted.curMode().equals("Ultra") && weaponType.hasFlag(0x400000)) {
                    n17 = 4;
                }
            } else if (weaponType.getAmmoType() == 23) {
                if (n16 == 2) {
                    n17 = 2;
                } else if (n16 == 4) {
                    n17 = 3;
                } else if (n16 == 6) {
                    n17 = 4;
                }
            }
            if (n17 > 0 && weaponResult.roll <= n17) {
                report = new Report();
                if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34) {
                    report.messageId = 3160;
                    mounted.setJammed(true);
                    mounted.setHit(true);
                } else if (weaponType.hasFlag(0x400000)) {
                    report.messageId = 3165;
                    mounted.setJammed(true);
                    mounted.setHit(true);
                } else {
                    report.messageId = 3170;
                    mounted.setJammed(true);
                }
                report.subject = n9;
                this.vPhaseReport.addElement(report);
                return true;
            }
        }
        if (this.game.getOptions().booleanOption("maxtech_ppc_inhibitors") && weaponType.hasModes() && mounted.curMode().equals("Field Inhibitor OFF")) {
            int n18 = 0;
            int n19 = Compute.d6(2);
            int n20 = Compute.effectiveDistance(this.game, entity, targetable);
            if (n20 >= 3) {
                n18 = 3;
            } else if (n20 == 2) {
                n18 = 6;
            } else if (n20 == 1) {
                n18 = 10;
            }
            report = new Report(3175);
            report.subject = entity.getId();
            report.indent();
            this.vPhaseReport.addElement(report);
            report = new Report(3180);
            report.subject = entity.getId();
            report.indent();
            report.add(n18);
            report.add(n19);
            if (n19 < n18) {
                n8 = mounted.getLocation();
                n7 = entity.getEquipmentNum(mounted);
                n6 = 0;
                mounted.setDestroyed(true);
                for (n5 = 0; n5 < entity.getNumberOfCriticals(n8); ++n5) {
                    object2 = entity.getCritical(n8, n5);
                    if (object2 == null || ((CriticalSlot)object2).getType() != 0 || !(object = entity.getEquipment(((CriticalSlot)object2).getIndex())).equals(mounted)) continue;
                    entity.hitAllCriticals(n8, n5);
                }
                report.choose(false);
                this.vPhaseReport.addElement(report);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, new HitData(n8), 10, false, 0, true));
                report = new Report(3185);
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
            } else {
                report.choose(true);
                this.vPhaseReport.addElement(report);
            }
        }
        boolean bl26 = bl2 = weaponResult.roll < toHitData.getValue();
        if (this.game.getOptions().booleanOption("maxtech_glancing_blows")) {
            if (weaponResult.roll == toHitData.getValue()) {
                bl20 = true;
                n12 = -4;
                n13 = -2;
                report = new Report(3186);
                report.subject = entity.getId();
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            } else {
                bl20 = false;
                n12 = 0;
                n13 = 0;
            }
        } else {
            bl20 = false;
            n12 = 0;
            n13 = 0;
        }
        if (weaponType.hasFlag(0x8000000)) {
            if (entity2 == null) {
                report = new Report(3187);
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
            } else {
                int n21 = 1;
                EquipmentMode equipmentMode = mounted.curMode();
                if (equipmentMode != null) {
                    if (equipmentMode.getName() == "1-shot") {
                        n21 = 1;
                    } else if (equipmentMode.getName() == "2-shot") {
                        n21 = 2;
                    } else if (equipmentMode.getName() == "3-shot") {
                        n21 = 3;
                    } else if (equipmentMode.getName() == "4-shot") {
                        n21 = 4;
                    }
                }
                if (n21 < 1) {
                    n21 = 1;
                }
                TagInfo tagInfo = new TagInfo(entity.getId(), entity2.getId(), n21, bl2);
                this.game.addTagInfo(tagInfo);
                if (!bl2) {
                    entity2.setTaggedBy(entity.getId());
                    report = new Report(3188);
                    report.subject = entity.getId();
                    this.vPhaseReport.addElement(report);
                } else {
                    report = new Report(3220);
                    report.subject = entity.getId();
                    this.vPhaseReport.addElement(report);
                }
            }
            return !bl2;
        }
        if (bl12) {
            Coords coords = targetable.getPosition();
            int n22 = targetable.getElevation();
            n8 = n22 + this.game.getBoard().getHex(coords).surface();
            if (!bl2) {
                report = new Report(3191);
                report.subject = n9;
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
            } else {
                coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3192);
                    report.subject = n9;
                    report.add(coords.getBoardNum());
                    this.vPhaseReport.addElement(report);
                } else {
                    report = new Report(3193);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                    return !bl2;
                }
            }
            n7 = 5;
            n6 = weaponType.getRackSize();
            Enumeration enumeration = this.game.getEntities(coords);
            while (enumeration.hasMoreElements()) {
                object2 = (Entity)enumeration.nextElement();
                n11 = n6;
                while (n11 > 0) {
                    if (weaponResult.artyAttackerCoords != null) {
                        toHitData.setSideTable(((Entity)object2).sideTable(weaponResult.artyAttackerCoords));
                    }
                    if (((Entity)object2).getElevation() != n22) {
                        report = new Report(3194);
                        report.subject = ((Entity)object2).getId();
                        report.addDesc((Entity)object2);
                        this.vPhaseReport.addElement(report);
                        continue;
                    }
                    object = ((Entity)object2).rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable(), weaponResult.waa.getAimedLocation(), weaponResult.waa.getAimingMode());
                    Server.combineVectors(this.vPhaseReport, this.damageEntity((Entity)object2, (HitData)object, Math.min(n7, n11), false, 0, false, true, bl3));
                    Report.addNewline(this.vPhaseReport);
                    n11 -= Math.min(n7, n11);
                }
            }
            for (int i = 0; i <= 5; ++i) {
                Object object3;
                object2 = coords.translated(i);
                if (!this.game.getBoard().contains((Coords)object2) || coords.equals(object2)) continue;
                n6 = weaponType.getRackSize() / 2;
                building = null;
                building = this.game.getBoard().getBuildingAt((Coords)object2);
                if (building != null && this.game.getBoard().getHex((Coords)object2).ceiling() < n8) {
                    building = null;
                }
                int n23 = building != null ? building.getPhaseCF() / 10 : 0;
                n23 = Math.min(n23, n6);
                n6 -= n23;
                if (building != null && n23 > 0) {
                    report = new Report(6425);
                    report.subject = n9;
                    report.add(n23);
                    this.vPhaseReport.addElement(report);
                    object3 = this.damageBuilding(building, n6);
                    ((Report)object3).subject = n9;
                    this.vPhaseReport.addElement(object3);
                }
                if ((object3 = this.game.getEntities((Coords)object2)).hasMoreElements()) {
                    report = new Report(3210);
                    report.newlines = 0;
                    report.subject = n9;
                    report.add(((Coords)object2).getBoardNum());
                    report.indent();
                    this.vPhaseReport.addElement(report);
                }
                while (object3.hasMoreElements()) {
                    Entity entity4 = (Entity)object3.nextElement();
                    if (entity4.getElevation() + this.game.getBoard().getHex((Coords)object2).surface() != n8) {
                        report = new Report(3194);
                        report.subject = entity4.getId();
                        report.addDesc(entity4);
                        this.vPhaseReport.addElement(report);
                        continue;
                    }
                    for (n11 = n6; n11 > 0; n11 -= Math.min(n7, n11)) {
                        HitData hitData = entity4.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable(), weaponResult.waa.getAimedLocation(), weaponResult.waa.getAimingMode());
                        Server.combineVectors(this.vPhaseReport, this.damageEntity(entity4, hitData, Math.min(n7, n11)));
                    }
                }
            }
            return !bl2;
        }
        if (targetable.getTargetType() == 14) {
            Coords coords = targetable.getPosition();
            if (!bl2) {
                report = new Report(3190);
                report.subject = n9;
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
            } else {
                coords = Compute.scatter(coords, 1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3195);
                    report.subject = n9;
                    report.add(coords.getBoardNum());
                    this.vPhaseReport.addElement(report);
                } else {
                    report = new Report(3200);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                    return !bl2;
                }
            }
            int n24 = 5;
            Infantry infantry2 = (Infantry)entity;
            n7 = infantry2.getShootingStrength() * 2;
            building = null;
            building = this.game.getBoard().getBuildingAt(coords);
            n6 = building != null ? building.getPhaseCF() / 10 : 0;
            n6 = Math.min(n6, n7);
            n7 -= n6;
            if (building != null && n6 > 0) {
                report = new Report(6435);
                report.subject = n9;
                report.add(n6);
                this.vPhaseReport.addElement(report);
                Report report3 = this.damageBuilding(building, n7);
                report3.subject = n9;
                this.vPhaseReport.addElement(report3);
            }
            Enumeration enumeration = this.game.getEntities(coords);
            while (enumeration.hasMoreElements()) {
                object2 = (Entity)enumeration.nextElement();
                if (((Entity)object2).getElevation() > 0) continue;
                for (n11 = n7; n11 > 0; n11 -= Math.min(n24, n11)) {
                    object = ((Entity)object2).rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                    Server.combineVectors(this.vPhaseReport, this.damageEntity((Entity)object2, (HitData)object, Math.min(n24, n11), false, 0, false, true, bl3));
                    Report.addNewline(this.vPhaseReport);
                }
            }
            for (int i = 0; i <= 5; ++i) {
                object2 = coords.translated(i);
                if (!this.game.getBoard().contains((Coords)object2) || coords.equals(object2)) continue;
                n7 = infantry2.getShootingStrength();
                building = null;
                building = this.game.getBoard().getBuildingAt((Coords)object2);
                n6 = building != null ? building.getPhaseCF() / 10 : 0;
                n6 = Math.min(n6, n7);
                n7 -= n6;
                if (building != null && n6 > 0) {
                    report = new Report(6435);
                    report.subject = n9;
                    report.add(n6);
                    this.vPhaseReport.addElement(report);
                    object = this.damageBuilding(building, n7);
                    ((Report)object).subject = n9;
                    this.vPhaseReport.addElement(object);
                }
                if ((object = this.game.getEntities((Coords)object2)).hasMoreElements()) {
                    report = new Report(3210);
                    report.newlines = 0;
                    report.subject = n9;
                    report.add(((Coords)object2).getBoardNum());
                    report.indent();
                    this.vPhaseReport.addElement(report);
                }
                while (object.hasMoreElements()) {
                    Entity entity5 = (Entity)object.nextElement();
                    if (entity5.getElevation() > 0) continue;
                    for (n11 = n7; n11 > 0; n11 -= Math.min(n24, n11)) {
                        HitData hitData = entity5.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                        Server.combineVectors(this.vPhaseReport, this.damageEntity(entity5, hitData, Math.min(n24, n11)));
                    }
                }
            }
            return !bl2;
        }
        if (targetable.getTargetType() == 6 || targetable.getTargetType() == 13) {
            Coords coords = targetable.getPosition();
            if (!bl2) {
                report = new Report(3190);
                report.subject = n9;
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
            } else {
                coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3195);
                    report.subject = n9;
                    report.add(coords.getBoardNum());
                    this.vPhaseReport.addElement(report);
                } else {
                    report = new Report(3200);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                    return !bl2;
                }
            }
            if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 262144L) {
                this.deliverThunderAugMinefield(coords, entity.getOwner().getId(), ammoType.getRackSize());
            } else if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 131072L) {
                this.deliverThunderMinefield(coords, entity.getOwner().getId(), ammoType.getRackSize());
            } else if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 524288L) {
                this.deliverThunderInfernoMinefield(coords, entity.getOwner().getId(), ammoType.getRackSize());
            } else if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 0x100000L) {
                this.deliverThunderVibraMinefield(coords, entity.getOwner().getId(), ammoType.getRackSize(), weaponResult.waa.getOtherAttackInfo());
            } else if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 0x200000L) {
                this.deliverThunderActiveMinefield(coords, entity.getOwner().getId(), ammoType.getRackSize());
            } else if (ammoType.getAmmoType() == 7 && ammoType.getMunitionType() == 8192L) {
                this.deliverFlare(coords, ammoType.getRackSize());
            }
            return !bl2;
        }
        if (targetable.getTargetType() == 8) {
            Coords coords = targetable.getPosition();
            if (!bl2) {
                report = new Report(3190);
                report.subject = n9;
                report.add(coords.getBoardNum(), true);
                this.vPhaseReport.addElement(report);
            } else {
                coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3195);
                    report.subject = n9;
                    report.add(coords.getBoardNum(), true);
                    this.vPhaseReport.addElement(report);
                } else {
                    report = new Report(3200);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                    return !bl2;
                }
            }
            if (this.game.getBoard().contains(coords)) {
                this.deliverFASCAMMinefield(coords, entity.getOwner().getId());
            }
            return !bl2;
        }
        if (targetable.getTargetType() == 10) {
            Coords coords = targetable.getPosition();
            if (!bl2) {
                report = new Report(3190);
                report.subject = n9;
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
            } else {
                coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3195);
                    report.subject = n9;
                    report.add(coords.getBoardNum());
                    this.vPhaseReport.addElement(report);
                } else {
                    report = new Report(3200);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                }
            }
            if (this.game.getBoard().contains(coords)) {
                this.deliverThunderVibraMinefield(coords, entity.getOwner().getId(), 20, weaponResult.waa.getOtherAttackInfo());
            }
            return !bl2;
        }
        if (targetable.getTargetType() == 9) {
            Coords coords = targetable.getPosition();
            if (!bl2) {
                report = new Report(3190);
                report.subject = n9;
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
            } else {
                coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3195);
                    report.subject = n9;
                    report.add(coords.getBoardNum(), true);
                    this.vPhaseReport.addElement(report);
                } else {
                    report = new Report(3200);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                    return !bl2;
                }
            }
            IHex iHex = this.game.getBoard().getHex(coords);
            if (!iHex.containsTerrain(7)) {
                report = new Report(3005);
                report.subject = n9;
                report.indent(2);
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
            }
            this.game.getBoard().addInfernoTo(coords, InfernoTracker.INFERNO_IV_ROUND, 1);
            this.sendChangedHex(coords);
            Enumeration enumeration = this.game.getEntities(coords);
            while (enumeration.hasMoreElements()) {
                Entity entity6 = (Entity)enumeration.nextElement();
                entity6.infernos.add(InfernoTracker.INFERNO_IV_ROUND, 1);
                report = new Report(3205);
                report.indent(2);
                report.subject = entity6.getId();
                report.addDesc(entity6);
                report.add(entity6.infernos.getTurnsLeftToBurn());
                this.vPhaseReport.addElement(report);
            }
            for (int i = 0; i <= 5; ++i) {
                Coords coords2 = coords.translated(i);
                if (!this.game.getBoard().contains(coords2) || coords.equals(coords2)) continue;
                iHex = this.game.getBoard().getHex(coords2);
                if (!iHex.containsTerrain(7)) {
                    report = new Report(3005);
                    report.subject = n9;
                    report.indent(2);
                    report.add(coords2.getBoardNum());
                    this.vPhaseReport.addElement(report);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                }
                this.game.getBoard().addInfernoTo(coords2, InfernoTracker.INFERNO_IV_ROUND, 1);
                this.sendChangedHex(coords2);
                Enumeration enumeration2 = this.game.getEntities(coords2);
                while (enumeration2.hasMoreElements()) {
                    Entity entity7 = (Entity)enumeration2.nextElement();
                    entity7.infernos.add(InfernoTracker.INFERNO_IV_ROUND, 1);
                    report = new Report(3205);
                    report.indent(2);
                    report.subject = entity7.getId();
                    report.addDesc(entity7);
                    report.add(entity7.infernos.getTurnsLeftToBurn());
                    this.vPhaseReport.addElement(report);
                }
            }
            return !bl2;
        }
        if (!(targetable.getTargetType() != 7 || bl5 && ammoType.getMunitionType() == 0x20000000L)) {
            Coords coords = targetable.getPosition();
            if (!bl2) {
                report = new Report(3190);
                report.subject = n9;
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
            } else {
                coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3195);
                    report.subject = n9;
                    report.add(coords.getBoardNum());
                    this.vPhaseReport.addElement(report);
                } else {
                    report = new Report(3200);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                    return !bl2;
                }
            }
            if (bl5 && ammoType.getMunitionType() == 8192L) {
                int n25 = ammoType.getAmmoType() == 15 ? 4 : (ammoType.getAmmoType() == 16 ? 3 : Math.max(1, ammoType.getRackSize() / 5));
                this.deliverArtilleryFlare(coords, n25);
                return !bl2;
            }
            int n26 = 5;
            n8 = weaponType.getRackSize();
            building = null;
            building = this.game.getBoard().getBuildingAt(coords);
            n7 = building != null ? building.getPhaseCF() / 10 : 0;
            n7 = Math.min(n7, n8);
            n8 -= n7;
            if (building != null && n7 > 0) {
                report = new Report(6425);
                report.subject = n9;
                report.add(n7);
                this.vPhaseReport.addElement(report);
                Report report4 = this.damageBuilding(building, n8);
                report4.subject = n9;
                this.vPhaseReport.addElement(report4);
            }
            Enumeration enumeration = this.game.getEntities(coords);
            block22: while (enumeration.hasMoreElements()) {
                Entity entity8 = (Entity)enumeration.nextElement();
                for (n11 = n8; n11 > 0; n11 -= Math.min(n26, n11)) {
                    if (weaponResult.artyAttackerCoords != null) {
                        toHitData.setSideTable(entity8.sideTable(weaponResult.artyAttackerCoords));
                    }
                    if (entity8.getMovementMode() == 6 && entity8.getElevation() != 0) continue block22;
                    object2 = entity8.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable(), weaponResult.waa.getAimedLocation(), weaponResult.waa.getAimingMode());
                    Server.combineVectors(this.vPhaseReport, this.damageEntity(entity8, (HitData)object2, Math.min(n26, n11), false, 0, false, true, bl3));
                    Report.addNewline(this.vPhaseReport);
                }
            }
            for (int i = 0; i <= 5; ++i) {
                Coords coords3 = coords.translated(i);
                if (!this.game.getBoard().contains(coords3) || coords.equals(coords3)) continue;
                n8 = weaponType.getRackSize() / 2;
                building = null;
                building = this.game.getBoard().getBuildingAt(coords3);
                n7 = building != null ? building.getPhaseCF() / 10 : 0;
                n7 = Math.min(n7, n8);
                n8 -= n7;
                if (building != null && n7 > 0) {
                    report = new Report(6425);
                    report.subject = n9;
                    report.add(n7);
                    this.vPhaseReport.addElement(report);
                    object2 = this.damageBuilding(building, n8);
                    ((Report)object2).subject = n9;
                    this.vPhaseReport.addElement(object2);
                }
                if ((object2 = this.game.getEntities(coords3)).hasMoreElements()) {
                    report = new Report(3210);
                    report.newlines = 0;
                    report.subject = n9;
                    report.add(coords3.getBoardNum());
                    report.indent();
                    this.vPhaseReport.addElement(report);
                }
                while (object2.hasMoreElements()) {
                    object = (Entity)object2.nextElement();
                    for (n11 = n8; n11 > 0; n11 -= Math.min(n26, n11)) {
                        HitData hitData = ((Entity)object).rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable(), weaponResult.waa.getAimedLocation(), weaponResult.waa.getAimingMode());
                        Server.combineVectors(this.vPhaseReport, this.damageEntity((Entity)object, hitData, Math.min(n26, n11)));
                    }
                }
            }
            return !bl2;
        }
        int n27 = 0;
        int n28 = weaponType.getDamage();
        if (bl2) {
            if (mounted.isRapidfire() && (!(targetable instanceof Infantry) || targetable instanceof BattleArmor)) {
                n28 = Compute.d6();
                n27 = 3 * n28;
                if (entity.getTotalAmmoOfType(mounted2.getType()) > 0) {
                    for (n8 = 0; n8 < n27; ++n8) {
                        if (mounted2.getShotsLeft() <= 0) {
                            entity.loadWeapon(mounted);
                            mounted2 = mounted.getLinked();
                        }
                        mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
                    }
                    if (entity instanceof Mech) {
                        entity.heatBuildup += n28;
                    }
                } else {
                    n11 = 0;
                }
            }
            if (!(weaponType.getAmmoType() != 11 && weaponType.getAmmoType() != 32 || bl19)) {
                report = new Report(3215);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
            } else {
                report = new Report(3220);
                report.subject = n9;
                if (mounted.isRapidfire() && (!(targetable instanceof Infantry) || targetable instanceof BattleArmor)) {
                    report.messageId = 3225;
                    report.add(n27);
                }
                this.vPhaseReport.addElement(report);
            }
            for (n8 = 0; n8 < weaponResult.amsShotDown.length; ++n8) {
                if (weaponResult.amsShotDown[n8] <= 0) continue;
                report = new Report(3230);
                report.indent();
                report.subject = n9;
                report.add(weaponResult.amsShotDown[n8]);
                this.vPhaseReport.addElement(report);
            }
            n8 = 0;
            if (bl5) {
                n8 = weaponType.getRackSize();
                if (weaponType.hasFlag(8192)) {
                    n8 *= 2;
                }
                if (entity instanceof BattleArmor) {
                    infantry = (Infantry)entity;
                    n8 *= infantry.getShootingStrength();
                }
            }
            if (bl16 || bl17) {
                n10 = n2 > 0 ? n2 : n8;
                int n29 = n8 = n2 > 0 ? n2 : n8;
            }
            if (bl5 && weaponResult.amsShotDownTotal >= n8 || toHitData.getValue() == 0x7FFFFFFE || (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 32) && !bl19) {
                return !bl2;
            }
            if ((bl16 || bl17) && entity2 != null) {
                n10 -= weaponResult.amsShotDownTotal;
                Entity entity9 = Compute.getSwarmTarget(this.game, entity.getId(), entity2, weaponResult.waa.getWeaponId());
                if (entity9 != null) {
                    report = new Report(3420);
                    report.subject = entity.getId();
                    report.indent();
                    report.add(n10);
                    this.vPhaseReport.addElement(report);
                    mounted.setUsedThisRound(false);
                    WeaponAttackAction weaponAttackAction = new WeaponAttackAction(entity.getId(), entity9.getTargetId(), weaponResult.waa.getWeaponId());
                    weaponAttackAction.setSwarmingMissiles(true);
                    weaponAttackAction.setOldTargetId(targetable.getTargetId());
                    weaponAttackAction.setAmmoId(weaponResult.waa.getAmmoId());
                    WeaponResult weaponResult3 = this.preTreatWeaponAttack(weaponAttackAction);
                    this.resolveWeaponAttack(weaponResult3, entity.getId(), false, n10);
                } else {
                    report = new Report(3425);
                    report.subject = entity.getId();
                    report.indent();
                    this.vPhaseReport.addElement(report);
                }
            }
            if (entity2 != null && (bl7 || building == null && weaponType.getFireTN() != Integer.MAX_VALUE)) {
                this.tryIgniteHex(targetable.getPosition(), entity.getId(), bl7, 11);
            }
            if (!(bl21 || bl5 && ammoType.getMunitionType() == 0x20000000L)) {
                return !bl2;
            }
        }
        if (!bl2 && weaponType.getAmmoType() == 13 && ammoType.getMunitionType() != 0x10000000L) {
            if (weaponResult.amsShotDownTotal > 0) {
                report = new Report(3235);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
                for (n8 = 0; n8 < weaponResult.amsShotDown.length; ++n8) {
                    report = new Report(3230);
                    report.indent(1);
                    report.subject = n9;
                    report.add(weaponResult.amsShotDown[n8]);
                    this.vPhaseReport.addElement(report);
                }
                report = new Report(3240);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
            } else if (entity2 == null) {
                report = new Report(3245);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
            } else {
                entity2.setNarcedBy(entity.getOwner().getTeam());
                report = new Report(3250);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
            }
            return !bl2;
        }
        if (!bl2 && weaponType.getAmmoType() == 31 && ammoType.getMunitionType() != 0x1000000L) {
            if (weaponResult.amsShotDownTotal > 0) {
                report = new Report(3235);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
                for (n8 = 0; n8 < weaponResult.amsShotDown.length; ++n8) {
                    report = new Report(3230);
                    report.indent(1);
                    report.subject = n9;
                    report.add(weaponResult.amsShotDown[n8]);
                    this.vPhaseReport.addElement(report);
                }
                report = new Report(3240);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
            } else if (entity2 == null) {
                report = new Report(3245);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
            } else {
                INarcPod iNarcPod = null;
                if (ammoType.getMunitionType() == 0x2000000L) {
                    iNarcPod = new INarcPod(entity.getOwner().getTeam(), 2);
                    report = new Report(3251);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                } else if (ammoType.getMunitionType() == 0x4000000L) {
                    iNarcPod = new INarcPod(entity.getOwner().getTeam(), 4);
                    report = new Report(3252);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                } else if (ammoType.getMunitionType() == 0x8000000L) {
                    iNarcPod = new INarcPod(entity.getOwner().getTeam(), 8);
                    report = new Report(3253);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                } else {
                    iNarcPod = new INarcPod(entity.getOwner().getTeam(), 1);
                    report = new Report(3254);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                }
                entity2.attachINarcPod(iNarcPod);
            }
            return !bl2;
        }
        if (!bl2 && targetable.getTargetType() == 5) {
            n8 = Compute.d6(2);
            if (n8 >= 5) {
                report = new Report(3255);
                report.indent(1);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
                Coords coords = targetable.getPosition();
                Enumeration enumeration = this.game.getMinefields(coords).elements();
                while (enumeration.hasMoreElements()) {
                    Minefield minefield = (Minefield)enumeration.nextElement();
                    this.removeMinefield(minefield);
                }
            } else {
                report = new Report(3260);
                report.indent(1);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
            }
            return !bl2;
        }
        n8 = 1;
        n7 = 0;
        n6 = 0;
        n5 = 0;
        boolean bl27 = false;
        boolean bl28 = false;
        String string = " shot(s) ";
        boolean bl29 = false;
        int n30 = entity.getPosition().distance(targetable.getPosition());
        int n31 = 0;
        boolean bl30 = this.game.getOptions().booleanOption("maxtech_mslhitpen");
        if (bl30) {
            n31 = n30 <= 1 ? 1 : (n30 <= weaponType.getShortRange() ? 0 : (n30 <= weaponType.getMediumRange() ? -1 : -2));
        }
        if ((weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 32) && !bl19 || weaponType.getAmmoType() == 13 || entity.getSwarmTargetId() == weaponResult.waa.getTargetId() || (targetable.getTargetType() == 4 || targetable.getTargetType() == 3) && entity.getPosition().distance(targetable.getPosition()) <= 1) {
            bl29 = true;
        }
        if (!bl2 && "SwarmMek".equals(weaponType.getInternalName())) {
            if (-1 != entity2.getSwarmAttackerId()) {
                report = new Report(3265);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
            } else if (entity2.isDoomed() || entity2.isDestroyed() || entity2.getCrew().isDead()) {
                report = new Report(3270);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
            } else {
                report = new Report(3275);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
                entity.setSwarmTargetId(weaponResult.waa.getTargetId());
                entity2.setSwarmAttackerId(weaponResult.waa.getEntityId());
            }
            return !bl2;
        }
        if (weaponType.getInternalName().equals("BAMineLauncher")) {
            n11 = n16;
            if (!bl29) {
                n11 = Compute.getBattleArmorHits(n11);
            }
            n6 = 1;
            string = " mine(s) ";
        } else if (bl6) {
            n6 = 1;
            infantry = (Infantry)entity;
            n8 = 1;
            if (bl5) {
                n28 = ammoType.getDamagePerShot();
            }
            n28 = weaponType.getRackSize();
            n11 = infantry.getShootingStrength();
            if (!bl29) {
                n11 = Compute.getBattleArmorHits(n11);
            }
            if (bl7) {
                n8 = n11;
                n28 = 0;
                string = " Inferno missle(s) ";
                n6 = 0;
            }
            if (entity.getSwarmTargetId() == weaponResult.waa.getTargetId()) {
                n28 += ((BattleArmor)entity).getVibroClawDamage();
            }
        } else if (bl4) {
            n6 = 1;
            infantry = (Infantry)entity;
            n8 = 5;
            n28 = 1;
            n11 = infantry.getDamage(infantry.getShootingStrength());
            string = " damage are inflicted by the shots that ";
            if (bl7) {
                n8 = n11;
                n28 = 0;
                string = " Inferno missile(s) ";
                n6 = 0;
            }
        } else if (weaponType.getDamage() == -2 || weaponType.hasFlag(16384)) {
            n6 = 1;
            if (weaponType.getAmmoType() == -2 || weaponType.getAmmoType() == -3) {
                n28 = Math.abs(weaponType.getAmmoType());
            } else {
                string = " missile(s) ";
                n28 = ammoType.getDamagePerShot();
            }
            if (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 32 || weaponType.getAmmoType() == 12 || weaponType.getAmmoType() == 29 || weaponType.getAmmoType() == 30) {
                n8 = 5;
            }
            if (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 9 || weaponType.getAmmoType() == 29) {
                mounted3 = mounted.getLinkedBy();
                if (weaponType.getAmmoType() == 29 || mounted3 != null && mounted3.getType() instanceof MiscType && !mounted3.isDestroyed() && !mounted3.isMissing() && !mounted3.isBreached() && mounted3.getType().hasFlag(512) && ammoType.getMunitionType() == 2048L) {
                    if (n5 == 0) {
                        if (entity instanceof Mech) {
                            bl28 = entity.isStealthActive();
                        }
                        bl27 = Compute.isAffectedByECM(entity, entity.getPosition(), targetable.getPosition());
                        n5 = 1;
                    }
                    if (!(bl27 || bl28 || mounted.getType().hasModes() && mounted.curMode().equals("Indirect") || (ammoType.getAmmoType() != 29 || ammoType.getMunitionType() != 0L && ammoType.getMunitionType() != 32L && ammoType.getMunitionType() != 64L) && (ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 2048L))) {
                        n7 += 2;
                    }
                } else if (entity2 != null && (entity2.isNarcedBy(entity.getOwner().getTeam()) || entity2.isINarcedBy(entity.getOwner().getTeam()))) {
                    if (n5 == 0) {
                        if (entity instanceof Mech) {
                            bl28 = entity.isStealthActive();
                        }
                        bl27 = Compute.isAffectedByECM(entity, entity.getPosition(), targetable.getPosition());
                        n5 = 1;
                    }
                    if (!(bl27 || bl28 || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 1024L)) {
                        n7 += 2;
                    }
                }
            }
            if (bl7) {
                n28 = 0;
                n7 = 0;
                string = " inferno missile(s) ";
                n6 = 0;
            }
            if (bl16) {
                string = " swarm missile(s) ";
            }
            if (bl17) {
                string = " swarm-I missile(s) ";
            }
            if (bl15) {
                string = " anti-TSM missile(s) ";
            }
            if (bl8) {
                string = " fragmentation missile(s) ";
            }
            if (bl9) {
                n28 = 1;
                n7 = -2;
                string = " acid-head missile(s) ";
            }
            if (weaponType.getRackSize() == 30 || weaponType.getRackSize() == 40) {
                n11 = Compute.missilesHit(weaponType.getRackSize() / 2, n31 + n12, bl30 | bl20) + Compute.missilesHit(weaponType.getRackSize() / 2, n31 + n12, bl30 | bl20);
            } else if (entity instanceof BattleArmor) {
                infantry = (Infantry)entity;
                if (bl29) {
                    n11 = n4;
                } else {
                    n11 = 0;
                    for (n4 = weaponType.getRackSize() * infantry.getShootingStrength(); n4 > 20; n4 -= 20) {
                        n11 += Compute.missilesHit(20, n31 + n12, bl30 | bl20);
                    }
                    n11 += Compute.missilesHit(n4, n31 + n12, bl30 | bl20);
                }
            } else if (bl29) {
                n11 = weaponType.getRackSize();
            } else {
                n11 = Compute.missilesHit(weaponType.getRackSize(), n7 + n31 + n12, bl30 | bl20);
                if ((bl16 || bl17) && n2 == 0) {
                    n10 = weaponType.getRackSize() - n11;
                }
            }
            if (bl15) {
                n11 = (int)Math.ceil((double)n11 / 2.0);
            }
            if ((bl16 || bl17) && n2 > 0) {
                n4 = 5;
                if (n2 > 5 && n2 <= 10) {
                    n4 = 10;
                } else if (n2 > 10 && n2 <= 15) {
                    n4 = 15;
                } else if (n2 > 15 && n2 <= 20) {
                    n4 = 20;
                }
                n11 = Compute.missilesHit(n4, n7 + n31 + n12, bl30 | bl20);
                if (n11 > n2) {
                    n11 = n2;
                }
                n10 = n2 - n11;
            }
            if (bl5 && ammoType.getAmmoType() == 24) {
                n4 = weaponType.getRackSize() * infantry.getShootingStrength();
                if (n11 % 2 == 1 && n11 < n4) {
                    ++n11;
                }
            }
        } else if (bl5 && (ammoType.getAmmoType() == 19 || ammoType.getAmmoType() == 33) && ammoType.getMunitionType() == 1L) {
            n6 = 1;
            n11 = weaponType.getRackSize();
            int n32 = n4 = weaponType.hasFlag(0x400000) ? 0 : -1;
            if (!bl29) {
                n11 = !bl20 ? Compute.missilesHit(n11, n4) : Compute.missilesHit(n11, n4) / 2;
            }
            n28 = 1;
        } else if (n16 > 1) {
            n6 = 1;
            n11 = n16;
            if (!bl29) {
                n11 = Compute.missilesHit(n11);
            }
        } else if (weaponType.getAmmoType() == 22) {
            n28 = n30 <= weaponType.getShortRange() ? 25 : (n30 <= weaponType.getMediumRange() ? 20 : 10);
        } else if (weaponType.hasFlag(262144)) {
            n28 = weaponType.getDamage();
            if (this.game.getOptions().booleanOption("maxtech_altdmg")) {
                if (n30 <= 1) {
                    ++n28;
                } else if (n30 > weaponType.getMediumRange()) {
                    if (n30 <= weaponType.getLongRange()) {
                        --n28;
                    } else if (n30 <= weaponType.getExtremeRange()) {
                        n28 = (int)Math.floor((double)n28 / 2.0);
                    }
                }
            }
        } else if (mounted.isRapidfire() && (!(targetable instanceof Infantry) || targetable instanceof BattleArmor)) {
            n28 = Compute.d6();
            n27 = 3 * n28;
            if (entity.getTotalAmmoOfType(mounted2.getType()) > 0) {
                for (n4 = 0; n4 < n27; ++n4) {
                    if (mounted2.getShotsLeft() <= 0) {
                        entity.loadWeapon(mounted);
                        mounted2 = mounted.getLinked();
                    }
                    mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
                }
                if (entity instanceof Mech) {
                    entity.heatBuildup += n28;
                }
            } else {
                n11 = 0;
            }
        }
        if (weaponType.hasFlag(4) && weaponType.hasFlag(0x400000)) {
            entity.heatBuildup += Compute.d6();
        }
        if (bl14) {
            --n28;
        }
        if (bl20 && !weaponType.hasFlag(524288) && !weaponType.hasFlag(16384) && (!bl5 || ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 33 || ammoType.getMunitionType() != 1L)) {
            n28 = (int)Math.floor((double)n28 / 2.0);
        }
        if (weaponType.hasFlag(8192)) {
            n11 *= 2;
        }
        if (bl5 && ammoType.getMunitionType() == 0x20000000L) {
            n28 = weaponType.getRackSize();
            if (entity2 != null && entity2.getTaggedBy() != -1) {
                if (weaponResult.artyAttackerCoords != null) {
                    toHitData.setSideTable(entity2.sideTable(weaponResult.artyAttackerCoords));
                } else {
                    Entity entity10 = this.game.getEntity(entity2.getTaggedBy());
                    if (entity10 != null) {
                        toHitData.setSideTable(Compute.targetSideTable(entity10, entity2));
                    }
                }
            }
        }
        if (bl2) {
            if (bl21 && building != null && !bl16 && !bl17) {
                if (weaponResult.amsShotDownTotal > 0) {
                    for (int i = 0; i < weaponResult.amsShotDown.length; ++i) {
                        int n33 = Math.min(weaponResult.amsShotDown[i], n11);
                        report = new Report(3280);
                        report.indent(1);
                        report.subject = n9;
                        report.add(n33);
                        this.vPhaseReport.addElement(report);
                    }
                    n11 -= weaponResult.amsShotDownTotal;
                }
                if (bl7 && n11 > 0) {
                    Coords coords = targetable.getPosition();
                    IHex iHex = this.game.getBoard().getHex(coords);
                    if (iHex.containsTerrain(7)) {
                        report = new Report(3285);
                        report.indent(2);
                        report.subject = n9;
                        report.add(n11);
                        report.add(coords.getBoardNum());
                        this.vPhaseReport.addElement(report);
                    } else {
                        report = new Report(3290);
                        report.indent(2);
                        report.subject = n9;
                        report.add(n11);
                        report.add(coords.getBoardNum());
                        this.vPhaseReport.addElement(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, n11);
                    this.sendChangedHex(coords);
                } else {
                    int n34 = n11 * n28;
                    if (n34 > 0) {
                        Report report5 = this.damageBuilding(building, n34);
                        report5.indent(2);
                        report5.newlines = 1;
                        report5.subject = n9;
                        this.vPhaseReport.addElement(report5);
                    }
                }
            }
            return !bl2;
        }
        int n35 = 0;
        if (bl21 && building != null) {
            n35 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
        }
        if (!bl4 && entity.getSwarmTargetId() == weaponResult.waa.getTargetId()) {
            n8 = n11;
        }
        if (weaponType.getAmmoType() == -2 && targetable instanceof Infantry && !(targetable instanceof BattleArmor)) {
            if (n35 > 0) {
                int n36 = n28 * n11;
                report = new Report(3295);
                report.newlines = 0;
                report.subject = n9;
                report.add(n11);
                report.add(string);
                this.vPhaseReport.addElement(report);
                Report report6 = this.damageBuilding(building, Math.min(n36, n35), " absorbs the shots, taking ");
                report6.newlines = 1;
                report6.subject = n9;
                this.vPhaseReport.addElement(report6);
                return !bl2;
            }
            n28 = Compute.d6(n11);
            report = new Report(3300);
            report.newlines = 0;
            report.subject = n9;
            report.add(n28);
            report.add(string);
            this.vPhaseReport.addElement(report);
            n11 = 1;
        } else if (bl5 && ammoType.hasFlag(1) && !bl4 && targetable instanceof Infantry && !(targetable instanceof BattleArmor) && !mounted.isRapidfire()) {
            n3 = weaponType.getDamage();
            if (n28 <= n35) {
                int n37 = n28 * n11;
                int n38 = building.getCurrentCF();
                n38 = Math.min(n38, n37);
                building.setCurrentCF(n38);
                if (n6 != 0) {
                    report = new Report(3305);
                    report.subject = n9;
                    report.add(n11);
                    report.add(string);
                    this.vPhaseReport.addElement(report);
                } else {
                    report = new Report(3310);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                }
                report = new Report(3315);
                report.indent(2);
                report.subject = n9;
                this.vPhaseReport.addElement(report);
                Report report7 = this.damageBuilding(building, Math.min(n37, n35), " absorbs the shots, taking ");
                report7.newlines = 1;
                report7.subject = n9;
                this.vPhaseReport.addElement(report7);
                return !bl2;
            }
            if (n35 > 0) {
                n3 -= n35;
            }
            n28 = Compute.d6(n3);
            report = new Report(3320);
            report.subject = n9;
            report.add(n28);
            report.add(string);
            this.vPhaseReport.addElement(report);
            n6 = 1;
            if (n35 > 0) {
                Report report8 = this.damageBuilding(building, n35);
                report8.indent(2);
                report8.subject = n9;
                this.vPhaseReport.addElement(report8);
                n35 = 0;
            }
        } else if (n6 != 0 && !bl7) {
            report = new Report(3325);
            report.subject = n9;
            report.add(n11);
            report.add(string);
            report.add(toHitData.getTableDesc());
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (bl27) {
                report = new Report(3330);
                report.subject = n9;
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            } else if (bl28) {
                report = new Report(3335);
                report.subject = n9;
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
            if (n7 > 0) {
                report = new Report(3340);
                report.subject = n9;
                report.add(n7);
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
            report = new Report(3345);
            report.subject = n9;
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (weaponResult.amsShotDownTotal > 0) {
                for (n3 = 0; n3 < weaponResult.amsShotDown.length; ++n3) {
                    int n39 = Math.min(weaponResult.amsShotDown[n3], n11);
                    report = new Report(3350);
                    report.indent();
                    report.subject = n9;
                    report.add(weaponResult.amsShotDown[n3]);
                    report.add(n39);
                    report.newlines = 0;
                    this.vPhaseReport.addElement(report);
                }
                Report.addNewline(this.vPhaseReport);
                if ((n11 -= weaponResult.amsShotDownTotal) < 1) {
                    report = new Report(3355);
                    report.indent();
                    report.subject = n9;
                    report.newlines = 0;
                    this.vPhaseReport.addElement(report);
                } else {
                    report = new Report(3360);
                    report.indent();
                    report.subject = n9;
                    report.add(n11);
                    report.newlines = 0;
                    this.vPhaseReport.addElement(report);
                }
            }
        }
        if (weaponType.getAmmoType() == 29) {
            n11 = n28 * n11;
            n28 = 1;
        }
        if (n11 == 0) {
            report = new Report(3365);
            report.subject = n9;
            this.vPhaseReport.addElement(report);
        }
        while (n11 > 0) {
            if (bl7) {
                if (weaponResult.amsShotDownTotal > 0) {
                    for (int i = 0; i < weaponResult.amsShotDown.length; ++i) {
                        int n40 = Math.min(weaponResult.amsShotDown[i], n11);
                        report = new Report(3350);
                        report.indent();
                        report.subject = n9;
                        report.add(weaponResult.amsShotDown[i]);
                        report.add(n40);
                        report.newlines = 0;
                        this.vPhaseReport.addElement(report);
                    }
                    Report.addNewline(this.vPhaseReport);
                    if ((n11 -= weaponResult.amsShotDownTotal) < 1) {
                        report = new Report(3355);
                        report.indent();
                        report.subject = n9;
                        report.newlines = 0;
                        this.vPhaseReport.addElement(report);
                    } else {
                        report = new Report(3360);
                        report.indent();
                        report.subject = n9;
                        report.add(n11);
                        report.newlines = 0;
                        this.vPhaseReport.addElement(report);
                    }
                    if (n11 <= 0) continue;
                }
                if (targetable.getTargetType() == 2 || targetable.getTargetType() == 4) {
                    report = new Report(3370);
                    report.subject = n9;
                    report.add(n11);
                    this.vPhaseReport.addElement(report);
                    Coords coords = targetable.getPosition();
                    IHex iHex = this.game.getBoard().getHex(coords);
                    if (!iHex.containsTerrain(7)) {
                        report = new Report(3005);
                        report.subject = n9;
                        report.add(coords.getBoardNum());
                        this.vPhaseReport.addElement(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, n11);
                    this.sendChangedHex(coords);
                    return !bl2;
                }
                if (entity2 != null) {
                    report = new Report(3375);
                    report.subject = n9;
                    report.add(n11);
                    this.vPhaseReport.addElement(report);
                    if (this.game.getOptions().booleanOption("vehicle_fires") && entity2 instanceof Tank) {
                        this.checkForVehicleFire((Tank)entity2, true);
                    } else {
                        entity2.infernos.add(InfernoTracker.STANDARD_ROUND, n11);
                        report = new Report(3205);
                        report.indent(2);
                        report.subject = n9;
                        report.addDesc(entity2);
                        report.add(entity2.infernos.getTurnsLeftToBurn());
                        this.vPhaseReport.addElement(report);
                    }
                    Coords coords = targetable.getPosition();
                    IHex iHex = this.game.getBoard().getHex(coords);
                    if (!iHex.containsTerrain(7)) {
                        report = new Report(3005);
                        report.subject = n9;
                        report.add(coords.getBoardNum());
                        this.vPhaseReport.addElement(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
                    this.sendChangedHex(coords);
                    return !bl2;
                }
            }
            if (targetable.getTargetType() == 2 || targetable.getTargetType() == 4) {
                if (n6 == 0) {
                    report = new Report(2270);
                    report.subject = n9;
                    report.newlines = 0;
                    this.vPhaseReport.addElement(report);
                }
                int n41 = weaponType.getFireTN();
                if (bl13) {
                    n41 = 5;
                }
                if (n41 != Integer.MAX_VALUE) {
                    if (building != null) {
                        n41 += building.getType() - 1;
                    }
                    Report.addNewline(this.vPhaseReport);
                    this.tryIgniteHex(targetable.getPosition(), entity.getId(), bl7, n41, true);
                }
                return !bl2;
            }
            if (targetable.getTargetType() == 1) {
                n3 = n28 * n11;
                if (n6 == 0) {
                    report = new Report(2270);
                    report.subject = n9;
                    report.newlines = 0;
                    this.vPhaseReport.addElement(report);
                }
                if (entity instanceof Infantry) {
                    report = new Report(3380);
                    report.indent();
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                    return !bl2;
                }
                report = new Report(3385);
                report.indent();
                report.subject = n9;
                report.add(n3);
                this.vPhaseReport.addElement(report);
                if (building == null) {
                    boolean bl31 = this.game.getBoard().getHex(targetable.getPosition()).containsTerrain(7);
                    boolean bl32 = this.tryIgniteHex(targetable.getPosition(), n9, bl7, 9);
                    if (!bl31 && bl32) {
                        return !bl2;
                    }
                }
                int n42 = 14 - n3;
                this.tryClearHex(targetable.getPosition(), n42, entity.getId());
                return !bl2;
            }
            if (targetable.getTargetType() == 3) {
                n3 = n28 * n11;
                if (n6 == 0) {
                    report = new Report(3390);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                }
                Report.addNewline(this.vPhaseReport);
                Report report9 = this.damageBuilding(building, n3);
                report9.indent(2);
                report9.newlines = 1;
                report9.subject = n9;
                this.vPhaseReport.addElement(report9);
                this.damageInfantryIn(building, n3);
                return !bl2;
            }
            if (weaponType.hasFlag(2) && targetable instanceof BattleArmor) {
                Enumeration enumeration = entity2.getMisc();
                while (enumeration.hasMoreElements()) {
                    Mounted mounted4 = (Mounted)enumeration.nextElement();
                    EquipmentType equipmentType = mounted4.getType();
                    if (!"BA-Fire Resistant Armor".equals(equipmentType.getInternalName())) continue;
                    if (n6 == 0) {
                        report = new Report(3390);
                        report.subject = n9;
                        this.vPhaseReport.addElement(report);
                    }
                    report = new Report(3395);
                    report.indent(2);
                    report.subject = n9;
                    report.addDesc(entity2);
                    this.vPhaseReport.addElement(report);
                    if (n35 > 0) {
                        int n43 = n28 * Math.min(n35, n11);
                        Report report10 = this.damageBuilding(building, n43);
                        report10.indent(2);
                        report10.newlines = 1;
                        report10.subject = n9;
                        this.vPhaseReport.addElement(report10);
                    }
                    return !bl2;
                }
            }
            if (entity2 != null && entity2 instanceof Mech && weaponType.hasFlag(2) && this.game.getOptions().booleanOption("flamer_heat") && weaponType.hasModes() && mounted.curMode().equals("Heat")) {
                n3 = n28 * n11;
                if (n6 == 0) {
                    report = new Report(3390);
                    report.subject = n9;
                    this.vPhaseReport.addElement(report);
                }
                report = new Report(3400);
                report.subject = n9;
                report.indent(2);
                report.add(n3);
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
                entity2.heatBuildup += n3;
                n11 = 0;
                continue;
            }
            if (entity2 != null) {
                HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable(), weaponResult.waa.getAimedLocation(), weaponResult.waa.getAimingMode());
                if (weaponType.hasFlag(0x20000000) && entity2 instanceof Mech) {
                    n3 = n28 * n11;
                    if (n6 == 0) {
                        report = new Report(3390);
                        report.subject = n9;
                        this.vPhaseReport.addElement(report);
                    }
                    report = new Report(3400);
                    report.subject = n9;
                    report.indent(2);
                    report.add(5);
                    report.newlines = 0;
                    this.vPhaseReport.addElement(report);
                    entity2.heatBuildup += 5;
                }
                if (weaponType.getInternalName().equals("LegAttack") && entity2.getInternal(hitData) <= 0) {
                    hitData = hitData.getLocation() == 6 ? new HitData(7) : new HitData(6);
                }
                if (weaponType.getInternalName().equals("BAMineLauncher")) {
                    hitData = targetable instanceof Mech ? new HitData(1) : new HitData(1);
                }
                if (n6 == 0) {
                    report = new Report(3405);
                    report.subject = n9;
                    report.add(toHitData.getTableDesc());
                    report.add(entity2.getLocationAbbr(hitData));
                    report.newlines = 0;
                    this.vPhaseReport.addElement(report);
                    if (hitData.hitAimedLocation()) {
                        report = new Report(3410);
                        report.subject = n9;
                        report.newlines = 0;
                        this.vPhaseReport.addElement(report);
                    }
                }
                if (n28 == -4) {
                    Vector vector = this.criticalEntity(entity2, hitData.getLocation());
                    if (((Report)vector.lastElement()).messageId == 6005) {
                        int n44 = 4;
                        if (entity instanceof BattleArmor) {
                            n44 += ((BattleArmor)entity).getVibroClawDamage();
                        }
                        vector = this.damageEntity(entity2, hitData, n44, false, 0, false, false, bl3);
                    } else {
                        try {
                            ++((Report)vector.elementAt((int)(vector.size() - 2))).newlines;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            System.err.println("ERROR: no previous report when trying to add newline");
                        }
                    }
                    Server.combineVectors(this.vPhaseReport, vector);
                } else if (this.game.getOptions().booleanOption("maxtech_partial_cover") && toHitData.getHitTable() == 6 && entity2.removePartialCoverHits(hitData.getLocation(), toHitData.getCover(), toHitData.getSideTable())) {
                    report = new Report(3460);
                    report.subject = entity2.getId();
                    report.indent(2);
                    report.add(entity2.getDisplayName());
                    report.add(entity2.getLocationAbbr(hitData));
                    report.newlines = 0;
                    this.vPhaseReport.addElement(report);
                } else {
                    n3 = n28 * Math.min(n8, n11);
                    if (n35 > 0) {
                        int n45 = Math.min(n35, n3);
                        n3 -= n45;
                        Report.addNewline(this.vPhaseReport);
                        Report report11 = this.damageBuilding(building, n45);
                        report11.indent(2);
                        report11.subject = n9;
                        this.vPhaseReport.addElement(report11);
                    }
                    if (n3 == 0) {
                        report = new Report(3415);
                        report.subject = n9;
                        report.indent(2);
                        report.addDesc(entity2);
                        report.newlines = 0;
                        this.vPhaseReport.addElement(report);
                    } else if (bl8) {
                        if (bl20) {
                            hitData.makeGlancingBlow();
                        }
                        Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n3, false, 1, false, false, bl3));
                    } else if (bl10) {
                        if (bl20) {
                            hitData.makeGlancingBlow();
                        }
                        Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n3, false, 2, false, false, bl3));
                    } else if (bl9) {
                        if (bl20) {
                            hitData.makeGlancingBlow();
                        }
                        Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n3, false, 3, false, false, bl3));
                    } else if (bl13 && bl5 && ammoType.getAmmoType() == 1) {
                        if (bl20) {
                            hitData.makeGlancingBlow();
                        }
                        Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n3, false, 4, false, false, bl3));
                    } else {
                        if (bl5 && ammoType.getAmmoType() == 1 && ammoType.getMunitionType() == 2L) {
                            hitData.makeArmorPiercing(ammoType);
                        }
                        if (bl20) {
                            hitData.makeGlancingBlow();
                        }
                        if (bl15) {
                            entity2.hitThisRoundByAntiTSM = true;
                        }
                        Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n3, false, 0, false, false, bl3));
                    }
                }
                n11 -= n8;
                this.creditKill(entity2, entity);
                continue;
            }
            System.err.println("Unable to resolve hit against " + targetable.getDisplayName());
            if (entity2 == null) {
                System.err.println("   entityTarget is null");
            }
            n11 = 0;
        }
        if (ammoType != null && ammoType.getMunitionType() == 0x20000000L) {
            Coords coords = targetable.getPosition();
            int n46 = 5;
            building = null;
            building = this.game.getBoard().getBuildingAt(coords);
            n35 = building != null ? building.getPhaseCF() / 10 : 0;
            n35 = Math.min(n35, n46);
            n46 -= n35;
            if (building != null && n35 > 0) {
                report = new Report(6010);
                if (entity2 != null) {
                    report.subject = entity2.getId();
                }
                report.add(n35);
                this.vPhaseReport.addElement(report);
                Report report12 = this.damageBuilding(building, n46);
                report12.indent(2);
                if (entity2 != null) {
                    report12.subject = entity2.getId();
                }
                this.vPhaseReport.addElement(report12);
            }
            if (n46 > 0) {
                Enumeration enumeration = this.game.getEntities(coords);
                while (enumeration.hasMoreElements()) {
                    Object object4;
                    Entity entity11 = (Entity)enumeration.nextElement();
                    if (!bl2 && entity11 == entity2) continue;
                    if (weaponResult.artyAttackerCoords != null) {
                        toHitData.setSideTable(entity11.sideTable(weaponResult.artyAttackerCoords));
                    } else if (entity2.getTaggedBy() != -1 && (object4 = this.game.getEntity(entity2.getTaggedBy())) != null) {
                        toHitData.setSideTable(Compute.targetSideTable((Entity)object4, entity2));
                    }
                    object4 = entity11.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable(), weaponResult.waa.getAimedLocation(), weaponResult.waa.getAimingMode());
                    Server.combineVectors(this.vPhaseReport, this.damageEntity(entity11, (HitData)object4, n46, false, 0, false, true, bl3));
                }
            }
        }
        Report.addNewline(this.vPhaseReport);
        if (n10 > 0 && entity2 != null) {
            Entity entity12 = Compute.getSwarmTarget(this.game, entity.getId(), entity2, weaponResult.waa.getWeaponId());
            if (entity12 != null) {
                report = new Report(3420);
                report.subject = entity12.getId();
                report.indent();
                report.add(n10);
                this.vPhaseReport.addElement(report);
                mounted.setUsedThisRound(false);
                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(entity.getId(), entity12.getTargetId(), weaponResult.waa.getWeaponId());
                weaponAttackAction.setSwarmingMissiles(true);
                weaponAttackAction.setOldTargetId(targetable.getTargetId());
                weaponAttackAction.setAmmoId(weaponResult.waa.getAmmoId());
                WeaponResult weaponResult4 = this.preTreatWeaponAttack(weaponAttackAction);
                this.resolveWeaponAttack(weaponResult4, entity.getId(), false, n10);
            } else {
                report = new Report(3425);
                report.subject = entity.getId();
                report.indent();
                this.vPhaseReport.addElement(report);
            }
        }
        return !bl2;
    }

    private void resolvePhysicalAttacks() {
        Object object;
        Object object2;
        this.vPhaseReport.addElement(new Report(4000, 0));
        Enumeration enumeration = this.game.getCharges();
        while (enumeration.hasMoreElements()) {
            this.game.addAction((EntityAction)enumeration.nextElement());
        }
        this.game.resetCharges();
        this.cleanupPhysicalAttacks();
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = (AttackAction)object2;
            if (!this.game.getEntity(object.getEntityId()).isActive() && !(object2 instanceof DfaAttackAction)) continue;
            AbstractAttackAction abstractAttackAction = (AbstractAttackAction)object2;
            if (abstractAttackAction instanceof SearchlightAttackAction) {
                SearchlightAttackAction searchlightAttackAction = (SearchlightAttackAction)abstractAttackAction;
                Server.combineVectors(this.vPhaseReport, searchlightAttackAction.resolveAction(this.game));
                continue;
            }
            this.physicalResults.addElement(this.preTreatPhysicalAttack(abstractAttackAction));
        }
        int n = -1;
        object2 = this.physicalResults.elements();
        while (object2.hasMoreElements()) {
            object = (PhysicalResult)object2.nextElement();
            this.resolvePhysicalAttack((PhysicalResult)object, n);
            n = ((PhysicalResult)object).aaa.getEntityId();
        }
        this.physicalResults.removeAllElements();
    }

    private void cleanupPhysicalAttacks() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            this.removeDuplicateAttacks(entity.getId());
        }
        this.removeDeadAttacks();
    }

    private void removeDuplicateAttacks(int n) {
        boolean bl = false;
        Vector<EntityAction> vector = new Vector<EntityAction>();
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            if (entityAction.getEntityId() != n) {
                vector.addElement(entityAction);
                continue;
            }
            if (!bl) {
                vector.addElement(entityAction);
                if (entityAction instanceof SearchlightAttackAction) continue;
                bl = true;
                continue;
            }
            System.err.println("server: removing duplicate phys attack for id#" + n);
            System.err.println("        action was " + entityAction.toString());
        }
        this.game.resetActions();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.game.addAction((EntityAction)enumeration.nextElement());
        }
    }

    private void removeDeadAttacks() {
        Vector<EntityAction> vector = new Vector<EntityAction>(this.game.actionsSize());
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            Entity entity = this.game.getEntity(entityAction.getEntityId());
            if (entity == null || entity.isDestroyed() || !entity.isActive() && !(entityAction instanceof DfaAttackAction)) continue;
            vector.addElement(entityAction);
        }
        this.game.resetActions();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.game.addAction((EntityAction)enumeration.nextElement());
        }
    }

    private void resolvePunchAttack(PhysicalResult physicalResult, int n) {
        Report report;
        PunchAttackAction punchAttackAction = (PunchAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(punchAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(punchAttackAction.getTargetType(), punchAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, punchAttackAction.getEntityId(), entity2);
        }
        String string = punchAttackAction.getArm() == 1 ? "Left Arm" : "Right Arm";
        int n2 = punchAttackAction.getArm() == 1 ? physicalResult.damage : physicalResult.damageRight;
        ToHitData toHitData = punchAttackAction.getArm() == 1 ? physicalResult.toHit : physicalResult.toHitRight;
        int n3 = punchAttackAction.getArm() == 1 ? physicalResult.roll : physicalResult.rollRight;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != punchAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        report = new Report(4010);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4015);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4020);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            if (bl2 && building != null && n2 > 0) {
                Report report2 = this.damageBuilding(building, n2);
                report2.indent();
                report2.subject = entity.getId();
                this.vPhaseReport.addElement(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            Report report3 = this.damageBuilding(building, n2);
            report3.indent();
            report3.subject = entity.getId();
            this.vPhaseReport.addElement(report3);
            this.damageInfantryIn(building, n2);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (bl2 && building != null) {
            int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n4, n2);
            n2 -= n5;
            Report.addNewline(this.vPhaseReport);
            Report report4 = this.damageBuilding(building, n5);
            report4.indent();
            report4.subject = entity.getId();
            this.vPhaseReport.addElement(report4);
        }
        if (n2 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
        } else {
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n2, false, 0, false, false, bl));
        }
        Report.addNewline(this.vPhaseReport);
    }

    private void resolveKickAttack(PhysicalResult physicalResult, int n) {
        Report report;
        String string;
        KickAttackAction kickAttackAction = (KickAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(kickAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(kickAttackAction.getTargetType(), kickAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, kickAttackAction.getEntityId(), entity2);
        }
        String string2 = string = kickAttackAction.getLeg() == 1 || kickAttackAction.getLeg() == 3 ? "Left " : "Right ";
        if (this.game.getOptions().booleanOption("maxtech_mulekicks")) {
            if (kickAttackAction.getLeg() == 3 || kickAttackAction.getLeg() == 4) {
                string.concat(" rear ");
            } else {
                string.concat(" front ");
            }
        }
        string.concat("leg");
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        report = new Report(4055);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4060);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a kick"));
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4065);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a kick"));
            if (bl2 && building != null && n2 > 0) {
                Report report2 = this.damageBuilding(building, n2);
                report2.indent();
                report2.subject = entity.getId();
                this.vPhaseReport.addElement(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            Report report3 = this.damageBuilding(building, n2);
            report3.indent();
            report3.subject = entity.getId();
            this.vPhaseReport.addElement(report3);
            this.damageInfantryIn(building, n2);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (bl2 && building != null) {
            int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n4, n2);
            n2 -= n5;
            Report.addNewline(this.vPhaseReport);
            Report report4 = this.damageBuilding(building, n5);
            report4.indent();
            report4.subject = entity.getId();
            this.vPhaseReport.addElement(report4);
        }
        if (n2 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
        } else {
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n2, false, 0, false, false, bl));
        }
        if (entity2.getMovementMode() == 1 || entity2.getMovementMode() == 2) {
            PilotingRollData pilotingRollData = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was kicked");
            pilotingRollData.setCumulative(false);
            this.game.addPSR(pilotingRollData);
        }
        Report.addNewline(this.vPhaseReport);
    }

    private void resolveProtoAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ProtomechPhysicalAttackAction protomechPhysicalAttackAction = (ProtomechPhysicalAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(protomechPhysicalAttackAction.getEntityId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Targetable targetable = this.game.getTarget(protomechPhysicalAttackAction.getTargetType(), protomechPhysicalAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, protomechPhysicalAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        report = new Report(4070);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            if (bl2 && building != null && n2 > 0) {
                Report report2 = this.damageBuilding(building, n2);
                report2.indent();
                report2.subject = entity.getId();
                this.vPhaseReport.addElement(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            Report report3 = this.damageBuilding(building, n2);
            report3.indent();
            report3.subject = entity.getId();
            this.vPhaseReport.addElement(report3);
            this.damageInfantryIn(building, n2);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (bl2 && building != null) {
            int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n4, n2);
            n2 -= n5;
            Report.addNewline(this.vPhaseReport);
            Report report4 = this.damageBuilding(building, n5);
            report4.indent();
            report4.subject = entity.getId();
            this.vPhaseReport.addElement(report4);
        }
        if (n2 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
        } else {
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n2));
        }
        Report.addNewline(this.vPhaseReport);
    }

    private void resolveBrushOffAttack(PhysicalResult physicalResult, int n) {
        Report report;
        int n2;
        String string;
        BrushOffAttackAction brushOffAttackAction = (BrushOffAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(brushOffAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(brushOffAttackAction.getTargetType(), brushOffAttackAction.getTargetId());
        Entity entity2 = null;
        String string2 = string = brushOffAttackAction.getArm() == 1 ? "Left Arm" : "Right Arm";
        if (targetable.getTargetType() == 0) {
            entity2 = this.game.getEntity(brushOffAttackAction.getTargetId());
        }
        int n3 = brushOffAttackAction.getArm() == 1 ? physicalResult.damage : physicalResult.damageRight;
        ToHitData toHitData = brushOffAttackAction.getArm() == 1 ? physicalResult.toHit : physicalResult.toHitRight;
        int n4 = n2 = brushOffAttackAction.getArm() == 1 ? physicalResult.roll : physicalResult.rollRight;
        if (n != brushOffAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        report = new Report(4085);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4090);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            toHitData.setHitTable(1);
            toHitData.setSideTable(0);
            HitData hitData = entity.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            report = new Report(4095);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.getLocationAbbr(hitData));
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n3));
            Report.addNewline(this.vPhaseReport);
            return;
        }
        switch (targetable.getTargetType()) {
            case 0: {
                HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                report = new Report(4045);
                report.subject = entity.getId();
                report.add(toHitData.getTableDesc());
                report.add(entity2.getLocationAbbr(hitData));
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n3));
                Report.addNewline(this.vPhaseReport);
                entity.setSwarmAttackerId(-1);
                entity2.setSwarmTargetId(-1);
                report = new Report(4100);
                report.subject = entity.getId();
                report.add(entity2.getDisplayName());
                this.vPhaseReport.addElement(report);
                break;
            }
            case 11: {
                entity.removeINarcPod((INarcPod)targetable);
                report = new Report(4105);
                report.subject = entity.getId();
                report.add(targetable.getDisplayName());
                this.vPhaseReport.addElement(report);
            }
        }
    }

    private void resolveThrashAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ThrashAttackAction thrashAttackAction = (ThrashAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(thrashAttackAction.getEntityId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        boolean bl = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Entity entity2 = this.game.getEntity(thrashAttackAction.getTargetId());
        if (n != thrashAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        report = new Report(4110);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4115);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4120);
            report.subject = entity.getId();
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (n3 < toHitData.getValue()) {
                report = new Report(4035);
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
                return;
            }
            report = new Report(4125);
            report.subject = entity.getId();
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
        }
        if (bl) {
            n2 = (int)Math.floor((double)n2 / 2.0);
        }
        report = new Report(4130);
        report.subject = entity.getId();
        report.add(n2);
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (bl) {
            report = new Report(4030);
            report.subject = entity.getId();
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
        }
        while (n2 > 0) {
            int n4 = Math.min(5, n2);
            n2 -= n4;
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            report = new Report(4135);
            report.subject = entity.getId();
            report.add(entity2.getLocationAbbr(hitData));
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n4));
        }
        Report.addNewline(this.vPhaseReport);
        PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
        entity.addPilotingModifierForTerrain(pilotingRollData);
        pilotingRollData.addModifier(0, "thrashing at infantry");
        report = new Report(4140);
        report.subject = entity.getId();
        report.addDesc(entity);
        this.vPhaseReport.addElement(report);
        int n5 = Compute.d6(2);
        report = new Report(2190);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n5);
        if (n5 < pilotingRollData.getValue()) {
            report.choose(false);
            this.vPhaseReport.addElement(report);
            this.doEntityFall(entity, pilotingRollData);
        } else {
            report.choose(true);
            this.vPhaseReport.addElement(report);
        }
    }

    private void resolveClubAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ClubAttackAction clubAttackAction = (ClubAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(clubAttackAction.getEntityId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Targetable targetable = this.game.getTarget(clubAttackAction.getTargetType(), clubAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, clubAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        clubAttackAction.getClub().restore();
        if (n != clubAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        report = new Report(4145);
        report.subject = entity.getId();
        report.indent();
        report.add(clubAttackAction.getClub().getName());
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(16)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a mace attack"));
            }
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(64)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 2, "missed a mace attack"));
            }
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(16)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a mace attack"));
            }
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(64)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 2, "missed a mace attack"));
            }
            if (bl2 && building != null && n2 > 0) {
                Report report2 = this.damageBuilding(building, n2);
                report2.indent();
                report2.subject = entity.getId();
                this.vPhaseReport.addElement(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            Report report3 = this.damageBuilding(building, n2);
            report3.indent();
            report3.subject = entity.getId();
            this.vPhaseReport.addElement(report3);
            this.damageInfantryIn(building, n2);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (bl2 && building != null) {
            int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n4, n2);
            n2 -= n5;
            Report.addNewline(this.vPhaseReport);
            Report report4 = this.damageBuilding(building, n5);
            report4.indent();
            report4.subject = entity.getId();
            this.vPhaseReport.addElement(report4);
        }
        if (n2 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
        } else {
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n2, false, 0, false, false, bl));
        }
        Report.addNewline(this.vPhaseReport);
        if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(2)) {
            report = new Report(4150);
            report.subject = entity.getId();
            report.add(clubAttackAction.getClub().getName());
            this.vPhaseReport.addElement(report);
            entity.removeMisc(clubAttackAction.getClub().getName());
        }
    }

    private void resolvePushAttack(PhysicalResult physicalResult, int n) {
        Serializable serializable;
        Report report;
        PushAttackAction pushAttackAction = (PushAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(pushAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(pushAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (physicalResult.pushBackResolved) {
            return;
        }
        if (n != pushAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        report = new Report(4155);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4160);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        Serializable serializable2 = null;
        Object object = this.physicalResults.elements();
        while (object.hasMoreElements()) {
            serializable = (PhysicalResult)object.nextElement();
            if (((PhysicalResult)serializable).aaa.getEntityId() != entity2.getId() || !(((PhysicalResult)serializable).aaa instanceof PushAttackAction) || ((PhysicalResult)serializable).aaa.getTargetId() != entity.getId()) continue;
            serializable2 = serializable;
        }
        if (serializable2 != null && ((PhysicalResult)serializable2).roll >= ((PhysicalResult)serializable2).toHit.getValue() && n2 >= toHitData.getValue()) {
            report = new Report(4165);
            report.subject = entity.getId();
            report.addDesc(entity2);
            report.addDesc(entity2);
            report.addDesc(entity);
            report.add(toHitData.getValue());
            report.add(n2);
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
            object = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was pushed");
            ((PilotingRollData)object).setCumulative(false);
            serializable = new PilotingRollData(entity.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was pushed");
            ((PilotingRollData)serializable).setCumulative(false);
            this.game.addPSR((PilotingRollData)serializable);
            this.game.addPSR((PilotingRollData)object);
            ((PhysicalResult)serializable2).pushBackResolved = true;
            return;
        }
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            return;
        }
        int n3 = entity.getFacing();
        serializable = entity2.getPosition();
        Coords coords = ((Coords)serializable).translated(n3);
        PilotingRollData pilotingRollData = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was pushed");
        pilotingRollData.setCumulative(false);
        if (Compute.isValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n3)) {
            report = new Report(4170);
            report.subject = entity.getId();
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (this.game.getBoard().contains(coords)) {
                report = new Report(4175);
                report.subject = entity.getId();
                report.add(coords.getBoardNum(), true);
                this.vPhaseReport.addElement(report);
            } else {
                report = new Report(4180);
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
            }
            this.doEntityDisplacement(entity2, (Coords)serializable, coords, pilotingRollData);
            if (!entity2.getPosition().equals(serializable)) {
                entity.setPosition((Coords)serializable);
            }
        } else {
            report = new Report(4185);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            this.game.addPSR(pilotingRollData);
        }
        Report.addNewline(this.vPhaseReport);
    }

    private void resolveChargeAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ChargeAttackAction chargeAttackAction = (ChargeAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(chargeAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(chargeAttackAction.getTargetType(), chargeAttackAction.getTargetId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Entity entity2 = null;
        if (targetable != null && targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, chargeAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(chargeAttackAction.getTargetPos());
        if (entity == null) {
            return;
        }
        int n4 = entity.getFacing();
        entity.setDisplacementAttack(null);
        if (n != chargeAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        if (targetable == null || targetable.getTargetType() == 0 && (entity2.isDestroyed() || entity2.isDoomed() || entity2.crew.isDead())) {
            report = new Report(4190);
            report.subject = entity.getId();
            report.indent();
            this.vPhaseReport.addElement(report);
            return;
        }
        if (entity.isProne()) {
            report = new Report(4195);
            report.subject = entity.getId();
            report.indent();
            this.vPhaseReport.addElement(report);
            return;
        }
        if (entity.isImmobile()) {
            report = new Report(4200);
            report.subject = entity.getId();
            report.indent();
            this.vPhaseReport.addElement(report);
            return;
        }
        if (entity2.isProne()) {
            report = new Report(4205);
            report.subject = entity.getId();
            report.indent();
            this.vPhaseReport.addElement(report);
            return;
        }
        report = new Report(4210);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (!targetable.getPosition().equals(chargeAttackAction.getTargetPos())) {
            report = new Report(4215);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            this.doEntityDisplacement(entity, entity.getPosition(), chargeAttackAction.getTargetPos(), null);
            return;
        }
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            n3 = -12;
            report = new Report(4220);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
            n3 = Integer.MAX_VALUE;
            report = new Report(4225);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (bl2) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Coords coords = entity.getPosition();
            Coords coords2 = Compute.getMissedChargeDisplacement(this.game, entity.getId(), coords, n4);
            report = new Report(4035);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            this.doEntityDisplacement(entity, coords, coords2, null);
        } else if (targetable.getTargetType() == 3) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            Report report2 = this.damageBuilding(building, n2);
            report2.indent();
            report2.subject = entity.getId();
            this.vPhaseReport.addElement(report2);
            this.damageInfantryIn(building, n2);
            int n5 = ChargeAttackAction.getDamageTakenBy(entity, building);
            HitData hitData = entity.rollHitLocation(0, entity.sideTable(targetable.getPosition()));
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n5, false, 0, false, false, bl));
            Report.addNewline(this.vPhaseReport);
            this.entityUpdate(entity.getId());
        } else {
            this.resolveChargeDamage(entity, entity2, toHitData, n4, bl2, bl);
        }
    }

    private void resolveChargeDamage(Entity entity, Entity entity2, ToHitData toHitData, int n) {
        this.resolveChargeDamage(entity, entity2, toHitData, n, false, true);
    }

    private void resolveChargeDamage(Entity entity, Entity entity2, ToHitData toHitData, int n, boolean bl, boolean bl2) {
        int n2;
        int n3 = ChargeAttackAction.getDamageFor(entity);
        int n4 = ChargeAttackAction.getDamageTakenBy(entity, entity2, this.game.getOptions().booleanOption("maxtech_charge_damage"));
        PilotingRollData pilotingRollData = null;
        if (bl) {
            n3 = (int)Math.floor((double)n3 / 2.0);
            n4 = (int)Math.floor((double)n4 / 2.0);
        }
        boolean bl3 = Compute.isInBuilding(this.game, entity2);
        Building building = this.game.getBoard().getBuildingAt(entity2.getPosition());
        int n5 = 0;
        if (bl3 && building != null) {
            n5 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
        }
        if (!entity.isProne()) {
            pilotingRollData = new PilotingRollData(entity.getId(), 2, "charging");
        }
        Report report = new Report(4230);
        report.subject = entity.getId();
        report.add(n3);
        report.add(toHitData.getTableDesc());
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        while (n3 > 0) {
            n2 = Math.min(5, n3);
            n3 -= n2;
            if (n5 > 0) {
                int n6 = Math.min(n5, n2);
                n2 -= n6;
                Report.addNewline(this.vPhaseReport);
                Report report2 = this.damageBuilding(building, n6);
                report2.indent();
                report2.subject = entity.getId();
                this.vPhaseReport.addElement(report2);
            }
            if (n2 == 0) {
                report = new Report(4235);
                report.subject = entity.getId();
                report.addDesc(entity2);
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
                continue;
            }
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, hitData, n2, false, 0, false, false, bl2));
        }
        report = new Report(4240);
        report.subject = entity.getId();
        report.add(n4);
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        while (n4 > 0) {
            n2 = Math.min(5, n4);
            HitData hitData = entity.rollHitLocation(0, 0);
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n2));
            n4 -= n2;
        }
        Coords coords = entity2.getPosition();
        Coords coords2 = coords.translated(n);
        if (Compute.isValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n)) {
            Report.addNewline(this.vPhaseReport);
            this.doEntityDisplacement(entity2, coords, coords2, new PilotingRollData(entity2.getId(), 2, "was charged"));
            this.doEntityDisplacement(entity, entity.getPosition(), coords, pilotingRollData);
        }
        Report.addNewline(this.vPhaseReport);
    }

    private void resolveDfaAttack(PhysicalResult physicalResult, int n) {
        Object object;
        Report report;
        DfaAttackAction dfaAttackAction = (DfaAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(dfaAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(dfaAttackAction.getTargetType(), dfaAttackAction.getTargetId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Entity entity2 = null;
        if (targetable != null && targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            IHex iHex = this.game.getBoard().getHex(entity2.getPosition());
            if (iHex.containsTerrain(4) && entity2.absHeight() < iHex.getElevation()) {
                n2 = (int)Math.ceil((float)n2 * 0.5f);
            }
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, dfaAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(dfaAttackAction.getTargetPos());
        if (entity == null) {
            return;
        }
        int n4 = entity.getFacing();
        if (n != dfaAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
        entity.setDisplacementAttack(null);
        if (targetable == null || targetable.getTargetType() == 0 && (entity2.isDestroyed() || entity2.isDoomed() || entity2.crew.isDead())) {
            report = new Report(4245);
            report.subject = entity.getId();
            report.indent();
            this.vPhaseReport.addElement(report);
            if (entity.isProne()) {
                this.doEntityFall(entity, dfaAttackAction.getTargetPos(), 2, 3, entity.getBasePilotingRoll());
            } else {
                this.doEntityDisplacement(entity, entity.getPosition(), dfaAttackAction.getTargetPos(), new PilotingRollData(entity.getId(), 4, "executed death from above"));
            }
            return;
        }
        report = new Report(4246);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        if (!targetable.getPosition().equals(dfaAttackAction.getTargetPos())) {
            report = new Report(4215);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            this.doEntityFallsInto(entity, entity.getPosition(), dfaAttackAction.getTargetPos(), entity.getBasePilotingRoll());
            return;
        }
        if (entity.isProne() || !entity.isActive()) {
            n3 = -12;
            report = new Report(4250);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
        } else if (toHitData.getValue() == Integer.MAX_VALUE) {
            n3 = -12;
            report = new Report(4255);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4260);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.vPhaseReport.addElement(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (bl2) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Coords coords = entity2.getPosition();
            Coords coords2 = Compute.getPreferredDisplacement(this.game, entity2.getId(), coords, n4);
            report = new Report(4035);
            report.subject = entity.getId();
            this.vPhaseReport.addElement(report);
            if (coords2 != null) {
                report = new Report(4265);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(coords.getBoardNum(), true);
                this.vPhaseReport.addElement(report);
                this.doEntityFall(entity, coords, 2, 3, entity.getBasePilotingRoll());
                this.doEntityDisplacement(entity2, coords, coords2, null);
            } else {
                Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity, "impossible displacement", entity instanceof Mech, entity instanceof Mech));
            }
            return;
        }
        int n5 = DfaAttackAction.getDamageTakenBy(entity);
        report = new Report(4040);
        report.subject = entity.getId();
        this.vPhaseReport.addElement(report);
        if (targetable.getTargetType() == 3) {
            Report report2 = this.damageBuilding(building, n2);
            report2.indent();
            report2.subject = entity.getId();
            this.vPhaseReport.addElement(report2);
            this.damageInfantryIn(building, n2);
        } else {
            if (bl2) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            report = new Report(4230);
            report.subject = entity.getId();
            report.add(n2);
            report.add(toHitData.getTableDesc());
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            while (n2 > 0) {
                int n6 = Math.min(5, n2);
                object = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, (HitData)object, n6, false, 0, false, false, bl));
                n2 -= n6;
            }
        }
        if (bl2) {
            n5 = (int)Math.floor((double)n5 / 2.0);
        }
        report = new Report(4240);
        report.subject = entity.getId();
        report.add(n5);
        report.newlines = 0;
        this.vPhaseReport.addElement(report);
        while (n5 > 0) {
            int n7 = Math.min(5, n5);
            object = entity.rollHitLocation(2, 0);
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, (HitData)object, n7));
            n5 -= n7;
        }
        Report.addNewline(this.vPhaseReport);
        if (targetable.getTargetType() == 3) {
            return;
        }
        Coords coords = entity2.getPosition();
        object = Compute.getValidDisplacement(this.game, entity2.getId(), coords, n4);
        if (object != null) {
            this.doEntityDisplacement(entity2, coords, (Coords)object, new PilotingRollData(entity2.getId(), 2, "hit by death from above"));
        } else {
            Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity2, "impossible displacement", entity2 instanceof Mech, entity2 instanceof Mech));
        }
        this.doEntityDisplacement(entity, coords, coords, new PilotingRollData(entity.getId(), 4, "executed death from above"));
    }

    private int getKickPushPSRMod(Entity entity, Entity entity2, int n) {
        int n2 = n;
        if (this.game.getOptions().booleanOption("maxtech_physical_psr")) {
            int n3 = 0;
            int n4 = 0;
            switch (entity.getWeightClass()) {
                case 0: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
                case 2: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 4;
                }
            }
            switch (entity2.getWeightClass()) {
                case 0: {
                    n4 = 1;
                    break;
                }
                case 1: {
                    n4 = 2;
                    break;
                }
                case 2: {
                    n4 = 3;
                    break;
                }
                case 3: {
                    n4 = 4;
                }
            }
            n2 = n3 - n4;
        }
        return n2;
    }

    private void resolveHeat() {
        this.vPhaseReport.addElement(new Report(5000, 0));
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            int n;
            Report report;
            int n2;
            Entity entity = (Entity)enumeration.nextElement();
            if (null == entity.getPosition()) continue;
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (!(entity instanceof Mech)) {
                entity.heatBuildup = 0;
                if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                    this.resolveVehicleFire((Tank)entity, true);
                    continue;
                }
                if (!entity.infernos.isStillBurning()) continue;
                this.doFlamingDeath(entity);
                continue;
            }
            if (entity.infernos.isStillBurning()) {
                n2 = entity.infernos.getHeat();
                entity.heatBuildup += n2;
                report = new Report(5010);
                report.subject = entity.getId();
                report.add(n2);
                this.vPhaseReport.addElement(report);
            }
            if (entity.isDestroyed() || entity.isDoomed() || entity.crew.isDoomed() || entity.crew.isDead()) continue;
            entity.heatBuildup += entity.getEngineCritHeat();
            if (entity instanceof Mech && entity.isStealthActive()) {
                entity.heatBuildup += 10;
                report = new Report(5015);
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
            }
            if (entity instanceof Mech && this.game.getTemperatureDifference() != 0 && !((Mech)entity).hasLaserHeatSinks()) {
                if (this.game.getOptions().intOption("temperature") > 50) {
                    entity.heatBuildup += this.game.getTemperatureDifference();
                    report = new Report(5020);
                    report.subject = entity.getId();
                    report.add(this.game.getTemperatureDifference());
                    this.vPhaseReport.addElement(report);
                } else {
                    entity.heatBuildup -= this.game.getTemperatureDifference();
                    report = new Report(5025);
                    report.subject = entity.getId();
                    report.add(this.game.getTemperatureDifference());
                    this.vPhaseReport.addElement(report);
                }
            }
            if (iHex != null) {
                if (iHex.terrainLevel(7) == 2) {
                    entity.heatBuildup += 5;
                    report = new Report(5030);
                    report.subject = entity.getId();
                    this.vPhaseReport.addElement(report);
                }
                if ((n2 = iHex.terrainLevel(24)) > 0) {
                    entity.heatBuildup += 5 * n2;
                    report = new Report(5032);
                    report.subject = entity.getId();
                    report.add(5 * n2);
                    this.vPhaseReport.addElement(report);
                }
            }
            if (entity.heatBuildup < 0) {
                entity.heatBuildup = 0;
            }
            entity.heat += entity.heatBuildup;
            n2 = entity.getHeatCapacityWithWater();
            int n3 = entity.hasInfernoAmmo() ? 9 : 13;
            int n4 = ((Mech)entity).getNumberOfSinks();
            Enumeration enumeration2 = entity.getEquipment();
            while (enumeration2.hasMoreElements()) {
                AmmoType ammoType;
                Mounted mounted = (Mounted)enumeration2.nextElement();
                if (!(mounted.getType() instanceof AmmoType) || (ammoType = (AmmoType)mounted.getType()).getAmmoType() != 37 || !mounted.isAmmoUsable()) continue;
                EquipmentMode equipmentMode = mounted.curMode();
                if (equipmentMode.equals("dump")) {
                    report = new Report(5260);
                    report.subject = entity.getId();
                    this.vPhaseReport.addElement(report);
                    mounted.setShotsLeft(0);
                    n2 += n4;
                    break;
                }
                if (equipmentMode.equals("safe") && entity.heat - n2 > n3) {
                    report = new Report(5265);
                    report.subject = entity.getId();
                    this.vPhaseReport.addElement(report);
                    mounted.setShotsLeft(0);
                    n2 += n4;
                    break;
                }
                if (!equipmentMode.equals("efficient") || entity.heat - n2 < n4) continue;
                report = new Report(5270);
                report.subject = entity.getId();
                this.vPhaseReport.addElement(report);
                mounted.setShotsLeft(0);
                n2 += n4;
                break;
            }
            n2 = Math.min(n2, entity.heat);
            entity.heat -= n2;
            report = new Report(5035);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.heatBuildup);
            report.add(n2);
            report.add(entity.heat);
            this.vPhaseReport.addElement(report);
            entity.heatBuildup = 0;
            if (entity.hasInfernoAmmo() && entity.heat >= 10) {
                int n5 = 4 + (entity.heat >= 14 ? 2 : 0) + (entity.heat >= 19 ? 2 : 0) + (entity.heat >= 23 ? 2 : 0) + (entity.heat >= 28 ? 2 : 0);
                int n6 = Compute.d6(2);
                report = new Report(5040);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n5);
                report.add(n6);
                if (n6 >= n5) {
                    report.choose(true);
                    this.vPhaseReport.addElement(report);
                } else {
                    report.choose(false);
                    this.vPhaseReport.addElement(report);
                    Server.combineVectors(this.vPhaseReport, this.explodeInfernoAmmoFromHeat(entity));
                }
            }
            if (this.game.getOptions().booleanOption("maxtech_heat")) {
                n = 50;
                bl = true;
            } else {
                n = 30;
                bl = false;
            }
            if (entity.heat < n && entity.isShutDown()) {
                if (entity.heat < 14) {
                    entity.setShutDown(false);
                    report = new Report(5045);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    this.vPhaseReport.addElement(report);
                } else {
                    int n7 = 4 + (entity.heat - 14) / 4 * 2;
                    if (bl) {
                        n7 = entity.crew.getPiloting() + n7 - 8;
                    }
                    int n8 = Compute.d6(2);
                    report = new Report(5050);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(n7);
                    report.add(n8);
                    if (n8 >= n7) {
                        entity.setShutDown(false);
                        report.choose(true);
                    } else {
                        report.choose(false);
                    }
                    this.vPhaseReport.addElement(report);
                }
            } else if (entity.heat >= 14 && !entity.isShutDown()) {
                if (entity.heat >= n) {
                    report = new Report(5055);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    this.vPhaseReport.addElement(report);
                    this.game.addPSR(new PilotingRollData(entity.getId(), 3, "reactor shutdown"));
                    this.resolvePilotingRolls();
                    entity.setShutDown(true);
                } else if (entity.heat >= 14) {
                    int n9 = 4 + (entity.heat - 14) / 4 * 2;
                    if (bl) {
                        n9 = entity.crew.getPiloting() + n9 - 8;
                    }
                    int n10 = Compute.d6(2);
                    report = new Report(5060);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(n9);
                    report.add(n10);
                    if (n10 >= n9) {
                        report.choose(true);
                        this.vPhaseReport.addElement(report);
                    } else {
                        report.choose(false);
                        this.vPhaseReport.addElement(report);
                        this.game.addPSR(new PilotingRollData(entity.getId(), 3, "reactor shutdown"));
                        this.resolvePilotingRolls();
                        entity.setShutDown(true);
                    }
                }
            }
            if (entity.heat >= 19) {
                int n11 = 4 + (entity.heat >= 23 ? 2 : 0) + (entity.heat >= 28 ? 2 : 0);
                if (bl) {
                    n11 += (entity.heat >= 35 ? 2 : 0) + (entity.heat >= 40 ? 2 : 0) + (entity.heat >= 45 ? 2 : 0);
                }
                if (entity instanceof Mech && ((Mech)entity).hasLaserHeatSinks()) {
                    --n11;
                }
                int n12 = Compute.d6(2);
                report = new Report(5065);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n11);
                report.add(n12);
                if (n12 >= n11) {
                    report.choose(true);
                    this.vPhaseReport.addElement(report);
                } else {
                    report.choose(false);
                    this.vPhaseReport.addElement(report);
                    Server.combineVectors(this.vPhaseReport, this.explodeAmmoFromHeat(entity));
                }
            }
            if (!(entity.getHitCriticals(0, 0, 0) <= 0 || entity.heat < 15 || entity.crew.isDead() || entity.crew.isDoomed() || entity.crew.isEjected())) {
                int n13;
                int n14;
                if (entity.heat >= 47 && bl) {
                    n14 = 47;
                    n13 = 5;
                } else if (entity.heat >= 39 && bl) {
                    n14 = 39;
                    n13 = 4;
                } else if (entity.heat >= 32 && bl) {
                    n14 = 32;
                    n13 = 3;
                } else if (entity.heat >= 25) {
                    n14 = 25;
                    n13 = 2;
                } else {
                    n14 = 15;
                    n13 = 1;
                }
                report = new Report(5070);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n14);
                report.add(n13);
                this.vPhaseReport.addElement(report);
                this.damageCrew(entity, n13);
            } else if (bl && entity.heat >= 32 && !entity.crew.isDead() && !entity.crew.isDoomed()) {
                int n15 = Compute.d6(2);
                int n16 = -1;
                if (entity.heat >= 47) {
                    n16 = 12;
                } else if (entity.heat >= 39) {
                    n16 = 10;
                } else if (entity.heat >= 32) {
                    n16 = 8;
                }
                report = new Report(5075);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n16);
                report.add(n15);
                if (n15 >= n16) {
                    report.choose(true);
                } else {
                    this.damageCrew(entity, 1);
                    report.choose(false);
                }
                this.vPhaseReport.addElement(report);
            }
            if ((entity.crew.isDead() || entity.crew.isDoomed()) && !entity.crew.isEjected()) {
                report = new Report(5080);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.newlines = 0;
                this.vPhaseReport.addElement(report);
                Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity, "crew death", true));
            }
            if (!bl || entity.heat < 36) continue;
            int n17 = Compute.d6(2);
            int n18 = -1;
            if (entity.heat >= 44) {
                n18 = 10;
            } else if (entity.heat >= 36) {
                n18 = 8;
            }
            report = new Report(5085);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(n18);
            report.add(n17);
            report.newlines = 0;
            if (n17 >= n18) {
                report.choose(true);
                this.vPhaseReport.addElement(report);
                continue;
            }
            report.choose(false);
            this.vPhaseReport.addElement(report);
            Server.combineVectors(this.vPhaseReport, this.oneCriticalEntity(entity, Compute.d6(2)));
            report = new Report(1210);
            this.vPhaseReport.add(report);
        }
        if (this.vPhaseReport.size() == 1) {
            this.vPhaseReport.addElement(new Report(1205, 0));
        }
    }

    private void resolveExtremeTempInfantryDeath() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (null == entity.getPosition()) continue;
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (!(entity instanceof Infantry) || entity instanceof BattleArmor || this.game.getTemperatureDifference() <= 0 || iHex.containsTerrain(10) || entity.getTransportId() != -1) continue;
            Report report = new Report(5090);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
            Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity, "heat/cold", false, false));
        }
    }

    private void doFlamingDeath(Entity entity) {
        Object object;
        Object object2;
        int n = Compute.d6(2);
        if (-1 != entity.getSwarmTargetId()) {
            return;
        }
        if (entity.getMovementMode() == 6 && !entity.infernos.isStillBurning()) {
            object2 = entity.getPosition();
            object = this.game.getBoard().getHex(((Coords)object2).x, ((Coords)object2).y);
            if (entity.getElevation() > 1) {
                return;
            }
        }
        object2 = entity.getMisc();
        while (object2.hasMoreElements()) {
            object = (Mounted)object2.nextElement();
            EquipmentType equipmentType = ((Mounted)object).getType();
            if (!"BA-Fire Resistant Armor".equals(equipmentType.getInternalName())) continue;
            Report report = new Report(5095);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
            return;
        }
        Report report = new Report(5100);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(n);
        if (n >= 8) {
            report.choose(true);
            this.vPhaseReport.addElement(report);
        } else {
            report.choose(false);
            this.vPhaseReport.addElement(report);
            Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity, "fire", false, false));
        }
    }

    private void checkFor20Damage() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!(entity instanceof Mech) || entity.damageThisPhase < 20) continue;
            if (this.game.getOptions().booleanOption("maxtech_round_damage")) {
                int n = entity.damageThisPhase / 20;
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(entity.damageThisPhase).append(" damage +").append(n);
                switch (entity.getWeightClass()) {
                    case 0: {
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        n2 = -1;
                        break;
                    }
                    case 3: {
                        n2 = -2;
                    }
                }
                PilotingRollData pilotingRollData = new PilotingRollData(entity.getId(), n + n2, stringBuffer.toString());
                pilotingRollData.setCumulative(false);
                this.game.addPSR(pilotingRollData);
                continue;
            }
            this.game.addPSR(new PilotingRollData(entity.getId(), 1, "20+ damage"));
        }
    }

    public void checkForFlamingDeath() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            IHex iHex;
            Entity entity = (Entity)enumeration.nextElement();
            if (null == entity.getPosition() || entity instanceof Mech || entity.isDoomed() || entity.isDestroyed() || entity.isOffBoard() || !(iHex = this.game.getBoard().getHex(entity.getPosition())).containsTerrain(7) || entity.getElevation() > 1) continue;
            if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                this.checkForVehicleFire((Tank)entity, false);
                continue;
            }
            this.doFlamingDeath(entity);
        }
    }

    private void checkForVacuumDeath() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (null == entity.getPosition() || entity.isOffBoard() || !entity.doomedInVacuum()) continue;
            Report report = new Report(6015);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
            Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity, "being in a vacuum where it can't survive", true, true));
        }
    }

    private void checkForSuffocation() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (null == entity.getPosition() || entity.isOffBoard()) continue;
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (entity.getElevation() >= 0 || iHex.terrainLevel(4) <= 1 && (iHex.terrainLevel(4) != 1 || !entity.isProne()) || entity.getHitCriticals(0, 0, 0) <= 0) continue;
            Report report = new Report(6020);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
            Server.combineVectors(this.vPhaseReport, this.damageCrew(entity, 1));
        }
    }

    private void resolvePilotingRolls() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            this.resolvePilotingRolls((Entity)enumeration.nextElement());
        }
        this.game.resetPSRs();
    }

    void resolvePilotingRolls(Entity entity) {
        this.resolvePilotingRolls(entity, false, null, null);
    }

    void resolvePilotingRolls(Entity entity, boolean bl, Coords coords, Coords coords2) {
        PilotingRollData pilotingRollData;
        Report report;
        if (entity.isDoomed() || entity.isDestroyed()) {
            return;
        }
        TargetRoll targetRoll = null;
        Object object = this.game.getExtremeGravityPSRs();
        while (object.hasMoreElements()) {
            PilotingRollData pilotingRollData2 = (PilotingRollData)object.nextElement();
            if (pilotingRollData2.getEntityId() != entity.getId()) continue;
            targetRoll = pilotingRollData2;
            this.game.resetExtremeGravityPSRs(entity);
        }
        if (targetRoll != null && targetRoll.getValue() != -2147483647) {
            report = new Report(2180);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(targetRoll.getLastPlainDesc());
            this.vPhaseReport.addElement(report);
            int n = Compute.d6(2);
            report = new Report(2190);
            report.subject = entity.getId();
            report.add(targetRoll.getValueAsString());
            report.add(targetRoll.getDesc());
            report.add(n);
            if (n < targetRoll.getValue()) {
                int n2;
                report.choose(false);
                this.vPhaseReport.addElement(report);
                if (entity.moved == 1 || entity.moved == 4 || entity.moved == 2 || entity.moved == 5) {
                    if (entity instanceof Mech) {
                        int n3 = entity.mpUsed;
                        n2 = 0;
                        while (n3 > entity.getRunMP(false)) {
                            --n3;
                            ++n2;
                        }
                        this.doExtremeGravityDamage(entity, n2);
                    } else if (entity instanceof Tank) {
                        int n4;
                        int n5 = n4 = entity.gotPavementBonus ? 1 : 0;
                        if (!entity.gotPavementBonus) {
                            n2 = entity.mpUsed;
                            int n6 = 0;
                            while (n2 > entity.getRunMP(false) + n4) {
                                --n2;
                                ++n6;
                            }
                            this.doExtremeGravityDamage(entity, n6);
                        }
                    }
                }
                if (entity.moved == 3 && entity instanceof Mech) {
                    if (this.game.getOptions().floatOption("gravity") < 1.0f) {
                        int n7 = entity.mpUsed;
                        n2 = 0;
                        while (n7 > entity.getOriginalJumpMP()) {
                            --n7;
                            ++n2;
                        }
                        this.doExtremeGravityDamage(entity, n2);
                    } else if (this.game.getOptions().floatOption("gravity") > 1.0f) {
                        int n8 = entity.getWalkMP(false) - entity.getWalkMP();
                        this.doExtremeGravityDamage(entity, n8);
                    }
                }
            } else {
                report.choose(true);
                this.vPhaseReport.addElement(report);
            }
        }
        if (!(entity instanceof Mech) || entity.isProne()) {
            return;
        }
        object = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        PilotingRollData pilotingRollData3 = entity.getBasePilotingRoll();
        entity.addPilotingModifierForTerrain(pilotingRollData3);
        Enumeration enumeration = this.game.getPSRs();
        while (enumeration.hasMoreElements()) {
            pilotingRollData = (PilotingRollData)enumeration.nextElement();
            if (pilotingRollData.getEntityId() != entity.getId()) continue;
            ((Vector)object).addElement(pilotingRollData);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(pilotingRollData.getPlainDesc());
            if (!pilotingRollData.isCumulative()) continue;
            pilotingRollData3.append(pilotingRollData);
        }
        if (((Vector)object).size() == 0) {
            return;
        }
        if (pilotingRollData3.getValue() == 0x7FFFFFFE || pilotingRollData3.getValue() == Integer.MAX_VALUE) {
            report = new Report(2275);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(((Vector)object).size());
            report.add(stringBuffer.toString());
            report.add(pilotingRollData3.getDesc());
            this.vPhaseReport.addElement(report);
            if (bl) {
                this.doEntityFallsInto(entity, coords, coords2, pilotingRollData3);
            } else {
                this.doEntityFall(entity, pilotingRollData3);
            }
            return;
        }
        report = new Report(2280);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(((Vector)object).size());
        report.add(stringBuffer.toString());
        this.vPhaseReport.addElement(report);
        report = new Report(2285);
        report.subject = entity.getId();
        report.add(pilotingRollData3.getValueAsString());
        report.add(pilotingRollData3.getDesc());
        this.vPhaseReport.addElement(report);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            pilotingRollData = (PilotingRollData)((Vector)object).elementAt(i);
            PilotingRollData pilotingRollData4 = pilotingRollData3;
            report = new Report(2290);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.add(i + 1);
            report.add(pilotingRollData.getPlainDesc());
            this.vPhaseReport.addElement(report);
            if (!pilotingRollData.isCumulative()) {
                report = new Report(2295);
                report.subject = entity.getId();
                report.newlines = 0;
                report.add(pilotingRollData.getValueAsString());
                pilotingRollData4 = new PilotingRollData(entity.getId());
                pilotingRollData4.append(pilotingRollData3);
                pilotingRollData4.append(pilotingRollData);
            }
            int n = Compute.d6(2);
            report = new Report(2300);
            report.subject = entity.getId();
            report.add(pilotingRollData4.getValueAsString());
            report.add(n);
            if (n < pilotingRollData4.getValue()) {
                report.choose(false);
                this.vPhaseReport.addElement(report);
                if (bl) {
                    this.doEntityFallsInto(entity, coords, coords2, pilotingRollData3);
                } else {
                    this.doEntityFall(entity, pilotingRollData3);
                }
                return;
            }
            report.choose(true);
            this.vPhaseReport.addElement(report);
        }
    }

    private Vector damageCrew(Entity entity, int n) {
        Vector<Report> vector = new Vector<Report>();
        Pilot pilot = entity.getCrew();
        if (!(pilot.isDead() || pilot.isEjected() || pilot.isDoomed())) {
            pilot.setHits(pilot.getHits() + n);
            Report report = new Report(6025);
            report.subject = entity.getId();
            report.indent(2);
            report.addDesc(entity);
            report.add(pilot.getName());
            report.add(n);
            report.newlines = 0;
            vector.addElement(report);
            if (6 > pilot.getHits()) {
                pilot.setRollsNeeded(pilot.getRollsNeeded() + n);
            } else if (!pilot.isDoomed()) {
                pilot.setDoomed(true);
                Server.combineVectors(vector, this.destroyEntity(entity, "pilot death", true));
            }
        }
        return vector;
    }

    private void resolveCrewDamage() {
        boolean bl = false;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!this.resolveCrewDamage(entity, bl)) continue;
            bl = true;
        }
        if (bl) {
            Report.addNewline(this.vPhaseReport);
        }
    }

    private boolean resolveCrewDamage(Entity entity, boolean bl) {
        int n = entity.getCrew().getHits();
        int n2 = entity.getCrew().getRollsNeeded();
        entity.crew.setRollsNeeded(0);
        if (!entity.isTargetable() || !entity.getCrew().isActive() || n2 == 0) {
            return false;
        }
        for (int i = n - n2 + 1; i <= n; ++i) {
            int n3 = Compute.d6(2);
            if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
                n3 = Math.min(12, n3 + 1);
            }
            int n4 = Compute.getConsciousnessNumber(i);
            Report report = new Report(6030);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.getCrew().getName());
            report.add(n4);
            report.add(n3);
            if (n3 < n4) {
                entity.crew.setUnconscious(true);
                entity.crew.setKoThisRound(true);
                report.choose(false);
                this.vPhaseReport.addElement(report);
                return true;
            }
            report.choose(true);
            this.vPhaseReport.addElement(report);
        }
        return true;
    }

    private void resolveCrewWakeUp() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.isTargetable() || !entity.crew.isUnconscious() || entity.crew.isKoThisRound() || !(entity instanceof Mech) && !(entity instanceof Protomech) && !(entity instanceof MechWarrior)) continue;
            int n = Compute.d6(2);
            if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
                n = Math.min(12, n + 1);
            }
            int n2 = Compute.getConsciousnessNumber(entity.crew.getHits());
            Report report = new Report(6029);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.getCrew().getName());
            report.add(n2);
            report.add(n);
            if (n >= n2) {
                report.choose(true);
                entity.crew.setUnconscious(false);
            } else {
                report.choose(false);
            }
            this.vPhaseReport.addElement(report);
        }
    }

    public Vector damageEntity(Entity entity, HitData hitData, int n, boolean bl) {
        return this.damageEntity(entity, hitData, n, bl, 0, false, false);
    }

    public Vector damageEntity(Entity entity, HitData hitData, int n) {
        return this.damageEntity(entity, hitData, n, false, 0, false, false);
    }

    public Vector damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2) {
        return this.damageEntity(entity, hitData, n, bl, n2, false, false);
    }

    public Vector damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2, boolean bl2) {
        return this.damageEntity(entity, hitData, n, bl, n2, bl2, false);
    }

    public Vector damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        return this.damageEntity(entity, hitData, n, bl, n2, bl2, false, true);
    }

    private Vector damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4) {
        Report report;
        boolean bl5;
        Mech mech;
        Vector<Report> vector = new Vector<Report>();
        boolean bl6 = false;
        if (bl && entity instanceof Mech && (mech = (Mech)entity).isAutoEject()) {
            bl6 = true;
            Server.combineVectors(vector, this.ejectEntity(entity, true));
        }
        boolean bl7 = !(bl5 = entity instanceof BattleArmor) && entity instanceof Infantry;
        boolean bl8 = false;
        if (entity != null && entity.getArmor(hitData) > 0 && (entity.getArmorType() == 1 || entity.getArmorType() == 5 || entity.getArmorType() == 6)) {
            bl8 = true;
        }
        boolean bl9 = false;
        boolean bl10 = bl2;
        IHex iHex = null;
        int n3 = entity.getId();
        int n4 = hitData.getEffect() == 1 ? 1 : 0;
        int n5 = 0;
        HitData hitData2 = null;
        if (entity instanceof Protomech && hitData.getLocation() == 6) {
            Report report2 = new Report(6035);
            report2.subject = n3;
            report2.indent(2);
            report2.newlines = 0;
            vector.addElement(report2);
            return vector;
        }
        if (!(!bl7 || entity.isDestroyed() || entity.isDoomed() || (iHex = this.game.getBoard().getHex(entity.getPosition())) == null || iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(2) || iHex.containsTerrain(3) || iHex.containsTerrain(9) || iHex.containsTerrain(10) || iHex.containsTerrain(21))) {
            n *= 2;
            report = new Report(6040);
            report.subject = n3;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
        }
        if ((bl7 || bl5) && !entity.isDestroyed() && !entity.isDoomed() && this.game.getOptions().booleanOption("vacuum")) {
            n *= 2;
            report = new Report(6041);
            report.subject = n3;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
        }
        switch (n2) {
            case 1: {
                if (bl7) {
                    n *= 2;
                    report = new Report(6045);
                    report.subject = n3;
                    report.indent(2);
                    report.newlines = 0;
                    vector.addElement(report);
                    break;
                }
                if (entity == null) break;
                n = 0;
                report = new Report(6050);
                report.subject = n3;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case 2: {
                if (bl7) {
                    n *= 2;
                    report = new Report(6055);
                    report.subject = n3;
                    report.indent(2);
                    report.newlines = 0;
                    vector.addElement(report);
                    break;
                }
                if (entity == null || bl5) break;
                n /= 2;
                report = new Report(6060);
                report.subject = n3;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case 3: {
                if (bl8) {
                    n = entity.getArmor(hitData) >= 3 ? 3 : entity.getArmor(hitData);
                    report = new Report(6061);
                    report.subject = n3;
                    report.indent(2);
                    report.newlines = 0;
                    report.add(n);
                    vector.addElement(report);
                    break;
                }
                if (entity == null) break;
                report = new Report(6062);
                report.subject = n3;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case 4: {
                if (!bl7) break;
                n += 2;
                break;
            }
        }
        boolean bl11 = entity.hasActiveEiCockpit();
        if (!(entity instanceof Mech) && !(entity instanceof Protomech) && bl11) {
            ++n;
        }
        while (n > 0) {
            int n6;
            int n7;
            Object object;
            report = new Report(6065);
            report.subject = n3;
            report.indent(2);
            report.newlines = 0;
            report.addDesc(entity);
            report.add(n);
            if (bl2) {
                report.messageId = 6070;
            }
            report.add(entity.getLocationAbbr(hitData));
            vector.addElement(report);
            if (entity.getInternal(hitData) == -2) {
                n4 = 0;
            }
            if (entity instanceof Mech && ((Mech)(object = (Mech)entity)).hasCowl() && hitData.getLocation() == 0 && !bl4) {
                n7 = ((Mech)object).damageCowl(n);
                n6 = n - n7;
                n = n7;
                report = new Report(3520);
                report.subject = n3;
                report.indent(3);
                report.newlines = 0;
                report.add(n6);
                vector.addElement(report);
            }
            if (entity.hasSpotlight()) {
                boolean bl12 = true;
                n7 = hitData.getLocation();
                if (entity instanceof Mech) {
                    if (n7 != 1 && n7 != 3 && n7 != 2) {
                        bl12 = false;
                    }
                } else if (entity instanceof Tank && n7 != 1 && n7 != 2 && n7 != 3) {
                    bl12 = false;
                }
                if (bl12) {
                    n6 = Compute.d6(2);
                    report = new Report(6072);
                    report.indent(2);
                    report.subject = n3;
                    report.add(n6);
                    report.newlines = 0;
                    vector.addElement(report);
                    if (n6 >= 7) {
                        report = new Report(6071);
                        report.subject = n3;
                        report.indent(2);
                        report.newlines = 0;
                        vector.addElement(report);
                        entity.setSpotlightState(false);
                        entity.setSpotlight(false);
                    }
                }
            }
            if (!bl2) {
                Object object2;
                int n8 = hitData.getLocation();
                Entity entity2 = entity.getExteriorUnitAt(n8, hitData.isRear());
                if (!bl && null != entity2 && !entity2.isDoomed()) {
                    report = new Report(6075);
                    report.subject = entity2.getId();
                    report.indent(3);
                    report.addDesc(entity2);
                    vector.addElement(report);
                    HitData hitData3 = entity2.rollHitLocation(0, 0);
                    int n9 = 0;
                    object2 = hitData3;
                    do {
                        if (0 < entity2.getArmor((HitData)object2)) {
                            n9 += entity2.getArmor((HitData)object2);
                        }
                        if (0 < entity2.getInternal((HitData)object2)) {
                            n9 += entity2.getInternal((HitData)object2);
                        }
                        object2 = entity2.getTransferLocation((HitData)object2);
                    } while (n > n9 && ((HitData)object2).getLocation() >= 0);
                    Server.combineVectors(vector, this.damageEntity(entity2, hitData3, n));
                    if (n > n9) {
                        report = new Report(6080);
                        report.subject = n3;
                        report.indent(1);
                        report.add(n -= n9);
                        report.addDesc(entity);
                        vector.addElement(report);
                    } else {
                        return vector;
                    }
                }
                int n10 = n6 = n8 == 1 || n8 == 2 || n8 == 3 ? 1 : 0;
                if (entity instanceof Mech && hitData.isRear() && n6 != 0) {
                    Enumeration enumeration = entity.getAmmo();
                    while (enumeration.hasMoreElements()) {
                        object2 = (Mounted)enumeration.nextElement();
                        if (!((Mounted)object2).isDumping() || ((Mounted)object2).isDestroyed() || ((Mounted)object2).isHit()) continue;
                        Server.combineVectors(vector, this.explodeEquipment(entity, ((Mounted)object2).getLocation(), (Mounted)object2));
                        ((Mounted)object2).setHit(true);
                    }
                }
            }
            if (!bl && entity.getArmor(hitData) > 0 && !bl2) {
                if (entity.getArmor(hitData) > n) {
                    entity.setArmor(entity.getArmor(hitData) - n, hitData);
                    entity.damageThisPhase += n;
                    n = 0;
                    report = new Report(6085);
                    report.subject = n3;
                    report.newlines = 0;
                    report.add(entity.getArmor(hitData));
                    vector.addElement(report);
                } else {
                    int n11 = Math.max(entity.getArmor(hitData), 0);
                    entity.setArmor(-3, hitData);
                    entity.damageThisPhase += n11;
                    n -= n11;
                    report = new Report(6090);
                    report.subject = n3;
                    report.newlines = 0;
                    vector.addElement(report);
                }
            }
            if (n > 0) {
                if (entity.getInternal(hitData) > 0) {
                    bl10 = true;
                    if (!bl7 && !bl5) {
                        ++n4;
                    }
                    int n12 = -1;
                    if (entity instanceof Mech && ((Mech)entity).hasCompositeStructure()) {
                        n12 = n;
                        n *= 2;
                    }
                    if (entity instanceof Mech && ((Mech)entity).hasReinforcedStructure()) {
                        n12 = n;
                        n /= 2;
                        n += n12 % 2;
                    }
                    if (entity.getInternal(hitData) > n) {
                        entity.setInternal(entity.getInternal(hitData) - n, hitData);
                        entity.damageThisPhase += n;
                        n = 0;
                        report = new Report();
                        report.subject = n3;
                        report.newlines = 0;
                        report.messageId = bl7 ? 6095 : 6100;
                        report.add(entity.getInternal(hitData));
                        vector.addElement(report);
                    } else {
                        int n13 = Math.max(entity.getInternal(hitData), 0);
                        if (entity instanceof Protomech && (n6 = Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()] - ((Protomech)entity).getPilotDamageTaken(hitData.getLocation())) > 0) {
                            Server.combineVectors(vector, this.damageCrew(entity, n6));
                            ((Protomech)entity).setPilotDamageTaken(hitData.getLocation(), Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()]);
                        }
                        report = new Report();
                        report.subject = n3;
                        report.newlines = 0;
                        report.messageId = bl7 ? 6105 : (bl5 ? 6110 : 6115);
                        vector.addElement(report);
                        if (entity instanceof Mech && (hitData.getLocation() == 2 && entity.getInternal(4) > 0 || hitData.getLocation() == 3 && entity.getInternal(5) > 0)) {
                            n6 = -1;
                            n6 = hitData.getLocation() == 2 ? 4 : 5;
                            report = new Report(6120);
                            report.subject = n3;
                            report.add(entity.getLocationName(n6));
                            report.newlines = 0;
                            vector.addElement(report);
                            IHex iHex2 = this.game.getBoard().getHex(entity.getPosition());
                            if (entity instanceof BipedMech) {
                                if (!iHex2.containsTerrain(18)) {
                                    iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(18, 1));
                                } else {
                                    iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex2.terrainLevel(18) + 1));
                                }
                            } else if (!iHex2.containsTerrain(19)) {
                                iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(19, 1));
                            } else {
                                iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex2.terrainLevel(19) + 1));
                            }
                            this.sendChangedHex(entity.getPosition());
                        }
                        this.destroyLocation(entity, hitData.getLocation());
                        entity.damageThisPhase += n13;
                        n -= n13;
                        if (n12 > 0) {
                            if (((Mech)entity).hasCompositeStructure()) {
                                n /= 2;
                            } else if (((Mech)entity).hasReinforcedStructure()) {
                                n *= 2;
                                n -= n12 % 2;
                            }
                        }
                        if (entity instanceof Mech && (hitData.getLocation() == 2 || hitData.getLocation() == 3)) {
                            n6 = 0;
                            int n14 = 0;
                            n14 += entity.getHitCriticals(0, 3, 1);
                            n14 += entity.getHitCriticals(0, 3, 2);
                            n6 = this.checkEngineExplosion(entity, vector, n14 += entity.getHitCriticals(0, 3, 3)) ? 1 : 0;
                            if (n6 == 0 && n14 > 2) {
                                Server.combineVectors(vector, this.destroyEntity(entity, "engine destruction"));
                            }
                        }
                        if (entity instanceof VTOL && hitData.getLocation() == 5) {
                            hitData.setEffect(2);
                        }
                    }
                }
                if (entity.getInternal(hitData) <= 0) {
                    hitData2 = entity.getTransferLocation(hitData);
                    if (hitData2.getLocation() == -2) {
                        if (entity instanceof Mech) {
                            entity.engineHitsThisRound += entity.getGoodCriticals(0, 3, hitData.getLocation());
                            entity.engineHitsThisRound -= entity.getHitCriticals(0, 3, hitData.getLocation());
                        }
                        boolean bl13 = false;
                        bl13 = this.checkEngineExplosion(entity, vector, entity.engineHitsThisRound);
                        if (!(bl13 || entity instanceof VTOL && hitData.getLocation() == 5)) {
                            Server.combineVectors(vector, this.destroyEntity(entity, "damage", !bl, !bl && !bl3 || hitData.getLocation() != 1));
                            if (hitData.getLocation() == 0 || hitData.getLocation() == 1 && (bl && !bl6 || bl3)) {
                                entity.getCrew().setDoomed(true);
                            }
                        }
                        n = 0;
                    } else if (hitData2.getLocation() == -1) {
                        n = 0;
                    } else if (bl && entity.locationHasCase(hitData.getLocation())) {
                        report = new Report(6125);
                        report.subject = n3;
                        report.add(n);
                        report.indent(3);
                        report.newlines = 0;
                        vector.addElement(report);
                        entity.damageThisPhase += n;
                        n = 0;
                    } else if (n > 0) {
                        report = new Report(6130);
                        report.subject = n3;
                        report.indent(2);
                        report.newlines = 0;
                        report.add(n);
                        report.add(entity.getLocationAbbr(hitData2));
                        vector.addElement(report);
                        object = entity.getWeapons();
                        while (object.hasMoreElements()) {
                            Mounted mounted = (Mounted)object.nextElement();
                            if (!mounted.isSplit() || mounted.getLocation() != hitData.getLocation() && mounted.getLocation() != hitData2.getLocation()) continue;
                            entity.setWeaponDestroyed(mounted);
                        }
                    }
                }
            } else if (hitData.getSpecCritMod() < 0) {
                ++n5;
            }
            Server.combineVectors(vector, this.breachCheck(entity, hitData.getLocation(), null));
            if (hitData.getEffect() == 3) {
                report = new Report(6135);
                report.subject = n3;
                report.indent(3);
                vector.addElement(report);
                int n15 = entity.getOriginalWalkMP();
                if (n15 > 0) {
                    entity.setOriginalWalkMP(n15 - 1);
                    if (entity.getOriginalWalkMP() == 0 && entity.getMovementMode() == 5 && this.game.getBoard().getHex(entity.getPosition()).terrainLevel(4) > 0 && !this.game.getBoard().getHex(entity.getPosition()).containsTerrain(20)) {
                        Server.combineVectors(vector, this.destroyEntity(entity, "a watery grave", false));
                    }
                }
            } else if (hitData.getEffect() == 2) {
                report = new Report(6140);
                report.subject = n3;
                report.indent(3);
                vector.addElement(report);
                ((Tank)entity).immobilize();
                iHex = this.game.getBoard().getHex(entity.getPosition());
                if (entity.getMovementMode() == 5 && iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20)) {
                    Server.combineVectors(vector, this.destroyEntity(entity, "a watery grave", false));
                }
                if (entity instanceof VTOL) {
                    Report.addNewline(vector);
                    Server.combineVectors(vector, this.crashVTOL((VTOL)entity));
                }
            } else if (hitData.getEffect() == 4) {
                report = new Report(6145);
                report.subject = n3;
                report.indent(3);
                vector.addElement(report);
                ((Tank)entity).lockTurret();
            }
            if (entity.getInternal(hitData) != -3) {
                int n16;
                for (n16 = 0; n16 < n4; ++n16) {
                    ++((Report)vector.elementAt((int)(vector.size() - 1))).newlines;
                    Server.combineVectors(vector, this.criticalEntity(entity, hitData.getLocation(), hitData.glancingMod()));
                }
                n4 = 0;
                for (n16 = 0; n16 < n5; ++n16) {
                    ++((Report)vector.elementAt((int)(vector.size() - 1))).newlines;
                    Server.combineVectors(vector, this.criticalEntity(entity, hitData.getLocation(), hitData.getSpecCritMod() + hitData.glancingMod()));
                }
                n5 = 0;
            }
            if (entity instanceof Mech && hitData.getLocation() == 0) {
                Report.addNewline(vector);
                Server.combineVectors(vector, this.damageCrew(entity, 1));
            }
            hitData = hitData2;
            if (!bl2) continue;
            bl9 = true;
            bl2 = false;
        }
        if (bl10 && (entity instanceof Mech || entity instanceof Protomech) && entity.hasActiveEiCockpit()) {
            Report.addNewline(vector);
            int n17 = Compute.d6(2);
            report = new Report(5075);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(7);
            report.add(n17);
            report.choose(n17 >= 7);
            report.indent(2);
            vector.add(report);
            if (n17 < 7) {
                Server.combineVectors(vector, this.damageCrew(entity, 1));
            }
        }
        if (bl9) {
            Report.addNewline(vector);
        }
        return vector;
    }

    private boolean checkEngineExplosion(Entity entity, Vector vector, int n) {
        int n2;
        if (!(entity instanceof Mech || entity instanceof QuadMech || entity instanceof BipedMech)) {
            return false;
        }
        if (entity.isDoomed() || entity.isDestroyed()) {
            return false;
        }
        Mech mech = (Mech)entity;
        if (!(mech.hasICE() || this.game.getOptions().booleanOption("engine_explosions") && !entity.rolledForEngineExplosion && entity.engineHitsThisRound >= 2)) {
            return false;
        }
        int n3 = 12;
        if (mech.hasICE()) {
            switch (n) {
                case 0: {
                    return false;
                }
                case 1: {
                    n3 = 10;
                    break;
                }
                case 2: {
                    n3 = 7;
                    break;
                }
                default: {
                    n3 = 4;
                }
            }
        }
        boolean bl = (n2 = Compute.d6(2)) >= n3;
        Report report = new Report(6150);
        report.subject = entity.getId();
        report.indent(2);
        report.addDesc(entity);
        report.add(entity.engineHitsThisRound);
        vector.addElement(report);
        report = new Report(6155);
        report.subject = entity.getId();
        report.indent(2);
        report.add(n3);
        report.add(n2);
        vector.addElement(report);
        entity.rolledForEngineExplosion = true;
        if (!bl) {
            report = new Report(6160);
            report.subject = entity.getId();
            report.indent(2);
            vector.addElement(report);
        } else {
            IHex iHex;
            report = new Report(6165, 0);
            report.subject = entity.getId();
            report.indent(2);
            vector.addElement(report);
            Server.combineVectors(vector, this.destroyEntity(entity, "engine explosion", false, false));
            entity.getCrew().setDoomed(true);
            if (entity instanceof Mech) {
                this.destroyLocation(entity, 1);
            }
            if (null != (iHex = this.game.getBoard().getHex(entity.getPosition())) && !iHex.containsTerrain(7) && (iHex.containsTerrain(1) || iHex.containsTerrain(23))) {
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                report = new Report(6170, 0);
                report.subject = entity.getId();
                report.indent(2);
                report.add(entity.getPosition().getBoardNum());
                vector.addElement(report);
                this.sendChangedHex(entity.getPosition());
            }
            if (!mech.hasICE()) {
                Enumeration enumeration = this.game.getEntities(entity.getPosition());
                Hashtable<Entity, Entity> hashtable = new Hashtable<Entity, Entity>();
                hashtable.put(entity, entity);
                while (enumeration.hasMoreElements()) {
                    Entity entity2 = (Entity)enumeration.nextElement();
                    if (entity2.equals(entity)) continue;
                    Server.combineVectors(vector, this.destroyEntity(entity2, "engine explosion proximity", false, false));
                    entity2.getCrew().setDoomed(true);
                    hashtable.put(entity2, entity2);
                }
                int n4 = ((Mech)entity).engineRating();
                int[] nArray = new int[]{999, n4 / 10, n4 / 20, n4 / 40};
                Vector vector2 = this.game.getEntitiesVector();
                for (int i = 0; i < vector2.size(); ++i) {
                    int n5;
                    int n6;
                    int n7;
                    Entity entity3 = (Entity)vector2.elementAt(i);
                    if (hashtable.containsKey(entity3) || entity3.isDoomed() || entity3.isDestroyed() || !entity3.isDeployed() || (n7 = entity.getPosition().distance(entity3.getPosition())) > 3) continue;
                    report = new Report(6175);
                    report.subject = entity3.getId();
                    report.indent(2);
                    report.addDesc(entity3);
                    report.add(n6);
                    report.newlines = 0;
                    vector.addElement(report);
                    for (n6 = nArray[n7]; n6 > 0; n6 -= n5) {
                        n5 = Math.min(5, n6);
                        HitData hitData = entity3.rollHitLocation(0, Compute.targetSideTable(entity, entity3));
                        Server.combineVectors(vector, this.damageEntity(entity3, hitData, n5));
                    }
                    Report.addNewline(vector);
                }
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vector applyCriticalHit(Entity entity, int n, CriticalSlot criticalSlot, boolean bl) {
        Report report;
        RoundUpdated roundUpdated;
        Vector<Report> vector;
        block51: {
            block52: {
                block53: {
                    int n2;
                    block50: {
                        vector = new Vector<Report>();
                        if (!(entity instanceof Tank)) break block50;
                        roundUpdated = (Tank)entity;
                        VTOL vTOL = null;
                        if (entity instanceof VTOL) {
                            vTOL = (VTOL)entity;
                        }
                        report = new Report(6180);
                        report.subject = entity.getId();
                        report.indent(3);
                        report.newlines = 0;
                        vector.addElement(report);
                        switch (criticalSlot.getIndex()) {
                            case 1: {
                                if (vTOL == null) {
                                    report = new Report(6185);
                                    report.subject = entity.getId();
                                    report.newlines = 0;
                                    vector.addElement(report);
                                    ((Tank)roundUpdated).stunCrew();
                                    break;
                                }
                                report = new Report(6190);
                                report.subject = entity.getId();
                                report.newlines = 0;
                                vector.addElement(report);
                                Server.combineVectors(vector, this.destroyEntity(vTOL, "crew death", true));
                                entity.getCrew().setDoomed(true);
                                Server.combineVectors(vector, this.crashVTOL(vTOL));
                                break;
                            }
                            case 2: {
                                Mounted mounted = ((Tank)roundUpdated).getMainWeapon();
                                if (mounted == null) {
                                    report = new Report(6195);
                                    report.subject = entity.getId();
                                    report.newlines = 0;
                                    vector.addElement(report);
                                    break;
                                }
                                report = new Report(6200);
                                report.subject = entity.getId();
                                report.add(mounted.getName());
                                int n3 = ((Tank)roundUpdated).getJammedTurns() + 1;
                                if (n3 > 1) {
                                    report.messageId = 6205;
                                    report.add(n3);
                                }
                                report.newlines = 0;
                                vector.addElement(report);
                                ((Tank)roundUpdated).setJammedTurns(n3);
                                break;
                            }
                            case 3: {
                                report = new Report(6210);
                                report.subject = entity.getId();
                                report.newlines = 0;
                                vector.addElement(report);
                                ((Tank)roundUpdated).immobilize();
                                if (bl) {
                                    IHex iHex = this.game.getBoard().getHex(entity.getPosition());
                                    if (vTOL == null) {
                                        if (entity.getMovementMode() != 5 || iHex.terrainLevel(4) <= 0 || iHex.containsTerrain(20)) break;
                                        Server.combineVectors(vector, this.destroyEntity(entity, "a watery grave", false));
                                        break;
                                    }
                                    Report.addNewline(vector);
                                    Server.combineVectors(vector, this.crashVTOL(vTOL));
                                    break;
                                }
                                break block51;
                            }
                            case 4: {
                                report = new Report(6190);
                                report.subject = entity.getId();
                                report.newlines = 0;
                                vector.addElement(report);
                                Server.combineVectors(vector, this.destroyEntity(entity, "crew death", true));
                                entity.getCrew().setDoomed(true);
                                if (vTOL != null) {
                                    Report.addNewline(vector);
                                    Server.combineVectors(vector, this.crashVTOL(vTOL));
                                    break;
                                }
                                break block51;
                            }
                            case 5: {
                                report = new Report(6215);
                                report.subject = entity.getId();
                                report.newlines = 0;
                                vector.addElement(report);
                                if (vTOL == null) {
                                    Server.combineVectors(vector, this.destroyEntity(entity, "fuel tank explosion", false, false));
                                } else {
                                    Report.addNewline(vector);
                                    Server.combineVectors(vector, this.explodeVTOL(vTOL));
                                }
                                entity.getCrew().setDoomed(true);
                                break;
                            }
                            case 6: {
                                report = new Report(6220);
                                report.subject = entity.getId();
                                report.newlines = 0;
                                vector.addElement(report);
                                boolean bl2 = entity.locationHasCase(0);
                                if (vTOL == null) {
                                    Server.combineVectors(vector, this.destroyEntity(entity, "power plant destruction", bl2, bl2));
                                } else {
                                    Report.addNewline(vector);
                                    Server.combineVectors(vector, this.explodeVTOL(vTOL));
                                }
                                entity.getCrew().setDoomed(!bl2);
                                break;
                            }
                        }
                        break block51;
                    }
                    if (0 != criticalSlot.getType()) break block52;
                    criticalSlot.setHit(true);
                    if (!(entity instanceof Protomech)) break block53;
                    int n4 = ((Protomech)entity).getCritsHit(n);
                    if (criticalSlot.getIndex() != 4 && criticalSlot.getIndex() != 5) {
                        report = new Report(6225);
                        report.subject = entity.getId();
                        report.indent(3);
                        report.newlines = 0;
                        report.add(Protomech.systemNames[criticalSlot.getIndex()]);
                        vector.addElement(report);
                    }
                    block8 : switch (criticalSlot.getIndex()) {
                        case 2: {
                            if (2 != n4) break;
                            report = new Report(6230);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            this.destroyLocation(entity, n);
                            break;
                        }
                        case 0: {
                            if (2 != n4) break;
                            report = new Report(6235);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            this.destroyLocation(entity, n);
                            break;
                        }
                        case 1: {
                            if (3 != n4) break;
                            report = new Report(6240);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            this.destroyLocation(entity, n);
                            break;
                        }
                        case 3: {
                            if (3 == n4) {
                                Server.combineVectors(vector, this.destroyEntity(entity, "torso destruction"));
                                break;
                            }
                            if (!bl) break;
                            int n5 = Compute.d6(1);
                            CriticalSlot criticalSlot2 = null;
                            switch (n5) {
                                case 1: 
                                case 2: {
                                    criticalSlot2 = new CriticalSlot(0, 4);
                                    Server.combineVectors(vector, this.applyCriticalHit(entity, -1, criticalSlot2, bl));
                                    break block8;
                                }
                                case 3: 
                                case 4: {
                                    criticalSlot2 = new CriticalSlot(0, 5);
                                    Server.combineVectors(vector, this.applyCriticalHit(entity, -1, criticalSlot2, bl));
                                    break block8;
                                }
                            }
                            break;
                        }
                        case 4: {
                            Mounted mounted = ((Protomech)entity).getTorsoWeapon(true);
                            if (null == mounted) break;
                            mounted.setHit(true);
                            report = new Report(6245);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            break;
                        }
                        case 5: {
                            Mounted mounted = ((Protomech)entity).getTorsoWeapon(false);
                            if (null == mounted) break;
                            mounted.setHit(true);
                            report = new Report(6250);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            break;
                        }
                    }
                    if (((Protomech)entity).shaded(n, n4) && Math.min(1, n2 = Protomech.POSSIBLE_PILOT_DAMAGE[n] - ((Protomech)entity).getPilotDamageTaken(n)) > 0) {
                        Report.addNewline(vector);
                        Server.combineVectors(vector, this.damageCrew(entity, 1));
                        n2 = 1 + ((Protomech)entity).getPilotDamageTaken(n);
                        ((Protomech)entity).setPilotDamageTaken(n, n2);
                    }
                    break block51;
                }
                report = new Report(6225);
                report.subject = entity.getId();
                report.indent(3);
                report.add(((Mech)entity).getSystemName(criticalSlot.getIndex()));
                report.newlines = 0;
                vector.addElement(report);
                switch (criticalSlot.getIndex()) {
                    case 2: {
                        if (6 > entity.getCrew().getHits()) {
                            entity.getCrew().setDoomed(true);
                            Report.addNewline(vector);
                            Server.combineVectors(vector, this.destroyEntity(entity, "pilot death", true));
                            break;
                        }
                        break block51;
                    }
                    case 3: {
                        ++entity.engineHitsThisRound;
                        boolean bl3 = false;
                        int n6 = 0;
                        n6 += entity.getHitCriticals(0, 3, 1);
                        n6 += entity.getHitCriticals(0, 3, 2);
                        bl3 = this.checkEngineExplosion(entity, vector, n6 += entity.getHitCriticals(0, 3, 3));
                        if (!bl3 && n6 > 2) {
                            Server.combineVectors(vector, this.destroyEntity(entity, "engine destruction"));
                            break;
                        }
                        break block51;
                    }
                    case 4: {
                        if (entity.getHitCriticals(0, 4, n) > 1) {
                            this.game.addPSR(new PilotingRollData(entity.getId(), 0x7FFFFFFE, 3, "gyro destroyed"));
                            break;
                        }
                        this.game.addPSR(new PilotingRollData(entity.getId(), 3, "gyro hit"));
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 1, "leg/foot actuator hit"));
                        break;
                    }
                    case 11: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 2, "hip actuator hit"));
                        break;
                    }
                }
                break block51;
            }
            if (1 == criticalSlot.getType()) {
                criticalSlot.setHit(true);
                roundUpdated = entity.getEquipment(criticalSlot.getIndex());
                EquipmentType equipmentType = ((Mounted)roundUpdated).getType();
                boolean bl4 = ((Mounted)roundUpdated).isHit();
                report = new Report(6225);
                report.subject = entity.getId();
                report.indent(3);
                report.add(((Mounted)roundUpdated).getDesc());
                report.newlines = 0;
                vector.addElement(report);
                ((Mounted)roundUpdated).setHit(true);
                if (!bl4 && equipmentType instanceof MiscType && equipmentType.hasFlag(1024) && ((Mounted)roundUpdated).getLinkedBy() != null) {
                    Mounted mounted = ((Mounted)roundUpdated).getLinkedBy();
                    report = new Report(6255);
                    report.subject = entity.getId();
                    report.indent(2);
                    report.add(mounted.getType().getName());
                    report.newlines = 0;
                    vector.addElement(report);
                    mounted.setMode("Off");
                }
                if (bl && equipmentType.isExplosive() && !bl4) {
                    Server.combineVectors(vector, this.explodeEquipment(entity, n, (Mounted)roundUpdated));
                }
                if (((Mounted)roundUpdated).getShotsLeft() > 0) {
                    ((Mounted)roundUpdated).setShotsLeft(0);
                }
            }
        }
        if (entity instanceof Mech && entity.hitThisRoundByAntiTSM) {
            roundUpdated = (Mech)entity;
            if (((Mech)roundUpdated).hasTSM()) {
                report = new Report(6430);
                report.subject = entity.getId();
                report.indent(2);
                report.addDesc(entity);
                report.newlines = 0;
                vector.addElement(report);
                Server.combineVectors(vector, this.oneCriticalEntity(entity, Compute.d6(2)));
            }
            entity.hitThisRoundByAntiTSM = false;
        }
        return vector;
    }

    private Vector criticalEntity(Entity entity, int n) {
        return this.criticalEntity(entity, n, 0, true);
    }

    private Vector criticalEntity(Entity entity, int n, int n2) {
        return this.criticalEntity(entity, n, n2, true);
    }

    private Vector oneCriticalEntity(Entity entity, int n) {
        return this.criticalEntity(entity, n, 0, false);
    }

    private Vector crashVTOL(VTOL vTOL, Coords coords, int n) {
        return this.crashVTOL(vTOL, false, 0, coords, n, 0);
    }

    private Vector crashVTOL(VTOL vTOL) {
        return this.crashVTOL(vTOL, false, 0, vTOL.getPosition(), vTOL.getElevation(), 0);
    }

    private Vector crashVTOL(VTOL vTOL, boolean bl, int n, Coords coords, int n2, int n3) {
        Vector<Report> vector = new Vector<Report>();
        if (!bl) {
            Report report = new Report(6260);
            report.subject = vTOL.getId();
            report.newlines = 0;
            report.addDesc(vTOL);
            vector.addElement(report);
            int n4 = n2;
            if (n4 == 0) {
                report = new Report(6265);
                report.subject = vTOL.getId();
                vector.addElement(report);
            } else {
                int n5;
                int n6;
                int n7;
                String string;
                report = new Report(6270);
                report.subject = vTOL.getId();
                report.add(n4);
                vector.addElement(report);
                IHex iHex = this.game.getBoard().getHex(coords);
                int n8 = Compute.d6();
                switch (n8) {
                    case 1: 
                    case 2: {
                        string = "right side";
                        n7 = 3;
                        break;
                    }
                    case 3: {
                        string = "rear";
                        n7 = 1;
                        break;
                    }
                    case 4: 
                    case 5: {
                        string = "left side";
                        n7 = 2;
                        break;
                    }
                    default: {
                        string = "front";
                        n7 = 0;
                    }
                }
                boolean bl2 = iHex.containsTerrain(4);
                if (bl2 && iHex.containsTerrain(20)) {
                    n6 = Compute.d6(1);
                    report = new Report(2118);
                    report.subject = vTOL.getId();
                    report.add(vTOL.getDisplayName(), true);
                    report.add(n6);
                    report.subject = vTOL.getId();
                    this.vPhaseReport.addElement(report);
                    if (n6 == 6) {
                        this.resolveIceBroken(coords);
                    } else {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    report = new Report(6275);
                    report.subject = vTOL.getId();
                    vector.addElement(report);
                    vTOL.destroy("Fell into water", false, false);
                }
                n6 = (int)Math.round((double)vTOL.getWeight() / 10.0) * (n4 + 1);
                n6 = Math.round((float)n6 * this.game.getOptions().floatOption("gravity"));
                report = new Report(6280);
                report.subject = vTOL.getId();
                report.indent();
                report.addDesc(vTOL);
                report.add(string);
                report.add(n6);
                report.newlines = 0;
                vector.addElement(report);
                vTOL.setFacing((vTOL.getFacing() + (n8 - 1)) % 6);
                if (iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20)) {
                    for (n5 = 0; n5 < vTOL.locations(); ++n5) {
                        vTOL.setLocationStatus(n5, 2);
                    }
                }
                n5 = 0;
                while (n6 > 0) {
                    int n9 = Math.min(5, n6);
                    HitData hitData = vTOL.rollHitLocation(0, n7);
                    int[] nArray = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                    Server.combineVectors(vector, this.damageEntity(vTOL, hitData, n9));
                    int[] nArray2 = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                    for (int i = 0; i <= 3; ++i) {
                        if (nArray[i] == nArray2[i]) continue;
                        n5 = 1;
                    }
                    n6 -= n9;
                }
                if (n5 != 0) {
                    report = new Report(6285);
                    report.subject = vTOL.getId();
                    report.addDesc(vTOL);
                    vector.addElement(report);
                    Server.combineVectors(vector, this.explodeVTOL(vTOL));
                }
                this.doSetLocationsExposure(vTOL, iHex, false, 0);
                vTOL.setElevation(0);
            }
        } else {
            int n10;
            vTOL.setElevation(0);
            Report report = new Report(6290);
            report.subject = vTOL.getId();
            report.addDesc(vTOL);
            vector.addElement(report);
            boolean bl3 = false;
            for (int i = (int)Math.round((double)vTOL.getWeight() / 10.0) * (n + 1); i > 0; i -= n10) {
                n10 = Math.min(5, i);
                HitData hitData = vTOL.rollHitLocation(0, n3);
                int[] nArray = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                Server.combineVectors(vector, this.damageEntity(vTOL, hitData, n10));
                int[] nArray3 = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                for (int j = 0; j <= 3; ++j) {
                    if (nArray[j] == nArray3[j]) continue;
                    bl3 = true;
                }
            }
            if (bl3) {
                report = new Report(6295);
                report.subject = vTOL.getId();
                report.addDesc(vTOL);
                vector.addElement(report);
                Server.combineVectors(vector, this.explodeVTOL(vTOL));
            }
        }
        return vector;
    }

    private Vector explodeVTOL(VTOL vTOL) {
        Vector<Report> vector = new Vector<Report>();
        if (vTOL.getEngineType() != 1) {
            Report report = new Report(6300);
            report.subject = vTOL.getId();
            vector.addElement(report);
        } else {
            Coords coords = vTOL.getPosition();
            IHex iHex = this.game.getBoard().getHex(coords);
            if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
            } else {
                this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
                ((InfernoTracker)this.game.getBoard().getInfernos().get(coords)).setTurnsLeftToBurn(this.game.getBoard().getInfernoBurnTurns(coords) - this.game.getBoard().getInfernoIVBurnTurns(coords) - 2);
            }
        }
        return vector;
    }

    private Vector criticalEntity(Entity entity, int n, int n2, boolean bl) {
        int n3;
        int n4;
        Report report;
        CriticalSlot criticalSlot = null;
        Vector<Report> vector = new Vector<Report>();
        Coords coords = entity.getPosition();
        IHex iHex = null;
        if (bl) {
            if (null != coords) {
                iHex = this.game.getBoard().getHex(coords);
            }
            report = new Report(6305);
            report.subject = entity.getId();
            report.indent(2);
            report.add(entity.getLocationAbbr(n));
            report.newlines = 0;
            vector.addElement(report);
            n4 = 0;
            n3 = Compute.d6(2);
            report = new Report(6310);
            report.subject = entity.getId();
            String string = new String();
            if (n2 != 0) {
                string = "(" + n3;
                if (n2 > 0) {
                    string = string + "+";
                }
                string = string + n2 + ") = ";
                n3 += n2;
            }
            string = string + n3;
            report.add(string);
            report.newlines = 0;
            vector.addElement(report);
            if (n3 <= 7) {
                report = new Report(6005);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
                return vector;
            }
            if (n3 >= 8 && n3 <= 9) {
                n4 = 1;
                report = new Report(6315);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
            } else if (n3 >= 10 && n3 <= 11) {
                n4 = 2;
                report = new Report(6320);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
            } else if (n3 == 12) {
                if (entity instanceof Tank || entity instanceof Protomech) {
                    n4 = 3;
                    report = new Report(6325);
                    report.subject = entity.getId();
                    report.newlines = 0;
                    vector.addElement(report);
                } else {
                    if (entity.locationIsLeg(n)) {
                        report = new Report(6120);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        if (entity.getInternal(n) > 0) {
                            this.destroyLocation(entity, n);
                        }
                        if (null != iHex) {
                            if (!iHex.containsTerrain(19)) {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, 1));
                            } else {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex.terrainLevel(19) + 1));
                            }
                        }
                        this.sendChangedHex(entity.getPosition());
                        return vector;
                    }
                    if (n == 4 || n == 5) {
                        report = new Report(6120);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        this.destroyLocation(entity, n);
                        if (null != iHex) {
                            if (!iHex.containsTerrain(18)) {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, 1));
                            } else {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex.terrainLevel(18) + 1));
                            }
                        }
                        this.sendChangedHex(entity.getPosition());
                        return vector;
                    }
                    if (n == 0) {
                        report = new Report(6330);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        this.destroyLocation(entity, n);
                        if (6 > entity.getCrew().getHits()) {
                            entity.crew.setDoomed(true);
                            Report.addNewline(vector);
                            Server.combineVectors(vector, this.destroyEntity(entity, "pilot death", true));
                        }
                        return vector;
                    }
                    n4 = 3;
                    report = new Report(6325);
                    report.subject = entity.getId();
                    report.newlines = 0;
                    vector.addElement(report);
                }
            }
        } else {
            n4 = 1;
        }
        if (entity instanceof Tank) {
            Tank tank = (Tank)entity;
            for (int i = 0; i < n4; ++i) {
                criticalSlot = new CriticalSlot(0, Compute.d6(1));
                Server.combineVectors(vector, this.applyCriticalHit(entity, -1, criticalSlot, true));
            }
        } else {
            while (n4 > 0 && entity.canTransferCriticals(n) && entity.getTransferLocation(n) != -2) {
                n = entity.getTransferLocation(n);
                report = new Report(6335);
                report.subject = entity.getId();
                report.indent(3);
                report.add(entity.getLocationAbbr(n));
                report.newlines = 0;
                vector.addElement(report);
            }
            while (n4 > 0) {
                if (entity.getHittableCriticals(n) <= 0) {
                    report = new Report(6340);
                    report.subject = entity.getId();
                    report.indent(3);
                    report.newlines = 0;
                    vector.addElement(report);
                    break;
                }
                n3 = Compute.randomInt(entity.getNumberOfCriticals(n));
                criticalSlot = entity.getCritical(n, n3);
                if (criticalSlot == null || !criticalSlot.isHittable()) continue;
                Server.combineVectors(vector, this.applyCriticalHit(entity, n, criticalSlot, true));
                --n4;
            }
        }
        return vector;
    }

    private Vector breachCheck(Entity entity, int n, IHex iHex) {
        Vector<Report> vector = new Vector<Report>();
        if (entity instanceof Infantry) {
            return vector;
        }
        if (entity instanceof VTOL) {
            return vector;
        }
        if (entity.getLocationStatus(n) > 0) {
            int n2 = 0;
            if (!(entity.getArmor(n) <= 0 || entity instanceof Mech && entity.getArmor(n, true) <= 0 || null != iHex)) {
                n2 = Compute.d6(2);
                Report report = new Report(6345);
                report.subject = entity.getId();
                report.indent(3);
                report.add(entity.getLocationAbbr(n));
                report.add(n2);
                report.newlines = 0;
                vector.addElement(report);
            }
            if (n2 >= 10 || entity.getArmor(n) <= 0 || entity instanceof Mech && entity.getArmor(n, true) <= 0) {
                Server.combineVectors(vector, this.breachLocation(entity, n, iHex));
            }
        }
        return vector;
    }

    private Vector breachLocation(Entity entity, int n, IHex iHex) {
        Serializable serializable;
        Vector<Report> vector = new Vector<Report>();
        if (entity.getInternal(n) < 0 || entity.getLocationStatus(n) < 0) {
            return vector;
        }
        Report report = new Report(6350);
        report.subject = entity.getId();
        report.add(entity.getShortName());
        report.add(entity.getLocationAbbr(n));
        report.newlines = 0;
        vector.addElement(report);
        if (entity instanceof Tank) {
            Server.combineVectors(vector, this.destroyEntity(entity, "hull breach", true, true));
            return vector;
        }
        Enumeration enumeration = entity.getEquipment();
        while (enumeration.hasMoreElements()) {
            serializable = (Mounted)enumeration.nextElement();
            if (((Mounted)serializable).getLocation() != n) continue;
            ((Mounted)serializable).setBreached(true);
        }
        for (int i = 0; i < entity.getNumberOfCriticals(n); ++i) {
            serializable = entity.getCritical(n, i);
            if (serializable == null) continue;
            if (entity.locationIsLeg(n) && ((CriticalSlot)serializable).isHittable()) {
                switch (((CriticalSlot)serializable).getIndex()) {
                    case 12: 
                    case 13: 
                    case 14: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 1, "leg/foot actuator hit"));
                        break;
                    }
                    case 11: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 0, "hip actuator hit"));
                    }
                }
            }
            ((CriticalSlot)serializable).setBreached(true);
        }
        if (n == 1) {
            Server.combineVectors(vector, this.destroyEntity(entity, "hull breach"));
        }
        if (n == 0) {
            entity.crew.setDoomed(true);
            Server.combineVectors(vector, this.destroyEntity(entity, "hull breach"));
            if (entity.getLocationStatus(n) == 2) {
                report = new Report(6355);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            } else {
                report = new Report(6360);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            }
        }
        entity.setLocationStatus(n, -1);
        if (entity.getHitCriticals(0, 3, 3) + entity.getHitCriticals(0, 3, 1) + entity.getHitCriticals(0, 3, 2) >= 3) {
            Server.combineVectors(vector, this.destroyEntity(entity, "engine destruction"));
        }
        return vector;
    }

    void destroyLocation(Entity entity, int n) {
        Serializable serializable;
        if (entity.getInternal(n) < 0) {
            return;
        }
        entity.setArmor(-2, n, false);
        entity.setInternal(-2, n);
        if (entity.hasRearArmor(n)) {
            entity.setArmor(-2, n, true);
        }
        Enumeration enumeration = entity.getEquipment();
        while (enumeration.hasMoreElements()) {
            serializable = (Mounted)enumeration.nextElement();
            if (((Mounted)serializable).getLocation() != n) continue;
            ((Mounted)serializable).setMissing(true);
        }
        for (int i = 0; i < entity.getNumberOfCriticals(n); ++i) {
            serializable = entity.getCritical(n, i);
            if (serializable == null) continue;
            if (((CriticalSlot)serializable).getType() == 0 && ((CriticalSlot)serializable).getIndex() == 3 && !((CriticalSlot)serializable).isDamaged()) {
                ++entity.engineHitsThisRound;
            }
            ((CriticalSlot)serializable).setMissing(true);
        }
        if (entity instanceof Mech && entity.locationIsLeg(n)) {
            this.game.addPSR(new PilotingRollData(entity.getId(), 0x7FFFFFFE, 5, "leg destroyed"));
        }
        if (entity.getDependentLocation(n) != -1) {
            this.destroyLocation(entity, entity.getDependentLocation(n));
        }
    }

    private Vector destroyEntity(Entity entity, String string) {
        return this.destroyEntity(entity, string, true);
    }

    private Vector destroyEntity(Entity entity, String string, boolean bl) {
        return this.destroyEntity(entity, string, bl, true);
    }

    private Vector destroyEntity(Entity entity, String string, boolean bl, boolean bl2) {
        Vector<Report> vector = new Vector<Report>();
        int n = 512;
        if (!bl2) {
            entity.setSalvage(bl2);
            n = 1024;
        }
        if (!entity.isDoomed() && !entity.isDestroyed()) {
            int n2;
            int n3;
            Object object;
            Serializable serializable;
            Serializable serializable2;
            Report report = new Report(6365);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(string);
            report.newlines = 0;
            vector.addElement(report);
            entity.setDoomed(true);
            Enumeration enumeration = entity.getPickedUpMechWarriors().elements();
            while (enumeration.hasMoreElements()) {
                serializable2 = (Integer)enumeration.nextElement();
                serializable = this.game.getEntity((Integer)serializable2);
                ((Entity)serializable).setDestroyed(true);
                this.game.removeEntity(((Entity)serializable).getId(), n);
                this.entityUpdate(((Entity)serializable).getId());
                this.send(this.createRemoveEntityPacket(((Entity)serializable).getId(), n));
                report = new Report(6370);
                report.subject = ((Entity)serializable).getId();
                report.addDesc((Entity)serializable);
                vector.addElement(report);
            }
            enumeration = entity.getLoadedUnits().elements();
            if (enumeration.hasMoreElements()) {
                serializable2 = null;
                serializable = entity.getPosition();
                object = this.game.getBoard().getHex((Coords)serializable);
                int n4 = entity.getFacing();
                while (enumeration.hasMoreElements()) {
                    serializable2 = (Entity)enumeration.nextElement();
                    if (!bl) {
                        ((Entity)serializable2).setDestroyed(true);
                        this.game.moveToGraveyard(((Entity)serializable2).getId());
                        this.entityUpdate(((Entity)serializable2).getId());
                        this.send(this.createRemoveEntityPacket(((Entity)serializable2).getId(), n));
                        report = new Report(6370);
                        report.subject = ((Entity)serializable2).getId();
                        report.addDesc((Entity)serializable2);
                        vector.addElement(report);
                        continue;
                    }
                    if (null != Compute.stackingViolation(this.game, ((Entity)serializable2).getId(), (Coords)serializable) || ((Entity)serializable2).isHexProhibited((IHex)object)) {
                        ((Entity)serializable2).setDestroyed(true);
                        this.game.moveToGraveyard(((Entity)serializable2).getId());
                        this.entityUpdate(((Entity)serializable2).getId());
                        this.send(this.createRemoveEntityPacket(((Entity)serializable2).getId(), n));
                        report = new Report(6375);
                        report.subject = ((Entity)serializable2).getId();
                        report.addDesc((Entity)serializable2);
                        vector.addElement(report);
                        continue;
                    }
                    this.unloadUnit(entity, (Targetable)((Object)serializable2), (Coords)serializable, n4, entity.getElevation());
                }
            }
            if (-1 != entity.getTransportId()) {
                serializable2 = this.game.getEntity(entity.getTransportId());
                serializable = ((Entity)serializable2).getPosition();
                int n5 = ((Entity)serializable2).getFacing();
                this.unloadUnit((Entity)serializable2, entity, (Coords)serializable, n5, ((Entity)serializable2).getElevation());
                this.entityUpdate(((Entity)serializable2).getId());
            }
            if (-1 != (n3 = entity.getSwarmAttackerId())) {
                serializable = this.game.getEntity(n3);
                this.game.removeTurnFor((Entity)serializable);
                this.send(this.createTurnVectorPacket());
                ((Entity)serializable).setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report = new Report(6380);
                report.subject = n3;
                report.addDesc((Entity)serializable);
                vector.addElement(report);
                this.entityUpdate(n3);
            }
            if (-1 != (n2 = entity.getSwarmTargetId())) {
                object = this.game.getEntity(n2);
                ((Entity)object).setSwarmAttackerId(-1);
                entity.setSwarmTargetId(-1);
                report = new Report(6385);
                report.subject = ((Entity)object).getId();
                report.addDesc((Entity)object);
                vector.addElement(report);
                this.entityUpdate(n2);
            }
        }
        this.entityUpdate(entity.getId());
        return vector;
    }

    private Vector explodeEquipment(Entity entity, int n, int n2) {
        return this.explodeEquipment(entity, n, entity.getEquipment(entity.getCritical(n, n2).getIndex()));
    }

    private Vector explodeEquipment(Entity entity, int n, Mounted mounted) {
        int n2;
        Vector<Report> vector = new Vector<Report>();
        if (mounted.isDestroyed()) {
            System.err.println("server: explodeEquipment called on destroyed equipment (" + mounted.getName() + ")");
            return null;
        }
        if (mounted.getType() instanceof WeaponType && ((WeaponType)mounted.getType()).getAmmoType() == 23 && !mounted.isJammed()) {
            return null;
        }
        if (mounted.getType() instanceof WeaponType && ((WeaponType)mounted.getType()).getAmmoType() == 1) {
            if (!mounted.isUsedThisRound()) {
                return null;
            }
            Mounted mounted2 = mounted.getLinked();
            if (mounted2 == null || !(mounted2.getType() instanceof AmmoType) || ((AmmoType)mounted2.getType()).getMunitionType() != 8L) {
                return null;
            }
        }
        if (mounted.getType() instanceof AmmoType && (((AmmoType)mounted.getType()).getAmmoType() == 9 || ((AmmoType)mounted.getType()).getAmmoType() == 25) && ((AmmoType)mounted.getType()).getMunitionType() == 0x400000L && mounted.getShotsLeft() > 0) {
            entity.heatBuildup += 30;
        }
        if ((n2 = mounted.getExplosionDamage()) <= 0) {
            return null;
        }
        Report report = new Report(6390);
        report.subject = entity.getId();
        report.add(mounted.getName());
        report.add(n2);
        report.indent(3);
        report.newlines = 0;
        vector.addElement(report);
        mounted.setShotsLeft(0);
        Server.combineVectors(vector, this.damageEntity(entity, new HitData(n), n2, true));
        Report.addNewline(vector);
        int n3 = 2;
        if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
            n3 = 1;
        }
        if (entity.getCrew().getOptions().booleanOption("iron_man")) {
            n3 = 1;
        }
        Server.combineVectors(vector, this.damageCrew(entity, n3));
        if (entity.crew.isDoomed() || entity.crew.isDead()) {
            Server.combineVectors(vector, this.destroyEntity(entity, "crew death", true));
        } else {
            Report.addNewline(vector);
        }
        return vector;
    }

    private Vector explodeAmmoFromHeat(Entity entity) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Vector vector = new Vector();
        for (int i = 0; i < entity.locations(); ++i) {
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                AmmoType ammoType;
                Mounted mounted;
                CriticalSlot criticalSlot = entity.getCritical(i, j);
                if (criticalSlot == null || criticalSlot.isDestroyed() || criticalSlot.isHit() || criticalSlot.getType() != 1 || !((mounted = entity.getEquipment(entity.getCritical(i, j).getIndex())).getType() instanceof AmmoType) || !(ammoType = (AmmoType)mounted.getType()).isExplosive() || ammoType.getShots() == 0) continue;
                int n5 = ammoType.getDamagePerShot() * ammoType.getRackSize();
                int n6 = mounted.getExplosionDamage();
                if (mounted.isHit() || n2 >= n5 && (n2 != n5 || n >= n6)) continue;
                n2 = n5;
                n = n6;
                n3 = i;
                n4 = j;
            }
        }
        if (n3 != -1 && n4 != -1) {
            CriticalSlot criticalSlot = entity.getCritical(n3, n4);
            criticalSlot.setHit(true);
            entity.getEquipment(criticalSlot.getIndex()).setHit(true);
            vector = this.explodeEquipment(entity, n3, n4);
        } else {
            Report report = new Report(5105);
            report.subject = entity.getId();
            report.indent();
            vector.addElement(report);
        }
        return vector;
    }

    private void doEntityFall(Entity entity, Coords coords, int n, int n2, PilotingRollData pilotingRollData) {
        int n3;
        Report report;
        int n4;
        String string;
        IHex iHex = this.game.getBoard().getHex(coords);
        if (entity.isMakingDfa()) {
            Report report2 = new Report(2305);
            report2.subject = entity.getId();
            this.vPhaseReport.addElement(report2);
            entity.setProne(true);
            return;
        }
        switch (n2) {
            case 1: 
            case 2: {
                string = "right side";
                n4 = 3;
                break;
            }
            case 3: {
                string = "rear";
                n4 = 1;
                break;
            }
            case 4: 
            case 5: {
                string = "left side";
                n4 = 2;
                break;
            }
            default: {
                string = "front";
                n4 = 0;
            }
        }
        int n5 = iHex.terrainLevel(4);
        int n6 = n;
        if (n5 > 0) {
            n6 = n - n5;
        } else {
            n5 = 0;
        }
        if (iHex.containsTerrain(20)) {
            n5 = 0;
        }
        int n7 = (int)Math.round((double)entity.getWeight() / 10.0) * (n6 + 1);
        int n8 = 0;
        if (n5 > 0) {
            n7 /= 2;
            n8 = (int)Math.round((double)entity.getWeight() / 10.0) * (n5 + 1) / 2;
        }
        if (n5 > n) {
            n7 = 0;
            n8 = (int)Math.round((double)entity.getWeight() / 10.0) * (n + 1) / 2;
        }
        n7 = Math.round((float)n7 * this.game.getOptions().floatOption("gravity"));
        if ((n8 = Math.round((float)n8 * this.game.getOptions().floatOption("gravity"))) == 0) {
            report = new Report(2310);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n7);
        } else if (n7 > 0) {
            report = new Report(2315);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n7);
            report.add(n8);
        } else {
            report = new Report(2310);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n8);
        }
        this.vPhaseReport.addElement(report);
        n7 += n8;
        int n9 = entity.getSwarmAttackerId();
        if (entity instanceof Mech) {
            entity.setProne(true);
        }
        entity.setPosition(coords);
        entity.setFacing((entity.getFacing() + (n2 - 1)) % 6);
        entity.setSecondaryFacing(entity.getFacing());
        entity.setElevation(-n5);
        if (n5 > 0) {
            for (n3 = 0; n3 < entity.locations(); ++n3) {
                entity.setLocationStatus(n3, 2);
            }
        }
        while (n7 > 0) {
            n3 = Math.min(5, n7);
            HitData hitData = entity.rollHitLocation(0, n4);
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n3));
            n7 -= n3;
        }
        this.doSetLocationsExposure(entity, iHex, false, -n5);
        pilotingRollData.removeAutos();
        if (n > 0) {
            pilotingRollData.addModifier(n, "height of fall");
        }
        entity.addPilotingModifierForTerrain(pilotingRollData, coords);
        if (pilotingRollData.getValue() == Integer.MAX_VALUE) {
            report = new Report(2320);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.crew.getName());
            report.indent();
            this.vPhaseReport.addElement(report);
            Server.combineVectors(this.vPhaseReport, this.damageCrew(entity, 1));
            ++((Report)this.vPhaseReport.elementAt((int)(this.vPhaseReport.size() - 1))).newlines;
        } else {
            n3 = Compute.d6(2);
            report = new Report(2325);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.crew.getName());
            report.add(pilotingRollData.getValueAsString());
            report.add(n3);
            if (n3 >= pilotingRollData.getValue()) {
                report.choose(true);
                this.vPhaseReport.addElement(report);
            } else {
                report.choose(false);
                this.vPhaseReport.addElement(report);
                Server.combineVectors(this.vPhaseReport, this.damageCrew(entity, 1));
                ++((Report)this.vPhaseReport.elementAt((int)(this.vPhaseReport.size() - 1))).newlines;
            }
        }
        if (-1 != n9) {
            Entity entity2 = this.game.getEntity(n9);
            entity.setSwarmAttackerId(-1);
            entity2.setSwarmTargetId(-1);
            if (n5 > 0) {
                entity2.setPosition(coords);
                report = new Report(2330);
                report.newlines = 0;
                report.subject = entity2.getId();
                report.addDesc(entity2);
                this.vPhaseReport.addElement(report);
                Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity2, "a watery grave", false));
            } else {
                report = new Report(2335);
                report.newlines = 0;
                report.subject = entity2.getId();
                report.addDesc(entity2);
                this.vPhaseReport.addElement(report);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity2, entity2.rollHitLocation(0, 0), 11));
                ++((Report)this.vPhaseReport.elementAt((int)(this.vPhaseReport.size() - 1))).newlines;
            }
            entity2.setPosition(coords);
            this.entityUpdate(n9);
        }
        this.game.resetPSRs(entity);
    }

    private void doEntityFall(Entity entity, Coords coords, int n, PilotingRollData pilotingRollData) {
        this.doEntityFall(entity, coords, n, Compute.d6(1), pilotingRollData);
    }

    private void doEntityFall(Entity entity, PilotingRollData pilotingRollData) {
        this.doEntityFall(entity, entity.getPosition(), 0, pilotingRollData);
    }

    private void resolveAmmoDumps() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            Enumeration enumeration2 = entity.getAmmo();
            while (enumeration2.hasMoreElements()) {
                Report report;
                Mounted mounted = (Mounted)enumeration2.nextElement();
                if (mounted.isPendingDump()) {
                    report = new Report(5110);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(mounted.getName());
                    this.vPhaseReport.addElement(report);
                    mounted.setPendingDump(false);
                    mounted.setDumping(true);
                    continue;
                }
                if (!mounted.isDumping()) continue;
                report = new Report(5115);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(mounted.getName());
                this.vPhaseReport.addElement(report);
                mounted.setDumping(false);
                mounted.setShotsLeft(0);
            }
            entity.reloadEmptyWeapons();
        }
    }

    public boolean ignite(IHex iHex, int n, boolean bl, int n2) {
        if (!this.game.getOptions().booleanOption("fire") || null == iHex) {
            return false;
        }
        if (iHex.containsTerrain(7)) {
            return true;
        }
        if (!(bl || iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(10))) {
            return false;
        }
        int n3 = Compute.d6(2);
        if (n2 != -1) {
            Report report = new Report(3430);
            report.indent(3);
            report.subject = n2;
            report.add(n);
            report.add(n3);
            this.vPhaseReport.addElement(report);
        }
        if (n3 >= n) {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
            return true;
        }
        return false;
    }

    public boolean ignite(IHex iHex, int n, boolean bl) {
        return this.ignite(iHex, n, bl, -1);
    }

    public boolean ignite(IHex iHex, int n) {
        return this.ignite(iHex, n, false, -1);
    }

    public void removeFire(int n, int n2, IHex iHex) {
        Coords coords = new Coords(n, n2);
        iHex.removeTerrain(7);
        this.sendChangedHex(coords);
        if (!this.game.getOptions().booleanOption("maxtech_fire")) {
            int n3 = this.game.getWindDirection();
            this.removeSmoke(n, n2, n3);
            this.removeSmoke(n, n2, (n3 + 1) % 6);
            this.removeSmoke(n, n2, (n3 + 5) % 6);
        }
        Report report = new Report(5170, 0);
        report.add(coords.getBoardNum());
        this.vPhaseReport.addElement(report);
    }

    public void addSmoke(int n, int n2, int n3) {
        Coords coords = new Coords(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex != null && !iHex.containsTerrain(8)) {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 1));
            this.sendChangedHex(coords);
            Report report = new Report(5175, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        }
    }

    public void addL3Smoke(int n, int n2) {
        IBoard iBoard = this.game.getBoard();
        Coords coords = new Coords(n, n2);
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl = iBoard.isInfernoBurning(coords);
        if (iHex == null) {
            return;
        }
        if (bl || 2 < iHex.terrainLevel(10)) {
            if (iHex.terrainLevel(8) == 2) {
                Report report = new Report(5180, 0);
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
            } else {
                if (iHex.terrainLevel(8) == 1) {
                    iHex.removeTerrain(8);
                }
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 2));
                this.sendChangedHex(coords);
                Report report = new Report(5185, 0);
                report.add(coords.getBoardNum());
                this.vPhaseReport.addElement(report);
            }
        } else if (iHex.terrainLevel(8) == 2) {
            Report report = new Report(5190, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        } else if (iHex.terrainLevel(8) == 1) {
            Report report = new Report(5195, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        } else {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 1));
            this.sendChangedHex(coords);
            Report report = new Report(5200, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        }
    }

    public void removeSmoke(int n, int n2, int n3) {
        Coords coords = new Coords(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex != null && iHex.containsTerrain(8)) {
            iHex.removeTerrain(8);
            this.sendChangedHex(coords);
            Report report = new Report(5205, 0);
            report.add(coords.getBoardNum());
            this.vPhaseReport.addElement(report);
        }
    }

    private Vector scanForBoardsInDir(File file, String string, int n, int n2) {
        String[] stringArray = file.list();
        Vector<String> vector = new Vector<String>();
        Comparator comparator = StringUtil.stringComparator();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(".board") == -1 || !Board.boardIsSize(string.concat("/").concat(stringArray[i]), n, n2)) continue;
            vector.addElement(string.concat("/").concat(stringArray[i].substring(0, stringArray[i].lastIndexOf(".board"))));
        }
        return vector;
    }

    private Vector scanForBoards(int n, int n2) {
        return this.scanForBoards(n, n2, this.game.getOptions().booleanOption("maps_include_subdir"));
    }

    private Vector scanForBoards(int n, int n2, boolean bl) {
        int n3;
        Vector<String> vector = new Vector<String>();
        File file = new File("data/boards");
        vector.addElement("[GENERATED]");
        if (!file.isDirectory()) {
            return vector;
        }
        String[] stringArray = file.list();
        Vector<String> vector2 = new Vector<String>();
        Comparator comparator = StringUtil.stringComparator();
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            File file2 = new File(new String("data/boards/").concat(stringArray[n3]));
            if (file2.isDirectory() && bl) {
                vector2.addAll(this.scanForBoardsInDir(file2, stringArray[n3], n, n2));
                continue;
            }
            if (stringArray[n3].indexOf(".board") == -1 || !Board.boardIsSize(stringArray[n3], n, n2)) continue;
            vector2.addElement(stringArray[n3].substring(0, stringArray[n3].lastIndexOf(".board")));
        }
        if (vector2.size() > 0) {
            vector.addElement("[RANDOM]");
            vector.addElement(DEFAULT_BOARD);
            Collections.sort(vector2, comparator);
            for (n3 = 0; n3 < vector2.size(); ++n3) {
                vector.addElement((String)vector2.elementAt(n3));
            }
        }
        return vector;
    }

    private boolean doBlind() {
        return this.game.getOptions().booleanOption("double_blind") && this.game.getPhase() >= 4;
    }

    private void entityUpdate(int n) {
        this.entityUpdate(n, new Vector());
    }

    private void entityUpdate(int n, Vector vector) {
        if (this.doBlind()) {
            Player player;
            int n2;
            Entity entity = this.game.getEntity(n);
            Vector vector2 = this.game.getPlayersVector();
            Vector vector3 = this.whoCanSee(entity);
            Packet packet = this.createEntityPacket(n, vector);
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                player = (Player)vector3.elementAt(n2);
                this.send(player.getId(), packet);
            }
            packet = this.createRemoveEntityPacket(n, entity.getRemovalCondition());
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                if (vector3.contains(vector2.elementAt(n2))) continue;
                player = (Player)vector2.elementAt(n2);
                this.send(player.getId(), packet);
            }
        } else {
            this.send(this.createEntityPacket(n, vector));
        }
    }

    private Vector whoCanSee(Entity entity) {
        Serializable serializable;
        boolean bl = this.game.getOptions().booleanOption("team_vision");
        Vector vector = this.game.getEntitiesVector();
        Vector<Serializable> vector2 = new Vector<Serializable>();
        vector2.addElement(entity.getOwner());
        if (bl) {
            this.addTeammates(vector2, entity.getOwner());
        }
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            serializable = (Player)enumeration.nextElement();
            if (!((Player)serializable).canSeeAll() || vector2.contains(enumeration)) continue;
            vector2.addElement(serializable);
        }
        for (int i = 0; i < vector.size(); ++i) {
            serializable = (Entity)vector.elementAt(i);
            if (vector2.contains(((Entity)serializable).getOwner()) || !((Entity)serializable).isActive() || !Compute.canSee(this.game, (Entity)serializable, entity)) continue;
            vector2.addElement(((Entity)serializable).getOwner());
            if (!bl) continue;
            this.addTeammates(vector2, ((Entity)serializable).getOwner());
        }
        return vector2;
    }

    private boolean canSee(Player player, Entity entity) {
        if (entity.getOwner().getId() == player.getId()) {
            return true;
        }
        Vector vector = this.whoCanSee(entity);
        for (int i = 0; i < vector.size(); ++i) {
            Player player2 = (Player)vector.elementAt(i);
            if (!player2.equals(player)) continue;
            return true;
        }
        return false;
    }

    private void addTeammates(Vector vector, Player player) {
        Vector vector2 = this.game.getPlayersVector();
        for (int i = 0; i < vector2.size(); ++i) {
            Player player2 = (Player)vector2.elementAt(i);
            if (player.isEnemyOf(player2) || vector.contains(player2)) continue;
            vector.addElement(player2);
        }
    }

    private void entityAllUpdate() {
        if (this.doBlind()) {
            Vector vector = this.game.getPlayersVector();
            for (int i = 0; i < vector.size(); ++i) {
                Player player = (Player)vector.elementAt(i);
                this.send(player.getId(), this.createFilteredEntitiesPacket(player));
            }
        } else {
            this.send(this.createEntitiesPacket());
        }
    }

    private Vector filterEntities(Player player, Vector vector) {
        Entity entity;
        int n;
        Vector<Entity> vector2 = new Vector<Entity>();
        Vector vector3 = this.game.getEntitiesVector();
        Vector<Entity> vector4 = new Vector<Entity>();
        boolean bl = this.game.getOptions().booleanOption("team_vision");
        if (player.canSeeAll()) {
            return vector;
        }
        for (n = 0; n < vector3.size(); ++n) {
            entity = (Entity)vector3.elementAt(n);
            if (entity.getOwner() != player && (!bl || entity.getOwner().isEnemyOf(player))) continue;
            vector4.addElement(entity);
        }
        block1: for (n = 0; n < vector.size(); ++n) {
            entity = (Entity)vector.elementAt(n);
            if (vector4.contains(entity)) {
                vector2.addElement(entity);
                continue;
            }
            for (int i = 0; i < vector4.size(); ++i) {
                Entity entity2 = (Entity)vector4.elementAt(i);
                if (!Compute.canSee(this.game, entity2, entity)) continue;
                vector2.addElement(entity);
                continue block1;
            }
        }
        return vector2;
    }

    private Vector filterReportVector(Vector vector, Player player) {
        if (!this.doBlind()) {
            return (Vector)vector.clone();
        }
        Vector<Report> vector2 = new Vector<Report>();
        for (int i = 0; i < vector.size(); ++i) {
            Report report = (Report)vector.elementAt(i);
            vector2.addElement(this.filterReport(report, player, false));
        }
        return vector2;
    }

    private Report filterReport(Report report, Player player, boolean bl) {
        if (report.subject == -1 && report.type != 0) {
            System.err.println("Error: Attempting to filter a Report object that is not public yet has no subject.\n\t\tmessageId: " + report.messageId);
            return report;
        }
        if (report.type == 0 || player == null && !bl) {
            return report;
        }
        Entity entity = this.game.getEntity(report.subject);
        Player player2 = null;
        if (entity != null) {
            player2 = entity.getOwner();
        }
        if (!(bl || entity != null && player2 != null)) {
            System.err.println("Error: Attempting to filter a Report object that is not public but has a subject (" + entity + ") with owner (" + player2 + ").\n\tmessageId: " + report.messageId);
            return report;
        }
        Report report2 = new Report(report);
        for (int i = 0; i < report2.dataCount(); ++i) {
            if (!bl && this.canSee(player, entity) || !report.isValueObscured(i)) continue;
            report2.hideData(i);
            if (player == null) continue;
            report.addObscuredRecipient(player.getName());
        }
        return report2;
    }

    private Vector filterPastReports(Vector vector, Player player) {
        System.err.println("filterPastReports() begin");
        System.err.println("  player is " + player.getName());
        if (this.doBlind()) {
            System.err.println("  pastReports vector is\n" + vector);
            Vector<Object> vector2 = new Vector<Object>();
            Vector<Report> vector3 = new Vector<Report>();
            Vector vector4 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                vector4 = (Vector)vector.elementAt(i);
                System.err.println("  roundReports vector is\n" + vector4);
                for (int j = 0; j < vector4.size(); ++j) {
                    Report report = (Report)vector4.elementAt(j);
                    if (report.isObscuredRecipient(player.getName())) {
                        System.err.println("  report is " + report + " -obscuring-");
                        vector3.addElement(this.filterReport(report, null, true));
                        continue;
                    }
                    System.err.println("  report is " + report);
                    vector3.addElement(report);
                }
                System.err.println("  filteredRoundReport is\n" + vector3);
                vector2.addElement(vector3.clone());
                vector3.removeAllElements();
            }
            System.err.println("filterPastReports() end");
            return vector2;
        }
        System.err.println("filterPastReports() end");
        return vector;
    }

    private void updateVisibilityIndicator() {
        Vector vector = this.game.getEntitiesVector();
        for (int i = 0; i < vector.size(); ++i) {
            Entity entity = (Entity)vector.elementAt(i);
            boolean bl = entity.isVisibleToEnemy();
            boolean bl2 = entity.isSeenByEnemy();
            entity.setVisibleToEnemy(false);
            Vector vector2 = this.whoCanSee(entity);
            for (int j = 0; j < vector2.size(); ++j) {
                Player player = (Player)vector2.elementAt(j);
                if (!entity.getOwner().isEnemyOf(player) || player.isObserver()) continue;
                entity.setVisibleToEnemy(true);
                entity.setSeenByEnemy(true);
            }
            if (bl == entity.isVisibleToEnemy() && bl2 == entity.isSeenByEnemy()) continue;
            this.sendVisibilityIndicator(entity);
        }
    }

    private void receiveEntityAdd(Packet packet, int n) {
        final Entity entity = (Entity)packet.getObject(0);
        if (entityVerifier == null) {
            entityVerifier = new EntityVerifier(new File(VERIFIER_CONFIG_FILENAME));
        }
        if (entity instanceof Mech || entity instanceof Tank) {
            StringBuffer stringBuffer;
            TestEntity testEntity = null;
            entity.restore();
            if (entity instanceof Mech) {
                testEntity = new TestMech((Mech)entity, Server.entityVerifier.mechOption, null);
            }
            if (entity instanceof VTOL) {
                testEntity = new TestTank((Tank)entity, Server.entityVerifier.tankOption, null);
            }
            if (entity instanceof Tank) {
                testEntity = new TestTank((Tank)entity, Server.entityVerifier.tankOption, null);
            }
            if (((TestEntity)testEntity).correctEntity(stringBuffer = new StringBuffer(), !this.game.getOptions().booleanOption("is_eq_limits"))) {
                entity.setDesignValid(true);
            } else if (this.game.getOptions().booleanOption("allow_illegal_units")) {
                entity.setDesignValid(false);
            } else {
                Player player = this.game.getPlayer(n);
                this.sendServerChat("Player " + player.getName() + " attempted to add an illegal unit design (" + entity.getShortNameRaw() + "), the unit was rejected.");
                System.err.println(stringBuffer);
                return;
            }
        }
        if (entity instanceof Protomech) {
            int n2 = this.game.getSelectedEntityCount(new EntitySelector(){
                private final int ownerId;
                {
                    this.ownerId = entity.getOwnerId();
                }

                public boolean accept(Entity entity2) {
                    return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId();
                }
            });
            entity.setUnitNumber((char)(n2 / 5));
        }
        if (-1 == entity.getId()) {
            entity.setId(this.getFreeEntityId());
        }
        this.game.addEntity(entity.getId(), entity);
        this.send(this.createAddEntityPacket(entity.getId()));
    }

    private void receiveEntityUpdate(Packet packet, int n) {
        Entity entity = (Entity)packet.getObject(0);
        Entity entity2 = this.game.getEntity(entity.getId());
        if (entity2 != null && entity2.getOwner() == this.getPlayer(n)) {
            this.game.setEntity(entity.getId(), entity);
            this.send(this.createEntitiesPacket());
        }
    }

    private void receiveEntityModeChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (entity.getOwner() != this.getPlayer(n)) {
            return;
        }
        Mounted mounted = entity.getEquipment(n3);
        if (mounted.getType() instanceof AmmoType && !mounted.getType().hasInstantModeSwitch()) {
            mounted.setPendingDump(n4 == 1);
        } else {
            mounted.setMode(n4);
        }
    }

    private void receiveEntitySystemModeChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (entity.getOwner() != this.getPlayer(n)) {
            return;
        }
        if (entity instanceof Mech && n3 == 2) {
            ((Mech)entity).setCockpitStatus(n4);
        }
    }

    private void receiveEntityAmmoChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (null == entity) {
            System.err.print("Server.receiveEntityAmmoChange: could not find entity #");
            System.err.println(n2);
            return;
        }
        Player player = this.getPlayer(n);
        if (null != player && entity.getOwner() != player) {
            System.err.print("Server.receiveEntityAmmoChange: player ");
            System.err.print(player.getName());
            System.err.print(" does not own the entity ");
            System.err.println(entity.getDisplayName());
            return;
        }
        Mounted mounted = entity.getEquipment(n3);
        Mounted mounted2 = entity.getEquipment(n4);
        if (null == mounted2) {
            System.err.print("Server.receiveEntityAmmoChange: entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" does not have ammo #");
            System.err.println(n4);
            return;
        }
        if (!(mounted2.getType() instanceof AmmoType)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n4);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted2.getName());
            System.err.println(" and not ammo.");
            return;
        }
        if (null == mounted) {
            System.err.print("Server.receiveEntityAmmoChange: entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" does not have weapon #");
            System.err.println(n3);
            return;
        }
        if (!(mounted.getType() instanceof WeaponType)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and not a weapon.");
            return;
        }
        if (((WeaponType)mounted.getType()).getAmmoType() == -1) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and does not use ammo.");
            return;
        }
        if (((WeaponType)mounted.getType()).hasFlag(32768)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and cannot use external ammo.");
            return;
        }
        entity.loadWeapon(mounted, mounted2);
    }

    private void receiveEntityDelete(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        final Entity entity = this.game.getEntity(n2);
        if (entity != null && entity.getOwner() == this.getPlayer(n)) {
            if (entity instanceof Protomech) {
                int n3 = this.game.getSelectedEntityCount(new EntitySelector(){
                    private final int ownerId;
                    {
                        this.ownerId = entity.getOwnerId();
                    }

                    public boolean accept(Entity entity2) {
                        return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId();
                    }
                });
                final char c = (char)(Math.ceil((double)n3 / 5.0) - 1.0);
                char c2 = (char)(Math.ceil((double)(n3 - 1) / 5.0) - 1.0);
                char c3 = entity.getUnitNumber();
                if (c != c3 && c != c2) {
                    Enumeration enumeration = this.game.getSelectedEntities(new EntitySelector(){
                        private final int ownerId;
                        private final char lastUnitNum;
                        {
                            this.ownerId = entity.getOwnerId();
                            this.lastUnitNum = c;
                        }

                        public boolean accept(Entity entity2) {
                            return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId() && this.lastUnitNum == entity2.getUnitNumber();
                        }
                    });
                    Entity entity2 = (Entity)enumeration.nextElement();
                    entity2.setUnitNumber(c3);
                    this.entityUpdate(entity2.getId());
                }
            }
            this.game.removeEntity(n2, 2048);
            this.send(this.createRemoveEntityPacket(n2, 2048));
        }
    }

    private void receivePlayerDone(Packet packet, int n) {
        boolean bl = packet.getBooleanValue(0);
        Player player = this.getPlayer(n);
        if (null != player) {
            player.setDone(bl);
        }
    }

    private void receiveInitiativeRerollRequest(Packet packet, int n) {
        Player player = this.getPlayer(n);
        if (6 != this.game.getPhase()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (null == player) {
                stringBuffer.append("Player #").append(n);
            } else {
                stringBuffer.append(player.getName());
            }
            stringBuffer.append(" is not allowed to ask for a reroll at this time.");
            System.err.println(stringBuffer.toString());
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        if (this.game.hasTacticalGenius(player)) {
            this.game.addInitiativeRerollRequest(this.game.getTeamForPlayer(player));
        }
        if (null != player) {
            player.setDone(true);
        }
        this.checkReady();
    }

    private boolean receiveGameOptions(Packet packet, int n) {
        Player player = this.game.getPlayer(n);
        if (null == player) {
            System.err.print("Server does not recognize player at connection ");
            System.err.println(n);
            return false;
        }
        if (this.password != null && this.password.length() > 0 && !this.password.equals(packet.getObject(0))) {
            this.sendServerChat(n, "The password you specified to change game options is incorrect.");
            return false;
        }
        int n2 = 0;
        Enumeration enumeration = ((Vector)packet.getObject(1)).elements();
        while (enumeration.hasMoreElements()) {
            IBasicOption iBasicOption = (IBasicOption)enumeration.nextElement();
            IOption iOption = this.game.getOptions().getOption(iBasicOption.getName());
            if (iOption == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Player ").append(player.getName()).append(" changed option \"").append(iOption.getDisplayableName()).append("\" to ").append(iBasicOption.getValue().toString()).append(".");
            this.sendServerChat(stringBuffer.toString());
            iOption.setValue(iBasicOption.getValue());
            ++n2;
        }
        Compute.setRNG(this.game.getOptions().intOption("rng_type"));
        return n2 > 0;
    }

    private void receiveGameOptionsAux(Packet packet, int n) {
        Enumeration enumeration = ((Vector)packet.getObject(1)).elements();
        while (enumeration.hasMoreElements()) {
            IBasicOption iBasicOption = (IBasicOption)enumeration.nextElement();
            IOption iOption = this.game.getOptions().getOption(iBasicOption.getName());
            if (iOption == null || !"maps_include_subdir".equals(iOption.getName())) continue;
            this.mapSettings.setBoardsAvailableVector(this.scanForBoards(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight()));
            this.mapSettings.removeUnavailable();
            this.mapSettings.setNullBoards(DEFAULT_BOARD);
            this.send(this.createMapSettingsPacket());
        }
    }

    private void transmitAllPlayerConnects(int n) {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.send(n, this.createPlayerConnectPacket(player.getId()));
        }
    }

    private Packet createPlayerConnectPacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n)};
        return new Packet(40, objectArray);
    }

    private Packet createPlayerUpdatePacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n)};
        return new Packet(60, objectArray);
    }

    private void transmitAllPlayerUpdates() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (null == player) continue;
            this.send(this.createPlayerUpdatePacket(player.getId()));
        }
    }

    private void transmitAllPlayerDones() {
        Enumeration enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.send(this.createPlayerDonePacket(player.getId()));
        }
    }

    private Packet createPlayerDonePacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), new Boolean(this.getPlayer(n).isDone())};
        return new Packet(70, objectArray);
    }

    private Packet createTurnVectorPacket() {
        return new Packet(300, this.game.getTurnVector());
    }

    private Packet createTurnIndexPacket() {
        return new Packet(250, new Integer(this.game.getTurnIndex()));
    }

    private Packet createMapSettingsPacket() {
        return new Packet(360, this.mapSettings);
    }

    private Packet createMapQueryPacket(MapSettings mapSettings) {
        return new Packet(370, mapSettings);
    }

    private Packet createGameSettingsPacket() {
        return new Packet(350, this.game.getOptions());
    }

    private Packet createBoardPacket() {
        return new Packet(270, this.game.getBoard());
    }

    private Packet createEntityPacket(int n) {
        return this.createEntityPacket(n, new Vector());
    }

    private Packet createEntityPacket(int n, Vector vector) {
        Entity entity = this.game.getEntity(n);
        Object[] objectArray = new Object[]{new Integer(n), entity, vector};
        return new Packet(140, objectArray);
    }

    private Packet createReportPacket(Player player) {
        return new Packet(310, this.filterReportVector(this.vPhaseReport, player));
    }

    private Packet createSpecialReportPacket() {
        return new Packet(320, this.vPhaseReport.clone());
    }

    private Packet createTacticalGeniusReportPacket() {
        return new Packet(330, this.vPhaseReport.clone());
    }

    private Packet createAllReportsPacket(Player player) {
        return new Packet(340, this.filterPastReports(this.game.getAllReports(), player));
    }

    private Packet createEntitiesPacket() {
        return new Packet(280, this.game.getEntitiesVector());
    }

    private Packet createFullEntitiesPacket() {
        Object[] objectArray = new Object[]{this.game.getEntitiesVector(), this.game.getOutOfGameEntitiesVector()};
        return new Packet(280, objectArray);
    }

    private Packet createFilteredEntitiesPacket(Player player) {
        return new Packet(280, this.filterEntities(player, this.game.getEntitiesVector()));
    }

    private Packet createFilteredFullEntitiesPacket(Player player) {
        Object[] objectArray = new Object[]{this.filterEntities(player, this.game.getEntitiesVector()), this.game.getOutOfGameEntitiesVector()};
        return new Packet(280, objectArray);
    }

    private Packet createAddEntityPacket(int n) {
        Entity entity = this.game.getEntity(n);
        Object[] objectArray = new Object[]{new Integer(n), entity};
        return new Packet(90, objectArray);
    }

    private Packet createRemoveEntityPacket(int n) {
        return this.createRemoveEntityPacket(n, 512);
    }

    private Packet createRemoveEntityPacket(int n, int n2) {
        if (n2 != 0 && n2 != 256 && n2 != 272 && n2 != 512 && n2 != 528 && n2 != 288 && n2 != 1024 && n2 != 2048) {
            throw new IllegalArgumentException("Unknown unit condition: " + n2);
        }
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        return new Packet(100, objectArray);
    }

    private Packet createEndOfGamePacket() {
        Object[] objectArray = new Object[]{this.getDetailedVictoryReport(), new Integer(this.game.getVictoryPlayerId()), new Integer(this.game.getVictoryTeam())};
        return new Packet(380, objectArray);
    }

    private void sendChat(int n, String string, String string2) {
        this.send(n, new Packet(80, string + ": " + string2));
    }

    private void sendChat(String string, String string2) {
        String string3 = string + ": " + string2;
        this.send(new Packet(80, string3));
    }

    public void sendServerChat(int n, String string) {
        this.sendChat(n, "***Server", string);
    }

    public void sendServerChat(String string) {
        this.sendChat("***Server", string);
    }

    private Packet createHexChangePacket(Coords coords, IHex iHex) {
        Object[] objectArray = new Object[]{coords, iHex};
        return new Packet(190, objectArray);
    }

    public void sendChangedHex(Coords coords) {
        this.send(this.createHexChangePacket(coords, this.game.getBoard().getHex(coords)));
    }

    public void sendVisibilityIndicator(Entity entity) {
        Object[] objectArray = new Object[]{new Integer(entity.getId()), new Boolean(entity.isSeenByEnemy()), new Boolean(entity.isVisibleToEnemy())};
        this.send(new Packet(180, objectArray));
    }

    private Packet createAttackPacket(Vector vector, int n) {
        Object[] objectArray = new Object[]{vector, new Integer(n)};
        return new Packet(130, objectArray);
    }

    private Packet createAttackPacket(EntityAction entityAction, int n) {
        Vector<EntityAction> vector = new Vector<EntityAction>(1);
        vector.addElement(entityAction);
        Object[] objectArray = new Object[]{vector, new Integer(n)};
        return new Packet(130, objectArray);
    }

    private Packet createArtilleryPacket(Player player) {
        if (player.getSeeAll()) {
            return new Packet(460, this.game.getArtilleryVector());
        }
        Vector<ArtilleryAttackAction> vector = new Vector<ArtilleryAttackAction>();
        int n = player.getTeam();
        Enumeration enumeration = this.game.getArtilleryAttacks();
        while (enumeration.hasMoreElements()) {
            ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)enumeration.nextElement();
            if (artilleryAttackAction.getPlayerId() != player.getId() && (n == 0 || n != this.game.getPlayer(artilleryAttackAction.getPlayerId()).getTeam())) continue;
            vector.addElement(artilleryAttackAction);
        }
        return new Packet(460, vector);
    }

    private Packet createFlarePacket() {
        return new Packet(470, this.game.getFlares());
    }

    private void send(Packet packet) {
        if (this.connections == null) {
            return;
        }
        Enumeration enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            connection.send(packet);
        }
    }

    private void sendReport() {
        this.sendReport(false);
    }

    private void sendReport(boolean bl) {
        if (this.connections == null) {
            return;
        }
        Enumeration enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            Player player = this.game.getPlayer(connection.getId());
            Packet packet = bl ? this.createTacticalGeniusReportPacket() : this.createReportPacket(player);
            connection.send(packet);
        }
    }

    private void send(int n, Packet packet) {
        if (this.getClient(n) != null) {
            this.getClient(n).send(packet);
        }
    }

    private void sendToPending(int n, Packet packet) {
        if (this.getPendingConnection(n) != null) {
            this.getPendingConnection(n).send(packet);
        }
    }

    private void processCommand(int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        String string2 = stringArray[0].substring(1);
        ServerCommand serverCommand = this.getCommand(string2);
        if (serverCommand != null) {
            serverCommand.run(n, stringArray);
        } else {
            this.sendServerChat(n, "Command not recognized.  Type /help for a list of commands.");
        }
    }

    protected synchronized void handle(int n, Packet packet) {
        Player player = this.game.getPlayer(n);
        if (null == player && null == this.getPendingConnection(n)) {
            System.err.print("Server does not recognize player at connection ");
            System.err.println(n);
            return;
        }
        if (packet == null) {
            System.out.println("server.connection.handle: got null packet");
            return;
        }
        switch (packet.getCommand()) {
            case 0: {
                Connection connection = this.getConnection(n);
                if (connection == null) break;
                connection.close();
                break;
            }
            case 20: {
                this.receivePlayerName(packet, n);
                break;
            }
            case 60: {
                this.receivePlayerInfo(packet, n);
                this.validatePlayerInfo(n);
                this.send(this.createPlayerUpdatePacket(n));
                break;
            }
            case 70: {
                this.receivePlayerDone(packet, n);
                this.send(this.createPlayerDonePacket(n));
                this.checkReady();
                break;
            }
            case 430: {
                this.receiveInitiativeRerollRequest(packet, n);
                this.send(this.createPlayerDonePacket(n));
                break;
            }
            case 80: {
                String string = (String)packet.getObject(0);
                if (string.startsWith("/")) {
                    this.processCommand(n, string);
                } else {
                    this.sendChat(player.getName(), string);
                }
                if (DUNE_CALL.equals(string)) {
                    this.sendServerChat(DUNE_RESPONSE);
                    break;
                }
                if (!STAR_WARS_CALL.equals(string)) break;
                this.sendServerChat(STAR_WARS_RESPONSE);
                break;
            }
            case 110: {
                this.receiveMovement(packet, n);
                break;
            }
            case 120: {
                this.receiveDeployment(packet, n);
                break;
            }
            case 390: {
                this.receiveDeployMinefields(packet, n);
                break;
            }
            case 130: {
                this.receiveAttack(packet, n);
                break;
            }
            case 90: {
                this.receiveEntityAdd(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 140: {
                this.receiveEntityUpdate(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 150: {
                this.receiveEntityModeChange(packet, n);
                break;
            }
            case 170: {
                this.receiveEntitySystemModeChange(packet, n);
                break;
            }
            case 160: {
                this.receiveEntityAmmoChange(packet, n);
                break;
            }
            case 100: {
                this.receiveEntityDelete(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 350: {
                if (!this.receiveGameOptions(packet, n)) break;
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                this.send(this.createGameSettingsPacket());
                this.receiveGameOptionsAux(packet, n);
                break;
            }
            case 360: {
                MapSettings mapSettings = (MapSettings)packet.getObject(0);
                if (!this.mapSettings.equalMapGenParameters(mapSettings)) {
                    this.sendServerChat("Player " + player.getName() + " changed mapsettings");
                }
                this.mapSettings = mapSettings;
                mapSettings = null;
                this.mapSettings.replaceBoardWithRandom("[RANDOM]");
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                this.send(this.createMapSettingsPacket());
                break;
            }
            case 370: {
                MapSettings mapSettings = (MapSettings)packet.getObject(0);
                mapSettings.setBoardsAvailableVector(this.scanForBoards(mapSettings.getBoardWidth(), mapSettings.getBoardHeight()));
                mapSettings.removeUnavailable();
                mapSettings.setNullBoards(DEFAULT_BOARD);
                mapSettings.replaceBoardWithRandom("[RANDOM]");
                mapSettings.removeUnavailable();
                this.send(n, this.createMapQueryPacket(mapSettings));
                break;
            }
            case 440: {
                this.receiveUnloadStranded(packet, n);
                break;
            }
            case 450: {
                this.receiveArtyAutoHitHexes(packet, n);
            }
        }
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        System.out.println("s: listening for clients...");
        while (this.connector == thread) {
            try {
                Socket socket = this.serverSocket.accept();
                int n = this.getFreeConnectionId();
                System.out.println("s: accepting player connection #" + n + " ...");
                Connection connection = ConnectionFactory.getInstance().createServerConnection(socket, n);
                connection.addConnectionListener(this.connectionListener);
                connection.open();
                this.connectionsPending.addElement(connection);
                this.greeting(n);
            }
            catch (IOException iOException) {}
        }
    }

    private Vector explodeInfernoAmmoFromHeat(Entity entity) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Vector<Report> vector = new Vector<Report>();
        for (int i = 0; i < entity.locations(); ++i) {
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                AmmoType ammoType;
                Mounted mounted;
                CriticalSlot criticalSlot = entity.getCritical(i, j);
                if (criticalSlot == null || criticalSlot.isDestroyed() || criticalSlot.isHit() || criticalSlot.getType() != 1 || !((mounted = entity.getEquipment(entity.getCritical(i, j).getIndex())).getType() instanceof AmmoType) || !(ammoType = (AmmoType)mounted.getType()).isExplosive() || ammoType.getMunitionType() != 0x400000L) continue;
                int n5 = ammoType.getDamagePerShot() * ammoType.getRackSize();
                int n6 = mounted.getExplosionDamage();
                if (mounted.isHit() || n2 >= n5 && (n2 != n5 || n >= n6)) continue;
                n2 = n5;
                n = n6;
                n3 = i;
                n4 = j;
            }
        }
        if (n3 != -1 && n4 != -1) {
            CriticalSlot criticalSlot = entity.getCritical(n3, n4);
            criticalSlot.setHit(true);
            entity.getEquipment(criticalSlot.getIndex()).setHit(true);
            Server.combineVectors(vector, this.explodeEquipment(entity, n3, n4));
            entity.heat += 30;
            Report report = new Report(5155);
            report.indent();
            report.subject = entity.getId();
            report.add(entity.heat);
            vector.addElement(report);
            entity.heatBuildup = 0;
        } else {
            Report report = new Report(5160);
            report.indent();
            report.subject = entity.getId();
            vector.addElement(report);
        }
        return vector;
    }

    private boolean passBuildingWall(Entity entity, Building building, Coords coords, Coords coords2, int n, String string) {
        int n2;
        if (entity instanceof VTOL && entity.getElevation() > this.game.getBoard().getHex(coords2).ceiling()) {
            return false;
        }
        PilotingRollData pilotingRollData = entity.rollMovementInBuilding(building, n, string);
        if (!this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) {
            n2 = (int)Math.ceil((double)building.getCurrentCF() / 10.0);
            if (n2 == 0) {
                Report report = new Report(6440);
                report.add(entity.getDisplayName());
                report.subject = entity.getId();
                report.indent(2);
                this.vPhaseReport.addElement(report);
            } else {
                HitData hitData = entity.rollHitLocation(0, 0);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n2));
            }
        }
        n2 = (int)Math.ceil((double)entity.getWeight() / 10.0);
        int n3 = building.getCurrentCF();
        n3 -= Math.min(n3, n2);
        building.setCurrentCF(n3);
        this.damageInfantryIn(building, n2);
        Hashtable hashtable = this.game.getPositionMap();
        Vector<Entity> vector = null;
        if (entity.getPosition() != null) {
            vector = (Vector)hashtable.get(entity.getPosition());
            vector.removeElement(entity);
        }
        if ((vector = (Vector<Entity>)hashtable.get(coords2)) == null) {
            vector = new Vector<Entity>();
            hashtable.put(coords2, vector);
        }
        vector.addElement(entity);
        return this.checkForCollapse(building, hashtable);
    }

    private void damageInfantryIn(Building building, int n) {
        float f = 0.0f;
        switch (building.getType()) {
            case 1: {
                f = 0.75f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            case 3: {
                f = 0.25f;
            }
        }
        int n2 = Math.round((float)n * f);
        if (n2 == 0) {
            Report report = new Report(6445);
            this.vPhaseReport.addElement(report);
            return;
        }
        boolean bl = false;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            Coords coords = entity.getPosition();
            if (!(entity instanceof Infantry) || !building.isIn(coords) || !Compute.isInBuilding(this.game, entity, coords)) continue;
            Report report = new Report(6450);
            report.indent(2);
            report.subject = entity.getId();
            report.add(entity.getDisplayName());
            report.add(n2);
            this.vPhaseReport.addElement(report);
            int n3 = n2;
            int n4 = n2;
            if (entity instanceof BattleArmor) {
                n4 = 5;
            }
            while (n3 > 0) {
                int n5 = Math.min(n4, n3);
                HitData hitData = entity.rollHitLocation(0, 0);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n5));
                n3 -= n5;
            }
            this.vPhaseReport.addElement(new Report(1210));
        }
        if (bl) {
            this.vPhaseReport.addElement(new Report(1210));
        }
    }

    public boolean checkForCollapse(Building building, Hashtable hashtable) {
        Serializable serializable;
        if (building == null || hashtable == null || hashtable.isEmpty()) {
            return false;
        }
        int n = building.getCurrentCF();
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = building.getCoords();
        boolean bl = false;
        while (!bl && enumeration.hasMoreElements()) {
            serializable = (Coords)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(serializable);
            if (vector == null) continue;
            IHex iHex = this.game.getBoard().getHex((Coords)serializable);
            int n2 = iHex.surface();
            int n3 = iHex.terrainLevel(12);
            int[] nArray = new int[n3];
            Vector<Entity> vector2 = new Vector<Entity>();
            for (int i = 0; i < n3; ++i) {
                nArray[i] = 0;
            }
            Enumeration enumeration2 = vector.elements();
            while (!bl && enumeration2.hasMoreElements()) {
                Entity entity = (Entity)enumeration2.nextElement();
                int n4 = entity.elevationOccupied(iHex);
                if (!Compute.isInBuilding(this.game, entity, (Coords)serializable) || !(entity instanceof Mech) && !(entity instanceof Tank)) continue;
                int n5 = (int)entity.getWeight();
                int n6 = n4 - n2;
                if (n6 == 0 && n5 > n) {
                    vector2.addElement(entity);
                    continue;
                }
                if (n6 <= 0) continue;
                int n7 = --n6;
                nArray[n7] = nArray[n7] + n5;
                if (nArray[n6] <= n) continue;
                bl = true;
            }
            if (vector2.isEmpty()) continue;
            hashtable2.put(serializable, vector2);
        }
        if (bl) {
            serializable = new Report(2375);
            ((Report)serializable).add(building.getName());
            this.vPhaseReport.addElement(serializable);
            this.collapseBuilding(building, hashtable);
        } else if (!hashtable2.isEmpty()) {
            // empty if block
        }
        return bl;
    }

    public void collapseBuilding(Building building, Hashtable hashtable) {
        int n = building.getPhaseCF();
        Enumeration enumeration = building.getCoords();
        while (enumeration.hasMoreElements()) {
            Coords coords = (Coords)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(coords);
            if (vector == null) continue;
            IHex iHex = this.game.getBoard().getHex(coords);
            int n2 = iHex.surface();
            int n3 = iHex.terrainLevel(12);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Entity entity = (Entity)enumeration2.nextElement();
                int n4 = entity.elevationOccupied(iHex);
                int n5 = n4 - n2;
                if (!Compute.isInBuilding(this.game, entity, coords)) continue;
                if (n5 == n3) {
                    --n5;
                }
                int n6 = (int)Math.ceil((double)(n * (n3 - n5)) / 10.0);
                if (entity instanceof Infantry) {
                    n6 *= 3;
                }
                Report report = new Report(6455);
                report.indent();
                report.subject = entity.getId();
                report.add(entity.getDisplayName());
                report.add(n6);
                this.vPhaseReport.addElement(report);
                int n7 = n6;
                int n8 = n6;
                if (entity instanceof BattleArmor || entity instanceof Mech || entity instanceof Tank) {
                    n8 = 5;
                }
                while (n7 > 0) {
                    int n9 = Math.min(n8, n7);
                    HitData hitData = entity.rollHitLocation(0, 0);
                    Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n9));
                    n7 -= n9;
                }
                this.vPhaseReport.addElement(new Report(1210));
                n5 = n4 - n2;
                if (n5 > 0 && entity instanceof Mech) {
                    PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
                    entity.addPilotingModifierForTerrain(pilotingRollData, coords);
                    if (n6 >= 20) {
                        pilotingRollData.addModifier(1, "20+ damage");
                    }
                    this.doEntityFall(entity, coords, n5, pilotingRollData);
                }
                this.entityUpdate(entity.getId());
            }
        }
        building.setCurrentCF(0);
        building.setPhaseCF(0);
        this.send(this.createCollapseBuildingPacket(building));
        this.game.getBoard().collapseBuilding(building);
    }

    private Packet createCollapseBuildingPacket(Building building) {
        Vector<Building> vector = new Vector<Building>();
        vector.addElement(building);
        return this.createCollapseBuildingPacket(vector);
    }

    private Packet createCollapseBuildingPacket(Vector vector) {
        return new Packet(230, vector);
    }

    private Packet createUpdateBuildingCFPacket(Vector vector) {
        return new Packet(220, vector);
    }

    private void applyBuildingDamage() {
        Serializable serializable;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<Building> vector2 = new Vector<Building>();
        Enumeration enumeration = this.game.getBoard().getBuildings();
        while (enumeration.hasMoreElements()) {
            serializable = (Building)enumeration.nextElement();
            if (((Building)serializable).getCurrentCF() == 0) {
                vector.addElement(serializable);
                continue;
            }
            if (((Building)serializable).getPhaseCF() == ((Building)serializable).getCurrentCF()) continue;
            ((Building)serializable).setPhaseCF(((Building)serializable).getCurrentCF());
            vector2.addElement((Building)serializable);
        }
        if (!vector.isEmpty()) {
            serializable = this.game.getPositionMap();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Building building = (Building)enumeration.nextElement();
                Report report = new Report(6460);
                report.add(building.getName());
                this.vPhaseReport.addElement(report);
                this.collapseBuilding(building, (Hashtable)serializable);
            }
        }
        if (!vector2.isEmpty()) {
            this.sendChangedCFBuildings(vector2);
        }
    }

    private Report damageBuilding(Building building, int n) {
        return this.damageBuilding(building, n, " absorbs ");
    }

    private Report damageBuilding(Building building, int n, String string) {
        Report report = new Report();
        report.newlines = 0;
        if (building != null && n > 0) {
            int n2;
            int n3 = n2 = building.getCurrentCF();
            n2 -= Math.min(n2, n);
            building.setCurrentCF(n2);
            report.messageId = 3435;
            report.add(building.getName());
            report.add(string);
            report.add(n);
            if (n2 == 0 && n3 != 0) {
                report.messageId = 3440;
            }
        }
        return report;
    }

    public void sendChangedCFBuildings(Vector<Building> vector) {
        this.send(this.createUpdateBuildingCFPacket(vector));
    }

    private void receiveUnloadStranded(Packet packet, int n) {
        int n2;
        GameTurn.UnloadStrandedTurn unloadStrandedTurn = null;
        Player player = this.game.getPlayer(n);
        int[] nArray = (int[])packet.getObject(0);
        Vector<Player> vector = null;
        Player player2 = null;
        Enumeration enumeration = null;
        UnloadStrandedAction unloadStrandedAction = null;
        Entity entity = null;
        if (this.game.getPhase() != 8) {
            System.err.println("error: server got unload stranded packet in wrong phase");
            return;
        }
        if (!(this.game.getTurn() instanceof GameTurn.UnloadStrandedTurn)) {
            System.err.println("error: server got unload stranded packet out of sequence");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" should not be sending 'unload stranded entity' packets at this time.");
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        unloadStrandedTurn = (GameTurn.UnloadStrandedTurn)this.game.getTurn();
        if (!unloadStrandedTurn.isValid(n, this.game)) {
            System.err.println("error: server got unload stranded packet from invalid player");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" should not be sending 'unload stranded entity' packets.");
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        vector = new Vector<Player>();
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            unloadStrandedAction = (UnloadStrandedAction)enumeration.nextElement();
            if (unloadStrandedAction.getPlayerId() == n) {
                System.err.println("error: server got multiple unload stranded packets from player");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(player.getName()).append(" should not send multiple 'unload stranded entity' packets.");
                this.sendServerChat(stringBuffer.toString());
                return;
            }
            player2 = this.game.getPlayer(unloadStrandedAction.getPlayerId());
            if (vector.contains(player2)) continue;
            vector.addElement(player2);
        }
        boolean bl = false;
        for (n2 = 0; null != nArray && n2 < nArray.length; ++n2) {
            entity = this.game.getEntity(nArray[n2]);
            if (!this.game.getTurn().isValid(n, entity, this.game)) {
                System.err.println("error: server got unload stranded packet for invalid entity");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(player.getName()).append(" can not unload stranded entity ");
                if (null == entity) {
                    stringBuffer.append("#").append(nArray[n2]);
                } else {
                    stringBuffer.append(entity.getDisplayName());
                }
                stringBuffer.append(" at this time.");
                this.sendServerChat(stringBuffer.toString());
                continue;
            }
            bl = true;
            this.game.addAction(new UnloadStrandedAction(n, nArray[n2]));
        }
        if (!bl) {
            this.game.addAction(new UnloadStrandedAction(n, -1));
        }
        vector.addElement(player);
        nArray = unloadStrandedTurn.getEntityIds();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            entity = this.game.getEntity(nArray[n2]);
            player2 = entity.getOwner();
            if (vector.contains(player2)) continue;
            return;
        }
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            unloadStrandedAction = (UnloadStrandedAction)enumeration.nextElement();
            if (-1 == unloadStrandedAction.getEntityId()) continue;
            entity = this.game.getEntity(unloadStrandedAction.getEntityId());
            if (null == entity) {
                System.err.print("error: server could not find stranded entity #");
                System.err.print(unloadStrandedAction.getEntityId());
                System.err.println(" to unload!!!");
                continue;
            }
            Entity entity2 = this.game.getEntity(entity.getTransportId());
            this.unloadUnit(entity2, entity, entity2.getPosition(), entity2.getFacing(), entity2.getElevation());
        }
        this.game.resetActions();
        this.changeToNextTurn();
    }

    private void clearArtillerySpotters(int n, int n2) {
        Enumeration enumeration = this.game.getArtilleryAttacks();
        while (enumeration.hasMoreElements()) {
            ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)enumeration.nextElement();
            if (artilleryAttackAction.getWR().waa.getEntityId() != n || artilleryAttackAction.getWR().waa.getWeaponId() != n2) continue;
            artilleryAttackAction.setSpotterIds(null);
        }
    }

    private WeaponResult convertHomingShotToEntityTarget(ArtilleryAttackAction artilleryAttackAction, Entity entity) {
        WeaponResult weaponResult = artilleryAttackAction.getWR();
        Targetable targetable = weaponResult.waa.getTarget(this.game);
        Coords coords = targetable.getPosition();
        Entity entity2 = null;
        TagInfo tagInfo = null;
        Entity entity3 = null;
        for (int i = 0; i < 2; ++i) {
            int n = Integer.MAX_VALUE;
            int n2 = -1;
            Vector vector = this.game.getTagInfo();
            for (int j = 0; j < vector.size(); ++j) {
                tagInfo = (TagInfo)vector.elementAt(j);
                entity3 = this.game.getEntity(tagInfo.attackerId);
                if (tagInfo.shots >= tagInfo.priority || entity.isEnemyOf(entity3)) continue;
                System.err.println("Checking TAG " + j + " with priority " + tagInfo.priority);
                entity2 = this.game.getEntity(tagInfo.targetId);
                if (entity2 == null || !entity2.isOnSameSheet(coords) || coords.distance(entity2.getPosition()) >= n) continue;
                n2 = j;
                n = coords.distance(entity2.getPosition());
                if (!this.game.getOptions().booleanOption("a4homing_target_area")) break;
            }
            if (n2 != -1) {
                tagInfo = (TagInfo)vector.elementAt(n2);
                entity2 = this.game.getEntity(tagInfo.targetId);
                entity3 = this.game.getEntity(tagInfo.attackerId);
                System.err.println("attacker: " + entity.getDisplayName());
                System.err.println("   " + entity3.getDisplayName() + " selected to TAG");
                System.err.println("   " + entity2.getDisplayName() + " selected as target");
                ++tagInfo.shots;
                this.game.updateTagInfo(tagInfo, n2);
                break;
            }
            entity2 = null;
            System.err.println("nothing on 1st pass");
            this.game.clearTagInfoShots(entity, coords);
        }
        if (entity2 == null || tagInfo == null) {
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "no targets tagged on map sheet");
        } else if (tagInfo.missed) {
            weaponResult.waa.setTargetId(entity2.getId());
            weaponResult.waa.setTargetType(0);
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "tag missed the target");
        } else {
            weaponResult.artyAttackerCoords = entity3.getPosition();
            weaponResult.waa.setTargetId(entity2.getId());
            weaponResult.waa.setTargetType(0);
        }
        return weaponResult;
    }

    private void resolveIndirectArtilleryAttacks() {
        Serializable serializable;
        Enumeration enumeration;
        Vector<Serializable> vector = new Vector<Serializable>(this.game.getArtillerySize());
        Vector<Enumeration> vector2 = new Vector<Enumeration>(this.game.getArtillerySize());
        Enumeration enumeration2 = this.game.getArtilleryAttacks();
        while (enumeration2.hasMoreElements()) {
            enumeration = (ArtilleryAttackAction)enumeration2.nextElement();
            if (((ArtilleryAttackAction)((Object)enumeration)).turnsTilHit <= 0) {
                Mounted mounted;
                AmmoType ammoType;
                serializable = ((ArtilleryAttackAction)((Object)enumeration)).getWR();
                ((WeaponResult)serializable).artyAttackerCoords = ((ArtilleryAttackAction)((Object)enumeration)).getCoords();
                final Vector vector3 = ((ArtilleryAttackAction)((Object)enumeration)).getSpotterIds();
                final Targetable targetable = ((WeaponResult)serializable).waa.getTarget(this.game);
                Coords coords = targetable.getPosition();
                final int n = ((ArtilleryAttackAction)((Object)enumeration)).getPlayerId();
                RoundUpdated roundUpdated = null;
                Entity entity = this.game.getEntity(((WeaponResult)serializable).waa.getEntityId());
                if (entity == null) {
                    entity = this.game.getOutOfGameEntity(((WeaponResult)serializable).waa.getEntityId());
                }
                AmmoType ammoType2 = ammoType = (mounted = entity.getEquipment(((WeaponResult)serializable).waa.getAmmoId())) == null ? null : (AmmoType)mounted.getType();
                if (ammoType != null && ammoType.getMunitionType() == 0x20000000L) {
                    serializable = this.convertHomingShotToEntityTarget((ArtilleryAttackAction)((Object)enumeration), entity);
                } else {
                    RoundUpdated roundUpdated2;
                    Object object;
                    if (null != vector3) {
                        object = this.game.getSelectedEntities(new EntitySelector(){
                            public int player;
                            public Targetable targ;
                            {
                                this.player = n;
                                this.targ = targetable;
                            }

                            public boolean accept(Entity entity) {
                                Integer n2 = new Integer(entity.getId());
                                return this.player == entity.getOwnerId() && vector3.contains(n2) && !LosEffects.calculateLos(Server.this.game, entity.getId(), this.targ).isBlocked() && entity.isActive() && !entity.isINarcedWith(4L);
                            }
                        });
                        while (object.hasMoreElements()) {
                            roundUpdated2 = (Entity)object.nextElement();
                            if (roundUpdated != null && roundUpdated2.crew.getGunnery() >= roundUpdated.crew.getGunnery()) continue;
                            roundUpdated = roundUpdated2;
                        }
                    }
                    if (null != roundUpdated) {
                        int n2 = (roundUpdated.crew.getGunnery() - 4) / 2;
                        ((WeaponResult)serializable).toHit.addModifier(n2, "Spotting modifier");
                    }
                    if (null != (object = ((WeaponResult)serializable).waa.getEntity(this.game))) {
                        roundUpdated2 = ((Entity)object).getEquipment(((WeaponResult)serializable).waa.getWeaponId());
                        if (((WeaponResult)serializable).roll >= ((WeaponResult)serializable).toHit.getValue()) {
                            ((Entity)object).aTracker.setModifier((Mounted)roundUpdated2, Integer.MIN_VALUE, coords);
                        } else if (null != roundUpdated) {
                            ((Entity)object).aTracker.setModifier((Mounted)roundUpdated2, ((Entity)object).aTracker.getModifier((Mounted)roundUpdated2, coords) - 1, coords);
                        }
                    }
                }
                vector.addElement(serializable);
                vector2.addElement(enumeration);
            }
            --((ArtilleryAttackAction)((Object)enumeration)).turnsTilHit;
        }
        int n = -1;
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            serializable = (WeaponResult)enumeration.nextElement();
            this.resolveWeaponAttack((WeaponResult)serializable, n);
            n = ((WeaponResult)serializable).waa.getEntityId();
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            this.game.removeArtilleryAttack((ArtilleryAttackAction)enumeration.nextElement());
        }
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            serializable = (Player)enumeration.nextElement();
            int n3 = ((Player)serializable).getId();
            this.send(n3, this.createArtilleryPacket((Player)serializable));
        }
    }

    private void enqueueIndirectArtilleryAttacks() {
        Object object;
        this.resolveAllButWeaponAttacks();
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            object = (EntityAction)enumeration.nextElement();
            final Entity entity = this.game.getEntity(object.getEntityId());
            if (!(object instanceof WeaponAttackAction)) continue;
            final WeaponAttackAction weaponAttackAction = (WeaponAttackAction)object;
            WeaponResult weaponResult = this.preTreatWeaponAttack(weaponAttackAction);
            boolean bl = false;
            Enumeration enumeration2 = this.game.getArtilleryAttacks();
            while (!bl && enumeration2.hasMoreElements()) {
                serializable = (ArtilleryAttackAction)enumeration2.nextElement();
                if (((ArtilleryAttackAction)serializable).getWR().waa.getEntityId() != weaponResult.waa.getEntityId() || ((ArtilleryAttackAction)serializable).getWR().waa.getTarget(this.game).getPosition().equals(weaponResult.waa.getTarget(this.game).getPosition())) continue;
                bl = true;
            }
            if (bl) {
                this.clearArtillerySpotters(entity.getId(), weaponAttackAction.getWeaponId());
            }
            enumeration2 = this.game.getSelectedEntities(new EntitySelector(){
                public int player;
                public Targetable target;
                {
                    this.player = entity.getOwnerId();
                    this.target = weaponAttackAction.getTarget(Server.this.game);
                }

                public boolean accept(Entity entity2) {
                    return this.player == entity2.getOwnerId() && !LosEffects.calculateLos(Server.this.game, entity2.getId(), this.target).isBlocked() && entity2.isActive();
                }
            });
            serializable = new Vector();
            while (enumeration2.hasMoreElements()) {
                Integer n = new Integer(((Entity)enumeration2.nextElement()).getId());
                ((Vector)serializable).addElement(n);
            }
            ArtilleryAttackAction artilleryAttackAction = new ArtilleryAttackAction(weaponResult, this.game, entity.getOwnerId(), (Vector)serializable, entity.getPosition());
            this.game.addArtilleryAttack(artilleryAttackAction);
        }
        this.game.resetActions();
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            object = (Player)enumeration.nextElement();
            int n = ((Player)object).getId();
            this.send(n, this.createArtilleryPacket((Player)object));
        }
    }

    private void creditKill(Entity entity, Entity entity2) {
        if (entity.isDoomed() && !entity.getGaveKillCredit()) {
            entity2.addKill(entity);
        }
    }

    private PhysicalResult preTreatPhysicalAttack(AbstractAttackAction abstractAttackAction) {
        Entity entity = this.game.getEntity(abstractAttackAction.getEntityId());
        int n = 0;
        PhysicalResult physicalResult = new PhysicalResult();
        ToHitData toHitData = new ToHitData();
        physicalResult.roll = Compute.d6(2);
        physicalResult.aaa = abstractAttackAction;
        if (abstractAttackAction instanceof BrushOffAttackAction) {
            BrushOffAttackAction brushOffAttackAction = (BrushOffAttackAction)abstractAttackAction;
            int n2 = brushOffAttackAction.getArm();
            brushOffAttackAction.setArm(1);
            toHitData = BrushOffAttackAction.toHit(this.game, abstractAttackAction.getEntityId(), abstractAttackAction.getTarget(this.game), 1);
            brushOffAttackAction.setArm(2);
            physicalResult.toHitRight = BrushOffAttackAction.toHit(this.game, abstractAttackAction.getEntityId(), abstractAttackAction.getTarget(this.game), 2);
            n = BrushOffAttackAction.getDamageFor(entity, 1);
            physicalResult.damageRight = BrushOffAttackAction.getDamageFor(entity, 2);
            brushOffAttackAction.setArm(n2);
            physicalResult.rollRight = Compute.d6(2);
        } else if (abstractAttackAction instanceof ChargeAttackAction) {
            ChargeAttackAction chargeAttackAction = (ChargeAttackAction)abstractAttackAction;
            toHitData = chargeAttackAction.toHit(this.game);
            n = ChargeAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof ClubAttackAction) {
            ClubAttackAction clubAttackAction = (ClubAttackAction)abstractAttackAction;
            toHitData = clubAttackAction.toHit(this.game);
            n = ClubAttackAction.getDamageFor(entity, clubAttackAction.getClub());
        } else if (abstractAttackAction instanceof DfaAttackAction) {
            DfaAttackAction dfaAttackAction = (DfaAttackAction)abstractAttackAction;
            toHitData = dfaAttackAction.toHit(this.game);
            n = DfaAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof KickAttackAction) {
            KickAttackAction kickAttackAction = (KickAttackAction)abstractAttackAction;
            toHitData = kickAttackAction.toHit(this.game);
            n = KickAttackAction.getDamageFor(entity, kickAttackAction.getLeg());
        } else if (abstractAttackAction instanceof ProtomechPhysicalAttackAction) {
            ProtomechPhysicalAttackAction protomechPhysicalAttackAction = (ProtomechPhysicalAttackAction)abstractAttackAction;
            toHitData = protomechPhysicalAttackAction.toHit(this.game);
            n = ProtomechPhysicalAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof PunchAttackAction) {
            PunchAttackAction punchAttackAction = (PunchAttackAction)abstractAttackAction;
            int n3 = punchAttackAction.getArm();
            int n4 = 0;
            punchAttackAction.setArm(1);
            toHitData = punchAttackAction.toHit(this.game);
            punchAttackAction.setArm(2);
            ToHitData toHitData2 = punchAttackAction.toHit(this.game);
            n = PunchAttackAction.getDamageFor(entity, 1);
            n4 = PunchAttackAction.getDamageFor(entity, 2);
            punchAttackAction.setArm(n3);
            if (entity.isProne()) {
                double d;
                double d2 = Compute.oddsAbove(toHitData.getValue());
                if (d2 * (double)n > (d = Compute.oddsAbove(toHitData2.getValue())) * (double)n4) {
                    punchAttackAction.setArm(1);
                } else {
                    punchAttackAction.setArm(2);
                }
            }
            physicalResult.damageRight = n4;
            physicalResult.toHitRight = toHitData2;
            physicalResult.rollRight = Compute.d6(2);
        } else if (abstractAttackAction instanceof PushAttackAction) {
            PushAttackAction pushAttackAction = (PushAttackAction)abstractAttackAction;
            toHitData = pushAttackAction.toHit(this.game);
        } else if (abstractAttackAction instanceof ThrashAttackAction) {
            ThrashAttackAction thrashAttackAction = (ThrashAttackAction)abstractAttackAction;
            toHitData = thrashAttackAction.toHit(this.game);
            n = ThrashAttackAction.getDamageFor(entity);
        }
        physicalResult.toHit = toHitData;
        physicalResult.damage = n;
        return physicalResult;
    }

    private void resolvePhysicalAttack(PhysicalResult physicalResult, int n) {
        Object object;
        AbstractAttackAction abstractAttackAction = physicalResult.aaa;
        if (abstractAttackAction instanceof PunchAttackAction) {
            object = (PunchAttackAction)abstractAttackAction;
            if (((PunchAttackAction)object).getArm() == 0) {
                ((PunchAttackAction)object).setArm(1);
                physicalResult.aaa = object;
                this.resolvePunchAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
                ((PunchAttackAction)object).setArm(2);
                physicalResult.aaa = object;
                this.resolvePunchAttack(physicalResult, n);
            } else {
                this.resolvePunchAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
            }
        } else if (abstractAttackAction instanceof KickAttackAction) {
            this.resolveKickAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof BrushOffAttackAction) {
            object = (BrushOffAttackAction)abstractAttackAction;
            if (((BrushOffAttackAction)object).getArm() == 0) {
                ((BrushOffAttackAction)object).setArm(1);
                physicalResult.aaa = object;
                this.resolveBrushOffAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
                ((BrushOffAttackAction)object).setArm(2);
                physicalResult.aaa = object;
                this.resolveBrushOffAttack(physicalResult, n);
            } else {
                this.resolveBrushOffAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
            }
        } else if (abstractAttackAction instanceof ThrashAttackAction) {
            this.resolveThrashAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ProtomechPhysicalAttackAction) {
            this.resolveProtoAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ClubAttackAction) {
            this.resolveClubAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof PushAttackAction) {
            this.resolvePushAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ChargeAttackAction) {
            this.resolveChargeAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof DfaAttackAction) {
            this.resolveDfaAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        }
        object = this.game.getTarget(abstractAttackAction.getTargetType(), abstractAttackAction.getTargetId());
        if (object instanceof Entity) {
            this.creditKill((Entity)object, this.game.getEntity(n));
        }
    }

    private void checkExtremeGravityMovement(Entity entity, MoveStep moveStep, Coords coords, int n) {
        if (this.game.getOptions().floatOption("gravity") != 1.0f) {
            if (entity instanceof Mech) {
                if (moveStep.getMovementType() == 1 || moveStep.getMovementType() == 4 || moveStep.getMovementType() == 2 || moveStep.getMovementType() == 5) {
                    if (moveStep.getMpUsed() > n) {
                        this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                    }
                } else if (moveStep.getMovementType() == 3) {
                    if (moveStep.getMpUsed() > n) {
                        this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                    } else if (this.game.getOptions().floatOption("gravity") > 1.0f) {
                        PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
                        entity.addPilotingModifierForTerrain(pilotingRollData, moveStep);
                        pilotingRollData.append(new PilotingRollData(entity.getId(), 0, "jumped in high gravity"));
                        this.game.addExtremeGravityPSR(pilotingRollData);
                    }
                }
            } else if (entity instanceof Tank && (moveStep.getMovementType() == 1 || moveStep.getMovementType() == 4 || moveStep.getMovementType() == 2 || moveStep.getMovementType() == 5)) {
                if (moveStep.getMpUsed() > n && !moveStep.isOnlyPavement()) {
                    this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                } else if (moveStep.getMpUsed() > n + 1) {
                    this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                }
            }
        }
    }

    private void doExtremeGravityDamage(Entity entity, int n) {
        HitData hitData;
        int n2;
        if (entity instanceof BipedMech) {
            for (n2 = 6; n2 <= 7; ++n2) {
                hitData = new HitData(n2);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n, false, 0, true));
            }
        }
        if (entity instanceof QuadMech) {
            for (n2 = 4; n2 <= 7; ++n2) {
                hitData = new HitData(n2);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n, false, 0, true));
            }
        } else if (entity instanceof Tank) {
            hitData = new HitData(1);
            Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, n, false, 0, true));
        }
    }

    public Vector ejectEntity(Entity entity, boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        if (entity.getCrew().isEjected()) {
            return vector;
        }
        if (entity instanceof Mech) {
            Report report;
            PilotingRollData pilotingRollData = new PilotingRollData(entity.getId(), entity.getCrew().getPiloting(), "ejecting");
            if (entity.isProne()) {
                pilotingRollData.addModifier(5, "Mech is prone");
            }
            if (entity.getCrew().isUnconscious()) {
                pilotingRollData.addModifier(3, "pilot unconscious");
            }
            if (bl) {
                pilotingRollData.addModifier(1, "automatic ejection");
            }
            if (entity.getInternal(0) < 3) {
                pilotingRollData.addModifier(Math.min(3 - entity.getInternal(0), 2), "Head Internal Structure Damage");
            }
            int n = entity.getFacing();
            Coords coords = entity.getPosition().translated((n + 3) % 6);
            IHex iHex = this.game.getBoard().getHex(coords);
            if (iHex != null) {
                if (iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20)) {
                    pilotingRollData.addModifier(-1, "landing in water");
                } else if (iHex.containsTerrain(2)) {
                    pilotingRollData.addModifier(0, "landing in rough");
                } else if (iHex.containsTerrain(3)) {
                    pilotingRollData.addModifier(0, "landing in rubble");
                } else if (iHex.terrainLevel(1) == 1) {
                    pilotingRollData.addModifier(2, "landing in light woods");
                } else if (iHex.terrainLevel(1) == 2) {
                    pilotingRollData.addModifier(3, "landing in heavy woods");
                } else if (iHex.terrainLevel(1) == 3) {
                    pilotingRollData.addModifier(4, "landing in ultra heavy woods");
                } else if (iHex.terrainLevel(23) == 1) {
                    pilotingRollData.addModifier(3, "landing in light jungle");
                } else if (iHex.terrainLevel(23) == 2) {
                    pilotingRollData.addModifier(5, "landing in heavy jungle");
                } else if (iHex.terrainLevel(23) == 3) {
                    pilotingRollData.addModifier(7, "landing in ultra heavy jungle");
                } else if (iHex.terrainLevel(12) > 0) {
                    pilotingRollData.addModifier(iHex.terrainLevel(12), "landing in a building");
                } else {
                    pilotingRollData.addModifier(-2, "landing in clear terrain");
                }
            } else {
                pilotingRollData.addModifier(-2, "landing off the board");
            }
            if (bl) {
                report = new Report(6395);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
            }
            report = new Report(2180);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(pilotingRollData.getLastPlainDesc(), true);
            report.indent(3);
            vector.addElement(report);
            int n2 = Compute.d6(2);
            report = new Report(2190);
            report.subject = entity.getId();
            report.add(pilotingRollData.getValueAsString());
            report.add(pilotingRollData.getDesc());
            report.add(n2);
            report.indent(4);
            report.newlines = 0;
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            if (n2 < pilotingRollData.getValue()) {
                report.choose(false);
                vector.addElement(report);
                Report.addNewline(vector);
                Vector vector2 = this.damageCrew(mechWarrior, 1);
                report = (Report)vector2.firstElement();
                report.indent(3);
                vector.addElement(report);
            } else {
                report.choose(true);
                vector.addElement(report);
            }
            if (entity.getCrew().isDoomed()) {
                Server.combineVectors(vector, this.destroyEntity(mechWarrior, "deadly ejection", false, false));
            } else {
                if (this.game.getBoard().contains(coords)) {
                    mechWarrior.setPosition(coords);
                    report = new Report(6400);
                    report.subject = entity.getId();
                    report.indent(5);
                    vector.addElement(report);
                    if (this.game.getOptions().booleanOption("vacuum")) {
                        report = new Report(6405);
                        report.subject = entity.getId();
                        report.indent(3);
                        vector.addElement(report);
                        Server.combineVectors(vector, this.destroyEntity(mechWarrior, "explosive decompression", false, false));
                    }
                    this.entityUpdate(mechWarrior.getId());
                    this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), coords);
                } else {
                    report = new Report(6410);
                    report.subject = entity.getId();
                    report.indent(3);
                    vector.addElement(report);
                    if (this.game.getOptions().booleanOption("vacuum")) {
                        report = new Report(6405);
                        report.subject = entity.getId();
                        report.indent(3);
                        vector.addElement(report);
                        Server.combineVectors(vector, this.destroyEntity(mechWarrior, "explosive decompression", false, false));
                    } else {
                        this.game.removeEntity(mechWarrior.getId(), 256);
                        this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
                    }
                }
                if (this.game.getOptions().booleanOption("ejected_pilots_flee")) {
                    this.game.removeEntity(mechWarrior.getId(), 256);
                    this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
                }
            }
        }
        entity.getCrew().setEjected(true);
        Server.combineVectors(vector, this.destroyEntity(entity, "ejection", true, true));
        if (this.game.getPhase() == 8) {
            this.game.removeEntity(entity.getId(), 528);
            this.send(this.createRemoveEntityPacket(entity.getId(), 528));
        }
        return vector;
    }

    private void resolveMechWarriorPickUp() {
        Enumeration enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                MechWarrior mechWarrior;
                return entity instanceof MechWarrior && (mechWarrior = (MechWarrior)entity).getPickedUpById() == -1 && !mechWarrior.isDoomed() && mechWarrior.getTransportId() == -1;
            }
        });
        while (enumeration.hasMoreElements()) {
            Report report;
            Object object;
            boolean bl = false;
            MechWarrior mechWarrior = (MechWarrior)enumeration.nextElement();
            Enumeration enumeration2 = this.game.getEntities(mechWarrior.getPosition());
            while (enumeration2.hasMoreElements()) {
                object = (Entity)enumeration2.nextElement();
                if (((Entity)object).isDoomed() || ((Entity)object).isShutDown() || ((Entity)object).getCrew().isUnconscious() || bl || ((Entity)object).getOwnerId() != mechWarrior.getOwnerId() || ((Entity)object).getId() == mechWarrior.getId()) continue;
                if (object instanceof MechWarrior) {
                    report = new Report(6415, 0);
                    report.add(((Entity)object).getDisplayName());
                    this.vPhaseReport.addElement(report);
                    continue;
                }
                ((Entity)object).pickUp(mechWarrior);
                mechWarrior.setPickedUpById(((Entity)object).getId());
                mechWarrior.setPickedUpByExternalId(((Entity)object).getExternalId());
                bl = true;
                report = new Report(6420, 0);
                report.add(mechWarrior.getDisplayName());
                report.addDesc((Entity)object);
                this.vPhaseReport.addElement(report);
            }
            if (!bl) {
                object = this.game.getEnemyEntities(mechWarrior.getPosition(), mechWarrior);
                while (object.hasMoreElements()) {
                    Entity entity = (Entity)object.nextElement();
                    if (entity.isDoomed() || entity.isShutDown() || entity.getCrew().isUnconscious()) continue;
                    if (entity instanceof MechWarrior) {
                        report = new Report(6415, 0);
                        report.add(entity.getDisplayName());
                        this.vPhaseReport.addElement(report);
                        continue;
                    }
                    entity.pickUp(mechWarrior);
                    mechWarrior.setCaptured(true);
                    mechWarrior.setPickedUpById(entity.getId());
                    mechWarrior.setPickedUpByExternalId(entity.getExternalId());
                    bl = true;
                    report = new Report(6420, 0);
                    report.add(mechWarrior.getDisplayName());
                    report.addDesc(entity);
                    this.vPhaseReport.addElement(report);
                }
            }
            if (!bl) continue;
            mechWarrior.setPosition(null);
            this.entityUpdate(mechWarrior.getId());
        }
    }

    private void resolveSinkVees() {
        Enumeration enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                if (entity.isOffBoard()) {
                    return false;
                }
                return entity instanceof Tank && entity.getPosition() != null && (entity.getMovementMode() == 3 || entity.getMovementMode() == 4) && Server.this.game.getBoard().getHex(entity.getPosition()).terrainLevel(4) > 0 && !Server.this.game.getBoard().getHex(entity.getPosition()).containsTerrain(20);
            }
        });
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity, "a watery grave", false));
        }
    }

    private void doTryUnstuck() {
        if (this.game.getPhase() != 8) {
            return;
        }
        Enumeration enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return entity.isStuck();
            }
        });
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
            entity.addPilotingModifierForTerrain(pilotingRollData);
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (!iHex.containsTerrain(9) && iHex.terrainLevel(24) != 2) {
                pilotingRollData.addModifier(-1, "bogged down");
            }
            Report report = new Report(2340);
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
            int n = Compute.d6(2);
            report = new Report(2190);
            report.add(pilotingRollData.getValueAsString());
            report.add(pilotingRollData.getDesc());
            report.add(n);
            if (n < pilotingRollData.getValue()) {
                report.choose(false);
            } else {
                report.choose(true);
                entity.setStuck(false);
                entity.setCanUnstickByJumping(false);
            }
            this.vPhaseReport.addElement(report);
        }
    }

    private void resolveVeeINarcPodRemoval() {
        Enumeration enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return entity instanceof Tank && entity.mpUsed == 0;
            }
        });
        while (enumeration.hasMoreElements()) {
            boolean bl = true;
            Entity entity = (Entity)enumeration.nextElement();
            for (int i = 0; i <= 5; ++i) {
                if (!entity.weaponFiredFrom(i)) continue;
                bl = false;
            }
            if (!bl || !entity.hasINarcPodsAttached() || !entity.getCrew().isActive()) continue;
            entity.removeAllINarcPods();
            Report report = new Report(2345);
            report.addDesc(entity);
            this.vPhaseReport.addElement(report);
        }
    }

    private void deadEntitiesCleanup() {
    }

    private void resolveIceBroken(Coords coords) {
        this.game.getBoard().getHex(coords).removeTerrain(20);
        this.sendChangedHex(coords);
        Enumeration enumeration = this.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getElevation() != 0) continue;
            if (entity instanceof Mech) {
                this.doEntityFall(entity, new PilotingRollData(0x7FFFFFFE));
                continue;
            }
            if (entity.getRunMP() <= 0 || entity.getMovementMode() == 5 || entity.getMovementMode() == 8 || entity.getMovementMode() == 7 || entity.getMovementMode() == 9) continue;
            Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity, "a watery grave", false));
        }
    }

    private void checkForVehicleFire(Tank tank, boolean bl) {
        int n = Compute.d6(2);
        int n2 = 0;
        switch (tank.getMovementMode()) {
            case 5: {
                n2 = 4;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
            }
        }
        if (bl) {
            n = 12;
        }
        Report report = new Report(5250);
        report.subject = tank.getId();
        report.addDesc(tank);
        report.add(8 - n2);
        report.add(n);
        if (n + n2 < 8) {
            report.choose(true);
            this.vPhaseReport.addElement(report);
        } else {
            if (!bl) {
                report.choose(false);
                this.vPhaseReport.addElement(report);
            }
            if (n + n2 < 10) {
                this.vehicleMotiveDamage(tank, n2 - 1);
            } else {
                this.resolveVehicleFire(tank, false);
                if (n + n2 >= 12) {
                    report = new Report(5255);
                    report.subject = tank.getId();
                    report.indent(3);
                    this.vPhaseReport.add(report);
                    tank.setOnFire();
                }
            }
        }
    }

    private void resolveVehicleFire(Tank tank, boolean bl) {
        if (bl && !tank.isOnFire()) {
            return;
        }
        for (int i = 0; i < tank.locations(); ++i) {
            if (i == 0 || tank instanceof VTOL && i == 5 || bl && !tank.isLocationBurning(i)) continue;
            HitData hitData = new HitData(i);
            int n = Compute.d6(1);
            Server.combineVectors(this.vPhaseReport, this.damageEntity(tank, hitData, n));
            if (n != 1 || !bl) continue;
            tank.extinguishLocation(i);
        }
        Report.addNewline(this.vPhaseReport);
    }

    private void vehicleMotiveDamage(Tank tank, int n) {
        Vector<Report> vector = new Vector<Report>();
        int n2 = Compute.d6(2) + n;
        Report report = new Report(6305);
        report.subject = tank.getId();
        report.add("movement system");
        report.newlines = 0;
        report.indent(3);
        vector.addElement(report);
        report = new Report(6310);
        report.subject = tank.getId();
        report.add(n2);
        report.newlines = 0;
        vector.addElement(report);
        if (n2 <= 7) {
            report = new Report(6005);
            report.subject = tank.getId();
            report.add(n2);
            vector.addElement(report);
        } else if (n2 <= 9) {
            report = new Report(6470);
            report.subject = tank.getId();
            report.add(n2);
            vector.addElement(report);
            tank.addMovementDamage(1);
        } else if (n2 < 12) {
            report = new Report(6135);
            report.subject = tank.getId();
            vector.addElement(report);
            tank.addMovementDamage(2);
            int n3 = tank.getOriginalWalkMP();
            if (n3 > 0) {
                tank.setOriginalWalkMP(n3 - 1);
                if (tank.getOriginalWalkMP() == 0 && tank.getMovementMode() == 5 && this.game.getBoard().getHex(tank.getPosition()).terrainLevel(4) > 0 && !this.game.getBoard().getHex(tank.getPosition()).containsTerrain(20)) {
                    Server.combineVectors(vector, this.destroyEntity(tank, "a watery grave", false));
                }
            }
        } else {
            report = new Report(6140);
            report.subject = tank.getId();
            vector.addElement(report);
            tank.immobilize();
            IHex iHex = this.game.getBoard().getHex(tank.getPosition());
            if (tank.getMovementMode() == 5 && iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20)) {
                Server.combineVectors(vector, this.destroyEntity(tank, "a watery grave", false));
            }
            if (tank instanceof VTOL) {
                Report.addNewline(vector);
                Server.combineVectors(vector, this.crashVTOL((VTOL)tank));
            }
        }
        Server.combineVectors(this.vPhaseReport, vector);
    }

    public void doAssaultDrop(Entity entity) {
        PilotingRollData pilotingRollData = entity instanceof Mech ? entity.getBasePilotingRoll() : new PilotingRollData(entity.getId(), 4, "landing assault drop");
        int n = Compute.d6(2);
        Report report = new Report(2380);
        report.subject = entity.getId();
        report.add(entity.getDisplayName(), true);
        report.add(pilotingRollData.getValueAsString());
        report.add(n);
        report.choose(n >= pilotingRollData.getValue());
        this.vPhaseReport.addElement(report);
        if (n < pilotingRollData.getValue()) {
            int n2 = pilotingRollData.getValue() - n;
            int n3 = Compute.d6(n2);
            Coords coords = Compute.scatter(entity.getPosition(), n3);
            report = new Report(2385);
            report.subject = entity.getId();
            report.add(n3);
            report.indent(3);
            report.newlines = 0;
            this.vPhaseReport.addElement(report);
            if (n2 >= 5 || !this.game.getBoard().contains(coords)) {
                report = new Report(2386);
                this.vPhaseReport.addElement(report);
                this.game.removeEntity(entity.getId(), 2048);
                return;
            }
            entity.setPosition(coords);
            if (entity instanceof Mech || entity instanceof Protomech) {
                entity.setElevation(n2);
                this.doEntityFallsInto(entity, coords, coords, pilotingRollData, true);
            } else if (entity instanceof BattleArmor) {
                for (int i = 1; i < entity.locations(); ++i) {
                    HitData hitData = new HitData(i);
                    Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, Compute.d6(n2)));
                    Report.addNewline(this.vPhaseReport);
                }
            } else if (entity instanceof Infantry) {
                HitData hitData = new HitData(0);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, 1));
                Report.addNewline(this.vPhaseReport);
            }
        }
        IHex iHex = this.game.getBoard().getHex(entity.getPosition());
        entity.setElevation(entity.elevationOccupied(iHex) - iHex.floor());
        Entity entity2 = Compute.stackingViolation(this.game, entity, entity.getPosition(), null);
        if (entity2 != null) {
            entity.setElevation(entity2.getElevation() + 2);
            report = new Report(2390);
            report.subject = entity.getId();
            report.add(entity.getDisplayName(), true);
            report.add(entity2.getDisplayName(), true);
            this.vPhaseReport.addElement(report);
            this.doEntityFallsInto(entity, entity.getPosition(), entity.getPosition(), pilotingRollData);
        }
    }

    void doAllAssaultDrops() {
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.isAssaultDropInProgress()) continue;
            this.doAssaultDrop(entity);
            entity.setLandedAssaultDrop();
        }
    }

    void doMagmaDamage(Entity entity, boolean bl) {
        if ((entity.getMovementMode() == 6 || entity.getMovementMode() == 5 && entity.getOriginalWalkMP() > 0 && !bl) && !entity.isImmobile()) {
            return;
        }
        boolean bl2 = entity instanceof Mech;
        Report report = bl2 ? new Report(2405) : new Report(2400);
        report.addDesc(entity);
        report.subject = entity.getId();
        this.vPhaseReport.add(report);
        if (bl2) {
            for (int i = 0; i < entity.locations(); ++i) {
                if (!bl && !entity.locationIsLeg(i) && !entity.isProne()) continue;
                HitData hitData = new HitData(i);
                Server.combineVectors(this.vPhaseReport, this.damageEntity(entity, hitData, Compute.d6(2)));
            }
        } else {
            Server.combineVectors(this.vPhaseReport, this.destroyEntity(entity, "fell into magma", false, false));
        }
        Report.addNewline(this.vPhaseReport);
    }
}

