/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import megamek.common.Player;
import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class VictoryCommand
extends ServerCommand {
    public VictoryCommand(Server server) {
        super(server, "victory", "Causes automatic victory for the issuing player or his/her team at the end of this turn. Must be acknowledged by all opponents using the /defeat command. Usage: /victory <password>");
    }

    public void run(int n, String[] stringArray) {
        if (!this.server.isPassworded() || stringArray.length > 1 && this.server.isPassword(stringArray[1])) {
            this.reset(n);
        } else {
            this.server.sendServerChat(n, "The password is incorrect.  Usage: /victory <password>");
        }
    }

    private void reset(int n) {
        Player player = this.server.getPlayer(n);
        if (player.getTeam() == 0) {
            this.server.sendServerChat(player.getName() + " declares individual victory at the end of the turn. This must be acknowledged by all opponents using the /defeat command or no victory will occur.");
        } else {
            this.server.sendServerChat(player.getName() + " declares team victory at the end of the turn. This must be acknowledged by all opponents using the /defeat command or no victory will occur.");
        }
        this.server.forceVictory(player);
    }
}

