/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.NoArgSQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;
import net.sf.hibernate.sql.CaseFragment;
import net.sf.hibernate.sql.HSQLCaseFragment;

public class HSQLDialect
extends Dialect {
    public HSQLDialect() {
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(-2, "BINARY");
        this.registerColumnType(-7, "BIT");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(3, "DECIMAL");
        this.registerColumnType(8, "DOUBLE");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(-4, "LONGVARBINARY");
        this.registerColumnType(-1, "LONGVARCHAR");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "TINYINT");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(-3, "VARBINARY($l)");
        this.registerColumnType(2, "NUMERIC");
        this.registerColumnType(2004, "LONGVARBINARY");
        this.registerColumnType(2005, "LONGVARCHAR");
        this.registerFunction("ascii", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("char", new StandardSQLFunction(Hibernate.CHARACTER));
        this.registerFunction("length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("lower", new StandardSQLFunction());
        this.registerFunction("upper", new StandardSQLFunction());
        this.registerFunction("lcase", new StandardSQLFunction());
        this.registerFunction("ucase", new StandardSQLFunction());
        this.registerFunction("soundex", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("ltrim", new StandardSQLFunction());
        this.registerFunction("rtrim", new StandardSQLFunction());
        this.registerFunction("reverse", new StandardSQLFunction());
        this.registerFunction("space", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("rawtohex", new StandardSQLFunction());
        this.registerFunction("hextoraw", new StandardSQLFunction());
        this.registerFunction("user", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("database", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("curdate", new NoArgSQLFunction(Hibernate.DATE));
        this.registerFunction("now", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("curtime", new NoArgSQLFunction(Hibernate.TIME));
        this.registerFunction("day", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofweek", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofmonth", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("week", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("quater", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("hour", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("minute", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("second", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("monthname", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("abs", new StandardSQLFunction());
        this.registerFunction("sign", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("rand", new StandardSQLFunction(Hibernate.FLOAT));
        this.registerFunction("radians", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("roundmagic", new StandardSQLFunction());
        this.registerFunction("ceiling", new StandardSQLFunction());
        this.registerFunction("floor", new StandardSQLFunction());
        this.registerFunction("mod", new StandardSQLFunction(Hibernate.INTEGER));
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentityColumnString() {
        return "NOT NULL IDENTITY";
    }

    public String getIdentitySelectString() {
        return "CALL IDENTITY()";
    }

    public String getIdentityInsertString() {
        return "null";
    }

    public boolean supportsForUpdate() {
        return false;
    }

    public boolean supportsUnique() {
        return false;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 10).append(sql).insert(6, hasOffset ? " limit ? ?" : " top ?").toString();
    }

    public CaseFragment createCaseFragment() {
        return new HSQLCaseFragment();
    }

    public boolean bindLimitParametersFirst() {
        return true;
    }

    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    public boolean supportsCheck() {
        return false;
    }
}

