/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.NoArgSQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;

public class SybaseDialect
extends Dialect {
    public SybaseDialect() {
        this.registerColumnType(-7, "TINYINT");
        this.registerColumnType(-5, "NUMERIC(19,0)");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "TINYINT");
        this.registerColumnType(4, "INT");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(91, "DATETIME");
        this.registerColumnType(92, "DATETIME");
        this.registerColumnType(93, "DATETIME");
        this.registerColumnType(-3, "VARBINARY($l)");
        this.registerColumnType(2, "NUMERIC(19,$l)");
        this.registerColumnType(2004, "IMAGE");
        this.registerColumnType(2005, "TEXT");
        this.registerFunction("ascii", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("char", new StandardSQLFunction(Hibernate.CHARACTER));
        this.registerFunction("len", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("lower", new StandardSQLFunction());
        this.registerFunction("upper", new StandardSQLFunction());
        this.registerFunction("str", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("ltrim", new StandardSQLFunction());
        this.registerFunction("rtrim", new StandardSQLFunction());
        this.registerFunction("reverse", new StandardSQLFunction());
        this.registerFunction("space", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("user", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("getdate", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("getutcdate", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("day", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("datename", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("abs", new StandardSQLFunction());
        this.registerFunction("sign", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("square", new StandardSQLFunction());
        this.registerFunction("rand", new StandardSQLFunction(Hibernate.FLOAT));
        this.registerFunction("radians", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction());
        this.registerFunction("ceiling", new StandardSQLFunction());
        this.registerFunction("floor", new StandardSQLFunction());
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getNullColumnString() {
        return " null";
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsForUpdate() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "select @@identity";
    }

    public String getIdentityColumnString() {
        return "IDENTITY NOT NULL";
    }

    public String getNoColumnsInsertString() {
        return "DEFAULT VALUES";
    }

    public char closeQuote() {
        return ']';
    }

    public char openQuote() {
        return '[';
    }

    public String appendIdentitySelectToInsert(String insertSQL) {
        return insertSQL + "\nselect @@identity";
    }
}

