/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.CollectionSnapshot;
import net.sf.hibernate.impl.ReattachVisitor;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.type.PersistentCollectionType;

class OnUpdateVisitor
extends ReattachVisitor {
    OnUpdateVisitor(SessionImpl session, Serializable key) {
        super(session, key);
    }

    Object processCollection(Object collection, PersistentCollectionType type) throws HibernateException {
        SessionImpl session = this.getSession();
        Serializable key = this.getKey();
        CollectionPersister persister = session.getCollectionPersister(type.getRole());
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection wrapper = (PersistentCollection)collection;
            if (wrapper.setCurrentSession(session)) {
                CollectionSnapshot snapshot = wrapper.getCollectionSnapshot();
                if (!SessionImpl.isOwnerUnchanged(snapshot, persister, key)) {
                    session.removeCollection(persister, key);
                }
                session.reattachCollection(wrapper, snapshot);
            } else {
                session.removeCollection(persister, key);
            }
        } else {
            session.removeCollection(persister, key);
        }
        return null;
    }
}

