/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.ScheduledCollectionAction;
import net.sf.hibernate.impl.SessionImpl;

final class ScheduledCollectionUpdate
extends ScheduledCollectionAction
implements SessionImpl.Executable,
Serializable {
    private final PersistentCollection collection;
    private final boolean emptySnapshot;

    public ScheduledCollectionUpdate(PersistentCollection collection, CollectionPersister persister, Serializable id, boolean emptySnapshot, SessionImplementor session) throws CacheException {
        super(persister, id, session);
        this.collection = collection;
        this.emptySnapshot = emptySnapshot;
    }

    public void execute() throws HibernateException {
        Serializable id = this.getId();
        SessionImplementor session = this.getSession();
        CollectionPersister persister = this.getPersister();
        if (!this.collection.wasInitialized()) {
            if (!this.collection.hasQueuedAdditions()) {
                throw new AssertionFailure("bug processing queued adds");
            }
        } else if (this.collection.empty()) {
            if (!this.emptySnapshot) {
                persister.remove(id, session);
            }
        } else if (this.collection.needsRecreate(this.getPersister())) {
            if (!this.emptySnapshot) {
                persister.remove(id, session);
            }
            persister.recreate(this.collection, id, session);
        } else {
            persister.deleteRows(this.collection, id, session);
            persister.updateRows(this.collection, id, session);
            persister.insertRows(this.collection, id, session);
        }
        this.evict();
    }
}

