/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.hibernate.dialect.Dialect;

public final class Template {
    private static final Set KEYWORDS = new HashSet();
    private static final Set BEFORE_TABLE_KEYWORDS = new HashSet();
    public static final String TEMPLATE = "$PlaceHolder$";

    private Template() {
    }

    public static String renderWhereStringTemplate(String sqlWhereString, Dialect dialect) {
        String nextToken;
        String symbols = " =><!+-*/()'," + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer tokens = new StringTokenizer(sqlWhereString, symbols, true);
        StringBuffer result = new StringBuffer();
        boolean quoted = false;
        boolean quotedIdentifier = false;
        boolean afterFrom = false;
        boolean afterFromTable = false;
        boolean hasMore = tokens.hasMoreTokens();
        String string = nextToken = hasMore ? tokens.nextToken() : null;
        while (hasMore) {
            String token = nextToken;
            String lcToken = token.toLowerCase();
            hasMore = tokens.hasMoreTokens();
            String string2 = nextToken = hasMore ? tokens.nextToken() : null;
            if (!quotedIdentifier && "'".equals(token)) {
                boolean bl = quoted = !quoted;
            }
            if (!quoted && !quotedIdentifier && dialect.openQuote() == token.charAt(0)) {
                quotedIdentifier = true;
            }
            if (!quoted && quotedIdentifier && dialect.closeQuote() == token.charAt(0)) {
                quotedIdentifier = false;
            }
            if (quoted || quotedIdentifier || Character.isWhitespace(token.charAt(0))) {
                result.append(token);
                continue;
            }
            if (afterFrom) {
                result.append(token);
                afterFrom = false;
                afterFromTable = true;
                continue;
            }
            if (afterFromTable) {
                afterFromTable = false;
                result.append(token);
                continue;
            }
            if (Template.isIdentifier(token, dialect) && !Template.isFunction(lcToken, nextToken, dialect)) {
                result.append(TEMPLATE).append('.').append(Template.quote(token, dialect));
                continue;
            }
            if (BEFORE_TABLE_KEYWORDS.contains(lcToken)) {
                afterFrom = true;
            }
            result.append(token);
        }
        return result.toString();
    }

    private static boolean isFunction(String lcToken, String nextToken, Dialect dialect) {
        return "(".equals(nextToken) || KEYWORDS.contains(lcToken) || dialect.getFunctions().containsKey(lcToken);
    }

    private static boolean isIdentifier(String token, Dialect dialect) {
        return token.charAt(0) == '`' || Character.isLetter(token.charAt(0)) && token.indexOf(46) < 0;
    }

    public static String renderOrderByStringTemplate(String sqlOrderByString, Dialect dialect) {
        StringTokenizer tokens = new StringTokenizer(sqlOrderByString, ",");
        StringBuffer result = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String column = Template.quote(tokens.nextToken().trim(), dialect);
            result.append(TEMPLATE).append('.').append(column);
            if (!tokens.hasMoreTokens()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private static String quote(String column, Dialect dialect) {
        if (column.charAt(0) == '`') {
            return dialect.openQuote() + column.substring(1, column.length() - 1) + dialect.closeQuote();
        }
        return column;
    }

    static {
        KEYWORDS.add("and");
        KEYWORDS.add("or");
        KEYWORDS.add("not");
        KEYWORDS.add("like");
        KEYWORDS.add("is");
        KEYWORDS.add("in");
        KEYWORDS.add("between");
        KEYWORDS.add("null");
        KEYWORDS.add("select");
        KEYWORDS.add("from");
        KEYWORDS.add("join");
        KEYWORDS.add("inner");
        KEYWORDS.add("outer");
        KEYWORDS.add("left");
        KEYWORDS.add("right");
        KEYWORDS.add("on");
        KEYWORDS.add("where");
        KEYWORDS.add("having");
        KEYWORDS.add("group");
        KEYWORDS.add("order");
        KEYWORDS.add("by");
        KEYWORDS.add("case");
        KEYWORDS.add("when");
        KEYWORDS.add("then");
        KEYWORDS.add("else");
        KEYWORDS.add("end");
        BEFORE_TABLE_KEYWORDS.add("from");
        BEFORE_TABLE_KEYWORDS.add("join");
    }
}

