/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import net.sf.cglib.core.CodeGenerationException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;

public class DebuggingClassWriter
extends ClassWriter {
    public static final String DEBUG_LOCATION_PROPERTY = "cglib.debugLocation";
    private static String debugLocation = System.getProperty("cglib.debugLocation");
    private static boolean traceEnabled;
    private String className;
    private String superName;

    public DebuggingClassWriter(boolean computeMaxs) {
        super(computeMaxs);
    }

    public void visit(int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.className = name.replace('/', '.');
        this.superName = superName.replace('/', '.');
        super.visit(access, name, superName, interfaces, sourceFile);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    public byte[] toByteArray() {
        byte[] b;
        block7: {
            b = super.toByteArray();
            if (debugLocation != null) {
                String dirs = this.className.replace('.', File.separatorChar);
                try {
                    new File(debugLocation + File.separatorChar + dirs).getParentFile().mkdirs();
                    File file = new File(new File(debugLocation), dirs + ".class");
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    try {
                        ((OutputStream)out).write(b);
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        ((OutputStream)out).close();
                        throw throwable;
                    }
                    ((OutputStream)out).close();
                    if (!traceEnabled) break block7;
                    file = new File(new File(debugLocation), dirs + ".asm");
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    try {
                        ClassReader cr = new ClassReader(b);
                        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
                        TraceClassVisitor tcv = new TraceClassVisitor(null, pw);
                        cr.accept((ClassVisitor)tcv, false);
                        pw.flush();
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        ((OutputStream)out).close();
                        throw throwable;
                    }
                    ((OutputStream)out).close();
                    {
                    }
                }
                catch (IOException e) {
                    throw new CodeGenerationException(e);
                }
            }
        }
        return b;
    }

    static {
        if (debugLocation != null) {
            System.err.println("CGLIB debugging enabled, writing to '" + debugLocation + "'");
            try {
                Class.forName("org.objectweb.asm.util.TraceClassVisitor");
                traceEnabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

