/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.JsseX509KeyManager;
import com.sun.net.ssl.internal.ssl.JsseX509TrustManager;
import com.sun.net.ssl.internal.ssl.SSLServerSocketFactoryImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketFactoryImpl;
import com.sun.net.ssl.internal.ssl.TrustManagerFactoryImpl;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public final class SSLContextImpl
extends SSLContextSpi {
    private static SSLContextImpl a;
    private X509KeyManager b;
    private X509TrustManager c;
    private SecureRandom d;
    private SSLSessionContextImpl e = new SSLSessionContextImpl();
    private SSLSessionContextImpl f = new SSLSessionContextImpl();
    private static final Debug g;

    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.b = new JsseX509KeyManager(keyManagerArray);
        if (trustManagerArray == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init((KeyStore)null);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.c = new JsseX509TrustManager(trustManagerArray);
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        this.d = secureRandom;
        if (g != null && Debug.isOn("sslctx")) {
            System.out.println("trigger seeding of SecureRandom");
        }
        this.d.nextInt();
        if (g != null && Debug.isOn("sslctx")) {
            System.out.println("done seeding SecureRandom");
        }
    }

    protected SSLSocketFactory engineGetSocketFactory() {
        return new SSLSocketFactoryImpl(this);
    }

    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new SSLServerSocketFactoryImpl(this);
    }

    protected SSLSessionContext engineGetClientSessionContext() {
        return this.e;
    }

    protected SSLSessionContext engineGetServerSessionContext() {
        return this.f;
    }

    SecureRandom a() {
        return this.d;
    }

    X509KeyManager b() {
        return this.b;
    }

    X509TrustManager c() {
        return this.c;
    }

    static synchronized SSLContextImpl d() {
        if (a != null) {
            return a;
        }
        try {
            Object object;
            String string = null;
            final HashMap hashMap = new HashMap();
            FileInputStream fileInputStream = null;
            KeyStore keyStore = null;
            SSLContextImpl sSLContextImpl = null;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    hashMap.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                    hashMap.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                    hashMap.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                    return null;
                }
            });
            final String string2 = (String)hashMap.get("keyStore");
            String string3 = (String)hashMap.get("keyStoreType");
            if (g != null && Debug.isOn("defaultctx")) {
                System.out.println("keyStore is : " + string2);
                System.out.println("keyStore type is : " + string3);
            }
            if (string2.length() != 0) {
                fileInputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new FileInputStream(string2);
                    }
                });
            }
            if (string3.length() != 0) {
                if (g != null && Debug.isOn("defaultctx")) {
                    System.out.println("init keystore");
                }
                keyStore = KeyStore.getInstance(string3);
                object = null;
                string = (String)hashMap.get("keyStorePasswd");
                if (string.length() != 0) {
                    object = string.toCharArray();
                }
                keyStore.load(fileInputStream, (char[])object);
                if (object != null) {
                    int n = 0;
                    while (n < ((Object)object).length) {
                        object[n] = false;
                        ++n;
                    }
                }
            }
            if (fileInputStream != null) {
                fileInputStream.close();
                fileInputStream = null;
            }
            if (g != null && Debug.isOn("defaultctx")) {
                System.out.println("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
            }
            object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ((KeyManagerFactory)object).init(keyStore, string.toCharArray());
            KeyManager[] keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
            keyStore = TrustManagerFactoryImpl.a("defaultctx");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            TrustManager[] trustManagerArray = null;
            trustManagerFactory.init(keyStore);
            trustManagerArray = trustManagerFactory.getTrustManagers();
            if (g != null && Debug.isOn("defaultctx")) {
                System.out.println("init context");
            }
            sSLContextImpl = new SSLContextImpl();
            sSLContextImpl.engineInit(keyManagerArray, trustManagerArray, null);
            a = sSLContextImpl;
        }
        catch (RuntimeException runtimeException) {
            if (g != null && Debug.isOn("defaultctx")) {
                System.out.println("default context init failed: " + runtimeException);
            }
            throw runtimeException;
        }
        catch (Exception exception) {
            if (g != null && Debug.isOn("defaultctx")) {
                System.out.println("default context init failed: " + exception);
            }
            throw new RuntimeException("Default SSL context init failed: " + exception.getMessage());
        }
        catch (Error error) {
            if (g != null && Debug.isOn("defaultctx")) {
                System.out.println("default context init failed: " + error);
            }
            throw error;
        }
        return a;
    }

    static {
        g = Debug.getInstance("ssl");
    }
}

