/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.MWClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class CConfig {
    public static final String IMAGE_PATH = "data/images/";
    public static final String CAMO_PATH = "data/images/camo/";
    private Properties config;
    private Properties defaults;
    private Properties guiTexts;
    private Properties guiDefaults;
    private String filename;
    private TreeMap images;

    public CConfig(String tfilename) {
        this.filename = tfilename;
        this.createDefaults();
        this.config = new Properties(this.defaults);
        this.createGUIDefaults();
        this.guiTexts = new Properties(this.guiDefaults);
        this.images = new TreeMap();
        this.checkConfig();
        this.loadConfig();
        this.loadServerAddress();
        this.loadImages();
    }

    public CConfig(String tfilename, boolean dedicated) {
        this.filename = tfilename;
        this.createDefaults();
        this.config = new Properties(this.defaults);
        this.createGUIDefaults();
        this.guiTexts = new Properties(this.guiDefaults);
        this.images = new TreeMap();
        this.checkConfig();
        this.loadConfig();
        this.loadServerAddress();
        if (dedicated) {
            this.setDedicated("YES");
        } else {
            this.loadImages();
        }
    }

    protected void createDefaults() {
        this.defaults = new Properties();
        this.defaults.setProperty("NAME", "");
        this.defaults.setProperty("NAMEPASSWORD", "");
        this.defaults.setProperty("PORT", "2346");
        this.defaults.setProperty("SERVERIP", "");
        this.defaults.setProperty("SERVERPORT", "2347");
        this.defaults.setProperty("DATAPORT", "4867");
        this.defaults.setProperty("AUTOCONNECT", "NO");
        this.defaults.setProperty("TIMEOUT", "180");
        this.defaults.setProperty("LOOKANDFEEL", "system");
        this.defaults.setProperty("COLORBLIND", "NO");
        this.defaults.setProperty("TIMESTAMP", "YES");
        this.defaults.setProperty("WIKIURL", "http://wiki.megamek.net/index.php?");
        this.defaults.setProperty("DEDICATED", "NO");
        this.defaults.setProperty("DEDICATEDCOMMANDPREFIX", "defaultprefix");
        this.defaults.setProperty("DEDICATEDOWNERNAME", "");
        this.defaults.setProperty("MENUCOLOR", "NO");
        this.defaults.setProperty("SPLITTERSIZE", "7");
        this.defaults.setProperty("PLAYERPANEL", "YES");
        this.defaults.setProperty("PLAYERPANELHEIGHT", "130");
        this.defaults.setProperty("LOGO", "NO");
        this.defaults.setProperty("LOGOIMAGE", "logo.jpg");
        this.defaults.setProperty("POPUPONATTACK", "YES");
        this.defaults.setProperty("POPUPONMESSAGE", "NO");
        this.defaults.setProperty("UNITCAMO", "Desert2.jpg");
        this.defaults.setProperty("UNITHEX", "NO");
        this.defaults.setProperty("HQCOLORSCHEME", "grey");
        this.defaults.setProperty("UNITAMOUNT", "10");
        this.defaults.setProperty("USERLISTBOLD", "YES");
        this.defaults.setProperty("USERLISTCOLOR", "YES");
        this.defaults.setProperty("USERLISTIMAGE", "YES");
        this.defaults.setProperty("USERLISTCOUNT", "YES");
        this.defaults.setProperty("USERLISTDEDICATEDS", "NO");
        this.defaults.setProperty("USERLISTACTIVITYBTN", "YES");
        this.defaults.setProperty("COMMANDPREFIX", "/");
        this.defaults.setProperty("MAINCHANNELNEWS", "YES");
        this.defaults.setProperty("MAINCHANNELHM", "NO");
        this.defaults.setProperty("MAINCHANNELPM", "NO");
        this.defaults.setProperty("MAINCHANNELSM", "NO");
        this.defaults.setProperty("MAINCHANNELMISC", "NO");
        this.defaults.setProperty("COMMTABSCOLOR", "YES");
        this.defaults.setProperty("AUTOSCROLL", "NO");
        this.defaults.setProperty("REPLYTOSENDER", "YES");
        this.defaults.setProperty("REPLYTORECEIVER", "NO");
        this.defaults.setProperty("CHATFONTSIZE", "+0");
        this.defaults.setProperty("CHATFONTCOLOR", "black");
        this.defaults.setProperty("SOUNDONCALL", "./data/sounds/call.wav");
        this.defaults.setProperty("SOUNDONKEYWORD", "./data/sounds/call.wav");
        this.defaults.setProperty("SOUNDONMESSAGE", "./data/sounds/mail.wav");
        this.defaults.setProperty("SOUNDONATTACK", "./data/sounds/attack.wav");
        this.defaults.setProperty("SOUNDONBMWIN", "./data/sounds/radarping.wav");
        this.defaults.setProperty("ENABLECALLSOUND", "YES");
        this.defaults.setProperty("ENABLEKEYWORDSOUND", "YES");
        this.defaults.setProperty("ENABLEMESSAGESOUND", "YES");
        this.defaults.setProperty("ENABLEATTACKSOUND", "YES");
        this.defaults.setProperty("ENABLEBMSOUND", "YES");
        this.defaults.setProperty("SOUNDSFROMSYSMESSAGES", "NO");
        this.defaults.setProperty("OLDSTYLETABS", "NO");
        this.defaults.setProperty("HQTABVISIBLE", "YES");
        this.defaults.setProperty("HQTABNAME", "Headquarters");
        this.defaults.setProperty("HQINTOPROW", "YES");
        this.defaults.setProperty("HQMNEMONIC", "Q");
        this.defaults.setProperty("BMTABVISIBLE", "YES");
        this.defaults.setProperty("BMTABNAME", "Black Market");
        this.defaults.setProperty("BMINTOPROW", "YES");
        this.defaults.setProperty("BMMNEMONIC", "L");
        this.defaults.setProperty("HSTATUSTABVISIBLE", "YES");
        this.defaults.setProperty("HSTATUSTABNAME", "Faction Status");
        this.defaults.setProperty("HSTATUSINTOPROW", "Yes");
        this.defaults.setProperty("HSTATUSMNEMONIC", "U");
        this.defaults.setProperty("BATTLETABVISIBLE", "YES");
        this.defaults.setProperty("BATTLETABNAME", "Battles");
        this.defaults.setProperty("BATTLEINTOPROW", "YES");
        this.defaults.setProperty("BATTLEMNEMONIC", "B");
        this.defaults.setProperty("MAPTABVISIBLE", "YES");
        this.defaults.setProperty("MAPTABNAME", "Map");
        this.defaults.setProperty("MAPINTOPROW", "NO");
        this.defaults.setProperty("MAPMNEMONIC", "A");
        this.defaults.setProperty("PANELDIVIDER", "40");
        this.defaults.setProperty("MAINCHANNELTABNAME", "Main Channel");
        this.defaults.setProperty("MAINCHANNELMNEMONIC", "M");
        this.defaults.setProperty("HOUSEMAILVISIBLE", "YES");
        this.defaults.setProperty("HOUSEMAILTABNAME", "Faction Channel");
        this.defaults.setProperty("HOUSEMAILMNEMONIC", "H");
        this.defaults.setProperty("PRIVATEMAILVISIBLE", "YES");
        this.defaults.setProperty("PRIVATEMAILTABNAME", "Private Channel");
        this.defaults.setProperty("PRIVATEMAILMNEMONIC", "P");
        this.defaults.setProperty("PERSONALLOGVISIBLE", "YES");
        this.defaults.setProperty("PERSONALLOGTABNAME", "Personal Log");
        this.defaults.setProperty("PERSONALLOGMNEMONIC", "L");
        this.defaults.setProperty("SYSTEMLOGVISIBLE", "NO");
        this.defaults.setProperty("SYSTEMLOGTABNAME", "System Log");
        this.defaults.setProperty("SYSTEMLOGMNEMONIC", "Y");
        this.defaults.setProperty("MISCELLANEOUSVISIBLE", "YES");
        this.defaults.setProperty("MISCELLANEOUSTABNAME", "Miscellaneous");
        this.defaults.setProperty("MISCELLANEOUSMNEMONIC", "A");
        this.defaults.setProperty("AUTOJOINGAME", "NO");
        this.defaults.setProperty("F1BIND", "mystatus");
        this.defaults.setProperty("F2BIND", "");
        this.defaults.setProperty("F3BIND", "");
        this.defaults.setProperty("F4BIND", "");
        this.defaults.setProperty("F5BIND", "");
        this.defaults.setProperty("DEFAULTARMYNAME", "");
        this.defaults.setProperty("DEDAUTORESTART", "20");
        this.defaults.setProperty("CAMPAIGNSERVERNAME", "MekWars Server");
        this.defaults.setProperty("STATUSINTRAYICON", "NO");
        this.defaults.setProperty("TRAYIMAGE", "reserve_colored.gif");
        this.defaults.setProperty("DISABLEALLSOUND", "false");
        this.defaults.setProperty("SORTMODE", "NAME");
        this.defaults.setProperty("SORTORDER", "ASCENDING");
        this.defaults.setProperty("BMSORTCOLUMN", "-2");
        this.defaults.setProperty("BMSORTORDER", "true");
        this.defaults.setProperty("TABLEBROWSERSORTCOLUMN", "3");
        this.defaults.setProperty("TABLEBROWSERSORTORDER", "false");
        this.defaults.setProperty("UNITVIEWERWEIGHT", "All");
        this.defaults.setProperty("UNITVIEWERTECH", "All");
        this.defaults.setProperty("UNITVIEWERTYPE", "Mek");
        this.defaults.setProperty("UNITVIEWERSORT", "Name");
        this.defaults.setProperty("UNITVIEWERUNIT", "-1");
        this.defaults.setProperty("TABLEVIEWERFACTION", "nullfac");
        this.defaults.setProperty("TABLEVIEWERTYPE", "Mek");
        this.defaults.setProperty("TALEVIEWERWEIGHT", "Light");
        this.defaults.setProperty("PRIMARYHQSORTORDER", "name");
        this.defaults.setProperty("SECONDARYHQSORTORDER", "none");
        this.defaults.setProperty("TERTIARYHQSORTORDER", "none");
        this.defaults.setProperty("DARKERMAP", "false");
        this.defaults.setProperty("BMPREVIEWIMAGE", "false");
        this.defaults.setProperty("PLAYERCHATCOLORMODE", "playercolors");
        this.defaults.setProperty("COLOREDEMOTES", "false");
        this.defaults.setProperty("SELECTEDPLANET", "");
        this.defaults.setProperty("MAPZOOMLEVEL", "1");
        this.defaults.setProperty("MAPYOFFSET", "0");
        this.defaults.setProperty("MAPXOFFSET", "0");
        this.defaults.setProperty("SHOWENTERANDEXIT", "true");
        this.defaults.setProperty("CHALLENGESTRING", "Looking for a game at");
        this.defaults.setProperty("SYSMESSAGECOLOR", "red");
        this.defaults.setProperty("NOIMGINCHAT", "false");
        this.defaults.setProperty("SERVERPORT", "2347");
        this.defaults.setProperty("DATAPORT", "4867");
        this.defaults.setProperty("PORT", "2346");
        this.defaults.setProperty("MAXPLAYERS", "12");
        this.defaults.setProperty("MAXSAVEDGAMEDAYS", "30");
    }

    protected void createGUIDefaults() {
        this.guiDefaults = new Properties();
        this.guiDefaults.setProperty("PP.NA", "Name");
        this.guiDefaults.setProperty("PP.PR", "Profession");
        this.guiDefaults.setProperty("PP.ST", "Status:");
        this.guiDefaults.setProperty("PP.EX", "Experience:");
        this.guiDefaults.setProperty("PP.RA", "Rating:");
        this.guiDefaults.setProperty("PP.MO", "Change this Money hard code:");
        this.guiDefaults.setProperty("PP.IN", "Change this Inf Hard Code:");
        this.guiDefaults.setProperty("PP.ME", "Techs:");
        this.guiDefaults.setProperty("PP.TH", "Paid Techs:");
        this.guiDefaults.setProperty("PP.RP", "Reward Points:");
        this.guiDefaults.setProperty("UL.SMN", "Name");
        this.guiDefaults.setProperty("UL.SMH", "Faction");
        this.guiDefaults.setProperty("UL.SME", "Experience");
        this.guiDefaults.setProperty("UL.SMR", "Rating");
        this.guiDefaults.setProperty("UL.SMS", "Status");
        this.guiDefaults.setProperty("UL.SML", "Userlevel");
        this.guiDefaults.setProperty("UL.SMC", "Country");
        this.guiDefaults.setProperty("UL.SOA", "Ascending Order");
        this.guiDefaults.setProperty("UL.SOD", "Descending Order");
        this.guiDefaults.setProperty("UL.SD", "Show Dedicated Hosts");
        this.guiDefaults.setProperty("UL.HD", "Hide Dedicated Hosts");
    }

    public void checkConfig() {
        try {
            File configfile = new File(this.filename);
            FileInputStream fis = new FileInputStream(configfile);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            br.readLine();
            br.close();
            fis.close();
        }
        catch (Exception ex) {
            this.createConfig();
        }
    }

    public void loadConfig() {
        try {
            File configfile = new File(this.filename);
            FileInputStream fis = new FileInputStream(configfile);
            this.config.load(fis);
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
            JOptionPane.showMessageDialog(null, "I couldn't read the config.txt file!\n\rPlease make sure it exists and that I have the rights to read it!\n\rIt could also've been damaged.\n\rIn that case delete it so I can create a new one.\n\rLoading Defaults");
        }
    }

    public void loadServerAddress() {
        try {
            File configfile = new File("serverdata.dat");
            FileInputStream fis = new FileInputStream(configfile);
            this.config.load(fis);
            fis.close();
            configfile.delete();
            this.saveConfig();
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientOutputLog("No serverdata.dat. Skipping overload.");
        }
    }

    public void loadImages() {
        if (this.isDedicated()) {
            return;
        }
        this.images = new TreeMap();
        this.loadImage(IMAGE_PATH + this.getDiscdImageName(), "DISCD", 20, 20);
        this.loadImage(IMAGE_PATH + this.getLogoutImageName(), "LOGOUT", 20, 20);
        this.loadImage(IMAGE_PATH + this.getReserveImageName(), "RESERVE", 20, 20);
        this.loadImage(IMAGE_PATH + this.getActiveImageName(), "ACTIVE", 20, 20);
        this.loadImage(IMAGE_PATH + this.getFightImageName(), "FIGHT", 20, 20);
        this.loadImage(IMAGE_PATH + this.getLogoImageName(), "LOGO", 100, 100);
        if (!this.isParam("UNITCAMO", "")) {
            this.loadImage(CAMO_PATH + this.getImageName("UNITCAMO"), "CAMO", 84, 72);
        }
        this.loadImage(IMAGE_PATH + this.getTrayImageName(), "TRAY", 20, 20);
    }

    protected void loadImage(String imagename, String image, int width, int height) {
        if (!imagename.equals("")) {
            try {
                this.images.put(image, new ImageIcon(new ImageIcon(imagename).getImage().getScaledInstance(width, height, 1)));
            }
            catch (Exception ex) {
                MWClient.mwClientLog.clientErrLog(ex);
            }
        }
    }

    public void createConfig() {
        try {
            FileOutputStream fos = new FileOutputStream(this.filename);
            PrintStream ps = new PrintStream(fos);
            ps.println("#MekWars config file. Edit as you please.");
            ps.println("#");
            ps.println("#BASIC SETTINGS");
            ps.println("#Name, used for chat");
            ps.println("NAME: ");
            ps.println("#Password. Leave this blank if you haven't registed a nickname.");
            ps.println("NAMEPASSWORD: ");
            ps.println("#Your Color used for your name in the chat ");
            ps.println("#Color of your name in chat.");
            ps.println("#Choices: standard HTML colours, any hex colour with a Red Value under AA)");
            ps.println("COLOR: black");
            ps.println("#IP of MekWars Server you are connecting to");
            ps.println("#Servers listed on forums @ http://www.sourceforge.net/projects/mekwars");
            ps.println("SERVERIP: SEE THE MEKWARS PROJECT PAGE FOR A LIST OF KNOWN SERVERS");
            ps.println("#Port used by target MekWars Server. Default is 2347");
            ps.println("SERVERPORT: 2347");
            ps.println("#Post used for asynchronous data transfer (map data, etc.)");
            ps.println("DATAPORT: 4867");
            ps.println("#");
            ps.println("#The port to use. Default is 2346");
            ps.println("PORT: 2346");
            ps.println("#The maximum number of players you want to join your host. (If you host a game) Default: 12");
            ps.println("MAXPLAYERS: 12");
            ps.println("#A comment for your game (If you host a game)");
            ps.println("COMMENT: ");
            ps.println("#If you want a Password for your game, enter it here");
            ps.println("#GAMEPASSWORD: ");
            ps.println("#Dedicated server settings");
            ps.println("#Should this be a Dedicated Server ONLY?");
            ps.println("DEDICATED: NO");
            ps.println("#(Only if Dedicated Only) Put names of people allowed to reset him here, separated with commas");
            ps.println("DEDICATEDOWNERNAME: ");
            ps.println("#(Only if Dedicated Only) Put prefix for dedicated commands here");
            ps.println("DEDICATEDCOMMANDPREFIX: defaultprefix");
            ps.println("# Images settings");
            ps.println("DISCDIMAGE: logout_colored.gif");
            ps.println("LOGOUTIMAGE: logout_colored.gif");
            ps.println("RESERVEIMAGE: reserve_colored.gif");
            ps.println("ACTIVEIMAGE: active_colored.gif");
            ps.println("FIGHTIMAGE: fighting_colored.gif");
            ps.println("#A picture (from /data/images) to be shown as your logo in client. If you comment it out, it will download your unit logo!");
            ps.println("LOGOIMAGE: logo.jpg");
            ps.println("#Should client use color theme for color blind people?");
            ps.println("#COLORBLIND: YES");
            ps.println("#The thickness of splitters dividing client windows");
            ps.println("#SPLITTERSIZE: 7");
            ps.println("#If you want \"Campaign\" menu option to be colored, set it to YES");
            ps.println("MENUCOLOR: NO");
            ps.println("#Size of chat font (as in html font tag)");
            ps.println("#CHATFONTSIZE: +0");
            ps.println("#Color of chat font (as in html font tag)");
            ps.println("#CHATFONTCOLOR: black");
            ps.println("#If you don't want the Player Panel to be visible, set it to NO");
            ps.println("PLAYERPANEL: YES");
            ps.println("#Put player panel height in pixels (excluding logo height) here (default is 130)");
            ps.println("#PLAYERPANELHEIGHT: 130");
            ps.println("#If you don't want the Logo to be visible, set it to NO");
            ps.println("LOGO: NO");
            ps.println("#If you don't want comm tabs titles to change color on new message, set it to NO");
            ps.println("COMMTABSCOLOR: YES");
            ps.println("#If you don't want dialog to popup on when you are attacked, set it to NO");
            ps.println("#POPUPONATTACK: YES");
            ps.println("#YES to use MMNET Version .3XX style tabs. Not recommended.");
            ps.println("OLDSTYLETABS: NO");
            ps.println("#PanelDivider set between 1-100");
            ps.println("PANELDIVIDER: 40");
            ps.println("#set to NO if you do not want server messages to appear as popup.");
            ps.println("#if turned off, messages will appear in main chat.");
            ps.println("POPUPONMESSAGE: NO");
            ps.println("#number of games a ded will play before it restarts");
            ps.println("DEDAUTORESTART: 20");
            ps.println("CAMPAIGNSERVERNAME: MekWars Server");
            ps.println("TRAYIMAGE: reserve_colored.gif");
            ps.close();
            fos.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Failed to create config file. Check folder write access privledges?");
            System.exit(0);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String tfilename) {
        this.filename = tfilename;
    }

    public String getName() {
        return this.getParam("NAME");
    }

    public void setName(String name) {
        this.config.setProperty("NAME", name);
    }

    public String getPassword() {
        return this.getParam("NAMEPASSWORD");
    }

    public void setPassword(String password) {
        this.config.setProperty("NAMEPASSWORD", password);
    }

    public String getRestartMsg() {
        return this.getParam("DEDICATEDRESTARTMESSAGE");
    }

    public void setRestartMsg(String message) {
        this.config.setProperty("DEDICATEDRESTARTMESSAGE", message);
    }

    public String getOwner() {
        return this.getParam("DEDICATEDOWNERNAME");
    }

    public void setOwner(String owner) {
        this.config.setProperty("DEDICATEDOWNERNAME", owner);
    }

    public String getPrefix() {
        return this.getParam("DEDICATEDCOMMANDPREFIX");
    }

    public void setPrefix(String prefix) {
        this.config.setProperty("DEDICATEDCOMMANDPREFIX", prefix);
    }

    public boolean isDedicated() {
        return this.isParam("DEDICATED");
    }

    public String getDedicated() {
        return this.getParam("DEDICATED");
    }

    public void setDedicated(String dedicated) {
        this.config.setProperty("DEDICATED", dedicated);
    }

    public boolean isColorblind() {
        return this.isParam("COLORBLIND");
    }

    public String getColorblind() {
        return this.getParam("COLORBLIND");
    }

    public void setColorblind(String colorblind) {
        this.config.setProperty("COLORBLIND", colorblind);
    }

    public boolean isAutoConnect() {
        return this.isParam("AUTOCONNECT");
    }

    public String getAutoConnect() {
        return this.getParam("AUTOCONNECT");
    }

    public void setAutoConnect(String autoconnect) {
        this.config.setProperty("AUTOCONNECT", autoconnect);
    }

    public boolean isTimeStamp() {
        return this.isParam("TIMESTAMP");
    }

    public String getTimeStamp() {
        return this.getParam("TIMESTAMP");
    }

    public void setTimeStamp(String timestamp) {
        this.config.setProperty("TIMESTAMP", timestamp);
    }

    public boolean isFASABVRation() {
        return this.isParam("FASABVRATIO");
    }

    public int getIntServerPort() {
        int port = 0;
        try {
            port = Integer.parseInt(this.getParam("SERVERPORT"));
        }
        catch (Exception ex) {
            port = Integer.parseInt(this.defaults.getProperty("SERVERPORT", "2347"));
        }
        return port;
    }

    public String getServerPort() {
        return this.getParam("SERVERPORT");
    }

    public void setServerPort(String serverport) {
        this.config.setProperty("SERVERPORT", serverport);
    }

    public String getServerIP() {
        return this.getParam("SERVERIP");
    }

    public void setServerIP(String serverip) {
        this.config.setProperty("SERVERIP", serverip);
    }

    public String getDataPort() {
        return this.getParam("DATAPORT");
    }

    public void setdataPort(String dataport) {
        this.config.setProperty("DATAPORT", dataport);
    }

    public String getImageName(String param) {
        return this.getParam(param);
    }

    public void setImageName(String param, String imagename) {
        this.config.setProperty(param, imagename);
    }

    public String getDiscdImageName() {
        return this.getParam("DISCDIMAGE");
    }

    public void setDiscdImageName(String imagename) {
        this.config.setProperty("DISCDIMAGE", imagename);
    }

    public String getLogoutImageName() {
        return this.getParam("LOGOUTIMAGE");
    }

    public void setLogoutImageName(String imagename) {
        this.config.setProperty("LOGOUTIMAGE", imagename);
    }

    public String getReserveImageName() {
        return this.getParam("RESERVEIMAGE");
    }

    public void setReserveImageName(String imagename) {
        this.config.setProperty("RESERVEIMAGE", imagename);
    }

    public String getActiveImageName() {
        return this.getParam("ACTIVEIMAGE");
    }

    public void setActiveImageName(String imagename) {
        this.config.setProperty("ACTIVEIMAGE", imagename);
    }

    public String getFightImageName() {
        return this.getParam("FIGHTIMAGE");
    }

    public void setFightImageName(String imagename) {
        this.config.setProperty("FIGHTIMAGE", imagename);
    }

    public String getLogoImageName() {
        return this.getParam("LOGOIMAGE");
    }

    public String getTrayImageName() {
        return this.getParam("TRAYIMAGE");
    }

    public void setLogoImageName(String imagename) {
        this.config.setProperty("LOGOIMAGE", imagename);
    }

    public ImageIcon getImage(String image) {
        return (ImageIcon)this.images.get(image);
    }

    public ImageIcon getDiscdImage() {
        return (ImageIcon)this.images.get("DISCD");
    }

    public ImageIcon getLogoutImage() {
        return (ImageIcon)this.images.get("LOGOUT");
    }

    public ImageIcon getReserveImage() {
        return (ImageIcon)this.images.get("RESERVE");
    }

    public ImageIcon getActiveImage() {
        return (ImageIcon)this.images.get("ACTIVE");
    }

    public ImageIcon getFightImage() {
        return (ImageIcon)this.images.get("FIGHT");
    }

    public ImageIcon getLogoImage() {
        return (ImageIcon)this.images.get("LOGO");
    }

    public ImageIcon getTrayImage() {
        return (ImageIcon)this.images.get("TRAY");
    }

    public void setLogoImage(ImageIcon image) {
        this.images.put("LOGO", new ImageIcon(image.getImage().getScaledInstance(100, 100, 1)));
    }

    public String getParam(String param) {
        String tparam = null;
        if (param.endsWith(":")) {
            param = param.substring(0, param.lastIndexOf(":"));
        }
        if ((tparam = this.config.getProperty(param)) == null) {
            tparam = "";
        }
        return tparam;
    }

    public String getDefaultParam(String param) {
        String tparam = null;
        if (param.endsWith(":")) {
            param = param.substring(0, param.lastIndexOf(":"));
        }
        if ((tparam = this.defaults.getProperty(param)) == null) {
            tparam = "";
        }
        return tparam;
    }

    public void setParam(String param, String value) {
        this.config.setProperty(param, value);
    }

    public boolean isParam(String param) {
        String tparam = this.getParam(param);
        return tparam.equalsIgnoreCase("YES") || tparam.equalsIgnoreCase("TRUE") || tparam.equalsIgnoreCase("ON");
    }

    public int getIntParam(String param) {
        int tparam = 0;
        try {
            tparam = Integer.parseInt(this.getParam(param));
        }
        catch (Exception ex) {
            return 0;
        }
        return tparam;
    }

    public long getLongParam(String param) {
        long tparam = 0L;
        try {
            tparam = Long.parseLong(this.getParam(param));
        }
        catch (Exception ex) {
            return 0L;
        }
        return tparam;
    }

    public float getFloatParam(String param) {
        float tparam = 0.0f;
        try {
            tparam = Float.parseFloat(this.getParam(param));
        }
        catch (Exception ex) {
            return 0.0f;
        }
        return tparam;
    }

    public boolean isParam(String param, String value) {
        String tparam = null;
        tparam = this.getParam(param);
        return tparam.equalsIgnoreCase(value);
    }

    public boolean existsParam(String param) {
        String tparam = null;
        tparam = this.config.getProperty(param);
        return tparam != null;
    }

    public String getText(String text) {
        String ttext = null;
        ttext = this.guiTexts.getProperty(text);
        if (ttext == null) {
            ttext = "";
        }
        return ttext;
    }

    public void saveConfig() {
        try {
            FileOutputStream fos = new FileOutputStream("./data/mwconfig.txt");
            PrintStream ps = new PrintStream(fos);
            this.config.store(ps, "Client Config");
            fos.close();
            ps.close();
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
            MWClient.mwClientLog.clientErrLog("Failed saving config file");
        }
    }
}

