/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.MWClient;
import java.awt.Color;
import java.util.StringTokenizer;

public class CUser
implements Comparable {
    protected String Name;
    protected String Addon;
    protected int Userlevel = 0;
    protected String House;
    protected String Fluff;
    protected int Exp;
    protected float Rating;
    protected int Status;
    protected String HTMLColor;
    protected Color RGBColor;
    protected String Country;
    protected boolean LoggedIn = false;

    public CUser() {
        this.Name = "";
        this.Addon = "";
        this.House = "";
        this.Fluff = "";
        this.Exp = 0;
        this.Rating = 0.0f;
        this.Status = MWClient.STATUS_LOGGEDOUT;
        this.HTMLColor = "black";
        this.RGBColor = Color.black;
        this.Country = "";
    }

    public CUser(String data) {
        String element = null;
        StringTokenizer ST = null;
        this.Addon = "";
        this.House = "";
        this.Fluff = "";
        this.Exp = 0;
        this.Rating = 0.0f;
        this.Status = MWClient.STATUS_LOGGEDOUT;
        this.RGBColor = Color.black;
        ST = new StringTokenizer(data, "~");
        try {
            this.Name = ST.nextToken();
            this.HTMLColor = ST.nextToken();
            this.Country = ST.nextToken();
            element = ST.nextToken();
            this.Userlevel = ST.hasMoreTokens() ? Integer.parseInt(ST.nextToken()) : Integer.parseInt(element);
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Error in deserializing user");
        }
    }

    public void setName(String tname) {
        this.Name = tname;
    }

    public String getName() {
        return this.Name;
    }

    public void setAddon(String taddon) {
        this.Addon = taddon;
    }

    public String getAddon() {
        return this.Addon;
    }

    public void setCountry(String tcountry) {
        this.Country = tcountry;
    }

    public String getCountry() {
        return this.Country;
    }

    public void setColor(String tcolor) {
        this.HTMLColor = tcolor;
    }

    public String getColor() {
        return this.HTMLColor;
    }

    public void setUserlevel(int tlevel) {
        this.Userlevel = tlevel;
    }

    public int getUserlevel() {
        return this.Userlevel;
    }

    public void setFluff(String tfluff) {
        this.Fluff = tfluff;
    }

    public String getFluff() {
        return this.Fluff;
    }

    public void setHouse(String tfaction) {
        this.House = tfaction;
    }

    public String getHouse() {
        return this.House;
    }

    public void setExp(int texp) {
        this.Exp = texp;
    }

    public int getExp() {
        return this.Exp;
    }

    public void setRating(float trating) {
        this.Rating = trating;
    }

    public float getRating() {
        return this.Rating;
    }

    public void setRGBColor() {
        this.House = "needs to update their client!";
        this.RGBColor = Color.black;
    }

    public Color getRGBColor() {
        return this.RGBColor;
    }

    public void setCampaignData(String data) {
        StringTokenizer ST = new StringTokenizer(data, "#");
        try {
            int blue = 0;
            int green = 0;
            int red = 0;
            this.Exp = Integer.parseInt(ST.nextToken());
            this.Rating = Float.parseFloat(ST.nextToken());
            try {
                this.setStatus(Integer.parseInt(ST.nextToken()));
            }
            catch (Exception ex) {
                MWClient.mwClientLog.clientErrLog(ex);
            }
            if (ST.hasMoreTokens()) {
                this.Fluff = ST.nextToken();
            }
            if (this.Fluff.equals(" ") || this.Fluff.equals("0")) {
                this.Fluff = "";
            }
            if (ST.hasMoreTokens()) {
                this.Addon = ST.nextToken();
            }
            this.setRGBColor();
            if (ST.hasMoreTokens()) {
                this.House = ST.nextToken();
            }
            if (ST.hasMoreTokens()) {
                red = Integer.parseInt(ST.nextToken());
            }
            if (ST.hasMoreTokens()) {
                green = Integer.parseInt(ST.nextToken());
            }
            if (ST.hasMoreTokens()) {
                blue = Integer.parseInt(ST.nextToken());
            }
            this.RGBColor = new Color(red, green, blue);
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    public void clearCampaignData() {
        this.Addon = "";
        this.House = "";
        this.Fluff = "";
        this.Exp = 0;
        this.Rating = 0.0f;
        this.Status = MWClient.STATUS_LOGGEDOUT;
        this.RGBColor = Color.black;
    }

    public void setStatus(int status) {
        this.Status = status;
        if (this.Status == MWClient.STATUS_LOGGEDOUT) {
            this.LoggedIn = false;
            this.clearCampaignData();
        } else if (this.Status == MWClient.STATUS_LOGGEDIN || this.Status == MWClient.STATUS_ACTIVE || this.Status == MWClient.STATUS_FIGHTING) {
            this.LoggedIn = true;
        }
    }

    public int getStatus() {
        return this.Status;
    }

    public boolean isLoggedIn() {
        return this.LoggedIn;
    }

    public String getShortInfo() {
        String info = "<html><body>" + this.getName();
        if (this.Userlevel >= 100 && this.Userlevel < 200) {
            info = info + " (Moderator)";
        }
        if (this.Userlevel >= 200) {
            info = info + " (Admin)";
        }
        if (!this.Country.equals("unknown")) {
            info = info + " (" + this.getCountry() + ")";
        }
        info = info + "</body></html>";
        return info;
    }

    public String getInfo() {
        String info = "<html><body>" + this.Name;
        if (!this.Addon.equals("") && this.LoggedIn) {
            info = info + " [" + this.Addon + "]";
        }
        if (this.Userlevel >= 100 && this.Userlevel < 200) {
            info = info + " (Moderator)";
        }
        if (this.Userlevel >= 200) {
            info = info + " (Admin)";
        }
        if (!this.Country.equals("unknown")) {
            info = info + " (" + this.getCountry() + ")";
        }
        if (this.LoggedIn) {
            info = info + "<br>Exp: " + this.Exp;
            if (this.Rating >= 1.0f) {
                info = info + " Rating: " + this.Rating;
            }
            if (!this.House.equals("")) {
                info = info + "<br>Fights for " + this.House;
            }
            if (!this.Fluff.equals("")) {
                info = info + "<br>" + this.Fluff;
            }
        }
        info = info + "</body></html>";
        return info;
    }

    public int compareTo(Object o) {
        if (!(o instanceof CUser)) {
            return 0;
        }
        CUser u = (CUser)o;
        return this.getName().compareTo(u.getName());
    }
}

