/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.CConfig;
import client.CMWLogger;
import client.CUser;
import client.ClientThread;
import client.MMGame;
import client.ServerInterface;
import client.autoSaveFilter;
import client.campaign.CCampaign;
import client.campaign.CPlayer;
import client.cmd.Command;
import client.gui.Browser;
import client.gui.CCommPanel;
import client.gui.CMainFrame;
import client.gui.SplashWindow;
import client.gui.commands.IGUICommand;
import client.gui.commands.LoginGCmd;
import client.gui.commands.MailGCmd;
import client.gui.commands.PingGCmd;
import client.gui.dialog.ConfigurationDialog;
import client.gui.dialog.RewardPointsDialog;
import client.gui.dialog.SignonDialog;
import client.protocol.CConnector;
import client.protocol.DataFetchClient;
import client.protocol.IClient;
import client.protocol.TransportCodec;
import client.protocol.commands.AckSignonPCmd;
import client.protocol.commands.CommPCmd;
import client.protocol.commands.IProtCommand;
import client.protocol.commands.PingPCmd;
import client.protocol.commands.PongPCmd;
import client.purgeAutoSaves;
import com.birosoft.liquid.LiquidLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.DesertGreen;
import com.jgoodies.looks.plastic.theme.SkyBlue;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import common.AdvanceTerrain;
import common.CampaignData;
import common.Planet;
import common.PlanetEnvironment;
import common.campaign.Buildings;
import common.util.MD5;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URI;
import java.rmi.dgc.VMID;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import megamek.MegaMek;
import megamek.client.Client;
import megamek.client.ui.AWT.GameOptionsDialog;
import megamek.common.options.GameOptions;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;
import megamek.server.Server;
import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWClient
implements IClient,
ServerInterface {
    CampaignData data = null;
    DataFetchClient dataFetcher;
    Thread updateDataFetcher;
    CConfig Config;
    public static String CLIENT_VERSION = "0.1.1.0";
    boolean packFrame = false;
    CConnector Connector;
    boolean SignOff = false;
    long TimeOut = 120L;
    long LastPing = 0L;
    TimeOutThread TO;
    Collection Users;
    MMGame.List games = new MMGame.List();
    Server myServer;
    Date mytime = new Date(System.currentTimeMillis());
    Vector GameOptions = new Vector();
    Browser browser;
    boolean SoundMuted = false;
    String myUsername = "";
    String password = "";
    String myComPrefix = "Default prefix";
    String myDedOwners = "";
    int myPort = -1;
    int gameCount = 0;
    int dedRestartAt = 50;
    int savedGamesMaxDays = 30;
    PlanetEnvironment currentEnvironment;
    AdvanceTerrain aTerrain = null;
    TreeMap<String, String[]> allOps;
    Dimension MapSize;
    Dimension BoardSize;
    SplashWindow splash = null;
    String lastSetGameState = "";
    Buildings buildingTemplate = null;
    public static String CAMPAIGN_PATH = "data/campaign/";
    public static String PROTOCOL_DELIMITER = "\t";
    public static String PROTOCOL_PREFIX = "/";
    public static String COMMAND_DELIMITER = "|";
    public static String GUI_PREFIX = "/";
    public static String CAMPAIGN_PREFIX = "/";
    public static int STATUS_DISCONNECTED = 0;
    public static int STATUS_LOGGEDOUT = 1;
    public static int STATUS_LOGGEDIN = 2;
    public static int STATUS_ACTIVE = 3;
    public static int STATUS_FIGHTING = 4;
    public static int REFRESH_STATUS = 0;
    public static int REFRESH_USERLIST = 1;
    public static int REFRESH_PLAYERPANEL = 2;
    public static int REFRESH_BATTLETABLE = 4;
    public static int REFRESH_HQPANEL = 5;
    public static int REFRESH_BMPANEL = 6;
    public static int IGNORE_PUBLIC = 0;
    public static int IGNORE_HOUSE = 1;
    public static int IGNORE_PRIVATE = 2;
    CCampaign theCampaign;
    CPlayer myPlayer;
    CMainFrame MainFrame;
    int Status = STATUS_DISCONNECTED;
    int LastStatus = STATUS_DISCONNECTED;
    TreeMap<String, IGUICommand> GUICommands = new TreeMap();
    TreeMap<String, IProtCommand> ProtCommands = new TreeMap();
    TreeMap Commands = new TreeMap();
    HashMap<String, Command> commands = new HashMap();
    String LastQuery = "";
    Vector IgnorePublic = new Vector();
    Vector IgnoreHouse = new Vector();
    Vector IgnorePrivate = new Vector();
    Vector KeyWords = new Vector();
    private String cacheDir;
    public Properties serverConfigs = new Properties();
    public static final CMWLogger mwClientLog = new CMWLogger(true);
    private int playerStartingEdge = -1;

    public static void main(String[] args) {
        String filename = "./data/mwconfig.txt";
        boolean dedicated = false;
        mwClientLog.client(true);
        String logFileName = "./logs/megameklog.txt";
        if (logFileName != null) {
            try {
                PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFileName), 64));
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog(ex);
                mwClientLog.clientErrLog("Unable to redirect MegaMek output to " + logFileName);
            }
        }
        mwClientLog.clientOutputLog("Starting MekWars Client Version: " + CLIENT_VERSION);
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-dedicated") || args[i].equalsIgnoreCase("-d")) {
                    dedicated = true;
                }
                if (!args[i].equalsIgnoreCase("-configfile") && !args[i].equalsIgnoreCase("-c") || i + 1 >= args.length) continue;
                filename = args[i + 1];
            }
            CConfig config = new CConfig(filename, dedicated);
            MWClient client = new MWClient(config);
            File cache = new File("./data/mechfiles/units.cache");
            if (cache.exists()) {
                cache.delete();
            }
            client.start();
            client.forceMainFrame();
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog(ex);
            mwClientLog.clientErrLog("Couldn't create Client Object");
            System.exit(1);
        }
    }

    public MWClient(CConfig config) {
        if (!config.isDedicated()) {
            this.splash = new SplashWindow(null);
        }
        this.Config = config;
        this.Connector = new CConnector(this);
        this.Connector.setSplashWindow(this.splash);
        this.Users = Collections.synchronizedList(new Vector());
        if (!this.Config.isDedicated()) {
            block15: {
                this.setLookAndFeel(false);
                this.theCampaign = new CCampaign(this);
                this.myPlayer = this.theCampaign.getPlayer();
                GUI_PREFIX = this.Config.getParam("COMMANDPREFIX");
                this.createProtCommands();
                this.createGUICommands();
                this.splash.setStatus(this.splash.STATUS_FETCHINGDATA);
                this.dataFetcher = new DataFetchClient(Integer.parseInt(this.Config.getDataPort()));
                try {
                    BufferedReader dis = new BufferedReader(new InputStreamReader(new FileInputStream("data/servers/" + this.Config.getServerIP() + "." + this.Config.getServerPort() + "/dataLastUpdated.dat")));
                    Date lastTS = new Date(Long.parseLong(dis.readLine()));
                    this.dataFetcher.setLastTimestamp(lastTS);
                }
                catch (Throwable t) {
                    mwClientLog.clientOutputLog("could not load data fetcher, need to fetch all planet updates since last full update.");
                }
                this.dataFetcher.setData(this.Config.getServerIP(), this.getCacheDir());
                try {
                    this.dataFetcher.checkForMostRecentOpList(this);
                }
                catch (IOException e) {
                    Object[] options = new Object[]{"Exit", "Continue"};
                    int selectedValue = JOptionPane.showOptionDialog(null, "No OpList. This usually means that you were unable to connect to the server to fetch a copy. Do you wish to exit?", "Startup error!", -1, 0, null, options, options[0]);
                    if (selectedValue != 0) break block15;
                    System.exit(0);
                }
            }
            this.allOps = new TreeMap();
            this.setupAllOps();
            this.MainFrame = new CMainFrame(this);
            try {
                this.MainFrame.setIconImage(this.Config.getDiscdImage().getImage());
            }
            catch (Exception ex) {
                mwClientLog.clientOutputLog(ex);
            }
            this.MainFrame.setColorBlind(this.Config.isColorblind());
            this.splash.setStatus(this.splash.STATUS_CONSTRUCTINGGUI);
            if (this.packFrame) {
                this.MainFrame.pack();
            } else {
                this.MainFrame.validate();
            }
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.MainFrame.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.MainFrame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            this.refreshGUI(REFRESH_STATUS);
            this.refreshGUI(REFRESH_HQPANEL);
            this.refreshGUI(REFRESH_PLAYERPANEL);
            this.refreshGUI(REFRESH_BMPANEL);
            this.setSoundMuted(this.getConfig().isParam("DISABLEALLSOUND"));
            this.MainFrame.updateAttackMenu();
        } else {
            this.createProtCommands();
            this.dataFetcher = new DataFetchClient(Integer.parseInt(this.Config.getDataPort()));
            this.dataFetcher.setData(this.Config.getServerIP(), this.getCacheDir());
            try {
                this.dataFetcher.getServerConfigData(this);
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog(ex);
            }
        }
    }

    public void start() {
        if (this.splash != null) {
            this.splash.setStatus(this.splash.STATUS_CONNECTING);
        }
        String ip = null;
        int port = 0;
        if (!Boolean.valueOf(this.getConfigParam("AUTOCONNECT")).booleanValue() && !this.Config.isDedicated()) {
            this.splash.setStatus(this.splash.STATUS_INPUTWAIT);
            new SignonDialog(this, false);
            this.splash.setStatus(this.splash.STATUS_CONNECTING);
        }
        this.myUsername = this.getConfigParam("NAME");
        if (this.Config.isDedicated() && !this.myUsername.startsWith("[Dedicated]")) {
            this.Config.setName("[Dedicated] " + this.Config.getName());
            this.myUsername = this.Config.getName();
        }
        this.dedRestartAt = Integer.parseInt(this.getConfigParam("DEDAUTORESTART"));
        this.savedGamesMaxDays = Integer.parseInt(this.getConfigParam("MAXSAVEDGAMEDAYS"));
        this.myComPrefix = this.getConfigParam("DEDICATEDCOMMANDPREFIX");
        if (this.myComPrefix.length() < 1) {
            this.myComPrefix = " ";
        }
        this.myDedOwners = this.getConfigParam("DEDICATEDOWNERNAME");
        this.myPort = Integer.parseInt(this.getConfigParam("PORT"));
        if (this.Config.existsParam("IGNOREPUBLIC")) {
            this.IgnorePublic = this.splitString(this.Config.getParam("IGNOREPUBLIC"), ",");
        }
        if (this.Config.existsParam("IGNOREHOUSE")) {
            this.IgnoreHouse = this.splitString(this.Config.getParam("IGNOREHOUSE"), ",");
        }
        if (this.Config.existsParam("IGNOREPRIVATE")) {
            this.IgnorePrivate = this.splitString(this.Config.getParam("IGNOREPRIVATE"), ",");
        }
        if (this.Config.existsParam("KEYWORDS")) {
            this.KeyWords = this.splitString(this.Config.getParam("KEYWORDS"), ",");
        }
        ip = this.Config.getParam("SERVERIP");
        try {
            port = this.Config.getIntServerPort();
        }
        catch (Exception e) {
            mwClientLog.clientErrLog(e);
            System.exit(1);
        }
        if (!this.Config.isDedicated()) {
            this.browser = new Browser();
            Browser.init();
            this.connectToServer(ip, port);
        } else {
            while (this.Status == STATUS_DISCONNECTED) {
                this.connectToServer(ip, port);
                if (this.Status != STATUS_DISCONNECTED) continue;
                mwClientLog.clientOutputLog("Couldn't connect to server. Retrying in 60 seconds.");
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception exe) {
                    mwClientLog.clientErrLog(exe);
                    System.exit(2);
                }
            }
        }
        this.TimeOut = this.Config.getLongParam("TIMEOUT");
        this.LastPing = System.currentTimeMillis() / 1000L;
        this.TO = new TimeOutThread(this);
        if (this.Config.isDedicated()) {
            mwClientLog.clientOutputLog("Starting pAS");
            purgeAutoSaves pAS = new purgeAutoSaves();
            new Thread(pAS).start();
        } else {
            try {
                Thread.sleep(800L);
                this.MainFrame.setVisible(true);
                this.splash.dispose();
                this.splash = null;
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog(ex);
                mwClientLog.clientErrLog("Error in finding stuff.");
            }
        }
        this.TO.run();
    }

    private void forceMainFrame() {
        if (!this.Config.isDedicated()) {
            try {
                Thread.sleep(800L);
                this.MainFrame.setVisible(true);
                this.splash.dispose();
                this.splash = null;
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog(ex);
                mwClientLog.clientErrLog("Error in finding stuff.");
            }
        }
    }

    public synchronized void doParseDataInput(String input) {
        try {
            StringTokenizer ST = null;
            String task = null;
            mwClientLog.clientOutputLog(input);
            ST = new StringTokenizer(input, COMMAND_DELIMITER);
            task = ST.nextToken();
            if (task.equals("UR") || task.equals("UA")) {
                mwClientLog.clientOutputLog("Got outdated command: " + task + ". Contact MekWars Staff and make them remove it from the server!");
                return;
            }
            if (!this.commands.containsKey(task)) {
                try {
                    Class<?> cmdClass = Class.forName(this.getClass().getPackage().getName() + ".cmd." + task);
                    Constructor<?> c = cmdClass.getConstructor(MWClient.class);
                    Command cmd = (Command)c.newInstance(this);
                    this.commands.put(task, cmd);
                }
                catch (Exception e) {
                    mwClientLog.clientErrLog(e);
                }
            }
            if (this.commands.containsKey(task)) {
                this.commands.get(task).execute(input);
            }
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog(ex);
        }
    }

    public synchronized void parseDedDataInput(String data) {
        if (data.startsWith("US") || data.startsWith("NU") || data.startsWith("UG")) {
            this.doParseDataInput(data);
            return;
        }
        if (!data.startsWith("PM|")) {
            return;
        }
        data = data.substring(3);
        StringTokenizer st = new StringTokenizer(data, "|");
        StringTokenizer own = new StringTokenizer(this.myDedOwners, "$");
        String name = st.nextToken().trim();
        if (!st.hasMoreTokens()) {
            return;
        }
        if (name.equals(this.myUsername)) {
            return;
        }
        String command = st.nextToken().trim();
        if (!command.equals("prefix") && !command.startsWith(this.myComPrefix)) {
            return;
        }
        if (command.equals(this.myComPrefix + "checkrestartcount")) {
            this.checkForRestart();
            return;
        }
        while (this.myDedOwners.equals("") || own.hasMoreTokens()) {
            String owner = own.hasMoreTokens() ? own.nextToken() : "";
            if (!this.myDedOwners.equals("") && !name.equals(owner) && this.getUser(name).getUserlevel() < 100) continue;
            if (command.equals("prefix")) {
                mwClientLog.clientOutputLog("Prefix command received from " + name);
                this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", My command prefix: \"" + this.myComPrefix + "\"");
                return;
            }
            if (this.myComPrefix.equals("") && !command.startsWith(this.getUsername())) {
                return;
            }
            if (command.startsWith(this.myComPrefix)) {
                String filename;
                File[] fileList;
                String list;
                File folder;
                File log;
                if ((command = command.substring(this.myComPrefix.length())).equals("restart")) {
                    mwClientLog.clientOutputLog("Restart command received from " + name);
                    this.stopHost();
                    File log2 = new File("./logs/megameklog.txt");
                    if (log2.exists()) {
                        File folder2 = new File("./logs/backup");
                        if (!folder2.exists()) {
                            folder2.mkdir();
                        }
                        String newFile = "./logs/backup/megameklog.txt." + System.currentTimeMillis();
                        try {
                            int c;
                            FileInputStream in = new FileInputStream(log2.getPath());
                            FileOutputStream out = new FileOutputStream(newFile);
                            while ((c = in.read()) != -1) {
                                out.write(c);
                            }
                            in.close();
                            out.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception ex) {
                        mwClientLog.clientErrLog(ex);
                    }
                    this.startHost(true, false, false);
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the restart command on " + this.myUsername);
                    return;
                }
                if (command.equals("reset")) {
                    mwClientLog.clientOutputLog("Reset command received from " + name);
                    if (this.myServer != null) {
                        this.resetGame();
                    }
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the reset command on " + this.myUsername);
                    return;
                }
                if (command.equals("die")) {
                    mwClientLog.clientOutputLog("Die command received from " + name);
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the die command on " + this.myUsername);
                    log = new File("./logs/megameklog.txt");
                    if (log.exists()) {
                        folder = new File("./logs/backup");
                        if (!folder.exists()) {
                            folder.mkdir();
                        }
                        log.renameTo(new File("./logs/backup/megameklog.txt." + System.currentTimeMillis()));
                    }
                    this.goodbye();
                    System.exit(0);
                }
                if (command.equals("start")) {
                    mwClientLog.clientOutputLog("Start command received from " + name);
                    if (this.myServer == null) {
                        this.startHost(true, false, false);
                    }
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the start command on " + this.myUsername);
                    return;
                }
                if (command.equals("stop")) {
                    mwClientLog.clientOutputLog("Stop command received from " + name);
                    if (this.myServer != null) {
                        this.stopHost();
                    }
                    if ((log = new File("./logs/megameklog.txt")).exists()) {
                        folder = new File("./logs/backup");
                        if (!folder.exists()) {
                            folder.mkdir();
                        }
                        log.renameTo(new File("./logs/backup/megameklog.txt." + System.currentTimeMillis()));
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception ex) {
                        mwClientLog.clientErrLog(ex);
                    }
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the stop command on " + this.myUsername);
                    return;
                }
                if (command.equals("owners")) {
                    mwClientLog.clientOutputLog("Owners command received from " + name);
                    this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", My owners: " + this.myDedOwners.replace('$', ' '));
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the owners command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("owner ")) {
                    mwClientLog.clientOutputLog("Owner command received from " + name);
                    if (!this.myDedOwners.equals("")) {
                        this.myDedOwners = this.myDedOwners + "$";
                    }
                    this.myDedOwners = this.myDedOwners + command.substring("owner ".length()).trim();
                    this.getConfig().setParam("DEDICATEDOWNERNAME", this.myDedOwners);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the owner " + this.myDedOwners + " command on " + this.myUsername);
                    return;
                }
                if (command.equals("clearowners")) {
                    mwClientLog.clientOutputLog("Clearowners command received from " + name);
                    this.myDedOwners = "";
                    this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", My owners: " + this.myDedOwners);
                    this.getConfig().setParam("DEDICATEDOWNERNAME", this.myDedOwners);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the clear owners command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("prefix ")) {
                    mwClientLog.clientOutputLog("Prefix command received from " + name);
                    this.myComPrefix = command.substring("prefix ".length()).trim();
                    this.getConfig().setParam("DEDICATEDCOMMANDPREFIX", this.myComPrefix);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " set the prefix to " + this.myComPrefix + " on " + this.myUsername);
                    return;
                }
                if (command.equals("port")) {
                    mwClientLog.clientOutputLog("Port command received from " + name);
                    this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", My port: " + this.myPort);
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the port command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("port ")) {
                    int port;
                    mwClientLog.clientOutputLog("Port command received from " + name);
                    try {
                        port = Integer.parseInt(command.substring("port ".length()).trim());
                    }
                    catch (Exception ex) {
                        mwClientLog.clientOutputLog("Command error: " + command + ": wrong port number.");
                        return;
                    }
                    if (port > 0 && port < 65536) {
                        this.myPort = port;
                    } else {
                        mwClientLog.clientOutputLog("Command error: " + command + ": wrong port number.");
                    }
                    String portString = Integer.toString(this.myPort);
                    this.getConfig().setParam("PORT", portString);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " changed the port for " + this.myUsername + " to " + this.myPort);
                    return;
                }
                if (command.equals("savegamepurge")) {
                    mwClientLog.clientOutputLog("Save game purge command received from " + name);
                    this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", I purge saved games that are " + this.savedGamesMaxDays + " days old");
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the save game purge command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("savegamepurge ")) {
                    int mySavedGamesMaxDays = 7;
                    mwClientLog.clientOutputLog("Save game purge command received from " + name);
                    try {
                        mySavedGamesMaxDays = Integer.parseInt(command.substring("savegamepurge ".length()).trim());
                    }
                    catch (Exception ex) {
                        mwClientLog.clientOutputLog("Command error: " + command + ": invalid number.");
                        return;
                    }
                    String purgeString = Integer.toString(mySavedGamesMaxDays);
                    this.getConfig().setParam("MAXSAVEDGAMEDAYS", purgeString);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.savedGamesMaxDays = mySavedGamesMaxDays;
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " changed the save game purge for " + this.myUsername + " to " + mySavedGamesMaxDays);
                    return;
                }
                if (command.equals("displaysavedgames")) {
                    mwClientLog.clientOutputLog("display saved games command received from " + name);
                    list = "<br><b>Saved files on " + this.myUsername + "</b><br>";
                    String dateTimeFormat = "MM/dd/yyyy HH:mm:ss";
                    SimpleDateFormat sDF = new SimpleDateFormat(dateTimeFormat);
                    try {
                        File tempFile = new File("./savegames/");
                        fileList = tempFile.listFiles();
                        for (int i = 0; i < fileList.length; ++i) {
                            File dateFile = fileList[i];
                            Date date = new Date(dateFile.lastModified());
                            String dateTime = sDF.format(date);
                            list = list + "<a href=\"MEKMAIL" + this.myUsername + "*" + this.myComPrefix + "loadgamewithfullpath " + fileList[i] + "\">Load " + fileList[i] + "</a> " + dateTime + "<br>";
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", " + list);
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the display saved games command on " + this.myUsername);
                    return;
                }
                if (command.equals("displaybackuplogs")) {
                    mwClientLog.clientOutputLog("display saved games command received from " + name);
                    list = "<br><b>Backup files on " + this.myUsername + "</b><br>";
                    String dateTimeFormat = "MM/dd/yyyy HH:mm:ss";
                    SimpleDateFormat sDF = new SimpleDateFormat(dateTimeFormat);
                    try {
                        File tempFile = new File("./logs/backup");
                        fileList = tempFile.listFiles();
                        for (int i = 0; i < fileList.length; ++i) {
                            File dateFile = fileList[i];
                            Date date = new Date(dateFile.lastModified());
                            String dateTime = sDF.format(date);
                            list = list + "<a href=\"MEKMAIL" + this.myUsername + "*" + this.myComPrefix + "displaymegameklog " + fileList[i] + "\">Display " + fileList[i] + "</a> " + dateTime + "<br>";
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", " + list);
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the display backup logs command on " + this.myUsername);
                    return;
                }
                if (command.equals("displaymegameklog")) {
                    mwClientLog.clientOutputLog("display megameklog command received from " + name);
                    try {
                        File logFile = new File("./logs/megameklog.txt");
                        FileInputStream fis = new FileInputStream(logFile);
                        BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                        this.sendChat(PROTOCOL_PREFIX + "c sendtomisc#" + name + "#MegaMek Log from " + this.myUsername);
                        while (dis.ready()) {
                            this.sendChat(PROTOCOL_PREFIX + "c sendtomisc#" + name + "#" + dis.readLine());
                        }
                        fis.close();
                        dis.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the display saved games command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("displaymegameklog ")) {
                    mwClientLog.clientOutputLog("display backup log command received from " + name);
                    String fileName = command.substring("displaymegameklog ".length()).trim();
                    try {
                        File logFile = new File(fileName);
                        FileInputStream fis = new FileInputStream(logFile);
                        BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                        this.sendChat(PROTOCOL_PREFIX + "c sendtomisc#" + name + "#MegaMek Log from " + this.myUsername);
                        while (dis.ready()) {
                            this.sendChat(PROTOCOL_PREFIX + "c sendtomisc#" + name + "#" + dis.readLine());
                        }
                        fis.close();
                        dis.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the display saved games command on " + this.myUsername);
                    return;
                }
                if (command.equals("ping")) {
                    mwClientLog.clientOutputLog("Ping command received from " + name);
                    this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", I'm active.");
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the ping command on " + this.myUsername);
                    return;
                }
                if (command.equals("loadgame") || command.startsWith("loadgame ")) {
                    mwClientLog.clientOutputLog("Loadgame command received from " + name);
                    filename = "";
                    if (command.startsWith("loadgame ")) {
                        filename = command.substring("loadgame ".length()).trim();
                    }
                    if (command.equals("loadgame") || filename.equals("")) {
                        filename = "autosave.sav";
                    }
                    if (this.myServer != null) {
                        if (!this.loadGame(filename)) {
                            this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", Unable to load saved game.");
                        } else {
                            this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", Saved game loaded.");
                        }
                    }
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " loaded game " + filename + " on " + this.myUsername);
                    return;
                }
                if (command.startsWith("loadgamewithfullpath ")) {
                    mwClientLog.clientOutputLog("Loadgame command received from " + name);
                    filename = "";
                    if (command.startsWith("loadgamewithfullpath ")) {
                        filename = command.substring("loaloadgamewithfullpathdgame ".length()).trim();
                    }
                    if (command.equals("loadgamewithfullpath") || filename.equals("")) {
                        filename = "autosave.sav";
                    }
                    if (this.myServer != null) {
                        if (!this.loadGameWithFullPath(filename)) {
                            this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", Unable to load saved game.");
                        } else {
                            this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", Saved game loaded.");
                        }
                    }
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " loaded game " + filename + " on " + this.myUsername);
                    return;
                }
                if (command.equals("loadautosave")) {
                    mwClientLog.clientOutputLog("Loadgame command received from " + name);
                    filename = "autosave.sav";
                    if (this.myServer != null) {
                        if (Boolean.valueOf(this.getserverConfigs("MMTimeStampLogFile")).booleanValue()) {
                            filename = this.getParanoidAutoSave();
                        }
                        if (!this.loadGame(filename)) {
                            this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", Unable to load saved game.");
                        } else {
                            this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", " + filename + " loaded.");
                        }
                    }
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " loaded " + filename + " game on " + this.myUsername);
                    return;
                }
                if (command.startsWith("name ")) {
                    mwClientLog.clientOutputLog("Prefix command received from " + name);
                    String myComName = command.substring("name ".length()).trim();
                    this.getConfig().setParam("NAME", myComName);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the set name command to change the name to " + myComName + " command on " + this.myUsername);
                    this.Config.setName("[Dedicated] " + myComName);
                    this.myUsername = this.Config.getName();
                    return;
                }
                if (command.startsWith("comment ")) {
                    mwClientLog.clientOutputLog("Prefix command received from " + name);
                    String myComComment = command.substring("comment ".length()).trim();
                    this.getConfig().setParam("COMMENT", myComComment);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " has set the comment to " + myComComment + " on " + this.myUsername);
                    return;
                }
                if (command.startsWith("players ")) {
                    mwClientLog.clientOutputLog("Prefix command received from " + name);
                    try {
                        String numPlayers = command.substring("players ".length()).trim();
                        this.getConfig().setParam("MAXPLAYERS", numPlayers);
                        this.getConfig().saveConfig();
                        this.setConfig();
                        this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " has set the max number of players to " + numPlayers + " on " + this.myUsername);
                        return;
                    }
                    catch (Exception ex) {
                        mwClientLog.clientErrLog(ex);
                        mwClientLog.clientErrLog("Unable to convert number of players to int");
                        return;
                    }
                }
                if (command.equals("restartcount")) {
                    mwClientLog.clientOutputLog("Restartcount command received from " + name);
                    this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", My restart count is set to " + this.dedRestartAt + " my current game count is " + this.gameCount);
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " used the restartcount command on " + this.myUsername);
                    return;
                }
                if (command.startsWith("restartcount ")) {
                    mwClientLog.clientOutputLog("restartcount change command received from " + name);
                    try {
                        this.dedRestartAt = Integer.parseInt(command.substring("restartcount ".length()).trim());
                    }
                    catch (Exception ex) {
                        mwClientLog.clientOutputLog("Command error: " + command + ": bad counter.");
                        return;
                    }
                    String restartString = Integer.toString(this.dedRestartAt);
                    this.getConfig().setParam("DEDAUTORESTART", restartString);
                    this.getConfig().saveConfig();
                    this.setConfig();
                    this.sendChat(PROTOCOL_PREFIX + "c mm# " + name + " changed the restart count for " + this.myUsername + " to " + this.dedRestartAt);
                    return;
                }
                mwClientLog.clientOutputLog("Command error: " + command + ": unknown command.");
                return;
            }
            return;
        }
        this.sendChat(PROTOCOL_PREFIX + "mail " + name + ", Your not an owner so bugger off!");
        mwClientLog.clientOutputLog("Command error: " + command + ": access denied for " + name + ".");
    }

    public void processGUIInput(String input) {
        String s = null;
        if (input.startsWith(GUI_PREFIX)) {
            IGUICommand command;
            StringTokenizer ST = new StringTokenizer(input = input.substring(GUI_PREFIX.length()), " #");
            s = ST.nextToken();
            if (s.equalsIgnoreCase("c")) {
                s = "c " + ST.nextToken().toLowerCase();
            }
            if ((command = this.getGUICommand(s)) != null && command.check(s)) {
                if (!command.execute(input)) {
                    mwClientLog.clientOutputLog("COMMAND ERROR: wrong command executed.");
                }
                return;
            }
            input = CAMPAIGN_PREFIX + input;
            this.sendChat(input);
            s = "Sent command: \"" + input.substring(CAMPAIGN_PREFIX.length()) + '\"';
            this.addToChat(s, CCommPanel.CHANNEL_SLOG);
        } else {
            this.sendChat(input);
            String color = this.getUser(this.myUsername).getColor();
            String addon = this.getUser(this.myUsername).getAddon();
            addon = addon.equals("") ? "" : " [" + addon + "]";
            s = "<font color=\"" + color + "\"><b>" + this.myUsername + addon + "</b></font><b>:</b> " + input;
            if (this.Config.isTimeStamp()) {
                s = this.getShortTime() + s;
            }
            this.addToChat(s, CCommPanel.CHANNEL_PLOG);
        }
    }

    protected void createGUICommands() {
        this.addGUICommand(new PingGCmd(this));
        this.addGUICommand(new MailGCmd(this));
        this.addGUICommand(new LoginGCmd(this));
    }

    protected void addGUICommand(IGUICommand command) {
        this.GUICommands.put(command.getName(), command);
        if (command.isAlias()) {
            this.GUICommands.put(command.getAlias(), command);
        }
    }

    IGUICommand getGUICommand(String command) {
        return this.GUICommands.get(command);
    }

    protected void createProtCommands() {
        this.addProtCommand(new CommPCmd(this));
        this.addProtCommand(new PingPCmd(this));
        this.addProtCommand(new PongPCmd(this));
        this.addProtCommand(new AckSignonPCmd(this));
    }

    protected void addProtCommand(IProtCommand command) {
        this.ProtCommands.put(command.getName(), command);
    }

    IProtCommand getProtCommand(String command) {
        return this.ProtCommands.get(command);
    }

    public CCampaign getCampaign() {
        return this.theCampaign;
    }

    public CPlayer getPlayer() {
        return this.myPlayer;
    }

    public String getLastQuery() {
        return this.LastQuery;
    }

    public void setLastQuery(String name) {
        this.LastQuery = name;
    }

    public int getMyStatus() {
        return this.Status;
    }

    public void setLastPing(long lastping) {
        this.LastPing = lastping;
    }

    public Vector getIgnorePublic() {
        return this.IgnorePublic;
    }

    public Vector getIgnoreHouse() {
        return this.IgnoreHouse;
    }

    public Vector getIgnorePrivate() {
        return this.IgnorePrivate;
    }

    public Vector getIgnored(int type) {
        if (type == IGNORE_PUBLIC) {
            return this.IgnorePublic;
        }
        if (type == IGNORE_HOUSE) {
            return this.IgnoreHouse;
        }
        if (type == IGNORE_PRIVATE) {
            return this.IgnorePrivate;
        }
        return new Vector();
    }

    public boolean isIgnored(String name, int type) {
        for (String next : this.getIgnored(type)) {
            if (!name.trim().equalsIgnoreCase(next.trim())) continue;
            return true;
        }
        return false;
    }

    public Vector getKeyWords() {
        return this.KeyWords;
    }

    public boolean hasKeyWords(String input) {
        Iterator i = this.KeyWords.iterator();
        while (i.hasNext()) {
            if (input.toLowerCase().indexOf(((String)i.next()).toLowerCase()) <= -1) continue;
            return true;
        }
        return false;
    }

    public String getStatus() {
        if (this.Status == STATUS_DISCONNECTED) {
            return "Not connected";
        }
        if (this.Status == STATUS_LOGGEDOUT) {
            return "Logged out";
        }
        if (this.Status == STATUS_LOGGEDIN) {
            return "Reserve duty";
        }
        if (this.Status == STATUS_ACTIVE) {
            return "Active duty";
        }
        if (this.Status == STATUS_FIGHTING) {
            return "Fighting";
        }
        return "";
    }

    public void setPlayerStartingEdge(int edge) {
        this.playerStartingEdge = edge;
    }

    public int getPlayerStartingEdge() {
        return this.playerStartingEdge;
    }

    public boolean isLoggedIn() {
        if (this.Status == STATUS_LOGGEDIN || this.Status == STATUS_ACTIVE || this.Status == STATUS_FIGHTING) {
            return true;
        }
        if (this.Status == STATUS_DISCONNECTED || this.Status == STATUS_LOGGEDOUT) {
            return false;
        }
        return false;
    }

    public String getShortTime() {
        this.mytime = new Date();
        StringTokenizer s = new StringTokenizer(this.mytime.toString());
        s.nextElement();
        s.nextElement();
        s.nextElement();
        String t = (String)s.nextElement();
        s = new StringTokenizer(t, ":");
        String result = "[" + s.nextElement() + ":" + s.nextElement() + "] ";
        return result;
    }

    public void addToChat(String s) {
        this.addToChat(s, CCommPanel.CHANNEL_MAIN);
    }

    public void addToChat(String s, int channel) {
        s = "<font size=\"" + this.Config.getParam("CHATFONTSIZE") + "\">" + s + "</font>";
        try {
            SwingUtilities.invokeLater(new CAddToChat(s, channel));
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog(ex);
        }
    }

    public void sendChat(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreElements()) {
            String str = (String)st.nextElement();
            if (str.trim().equals("")) continue;
            this.serverSend("CH|" + str);
        }
    }

    public String doEscape(String str) {
        if (str.indexOf("<a href=\"MEKINFO") != -1) {
            return str;
        }
        str = this.doEscapeString(str, 38, "&amp;");
        str = this.doEscapeString(str, 60, "&lt;");
        str = this.doEscapeString(str, 62, "&gt;");
        return str;
    }

    public String doEscapeString(String t, int character, String replace) {
        int pos = t.indexOf(character);
        if (pos != -1) {
            String res = "";
            if (pos > 0) {
                res = res + t.substring(0, pos);
            }
            res = res + replace;
            if (pos < t.length()) {
                res = res + this.doEscapeString(t.substring(pos + 1), character, replace);
            }
            return res;
        }
        return t;
    }

    protected Vector splitString(String string, String splitter) {
        Vector<String> vector = new Vector<String>();
        String[] splitted = string.split(splitter);
        for (int i = 0; i < splitted.length; ++i) {
            vector.add(splitted[i].trim());
        }
        Iterator i = vector.iterator();
        while (i.hasNext()) {
            String currString = (String)i.next();
            if (!currString.equals("")) continue;
            i.remove();
        }
        return vector;
    }

    public MMGame.List getGameList() {
        return this.games;
    }

    public synchronized CUser getUser(String name) {
        for (CUser user : this.Users) {
            if (!user.getName().equalsIgnoreCase(name)) continue;
            return user;
        }
        return new CUser();
    }

    public boolean hasUser(String name) {
        for (CUser user : this.Users) {
            if (!user.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized String getPartialUser(String u) {
        StringTokenizer s;
        int numfound = 0;
        Iterator i = this.Users.iterator();
        String result = "";
        while (i.hasNext()) {
            CUser usr = (CUser)i.next();
            if (!usr.getName().toLowerCase().startsWith(u.toLowerCase())) continue;
            ++numfound;
            result = usr.getName();
        }
        if (numfound == 1) {
            return result;
        }
        if (numfound == 0 && (s = new StringTokenizer(u, " ")).hasMoreElements()) {
            String tmp = s.nextToken();
            if (s.hasMoreElements()) {
                return tmp + " " + this.getPartialUser(u.substring(tmp.length() + 1));
            }
        }
        return u;
    }

    public synchronized void clearUserCampaignData() {
        for (CUser user : this.Users) {
            user.clearCampaignData();
        }
    }

    public void setupAllOps() {
        try {
            File f = new File(this.cacheDir + "/OpList.txt");
            if (!f.exists()) {
                mwClientLog.clientErrLog("Error: OpList.txt does not exist.");
                return;
            }
            FileInputStream in = new FileInputStream(this.cacheDir + "/OpList.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String currLine = br.readLine();
            while (currLine != null) {
                if (currLine.trim().length() == 0) {
                    currLine = br.readLine();
                    continue;
                }
                StringTokenizer st = new StringTokenizer(currLine, "*");
                String name = st.nextToken();
                String range = st.nextToken();
                String color = st.nextToken();
                String hasLong = st.nextToken();
                String[] props = new String[]{range, color, hasLong};
                this.allOps.put(name, props);
                currLine = br.readLine();
            }
            br.close();
            in.close();
        }
        catch (Exception e) {
            mwClientLog.clientErrLog("Error in setupAllOps()");
            mwClientLog.clientErrLog(e);
        }
    }

    public TreeMap<String, String[]> getAllOps() {
        return this.allOps;
    }

    public void setLookAndFeel(boolean isRedraw) {
        Object LAF = new KunststoffLookAndFeel();
        if (this.Config.isParam("LOOKANDFEEL", "metal")) {
            LAF = new MetalLookAndFeel();
        } else if (this.Config.isParam("LOOKANDFEEL", "motif")) {
            LAF = new MotifLookAndFeel();
        } else if (this.Config.isParam("LOOKANDFEEL", "liquid")) {
            LAF = new LiquidLookAndFeel();
        } else if (this.Config.isParam("LOOKANDFEEL", "metouia")) {
            LAF = new MetouiaLookAndFeel();
        } else if (this.Config.isParam("LOOKANDFEEL", "plastic")) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)new DesertGreen());
            LAF = new Plastic3DLookAndFeel();
        } else if (this.Config.isParam("LOOKANDFEEL", "plasticxp")) {
            LAF = new PlasticXPLookAndFeel();
        } else if (this.Config.isParam("LOOKANDFEEL", "plastic3d")) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)new SkyBlue());
            LAF = new Plastic3DLookAndFeel();
        } else if (this.Config.isParam("LOOKANDFEEL", "jwindows")) {
            LAF = new WindowsLookAndFeel();
        }
        try {
            if (isRedraw) {
                this.MainFrame.setVisible(false);
            }
            if (this.Config.getParam("LOOKANDFEEL").equalsIgnoreCase("system")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel((LookAndFeel)LAF);
            }
            if (isRedraw) {
                SwingUtilities.updateComponentTreeUI(this.MainFrame);
                this.MainFrame.setExtendedState(6);
                this.MainFrame.setVisible(true);
            }
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog(ex);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                mwClientLog.clientErrLog(e);
            }
        }
    }

    public void refreshGUI(int mode) {
        try {
            SwingUtilities.invokeLater(new CRefreshGUI(mode));
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog(ex);
        }
    }

    public void showInfoWindow(String Text) {
        if (!this.Config.isDedicated()) {
            final JDialog dialog = new JDialog((Frame)this.MainFrame, "Message");
            JLabel label = new JLabel("<html>" + Text + "</html>");
            label.setHorizontalAlignment(0);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.ipadx = 30;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            contentPane.add((Component)label, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(1));
            JButton okButton = new JButton("OK");
            panel.add(okButton);
            contentPane.add((Component)panel, gridBagConstraints);
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            Dimension d = dialog.getPreferredSize();
            d.setSize(d.getWidth() + 20.0, d.getHeight() + 40.0);
            dialog.setSize(d);
            dialog.setLocationRelativeTo(this.MainFrame);
            dialog.setVisible(true);
        } else {
            mwClientLog.clientErrLog("-----------");
            mwClientLog.clientErrLog(Text);
            mwClientLog.clientErrLog("-----------");
        }
    }

    public void doPlaySound(String filename) {
        try {
            CPlaySound player = new CPlaySound(filename);
            new Thread(player).run();
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog(ex);
        }
    }

    public void setSoundMuted(boolean b) {
        this.SoundMuted = b;
        this.MainFrame.setSoundMuted(b);
        if (b != this.getConfig().isParam("DISABLEALLSOUND")) {
            if (!b) {
                this.getConfig().setParam("DISABLEALLSOUND", "false");
            } else {
                this.getConfig().setParam("DISABLEALLSOUND", "true");
            }
            this.getConfig().saveConfig();
        }
    }

    public CMainFrame getMainFrame() {
        return this.MainFrame;
    }

    public synchronized Collection getUsers() {
        return this.Users;
    }

    public static String getProtocolVersion() {
        return "4";
    }

    public void setUsername(String s) {
        this.myUsername = s;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public String getUsername() {
        return this.myUsername;
    }

    public CConfig getConfig() {
        return this.Config;
    }

    public void setConfig() {
        String filename = "./data/mwconfig.txt";
        this.Config = new CConfig(filename, false);
    }

    public String getConfigParam(String p) {
        String tparam = "";
        if (p.endsWith(":")) {
            p = p.substring(0, p.lastIndexOf(":"));
        }
        if (p.equals("NAME") && !this.myUsername.equals("")) {
            return this.myUsername;
        }
        if (p.equals("NAMEPASSWORD") && !this.password.equals("")) {
            return this.password;
        }
        tparam = this.Config.getParam(p);
        if (tparam == null) {
            tparam = "";
        }
        if (tparam.equals("") && p.equals("NAME")) {
            if (!this.Config.isDedicated()) {
                this.splash.setStatus(this.splash.STATUS_INPUTWAIT);
                new SignonDialog(this, false);
                this.dataFetcher.setData(this.Config.getServerIP(), this.getCacheDir());
                this.reloadData();
                this.splash.setStatus(this.splash.STATUS_CONNECTING);
                return this.myUsername;
            }
            mwClientLog.clientOutputLog("Error: no dedicated name set.");
            System.exit(1);
        }
        return tparam;
    }

    @Override
    public void systemMessage(String message) {
        if (!this.Config.isDedicated()) {
            message = "<font color=\"maroon\">" + message + "</font>";
            this.addToChat(message, CCommPanel.CHANNEL_SLOG);
            if (this.Config.isParam("MAINCHANNELSM")) {
                this.addToChat(message);
            }
        }
    }

    @Override
    public void errorMessage(String message) {
        if (!this.Config.isDedicated()) {
            JOptionPane.showMessageDialog(this.MainFrame, message);
        } else {
            mwClientLog.clientErrLog("Error: " + message);
        }
    }

    @Override
    public void processIncoming(String incoming) {
        IProtCommand pcommand = null;
        if (incoming.startsWith(PROTOCOL_PREFIX)) {
            StringTokenizer ST = new StringTokenizer(incoming = incoming.substring(PROTOCOL_PREFIX.length()), PROTOCOL_DELIMITER);
            String s = ST.nextToken();
            pcommand = this.getProtCommand(s);
            if (pcommand != null && pcommand.check(s)) {
                if (!pcommand.execute(incoming)) {
                    mwClientLog.clientOutputLog("COMMAND ERROR: wrong protocol command executed or execution failed.");
                    mwClientLog.clientOutputLog("COMMAND RECEIVED: " + incoming);
                }
                return;
            }
            if (pcommand == null) {
                mwClientLog.clientOutputLog("COMMAND ERROR: unknown protocol command from server.");
                mwClientLog.clientOutputLog("COMMAND RECEIVED: " + incoming);
                return;
            }
        } else {
            mwClientLog.clientOutputLog("COMMAND ERROR: received protocol command without protocol prefix.");
            mwClientLog.clientOutputLog("COMMAND RECEIVED: " + incoming);
            return;
        }
    }

    @Override
    public void connectionLost() {
        this.Status = STATUS_DISCONNECTED;
        if (this.SignOff) {
            return;
        }
        this.errorMessage("Connection lost.");
        if (this.Config.isDedicated()) {
            this.stopHost();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog(ex);
            }
            while (this.Status == STATUS_DISCONNECTED) {
                this.connectToServer(this.Config.getParam("SERVERIP"), this.Config.getIntServerPort());
                if (this.Status != STATUS_DISCONNECTED) continue;
                mwClientLog.clientOutputLog("Couldn't connect to server. Retrying in 10 seconds.");
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exe) {
                    mwClientLog.clientErrLog(exe);
                }
            }
        } else {
            this.Users.clear();
            this.refreshGUI(REFRESH_STATUS);
        }
    }

    @Override
    public void connectionEstablished() {
        this.LastPing = System.currentTimeMillis() / 1000L;
        this.systemMessage("Connected, signing on...");
        String VersionSubID = new VMID().toString();
        StringTokenizer ST = new StringTokenizer(VersionSubID, ":");
        this.Connector.send(PROTOCOL_PREFIX + "signon\t" + this.getConfigParam("NAME") + "\t" + this.getConfigParam("NAMEPASSWORD") + "\t" + MWClient.getProtocolVersion() + "\t" + this.Config.getParam("COLOR") + "\t" + CLIENT_VERSION + "\t" + ST.nextToken());
        this.Status = STATUS_LOGGEDOUT;
        if (!this.Config.isDedicated()) {
            this.refreshGUI(REFRESH_STATUS);
        }
    }

    public void clientConfiguration() {
        new ConfigurationDialog(this);
    }

    public void RewardPoints() {
        new RewardPointsDialog(this);
    }

    public void connectionSwitch() {
        String OldName = this.myUsername;
        new SignonDialog(this, true);
        if (OldName == this.myUsername) {
            return;
        }
        this.sendChat(CAMPAIGN_PREFIX + "c logout");
        this.LastPing = System.currentTimeMillis() / 1000L;
        this.Connector.closeConnection();
        this.Connector.connect();
    }

    public void connectToServer() {
        this.connectToServer(this.Config.getServerIP(), this.Config.getIntServerPort());
    }

    public void connectToServer(String ip, int port) {
        if (this.myUsername == null || this.myUsername.equals("")) {
            this.errorMessage("Username not set.");
            return;
        }
        this.Connector.connect(ip, port);
    }

    public void goodbye() {
        this.SignOff = true;
        if (this.Status != STATUS_DISCONNECTED) {
            this.serverSend("GB");
            this.Connector.send(PROTOCOL_PREFIX + "signoff");
            this.Connector.closeConnection();
        }
    }

    public CConnector getConnector() {
        return this.Connector;
    }

    public void serverSend(String s) {
        try {
            this.Connector.send(PROTOCOL_PREFIX + "comm" + "\t" + TransportCodec.encode(s));
        }
        catch (Exception e) {
            mwClientLog.clientErrLog(e);
        }
    }

    public static final String escapeHTML(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block4;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void startHost(boolean dedicated, boolean deploy, boolean loadSavegame) {
        String MMVersion;
        String ip = "127.0.0.1";
        if (!this.getConfigParam("IP:").equals("")) {
            try {
                ip = this.getConfigParam("IP:");
                InetAddress IA = InetAddress.getByName(ip);
                ip = IA.getHostAddress();
            }
            catch (Exception ex) {
                this.showInfoWindow("Couldn't set your IP, please check the spelling of the IP parameter in mwconfig.txt or comment it out to use automatic detection.");
                return;
            }
        }
        if (!(MMVersion = this.getserverConfigs("AllowedMegaMekVersion")).equals("-1") && !MMVersion.equalsIgnoreCase(MegaMek.VERSION)) {
            if (this.getConfig().isDedicated()) {
                mwClientLog.clientErrLog("You are using an invalid version of MegaMek please use version " + MMVersion);
                System.exit(0);
            }
            this.showInfoWindow("You are using an invalid version of MegaMek please use version " + MMVersion);
            return;
        }
        int MaxPlayers = Integer.parseInt(this.getConfigParam("MAXPLAYERS:"));
        String comment = this.getConfigParam("COMMENT:");
        String gpassword = this.getConfigParam("GAMEPASSWORD:");
        if (gpassword == null) {
            gpassword = "";
        }
        try {
            this.myServer = new Server(gpassword, this.myPort);
            if (loadSavegame) {
                FileDialog f = new FileDialog((Frame)this.MainFrame, "Load Savegame");
                f.setDirectory(System.getProperty("user.dir") + "/savegames");
                f.setVisible(true);
                this.myServer.loadGame(new File(f.getDirectory(), f.getFile()));
            }
        }
        catch (Exception ex) {
            try {
                this.myServer.die();
            }
            catch (Exception e) {
                mwClientLog.clientErrLog(e);
            }
            return;
        }
        this.serverSend("NG|" + new MMGame(this.myUsername, ip, this.myPort, MaxPlayers, MegaMek.VERSION + " " + MegaMek.TIMESTAMP, comment, this.myComPrefix).toString());
        if (!dedicated) {
            Vector autoArmy;
            Vector meks;
            int nextrow = this.getMainFrame().getMainPanel().getBattleTable().getRowCount();
            if (deploy) {
                meks = this.myPlayer.getLockedUnits();
                autoArmy = this.myPlayer.getAutoArmy();
            } else {
                meks = new Vector();
                autoArmy = new Vector();
            }
            mwClientLog.clientOutputLog("Joining my game!");
            this.serverSend("JG");
            ClientThread tmpThread = new ClientThread(this.myUsername, this.Config.getName(), "127.0.0.1", this.myPort, this, true, meks, autoArmy);
            tmpThread.run();
            this.sendChat(CAMPAIGN_PREFIX + "c autojoingame#" + nextrow);
        } else {
            this.clearSavedGames();
            this.purgeOldLogs();
            IClientPreferences cs = PreferenceManager.getClientPreferences();
            cs.setStampFilenames(Boolean.valueOf(this.getserverConfigs("MMTimeStampLogFile")));
        }
    }

    public void stopHost() {
        this.serverSend("CG");
        try {
            this.myServer.die();
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog(ex);
            mwClientLog.clientErrLog("Megamek Error:");
        }
        this.myServer = null;
    }

    public void resetGame() {
        if (this.myServer != null) {
            this.myServer.resetGame();
        }
    }

    public boolean loadGame(String filename) {
        if (this.myServer != null && filename != null && !filename.equals("")) {
            return this.myServer.loadGame(new File("./savegames/", filename));
        }
        if (this.myServer == null) {
            mwClientLog.clientOutputLog("MyServer == NULL!");
        }
        if (filename == null) {
            mwClientLog.clientOutputLog("Filename == NULL!");
        } else if (filename.equals("")) {
            mwClientLog.clientOutputLog("Filename == \"\"!");
        }
        return false;
    }

    public boolean loadGameWithFullPath(String filename) {
        if (this.myServer != null && filename != null && !filename.equals("")) {
            return this.myServer.loadGame(new File(filename));
        }
        if (this.myServer == null) {
            mwClientLog.clientOutputLog("MyServer == NULL!");
        }
        if (filename == null) {
            mwClientLog.clientOutputLog("Filename == NULL!");
        } else if (filename.equals("")) {
            mwClientLog.clientOutputLog("Filename == \"\"!");
        }
        return false;
    }

    public boolean isServerRunning() {
        return this.myServer != null;
    }

    public void startClient(int row, boolean deploy) {
        Vector meks = new Vector();
        Vector autoArmy = new Vector();
        if (this.games.size() > 0 && row >= 0) {
            MMGame curGame = (MMGame)this.games.get(row);
            if (curGame.getCurrentPlayers().size() >= curGame.getMaxPlayers() && curGame.getStatus().equals("Open") && !this.isMod()) {
                this.showInfoWindow("This game is already full");
                return;
            }
            String serverip = curGame.getIp();
            int serverport = curGame.getPort();
            if (this.myUsername.equalsIgnoreCase(curGame.getUID())) {
                serverip = "127.0.0.1";
            }
            if (deploy) {
                meks = this.myPlayer.getLockedUnits();
                autoArmy = this.myPlayer.getAutoArmy();
            }
            ClientThread tmpThread = new ClientThread(curGame.getUID(), this.Config.getName(), serverip, serverport, this, false, meks, autoArmy);
            tmpThread.start();
            this.serverSend("JG|" + curGame.getUID());
        } else {
            this.showInfoWindow("You have to select a game!");
        }
    }

    public void closingGame(String id) {
        mwClientLog.clientOutputLog("Leaving " + id);
        if (!id.equalsIgnoreCase("default")) {
            this.serverSend("LG|" + id);
        }
    }

    @Override
    public void setGameState(String newState) {
        if (!this.lastSetGameState.equals(newState) && this.myServer != null) {
            this.serverSend("SS|" + newState);
        }
        this.lastSetGameState = newState;
    }

    @Override
    public void setPlayers(Vector Players) {
    }

    @Override
    public void setGhosts(Vector Ghosts) {
    }

    public Vector getGameOptions() {
        return this.GameOptions;
    }

    public Dimension getMapSize() {
        return this.MapSize;
    }

    public Dimension getBoardSize() {
        return this.BoardSize;
    }

    public PlanetEnvironment getCurrentEnvironment() {
        return this.currentEnvironment;
    }

    public AdvanceTerrain getCurrentAdvanceTerrain() {
        return this.aTerrain;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public synchronized void refreshData() {
        if (!this.getConfig().isParam("MAPTABVISIBLE")) {
            mwClientLog.clientOutputLog("Map visibility disabled. Skipping map data fetch!");
            return;
        }
        if (!this.dataFetcher.getPlanetsUpdate(this.data)) {
            mwClientLog.clientOutputLog("MD5 does not match! But the md5 seems broken anyway...");
        }
        this.updateDataFetcher = null;
        Map changesSinceLastRefresh = this.dataFetcher.getChangesSinceLastRefresh();
        if (this.getMainFrame() != null) {
            this.getMainFrame().getMainPanel().getMapPanel().getMap().dataFetched(changesSinceLastRefresh);
        }
        mwClientLog.clientOutputLog("update for new planet data finished");
    }

    public Map getChangesSinceLastRefresh() {
        return this.dataFetcher.getChangesSinceLastRefresh();
    }

    public void reloadData() {
        try {
            this.data = this.dataFetcher.getAllData();
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog(ex);
        }
        try {
            this.dataFetcher.getServerConfigData(this);
        }
        catch (IOException e1) {
            mwClientLog.clientErrLog(e1);
        }
    }

    public void loadServerCommmands() {
        try {
            this.dataFetcher.getAccessLevels(this.getData());
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog("Error loading Server Commands files");
            mwClientLog.clientErrLog(ex);
        }
    }

    public void loadServerTraitFiles() {
        try {
            this.dataFetcher.getServerTraitFiles();
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog("Error loading Server Trait files");
            mwClientLog.clientErrLog(ex);
        }
    }

    public void loadServerMegaMekGameOptions() {
        try {
            this.dataFetcher.getServerMegaMekGameOptions();
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog("Error loading Server MegaMekGameOptions files");
            mwClientLog.clientErrLog(ex);
        }
    }

    public void loadServerBannedAmmo() {
        try {
            this.dataFetcher.getServerBannedAmmoData(this);
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog("Error loading Server banned ammo file");
            mwClientLog.clientErrLog(ex);
        }
    }

    public void loadHouseBannedAmmo() {
        try {
            this.dataFetcher.getHouseBannedAmmoData(this);
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog("Error loading house banned ammo file");
            mwClientLog.clientErrLog(ex);
        }
    }

    public CampaignData getData() {
        if (this.data == null) {
            block19: {
                try {
                    mwClientLog.clientOutputLog("try to import the planetcache");
                    this.data = this.dataFetcher.getAllData();
                    this.dataFetcher.store();
                    this.splash.setStatus(this.splash.STATUS_CONSTRUCTINGGUI);
                }
                catch (Throwable e) {
                    block18: {
                        if (this.splash != null) {
                            this.splash.setStatus(this.splash.STATUS_DATAERROR);
                        }
                        if (!(e instanceof FileNotFoundException)) {
                            mwClientLog.clientErrLog(e);
                        }
                        mwClientLog.clientOutputLog("need to fetch all planet data..");
                        try {
                            this.data = this.dataFetcher.getAllData();
                            this.dataFetcher.store();
                        }
                        catch (ConnectException e1) {
                            mwClientLog.clientErrLog(e1);
                            mwClientLog.clientErrLog(this.getCacheDir());
                            Object[] options = new Object[]{"Exit", "Continue"};
                            int selectedValue = JOptionPane.showOptionDialog(null, "Could not connect to server to fetch map data.", "Connection error!", -1, 0, null, options, options[0]);
                            if (selectedValue == 0) {
                                System.exit(0);
                            }
                        }
                        catch (IOException e1) {
                            mwClientLog.clientErrLog(e1);
                            JOptionPane.showMessageDialog(null, "Server is busy while fetching planet data.\nTry again later.");
                        }
                        catch (Throwable e1) {
                            mwClientLog.clientErrLog(e1);
                            Object[] options = new Object[]{"Exit", "Continue"};
                            int selectedValue = JOptionPane.showOptionDialog(null, "Unknown error while fetching map data. Please\nreport this bug, and keep your error logs handy.", "Unknown error!", -1, 0, null, options, options[0]);
                            if (selectedValue != 0) break block18;
                            System.exit(0);
                        }
                    }
                    if (this.splash == null) break block19;
                    this.splash.setStatus(this.splash.STATUS_CONSTRUCTINGGUI);
                }
            }
            try {
                this.refreshData();
            }
            catch (Throwable x) {
                mwClientLog.clientErrLog(x);
            }
            try {
                this.dataFetcher.getServerConfigData(this);
            }
            catch (IOException e1) {
                mwClientLog.clientErrLog("Unable to fetch server configuration. Loading defaults.");
                mwClientLog.clientErrLog(e1);
            }
            try {
                this.loadServerMegaMekGameOptions();
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog("Unable to load MM server game options!");
                mwClientLog.clientErrLog(ex);
            }
            try {
                this.dataFetcher.getServerBannedAmmoData(this);
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog("Unable to fetch server banned ammo data.");
                mwClientLog.clientErrLog(ex);
            }
        }
        return this.data;
    }

    public void processTick(int time) {
        this.getMainFrame().getMainPanel().getPlayerPanel().setNextTick(System.currentTimeMillis() + (long)time);
        this.getMainFrame().getMainPanel().getMapPanel().getMap().processTick();
        System.gc();
    }

    public String getCacheDir() {
        this.cacheDir = "data/servers/" + this.Config.getServerIP() + "." + this.Config.getServerPort();
        File dir = new File(this.cacheDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return this.cacheDir;
    }

    public void setIgnoreHouse() {
        if (this.Config.existsParam("IGNOREHOUSE")) {
            this.IgnoreHouse = new Vector();
            this.IgnoreHouse = this.splitString(this.Config.getParam("IGNOREHOUSE"), ",");
        }
    }

    public void setIgnorePublic() {
        if (this.Config.existsParam("IGNOREPUBLIC")) {
            this.IgnorePublic = new Vector();
            this.IgnorePublic = this.splitString(this.Config.getParam("IGNOREPUBLIC"), ",");
        }
    }

    public void setIgnorePrivate() {
        if (this.Config.existsParam("IGNOREPRIVATE")) {
            this.IgnorePrivate = new Vector();
            this.IgnorePrivate = this.splitString(this.Config.getParam("IGNOREPRIVATE"), ",");
        }
    }

    public void setEnvironment(PlanetEnvironment pe, Dimension dim) {
        this.currentEnvironment = pe;
        this.MapSize = dim;
    }

    public void setAdvanceTerrain(AdvanceTerrain aTerrain, Dimension dim) {
        this.aTerrain = aTerrain;
        this.MapSize = dim;
    }

    public void setEnvironment(PlanetEnvironment pe, Dimension map, Dimension board) {
        this.currentEnvironment = pe;
        this.MapSize = map;
        this.BoardSize = board;
    }

    public void setBuildingTemplate(Buildings buildingTemplate) {
        this.buildingTemplate = buildingTemplate;
    }

    public Buildings getBuildingTemplate() {
        return this.buildingTemplate;
    }

    public void changeStatus(int newStatus) {
        this.LastStatus = this.Status;
        this.Status = newStatus;
        if (this.Status == STATUS_LOGGEDIN) {
            this.sendChat(CAMPAIGN_PREFIX + "c setclientversion#" + this.myUsername + "#" + CLIENT_VERSION);
        } else if (this.Status == STATUS_LOGGEDOUT) {
            this.clearUserCampaignData();
        }
        if (this.Status == STATUS_FIGHTING) {
            this.getMainFrame().getMainPanel().getUserListPanel().setActivateButtonText("Deactivate");
            this.getMainFrame().getMainPanel().getUserListPanel().setActivityButtonEnabled(false);
        } else if (this.Status == STATUS_ACTIVE) {
            this.getMainFrame().getMainPanel().getUserListPanel().setActivateButtonText("Deactivate");
            this.getMainFrame().getMainPanel().getUserListPanel().setActivityButtonEnabled(true);
        } else if (this.Status == STATUS_DISCONNECTED) {
            this.getMainFrame().getMainPanel().getUserListPanel().setActivateButtonText("Disconnected");
            this.getMainFrame().getMainPanel().getUserListPanel().setActivityButtonEnabled(false);
        } else if (this.Status == STATUS_LOGGEDOUT) {
            this.getMainFrame().getMainPanel().getUserListPanel().setActivateButtonText("Login");
            this.getMainFrame().getMainPanel().getUserListPanel().setActivityButtonEnabled(true);
        } else if (this.Status == STATUS_LOGGEDIN) {
            this.getMainFrame().getMainPanel().getUserListPanel().setActivateButtonText("Activate");
            this.getMainFrame().getMainPanel().getUserListPanel().setActivityButtonEnabled(true);
        }
        this.refreshGUI(REFRESH_STATUS);
        this.refreshGUI(REFRESH_HQPANEL);
        this.refreshGUI(REFRESH_PLAYERPANEL);
    }

    public Properties getserverConfigs() {
        return this.serverConfigs;
    }

    public String getserverConfigs(String key) {
        if (this.serverConfigs.getProperty(key) == null) {
            mwClientLog.clientOutputLog("You're missing the config variable: " + key + " in serverconfig!");
            return "-1";
        }
        return this.serverConfigs.getProperty(key).trim();
    }

    public SplashWindow getSplashWindow() {
        return this.splash;
    }

    public boolean isAdmin() {
        return this.getUser(this.getUsername()).getUserlevel() == 200;
    }

    public boolean isMod() {
        return this.getUser(this.getUsername()).getUserlevel() >= 100;
    }

    public void checkForRestart() {
        ++this.gameCount;
        if (this.gameCount >= this.dedRestartAt) {
            mwClientLog.clientOutputLog("System has reached " + this.gameCount + " games played and is restarting");
            try {
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog(ex);
            }
            this.stopHost();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog(ex);
            }
            this.startHost(true, false, false);
            this.gameCount = 0;
            return;
        }
    }

    public void clearSavedGames() {
        long daysInSeconds = (long)this.savedGamesMaxDays * 24L * 60L * 60L * 1000L;
        File saveFiles = new File("./savegames/");
        if (!saveFiles.exists()) {
            return;
        }
        File[] fileList = saveFiles.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File savedFile = fileList[i];
            long lastTime = savedFile.lastModified();
            if (!savedFile.exists() || !savedFile.isFile() || lastTime >= System.currentTimeMillis() - daysInSeconds) continue;
            try {
                mwClientLog.clientOutputLog("Purging File: " + savedFile.getName() + " Time: " + lastTime + " purge Time: " + (System.currentTimeMillis() - daysInSeconds));
                savedFile.delete();
                continue;
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog("Error trying to delete these files!");
                mwClientLog.clientErrLog(ex);
            }
        }
    }

    public void purgeOldLogs() {
        long daysInSeconds = (long)this.savedGamesMaxDays * 24L * 60L * 60L * 1000L;
        File saveFiles = new File("./logs/backup");
        if (!saveFiles.exists()) {
            return;
        }
        File[] fileList = saveFiles.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File savedFile = fileList[i];
            long lastTime = savedFile.lastModified();
            if (!savedFile.exists() || !savedFile.isFile() || lastTime >= System.currentTimeMillis() - daysInSeconds) continue;
            try {
                mwClientLog.clientOutputLog("Purging File: " + savedFile.getName() + " Time: " + lastTime + " purge Time: " + (System.currentTimeMillis() - daysInSeconds));
                savedFile.delete();
                continue;
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog("Error trying to delete these files!");
                mwClientLog.clientErrLog(ex);
            }
        }
    }

    public String getParanoidAutoSave() {
        File tempFile = new File("./savegames/");
        autoSaveFilter filter = new autoSaveFilter();
        File[] fileList = tempFile.listFiles(filter);
        long time = 0L;
        String saveFile = "autosave.sav";
        for (int i = 0; i < fileList.length; ++i) {
            File newFile = fileList[i];
            if (newFile.lastModified() <= time) continue;
            time = newFile.lastModified();
            saveFile = newFile.getName();
        }
        return saveFile;
    }

    public String moneyOrFluMessage(boolean money, boolean shortname, int amount) {
        return this.moneyOrFluMessage(money, shortname, amount, false);
    }

    public String moneyOrFluMessage(boolean money, boolean shortname, int amount, boolean showSign) {
        String result = Integer.toString(amount);
        String moneyShort = this.getserverConfigs("MoneyShortName");
        String moneyLong = this.getserverConfigs("MoneyLongName");
        String fluShort = this.getserverConfigs("FluShortName");
        String fluLong = this.getserverConfigs("FluLongName");
        String sign = "+";
        if (amount < 0) {
            result = "";
            amount *= -1;
            sign = "-";
        }
        result = money ? (shortname ? (amount == 1 && moneyShort.endsWith("s") ? result + moneyShort.substring(0, moneyShort.length() - 1) : (amount > 1 && !moneyShort.endsWith("s") ? result + moneyShort + "s" : result + moneyShort)) : (amount == 1 && moneyLong.endsWith("s") ? result + " " + moneyLong.substring(0, moneyLong.length() - 1) : (amount > 1 && !moneyLong.endsWith("s") ? result + " " + moneyLong + "s" : result + " " + moneyLong))) : (shortname ? (amount == 1 && fluShort.endsWith("s") ? result + fluShort.substring(0, fluShort.length() - 1) : (amount > 1 && !fluShort.endsWith("s") ? result + fluShort + "s" : result + fluShort)) : (amount == 1 && fluLong.endsWith("s") ? result + " " + fluLong.substring(0, fluLong.length() - 1) : (amount > 1 && !fluLong.endsWith("s") ? result + " " + fluLong + "s" : result + " " + fluLong)));
        if (showSign) {
            result = sign + result;
        }
        return result;
    }

    public void LoadMegaMekClient() {
        try {
            this.loadServerMegaMekGameOptions();
            Client MegaMekClient = new Client("temp", "None", 0);
            MegaMekClient.game.getOptions().loadOptions("");
            GameOptions gameOptions = MegaMekClient.game.getOptions();
            GameOptionsDialog MMGOD = new GameOptionsDialog((Frame)this.getMainFrame(), gameOptions);
            MMGOD.update(gameOptions);
            MMGOD.setVisible(true);
            File localGameOptions = new File("mmconf/gameoptions.xml");
            String localOptionsMD5 = MD5.getHashString(localGameOptions);
            String ServerMegaMekGameOptionsMD52 = this.dataFetcher.getServerMegaMekGameOptionsMD5();
            if (!localOptionsMD5.equals(ServerMegaMekGameOptionsMD52)) {
                this.sendGameOptionsToServer();
            }
        }
        catch (Exception ex) {
            mwClientLog.clientErrLog("Unable to pull server MegaMek Logs");
            mwClientLog.clientErrLog(ex);
        }
    }

    public void sendGameOptionsToServer() {
        StringBuffer packet = new StringBuffer();
        try {
            FileInputStream gameOptionsFile = new FileInputStream("./mmconf/gameoptions.xml");
            BufferedReader gameOptions = new BufferedReader(new InputStreamReader(gameOptionsFile));
            while (gameOptions.ready()) {
                packet.append(gameOptions.readLine() + "#");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sendChat(CAMPAIGN_PREFIX + "c servergameoptions#" + packet.toString());
    }

    public int getMinPlanetOwnerShip(Planet p) {
        if (p.getMinPlanetOwnerShip() == -1) {
            return Integer.parseInt(this.getserverConfigs("MinPlanetOwnerShip"));
        }
        return p.getMinPlanetOwnerShip();
    }

    protected class TimeOutThread
    extends Thread {
        MWClient mwclient;

        public TimeOutThread(MWClient client) {
            this.mwclient = client;
        }

        public void run() {
            while (true) {
                try {
                    TimeOutThread.sleep(this.mwclient.TimeOut * 100L);
                }
                catch (Exception ex) {
                    mwClientLog.clientErrLog(ex);
                }
                if (this.mwclient.Status != STATUS_DISCONNECTED) {
                    long timeout = System.currentTimeMillis() / 1000L - MWClient.this.LastPing;
                    if (timeout <= this.mwclient.TimeOut) continue;
                    MWClient.this.systemMessage("Ping timeout (" + timeout + " s)");
                    MWClient.this.Connector.closeConnection();
                    continue;
                }
                MWClient.this.LastPing = System.currentTimeMillis() / 1000L;
            }
        }
    }

    protected class CPlaySound
    implements Runnable {
        String filename;

        public CPlaySound(String tfilename) {
            this.filename = tfilename;
        }

        public void run() {
            if (this.filename == null || MWClient.this.SoundMuted) {
                return;
            }
            try {
                File file = new File(this.filename);
                URI newUri = file.toURI();
                AudioClip clip = Applet.newAudioClip(newUri.toURL());
                clip.play();
            }
            catch (Exception ex) {
                mwClientLog.clientErrLog(ex);
            }
        }
    }

    protected class CRefreshGUI
    implements Runnable {
        protected int mode = -1;

        public CRefreshGUI(int tmode) {
            this.mode = tmode;
        }

        public void run() {
            if (this.mode == REFRESH_USERLIST) {
                MWClient.this.MainFrame.getMainPanel().getUserListPanel().refresh();
                return;
            }
            if (this.mode == REFRESH_PLAYERPANEL) {
                MWClient.this.MainFrame.getMainPanel().getPlayerPanel().refresh();
                return;
            }
            if (this.mode == REFRESH_BATTLETABLE) {
                MWClient.this.MainFrame.refreshBattleTable();
                return;
            }
            if (this.mode == REFRESH_HQPANEL) {
                MWClient.this.MainFrame.getMainPanel().getHQPanel().refresh();
                return;
            }
            if (this.mode == REFRESH_STATUS) {
                MWClient.this.MainFrame.changeStatus(MWClient.this.Status, MWClient.this.LastStatus);
                return;
            }
            if (this.mode == REFRESH_BMPANEL) {
                MWClient.this.MainFrame.getMainPanel().getBMPanel().refresh();
                return;
            }
        }
    }

    protected class CAddToChat
    implements Runnable {
        String input = "";
        int channel = -1;

        public CAddToChat(String tinput, int tchannel) {
            this.input = tinput;
            this.channel = tchannel;
        }

        public void run() {
            MWClient.this.MainFrame.getMainPanel().getCommPanel().setChat(this.input, this.channel);
        }
    }
}

