/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import client.campaign.CBMUnit;
import client.campaign.CPlayer;
import client.gui.CCommPanel;
import java.io.File;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class CCampaign {
    MWClient mwclient;
    CPlayer Player;
    TreeMap BlackMarket = new TreeMap();
    TreeMap Houses = new TreeMap();
    TreeMap Planets;
    TreeMap Tasks;
    String Path;
    public static String HOUSE_FILENAME = "houses.dat";
    public static String PLANET_FILENAME = "planets.dat";
    public static String PLAYER_FILENAME = "player.dat";

    public CCampaign(MWClient client) {
        this.mwclient = client;
        this.Player = new CPlayer(this, this.mwclient);
        this.Path = MWClient.CAMPAIGN_PATH;
        File f = new File(this.Path);
        if (f.exists() && !f.isDirectory()) {
            f.delete();
        }
        if (!f.exists()) {
            try {
                f.mkdirs();
            }
            catch (Exception e) {
                MWClient.mwClientLog.clientErrLog(e);
            }
        }
    }

    public boolean decodeCommand(String command) {
        StringTokenizer ST = new StringTokenizer(command, "|");
        String element = ST.nextToken();
        command = command.substring(3);
        if (element.equals("PS")) {
            if (!this.Player.setData(command)) {
                this.mwclient.addToChat("Player data load failed!<br>");
                return false;
            }
            return true;
        }
        if (element.equals("CC")) {
            String commandid = ST.nextToken();
            if (commandid.equals("AT")) {
                if (this.mwclient.getConfig().isParam("ENABLEATTACKSOUND")) {
                    this.mwclient.doPlaySound(this.mwclient.getConfigParam("SOUNDONATTACK:"));
                }
                this.mwclient.addToChat("<font color=\"red\"><b>Your forces are under attack!</b></font>", CCommPanel.CHANNEL_HMAIL);
                this.mwclient.addToChat("<font color=\"red\"><b>Your forces are under attack!</b></font>", CCommPanel.CHANNEL_PMAIL);
                if (this.mwclient.getConfig().isParam("POPUPONATTACK")) {
                    this.mwclient.showInfoWindow("Your forces are under attack!");
                }
            }
            if (commandid.equals("NT")) {
                int time = Integer.parseInt(ST.nextToken());
                this.mwclient.processTick(time);
            }
            return true;
        }
        if (element.equals("CA")) {
            if (!this.setData(command)) {
                this.mwclient.addToChat("<b>Error: Campaign data load failed.</b><br>");
                return false;
            }
            return true;
        }
        if (element.equals("PL")) {
            if (!this.Player.decodeCommand(command)) {
                this.mwclient.addToChat("<b>Error: Player data load failed.</b><br>");
                return false;
            }
            return true;
        }
        if (element.equals("BM")) {
            if (!this.setBMData(command)) {
                this.mwclient.addToChat("<b>Error: Black Market data load failed.</b><br>");
                return false;
            }
            return true;
        }
        if (element.equals("MS")) {
            if (!this.showMsg(command)) {
                this.mwclient.addToChat("<b>Error: Message show failed.</b><br>");
                return false;
            }
            return true;
        }
        if (element.equals("ST")) {
            if (!this.showStatus(command)) {
                this.mwclient.addToChat("<b>Error: Status show failed.</b><br>");
                return false;
            }
            return true;
        }
        this.mwclient.addToChat("<b>Error: Wrong campaign command from server.</b><br>");
        return false;
    }

    protected boolean setData(String command) {
        return true;
    }

    protected boolean setBMData(String command) {
        this.BlackMarket.clear();
        this.Player.getBMUnits().clear();
        StringTokenizer ST = new StringTokenizer(command, "|");
        String element = (String)ST.nextElement();
        if (element.equals("DA")) {
            int mekcount = Integer.parseInt(ST.nextToken());
            for (int i = 0; i < mekcount; ++i) {
                CBMUnit tmek = new CBMUnit(this);
                if (!tmek.setBMData((String)ST.nextElement())) continue;
                this.BlackMarket.put(new Integer(tmek.getAuctionID()), tmek);
                if (!tmek.getSeller().equals(this.Player.getName())) continue;
                this.Player.getBMUnits().add(tmek);
            }
        }
        this.mwclient.getMainFrame().getMainPanel().getBMPanel().setRefreshTime();
        return true;
    }

    public boolean loadData() {
        return this.loadHouseData() && this.loadPlanetData() && this.loadPlayerData();
    }

    public void clearData() {
        this.BlackMarket.clear();
        this.Houses.clear();
        this.Planets.clear();
        this.Tasks.clear();
        this.Player.clearData();
    }

    public boolean loadHouseData() {
        return true;
    }

    public boolean loadPlayerData() {
        this.Player.loadData();
        return true;
    }

    public boolean loadPlanetData() {
        return true;
    }

    protected void processTick() {
    }

    protected boolean showMsg(String command) {
        return true;
    }

    protected boolean showStatus(String command) {
        this.mwclient.addToChat(command);
        return true;
    }

    public void setPlayer(CPlayer tplayer) {
        this.Player = tplayer;
    }

    public CPlayer getPlayer() {
        return this.Player;
    }

    public TreeMap getBlackMarket() {
        return this.BlackMarket;
    }

    public TreeMap getHouses() {
        return this.Houses;
    }

    public String getPath() {
        return this.Path;
    }
}

