/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import client.campaign.CArmy;
import client.campaign.CCampaign;
import client.campaign.CPersonalPilotQueues;
import client.campaign.CShortUnit;
import client.campaign.CUnit;
import client.util.CUnitComparator;
import common.Army;
import common.House;
import common.Player;
import common.Unit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPlayer
extends Player {
    public static String PREFIX = "PL";
    public static String DELIMITER = "#";
    MWClient mwclient;
    CCampaign Campaign;
    String Name;
    int Exp;
    int Money;
    int Bays;
    int FreeBays;
    int Influence;
    int Techs;
    int TechCost;
    int RewardPoints;
    double Rating;
    String House;
    String Profession = "Mek Warrior Commander";
    Vector Hangar;
    Vector<CArmy> Armies;
    Vector AutoArmy;
    Vector BMUnits;
    Vector adminExcludes;
    Vector playerExcludes;
    TreeMap Bids;
    FileInputStream fis;
    BufferedReader br;
    FileOutputStream fos;
    PrintStream ps;
    CPersonalPilotQueues personalPilotQueue;
    House myHouse = null;

    public CPlayer(CCampaign campaign, MWClient client) {
        this.Campaign = campaign;
        this.mwclient = client;
        this.Name = "";
        this.Exp = 0;
        this.Money = 0;
        this.Bays = 0;
        this.FreeBays = 0;
        this.Influence = 0;
        this.Rating = 0.0;
        this.House = "";
        this.Profession = "";
        this.Hangar = new Vector();
        this.Armies = new Vector();
        this.AutoArmy = new Vector();
        this.BMUnits = new Vector();
        this.Bids = new TreeMap();
        this.personalPilotQueue = new CPersonalPilotQueues();
        this.adminExcludes = new Vector();
        this.playerExcludes = new Vector();
        this.myHouse = new House();
    }

    public boolean decodeCommand(String command) {
        StringTokenizer ST = new StringTokenizer(command, "|");
        String element = (String)ST.nextElement();
        if (!element.equals("PL")) {
            return false;
        }
        element = (String)ST.nextElement();
        command = command.substring(3);
        if (element.equals("DA")) {
            return this.setData(command);
        }
        return false;
    }

    public boolean loadData() {
        String line = null;
        String c = MWClient.COMMAND_DELIMITER;
        try {
            File f = new File(this.Campaign.getPath() + CCampaign.PLAYER_FILENAME);
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                MWClient.mwClientLog.clientErrLog(e);
            }
            this.fis = new FileInputStream(f);
            this.br = new BufferedReader(new InputStreamReader(this.fis));
            line = this.br.readLine();
            while (line != null) {
                if (!line.startsWith("#") && !line.startsWith(";") && line.startsWith("PL" + c)) {
                    if ((line = line.substring(c.length() + 2)).startsWith("PD" + c)) {
                        line = line.substring(c.length() + 2);
                        this.setPlayerData(line);
                        line = "";
                    }
                    if (line.startsWith("LD" + c)) {
                        line = line.substring(c.length() + 2);
                        System.err.println("Loading Armies via Data Provider is broken!");
                        line = "";
                    }
                    if (line.startsWith("HD" + c)) {
                        line = line.substring(c.length() + 2);
                        this.setHangarData(line);
                        line = "";
                    }
                }
                line = this.br.readLine();
            }
            this.br.close();
            this.fis.close();
            return true;
        }
        catch (Exception e) {
            MWClient.mwClientLog.clientErrLog(e);
            return false;
        }
    }

    public boolean saveData() {
        try {
            this.fos = new FileOutputStream(this.Campaign.getPath() + CCampaign.PLAYER_FILENAME);
            this.ps = new PrintStream(this.fos);
            this.ps.println("#MekWars player data file. Don't change anything below (even if you know what are you doing).");
            this.ps.println(this.getPlayerString());
            this.ps.println(this.getHangarString());
            this.ps.close();
            this.fos.close();
            return true;
        }
        catch (Exception e) {
            MWClient.mwClientLog.clientErrLog(e);
            return false;
        }
    }

    public void setArmyData(String data) {
        CArmy newArmy = new CArmy();
        newArmy.fromString(data, this, "%", this.mwclient);
        CArmy oldArmy = this.getArmy(newArmy.getID());
        if (oldArmy != null) {
            newArmy.setLegalOperations(oldArmy.getLegalOperations());
        }
        this.removeArmy(newArmy.getID());
        this.Armies.add(newArmy);
    }

    public boolean setData(String data) {
        int i;
        StringTokenizer ST = new StringTokenizer(data, "~");
        String element = (String)ST.nextElement();
        if (!element.equals("CP")) {
            return false;
        }
        this.Armies.clear();
        this.Hangar.clear();
        this.Name = (String)ST.nextElement();
        this.Money = Integer.parseInt((String)ST.nextElement());
        this.Exp = Integer.parseInt((String)ST.nextElement());
        int Hangarcount = Integer.parseInt((String)ST.nextElement());
        for (i = 0; i < Hangarcount; ++i) {
            CUnit tmek = new CUnit(this);
            if (!tmek.setData((String)ST.nextElement())) continue;
            this.Hangar.add(tmek);
        }
        int Armiescount = Integer.parseInt((String)ST.nextElement());
        for (i = 0; i < Armiescount; ++i) {
            CArmy army = new CArmy();
            army.fromString((String)ST.nextElement(), this, "%", this.mwclient);
            this.Armies.add(army);
        }
        ST.nextToken();
        this.Profession = "Mek Warrior Commander";
        ST.nextToken();
        this.Bays = Integer.parseInt(ST.nextToken());
        this.FreeBays = Integer.parseInt(ST.nextToken());
        this.Rating = Double.parseDouble(ST.nextToken());
        this.Influence = Integer.parseInt(ST.nextToken());
        ST.nextToken();
        if (ST.hasMoreElements()) {
            int numofoptions = Integer.parseInt(ST.nextToken());
            for (i = 0; i < numofoptions; ++i) {
                ST.nextToken();
                ST.nextToken();
            }
        }
        if (ST.hasMoreElements()) {
            this.Techs = Integer.parseInt(ST.nextToken());
            this.doPayTechniciansMath(this.Techs);
        }
        if (ST.hasMoreElements()) {
            this.RewardPoints = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            ST.nextToken();
        }
        if (ST.hasMoreElements()) {
            ST.nextToken();
        }
        if (ST.hasMoreElements()) {
            this.House = ST.nextToken();
        }
        if (ST.hasMoreElements()) {
            ST.nextToken();
        }
        this.saveData();
        this.sortHangar();
        return true;
    }

    public void setRewardPoints(int rewards) {
        this.RewardPoints = rewards;
    }

    public void setPlayerData(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens() && ST.nextToken().equals(PREFIX)) {
            if (ST.hasMoreTokens()) {
                this.Name = ST.nextToken();
            }
            if (ST.hasMoreTokens()) {
                this.Exp = Integer.parseInt(ST.nextToken());
            }
            if (ST.hasMoreTokens()) {
                this.Money = Integer.parseInt(ST.nextToken());
            }
            if (ST.hasMoreTokens()) {
                this.Bays = Integer.parseInt(ST.nextToken());
            }
            if (ST.hasMoreTokens()) {
                this.FreeBays = Integer.parseInt(ST.nextToken());
            }
            if (ST.hasMoreTokens()) {
                this.Influence = Integer.parseInt(ST.nextToken());
            }
            if (ST.hasMoreTokens()) {
                this.Rating = Float.parseFloat(ST.nextToken());
            }
            if (ST.hasMoreTokens()) {
                this.House = ST.nextToken();
            }
            if (ST.hasMoreTokens()) {
                this.Profession = ST.nextToken();
            }
        }
    }

    public void setHangarData(String data) {
        try {
            CUnit unit = new CUnit(this);
            if (unit.setData(data)) {
                this.Hangar.add(unit);
                this.sortHangar();
            }
        }
        catch (Exception e) {
            MWClient.mwClientLog.clientErrLog(e);
            return;
        }
    }

    public void updateUnitData(StringTokenizer st) {
        try {
            CUnit currUnit = this.getUnit(Integer.parseInt(st.nextToken()));
            currUnit.setData(st.nextToken());
            this.sortHangar();
        }
        catch (Exception e) {
            MWClient.mwClientLog.clientErrLog(e);
            return;
        }
    }

    public void clearData() {
        this.Name = "";
        this.Exp = 0;
        this.Money = 0;
        this.Bays = 0;
        this.FreeBays = 0;
        this.Influence = 0;
        this.Rating = 0.0;
        this.House = "";
        this.Profession = "";
        this.Hangar.clear();
        this.Armies.clear();
        this.BMUnits.clear();
        this.Bids.clear();
    }

    public String getPlayerString() {
        String c = MWClient.COMMAND_DELIMITER;
        String d = DELIMITER;
        String result = "PL" + c + "PD" + c + PREFIX + d;
        result = result + this.Name + d + this.Exp + d + this.Money + d + this.Bays + d + this.FreeBays + d + this.Influence + d + this.Rating;
        result = result + d + this.House + d + this.Profession;
        return result;
    }

    public String getHangarString() {
        String c = MWClient.COMMAND_DELIMITER;
        String d = DELIMITER;
        String result = "PL" + c + "HD" + c + Integer.toString(this.Hangar.size()) + d;
        Iterator i = this.Hangar.iterator();
        while (i.hasNext()) {
            result = result + ((CUnit)i.next()).getUnitString() + d;
        }
        result = result.substring(0, result.length() - d.length());
        return result;
    }

    public void addArmy() {
        CArmy lance = new CArmy();
        lance.setID(this.getFreeArmyID());
        this.Armies.add(lance);
    }

    public boolean removeArmy(int lanceID) {
        Iterator<CArmy> i = this.Armies.iterator();
        while (i.hasNext()) {
            if (i.next().getID() != lanceID) continue;
            i.remove();
            this.mwclient.getMainFrame().updateAttackMenu();
            return true;
        }
        return false;
    }

    public boolean addUnit(String data) {
        CUnit unit = new CUnit(this);
        if (unit.setUnitData(data)) {
            this.Hangar.add(unit);
            return true;
        }
        return false;
    }

    public boolean addUnit(CUnit unit) {
        this.Hangar.add(unit);
        return true;
    }

    public boolean removeUnit(int unitID) {
        Iterator i = this.Hangar.iterator();
        while (i.hasNext()) {
            if (((CUnit)i.next()).getId() != unitID) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public boolean removeUnit(int lanceID, int unitID) {
        MWClient.mwClientLog.clientErrLog("Remove Unit is defunct right now!");
        return false;
    }

    public boolean moveUnit(int sourceID, int destID, int unitID) {
        MWClient.mwClientLog.clientErrLog("Move Unit is defunct right now!");
        return false;
    }

    public Vector<CArmy> getArmies() {
        return this.Armies;
    }

    public void setExp(int texp) {
        this.Exp = texp;
    }

    public void setMoney(int tmoney) {
        this.Money = tmoney;
    }

    public void setBays(int tbays) {
        this.Bays = tbays;
    }

    public void setFreeBays(int tfreebays) {
        this.FreeBays = tfreebays;
    }

    public void setInfluence(int tinfluence) {
        this.Influence = tinfluence;
    }

    public void setRating(double trating) {
        this.Rating = trating;
    }

    public void setHouse(String faction) {
        this.myHouse = this.mwclient.getData().getHouseByName(faction);
        this.House = faction;
    }

    public String getHouse() {
        return this.House;
    }

    public void setProfession(String profession) {
        this.Profession = profession;
    }

    public String getInfo() {
        String tinfo = "";
        tinfo = "<font Color =\"black\"> Status for Player: " + this.Name + "<br>";
        tinfo = tinfo + "Profession: " + this.Profession + "<br>";
        tinfo = tinfo + "Member of Unit: " + this.House + "<br>";
        tinfo = tinfo + "Experience: " + this.Exp + "<br>";
        tinfo = tinfo + this.mwclient.moneyOrFluMessage(true, false, -this.Money) + ": " + this.Money + "<br>";
        tinfo = tinfo + "Contents of Hangar (" + this.FreeBays + "/" + this.Bays + " bays used):<br>";
        Iterator i = this.Hangar.iterator();
        while (i.hasNext()) {
            tinfo = tinfo + ((CUnit)i.next()).getInfo();
        }
        if (this.BMUnits.size() > 0) {
            tinfo = tinfo + "Units on Market:<br>";
            i = this.BMUnits.iterator();
            while (i.hasNext()) {
                tinfo = tinfo + ((CUnit)i.next()).getInfo() + "<br>";
            }
        }
        tinfo = tinfo + "</font>";
        return tinfo;
    }

    public String getName() {
        return this.Name;
    }

    public String getProfession() {
        return this.Profession;
    }

    public int getExp() {
        return this.Exp;
    }

    public double getRating() {
        return this.Rating;
    }

    public int getRewardPoints() {
        return this.RewardPoints;
    }

    public int getMoney() {
        return this.Money;
    }

    public int getBays() {
        return this.Bays;
    }

    public int getFreeBays() {
        return this.FreeBays;
    }

    public int getInfluence() {
        return this.Influence;
    }

    public int getTechs() {
        return this.Techs;
    }

    @Override
    public void setTechnicians(int tech) {
        this.Techs = tech;
        this.doPayTechniciansMath(this.Techs);
    }

    public int getTechCost() {
        if (this.TechCost < 0) {
            return 0;
        }
        return this.TechCost;
    }

    public Vector getHangar() {
        return this.Hangar;
    }

    protected int getFreeArmyID() {
        TreeMap<Integer, CArmy> TM = new TreeMap<Integer, CArmy>();
        CArmy lance2 = null;
        int id = -1;
        if (this.Armies.size() == 0) {
            return 0;
        }
        for (CArmy lance2 : this.Armies) {
            TM.put(new Integer(lance2.getID()), lance2);
        }
        Object[] lances = TM.values().toArray();
        id = ((CArmy)lances[0]).getID();
        for (int i = 1; i < lances.length; ++i) {
            lance2 = (CArmy)lances[i];
            if (lance2.getID() > id + 1) {
                return id + 1;
            }
            id = lance2.getID();
        }
        return id + 1;
    }

    protected int getFreeUnitID() {
        TreeMap<Integer, CUnit> TM = new TreeMap<Integer, CUnit>();
        CUnit unit2 = null;
        int id = -1;
        if (this.Hangar.size() == 0) {
            return 0;
        }
        for (CUnit unit2 : this.Hangar) {
            TM.put(new Integer(unit2.getId()), unit2);
        }
        Object[] hangar = TM.values().toArray();
        id = ((CUnit)hangar[0]).getId();
        for (int i = 1; i < hangar.length; ++i) {
            unit2 = (CUnit)hangar[i];
            if (unit2.getId() > id + 1) {
                return id + 1;
            }
            id = unit2.getId();
        }
        return id + 1;
    }

    public int getNextNewArmyID() {
        int newID = -1;
        int possibleNewID = 0;
        while (newID == -1) {
            for (int i = 0; i < this.Armies.size(); ++i) {
                if (this.Armies.get(i).getID() != possibleNewID) continue;
                newID = i;
            }
            if (newID == -1) {
                newID = possibleNewID;
                continue;
            }
            ++possibleNewID;
            newID = -1;
        }
        return newID;
    }

    public Vector getAllShortMeks(boolean c3) {
        Vector longList = new Vector(this.Hangar);
        Vector<CShortUnit> result = new Vector<CShortUnit>();
        Iterator i = longList.iterator();
        while (i.hasNext()) {
            result.add(new CShortUnit((CUnit)i.next(), c3));
        }
        int newID = this.getNextNewArmyID();
        for (int i2 = 0; i2 < this.Hangar.size(); ++i2) {
            ((CShortUnit)result.get(i2)).setHttpCommandString("/c exm#" + newID + ",-1#" + ((CUnit)this.Hangar.get(i2)).getId());
        }
        return result;
    }

    int getBiggestLance() {
        if (this.Armies.size() == 0) {
            return -1;
        }
        int biggestLance = 0;
        for (int i = 0; i < this.Armies.size(); ++i) {
            if (this.Armies.get(i).getUnits().size() < this.Armies.get(biggestLance).getUnits().size()) continue;
            biggestLance = i;
        }
        return biggestLance;
    }

    void getPossibleLances_Rec(int size, int unitCount, Vector allMeks, String soFar, String httpStringSoFar, int soFarBV, Vector result, int targetBV, int range) {
        if (size < 0) {
            return;
        }
        if (unitCount == 0) {
            if (Math.abs(soFarBV - targetBV) <= range) {
                result.add(new CShortUnit(soFar, soFarBV, httpStringSoFar));
            }
            return;
        }
        for (int i = size - 1; i >= 0; --i) {
            String newOne = soFar + ((CShortUnit)allMeks.get(i)).getDescription() + "; ";
            String newHttpString = httpStringSoFar + ((CShortUnit)allMeks.get(i)).getHttpCommandString() + "\n";
            this.getPossibleLances_Rec(i, unitCount - 1, allMeks, newOne, newHttpString, soFarBV += ((CShortUnit)allMeks.get(i)).getBV(), result, targetBV, range);
            soFarBV -= ((CShortUnit)allMeks.get(i)).getBV();
        }
    }

    public String getPossibleLances(int targetBV, int unitCount, int range, boolean c3) {
        int i;
        Vector allMeks = this.getAllShortMeks(c3);
        int upper = 0;
        int lower = 0;
        int min = targetBV - range;
        int max = targetBV + range;
        Collections.sort(allMeks);
        if (allMeks.size() < unitCount) {
            return "I guess you would be happy with so many units.<br>";
        }
        for (i = 0; i < unitCount - 1; ++i) {
            min -= ((CShortUnit)allMeks.get(allMeks.size() - 1 - i)).getBV();
        }
        if (min > 0) {
            CShortUnit minMek = new CShortUnit("Min-Dummy", min, "");
            lower = Collections.binarySearch(allMeks, minMek);
            if (lower < 0) {
                lower = -(lower + 1);
            }
            allMeks = new Vector(allMeks.subList(lower, allMeks.size()));
        }
        if (allMeks.size() < unitCount) {
            return "No units coming close to it.<br>";
        }
        for (i = 0; i < unitCount - 1; ++i) {
            max -= ((CShortUnit)allMeks.get(i)).getBV();
        }
        if (max > 0) {
            CShortUnit maxMek = new CShortUnit("Min-Dummy", max, "");
            upper = Collections.binarySearch(allMeks, maxMek);
            if (upper < 0) {
                upper = -upper;
            }
            if (upper < allMeks.size()) {
                allMeks = new Vector(allMeks.subList(0, upper));
            }
        }
        if (allMeks.size() < unitCount) {
            return "No units coming close to it.<br>";
        }
        Vector result = new Vector();
        this.getPossibleLances_Rec(allMeks.size(), unitCount, allMeks, "", "", 0, result, targetBV, range);
        if (result.size() <= 0) {
            return "Sorry no combinations at the given BV.<br>";
        }
        Collections.sort(result);
        for (int i2 = 0; i2 < result.size() - 1; ++i2) {
            int compareTo = i2 + 1;
            while (compareTo < result.size() && ((CShortUnit)result.get(i2)).getBV() == ((CShortUnit)result.get(compareTo)).getBV()) {
                if (((CShortUnit)result.get(i2)).equals(result.get(compareTo))) {
                    result.removeElementAt(compareTo);
                    continue;
                }
                ++compareTo;
            }
        }
        String stringResult = "<font color=\"#ff0000\"> Lance Options with BV " + targetBV + " (" + (targetBV - range) + "-" + (targetBV + range) + "): </font> <br>";
        CShortUnit targetBVMek = new CShortUnit("targetBV-Dummy", targetBV, "");
        int bestApprox = Collections.binarySearch(result, targetBVMek);
        if (bestApprox < 0) {
            bestApprox = -(bestApprox + 1);
        }
        if (bestApprox >= result.size()) {
            bestApprox = result.size() - 1;
        }
        String httpPrefix = "<a href=\"MEKWARS/c cra#" + this.mwclient.getConfigParam("DEFAULTARMYNAME") + "\n";
        for (int i3 = 0; i3 < result.size(); ++i3) {
            CShortUnit next = (CShortUnit)result.get(i3);
            stringResult = i3 == bestApprox ? stringResult + "<font color=\"#008000\">" : stringResult + "<font color=\"#000000\">";
            stringResult = stringResult + httpPrefix + next.getHttpCommandString() + "\"> BV " + next.getBV() + ": " + next.getDescription() + "\t Usefullness: " + "</a><br>";
            stringResult = stringResult + "</font>";
        }
        return stringResult;
    }

    public Vector getBMUnits() {
        return this.BMUnits;
    }

    public void setAutoArmy(StringTokenizer st) {
        this.AutoArmy = new Vector();
        if (st == null) {
            return;
        }
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            String filename = "";
            int weightclass = Integer.parseInt(next);
            filename = 0 == weightclass ? this.mwclient.getserverConfigs("LightArtilleryFile") : (1 == weightclass ? this.mwclient.getserverConfigs("MediumArtilleryFile") : (2 == weightclass ? this.mwclient.getserverConfigs("HeavyArtilleryFile") : this.mwclient.getserverConfigs("AssaultArtilleryFile")));
            int distInBoards = Integer.parseInt(this.mwclient.getserverConfigs("DistanceFromMap"));
            int distInHexes = distInBoards * 17;
            CUnit currUnit = new CUnit(this);
            currUnit.setAutoUnitData(filename, distInHexes);
            this.AutoArmy.add(currUnit);
        }
    }

    public Vector getAutoArmy() {
        return this.AutoArmy;
    }

    public CUnit getUnit(int unitID) {
        CUnit unit2 = null;
        for (CUnit unit2 : this.Hangar) {
            if (unit2.getId() != unitID) continue;
            return unit2;
        }
        return null;
    }

    public int getUnitCount() {
        int tcount = 0;
        tcount += this.Hangar.size();
        for (CArmy lance : this.Armies) {
            Iterator<Unit> j = lance.getUnits().iterator();
            while (j.hasNext()) {
                if (!((CUnit)j.next()).isOk()) continue;
                ++tcount;
            }
        }
        return tcount += this.BMUnits.size();
    }

    public CArmy getArmy(int id) {
        CArmy lance2 = null;
        for (CArmy lance2 : this.Armies) {
            if (lance2.getID() != id) continue;
            return lance2;
        }
        return null;
    }

    public int getAmountOfTimesUnitExistsInArmies(int unitID) {
        int result = 0;
        Vector<CArmy> v = this.getArmies();
        for (int i = 0; i < v.size(); ++i) {
            Army a = v.elementAt(i);
            if (a.getUnit(unitID) == null) continue;
            ++result;
        }
        return result;
    }

    public String getArmiesUnitIsIn(int unitID) {
        String result = "";
        Vector<CArmy> v = this.getArmies();
        for (int i = 0; i < v.size(); ++i) {
            Army a = v.elementAt(i);
            if (a.getUnit(unitID) == null) continue;
            result = result + a.getID() + " ";
        }
        return result;
    }

    public synchronized Vector getLockedUnits() {
        Vector<Unit> result = new Vector<Unit>();
        for (CArmy l : this.Armies) {
            if (!l.isLocked()) continue;
            result.addAll(l.getUnits());
        }
        return result;
    }

    public synchronized Vector getLockedEntities() {
        Vector<Unit> result = new Vector<Unit>();
        for (CArmy l : this.Armies) {
            if (!l.isLocked()) continue;
            result.addAll(l.getUnits());
        }
        return result;
    }

    public Vector getEntities() {
        return null;
    }

    public boolean canAfford(int ttype, int tweightclass, boolean tused) {
        return this.Money >= CUnit.getPrice(ttype, tweightclass, tused);
    }

    public int getBiggestArmySize() {
        Enumeration<CArmy> en = this.Armies.elements();
        int max = 0;
        while (en.hasMoreElements()) {
            CArmy army = en.nextElement();
            if (army.getAmountOfUnits() <= max) continue;
            max = army.getAmountOfUnits();
        }
        return max;
    }

    public int doPayTechniciansMath(int techsToPay) {
        if (techsToPay <= 0) {
            this.TechCost = 0;
            return 0;
        }
        boolean isAdditive = Boolean.valueOf(this.mwclient.getserverConfigs("UseAdditiveTechCosts"));
        boolean isLogarithmic = Boolean.valueOf(this.mwclient.getserverConfigs("UseLogarithmicTechCosts"));
        boolean isSupplyAndDemand = Boolean.valueOf(this.mwclient.getserverConfigs("UseSupplyAndDemandTechCosts"));
        double amountToPay = 0.0;
        if (isAdditive) {
            double additive = Double.parseDouble(this.mwclient.getserverConfigs("AdditivePerTech"));
            double ceiling = Double.parseDouble(this.mwclient.getserverConfigs("AdditiveCostCeiling"));
            int techCeiling = (int)(ceiling / additive);
            if (techsToPay > techCeiling) {
                int techsPastCeiling = techsToPay - techCeiling;
                amountToPay += ceiling * (double)techsPastCeiling;
            }
            int techsUsingAdditive = 0;
            techsUsingAdditive = techsToPay > techCeiling ? techCeiling : techsToPay;
            int totalAdditions = 0;
            for (int i = 1; i <= techsUsingAdditive; ++i) {
                totalAdditions += i;
            }
            amountToPay += (double)totalAdditions * additive;
        }
        if (isLogarithmic) {
            // empty if block
        }
        if (isSupplyAndDemand) {
            // empty if block
        }
        this.TechCost = (int)amountToPay;
        return (int)amountToPay;
    }

    public int doPayTechniciansMath() {
        return this.doPayTechniciansMath(this.Techs);
    }

    public void addArmyUnit(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            int unitid = Integer.parseInt(ST.nextToken());
            int bv = Integer.parseInt(ST.nextToken());
            if (ST.hasMoreElements()) {
                int position = Integer.parseInt(ST.nextToken());
                this.getArmy(army).addUnit(this.getUnit(unitid), position);
            } else {
                this.getArmy(army).addUnit(this.getUnit(unitid));
            }
            this.getArmy(army).setBV(bv);
        }
    }

    public void removeArmyUnit(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            int unitid = Integer.parseInt(ST.nextToken());
            int bv = Integer.parseInt(ST.nextToken());
            Vector<Unit> v = this.getArmy(army).getUnits();
            for (int i = 0; i < v.size(); ++i) {
                CUnit unit = (CUnit)v.elementAt(i);
                if (unit.getId() != unitid) continue;
                this.getArmy(army).getUnits().removeElementAt(i);
                break;
            }
            this.getArmy(army).setBV(bv);
        }
        this.mwclient.refreshGUI(MWClient.REFRESH_HQPANEL);
    }

    public void updateOperations(String data) {
        StringTokenizer tokenizer = new StringTokenizer(data, "*");
        int armyID = Integer.parseInt(tokenizer.nextToken());
        CArmy army = this.getArmy(armyID);
        if (army == null) {
            return;
        }
        while (tokenizer.hasMoreTokens()) {
            String mode = "";
            String name = "";
            try {
                mode = tokenizer.nextToken();
                name = tokenizer.nextToken();
            }
            catch (NoSuchElementException e) {
                return;
            }
            if (mode.equals("a")) {
                army.getLegalOperations().put(name, name);
                continue;
            }
            if (!mode.equals("r")) continue;
            army.getLegalOperations().remove(name);
        }
        this.mwclient.getMainFrame().updateAttackMenu();
    }

    public void repositionArmyUnit(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        int army = Integer.parseInt(ST.nextToken());
        int unitid = Integer.parseInt(ST.nextToken());
        int position = Integer.parseInt(ST.nextToken());
        CArmy a = this.getArmy(army);
        Vector<Unit> v = a.getUnits();
        for (int i = 0; i < v.size(); ++i) {
            CUnit unit = (CUnit)v.elementAt(i);
            if (unit.getId() != unitid) continue;
            a.getUnits().removeElementAt(i);
            break;
        }
        this.getArmy(army).addUnit(this.getUnit(unitid), position);
    }

    public void setUnitMaintenance(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int unitid = Integer.parseInt(ST.nextToken());
            int status = Integer.parseInt(ST.nextToken());
            this.getUnit(unitid).setStatus(status);
        }
    }

    public void setArmyName(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            String name = ST.nextToken();
            this.getArmy(army).setName(name);
        }
    }

    public void setArmyLimit(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            int lowerLimit = Integer.parseInt(ST.nextToken());
            int upperLimit = Integer.parseInt(ST.nextToken());
            this.getArmy(army).setLowerLimiter(lowerLimit);
            this.getArmy(army).setUpperLimiter(upperLimit);
        }
    }

    public void setArmyLock(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        if (ST.hasMoreTokens()) {
            int army = Integer.parseInt(ST.nextToken());
            boolean lock = Boolean.valueOf(ST.nextToken());
            this.getArmy(army).setLocked(lock);
        }
    }

    public void setPlayerPersonalPilotQueue(CPersonalPilotQueues queue) {
        this.personalPilotQueue = queue;
    }

    public CPersonalPilotQueues getPlayerPersonalPilotQueue() {
        return this.personalPilotQueue;
    }

    public void addUnitBM(int unitid) {
        this.getBMUnits().add(this.getUnit(unitid));
    }

    public void RemoveUnitBM(int unitid) {
        this.getBMUnits().remove(this.getUnit(unitid));
    }

    public void setAdminExcludes(String buffer, String token) {
        this.adminExcludes.clear();
        StringTokenizer ST = new StringTokenizer(buffer, token);
        while (ST.hasMoreElements()) {
            String curr = ST.nextToken();
            if (curr.equals("0")) continue;
            this.adminExcludes.add(curr);
        }
        this.mwclient.getMainFrame().getMainPanel().getUserListPanel().repaint();
    }

    public void setPlayerExcludes(String buffer, String token) {
        MWClient.mwClientLog.clientErrLog("setPlayerExcludes called.");
        this.playerExcludes.clear();
        StringTokenizer ST = new StringTokenizer(buffer, token);
        while (ST.hasMoreElements()) {
            String curr = ST.nextToken();
            if (curr.equals("0")) continue;
            this.playerExcludes.add(curr);
        }
        this.mwclient.getMainFrame().getMainPanel().getUserListPanel().repaint();
    }

    public Vector getAdminExcludes() {
        return this.adminExcludes;
    }

    public Vector getPlayerExcludes() {
        return this.playerExcludes;
    }

    public void sortHangar() {
        String primeSortOrder = this.mwclient.getConfigParam("PRIMARYHQSORTORDER");
        String secondarySortOrder = this.mwclient.getConfigParam("SECONDARYHQSORTORDER");
        String tertiarySortOrder = this.mwclient.getConfigParam("TERTIARYHQSORTORDER");
        String[] choices = new String[]{"Name", "Battle Value", "Gunnery Skill", "ID Number", "MP (Jumping)", "MP (Walking)", "Pilot Kills", "Unit Type", "Weight (Class)", "Weight (Tons)", "No Sort"};
        int primarySort = 10;
        for (int i = 0; i < choices.length; ++i) {
            if (!primeSortOrder.equals(choices[i])) continue;
            primarySort = i;
        }
        int secondarySort = 10;
        for (int i = 0; i < choices.length; ++i) {
            if (!secondarySortOrder.equals(choices[i])) continue;
            secondarySort = i;
        }
        int tertiarySort = 10;
        for (int i = 0; i < choices.length; ++i) {
            if (!tertiarySortOrder.equals(choices[i])) continue;
            tertiarySort = i;
        }
        Object[] unitsArray = this.Hangar.toArray();
        if (tertiarySort != primarySort && tertiarySort != secondarySort && tertiarySort != 10) {
            Arrays.sort(unitsArray, new CUnitComparator(tertiarySort));
        }
        if (primarySort != secondarySort && secondarySort != 10) {
            Arrays.sort(unitsArray, new CUnitComparator(secondarySort));
        }
        if (primarySort != 10) {
            Arrays.sort(unitsArray, new CUnitComparator(primarySort));
        }
        Vector<Object> Hangar2 = new Vector<Object>();
        for (int i = 0; i < unitsArray.length; ++i) {
            Hangar2.add(unitsArray[i]);
        }
        this.Hangar = Hangar2;
        unitsArray = null;
    }

    public int getPriceForUnit(int weightclass, int type_id) {
        int result = Integer.MAX_VALUE;
        String classtype = CUnit.getWeightClassDesc(weightclass) + CUnit.getTypeClassDesc(type_id) + "Price";
        result = type_id == 0 ? Integer.parseInt(this.mwclient.getserverConfigs(CUnit.getWeightClassDesc(weightclass) + "Price")) : Integer.parseInt(this.mwclient.getserverConfigs(classtype));
        if ((result += this.myHouse.getHouseUnitPriceMod(type_id, weightclass)) < 0) {
            result = 0;
        }
        return result;
    }

    public int getInfluenceForUnit(int weightclass, int type_id) {
        int result = Integer.MAX_VALUE;
        String classtype = CUnit.getWeightClassDesc(weightclass) + CUnit.getTypeClassDesc(type_id) + "Inf";
        result = type_id == 0 ? Integer.parseInt(this.mwclient.getserverConfigs(CUnit.getWeightClassDesc(weightclass) + "Inf")) : Integer.parseInt(this.mwclient.getserverConfigs(classtype));
        return result;
    }

    public int getPPCost(int weight, int type_id) {
        int result = 0;
        if (type_id == 1) {
            result = Integer.parseInt(this.mwclient.getserverConfigs(CUnit.getWeightClassDesc(weight) + "VehiclePP"));
        } else if (type_id == 2) {
            result = Integer.parseInt(this.mwclient.getserverConfigs(CUnit.getWeightClassDesc(weight) + "InfantryPP"));
        } else if (type_id == 0) {
            result = Integer.parseInt(this.mwclient.getserverConfigs(CUnit.getWeightClassDesc(weight) + "PP"));
        } else if (type_id == 4) {
            result = Integer.parseInt(this.mwclient.getserverConfigs(CUnit.getWeightClassDesc(weight) + "BattleArmorPP"));
        } else if (type_id == 3) {
            result = Integer.parseInt(this.mwclient.getserverConfigs(CUnit.getWeightClassDesc(weight) + "ProtoMekPP"));
        }
        if ((result += this.myHouse.getHouseUnitComponentMod(type_id, weight)) < 1) {
            result = 1;
        }
        return result;
    }

    public int getHangarSpaceRequired(int typeid, int weightclass, int baymod, String model) {
        if (typeid == 3) {
            return 0;
        }
        if (typeid == 2 && Boolean.valueOf(this.mwclient.getserverConfigs("FootInfTakeNoBays")).booleanValue()) {
            boolean isFoot = model.startsWith("Foot");
            boolean isAMFoot = model.startsWith("Anti-Mech Foot");
            if (isFoot || isAMFoot) {
                return 0;
            }
        }
        int result = 1;
        String techAmount = "TechsFor" + CUnit.getWeightClassDesc(weightclass) + CUnit.getTypeClassDesc(typeid);
        result = Integer.parseInt(this.mwclient.getserverConfigs(techAmount));
        if ((result += baymod) < 0) {
            result = 0;
        }
        return result;
    }

    public House getMyHouse() {
        return this.myHouse;
    }
}

