/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import client.campaign.CArmy;
import client.campaign.CCampaign;
import client.campaign.CPlayer;
import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import common.campaign.pilot.skills.PilotSkill;
import common.util.UnitUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Mounted;

public class CUnit
extends Unit {
    public static String PREFIX = "UN";
    public static String DELIMITER = "$";
    public static final int LIGHT_PRICE = 10;
    public static final int MEDIUM_PRICE = 30;
    public static final int HEAVY_PRICE = 60;
    public static final int ASSAULT_PRICE = 80;
    public static final int LIGHT_PRICE_U = 5;
    public static final int MEDIUM_PRICE_U = 15;
    public static final int HEAVY_PRICE_U = 30;
    public static final int ASSAULT_PRICE_U = 40;
    public static final int LIGHT_PRICE_V = 5;
    public static final int MEDIUM_PRICE_V = 15;
    public static final int HEAVY_PRICE_V = 30;
    public static final int ASSAULT_PRICE_V = 40;
    public static final int LIGHT_PRICE_V_U = 3;
    public static final int MEDIUM_PRICE_V_U = 8;
    public static final int HEAVY_PRICE_V_U = 15;
    public static final int ASSAULT_PRICE_V_U = 20;
    CCampaign theCampaign;
    CPlayer thePlayer;
    Entity UnitEntity;
    int BV;
    int pilotBV = 0;
    CArmy myLance;
    Integer scrappableFor = new Integer(-1);

    public CUnit() {
        this.init();
    }

    public CUnit(CPlayer tplayer) {
        this.init();
        this.thePlayer = tplayer;
    }

    public CUnit(CCampaign tcampaign) {
        this.init();
        this.theCampaign = tcampaign;
    }

    private void init() {
        this.theCampaign = null;
        this.thePlayer = null;
        this.UnitEntity = null;
        this.BV = 0;
        this.myLance = null;
        this.setStatus(1);
        this.setProducer("unknown origin");
    }

    public boolean setData(String data) {
        String unitDamage = null;
        MWClient.mwClientLog.clientOutputLog("PDATA: " + data);
        StringTokenizer ST = new StringTokenizer(data, "$");
        String element = (String)ST.nextElement();
        if (!element.equals("CM")) {
            return false;
        }
        this.setUnitFilename(ST.nextToken());
        this.createEntity();
        if (this.UnitEntity == null) {
            MWClient.mwClientLog.clientErrLog("Cannot load entity!");
            return false;
        }
        this.getC3Type(this.UnitEntity);
        this.setId(Integer.parseInt((String)ST.nextElement()));
        this.setStatus(Integer.parseInt(ST.nextToken()));
        this.setProducer(ST.nextToken());
        String pilotname = "John Denver";
        int gunnery = 4;
        int piloting = 5;
        int exp = 0;
        Pilot p = null;
        StringTokenizer STR = new StringTokenizer(ST.nextToken(), "#");
        pilotname = STR.nextToken();
        exp = Integer.parseInt(STR.nextToken());
        gunnery = Integer.parseInt(STR.nextToken());
        piloting = Integer.parseInt(STR.nextToken());
        p = new Pilot(pilotname, gunnery, piloting);
        p.setExperience(exp);
        int skillAmount = Integer.parseInt(STR.nextToken());
        for (int i = 0; i < skillAmount; ++i) {
            PilotSkill skill = new PilotSkill(Integer.parseInt(STR.nextToken()), STR.nextToken(), Integer.parseInt(STR.nextToken()));
            if (skill.getName().equals("Weapon Specialist")) {
                p.setWeapon(STR.nextToken());
            }
            if (skill.getName().equals("Trait")) {
                p.setTraitName(STR.nextToken());
            }
            p.getSkills().add(skill);
        }
        if (STR.hasMoreElements()) {
            p.setKills(Integer.parseInt(STR.nextToken()));
        }
        int mmoptionsamount = Integer.parseInt(ST.nextToken());
        for (int i = 0; i < mmoptionsamount; ++i) {
            MegaMekPilotOption mo = new MegaMekPilotOption(ST.nextToken(), Boolean.valueOf(ST.nextToken()));
            p.addMegamekOption(mo);
        }
        this.setType(Integer.parseInt((String)ST.nextElement()));
        this.setType(this.getEntityType(this.UnitEntity));
        this.setPilot(p);
        this.BV = Integer.parseInt(ST.nextToken());
        if (this.BV < 0) {
            this.BV = 0;
        }
        this.setWeightclass(Integer.parseInt(ST.nextToken()));
        if (this.getType() == 0 || this.getType() == 1) {
            this.setWeightclass(this.getEntityWeight(this.UnitEntity));
        }
        this.setId(Integer.parseInt(ST.nextToken()));
        if (this.getModelName().startsWith("Error") || this.getModelName().startsWith("OMG")) {
            this.UnitEntity.setExternalId(this.getId());
            this.UnitEntity.setCrew(new megamek.common.Pilot(p.getName(), p.getGunnery(), p.getPiloting()));
            return true;
        }
        if (this.UnitEntity instanceof Mech) {
            ((Mech)this.UnitEntity).setAutoEject(Boolean.valueOf(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            try {
                int maxCrits = Integer.parseInt(ST.nextToken());
                Enumeration e = this.UnitEntity.getAmmo();
                for (int count = 0; count < maxCrits; ++count) {
                    int weaponType = Integer.parseInt(ST.nextToken());
                    String ammoName = ST.nextToken();
                    int shots = Integer.parseInt(ST.nextToken());
                    Mounted mWeapon = (Mounted)e.nextElement();
                    AmmoType at = this.getEntityAmmo(weaponType, ammoName);
                    mWeapon.changeAmmoType(at);
                    mWeapon.setShotsLeft(shots);
                }
            }
            catch (Exception ex) {
                return true;
            }
        }
        if (ST.hasMoreElements()) {
            int maxMachineGuns = Integer.parseInt(ST.nextToken());
            int currentLocation = 0;
            Entity en = this.UnitEntity;
            Enumeration enWeapons = en.getWeapons();
            block5: for (int count = 0; count < maxMachineGuns; ++count) {
                int location = Integer.parseInt(ST.nextToken());
                boolean selection = Boolean.valueOf(ST.nextToken());
                while (enWeapons.hasMoreElements()) {
                    Mounted mWeapon = (Mounted)enWeapons.nextElement();
                    if (currentLocation == location) {
                        mWeapon.setRapidfire(selection);
                        ++currentLocation;
                        continue block5;
                    }
                    ++currentLocation;
                }
            }
        }
        if (ST.hasMoreElements()) {
            this.UnitEntity.setSpotlight(Boolean.valueOf(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.UnitEntity.setSpotlightState(Boolean.valueOf(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.pilotBV = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.UnitEntity.setTargSysType(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.scrappableFor = new Integer(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            unitDamage = ST.nextToken();
        }
        this.UnitEntity.setExternalId(this.getId());
        this.UnitEntity.setCrew(new megamek.common.Pilot(p.getName(), p.getGunnery(), p.getPiloting()));
        if (unitDamage != null) {
            UnitUtils.applyBattleDamage(this.UnitEntity, unitDamage);
        }
        return true;
    }

    public void setAutoUnitData(String filename, int distance) {
        this.setUnitFilename(filename);
        this.setPilot(new Pilot("Autopilot", 4, 5));
        this.createEntity();
        this.UnitEntity.setOffBoard(distance, 0);
    }

    public boolean setUnitData(String data) {
        StringTokenizer ST = new StringTokenizer(data, DELIMITER);
        String unitDamage = null;
        if (ST.hasMoreTokens() && ST.nextToken().equals(PREFIX)) {
            try {
                if (ST.hasMoreTokens()) {
                    this.setUnitFilename(ST.nextToken());
                }
                this.createEntity();
                if (this.UnitEntity == null) {
                    return false;
                }
                if (ST.hasMoreTokens()) {
                    this.setId(Integer.parseInt(ST.nextToken()));
                }
                if (ST.hasMoreTokens()) {
                    this.setStatus(Integer.parseInt(ST.nextToken()));
                }
                if (ST.hasMoreTokens()) {
                    this.setProducer(ST.nextToken());
                }
                String pilotname = "John Denver";
                int gunnery = 4;
                int piloting = 5;
                if (ST.hasMoreTokens()) {
                    pilotname = ST.nextToken();
                }
                if (ST.hasMoreTokens()) {
                    gunnery = Integer.parseInt(ST.nextToken());
                }
                if (ST.hasMoreTokens()) {
                    piloting = Integer.parseInt(ST.nextToken());
                }
                Pilot p = new Pilot(pilotname, gunnery, piloting);
                if (ST.hasMoreTokens()) {
                    p.setExperience(Integer.parseInt(ST.nextToken()));
                }
                int mmoptionsamount = Integer.parseInt(ST.nextToken());
                for (int i = 0; i < mmoptionsamount; ++i) {
                    MegaMekPilotOption mo = new MegaMekPilotOption(ST.nextToken(), Boolean.valueOf(ST.nextToken()));
                    p.addMegamekOption(mo);
                }
                int skillAmount = Integer.parseInt(ST.nextToken());
                for (int i = 0; i < skillAmount; ++i) {
                    PilotSkill skill = new PilotSkill(Integer.parseInt(ST.nextToken()), ST.nextToken(), Integer.parseInt(ST.nextToken()));
                    if (skill.getName().equals("Weapon Specialist")) {
                        p.setWeapon(ST.nextToken());
                    }
                    if (skill.getName().equals("Trait")) {
                        p.setTraitName(ST.nextToken());
                    }
                    p.getSkills().add(skill);
                }
                this.setPilot(p);
                if (ST.hasMoreTokens()) {
                    this.setType(Integer.parseInt(ST.nextToken()));
                }
                if (ST.hasMoreTokens()) {
                    this.BV = Integer.parseInt(ST.nextToken());
                }
                if (this.BV < 0) {
                    this.BV = 0;
                }
                if (ST.hasMoreTokens() && this.UnitEntity instanceof Mech) {
                    ((Mech)this.UnitEntity).setAutoEject(Boolean.valueOf(ST.nextToken()));
                }
                if (ST.hasMoreElements()) {
                    int maxCrits = Integer.parseInt(ST.nextToken());
                    Enumeration e = this.UnitEntity.getAmmo();
                    for (int count = 0; count < maxCrits; ++count) {
                        int weaponType = Integer.parseInt(ST.nextToken());
                        String ammoName = ST.nextToken();
                        int shots = Integer.parseInt(ST.nextToken());
                        Mounted mWeapon = (Mounted)e.nextElement();
                        AmmoType at = this.getEntityAmmo(weaponType, ammoName);
                        mWeapon.changeAmmoType(at);
                        mWeapon.setShotsLeft(shots);
                    }
                }
                if (ST.hasMoreElements()) {
                    int maxMachineGuns = Integer.parseInt(ST.nextToken());
                    int currentLocation = 0;
                    Entity en = this.UnitEntity;
                    Enumeration enWeapons = en.getWeapons();
                    block5: for (int count = 0; count < maxMachineGuns; ++count) {
                        int location = Integer.parseInt(ST.nextToken());
                        boolean selection = Boolean.valueOf(ST.nextToken());
                        while (enWeapons.hasMoreElements()) {
                            Mounted mWeapon = (Mounted)enWeapons.nextElement();
                            if (currentLocation == location) {
                                mWeapon.setRapidfire(selection);
                                ++currentLocation;
                                continue block5;
                            }
                            ++currentLocation;
                        }
                    }
                }
                if (ST.hasMoreElements()) {
                    this.UnitEntity.setSpotlight(Boolean.valueOf(ST.nextToken()));
                }
                if (ST.hasMoreElements()) {
                    this.UnitEntity.setSpotlightState(Boolean.valueOf(ST.nextToken()));
                }
                if (ST.hasMoreElements()) {
                    this.pilotBV = Integer.parseInt(ST.nextToken());
                }
                if (ST.hasMoreElements()) {
                    this.UnitEntity.setTargSysType(Integer.parseInt(ST.nextToken()));
                }
                if (ST.hasMoreElements()) {
                    this.scrappableFor = new Integer(ST.nextToken());
                }
                if (ST.hasMoreElements()) {
                    unitDamage = ST.nextToken();
                }
                this.setType(this.getEntityType(this.UnitEntity));
                if (this.getType() == 0 || this.getType() == 1) {
                    this.setWeightclass(this.getEntityWeight(this.UnitEntity));
                }
                this.UnitEntity.setExternalId(this.getId());
                this.UnitEntity.setCrew(new megamek.common.Pilot(p.getName(), p.getGunnery(), p.getPiloting()));
                if (unitDamage != null) {
                    UnitUtils.applyBattleDamage(this.UnitEntity, unitDamage);
                }
            }
            catch (Exception e) {
                MWClient.mwClientLog.clientErrLog(e);
                return false;
            }
            return true;
        }
        return false;
    }

    public String getUnitString() {
        String d = DELIMITER;
        String result = PREFIX + d + this.getUnitFilename() + d + this.getId() + d + this.getStatus() + d + this.getProducer() + d + this.getPilot().getName() + d;
        result = result + Integer.toString(this.getPilot().getGunnery()) + d + Integer.toString(this.getPilot().getPiloting()) + d + Integer.toString(this.getPilot().getExperience()) + d;
        result = result + this.getType() + d + Integer.toString(this.BV) + d;
        return result;
    }

    public boolean isDestroyed() {
        return this.checkStatus("destroyed");
    }

    public boolean isOk() {
        return this.checkStatus("ok");
    }

    public boolean checkStatus(String tstatus) {
        return this.getStatus() == 1;
    }

    public boolean isMek() {
        return this.getType() == 0;
    }

    public boolean isVehicle() {
        return this.getType() == 1;
    }

    public boolean isInfantry() {
        return this.getType() == 2;
    }

    public String getInfo() {
        String tinfo = "";
        if (this.UnitEntity == null) {
            return "";
        }
        tinfo = "#" + this.getId() + " " + this.UnitEntity.getChassis() + " (" + this.getModelName() + ") (" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ") [" + this.getPilot().getName() + ", " + this.getPilot().getExperience() + " EXP] " + this.getProducer() + ". BV: " + this.BV + "<br>";
        return tinfo;
    }

    public String getShortInfo() {
        String tinfo = "";
        tinfo = "[#" + this.getId() + "]" + this.getModelName();
        tinfo = this.isDestroyed() ? tinfo + " (KIA)" : (this.getType() == 0 || this.getType() == 1 ? tinfo + "(" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ")" : tinfo + "(" + this.getPilot().getGunnery() + ")");
        return tinfo;
    }

    public String getSmallDescription() {
        if (this.getType() == 0 || this.getType() == 1) {
            return this.getModelName() + " [" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + "]";
        }
        return this.getModelName() + " [" + this.getPilot().getGunnery() + "]";
    }

    public String getDisplayInfo(String armyText) {
        String capacity;
        String tinfo = "";
        tinfo = this.getType() == 0 && !this.UnitEntity.isOmni() ? "<html><body>#" + this.getId() + " " + this.UnitEntity.getChassis() + ", " + this.getModelName() : "<html><body>#" + this.getId() + " " + this.getModelName();
        tinfo = this.getType() == 0 || this.getType() == 1 ? tinfo + " (" + this.getPilot().getName() + ", " + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ") <br>" : tinfo + " (" + this.getPilot().getName() + ", " + this.getPilot().getGunnery() + ") <br>";
        tinfo = tinfo + "BV: " + this.BV + " // Exp: " + this.getPilot().getExperience() + " // Kills: " + this.getPilot().getKills() + "<br> ";
        if (this.getPilot().getSkills().size() > 0) {
            tinfo = tinfo + "Skills: ";
            tinfo = tinfo + this.getPilot().getSkillString(false);
            tinfo = tinfo + "<br>";
        }
        if (!armyText.equals("")) {
            tinfo = tinfo + armyText + "<br>";
        }
        if ((capacity = this.getEntity().getUnusedString()) != null && capacity.startsWith("Troops")) {
            capacity = capacity.substring(9);
            tinfo = tinfo + "Cargo: " + capacity + "<br>";
        }
        tinfo = tinfo + this.getProducer();
        tinfo = tinfo + "</body></html>";
        return tinfo;
    }

    public String getModelName() {
        if (!this.isMek()) {
            StringBuffer name = new StringBuffer(new StringTokenizer(this.getEntity().getShortNameRaw()).nextToken());
            name.append(" ").append(this.getEntity().getModel());
            return name.toString();
        }
        if (this.getEntity().isOmni()) {
            return this.UnitEntity.getChassis() + " " + this.UnitEntity.getModel();
        }
        return this.getEntity().getModel();
    }

    public int getBV() {
        if (this.BV < 0) {
            return 0;
        }
        return this.BV;
    }

    public int getBV(boolean c3) {
        if (c3) {
            return this.getOriginalBV(c3) + this.pilotBV;
        }
        if (this.BV < 0) {
            return 0;
        }
        return this.BV;
    }

    public Entity getEntity() {
        return this.UnitEntity;
    }

    public static int getPrice(int ttype, int tweightclass, boolean tused) {
        if (ttype == 0) {
            if (!tused) {
                if (tweightclass == 0) {
                    return 10;
                }
                if (tweightclass == 1) {
                    return 30;
                }
                if (tweightclass == 2) {
                    return 60;
                }
                if (tweightclass == 3) {
                    return 80;
                }
            } else {
                if (tweightclass == 0) {
                    return 5;
                }
                if (tweightclass == 1) {
                    return 15;
                }
                if (tweightclass == 2) {
                    return 30;
                }
                if (tweightclass == 3) {
                    return 40;
                }
            }
        }
        if (ttype == 1) {
            if (!tused) {
                if (tweightclass == 0) {
                    return 5;
                }
                if (tweightclass == 1) {
                    return 15;
                }
                if (tweightclass == 2) {
                    return 30;
                }
                if (tweightclass == 3) {
                    return 40;
                }
            } else {
                if (tweightclass == 0) {
                    return 3;
                }
                if (tweightclass == 1) {
                    return 8;
                }
                if (tweightclass == 2) {
                    return 15;
                }
                if (tweightclass == 3) {
                    return 20;
                }
            }
        }
        return 0;
    }

    public static String getWeightclassName(int tweightclass) {
        if (tweightclass == 0) {
            return "Light";
        }
        if (tweightclass == 1) {
            return "Medium";
        }
        if (tweightclass == 2) {
            return "Heavy";
        }
        if (tweightclass == 3) {
            return "Assault";
        }
        return "";
    }

    protected void createEntity() {
        this.UnitEntity = null;
        try {
            MechSummary ms = MechSummaryCache.getInstance().getMech(this.getUnitFilename());
            this.UnitEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
        }
        catch (Exception exep) {
            try {
                MWClient.mwClientLog.clientErrLog("Error loading unit: " + this.getUnitFilename() + ". Try replacing with OMG.");
                this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Meks.zip"), "Error OMG-UR-FD.hmp").getEntity();
            }
            catch (Exception exepe) {
                MWClient.mwClientLog.clientErrLog("Error unit failed to load. Exiting.");
                System.exit(1);
            }
        }
        this.setType(this.getEntityType(this.UnitEntity));
        this.getC3Type(this.UnitEntity);
    }

    protected void createEntityFromFilename(String fn) {
        this.UnitEntity = null;
        try {
            this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Meks.zip"), fn).getEntity();
        }
        catch (Exception ex) {
            try {
                this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Vehicles.zip"), fn).getEntity();
            }
            catch (Exception exe) {
                try {
                    this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Infantry.zip"), fn).getEntity();
                }
                catch (Exception exep) {
                    try {
                        MWClient.mwClientLog.clientErrLog("Error loading unit: " + fn + " - Try replacing with OMG.");
                        this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Meks.zip"), "Error OMG-UR-FD.hmp").getEntity();
                    }
                    catch (Exception exepe) {
                        MWClient.mwClientLog.clientErrLog("Error unit failed to load. Exiting.");
                        System.exit(1);
                    }
                }
            }
        }
        this.setType(this.getEntityType(this.UnitEntity));
        this.getC3Type(this.UnitEntity);
    }

    public boolean isOmni() {
        boolean isOmni = false;
        String targetChassis = this.getEntity().getChassis();
        if (this.getType() == 1) {
            try {
                FileInputStream fis = new FileInputStream("./data/mechfiles/omnivehiclelist.txt");
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                while (dis.ready()) {
                    String chassie = dis.readLine();
                    if (!targetChassis.equalsIgnoreCase(chassie)) continue;
                    isOmni = true;
                    break;
                }
                dis.close();
                fis.close();
            }
            catch (Exception exception) {}
        } else {
            isOmni = this.getEntity().isOmni();
        }
        return isOmni;
    }

    public int getOriginalBV(boolean C3Network) {
        return this.UnitEntity.calculateBattleValue(C3Network);
    }

    public String getShortenedMekFile() {
        return this.getUnitFilename().substring(0, this.getUnitFilename().indexOf("."));
    }
}

