/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import common.CampaignData;
import common.House;
import common.Planet;
import java.util.Vector;

public class MapHelper {
    private int width;
    private int height;
    private Vector planets;
    private Vector map;
    private double minx = 2.147483647E9;
    private double maxx = -2.147483648E9;
    private double miny = 2.147483647E9;
    private double maxy = -2.147483648E9;
    private double pixelworthx;
    private double pixelworthy;
    private double disttonext;
    private int calcdone = 0;

    public MapHelper(int width, int height, Vector planets) {
        this.width = width;
        this.height = height;
        this.planets = planets;
        for (Planet p : planets) {
            if (p.getPosition().x > this.maxx) {
                this.maxx = p.getPosition().x;
            }
            if (p.getPosition().x < this.minx) {
                this.minx = p.getPosition().x;
            }
            if (p.getPosition().y > this.maxy) {
                this.maxy = p.getPosition().y;
            }
            if (!(p.getPosition().y < this.miny)) continue;
            this.miny = p.getPosition().y;
        }
        this.pixelworthx = (this.maxx - this.minx) / (double)width;
        this.pixelworthy = (this.maxy - this.miny) / (double)height;
        MWClient.mwClientLog.clientOutputLog("X: " + this.minx + "/" + this.maxx + " -> " + this.pixelworthx);
        MWClient.mwClientLog.clientOutputLog("Y: " + this.miny + "/" + this.maxy + " -> " + this.pixelworthy);
    }

    public Vector getMap(CampaignData data) {
        this.map = new Vector();
        for (int i = 0; i < this.height; ++i) {
            Vector<String> line = new Vector<String>();
            for (int j = 0; j < this.width; ++j) {
                line.add("");
            }
            this.map.add(line);
        }
        double currentxpos = this.minx;
        double currentypos = this.miny;
        for (int currenty = 0; currenty < this.height; ++currenty) {
            currentypos = this.miny + this.pixelworthy * (double)currenty;
            for (int currentx = 0; currentx < this.width; ++currentx) {
                if (!this.getPoint(currentx, currenty).equals("")) continue;
                currentxpos = this.minx + this.pixelworthx * (double)currentx;
                Planet[] nextPlanets = this.getDistance(currentxpos, currentypos, data);
                House x = data.getHouse(nextPlanets[0].getInfluence().getOwner());
                this.setPoint(currentx, currenty, x.getHouseColor());
                int internalx = currentx + 1;
                while (this.disttonext > 2.0 * this.pixelworthx && internalx < this.width) {
                    this.setPoint(internalx, currenty, x.getHouseColor());
                    double tempdisttonext = this.disttonext;
                    for (int internaly = currenty + 1; tempdisttonext > 2.0 * this.pixelworthy && internaly < this.height; ++internaly, tempdisttonext -= 2.0 * this.pixelworthy) {
                        this.setPoint(internalx, internaly, x.getHouseColor());
                    }
                    ++internalx;
                    this.disttonext -= 2.0 * this.pixelworthx;
                }
            }
        }
        MWClient.mwClientLog.clientOutputLog("Calcs done: " + this.calcdone);
        return this.map;
    }

    private String getPoint(int x, int y) {
        Vector line = (Vector)this.map.elementAt(y);
        return (String)line.elementAt(x);
    }

    private void setPoint(int x, int y, String color) {
        Vector line = (Vector)this.map.elementAt(y);
        line.setElementAt(color, x);
    }

    private Planet[] getDistance(double x, double y, CampaignData data) {
        ++this.calcdone;
        Planet[] result = new Planet[2];
        double dist1 = Double.MAX_VALUE;
        double dist2 = Double.MAX_VALUE;
        for (int i = 0; i < this.planets.size(); ++i) {
            Planet c = (Planet)this.planets.elementAt(i);
            double dist = Math.sqrt(Math.pow(x - c.getPosition().x, 2.0) + Math.pow(y - c.getPosition().y, 2.0));
            if (dist < dist1) {
                if (result[0] != null) {
                    House hs = data.getHouse(c.getInfluence().getOwner());
                    House hs2 = data.getHouse(result[0].getInfluence().getOwner());
                    if (!hs.getHouseColor().equals(hs2.getHouseColor())) {
                        result[1] = result[0];
                        dist2 = dist1;
                    }
                } else {
                    result[1] = result[0];
                    dist2 = dist1;
                }
                result[0] = c;
                dist1 = dist;
                continue;
            }
            if (!(dist < dist2)) continue;
            result[1] = c;
            dist2 = dist;
        }
        this.disttonext = dist2 - dist1;
        return result;
    }
}

