/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CArmy;
import client.gui.dialog.PlanetNameDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.MenuKeyListener;

public class AttackMenu
extends JMenu
implements ActionListener {
    private MWClient mwclient;
    private int armyID;
    private String planetName;

    public AttackMenu(MWClient mwclient, int armyID, String planetName) {
        super("Attack");
        this.mwclient = mwclient;
        this.armyID = armyID;
        this.planetName = planetName;
    }

    public void updateMenuItems(boolean fullMenu) {
        JMenuItem currItem;
        String menuItemName;
        String color;
        String[] settings;
        String allOpsList;
        JMenuItem filler;
        this.removeAll();
        TreeMap<String, String[]> allOps = this.mwclient.getAllOps();
        if (this.armyID < 0) {
            TreeMap<String, String> allEligibles = new TreeMap<String, String>();
            for (CArmy currA : this.mwclient.getPlayer().getArmies()) {
                allEligibles.putAll(currA.getLegalOperations());
            }
            if (allEligibles.size() <= 0) {
                filler = new JMenuItem("None");
                this.add(filler);
            }
            for (String currName : allEligibles.keySet()) {
                if (!allOps.containsKey(currName)) {
                    MWClient.mwClientLog.clientErrLog("Error in updateMenuItems(): no _" + currName + "_ in allOps.");
                    allOpsList = "allOps contains: ";
                    for (String currO : allOps.keySet()) {
                        allOpsList = allOpsList + currO + " ";
                    }
                    MWClient.mwClientLog.clientErrLog(allOpsList);
                    continue;
                }
                settings = allOps.get(currName);
                color = settings[1];
                menuItemName = "";
                menuItemName = !fullMenu ? "<html><font color=" + color + ">" + currName + "</font></html>" : " - " + currName;
                currItem = new JMenuItem(menuItemName);
                currItem.addActionListener(this);
                currItem.setActionCommand(currName);
                this.add(currItem);
            }
        } else {
            CArmy clickArmy = this.mwclient.getPlayer().getArmy(this.armyID);
            if (clickArmy.getLegalOperations().size() <= 0) {
                filler = new JMenuItem("None");
                this.add(filler);
            }
            for (String currName : clickArmy.getLegalOperations().keySet()) {
                if (!allOps.containsKey(currName)) {
                    MWClient.mwClientLog.clientErrLog("Error in updateMenuItems(): no _" + currName + "_ in allOps.");
                    allOpsList = "allOps contains: ";
                    for (String currO : allOps.keySet()) {
                        allOpsList = allOpsList + currO + " ";
                    }
                    MWClient.mwClientLog.clientErrLog(allOpsList);
                    continue;
                }
                settings = allOps.get(currName);
                color = settings[1];
                menuItemName = "";
                menuItemName = !fullMenu ? "<html><font color=" + color + ">" + currName + "</font></html>" : " - " + currName;
                currItem = new JMenuItem(menuItemName);
                currItem.addActionListener(this);
                currItem.setActionCommand(currName);
                this.add(currItem);
            }
        }
        if (fullMenu) {
            int i;
            this.setText("Games");
            JMenuItem toAdd = new JMenuItem("Attacks:");
            MouseListener[] mouse = toAdd.getMouseListeners();
            FocusListener[] focus = toAdd.getFocusListeners();
            MenuKeyListener[] menukey = toAdd.getMenuKeyListeners();
            PropertyChangeListener[] property = toAdd.getPropertyChangeListeners();
            for (i = 0; i < mouse.length; ++i) {
                toAdd.removeMouseListener(mouse[i]);
            }
            for (i = 0; i < focus.length; ++i) {
                toAdd.removeFocusListener(focus[i]);
            }
            for (i = 0; i < menukey.length; ++i) {
                toAdd.removeFocusListener(focus[i]);
            }
            for (i = 0; i < property.length; ++i) {
                toAdd.removePropertyChangeListener(property[i]);
            }
            this.add((Component)toAdd, 0);
            this.add(new JSeparator());
            toAdd = new JMenuItem("Check Access");
            toAdd.addActionListener(this);
            toAdd.setActionCommand("cmdCheckAccess");
            this.add(toAdd);
            if (this.mwclient.getMyStatus() == MWClient.STATUS_FIGHTING) {
                toAdd = new JMenuItem("Cancel Game");
                toAdd.addActionListener(this);
                toAdd.setActionCommand("cmdCancelGames");
                this.add(toAdd);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String name = e.getActionCommand();
        if (name.equals("cmdCancelGames")) {
            this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c terminate");
            return;
        }
        if (name.equals("cmdCheckAccess")) {
            if (this.mwclient.getPlayer().getArmies().size() <= 0) {
                String toUser = "CH|CLIENT: It's impossible to check legality when you have no armies.";
                this.mwclient.doParseDataInput(toUser);
                return;
            }
            TreeSet<String> names = new TreeSet<String>();
            for (CArmy currArmy : this.mwclient.getPlayer().getArmies()) {
                names.add("#" + currArmy.getID() + " - BV: " + currArmy.getBV());
            }
            JComboBox<Object> armyCombo = new JComboBox<Object>(names.toArray());
            armyCombo.setEditable(false);
            JComboBox<Object> attackCombo = new JComboBox<Object>(this.mwclient.getAllOps().keySet().toArray());
            attackCombo.setEditable(false);
            JPanel holderPanel = new JPanel();
            holderPanel.setLayout(new BoxLayout(holderPanel, 1));
            holderPanel.add(armyCombo);
            holderPanel.add(attackCombo);
            JOptionPane jop = new JOptionPane(holderPanel, 3, -1);
            JDialog dlg = jop.createDialog(null, "Select army and attack type.");
            armyCombo.grabFocus();
            armyCombo.getEditor().selectAll();
            dlg.setVisible(true);
            this.armyID = Integer.parseInt(((String)armyCombo.getSelectedItem()).substring(1, 2));
            String attackName = (String)attackCombo.getSelectedItem();
            this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c checkarmyeligibility#" + this.armyID + "#" + attackName);
            return;
        }
        if (this.mwclient.getMyStatus() < MWClient.STATUS_ACTIVE) {
            String toUser = "CH|CLIENT: You must be active in order to initiate attacks.";
            this.mwclient.doParseDataInput(toUser);
            return;
        }
        if (this.mwclient.getMyStatus() == MWClient.STATUS_FIGHTING) {
            String toUser = "CH|CLIENT: You may not initiate an attack while you are in a game.";
            this.mwclient.doParseDataInput(toUser);
            return;
        }
        if (this.planetName.equals("-1")) {
            PlanetNameDialog planetdialog = new PlanetNameDialog(this.mwclient, "Select a planet to attack.");
            planetdialog.setVisible(true);
            this.planetName = planetdialog.getPlanetName();
            planetdialog.dispose();
            if (this.planetName == null || this.planetName.trim().length() == 0) {
                return;
            }
        }
        if (this.armyID < 0) {
            TreeSet<String> names = new TreeSet<String>();
            for (CArmy currArmy : this.mwclient.getPlayer().getArmies()) {
                if (!currArmy.getLegalOperations().containsKey(name)) continue;
                names.add("#" + currArmy.getID() + " - BV: " + currArmy.getBV());
            }
            JComboBox<Object> combo = new JComboBox<Object>(names.toArray());
            combo.setEditable(false);
            JOptionPane jop = new JOptionPane(combo, 3, -1);
            JDialog dlg = jop.createDialog(null, "Select an army.");
            combo.grabFocus();
            combo.getEditor().selectAll();
            dlg.setVisible(true);
            this.armyID = Integer.parseInt(((String)combo.getSelectedItem()).substring(1, 2));
            int value = (Integer)jop.getValue();
            if (value == 2) {
                return;
            }
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c attack#" + name + "#" + this.armyID + "#" + this.planetName);
    }
}

