/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CBMUnit;
import client.campaign.CCampaign;
import java.awt.Color;
import java.awt.Component;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class BlackMarketModel
extends AbstractTableModel {
    private static final long serialVersionUID = -783116408720137035L;
    public MWClient mwclient;
    CCampaign theCampaign;
    public TreeMap mechs;
    public TreeMap bids;
    public Object[] sortedMechs;
    public static final int MECH = 0;
    public static final int PILOT = 1;
    public static final int EXP = 2;
    public static final int SKILLS = 3;
    public static final int BV = 4;
    public static final int MIN = 5;
    public static final int AVG = 6;
    public static final int TICKS = 7;
    public static final int BID = 8;
    public static final int FASA = 9;
    public static final int AUCTION_ID = 10;
    final String[] columnNames = new String[]{"Unit", "Pilot", "EXP", "Skills", "BV", "Min", "Avg", "Ticks", "My Bid", "FASA-BV"};
    final String[] longValues = new String[]{"XXX-X-XXX", "X/X", "XXX", "XXXXXXXXX", "XXXX", "XXX", "XXX", "XXX", "XXX", "XXX"};

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public BlackMarketModel(MWClient client) {
        this.mwclient = client;
        this.theCampaign = this.mwclient.getCampaign();
        this.mechs = this.theCampaign.getBlackMarket();
        this.sortedMechs = this.mechs.values().toArray();
    }

    public void refreshModel() {
        this.sortedMechs = this.mechs.values().toArray();
        this.fireTableDataChanged();
    }

    public void initColumnSizes(JTable table) {
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        BlackMarketModel model = this;
        String[] longValues = model.longValues;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, longValues[i], false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
    }

    public int getRowCount() {
        return this.sortedMechs.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0) {
            return "";
        }
        if (row >= this.sortedMechs.length) {
            return "";
        }
        CBMUnit mm = (CBMUnit)this.sortedMechs[row];
        switch (col) {
            case 0: {
                return mm.getModelName();
            }
            case 3: {
                return mm.getSkills();
            }
            case 1: {
                if (mm.getType() == 0 || mm.getType() == 1) {
                    return mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting();
                }
                return new Integer(mm.getPilot().getGunnery()).toString();
            }
            case 4: {
                return new Integer(mm.getBV());
            }
            case 2: {
                return new Integer(mm.getPilot().getExperience());
            }
            case 5: {
                return new Integer(mm.getMinBid());
            }
            case 6: {
                return new Integer(mm.getAverage());
            }
            case 7: {
                return new Integer(mm.getTicks());
            }
            case 8: {
                if (mm.getBid() != -1) {
                    return new Integer(mm.getBid());
                }
                return null;
            }
            case 9: {
                return new Integer(mm.getEntity().calculateBattleValue());
            }
            case 10: {
                return new Integer(mm.getAuctionID());
            }
        }
        return "";
    }

    public Renderer getRenderer() {
        return new Renderer();
    }

    public class Renderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 5506902358006897558L;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component d = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel c = new JLabel();
            c.setOpaque(true);
            if (BlackMarketModel.this.mechs.size() < row || row < 0) {
                return c;
            }
            if (table.getModel().getValueAt(row, column) != null) {
                c.setText(table.getModel().getValueAt(row, column).toString());
            }
            c.setToolTipText("");
            CBMUnit mm = (CBMUnit)BlackMarketModel.this.mechs.get(table.getModel().getValueAt(row, 10));
            String description = "<html><body>#" + mm.getAuctionID() + " " + mm.getEntity().getChassis() + " (" + mm.getEntity().getModel() + ") [" + mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting() + "] <br>";
            if (!Boolean.valueOf(BlackMarketModel.this.mwclient.getserverConfigs("DisableMarketComments")).booleanValue() && !mm.getComment().equals("")) {
                description = description + "Comment: " + mm.getComment();
            }
            if (mm.getC3Level() > 0) {
                if (mm.getC3Level() == 1) {
                    description = description + "<br>C3 Slave";
                } else if (mm.getC3Level() == 2) {
                    description = description + "<br>C3 Master";
                } else if (mm.getC3Level() == 3) {
                    description = description + "<br>C3 Improved";
                }
            }
            if (!mm.getSkills().equals(" ")) {
                description = description + "<br>Skills: " + mm.getSkills();
            }
            description = description + "</body></html>";
            c.setToolTipText(description);
            if (isSelected) {
                c.setForeground(d.getForeground());
                c.setBackground(d.getBackground());
                return c;
            }
            if (mm.getSeller().equals(BlackMarketModel.this.mwclient.getPlayer().getName())) {
                c.setBackground(Color.lightGray);
            } else if (table.getModel().getValueAt(row, 8) != null) {
                c.setBackground(Color.green);
            } else {
                c.setBackground(Color.white);
            }
            return c;
        }
    }
}

