/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MMGame;
import client.MWClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class CBattlePanel
extends JPanel {
    private final MWClient mwclient;
    private final JTable BattleTable;
    private final MMGame.TableModel BattleTableModel;
    private final JScrollPane battleScrollPane;

    public CBattlePanel(MWClient client) {
        this.mwclient = client;
        this.setLayout(new BoxLayout(this, 1));
        this.BattleTableModel = new MMGame.TableModel(this.mwclient.getGameList());
        this.BattleTable = new JTable(this.BattleTableModel);
        this.BattleTable.setDefaultRenderer(Object.class, this.BattleTableModel.getRenderer());
        this.BattleTable.addMouseListener(new BattlePopupListener());
        this.BattleTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.BattleTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.BattleTable.getColumnModel().getColumn(1).setMaxWidth(50);
        this.BattleTable.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.BattleTable.getColumnModel().getColumn(2).setMaxWidth(90);
        this.BattleTable.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.BattleTable.getColumnModel().getColumn(4).setPreferredWidth(300);
        this.BattleTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CBattlePanel.this.mwclient.startClient(CBattlePanel.this.BattleTable.getSelectedRow(), true);
                }
            }
        });
        this.BattleTable.setSelectionMode(0);
        this.battleScrollPane = new JScrollPane(this.BattleTable);
        this.battleScrollPane.add((Component)this.BattleTable, null);
        this.battleScrollPane.setPreferredSize(new Dimension(640, 190));
        this.battleScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.battleScrollPane.getViewport().add((Component)this.BattleTable, null);
        this.add((Component)this.battleScrollPane, "North");
    }

    public JScrollPane getBattleScrollPane() {
        return this.battleScrollPane;
    }

    public JTable getBattleTable() {
        return this.BattleTable;
    }

    public MMGame.TableModel getBattleTableModel() {
        return this.BattleTableModel;
    }

    class BattlePopupListener
    extends MouseAdapter
    implements ActionListener {
        BattlePopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            if (e.isPopupTrigger()) {
                JMenuItem menuItem;
                MMGame curGame = (MMGame)((CBattlePanel)CBattlePanel.this).BattleTableModel.data.elementAt(CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                if (curGame.getCurrentPlayers().size() < curGame.getMaxPlayers() || CBattlePanel.this.mwclient.isMod()) {
                    menuItem = new JMenuItem("View game");
                    menuItem.setActionCommand("V|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    popup.add(menuItem);
                    if (curGame.getStatus().equals("Open")) {
                        menuItem = new JMenuItem("Join game");
                        menuItem.setActionCommand("J|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                    }
                } else {
                    menuItem = new JMenuItem("Game is full");
                    popup.add(menuItem);
                }
                if (curGame.getPlayerName().equals(CBattlePanel.this.mwclient.getUsername())) {
                    menuItem = new JMenuItem("Stop Hosting");
                    menuItem.setActionCommand("S|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    popup.add(menuItem);
                }
                if (curGame.getPlayerName().startsWith("[Dedicated]")) {
                    JMenu serviceMenu = new JMenu("Maintenance");
                    JMenu settingsMenu = new JMenu("Settings");
                    JMenu portMenu = new JMenu("Port");
                    JMenu prefixMenu = new JMenu("Prefix");
                    JMenu ownersMenu = new JMenu("Owners");
                    JMenu miscMenu = new JMenu("Misc");
                    JMenu autoRestartMenu = new JMenu("AutoRestart");
                    popup.addSeparator();
                    menuItem = new JMenuItem("Restart Dedicated");
                    menuItem.setActionCommand("RESTART|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    popup.add(menuItem);
                    menuItem = new JMenuItem("Load Autosave");
                    menuItem.setActionCommand("LOADAUTOSAVE|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    popup.add(menuItem);
                    popup.addSeparator();
                    menuItem = new JMenuItem("Reset Dedicated");
                    menuItem.setActionCommand("RESET|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Kill Dedicated");
                    menuItem.setActionCommand("DIE|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Start Dedicated");
                    menuItem.setActionCommand("START|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Stop Dedicated");
                    menuItem.setActionCommand("STOP|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Load Game");
                    menuItem.setActionCommand("LOADGAME|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Display Saved Games");
                    menuItem.setActionCommand("DSG|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Display MegaMek Log");
                    menuItem.setActionCommand("DMML|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Display Backup Logs");
                    menuItem.setActionCommand("DBUL|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Ping Dedicated");
                    menuItem.setActionCommand("PING|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    serviceMenu.add(menuItem);
                    menuItem = new JMenuItem("Current Owners");
                    menuItem.setActionCommand("OWNERS|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    ownersMenu.add(menuItem);
                    menuItem = new JMenuItem("Add Dedicated Owners");
                    menuItem.setActionCommand("ADDOWNERS|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    ownersMenu.add(menuItem);
                    menuItem = new JMenuItem("Clear Dedicated Owners");
                    menuItem.setActionCommand("CLEAROWNERS|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    ownersMenu.add(menuItem);
                    menuItem = new JMenuItem("Current Prefix");
                    menuItem.setActionCommand("GETPREFIX|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    prefixMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Prefix");
                    menuItem.setActionCommand("SETPREFIX|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    prefixMenu.add(menuItem);
                    menuItem = new JMenuItem("Current Port");
                    menuItem.setActionCommand("GETPORT|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    portMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Port");
                    menuItem.setActionCommand("SETPORT|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    portMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Name");
                    menuItem.setActionCommand("SETNAME|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    miscMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Comment");
                    menuItem.setActionCommand("SETCOMMENT|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    miscMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Max Players");
                    menuItem.setActionCommand("SETPLAYERS|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    miscMenu.add(menuItem);
                    menuItem = new JMenuItem("Current Saved Games Purge Days");
                    menuItem.setActionCommand("GSGPD|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    miscMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Saved Games Purge Days");
                    menuItem.setActionCommand("SSGPD|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    miscMenu.add(menuItem);
                    menuItem = new JMenuItem("Current Restart Count");
                    menuItem.setActionCommand("CURRENTRESTART|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    autoRestartMenu.add(menuItem);
                    menuItem = new JMenuItem("Set Dedicated Restart Count");
                    menuItem.setActionCommand("SETRESTART|" + CBattlePanel.this.BattleTable.rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    autoRestartMenu.add(menuItem);
                    settingsMenu.add(portMenu);
                    settingsMenu.add(ownersMenu);
                    settingsMenu.add(prefixMenu);
                    settingsMenu.add(miscMenu);
                    settingsMenu.add(autoRestartMenu);
                    serviceMenu.add(settingsMenu);
                    popup.add(serviceMenu);
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int result;
            String dedPrefix;
            MMGame curGame;
            int row;
            String s = actionEvent.getActionCommand();
            if (s.startsWith("V|")) {
                CBattlePanel.this.mwclient.startClient(Integer.parseInt(s.substring(s.indexOf(124) + 1)), false);
            }
            if (s.startsWith("J|")) {
                CBattlePanel.this.mwclient.startClient(Integer.parseInt(s.substring(s.indexOf(124) + 1)), true);
            }
            if (s.startsWith("S|")) {
                CBattlePanel.this.mwclient.getMainFrame().stopHost();
                CBattlePanel.this.mwclient.stopHost();
            }
            if (s.startsWith("RESTART|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to restart\n\r" + curGame.getPlayerName() + "?", "Restart?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "restart");
                }
            }
            if (s.startsWith("RESET|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to reset\n\r" + curGame.getPlayerName() + "?", "Reset?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "reset");
                }
            }
            if (s.startsWith("DIE|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to kill\n\r" + curGame.getPlayerName() + "?", "Kill?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "die");
                }
            }
            if (s.startsWith("START|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to start\n\r" + curGame.getPlayerName() + "?", "Start?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "start");
                }
            }
            if (s.startsWith("STOP|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to stop\n\r" + curGame.getPlayerName() + "?", "Stop?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "stop");
                }
            }
            if (s.startsWith("OWNERS|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "owners");
            }
            if (s.startsWith("CLEAROWNERS|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to clear the owners of\n\r" + curGame.getPlayerName() + "?", "Clear the owners?", 0);
                if (result == 0) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "clearowners");
                }
            }
            if (s.startsWith("ADDOWNERS|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                String result2 = JOptionPane.showInputDialog(new JFrame(), "Enter a list of owners you want to add to\n\r" + curGame.getPlayerName() + "\n\r(sperated by $)", "Add Owners", 2);
                if (result2 != null && result2.length() > 1) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "owner " + result2);
                }
            }
            if (s.startsWith("GETPREFIX|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + ",prefix");
            }
            if (s.startsWith("SETPREFIX|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                String result3 = JOptionPane.showInputDialog(new JFrame(), "Enter the new prefix for\n\r" + curGame.getPlayerName(), "Change Prefix", 2);
                if (result3 != null && result3.length() > 1) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "prefix " + result3);
                }
            }
            if (s.startsWith("GETPORT|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "port");
            }
            if (s.startsWith("SETPORT|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                String result4 = JOptionPane.showInputDialog(new JFrame(), "Enter a new port for\n\r" + curGame.getPlayerName(), "New Port", 2);
                if (result4 != null && result4.length() > 1) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "port " + result4);
                }
            }
            if (s.startsWith("GSGPD|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "savegamepurge");
            }
            if (s.startsWith("SSGPD|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                String result5 = JOptionPane.showInputDialog(new JFrame(), "Enter a new day for\n\r" + curGame.getPlayerName(), "New days out to purge", 2);
                if (result5 != null && result5.length() >= 1) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "savegamepurge " + result5);
                }
            }
            if (s.startsWith("PING|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "ping");
            }
            if (s.startsWith("DSG|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "displaysavedgames");
            }
            if (s.startsWith("DMML|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "displaymegameklog");
            }
            if (s.startsWith("DBUL|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "displaybackuplogs");
            }
            if (s.startsWith("LOADGAME|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                String result6 = null;
                result6 = JOptionPane.showInputDialog(new JFrame(), "Enter name of the save file on\n\r" + curGame.getPlayerName() + "\n\r(leave blank to load autosave.sav)", "Load Game", 2);
                if (result6 != null) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "loadgame " + result6);
                }
            }
            if (s.startsWith("LOADAUTOSAVE|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                int result7 = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to load the autosave game on\n\r" + curGame.getPlayerName() + "?", "Load Auto Saved Game?", 0);
                if (result7 == 0) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "loadautosave");
                }
            }
            if (s.startsWith("SETNAME|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                String result8 = JOptionPane.showInputDialog(new JFrame(), "Enter a new name for\n\r" + curGame.getPlayerName() + "\n\rNote: This will require the Ded to be killed and restarted to take place.", "New Name", 2);
                if (result8 != null && result8.length() > 1) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "name " + result8);
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "die");
                }
            }
            if (s.startsWith("SETCOMMENT|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                String result9 = JOptionPane.showInputDialog(new JFrame(), "Enter a new comment for\n\r" + curGame.getPlayerName(), "New Comment", 2);
                if (result9 != null && result9.length() > 1) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "comment " + result9);
                }
            }
            if (s.startsWith("SETPLAYERS|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                String result10 = JOptionPane.showInputDialog(new JFrame(), "Enter the max number of players for\n\r" + curGame.getPlayerName(), "New Players", 2);
                if (result10 != null && result10.length() > 0) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "players " + result10);
                }
            }
            if (s.startsWith("CURRENTRESTART|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "restartcount");
            }
            if (s.startsWith("SETRESTART|")) {
                row = Integer.parseInt(s.substring(s.indexOf(124) + 1));
                curGame = (MMGame)CBattlePanel.this.mwclient.getGameList().get(row);
                dedPrefix = curGame.getDedPrefix();
                String result11 = JOptionPane.showInputDialog(new JFrame(), "Enter a new restart count for\n\r" + curGame.getPlayerName(), "New Restart", 2);
                if (result11 != null && result11.length() >= 1) {
                    CBattlePanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + curGame.getPlayerName() + "," + dedPrefix + "restartcount " + result11);
                }
            }
        }
    }
}

