/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.CUser;
import client.MWClient;
import client.campaign.CArmy;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import client.gui.AttackMenu;
import client.gui.MechInfo;
import client.gui.SpringLayoutHelper;
import client.gui.dialog.AdvanceRepairDialog;
import client.gui.dialog.CamoSelectionDialog;
import client.gui.dialog.CustomUnitDialog;
import client.gui.dialog.MechDetailDisplay;
import common.Unit;
import common.campaign.pilot.Pilot;
import common.util.UnitUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import megamek.client.ui.AWT.MechTileset;
import megamek.common.Entity;
import megamek.common.Mech;

public class CHQPanel
extends JPanel {
    MWClient mwclient;
    CPlayer Player;
    public MekTableModel MekTable;
    protected MechTableMouseAdapter mouseAdapter;
    private GridBagConstraints gridBagConstraints;
    private JPanel pnlMeks;
    private JScrollPane spMeks;
    private JTable tblMeks;
    private JPanel pnlMeksBtns;
    private JButton btnAddLance;
    private JButton btnRemoveAllArmies;
    private JButton setCamoButton;
    private JButton newbieResetUnitsButton;
    private JPanel pnlMekIcon;
    private JButton btnShowMek;

    public CHQPanel(MWClient client) {
        this.mwclient = client;
        this.Player = this.mwclient.getPlayer();
        this.MekTable = new MekTableModel();
        this.mouseAdapter = new MechTableMouseAdapter();
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.gridheight = 2;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.ipadx = 5;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.init();
        this.refresh();
    }

    public void reinitialize() {
        this.removeAll();
        this.Player = this.mwclient.getPlayer();
        this.MekTable = new MekTableModel();
        this.mouseAdapter = new MechTableMouseAdapter();
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.gridheight = 2;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.ipadx = 5;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.init();
        this.refresh();
    }

    private void init() {
        this.pnlMeks = new JPanel();
        this.spMeks = new JScrollPane();
        this.tblMeks = new JTable();
        this.pnlMeksBtns = new JPanel();
        this.btnAddLance = new JButton();
        this.btnRemoveAllArmies = new JButton();
        this.setCamoButton = new JButton();
        this.newbieResetUnitsButton = new JButton();
        this.pnlMekIcon = new MechInfo(this.mwclient);
        this.btnShowMek = new JButton();
        this.setLayout(new GridBagLayout());
        this.createMeksPanel();
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.ipadx = 5;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlMeks, this.gridBagConstraints);
    }

    private void createMeksPanel() {
        this.pnlMeks.setLayout(new GridBagLayout());
        this.spMeks.setPreferredSize(new Dimension(300, 400));
        this.tblMeks.setBackground(new Color(255, 255, 255));
        this.tblMeks.setForeground(new Color(0, 0, 0));
        this.tblMeks.setAutoResizeMode(4);
        this.tblMeks.setDoubleBuffered(true);
        this.tblMeks.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10000));
        this.tblMeks.setPreferredScrollableViewportSize(new Dimension(300, 400));
        this.tblMeks.setPreferredSize(new Dimension(300, 400));
        this.tblMeks.setRowHeight(82);
        this.tblMeks.setRowSelectionAllowed(false);
        this.tblMeks.setColumnSelectionAllowed(false);
        this.tblMeks.setCellSelectionEnabled(true);
        this.tblMeks.setSelectionMode(0);
        this.tblMeks.setModel(this.MekTable);
        this.tblMeks.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.tblMeks.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < this.tblMeks.getColumnCount(); ++i) {
            this.tblMeks.getColumnModel().getColumn(i).setCellRenderer(this.MekTable.getRenderer());
        }
        this.tblMeks.addMouseListener(this.mouseAdapter);
        this.tblMeks.addMouseMotionListener(this.mouseAdapter);
        this.spMeks.setViewportView(this.tblMeks);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.ipadx = 5;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.pnlMeks.add((Component)this.spMeks, this.gridBagConstraints);
        this.pnlMeksBtns.setLayout(new BoxLayout(this.pnlMeksBtns, 1));
        this.makeButtons();
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.weightx = 1.0;
        this.pnlMeks.add((Component)this.pnlMeksBtns, this.gridBagConstraints);
    }

    public void refresh() {
        this.MekTable.refreshModel();
        this.tblMeks.setPreferredSize(new Dimension(this.tblMeks.getWidth(), this.tblMeks.getRowHeight() * this.MekTable.getRowCount()));
        this.tblMeks.revalidate();
    }

    private void btnRemoveAllArmiesActionPerformed(ActionEvent evt) {
        if (this.mwclient.getMyStatus() == MWClient.STATUS_LOGGEDIN) {
            Vector<CArmy> armies = this.mwclient.getPlayer().getArmies();
            Enumeration<CArmy> e = armies.elements();
            while (e.hasMoreElements()) {
                CArmy currArmy = e.nextElement();
                int id = currArmy.getID();
                this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c removearmy#" + id);
            }
        }
    }

    private void newbieResetUnitsButtonActionPerformed(ActionEvent evt) {
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c request#resetunits");
    }

    private void btnAddLanceActionPerformed(ActionEvent evt) {
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c cra#" + this.mwclient.getConfigParam("DEFAULTARMYNAME"));
    }

    private void setCamoButtonActionPerformed(ActionEvent evt) {
        CamoSelectionDialog camoDialog = new CamoSelectionDialog(new JFrame(), this.mwclient);
        camoDialog.setVisible(true);
    }

    public void makeButtons() {
        JPanel hqButtonSpring = new JPanel(new SpringLayout());
        this.pnlMeksBtns.removeAll();
        this.btnAddLance.setText("Create New Army");
        this.btnAddLance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CHQPanel.this.btnAddLanceActionPerformed(evt);
            }
        });
        hqButtonSpring.add(this.btnAddLance);
        this.btnRemoveAllArmies.setText("Remove All Armies");
        this.btnRemoveAllArmies.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CHQPanel.this.btnRemoveAllArmiesActionPerformed(evt);
            }
        });
        hqButtonSpring.add(this.btnRemoveAllArmies);
        int numButtons = 3;
        CUser user = this.mwclient.getUser(this.mwclient.getPlayer().getName());
        if (user != null && user.getHouse().equalsIgnoreCase(this.mwclient.getserverConfigs("NewbieHouseName"))) {
            this.newbieResetUnitsButton.setText("Reset Units");
            this.newbieResetUnitsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    CHQPanel.this.newbieResetUnitsButtonActionPerformed(evt);
                }
            });
            hqButtonSpring.add(this.newbieResetUnitsButton);
            ++numButtons;
        }
        this.setCamoButton.setText("Change Camo");
        this.setCamoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CHQPanel.this.setCamoButtonActionPerformed(evt);
            }
        });
        hqButtonSpring.add(this.setCamoButton);
        SpringLayoutHelper.setupSpringGrid(hqButtonSpring, 1, numButtons);
        this.pnlMeksBtns.add(hqButtonSpring);
        this.pnlMeksBtns.validate();
        this.pnlMeksBtns.repaint();
    }

    public class MekTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            int count = Integer.parseInt(CHQPanel.this.mwclient.getConfigParam("UNITAMOUNT")) + 1;
            return count;
        }

        public int getRowCount() {
            int hangarRows = this.getRowsForHangar();
            int armyRows = this.getRowsForArmies();
            return hangarRows + armyRows;
        }

        public int getRowsForArmy(CArmy army) {
            int toReturn = (int)Math.ceil((double)army.getAmountOfUnits() / (double)(this.getColumnCount() - 1));
            if (toReturn < 1) {
                return 1;
            }
            return toReturn;
        }

        public int getRowsForHangar() {
            int freebays = CHQPanel.this.Player.getFreeBays();
            if (freebays > 1) {
                freebays = 1;
            }
            if (freebays < 0) {
                freebays = 0;
            }
            return (int)Math.ceil((double)(freebays + CHQPanel.this.Player.getHangar().size()) / (double)(this.getColumnCount() - 1));
        }

        public int getRowsForArmies() {
            int total = 0;
            Enumeration<CArmy> e = CHQPanel.this.Player.getArmies().elements();
            while (e.hasMoreElements()) {
                CArmy currArmy = e.nextElement();
                total += this.getRowsForArmy(currArmy);
            }
            return total;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Army";
            }
            return "Unit " + col;
        }

        public Vector getHangerMechs() {
            return CHQPanel.this.Player.getHangar();
        }

        public Vector getArmies() {
            return CHQPanel.this.Player.getArmies();
        }

        public CArmy getArmyAt(int row) {
            Vector v = this.getArmies();
            for (int i = 0; i < v.size(); ++i) {
                int uses = this.getRowsForArmy((CArmy)v.elementAt(i));
                if (uses > row) {
                    return (CArmy)v.elementAt(i);
                }
                row -= uses;
            }
            return null;
        }

        public int getOffset(int row) {
            Vector v = this.getArmies();
            for (int i = 0; i < v.size(); ++i) {
                int uses = this.getRowsForArmy((CArmy)v.elementAt(i));
                if (uses > row) {
                    return row * (this.getColumnCount() - 1);
                }
                row -= uses;
            }
            return 0;
        }

        public CUnit getMekAt(int row, int col) {
            if (row < 0) {
                return null;
            }
            if (col != 0) {
                if (row < this.getRowsForArmies()) {
                    CArmy army = this.getArmyAt(row);
                    Vector<Unit> mechs = new Vector<Unit>(army.getUnits());
                    int offset = this.getOffset(row) + col - 1;
                    if (offset < mechs.size()) {
                        return (CUnit)mechs.elementAt(offset);
                    }
                    return null;
                }
                int hangernum = (row - this.getRowsForArmies()) * (this.getColumnCount() - 1) + col - 1;
                if (hangernum >= 0 && hangernum < CHQPanel.this.Player.getHangar().size()) {
                    return (CUnit)CHQPanel.this.Player.getHangar().elementAt(hangernum);
                }
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            if (row < 0) {
                return "";
            }
            if (col == 0) {
                if (row < this.getRowsForArmies()) {
                    String armyName;
                    CArmy army = this.getArmyAt(row);
                    if (this.getRowsForArmy(army) > 1) {
                        int rowsUsed = 0;
                        boolean shouldContinue = true;
                        Enumeration<CArmy> e = CHQPanel.this.Player.getArmies().elements();
                        while (e.hasMoreElements() && shouldContinue) {
                            CArmy currArmy = e.nextElement();
                            if (currArmy.getID() == army.getID() && rowsUsed != row) {
                                return "";
                            }
                            rowsUsed += this.getRowsForArmy(currArmy);
                        }
                    }
                    int lid = army.getID();
                    String range = "";
                    boolean limitsAllowed = Boolean.valueOf(CHQPanel.this.mwclient.getserverConfigs("AllowLimiters"));
                    if (limitsAllowed) {
                        range = army.getLowerLimiter() == -1 ? "No Lower" : (army.getAmountOfUnits() - army.getLowerLimiter() < 1 ? "1" : "" + (army.getAmountOfUnits() - army.getLowerLimiter()));
                        range = range + " - ";
                        range = army.getUpperLimiter() == -1 ? range + "No Upper" : range + "" + (army.getAmountOfUnits() + army.getUpperLimiter());
                        if (army.getLowerLimiter() == -1 && army.getUpperLimiter() == -1) {
                            range = "No Limits";
                        }
                    }
                    if ((armyName = army.getName()).length() > 11) {
                        armyName = armyName.substring(0, 11);
                    }
                    String toReturn = "<html><center><b>Army #" + new Integer(lid) + "</b><br>";
                    boolean fakeName = false;
                    if (armyName.equals("") || armyName.equals(" ")) {
                        fakeName = true;
                    } else if (armyName.toLowerCase().equals("no name")) {
                        fakeName = true;
                    } else if (armyName.toLowerCase().equals("none")) {
                        fakeName = true;
                    } else if (armyName.toLowerCase().equals("clear")) {
                        fakeName = true;
                    } else if (armyName.toLowerCase().equals("untitled")) {
                        fakeName = true;
                    }
                    if (!fakeName) {
                        toReturn = armyName.length() > 10 ? toReturn + armyName.subSequence(0, 9) + "...<br>" : toReturn + armyName + "<br>";
                    }
                    toReturn = toReturn + "BV: " + army.getOperationsBV() + "<br>" + range + "</center></HTML>";
                    return toReturn;
                }
                return "Hangar";
            }
            CUnit cm = this.getMekAt(row, col);
            if (cm == null && row < this.getRowsForArmies()) {
                return " - ";
            }
            if (cm == null) {
                int hangernum = (row - this.getRowsForArmies()) * (this.getColumnCount() - 1) + col - 1;
                if (hangernum == CHQPanel.this.Player.getHangar().size()) {
                    return "Idle Techs: " + CHQPanel.this.mwclient.getPlayer().getFreeBays();
                }
                return "";
            }
            CArmy army = this.getArmyAt(row);
            String result = cm.getModelName();
            for (int i = 0; i < cm.getPilot().getSkills().size(); ++i) {
                result = result + "*";
            }
            if (army != null) {
                if (cm.hasBeenC3LinkedTo(army)) {
                    result = result + " |M|";
                } else if (army.getC3Network().get(new Integer(cm.getId())) != null) {
                    result = result + " |L|";
                }
            }
            return result;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void refreshModel() {
            this.fireTableDataChanged();
        }

        public Renderer getRenderer() {
            return new Renderer(CHQPanel.this.mwclient);
        }

        public class Renderer
        extends MechInfo
        implements TableCellRenderer {
            int meknum;
            MechTileset mt;
            Color dcolor;

            public Renderer(MWClient client) {
                super(client);
                this.mt = new MechTileset("data/images/units/");
                this.dcolor = new Color(220, 220, 220);
                try {
                    this.mt.loadFromFile("mechset.txt");
                }
                catch (IOException ex) {
                    MWClient.mwClientLog.clientErrLog("Unable to read data/images/units/mechset.txt");
                }
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                CUnit cm;
                Renderer c = this;
                this.setOpaque(true);
                this.setText(MekTableModel.this.getValueAt(row, column).toString());
                this.setToolTipText(null);
                ((Component)c).setBackground(this.dcolor);
                String scheme = this.mwclient.getConfig().getParam("HQCOLORSCHEME").toLowerCase();
                CArmy l = MekTableModel.this.getArmyAt(row);
                if (l != null) {
                    if (column == 0) {
                        this.setImageVisible(false);
                        if (l.isLocked()) {
                            ((Component)c).setBackground(new Color(235, 225, 5));
                        }
                        return c;
                    }
                } else if (column == 0) {
                    ((Component)c).setBackground(new Color(this.dcolor.getRed() - 33, this.dcolor.getBlue() - 33, this.dcolor.getGreen() - 7));
                    return c;
                }
                if ((cm = MekTableModel.this.getMekAt(row, column)) != null) {
                    int inNumberofArmies = CHQPanel.this.Player.getAmountOfTimesUnitExistsInArmies(cm.getId());
                    CUnit mek = MekTableModel.this.getMekAt(table.getSelectedRow(), table.getSelectedColumn());
                    String C3Text = "";
                    String description = "";
                    if (cm.getC3Level() > 0) {
                        if (cm.getC3Level() == 1) {
                            C3Text = "C3 Slave";
                        } else if (cm.getC3Level() == 2) {
                            C3Text = "C3 Master";
                        } else if (cm.getC3Level() == 4) {
                            C3Text = "C3 Dual Master";
                        } else if (cm.getC3Level() == 3) {
                            C3Text = "C3 Improved";
                        }
                        if (l != null && l.getC3Network().get(new Integer(cm.getId())) != null) {
                            Integer master = (Integer)l.getC3Network().get(new Integer(cm.getId()));
                            C3Text = cm.getC3Level() == 3 ? C3Text + " linked to #" + master : C3Text + " to #" + master;
                        }
                        if (l != null && cm.hasBeenC3LinkedTo(l)) {
                            C3Text = cm.getC3Level() == 3 ? C3Text + " master for" : C3Text + " for";
                            Enumeration c3Key = l.getC3Network().keys();
                            Enumeration c3Unit = l.getC3Network().elements();
                            while (c3Key.hasMoreElements()) {
                                Integer slave = (Integer)c3Key.nextElement();
                                Integer master = (Integer)c3Unit.nextElement();
                                if (master.intValue() != cm.getId()) continue;
                                C3Text = C3Text + " #" + slave;
                            }
                        }
                    }
                    if (inNumberofArmies > 1) {
                        String armiesText = "";
                        if (cm.getC3Level() > 0) {
                            armiesText = C3Text + "<br>";
                        }
                        armiesText = armiesText + "In armies " + CHQPanel.this.Player.getArmiesUnitIsIn(cm.getId());
                        description = cm.getDisplayInfo(armiesText);
                    } else {
                        description = cm.getDisplayInfo(C3Text);
                    }
                    this.setToolTipText(description);
                    this.setUnit(cm.getEntity());
                    this.setImageVisible(true);
                    boolean autorepair = Boolean.valueOf(this.mwclient.getserverConfigs("UseAdvanceRepair"));
                    if (autorepair && UnitUtils.hasCriticalDamage(cm.getEntity())) {
                        ((Component)c).setBackground(Color.red);
                    } else if (autorepair && UnitUtils.hasArmorDamage(cm.getEntity())) {
                        ((Component)c).setBackground(new Color(238, 238, 0));
                    } else if (cm.getStatus() == 3) {
                        ((Component)c).setBackground(new Color(190, 150, 55));
                    } else if (l == null && inNumberofArmies > 0) {
                        if (scheme.equals("classic")) {
                            ((Component)c).setBackground(new Color(65, 170, 55));
                        } else {
                            ((Component)c).setBackground(new Color(this.dcolor.getRed() - 43, this.dcolor.getBlue() - 33, this.dcolor.getGreen() - 4));
                        }
                    } else if (scheme.equals("tan")) {
                        switch (cm.getWeightclass()) {
                            case 0: {
                                ((Component)c).setBackground(new Color(this.dcolor.getRed() - 10, this.dcolor.getBlue() - 10, this.dcolor.getGreen() - 30));
                                break;
                            }
                            case 1: {
                                ((Component)c).setBackground(new Color(this.dcolor.getRed() - 30, this.dcolor.getBlue() - 30, this.dcolor.getGreen() - 50));
                                break;
                            }
                            case 2: {
                                ((Component)c).setBackground(new Color(this.dcolor.getRed() - 55, this.dcolor.getBlue() - 55, this.dcolor.getGreen() - 75));
                                break;
                            }
                            case 3: {
                                ((Component)c).setBackground(new Color(this.dcolor.getRed() - 75, this.dcolor.getBlue() - 75, this.dcolor.getGreen() - 95));
                            }
                        }
                    } else if (scheme.equals("grey")) {
                        switch (cm.getWeightclass()) {
                            case 0: {
                                ((Component)c).setBackground(this.dcolor);
                                break;
                            }
                            case 1: {
                                ((Component)c).setBackground(new Color(this.dcolor.getRed() - 17, this.dcolor.getBlue() - 17, this.dcolor.getGreen() - 17));
                                break;
                            }
                            case 2: {
                                ((Component)c).setBackground(new Color(this.dcolor.getRed() - 40, this.dcolor.getBlue() - 40, this.dcolor.getGreen() - 40));
                                break;
                            }
                            case 3: {
                                ((Component)c).setBackground(new Color(this.dcolor.getRed() - 65, this.dcolor.getBlue() - 65, this.dcolor.getGreen() - 65));
                            }
                        }
                    } else {
                        switch (cm.getWeightclass()) {
                            case 0: {
                                ((Component)c).setBackground(this.dcolor);
                                break;
                            }
                            case 1: {
                                ((Component)c).setBackground(new Color(this.dcolor.getRed() - 30, this.dcolor.getBlue() - 30, this.dcolor.getGreen() - 50));
                                break;
                            }
                            case 2: {
                                ((Component)c).setBackground(new Color(this.dcolor.getRed() - 65, this.dcolor.getBlue() - 65, this.dcolor.getGreen() - 25));
                                break;
                            }
                            case 3: {
                                ((Component)c).setBackground(new Color(this.dcolor.getRed() - 45, this.dcolor.getBlue() - 93, this.dcolor.getGreen() - 45));
                            }
                        }
                    }
                } else {
                    this.setImageVisible(false);
                    this.meknum = (row - MekTableModel.this.getRowsForArmies()) * MekTableModel.this.getColumnCount() - 1 + column;
                    int freebays = CHQPanel.this.Player.getFreeBays();
                    if (freebays < 0) {
                        freebays = 0;
                    }
                    if (this.meknum > freebays + CHQPanel.this.Player.getHangar().size()) {
                        this.setText("");
                    }
                }
                return c;
            }
        }
    }

    class MechTableMouseAdapter
    extends MouseInputAdapter
    implements ActionListener {
        private boolean isDrag;
        private MekTableModel tableModel;
        private Image dragImage;
        private Rectangle2D dragRect;
        private Point offset;
        private CUnit dragUnit = null;
        private CArmy startArmy = null;
        private CArmy currArmy = null;
        private Cursor exchangeCursor;
        private Cursor positionCursor;
        private Cursor addCursor;
        private Cursor removeCursor;
        private Cursor notAllowedCursor;
        private Cursor dupeCursor;
        private Cursor maxCursor;

        public MechTableMouseAdapter() {
            Image plusI = Toolkit.getDefaultToolkit().createImage("./data/images/hqadd.gif");
            Image minusI = Toolkit.getDefaultToolkit().createImage("./data/images/hqremove.gif");
            Image exchangeI = Toolkit.getDefaultToolkit().createImage("./data/images/hqexchange.gif");
            Image positionI = Toolkit.getDefaultToolkit().createImage("./data/images/hqposition.gif");
            Image notallowedI = Toolkit.getDefaultToolkit().createImage("./data/images/hqnotallowed.gif");
            Image dupeI = Toolkit.getDefaultToolkit().createImage("./data/images/hqdouble.gif");
            Image maxI = Toolkit.getDefaultToolkit().createImage("./data/images/hqmax.gif");
            this.addCursor = Toolkit.getDefaultToolkit().createCustomCursor(plusI, new Point(0, 0), "addcursor");
            this.removeCursor = Toolkit.getDefaultToolkit().createCustomCursor(minusI, new Point(0, 0), "removecursor");
            this.exchangeCursor = Toolkit.getDefaultToolkit().createCustomCursor(exchangeI, new Point(0, 0), "exchangecursor");
            this.positionCursor = Toolkit.getDefaultToolkit().createCustomCursor(positionI, new Point(0, 0), "positioncursor");
            this.notAllowedCursor = Toolkit.getDefaultToolkit().createCustomCursor(notallowedI, new Point(0, 0), "noallowedcursor");
            this.dupeCursor = Toolkit.getDefaultToolkit().createCustomCursor(dupeI, new Point(0, 0), "dupecursor");
            this.maxCursor = Toolkit.getDefaultToolkit().createCustomCursor(maxI, new Point(0, 0), "maxcursor");
        }

        public void mousePressed(MouseEvent e) {
            boolean isFirstButton = false;
            if (e.getButton() == 1) {
                isFirstButton = true;
            }
            int row = CHQPanel.this.tblMeks.rowAtPoint(e.getPoint());
            int col = CHQPanel.this.tblMeks.columnAtPoint(e.getPoint());
            this.dragUnit = CHQPanel.this.MekTable.getMekAt(row, col);
            this.startArmy = CHQPanel.this.MekTable.getArmyAt(row);
            if (this.dragUnit != null && isFirstButton) {
                this.isDrag = true;
                this.offset = new Point(28, 22);
                MechInfo unitImage = (MechInfo)CHQPanel.this.tblMeks.getCellRenderer(row, col).getTableCellRendererComponent(CHQPanel.this.tblMeks, null, false, false, row, col);
                this.dragImage = unitImage.getEmbeddedImage();
                this.dragRect = new Rectangle2D.Float();
                this.dragRect.setRect(e.getX(), e.getY(), 84.0, 72.0);
                AlphaFilter aFilter = new AlphaFilter(95);
                this.dragImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this.dragImage.getSource(), aFilter));
            }
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (this.isDrag) {
                CHQPanel.this.tblMeks.paintImmediately(this.dragRect.getBounds());
                boolean validRelease = false;
                if (CHQPanel.this.tblMeks.contains(e.getPoint())) {
                    validRelease = true;
                }
                int row = CHQPanel.this.tblMeks.rowAtPoint(e.getPoint());
                int col = CHQPanel.this.tblMeks.columnAtPoint(e.getPoint());
                CUnit exchangeUnit = CHQPanel.this.MekTable.getMekAt(row, col);
                this.currArmy = CHQPanel.this.MekTable.getArmyAt(row);
                if (this.currArmy == null && validRelease) {
                    if (this.startArmy != null) {
                        CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c EXM#" + this.startArmy.getID() + "," + this.dragUnit.getId());
                    }
                } else if (validRelease) {
                    if (this.startArmy == null) {
                        if (exchangeUnit == null) {
                            CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c EXM#" + this.currArmy.getID() + ",-1" + "#" + this.dragUnit.getId());
                        } else if (this.dragUnit.getId() != exchangeUnit.getId()) {
                            CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c EXM#" + this.currArmy.getID() + "," + exchangeUnit.getId() + "#" + this.dragUnit.getId());
                        }
                    } else if (this.currArmy.getID() == this.startArmy.getID() && exchangeUnit != null && this.dragUnit.getId() != exchangeUnit.getId()) {
                        int newpos = 0;
                        for (Unit currU : this.currArmy.getUnits()) {
                            if (currU.getId() == exchangeUnit.getId()) break;
                            ++newpos;
                        }
                        CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c unitposition#" + this.startArmy.getID() + "#" + this.dragUnit.getId() + "#" + newpos);
                    }
                }
                CHQPanel.this.tblMeks.setCursor(Cursor.getDefaultCursor());
            }
            this.isDrag = false;
            this.maybeShowPopup(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (this.isDrag) {
                CHQPanel.this.tblMeks.paintImmediately(this.dragRect.getBounds());
                this.dragRect.setRect(e.getX() - this.offset.x, e.getY() - this.offset.y, 84.0, 72.0);
                Graphics2D g = (Graphics2D)CHQPanel.this.tblMeks.getGraphics();
                g.drawImage(this.dragImage, AffineTransform.getTranslateInstance(this.dragRect.getX(), this.dragRect.getY()), null);
                int row = CHQPanel.this.tblMeks.rowAtPoint(e.getPoint());
                int col = CHQPanel.this.tblMeks.columnAtPoint(e.getPoint());
                CUnit currUnit = CHQPanel.this.MekTable.getMekAt(row, col);
                this.currArmy = CHQPanel.this.MekTable.getArmyAt(row);
                if (this.currArmy == null) {
                    if (this.startArmy != null && CHQPanel.this.mwclient.getMyStatus() == MWClient.STATUS_LOGGEDIN) {
                        CHQPanel.this.tblMeks.setCursor(this.removeCursor);
                    } else if (this.startArmy != null) {
                        CHQPanel.this.tblMeks.setCursor(this.notAllowedCursor);
                    } else {
                        CHQPanel.this.tblMeks.setCursor(Cursor.getDefaultCursor());
                    }
                } else if (this.startArmy == null) {
                    if (CHQPanel.this.mwclient.getMyStatus() != MWClient.STATUS_LOGGEDIN) {
                        CHQPanel.this.tblMeks.setCursor(this.notAllowedCursor);
                    } else if (CHQPanel.this.Player.getAmountOfTimesUnitExistsInArmies(this.dragUnit.getId()) >= Integer.parseInt(CHQPanel.this.mwclient.getserverConfigs("UnitsInMultipleArmiesAmount"))) {
                        CHQPanel.this.tblMeks.setCursor(this.maxCursor);
                    } else if (this.currArmy.getUnit(this.dragUnit.getId()) != null) {
                        CHQPanel.this.tblMeks.setCursor(this.dupeCursor);
                    } else if (currUnit == null) {
                        CHQPanel.this.tblMeks.setCursor(this.addCursor);
                    } else if (this.dragUnit.getId() != currUnit.getId()) {
                        CHQPanel.this.tblMeks.setCursor(this.exchangeCursor);
                    }
                } else if (this.currArmy.getID() == this.startArmy.getID()) {
                    if (currUnit != null && this.dragUnit.getId() != currUnit.getId() && CHQPanel.this.mwclient.getMyStatus() != MWClient.STATUS_FIGHTING) {
                        CHQPanel.this.tblMeks.setCursor(this.positionCursor);
                    } else {
                        CHQPanel.this.tblMeks.setCursor(this.notAllowedCursor);
                    }
                } else {
                    CHQPanel.this.tblMeks.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            int col;
            int row;
            CUnit mek;
            if (e.getClickCount() == 2 && (mek = CHQPanel.this.MekTable.getMekAt(row = CHQPanel.this.tblMeks.rowAtPoint(e.getPoint()), col = CHQPanel.this.tblMeks.columnAtPoint(e.getPoint()))) != null) {
                JFrame InfoWindow = new JFrame();
                MechDetailDisplay MechDetailInfo = new MechDetailDisplay();
                Entity theEntity = mek.getEntity();
                theEntity.loadAllWeapons();
                MechDetailInfo.displayEntity(theEntity, mek.getBV(), CHQPanel.this.mwclient.getConfig().getImage("CAMO"));
                InfoWindow.getContentPane().add(MechDetailInfo);
                InfoWindow.setSize(220, 400);
                InfoWindow.setResizable(false);
                InfoWindow.setTitle(mek.getModelName());
                InfoWindow.setLocationRelativeTo(null);
                InfoWindow.setVisible(true);
            }
            CHQPanel.this.tblMeks.repaint();
        }

        private void maybeShowPopup(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            if (e.isPopupTrigger()) {
                int row = CHQPanel.this.tblMeks.rowAtPoint(e.getPoint());
                int col = CHQPanel.this.tblMeks.columnAtPoint(e.getPoint());
                JMenuItem menuItem = null;
                if (col == 0 && row >= CHQPanel.this.MekTable.getRowsForArmies()) {
                    int i;
                    JMenu primeSortMenu = new JMenu("Sort (1st)");
                    JMenu secondarySortMenu = new JMenu("Sort (2nd)");
                    JMenu tertiarySortMenu = new JMenu("Sort (3rd)");
                    popup.add(primeSortMenu);
                    popup.add(secondarySortMenu);
                    popup.add(tertiarySortMenu);
                    String[] choices = new String[]{"Name", "Battle Value", "Gunnery Skill", "ID Number", "MP (Jumping)", "MP (Walking)", "Pilot Kills", "Unit Type", "Weight (Class)", "Weight (Tons)", "No Sort"};
                    String menuName = "";
                    boolean selectionFound = true;
                    for (i = 0; i < choices.length; ++i) {
                        menuName = choices[i];
                        if (CHQPanel.this.mwclient.getConfigParam("PRIMARYHQSORTORDER").equals(choices[i])) {
                            menuName = "<HTML><i>" + menuName + "</i></HTML>";
                            selectionFound = false;
                        }
                        menuItem = new JMenuItem(menuName);
                        menuItem.setActionCommand("PHS|" + choices[i]);
                        menuItem.addActionListener(this);
                        primeSortMenu.add(menuItem);
                        if (i + 2 != choices.length) continue;
                        primeSortMenu.addSeparator();
                    }
                    selectionFound = true;
                    for (i = 0; i < choices.length; ++i) {
                        menuName = choices[i];
                        if (CHQPanel.this.mwclient.getConfigParam("SECONDARYHQSORTORDER").equals(choices[i])) {
                            menuName = "<HTML><i>" + menuName + "</i></HTML>";
                            selectionFound = false;
                        }
                        menuItem = new JMenuItem(menuName);
                        menuItem.setActionCommand("SHS|" + choices[i]);
                        menuItem.addActionListener(this);
                        secondarySortMenu.add(menuItem);
                        if (i + 2 != choices.length) continue;
                        secondarySortMenu.addSeparator();
                    }
                    selectionFound = true;
                    for (i = 0; i < choices.length; ++i) {
                        menuName = choices[i];
                        if (CHQPanel.this.mwclient.getConfigParam("TERTIARYHQSORTORDER").equals(choices[i])) {
                            menuName = "<HTML><i>" + menuName + "</i></HTML>";
                            selectionFound = false;
                        }
                        menuItem = new JMenuItem(menuName);
                        menuItem.setActionCommand("THS|" + choices[i]);
                        menuItem.addActionListener(this);
                        tertiarySortMenu.add(menuItem);
                        if (i + 2 != choices.length) continue;
                        tertiarySortMenu.addSeparator();
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                } else if (row < 0 || col == 0) {
                    CArmy l = CHQPanel.this.MekTable.getArmyAt(row);
                    int lid = l.getID();
                    if (l != null) {
                        if (l.getBV() > 0) {
                            menuItem = new JMenuItem("Attack Options");
                            menuItem.setActionCommand("AO|" + lid);
                            menuItem.addActionListener(this);
                            boolean canCheckFromReserve = Boolean.valueOf(CHQPanel.this.mwclient.getserverConfigs("ProbeInReserve"));
                            if (CHQPanel.this.mwclient.getMyStatus() != MWClient.STATUS_ACTIVE && !canCheckFromReserve) {
                                menuItem.setEnabled(false);
                            }
                            popup.add(menuItem);
                            boolean limitsAllowed = Boolean.valueOf(CHQPanel.this.mwclient.getserverConfigs("AllowLimiters"));
                            if (limitsAllowed) {
                                JMenu limitmenu = new JMenu("Limits");
                                popup.add(limitmenu);
                                menuItem = new JMenuItem("Set Lower Unit Limit");
                                menuItem.setActionCommand("SLUL|" + lid);
                                menuItem.addActionListener(this);
                                limitmenu.add(menuItem);
                                menuItem = new JMenuItem("Set Upper Unit Limit");
                                menuItem.setActionCommand("SUUL|" + lid);
                                menuItem.addActionListener(this);
                                limitmenu.add(menuItem);
                            }
                            AttackMenu aMenu = new AttackMenu(CHQPanel.this.mwclient, lid, "-1");
                            aMenu.updateMenuItems(false);
                            popup.add(aMenu);
                            popup.addSeparator();
                        }
                        menuItem = new JMenuItem("Remove Army");
                        menuItem.setActionCommand("RA|" + lid);
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        menuItem = new JMenuItem("Rename Army");
                        menuItem.setActionCommand("NA|" + lid);
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        popup.addSeparator();
                        menuItem = new JMenuItem("Show To Faction");
                        menuItem.setActionCommand("SATH|" + lid);
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        if (CHQPanel.this.mwclient.getPlayer().getArmy(lid).getUnits().size() <= 0) {
                            menuItem.setEnabled(false);
                        }
                        JMenu challengeMenu = new JMenu("Request Match");
                        popup.add(challengeMenu);
                        JMenu submenu = new JMenu("Unit");
                        menuItem = new JMenuItem("BV Only");
                        menuItem.setActionCommand("MPC|1|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        menuItem = new JMenuItem("Unit Count and BV");
                        menuItem.setActionCommand("MPC|2|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        menuItem = new JMenuItem("Unit Classes and BV");
                        menuItem.setActionCommand("MPC|3|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        challengeMenu.add(submenu);
                        submenu = new JMenu("Total Weight");
                        menuItem = new JMenuItem("Total Weight");
                        menuItem.setActionCommand("MPC|4|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        menuItem = new JMenuItem("Total Weight with BV");
                        menuItem.setActionCommand("MPC|5|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        menuItem = new JMenuItem("Total Weight and Unit Count");
                        menuItem.setActionCommand("MPC|6|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        menuItem = new JMenuItem("Total Weight, Unit Count and BV");
                        menuItem.setActionCommand("MPC|7|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        challengeMenu.add(submenu);
                        submenu = new JMenu("Unit Types");
                        menuItem = new JMenuItem("Unit Types");
                        menuItem.setActionCommand("MPC|8|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        menuItem = new JMenuItem("Unit Types with BV");
                        menuItem.setActionCommand("MPC|9|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        challengeMenu.add(submenu);
                        submenu = new JMenu("Unit Models");
                        menuItem = new JMenuItem("Unit Models");
                        menuItem.setActionCommand("MPC|10|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        menuItem = new JMenuItem("Unit Models with BV");
                        menuItem.setActionCommand("MPC|11|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        challengeMenu.add(submenu);
                        submenu = new JMenu("Actual Weight");
                        menuItem = new JMenuItem("Actual Unit Weights");
                        menuItem.setActionCommand("MPC|12|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        menuItem = new JMenuItem("Actual Unit Weights with BV");
                        menuItem.setActionCommand("MPC|13|" + lid);
                        menuItem.addActionListener(this);
                        submenu.add(menuItem);
                        challengeMenu.add(submenu);
                        if (CHQPanel.this.mwclient.getPlayer().getArmy(lid).getUnits().size() <= 0) {
                            challengeMenu.setEnabled(false);
                        }
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                } else if (row < CHQPanel.this.MekTable.getRowsForArmies()) {
                    CUnit cm = null;
                    CArmy l = CHQPanel.this.MekTable.getArmyAt(row);
                    int mid = col;
                    int lid = l.getID();
                    cm = CHQPanel.this.MekTable.getMekAt(row, col);
                    boolean hasUnitsFree = false;
                    JMenu addMenu = new JMenu("Add");
                    if (!(CHQPanel.this.MekTable.getHangerMechs().size() <= 0 || l != null && l.isLocked())) {
                        Object[] mechArray = CHQPanel.this.MekTable.getHangerMechs().toArray();
                        if (mechArray.length > 0) {
                            int i;
                            Vector SubMenus = new Vector();
                            for (i = 0; i < 6; ++i) {
                                SubMenus.add(new Vector());
                            }
                            for (i = 0; i < mechArray.length; ++i) {
                                CUnit mm = (CUnit)mechArray[i];
                                if (mm.getStatus() == 3 || CHQPanel.this.Player.getAmountOfTimesUnitExistsInArmies(mm.getId()) >= Integer.parseInt(CHQPanel.this.mwclient.getserverConfigs("UnitsInMultipleArmiesAmount")) || l.hasUnit(mm.getId())) continue;
                                hasUnitsFree = true;
                                menuItem = mm.getType() == 0 || mm.getType() == 1 ? new JMenuItem(mm.getModelName() + " (" + mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting() + ") " + mm.getBV() + " BV") : new JMenuItem(mm.getModelName() + " (" + mm.getPilot().getGunnery() + ") " + mm.getBV() + " BV");
                                menuItem.setActionCommand("EXM|" + lid + "|" + "-1" + "|" + mm.getId());
                                menuItem.addActionListener(this);
                                if (mm.getType() == 3) {
                                    ((Vector)SubMenus.elementAt(4)).add(menuItem);
                                    continue;
                                }
                                if (mm.getType() == 2 || mm.getType() == 4) {
                                    ((Vector)SubMenus.elementAt(5)).add(menuItem);
                                    continue;
                                }
                                int size = mm.getWeightclass();
                                ((Vector)SubMenus.elementAt(size)).add(menuItem);
                            }
                            for (i = 0; i < SubMenus.size(); ++i) {
                                Vector SizeMenu = (Vector)SubMenus.elementAt(i);
                                if (SizeMenu.size() > 10) {
                                    int iterations = SizeMenu.size() / 10 + 1;
                                    for (int j = 0; j < iterations; ++j) {
                                        int mechcount = 0;
                                        JMenu menux = null;
                                        if (i < 4) {
                                            menux = new JMenu(CUnit.getWeightclassName(i) + " " + (j + 1));
                                        } else if (i == 4) {
                                            menux = new JMenu("Proto " + (j + 1));
                                        } else if (i == 5) {
                                            menux = new JMenu("Infantry " + (j + 1));
                                        }
                                        while (!SizeMenu.isEmpty() && mechcount < 10) {
                                            menux.add((JMenuItem)SizeMenu.elementAt(0));
                                            SizeMenu.removeElementAt(0);
                                            SizeMenu.trimToSize();
                                            ++mechcount;
                                        }
                                        if (i == 4 || i == 5) {
                                            Component[] components = addMenu.getMenuComponents();
                                            if (i == 4 && components.length != 0) {
                                                addMenu.addSeparator();
                                            } else if (i == 5) {
                                                boolean hasProtoMenu = false;
                                                for (int k = 0; k < components.length; ++k) {
                                                    JMenu currMenu;
                                                    Component currComponent = components[k];
                                                    if (!(currComponent instanceof JMenu) || !(currMenu = (JMenu)currComponent).getText().startsWith("Proto")) continue;
                                                    hasProtoMenu = true;
                                                }
                                                if (!hasProtoMenu && components.length > 0 && menux.getComponentCount() > 0) {
                                                    addMenu.addSeparator();
                                                }
                                            }
                                        }
                                        addMenu.add(menux);
                                    }
                                    continue;
                                }
                                JMenu menux = null;
                                if (i < 4) {
                                    menux = new JMenu(CUnit.getWeightclassName(i));
                                } else if (i == 4) {
                                    menux = new JMenu("Proto");
                                } else if (i == 5) {
                                    menux = new JMenu("Infantry");
                                }
                                boolean hasProtoMenu = false;
                                Component[] components = addMenu.getMenuComponents();
                                if (i == 5) {
                                    for (int k = 0; k < components.length; ++k) {
                                        JMenu currMenu;
                                        Component currComponent = components[k];
                                        if (!(currComponent instanceof JMenu) || !(currMenu = (JMenu)currComponent).getText().startsWith("Proto")) continue;
                                        hasProtoMenu = true;
                                    }
                                }
                                for (int j = 0; j < SizeMenu.size(); ++j) {
                                    menux.add((JMenuItem)SizeMenu.elementAt(j));
                                    if (i == 5 && j == 0 && !hasProtoMenu && components.length > 0) {
                                        addMenu.addSeparator();
                                    } else if (i == 4 && j == 0 && components.length > 0) {
                                        addMenu.addSeparator();
                                    }
                                    addMenu.add(menux);
                                }
                            }
                        } else {
                            for (int i = 0; i < mechArray.length; ++i) {
                                CUnit mm = (CUnit)mechArray[i];
                                if (mm.getStatus() == 3) continue;
                                menuItem = mm.getType() == 0 || mm.getType() == 1 ? new JMenuItem(mm.getModelName() + " (" + mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting() + ") " + mm.getBV() + " BV") : new JMenuItem(mm.getModelName() + " (" + mm.getPilot().getGunnery() + ") " + mm.getBV() + " BV");
                                menuItem.setActionCommand("EXM|" + lid + "|" + mid + "|" + mm.getId());
                                menuItem.addActionListener(this);
                                addMenu.add(menuItem);
                            }
                        }
                        addMenu.setEnabled(hasUnitsFree);
                    }
                    if (cm != null) {
                        JMenu linkMenu = new JMenu("Link");
                        if (!(l.getUnits().size() <= 0 || l != null && l.isLocked())) {
                            Vector<CUnit> Masters = new Vector<CUnit>();
                            Enumeration<Unit> c3M = l.getUnits().elements();
                            while (c3M.hasMoreElements()) {
                                CUnit c3Unit = (CUnit)c3M.nextElement();
                                if (c3Unit.equals(cm)) continue;
                                if (cm.getC3Level() != 3) {
                                    if (c3Unit.getC3Level() != 2 && c3Unit.getC3Level() != 4 || !c3Unit.checkC3mNetworkHasOpen(l, cm.getC3Level())) continue;
                                    Masters.add(c3Unit);
                                    continue;
                                }
                                if (cm.getC3Level() != 3 || c3Unit.getC3Level() != 3 || !c3Unit.checkC3iNetworkHasOpen(l)) continue;
                                Masters.add(c3Unit);
                            }
                            for (int i = 0; i < Masters.size(); ++i) {
                                CUnit mm = (CUnit)Masters.elementAt(i);
                                if (!l.hasUnit(mm.getId())) continue;
                                menuItem = new JMenuItem(mm.getModelName() + " " + mm.getBV() + " BV");
                                menuItem.setActionCommand("LCN|" + lid + "|" + cm.getId() + "|" + mm.getId());
                                menuItem.addActionListener(this);
                                linkMenu.add(menuItem);
                            }
                        }
                        mid = cm.getId();
                        if (l != null && !l.isLocked()) {
                            String text = "Move To Hangar";
                            if (cm.getStatus() == 2) {
                                text = "Remove";
                            }
                            menuItem = new JMenuItem(text);
                            menuItem.setActionCommand("MH|" + lid + "|" + mid);
                            menuItem.addActionListener(this);
                            popup.add(menuItem);
                        }
                        if (!(CHQPanel.this.MekTable.getHangerMechs().size() <= 0 || l != null && l.isLocked())) {
                            JMenu jm = new JMenu("Exchange");
                            popup.add(jm);
                            Object[] mechs = CHQPanel.this.MekTable.getHangerMechs().toArray();
                            if (mechs.length > 0) {
                                int i;
                                Vector SubMenus = new Vector();
                                for (i = 0; i < 6; ++i) {
                                    SubMenus.add(new Vector());
                                }
                                for (i = 0; i < mechs.length; ++i) {
                                    CUnit mm = (CUnit)mechs[i];
                                    if (mm.getStatus() == 3 || CHQPanel.this.Player.getAmountOfTimesUnitExistsInArmies(mm.getId()) >= Integer.parseInt(CHQPanel.this.mwclient.getserverConfigs("UnitsInMultipleArmiesAmount")) || l.hasUnit(mm.getId())) continue;
                                    menuItem = mm.getType() == 0 || mm.getType() == 1 ? new JMenuItem(mm.getModelName() + " (" + mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting() + ") " + mm.getBV() + " BV") : new JMenuItem(mm.getModelName() + " (" + mm.getPilot().getGunnery() + ") " + mm.getBV() + " BV");
                                    menuItem.setActionCommand("EXM|" + lid + "|" + cm.getId() + "|" + mm.getId());
                                    menuItem.addActionListener(this);
                                    if (mm.getType() == 3) {
                                        ((Vector)SubMenus.elementAt(4)).add(menuItem);
                                        continue;
                                    }
                                    if (mm.getType() == 2 || mm.getType() == 4) {
                                        ((Vector)SubMenus.elementAt(5)).add(menuItem);
                                        continue;
                                    }
                                    int size = mm.getWeightclass();
                                    ((Vector)SubMenus.elementAt(size)).add(menuItem);
                                }
                                for (i = 0; i < SubMenus.size(); ++i) {
                                    Vector SizeMenu = (Vector)SubMenus.elementAt(i);
                                    JMenu menux = null;
                                    if (SizeMenu.size() > 10) {
                                        int iterations = SizeMenu.size() / 10 + 1;
                                        for (int j = 0; j < iterations; ++j) {
                                            int mechcount = 0;
                                            if (i < 4) {
                                                menux = new JMenu(CUnit.getWeightclassName(i) + " " + (j + 1));
                                            } else if (i == 4) {
                                                menux = new JMenu("Proto " + (j + 1));
                                            } else if (i == 5) {
                                                menux = new JMenu("Infantry " + (j + 1));
                                            }
                                            while (!SizeMenu.isEmpty() && mechcount < 10) {
                                                menux.add((JMenuItem)SizeMenu.elementAt(0));
                                                SizeMenu.removeElementAt(0);
                                                SizeMenu.trimToSize();
                                                ++mechcount;
                                            }
                                            if (i == 4 || i == 5) {
                                                Component[] components = addMenu.getMenuComponents();
                                                if (i == 4 && components.length != 0) {
                                                    jm.addSeparator();
                                                } else if (i == 5) {
                                                    boolean hasProtoMenu = false;
                                                    for (int k = 0; k < components.length; ++k) {
                                                        JMenu currMenu;
                                                        Component currComponent = components[k];
                                                        if (!(currComponent instanceof JMenu) || !(currMenu = (JMenu)currComponent).getText().startsWith("Proto")) continue;
                                                        hasProtoMenu = true;
                                                    }
                                                    if (!hasProtoMenu && components.length > 0 && menux.getComponentCount() > 0) {
                                                        jm.addSeparator();
                                                    }
                                                }
                                            }
                                            jm.add(menux);
                                        }
                                        continue;
                                    }
                                    if (i < 4) {
                                        menux = new JMenu(CUnit.getWeightclassName(i));
                                    } else if (i == 4) {
                                        menux = new JMenu("Proto");
                                    } else if (i == 5) {
                                        menux = new JMenu("Infantry");
                                    }
                                    boolean hasProtoMenu = false;
                                    Component[] components = jm.getMenuComponents();
                                    if (i == 5) {
                                        for (int k = 0; k < components.length; ++k) {
                                            JMenu currMenu;
                                            Component currComponent = components[k];
                                            if (!(currComponent instanceof JMenu) || !(currMenu = (JMenu)currComponent).getText().startsWith("Proto")) continue;
                                            hasProtoMenu = true;
                                        }
                                    }
                                    for (int j = 0; j < SizeMenu.size(); ++j) {
                                        menux.add((JMenuItem)SizeMenu.elementAt(j));
                                        if (i == 5 && j == 0 && !hasProtoMenu && components.length > 0) {
                                            jm.addSeparator();
                                        } else if (i == 4 && j == 0 && components.length > 0) {
                                            jm.addSeparator();
                                        }
                                        jm.add(menux);
                                    }
                                }
                            } else {
                                for (int i = 0; i < mechs.length; ++i) {
                                    CUnit mm = (CUnit)mechs[i];
                                    if (mm.getStatus() == 3) continue;
                                    menuItem = mm.getType() == 0 || mm.getType() == 1 ? new JMenuItem(mm.getModelName() + " (" + mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting() + ") " + mm.getBV() + " BV") : new JMenuItem(mm.getModelName() + " (" + mm.getPilot().getGunnery() + ") " + mm.getBV() + " BV");
                                    menuItem.setActionCommand("EXM|" + lid + "|" + cm.getId() + "|" + mm.getId());
                                    menuItem.addActionListener(this);
                                    jm.add(menuItem);
                                }
                            }
                            jm.setEnabled(hasUnitsFree);
                            popup.add(addMenu);
                            if (l.getAmountOfUnits() > 1) {
                                JMenu pjm = new JMenu("Position");
                                popup.add(pjm);
                                Enumeration<Unit> en = l.getUnits().elements();
                                int currPos = 0;
                                while (en.hasMoreElements()) {
                                    CUnit currUnit = (CUnit)en.nextElement();
                                    if (currUnit.getId() != mid) {
                                        menuItem = new JMenuItem("Move to #" + (currPos + 1));
                                        menuItem.setActionCommand("RPU|" + lid + "|" + cm.getId() + "|" + currPos);
                                        menuItem.addActionListener(this);
                                        pjm.add(menuItem);
                                    }
                                    ++currPos;
                                }
                            }
                        }
                        if (cm.getC3Level() != 0) {
                            popup.add(linkMenu);
                        }
                        if (cm.hasBeenC3LinkedTo(l) || l.getC3Network().get(new Integer(cm.getId())) != null) {
                            menuItem = new JMenuItem("Unlink");
                            menuItem.setActionCommand("LCN|" + lid + "|" + cm.getId() + "|-1");
                            menuItem.addActionListener(this);
                            popup.add(menuItem);
                        }
                        popup.addSeparator();
                        menuItem = new JMenuItem("View Unit");
                        menuItem.setActionCommand("SM|" + row + "|" + col);
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        menuItem = new JMenuItem("Customize Unit");
                        menuItem.setActionCommand("CMU|" + row + "|" + col);
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        if (cm.getEntity() instanceof Mech) {
                            Mech mech = (Mech)cm.getEntity();
                            if (mech.isAutoEject()) {
                                menuItem = new JMenuItem("Disable Autoeject");
                                menuItem.setActionCommand("DAE|" + row + "|" + col);
                                menuItem.addActionListener(this);
                                popup.add(menuItem);
                            } else {
                                menuItem = new JMenuItem("Enable Autoeject");
                                menuItem.setActionCommand("EAE|" + row + "|" + col);
                                menuItem.addActionListener(this);
                                popup.add(menuItem);
                            }
                        }
                    } else {
                        popup.add(addMenu);
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    int hangernum;
                    CUnit cm = CHQPanel.this.MekTable.getMekAt(row, col);
                    if (cm != null) {
                        boolean ppqsEnabled;
                        menuItem = new JMenuItem("View Unit");
                        menuItem.setActionCommand("SM|" + row + "|" + col);
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        menuItem = new JMenuItem("Customize Unit");
                        menuItem.setActionCommand("CMU|" + row + "|" + col);
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        if (Boolean.valueOf(CHQPanel.this.mwclient.getserverConfigs("UseAdvanceRepair")).booleanValue() && (UnitUtils.hasArmorDamage(cm.getEntity()) || UnitUtils.hasCriticalDamage(cm.getEntity()))) {
                            menuItem = new JMenuItem("Repair Unit");
                            menuItem.setActionCommand("ARU|" + row + "|" + col);
                            menuItem.addActionListener(this);
                            popup.add(menuItem);
                        }
                        if (cm.getEntity() instanceof Mech) {
                            Mech mech = (Mech)cm.getEntity();
                            if (mech.isAutoEject()) {
                                menuItem = new JMenuItem("Disable Autoeject");
                                menuItem.setActionCommand("DAE|" + row + "|" + col);
                                menuItem.addActionListener(this);
                                popup.add(menuItem);
                            } else {
                                menuItem = new JMenuItem("Enable Autoeject");
                                menuItem.setActionCommand("EAE|" + row + "|" + col);
                                menuItem.addActionListener(this);
                                popup.add(menuItem);
                            }
                        }
                        popup.addSeparator();
                        if (cm.getStatus() == 3) {
                            menuItem = new JMenuItem("Maintain");
                            menuItem.setActionCommand("MM|" + cm.getId());
                            menuItem.addActionListener(this);
                            popup.add(menuItem);
                        } else {
                            menuItem = new JMenuItem("Unmaintain");
                            menuItem.setActionCommand("UMM|" + cm.getId());
                            menuItem.addActionListener(this);
                            popup.add(menuItem);
                        }
                        if (cm.isOmni()) {
                            menuItem = new JMenuItem("Repod Unit");
                            menuItem.setActionCommand("RM|" + cm.getId());
                            menuItem.addActionListener(this);
                            popup.add(menuItem);
                        }
                        JMenu hm = new JMenu("Transactions");
                        popup.add(hm);
                        menuItem = new JMenuItem("Donate");
                        menuItem.setActionCommand("DO|" + cm.getId());
                        menuItem.addActionListener(this);
                        hm.add(menuItem);
                        menuItem = new JMenuItem("Scrap");
                        menuItem.setActionCommand("S|" + cm.getId());
                        menuItem.addActionListener(this);
                        hm.add(menuItem);
                        menuItem = new JMenuItem("Transfer Unit");
                        menuItem.setActionCommand("TM|" + cm.getId());
                        menuItem.addActionListener(this);
                        hm.add(menuItem);
                        menuItem = new JMenuItem("Add to BM");
                        menuItem.setActionCommand("AB|" + cm.getId());
                        menuItem.addActionListener(this);
                        hm.add(menuItem);
                        if (Boolean.valueOf(CHQPanel.this.mwclient.getserverConfigs("UseDirectSell")).booleanValue()) {
                            menuItem = new JMenuItem("Direct Sell Unit");
                            menuItem.setActionCommand("DSU|" + cm.getId());
                            menuItem.addActionListener(this);
                            hm.add(menuItem);
                        }
                        JMenu pm = new JMenu("Pilot");
                        popup.add(pm);
                        if (!cm.getPilot().getName().equals("Vacant")) {
                            menuItem = new JMenuItem("Retire");
                            menuItem.setActionCommand("RT|" + cm.getId());
                            menuItem.addActionListener(this);
                            pm.add(menuItem);
                            menuItem = new JMenuItem("Rename");
                            menuItem.setActionCommand("RP|" + cm.getId());
                            menuItem.addActionListener(this);
                            pm.add(menuItem);
                        }
                        if ((ppqsEnabled = Boolean.valueOf(CHQPanel.this.mwclient.getserverConfigs("AllowPersonalPilotQueues")).booleanValue()) && (cm.getType() == 0 || cm.getType() == 3)) {
                            Object[] pilots = CHQPanel.this.Player.getPlayerPersonalPilotQueue().getPilotQueue(cm.getType(), cm.getWeightclass()).toArray();
                            JMenu jm = new JMenu("Exchange");
                            if (!cm.getPilot().getName().equals("Vacant")) {
                                pm.addSeparator();
                                menuItem = new JMenuItem("Remove");
                                menuItem.setActionCommand("EXP|" + cm.getId() + "|-1");
                                menuItem.addActionListener(this);
                                pm.add(menuItem);
                            } else {
                                jm = new JMenu("Assign");
                            }
                            if (pilots.length == 0) {
                                jm.setEnabled(false);
                            } else {
                                pm.add(jm);
                                for (int i = 0; i < pilots.length; ++i) {
                                    String skills;
                                    String pilotString;
                                    Pilot mm = (Pilot)pilots[i];
                                    if (cm.getType() == 0) {
                                        pilotString = mm.getName() + " (" + mm.getGunnery() + "/" + mm.getPiloting();
                                        skills = mm.getSkillString(true);
                                        pilotString = skills.trim().equals("") ? pilotString + ")" : pilotString + ", " + skills + ")";
                                        menuItem = new JMenuItem(pilotString);
                                    } else {
                                        pilotString = mm.getName() + " (" + mm.getGunnery();
                                        skills = mm.getSkillString(true);
                                        pilotString = skills.trim().equals("") ? pilotString + ")" : pilotString + ", " + skills + ")";
                                        menuItem = new JMenuItem(pilotString);
                                    }
                                    menuItem.setActionCommand("EXP|" + cm.getId() + "|" + i);
                                    menuItem.addActionListener(this);
                                    jm.add(menuItem);
                                }
                            }
                        }
                        popup.addSeparator();
                        menuItem = new JMenuItem("Show To Faction");
                        menuItem.setActionCommand("SUTH|" + cm.getId());
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        menuItem = new JMenuItem("Remove From All");
                        menuItem.setActionCommand("RFAA|" + cm.getId());
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        Vector<CArmy> armies = CHQPanel.this.mwclient.getPlayer().getArmies();
                        Enumeration<CArmy> en = armies.elements();
                        boolean isInArmy = false;
                        while (en.hasMoreElements() && !isInArmy) {
                            CArmy currArmy = en.nextElement();
                            if (!currArmy.hasUnit(cm.getId())) continue;
                            isInArmy = true;
                        }
                        if (!isInArmy) {
                            menuItem.setEnabled(false);
                        }
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    } else if (CHQPanel.this.Player.getFreeBays() > 0 && (hangernum = (row - CHQPanel.this.MekTable.getRowsForArmies()) * (CHQPanel.this.MekTable.getColumnCount() - 1) + col - 1) == CHQPanel.this.mwclient.getPlayer().getHangar().size()) {
                        menuItem = new JMenuItem("Fire Excess Techs");
                        menuItem.setActionCommand("FET");
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String s = actionEvent.getActionCommand();
            StringTokenizer st = new StringTokenizer(s, "|");
            String command = st.nextToken();
            if (command.equalsIgnoreCase("EXM")) {
                int lid = Integer.parseInt(st.nextToken());
                int mid = Integer.parseInt(st.nextToken());
                int hid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c EXM#" + lid + "," + mid + "#" + hid);
            } else if (command.equalsIgnoreCase("MH")) {
                int lid = Integer.parseInt(st.nextToken());
                int mid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c EXM#" + lid + "," + mid);
            } else if (command.equalsIgnoreCase("D")) {
                int row = Integer.parseInt(st.nextToken());
                int col = Integer.parseInt(st.nextToken());
                CHQPanel.this.MekTable.getMekAt(row, col).setStatus(2);
            } else if (command.equalsIgnoreCase("A")) {
                int row = Integer.parseInt(st.nextToken());
                int col = Integer.parseInt(st.nextToken());
                CHQPanel.this.MekTable.getMekAt(row, col).setStatus(1);
            } else if (command.equalsIgnoreCase("AA")) {
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c cra#" + CHQPanel.this.mwclient.getConfigParam("DEFAULTARMYNAME"));
            } else if (command.equalsIgnoreCase("SA")) {
                int lid = Integer.parseInt(st.nextToken());
            } else if (command.equalsIgnoreCase("SI")) {
                int lid = Integer.parseInt(st.nextToken());
            } else if (command.equalsIgnoreCase("AO")) {
                int lid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderCheckAttack_actionPerformed(null, lid);
            } else if (command.equalsIgnoreCase("RA")) {
                int lid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderRemoveLance_actionPerformed(null, lid);
            } else if (command.equalsIgnoreCase("NA")) {
                int mid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderNameArmy_actionPerformed(null, mid);
            } else if (command.equalsIgnoreCase("SLUL")) {
                int lid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderSetLowerUnitLimit_actionPerformed(lid);
            } else if (command.equalsIgnoreCase("SUUL")) {
                int lid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderSetUpperUnitLimit_actionPerformed(lid);
            } else if (command.equalsIgnoreCase("SATH")) {
                int lid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c sth#a#" + lid);
            } else if (command.equalsIgnoreCase("MPC")) {
                int mode = Integer.parseInt(st.nextToken());
                int lid = Integer.parseInt(st.nextToken());
                CArmy currArmy = CHQPanel.this.mwclient.getPlayer().getArmy(lid);
                String toSend = CHQPanel.this.mwclient.getConfigParam("CHALLENGESTRING");
                if (toSend.trim().equals("")) {
                    toSend = CHQPanel.this.mwclient.getConfig().getDefaultParam("CHALLENGESTRING");
                }
                if (mode == 1) {
                    toSend = toSend + " " + currArmy.getBV() + " BV.";
                } else if (mode == 2) {
                    int armySize = currArmy.getUnits().size();
                    toSend = toSend + " " + currArmy.getBV() + " BV, with  " + armySize + " unit";
                    toSend = armySize > 1 ? toSend + "s." : toSend + ".";
                } else if (mode == 3) {
                    int assaultM = 0;
                    int heavyM = 0;
                    int mediumM = 0;
                    int lightM = 0;
                    int protoM = 0;
                    int ba = 0;
                    int vehs = 0;
                    int inf = 0;
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    boolean firstUnit = true;
                    while (e.hasMoreElements()) {
                        CUnit currUnit = (CUnit)e.nextElement();
                        if (currUnit.getType() == 0 || currUnit.getType() == 5) {
                            if (currUnit.getWeightclass() == 3) {
                                ++assaultM;
                                continue;
                            }
                            if (currUnit.getWeightclass() == 2) {
                                ++heavyM;
                                continue;
                            }
                            if (currUnit.getWeightclass() == 1) {
                                ++mediumM;
                                continue;
                            }
                            ++lightM;
                            continue;
                        }
                        if (currUnit.getType() == 3) {
                            ++protoM;
                            continue;
                        }
                        if (currUnit.getType() == 1) {
                            ++vehs;
                            continue;
                        }
                        if (currUnit.getType() == 4) {
                            ++ba;
                            continue;
                        }
                        ++inf;
                    }
                    toSend = toSend + " " + currArmy.getBV() + " BV.";
                    if (assaultM > 0) {
                        toSend = toSend + " " + assaultM + "A,";
                    }
                    if (heavyM > 0) {
                        toSend = toSend + " " + heavyM + "H,";
                    }
                    if (mediumM > 0) {
                        toSend = toSend + " " + mediumM + "M,";
                    }
                    if (lightM > 0) {
                        toSend = toSend + " " + lightM + "L,";
                    }
                    if (protoM > 0) {
                        toSend = toSend + " " + protoM + " Protos,";
                    }
                    if (ba > 0) {
                        toSend = toSend + " " + ba + " BAs,";
                    }
                    if (vehs > 0) {
                        toSend = toSend + " " + vehs + " Vehs,";
                    }
                    if (inf > 0) {
                        toSend = toSend + " " + inf + " Inf,";
                    }
                    int sendLength = toSend.lastIndexOf(",");
                    toSend = toSend.substring(0, sendLength) + ".";
                } else if (mode == 4) {
                    int Tonnage = 0;
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    while (e.hasMoreElements()) {
                        CUnit unit = (CUnit)e.nextElement();
                        Tonnage += (int)unit.getEntity().getWeight();
                    }
                    toSend = toSend + " " + Tonnage + " tons.";
                } else if (mode == 5) {
                    int Tonnage = 0;
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    while (e.hasMoreElements()) {
                        CUnit unit = (CUnit)e.nextElement();
                        Tonnage += (int)unit.getEntity().getWeight();
                    }
                    toSend = toSend + " " + currArmy.getBV() + " BV, at " + Tonnage + " tons";
                } else if (mode == 6) {
                    int Tonnage = 0;
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    while (e.hasMoreElements()) {
                        CUnit unit = (CUnit)e.nextElement();
                        Tonnage += (int)unit.getEntity().getWeight();
                    }
                    toSend = toSend + " " + Tonnage + " tons, with " + currArmy.getUnits().size();
                    toSend = currArmy.getUnits().size() == 1 ? toSend + " unit." : toSend + " units.";
                } else if (mode == 7) {
                    int Tonnage = 0;
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    while (e.hasMoreElements()) {
                        CUnit unit = (CUnit)e.nextElement();
                        Tonnage += (int)unit.getEntity().getWeight();
                    }
                    toSend = toSend + " " + currArmy.getBV() + " BV, at " + Tonnage + " tons, with " + currArmy.getUnits().size();
                    toSend = currArmy.getUnits().size() == 1 ? toSend + " unit." : toSend + " units.";
                } else if (mode == 8) {
                    int assault = 0;
                    int heavy = 0;
                    int medium = 0;
                    int light = 0;
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    while (e.hasMoreElements()) {
                        CUnit unit = (CUnit)e.nextElement();
                        switch (unit.getWeightclass()) {
                            case 3: {
                                ++assault;
                                break;
                            }
                            case 0: {
                                ++light;
                                break;
                            }
                            case 1: {
                                ++medium;
                                break;
                            }
                            case 2: {
                                ++heavy;
                            }
                        }
                    }
                    if (assault > 0) {
                        toSend = toSend + " " + assault + "A,";
                    }
                    if (heavy > 0) {
                        toSend = toSend + " " + heavy + "H,";
                    }
                    if (medium > 0) {
                        toSend = toSend + " " + medium + "M,";
                    }
                    if (light > 0) {
                        toSend = toSend + " " + light + "L,";
                    }
                    int sendLength = toSend.lastIndexOf(",");
                    toSend = toSend.substring(0, sendLength) + ".";
                } else if (mode == 9) {
                    int assault = 0;
                    int heavy = 0;
                    int medium = 0;
                    int light = 0;
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    while (e.hasMoreElements()) {
                        CUnit unit = (CUnit)e.nextElement();
                        switch (unit.getWeightclass()) {
                            case 3: {
                                ++assault;
                                break;
                            }
                            case 0: {
                                ++light;
                                break;
                            }
                            case 1: {
                                ++medium;
                                break;
                            }
                            case 2: {
                                ++heavy;
                            }
                        }
                    }
                    toSend = toSend + " " + currArmy.getBV() + " BV, with";
                    if (assault > 0) {
                        toSend = toSend + " " + assault + "A,";
                    }
                    if (heavy > 0) {
                        toSend = toSend + " " + heavy + "H,";
                    }
                    if (medium > 0) {
                        toSend = toSend + " " + medium + "M,";
                    }
                    if (light > 0) {
                        toSend = toSend + " " + light + "L,";
                    }
                    int sendLength = toSend.lastIndexOf(",");
                    toSend = toSend.substring(0, sendLength) + ".";
                } else if (mode == 10) {
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    while (e.hasMoreElements()) {
                        CUnit unit = (CUnit)e.nextElement();
                        toSend = toSend + " <a href=\"MEKINFO" + unit.getUnitFilename() + "#" + unit.getBV() + "#" + unit.getPilot().getGunnery() + "#" + unit.getPilot().getPiloting() + "\">" + unit.getModelName() + "</a>,";
                    }
                    int sendLength = toSend.lastIndexOf(",");
                    toSend = toSend.substring(0, sendLength) + ".";
                } else if (mode == 11) {
                    toSend = toSend + " " + currArmy.getBV() + " BV,";
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    while (e.hasMoreElements()) {
                        CUnit unit = (CUnit)e.nextElement();
                        toSend = toSend + " <a href=\"MEKINFO" + unit.getUnitFilename() + "#" + unit.getBV() + "#" + unit.getPilot().getGunnery() + "#" + unit.getPilot().getPiloting() + "\">" + unit.getModelName() + "</a>,";
                    }
                    int sendLength = toSend.lastIndexOf(",");
                    toSend = toSend.substring(0, sendLength) + ".";
                } else if (mode == 12) {
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    TreeMap<Float, Integer> unitWeights = new TreeMap<Float, Integer>();
                    while (e.hasMoreElements()) {
                        CUnit unit = (CUnit)e.nextElement();
                        if (!unitWeights.containsKey(Float.valueOf(unit.getEntity().getWeight()))) {
                            unitWeights.put(Float.valueOf(unit.getEntity().getWeight()), 1);
                            continue;
                        }
                        unitWeights.put(Float.valueOf(unit.getEntity().getWeight()), (Integer)unitWeights.get(Float.valueOf(unit.getEntity().getWeight())) + 1);
                    }
                    for (Float weight : unitWeights.keySet()) {
                        toSend = toSend + " " + Integer.toString((Integer)unitWeights.get(weight)) + "x " + weight.intValue() + " tons,";
                    }
                    int sendLength = toSend.lastIndexOf(",");
                    toSend = toSend.substring(0, sendLength) + ".";
                } else if (mode == 13) {
                    toSend = toSend + " " + currArmy.getBV() + " BV,";
                    Enumeration<Unit> e = currArmy.getUnits().elements();
                    TreeMap<Float, Integer> unitWeights = new TreeMap<Float, Integer>();
                    while (e.hasMoreElements()) {
                        CUnit unit = (CUnit)e.nextElement();
                        if (!unitWeights.containsKey(Float.valueOf(unit.getEntity().getWeight()))) {
                            unitWeights.put(Float.valueOf(unit.getEntity().getWeight()), 1);
                            continue;
                        }
                        unitWeights.put(Float.valueOf(unit.getEntity().getWeight()), (Integer)unitWeights.get(Float.valueOf(unit.getEntity().getWeight())) + 1);
                    }
                    for (Float weight : unitWeights.keySet()) {
                        toSend = toSend + " " + Integer.toString((Integer)unitWeights.get(weight)) + "x " + weight.intValue() + " tons,";
                    }
                    int sendLength = toSend.lastIndexOf(",");
                    toSend = toSend.substring(0, sendLength) + ".";
                }
                CHQPanel.this.mwclient.sendChat(toSend);
            } else if (command.equalsIgnoreCase("SUTH")) {
                int mid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c sth#u#" + mid);
            } else if (command.equalsIgnoreCase("RP")) {
                int mid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderNamePilot_actionPerformed(null, mid);
            } else if (command.equalsIgnoreCase("RT")) {
                int mid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderRetirePilot_actionPerformed(mid);
            } else if (command.equalsIgnoreCase("SM")) {
                int row = Integer.parseInt(st.nextToken());
                int col = Integer.parseInt(st.nextToken());
                CUnit mek = CHQPanel.this.MekTable.getMekAt(row, col);
                Entity theEntity = mek.getEntity();
                JFrame InfoWindow = new JFrame();
                MechDetailDisplay MechDetailInfo = new MechDetailDisplay();
                theEntity.loadAllWeapons();
                MechDetailInfo.displayEntity(theEntity, mek.getBV(), CHQPanel.this.mwclient.getConfig().getImage("CAMO"));
                InfoWindow.getContentPane().add(MechDetailInfo);
                InfoWindow.setSize(220, 400);
                InfoWindow.setResizable(false);
                InfoWindow.setTitle(mek.getModelName());
                InfoWindow.setLocationRelativeTo(null);
                InfoWindow.setVisible(true);
            } else if (command.equalsIgnoreCase("CMU")) {
                int row = Integer.parseInt(st.nextToken());
                int col = Integer.parseInt(st.nextToken());
                CUnit mek = CHQPanel.this.MekTable.getMekAt(row, col);
                Entity theEntity = mek.getEntity();
                theEntity.loadAllWeapons();
                CustomUnitDialog customizeUnit = new CustomUnitDialog(CHQPanel.this.mwclient.getMainFrame(), CHQPanel.this.mwclient, theEntity, true);
                customizeUnit.setVisible(true);
            } else if (command.equalsIgnoreCase("ARU")) {
                int row = Integer.parseInt(st.nextToken());
                int col = Integer.parseInt(st.nextToken());
                CUnit mek = CHQPanel.this.MekTable.getMekAt(row, col);
                Entity theEntity = mek.getEntity();
                theEntity.loadAllWeapons();
                new AdvanceRepairDialog(CHQPanel.this.mwclient, theEntity);
            } else if (command.equalsIgnoreCase("RFAA")) {
                int mid = Integer.parseInt(st.nextToken());
                Vector<CArmy> armies = CHQPanel.this.mwclient.getPlayer().getArmies();
                Enumeration<CArmy> e = armies.elements();
                while (e.hasMoreElements()) {
                    CArmy currArmy = e.nextElement();
                    if (!currArmy.hasUnit(mid)) continue;
                    CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c EXM#" + currArmy.getID() + "," + mid);
                }
            } else if (command.equalsIgnoreCase("TM")) {
                int mid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderSendMek_actionPerformed(null, null, mid);
            } else if (command.equalsIgnoreCase("RM")) {
                int mid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c repod#" + mid);
            } else if (command.equalsIgnoreCase("AB")) {
                int mid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderAddToBM_actionPerformed(null, mid);
            } else if (command.equalsIgnoreCase("DSU")) {
                String mid = st.nextToken();
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderDirectSell_actionPerformed(null, null, mid);
            } else if (command.equalsIgnoreCase("S")) {
                int num = Integer.parseInt(st.nextToken());
                int result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to scrap this unit?", "Scrap it?", 0);
                if (result == 0) {
                    CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c scrap#" + num);
                }
            } else if (command.equalsIgnoreCase("MM")) {
                int num = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c setmaintained#" + num);
                CHQPanel.this.mwclient.refreshGUI(MWClient.REFRESH_HQPANEL);
            } else if (command.equalsIgnoreCase("UMM")) {
                int num = Integer.parseInt(st.nextToken());
                int result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to stop maintaining this unit?", "Unmaintain?", 0);
                if (result == 0) {
                    CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c setunmaintained#" + num);
                }
                CHQPanel.this.mwclient.refreshGUI(MWClient.REFRESH_HQPANEL);
            } else if (command.equalsIgnoreCase("DO")) {
                int mid = Integer.parseInt(st.nextToken());
                int result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to donate this unit?", "Donate?", 0);
                if (result == 0) {
                    CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c donate#" + mid);
                }
            } else if (command.equalsIgnoreCase("LCN")) {
                int lid = Integer.parseInt(st.nextToken());
                int mid = Integer.parseInt(st.nextToken());
                int hid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c linkunit#" + lid + "#" + mid + "#" + hid);
            } else if (command.equalsIgnoreCase("EAE")) {
                int row = Integer.parseInt(st.nextToken());
                int col = Integer.parseInt(st.nextToken());
                CUnit mek = CHQPanel.this.MekTable.getMekAt(row, col);
                Mech mech = (Mech)mek.getEntity();
                mech.setAutoEject(true);
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c setautoeject#" + mech.getExternalId() + "#" + true);
            } else if (command.equalsIgnoreCase("DAE")) {
                int row = Integer.parseInt(st.nextToken());
                int col = Integer.parseInt(st.nextToken());
                CUnit mek = CHQPanel.this.MekTable.getMekAt(row, col);
                Mech mech = (Mech)mek.getEntity();
                mech.setAutoEject(false);
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c setautoeject#" + mech.getExternalId() + "#" + false);
            } else if (command.equalsIgnoreCase("EXP")) {
                int uid = Integer.parseInt(st.nextToken());
                int pid = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c EXP#" + uid + "#" + pid);
            } else if (command.equalsIgnoreCase("FET")) {
                CHQPanel.this.mwclient.getMainFrame().jMenuCommanderFireTechs_actionPerformed(null);
            } else if (command.equals("RPU")) {
                int armyid = Integer.parseInt(st.nextToken());
                int unitid = Integer.parseInt(st.nextToken());
                int newpos = Integer.parseInt(st.nextToken());
                CHQPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c unitposition#" + armyid + "#" + unitid + "#" + newpos);
            } else if (command.equals("PHS")) {
                CHQPanel.this.mwclient.getConfig().setParam("PRIMARYHQSORTORDER", st.nextToken());
                CHQPanel.this.mwclient.getConfig().saveConfig();
                CHQPanel.this.mwclient.getPlayer().sortHangar();
            } else if (command.equals("SHS")) {
                CHQPanel.this.mwclient.getConfig().setParam("SECONDARYHQSORTORDER", st.nextToken());
                CHQPanel.this.mwclient.getConfig().saveConfig();
                CHQPanel.this.mwclient.getPlayer().sortHangar();
            } else if (command.equals("THS")) {
                CHQPanel.this.mwclient.getConfig().setParam("TERTIARYHQSORTORDER", st.nextToken());
                CHQPanel.this.mwclient.getConfig().saveConfig();
                CHQPanel.this.mwclient.getPlayer().sortHangar();
            }
            CHQPanel.this.tblMeks.repaint();
        }

        class AlphaFilter
        extends RGBImageFilter {
            int alphaLevel;

            public AlphaFilter(int alpha) {
                this.alphaLevel = alpha;
                this.canFilterIndexColorModel = true;
            }

            public int filterRGB(int x, int y, int rgb) {
                int alpha = rgb >> 24 & 0xFF;
                alpha = alpha * this.alphaLevel / 255;
                return rgb & 0xFFFFFF | alpha << 24;
            }
        }
    }
}

