/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CArmy;
import client.campaign.CCampaign;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import client.gui.AttackMenu;
import client.gui.Browser;
import client.gui.CCommPanel;
import client.gui.CMainPanel;
import client.gui.dialog.HouseNameDialog;
import client.gui.dialog.MechDetailDisplay;
import client.gui.dialog.PlayerNameDialog;
import client.gui.dialog.SellUnitDialog;
import client.gui.dialog.TableViewerDialog;
import client.gui.dialog.TraitDialog;
import client.gui.dialog.UnitSelectionDialog;
import client.gui.dialog.UnitViewerDialog;
import common.campaign.pilot.Pilot;
import common.util.AorAn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import megamek.MegaMek;
import megamek.client.ui.AWT.UnitLoadingDialog;

public class CMainFrame
extends JFrame {
    JPanel contentPane;
    JToolBar ToolBar = new JToolBar();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileConnect = new JMenuItem();
    JMenuItem jMenuFileDisconnect = new JMenuItem();
    JMenuItem jMenuFileConnectTo = new JMenuItem();
    JMenuItem jMenuFileNick = new JMenuItem();
    JMenuItem jMenuFileRegister = new JMenuItem();
    JMenuItem jMenuFileMail = new JMenuItem();
    JMenuItem jMenuFileLastOnline = new JMenuItem();
    JMenuItem jMenuFileSwitchAccount = new JMenuItem();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenuItem jMenuFileConfig = new JMenuItem();
    JMenu jMenuCampaign = new JMenu();
    JMenuItem jMenuCampaignSubStatus = new JMenu();
    JMenuItem jMenuCampaignSubTechs = new JMenu();
    JMenuItem jMenuCampaignSubSend = new JMenu();
    JMenuItem jMenuCampaignSubAttack = new JMenu();
    JMenuItem jMenuCampaignSubMerc = new JMenu();
    JMenuItem jMenuCampaignSubOther = new JMenu();
    JMenuItem jMenuCampaignMyStatus = new JMenuItem();
    JMenuItem jMenuCampaignLogin = new JMenuItem();
    JMenuItem jMenuCampaignActivate = new JMenuItem();
    JMenuItem jMenuCampaignDeactivate = new JMenuItem();
    JMenuItem jMenuCampaignLogout = new JMenuItem();
    JMenuItem jMenuCampaignGames = new JMenuItem();
    JMenuItem jMenuCampaignPlayers = new JMenuItem();
    JMenuItem jMenuCampaignISStatus = new JMenuItem();
    JMenuItem jMenuCampaignHouses = new JMenuItem();
    JMenuItem jMenuCampaignEnroll = new JMenuItem();
    JMenuItem jMenuCampaignUnenroll = new JMenuItem();
    JMenuItem jMenuCampaignBVCalc = new JMenuItem();
    JMenuItem jMenuCampaignHouseStatus = new JMenuItem();
    JMenuItem jMenuCampaignCheckAttack = new JMenuItem();
    JMenuItem jMenuCampaignRange = new JMenuItem();
    JMenuItem jMenuCampaignHouseMail = new JMenuItem();
    JMenuItem jMenuCampaignSendMek = new JMenuItem();
    JMenuItem jMenuCampaignSendMoney = new JMenuItem();
    JMenuItem jMenuCampaignTransferPilot = new JMenuItem();
    JMenuItem jMenuCampaignLogo = new JMenuItem();
    JMenuItem jMenuCampaignPersonalPilotQueue = new JMenuItem();
    JMenuItem jMenuCampaignDonatePersonalPilot = new JMenuItem();
    JMenuItem jMenuCampaignDirectSell = new JMenuItem();
    JMenuItem jMenuCampaignDefect = new JMenuItem();
    JMenuItem jMenuCampaignRewardPoints = new JMenuItem();
    JMenuItem jMenuSubCampaignFireTechs = new JMenuItem();
    JMenuItem jMenuSubCampaignHireTechs = new JMenuItem();
    JMenuItem jMenuMercStatus = new JMenuItem();
    JMenuItem jMenuMercUnemployed = new JMenuItem();
    JMenuItem jMenuMercContracted = new JMenuItem();
    JMenuItem jMenuMercOfferContract = new JMenuItem();
    AttackMenu jMenuAttackMenu;
    JMenu jMenuHost = new JMenu();
    JMenuItem jMenuCSHostAndJoin = new JMenuItem();
    JMenuItem jMenuCSHostDedicated = new JMenuItem();
    JMenuItem jMenuCSHostLoad = new JMenuItem();
    JMenuItem jMenuCSHostLoadAndJoin = new JMenuItem();
    JMenuItem jMenuCSHostStop = new JMenuItem();
    JMenu jMenuOptions = new JMenu();
    JCheckBoxMenuItem jMenuOptionsAutoScroll = new JCheckBoxMenuItem();
    JCheckBoxMenuItem jMenuOptionsMute = new JCheckBoxMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JMenuItem jMenuHelpHelp = new JMenuItem();
    JMenuItem jMenuHelpViewUnit = new JMenuItem();
    JMenuItem jMenuHelpViewBuildTables = new JMenuItem();
    JMenuItem jMenuHelpViewTraits = new JMenuItem();
    JMenu jMenuMod = new JMenu();
    JMenu jMenuAdmin = new JMenu();
    public MWClient mwclient;
    CMainPanel MainPanel;
    boolean colorblind = false;
    CCampaign theCampaign;
    CPlayer thePlayer;
    private boolean hasAdminMenus = false;

    public CMainFrame(MWClient myC) {
        this.mwclient = myC;
        this.theCampaign = this.mwclient.getCampaign();
        this.thePlayer = this.mwclient.getPlayer();
        this.MainPanel = new CMainPanel(this.mwclient, this);
        this.jMenuAttackMenu = new AttackMenu(this.mwclient, -1, "-1");
        this.enableEvents(64L);
        this.setResizable(true);
        this.setSize(new Dimension(640, 480));
        this.setExtendedState(6);
        this.setTitle(this.mwclient.getConfigParam("CAMPAIGNSERVERNAME") + " (MekWars Client " + MWClient.CLIENT_VERSION + ")");
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        try {
            this.createMenu();
        }
        catch (Exception e) {
            MWClient.mwClientLog.clientErrLog(e);
        }
        this.setJMenuBar(this.jMenuBar1);
        this.enableMenu();
        this.repaint();
        this.contentPane.add((Component)this.MainPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (CMainFrame.this.mwclient.isServerRunning()) {
                    int result = JOptionPane.showConfirmDialog(new JFrame(), "Are you sure you want to exit? You are hosting a game!");
                    if (result == 0) {
                        CMainFrame.this.mwclient.goodbye();
                        System.exit(0);
                    }
                } else {
                    CMainFrame.this.mwclient.goodbye();
                    System.exit(0);
                }
            }
        });
    }

    public CMainPanel getMainPanel() {
        return this.MainPanel;
    }

    public void setColorBlind(boolean tcolorblind) {
        this.colorblind = tcolorblind;
    }

    public void enableMenu() {
        boolean disconnected = false;
        boolean loggedout = false;
        boolean loggedin = false;
        boolean reserve = false;
        boolean active = false;
        boolean fighting = false;
        boolean admin = false;
        boolean mod = false;
        if (this.mwclient.getMyStatus() == MWClient.STATUS_DISCONNECTED) {
            disconnected = true;
        }
        if (this.mwclient.getMyStatus() == MWClient.STATUS_LOGGEDOUT) {
            loggedout = true;
        }
        if (this.mwclient.getMyStatus() == MWClient.STATUS_LOGGEDIN) {
            loggedin = true;
            reserve = true;
        }
        if (this.mwclient.getMyStatus() == MWClient.STATUS_ACTIVE) {
            loggedin = true;
            active = true;
        }
        if (this.mwclient.getMyStatus() == MWClient.STATUS_FIGHTING) {
            loggedin = true;
            fighting = true;
        }
        if (this.mwclient.isAdmin()) {
            admin = true;
        }
        if (this.mwclient.isMod()) {
            mod = true;
        }
        if ((mod || admin) && !this.hasAdminMenus) {
            this.mwclient.loadServerCommmands();
            File loadJar = new File("./MekWarsAdmin.jar");
            if (!loadJar.exists()) {
                MWClient.mwClientLog.clientErrLog("Player/Server menu creation skipped. No MekWarsAdmin.jar present.");
            } else {
                JMenu tempMenu;
                Object o;
                Class<?> c;
                URLClassLoader loader;
                try {
                    loader = new URLClassLoader(new URL[]{loadJar.toURL()});
                    c = loader.loadClass("admin.ModeratorMenu");
                    o = c.newInstance();
                    c.getDeclaredMethod("createMenu", MWClient.class).invoke(o, this.mwclient);
                    tempMenu = (JMenu)o;
                    this.jMenuMod.setText(tempMenu.getText());
                    this.jMenuBar1.add(tempMenu);
                    this.jMenuBar1.remove(this.jMenuMod);
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog("ModeratorMenu creation FAILED!");
                    MWClient.mwClientLog.clientErrLog(ex);
                }
                try {
                    loader = new URLClassLoader(new URL[]{loadJar.toURL()});
                    c = loader.loadClass("admin.AdminMenu");
                    o = c.newInstance();
                    c.getDeclaredMethod("createMenu", MWClient.class).invoke(o, this.mwclient);
                    tempMenu = (JMenu)o;
                    if (tempMenu.getItemCount() > 0) {
                        this.jMenuBar1.add(tempMenu);
                    }
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog("AdminMenu creation FAILED!");
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
            this.hasAdminMenus = true;
        }
        this.jMenuMod.setVisible(mod);
        this.jMenuCampaign.setVisible(!disconnected);
        this.jMenuCampaignMyStatus.setVisible(loggedin);
        this.jMenuCampaignSubAttack.setVisible(loggedin);
        this.jMenuCampaignSubMerc.setVisible(loggedin);
        this.jMenuCampaignSubSend.setVisible(loggedin);
        this.jMenuCampaignSubStatus.setVisible(loggedin);
        this.jMenuCampaignSubTechs.setVisible(loggedin);
        this.jMenuCampaignSubOther.setVisible(loggedin);
        this.jMenuHost.setVisible(!disconnected);
        this.jMenuFileConnect.setVisible(disconnected);
        this.jMenuFileConnectTo.setVisible(disconnected);
        this.jMenuFileDisconnect.setVisible(!disconnected);
        this.jMenuFileRegister.setVisible(!disconnected);
        this.jMenuFileMail.setVisible(!disconnected);
        this.jMenuFileSwitchAccount.setVisible(!disconnected);
        this.jMenuFileLastOnline.setVisible(!disconnected);
        this.jMenuFileConfig.setVisible(true);
        this.jMenuCampaignLogin.setVisible(loggedout);
        this.jMenuCampaignActivate.setVisible(reserve);
        this.jMenuCampaignDeactivate.setVisible(active);
        this.jMenuCampaignLogout.setVisible(loggedin);
        this.jMenuCampaignPersonalPilotQueue.setVisible(Boolean.valueOf(this.mwclient.getserverConfigs("AllowPersonalPilotQueues")));
        this.jMenuCampaignTransferPilot.setVisible(Boolean.valueOf(this.mwclient.getserverConfigs("AllowPersonalPilotQueues")));
        this.jMenuCampaignDirectSell.setVisible(Boolean.valueOf(this.mwclient.getserverConfigs("UseDirectSell")));
        this.jMenuCampaignDonatePersonalPilot.setVisible(Boolean.valueOf(this.mwclient.getserverConfigs("AllowPersonalPilotQueues")));
        this.jMenuCampaignEnroll.setVisible(loggedout);
    }

    protected void createMenu() throws Exception {
        this.jMenuFile.setText("File");
        this.jMenuFile.setMnemonic('F');
        this.jMenuFileNick.setText("Change nick");
        this.jMenuFileNick.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileNick_actionPerformed(e);
            }
        });
        this.jMenuFileConnect.setText("Connect");
        this.jMenuFileConnect.setMnemonic('C');
        this.jMenuFileConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileConnect_actionPerformed(e);
            }
        });
        this.jMenuFileDisconnect.setText("Disconnect");
        this.jMenuFileDisconnect.setMnemonic('D');
        this.jMenuFileDisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.getConnector().closeConnection();
            }
        });
        this.jMenuFileConnectTo.setText("Connect to");
        this.jMenuFileConnectTo.setMnemonic('T');
        this.jMenuFileConnectTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileConnectTo_actionPerformed(e);
            }
        });
        this.jMenuFileRegister.setText("Register Nickname");
        this.jMenuFileRegister.setMnemonic('R');
        this.jMenuFileRegister.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileRegister_actionPerformed(e);
            }
        });
        this.jMenuFileMail.setText("Mail User");
        this.jMenuFileMail.setMnemonic('M');
        this.jMenuFileMail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileMail_actionPerformed(e, null);
            }
        });
        this.jMenuFileLastOnline.setText("Last Online");
        this.jMenuFileLastOnline.setMnemonic('L');
        this.jMenuFileLastOnline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileLastOnline_actionPerformed(e);
            }
        });
        this.jMenuFileSwitchAccount.setText("Switch Account");
        this.jMenuFileSwitchAccount.setMnemonic('S');
        this.jMenuFileSwitchAccount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileSwitchAccount_actionPerformed(e);
            }
        });
        this.jMenuFileConfig.setText("Configuration");
        this.jMenuFileConfig.setMnemonic('C');
        this.jMenuFileConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.clientConfiguration();
            }
        });
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.setMnemonic('X');
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuCampaign.setText("Campaign");
        this.jMenuCampaign.setMnemonic('C');
        this.jMenuCampaignLogin.setText("Log in!");
        this.jMenuCampaignLogin.setMnemonic('I');
        this.jMenuCampaignLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c login");
            }
        });
        this.jMenuCampaignActivate.setText("Active duty!");
        this.jMenuCampaignActivate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c activate");
            }
        });
        this.jMenuCampaignDeactivate.setText("Reserve duty!");
        this.jMenuCampaignDeactivate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c deactivate");
            }
        });
        this.jMenuCampaignLogout.setText("Log out!");
        this.jMenuCampaignLogout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c logout");
            }
        });
        this.jMenuCampaignGames.setText("Games Status");
        this.jMenuCampaignGames.setMnemonic('G');
        this.jMenuCampaignGames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c games");
            }
        });
        this.jMenuCampaignPlayers.setText("Players Status");
        this.jMenuCampaignPlayers.setMnemonic('P');
        this.jMenuCampaignPlayers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c players");
            }
        });
        this.jMenuCampaignISStatus.setText("Plantary Control");
        this.jMenuCampaignISStatus.setMnemonic('C');
        this.jMenuCampaignISStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCampaignISStatus_actionPerformed(e);
            }
        });
        this.jMenuCampaignHouses.setText("Houses Status");
        this.jMenuCampaignHouses.setMnemonic('H');
        this.jMenuCampaignHouses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c housestatus");
            }
        });
        this.jMenuCampaignEnroll.setText("Enroll");
        this.jMenuCampaignEnroll.setMnemonic('N');
        this.jMenuCampaignEnroll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCampaignEnroll_actionPerformed(e);
            }
        });
        this.jMenuCampaignUnenroll.setText("Un-Enroll");
        this.jMenuCampaignUnenroll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCampaignUnenroll_actionPerformed(e);
            }
        });
        this.jMenuCampaign.setText("Campaign");
        this.jMenuCampaign.setMnemonic('C');
        this.jMenuCampaignSubTechs.setText("Techs");
        this.jMenuCampaignSubTechs.setMnemonic('T');
        this.jMenuCampaignSubSend.setText("Send");
        this.jMenuCampaignSubSend.setMnemonic('S');
        this.jMenuCampaignSubAttack.setText("Front Line");
        this.jMenuCampaignSubAttack.setMnemonic('F');
        this.jMenuCampaignSubStatus.setText("Status");
        this.jMenuCampaignSubStatus.setMnemonic('U');
        this.jMenuCampaignSubOther.setText("Other");
        this.jMenuCampaignSubOther.setMnemonic('O');
        this.jMenuCampaignMyStatus.setText("My Status");
        this.jMenuCampaignMyStatus.setMnemonic('M');
        this.jMenuCampaignMyStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c mystatus");
            }
        });
        this.jMenuCampaignCheckAttack.setText("Attack Options");
        this.jMenuCampaignCheckAttack.setMnemonic('A');
        this.jMenuCampaignCheckAttack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderCheckAttack_actionPerformed(e, -1);
            }
        });
        this.jMenuCampaignRange.setText("Range Calculator");
        this.jMenuCampaignRange.setMnemonic('R');
        this.jMenuCampaignRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderRange_actionPerformed(e);
            }
        });
        this.jMenuCampaignHouseMail.setText("Send House Mail");
        this.jMenuCampaignHouseMail.setMnemonic('L');
        this.jMenuCampaignHouseMail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderHouseMail_actionPerformed(e);
            }
        });
        this.jMenuCampaignSendMek.setText("Send Mek");
        this.jMenuCampaignSendMek.setMnemonic('E');
        this.jMenuCampaignSendMek.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderSendMek_actionPerformed(e, null, -1);
            }
        });
        this.jMenuCampaignSendMoney.setText("Send " + this.mwclient.moneyOrFluMessage(true, true, -2));
        this.jMenuCampaignSendMoney.setMnemonic('Y');
        this.jMenuCampaignSendMoney.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderSendMoney_actionPerformed(e, null);
            }
        });
        this.jMenuCampaignLogo.setText("Set Logo");
        this.jMenuCampaignLogo.setMnemonic('L');
        this.jMenuCampaignLogo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderLogo_actionPerformed(e);
            }
        });
        this.jMenuCampaignPersonalPilotQueue.setText("View Pilot Queue");
        this.jMenuCampaignPersonalPilotQueue.setMnemonic('Q');
        this.jMenuCampaignPersonalPilotQueue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderPersonalPilotQueue_actionPerformed(e);
            }
        });
        this.jMenuCampaignDonatePersonalPilot.setText("Donate Pilot");
        this.jMenuCampaignDonatePersonalPilot.setMnemonic('o');
        this.jMenuCampaignDonatePersonalPilot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderDonatePersonalPilot_actionPerformed(e);
            }
        });
        this.jMenuCampaignDirectSell.setText("Direct Sell Unit");
        this.jMenuCampaignDirectSell.setMnemonic('S');
        this.jMenuCampaignDirectSell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderDirectSell_actionPerformed(e, null, null);
            }
        });
        this.jMenuCampaignTransferPilot.setText("Send Pilot");
        this.jMenuCampaignTransferPilot.setMnemonic('T');
        this.jMenuCampaignTransferPilot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderTransferPilot_actionPerformed(e, null);
            }
        });
        this.jMenuCampaignDefect.setText("Defect");
        this.jMenuCampaignDefect.setMnemonic('D');
        this.jMenuCampaignDefect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderDefect_actionPerformed(e);
            }
        });
        this.jMenuCampaignBVCalc.setText("BV Calculator");
        this.jMenuCampaignBVCalc.setMnemonic('V');
        this.jMenuCampaignBVCalc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderBVCalc_actionPerformed(e);
            }
        });
        this.jMenuCampaignRewardPoints.setText("Use Reward Points");
        this.jMenuCampaignRewardPoints.setMnemonic('P');
        this.jMenuCampaignRewardPoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.RewardPoints();
            }
        });
        this.jMenuSubCampaignHireTechs.setText("Hire Techs");
        this.jMenuSubCampaignHireTechs.setMnemonic('H');
        this.jMenuSubCampaignHireTechs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderHireTechs_actionPerformed(e);
            }
        });
        this.jMenuSubCampaignFireTechs.setText("Fire Techs");
        this.jMenuSubCampaignFireTechs.setMnemonic('F');
        this.jMenuSubCampaignFireTechs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuCommanderFireTechs_actionPerformed(e);
            }
        });
        this.jMenuCampaignSubMerc.setText("Mercenaries");
        this.jMenuCampaignSubMerc.setMnemonic('r');
        this.jMenuMercOfferContract.setText("Offer a Mercenary Contract");
        this.jMenuMercOfferContract.setMnemonic('O');
        this.jMenuMercOfferContract.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuMercOfferContract_actionPerformed(e);
            }
        });
        this.jMenuMercStatus.setText("Mercenary Status");
        this.jMenuMercStatus.setMnemonic('M');
        this.jMenuMercStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuMercStatus_actionPerformed(e);
            }
        });
        this.jMenuMercUnemployed.setText("Unemployed Mercs");
        this.jMenuMercUnemployed.setMnemonic('U');
        this.jMenuMercUnemployed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c unemployedmercs");
            }
        });
        this.jMenuMercContracted.setText("Contracted Mercs");
        this.jMenuMercContracted.setMnemonic('C');
        this.jMenuMercContracted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c factioncontracts");
            }
        });
        this.jMenuHost.setText("Host");
        this.jMenuHost.setMnemonic('S');
        this.jMenuCSHostAndJoin.setText("Start Hosting (and Join)");
        this.jMenuCSHostAndJoin.setMnemonic('H');
        this.jMenuCSHostAndJoin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.startHost();
                CMainFrame.this.mwclient.startHost(false, true, false);
            }
        });
        this.jMenuCSHostDedicated.setText("Start Dedicated Host");
        this.jMenuCSHostDedicated.setMnemonic('D');
        this.jMenuCSHostDedicated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.startHost();
                CMainFrame.this.mwclient.startHost(true, false, false);
            }
        });
        this.jMenuCSHostLoad.setText("Start Dedicated Host (Load Savegame)");
        this.jMenuCSHostLoad.setMnemonic('L');
        this.jMenuCSHostLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.startHost();
                CMainFrame.this.mwclient.startHost(true, false, true);
            }
        });
        this.jMenuCSHostLoadAndJoin.setText("Start Hosting (Load Savegame and Join)");
        this.jMenuCSHostLoadAndJoin.setMnemonic('S');
        this.jMenuCSHostLoadAndJoin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.startHost();
                CMainFrame.this.mwclient.startHost(false, false, true);
            }
        });
        this.jMenuCSHostStop.setText("Stop Hosting");
        this.jMenuCSHostStop.setMnemonic('S');
        this.jMenuCSHostStop.setEnabled(false);
        this.jMenuCSHostStop.setVisible(false);
        this.jMenuCSHostStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.stopHost();
                CMainFrame.this.mwclient.stopHost();
            }
        });
        this.jMenuOptions.setText("Options");
        this.jMenuOptions.setMnemonic('I');
        this.jMenuOptionsAutoScroll.setText("Auto Scroll");
        this.jMenuOptionsAutoScroll.setMnemonic('A');
        this.jMenuOptionsAutoScroll.setState(this.MainPanel.getCommPanel().autoTextUpdate);
        this.jMenuOptionsAutoScroll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean newValue;
                CMainFrame.this.MainPanel.getCommPanel().autoTextUpdate = newValue = !CMainFrame.this.MainPanel.getCommPanel().autoTextUpdate;
                CMainFrame.this.jMenuOptionsAutoScroll.setState(newValue);
                if (newValue) {
                    CMainFrame.this.mwclient.getConfig().setParam("AUTOSCROLL", "true");
                } else {
                    CMainFrame.this.mwclient.getConfig().setParam("AUTOSCROLL", "false");
                }
                CMainFrame.this.mwclient.getConfig().saveConfig();
            }
        });
        this.jMenuOptionsMute.setText("Mute");
        this.jMenuOptionsMute.setMnemonic('M');
        this.jMenuOptionsMute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.mwclient.setSoundMuted(CMainFrame.this.jMenuOptionsMute.getState());
            }
        });
        this.jMenuHelp.setText("Help");
        this.jMenuHelp.setMnemonic('E');
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.setMnemonic('A');
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.jMenuHelpHelp.setText("Online Help");
        this.jMenuHelpHelp.setMnemonic('H');
        this.jMenuHelpHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuHelpHelp_actionPerformed(e);
            }
        });
        this.jMenuHelpViewUnit.setText("Unit Viewer");
        this.jMenuHelpViewUnit.setMnemonic('U');
        this.jMenuHelpViewUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CMainFrame.this.jMenuHelpViewUnit_actionPerformed(e);
            }
        });
        this.jMenuHelpViewBuildTables.setText("Build Table Viewer");
        this.jMenuHelpViewBuildTables.setMnemonic('B');
        this.jMenuHelpViewBuildTables.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File f = new File("./data/buildtables.zip");
                if (f.exists()) {
                    TableViewerDialog tableViewerDialog = new TableViewerDialog(CMainFrame.this.mwclient);
                } else {
                    CMainFrame.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c buildtablelist");
                }
            }
        });
        this.jMenuHelpViewTraits.setText("View Faction Traits");
        this.jMenuHelpViewTraits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new TraitDialog(CMainFrame.this.mwclient, true);
            }
        });
        try {
            Properties p = new Properties();
            File configfile = new File(this.mwclient.getCacheDir() + "/links.txt");
            if (configfile.exists()) {
                FileInputStream fis = new FileInputStream(configfile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                while (dis.ready()) {
                    String line = dis.readLine();
                    StringTokenizer ST = new StringTokenizer(line, ":");
                    String elementname = ST.nextToken();
                    String url = ST.nextToken();
                    while (ST.hasMoreElements()) {
                        url = url + ":" + ST.nextToken();
                    }
                    final String URL2 = url;
                    JMenuItem item = new JMenuItem(elementname);
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                Browser.displayURL(URL2);
                            }
                            catch (Exception ex) {
                                MWClient.mwClientLog.clientErrLog(ex);
                            }
                        }
                    });
                    this.jMenuHelp.add(item);
                }
                dis.close();
                fis.close();
                this.jMenuHelp.addSeparator();
            } else {
                MWClient.mwClientLog.clientOutputLog("no links.txt provided. Help menu will be very limited for this server.");
            }
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
        JMenuItem jMenuMekwarsBug = new JMenuItem("Report Bug (MekWars)");
        JMenuItem jMenuMegamekBug = new JMenuItem("Report Bug (MegaMek)");
        JMenuItem jMenuMekwarsRFE = new JMenuItem("RFE (MekWars)");
        JMenuItem jMenuMegamekRFE = new JMenuItem("RFE (MegaMek)");
        ActionListener mekwarsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Browser.displayURL("http://sourceforge.net/tracker/?group_id=122002&atid=692058");
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
        };
        ActionListener megamekListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Browser.displayURL("http://sourceforge.net/tracker/?group_id=47079&atid=448394");
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
        };
        ActionListener megamekRFEListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Browser.displayURL("http://sourceforge.net/tracker/?group_id=47079&atid=448397");
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
        };
        ActionListener mekwarsRFEListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Browser.displayURL("http://sourceforge.net/tracker/?group_id=122002&atid=692061");
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
        };
        jMenuMekwarsBug.addActionListener(mekwarsListener);
        jMenuMegamekBug.addActionListener(megamekListener);
        jMenuMegamekRFE.addActionListener(megamekRFEListener);
        jMenuMekwarsRFE.addActionListener(mekwarsRFEListener);
        this.jMenuFile.add(this.jMenuFileConnect);
        this.jMenuFile.add(this.jMenuFileConnectTo);
        this.jMenuFile.add(this.jMenuFileRegister);
        this.jMenuFile.add(this.jMenuFileMail);
        this.jMenuFile.add(this.jMenuFileLastOnline);
        this.jMenuFile.add(this.jMenuFileSwitchAccount);
        this.jMenuFile.add(this.jMenuFileConfig);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileDisconnect);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuCampaignSubAttack.add(this.jMenuCampaignCheckAttack);
        this.jMenuCampaignSubAttack.add(this.jMenuCampaignRange);
        this.jMenuCampaignSubAttack.add(this.jMenuCampaignBVCalc);
        this.jMenuCampaignSubSend.add(this.jMenuCampaignHouseMail);
        this.jMenuCampaignSubSend.add(this.jMenuCampaignSendMoney);
        this.jMenuCampaignSubSend.add(this.jMenuCampaignSendMek);
        this.jMenuCampaignSubSend.add(this.jMenuCampaignTransferPilot);
        this.jMenuCampaignSubTechs.add(this.jMenuSubCampaignHireTechs);
        this.jMenuCampaignSubTechs.add(this.jMenuSubCampaignFireTechs);
        this.jMenuCampaignSubStatus.add(this.jMenuCampaignGames);
        this.jMenuCampaignSubStatus.add(this.jMenuCampaignPlayers);
        this.jMenuCampaignSubStatus.add(this.jMenuCampaignISStatus);
        this.jMenuCampaignSubStatus.add(this.jMenuCampaignHouses);
        this.jMenuCampaignSubMerc.add(this.jMenuMercStatus);
        this.jMenuCampaignSubMerc.add(this.jMenuMercUnemployed);
        this.jMenuCampaignSubMerc.add(this.jMenuMercContracted);
        this.jMenuCampaignSubMerc.add(this.jMenuMercOfferContract);
        this.jMenuCampaignSubOther.add(this.jMenuCampaignLogo);
        this.jMenuCampaignSubOther.add(this.jMenuCampaignDefect);
        this.jMenuCampaignSubOther.add(this.jMenuCampaignRewardPoints);
        this.jMenuCampaignSubOther.add(this.jMenuCampaignPersonalPilotQueue);
        this.jMenuCampaignSubOther.add(this.jMenuCampaignDonatePersonalPilot);
        this.jMenuCampaignSubOther.add(this.jMenuCampaignDirectSell);
        this.jMenuCampaign.add(this.jMenuCampaignMyStatus);
        this.jMenuCampaign.add(this.jMenuCampaignSubAttack);
        this.jMenuCampaign.addSeparator();
        this.jMenuCampaign.add(this.jMenuCampaignSubMerc);
        this.jMenuCampaign.add(this.jMenuCampaignSubSend);
        this.jMenuCampaign.add(this.jMenuCampaignSubStatus);
        this.jMenuCampaign.add(this.jMenuCampaignSubTechs);
        this.jMenuCampaign.add(this.jMenuCampaignSubOther);
        this.jMenuCampaign.addSeparator();
        this.jMenuCampaign.add(this.jMenuCampaignLogin);
        this.jMenuCampaign.add(this.jMenuCampaignActivate);
        this.jMenuCampaign.add(this.jMenuCampaignDeactivate);
        this.jMenuCampaign.add(this.jMenuCampaignLogout);
        if (this.jMenuCampaignEnroll.isVisible()) {
            this.jMenuCampaign.add(this.jMenuCampaignEnroll);
        }
        this.jMenuHost.add(this.jMenuCSHostAndJoin);
        this.jMenuHost.add(this.jMenuCSHostLoadAndJoin);
        this.jMenuHost.add(this.jMenuCSHostDedicated);
        this.jMenuHost.add(this.jMenuCSHostLoad);
        this.jMenuHost.add(this.jMenuCSHostStop);
        this.jMenuOptions.add(this.jMenuOptionsAutoScroll);
        this.jMenuOptions.add(this.jMenuOptionsMute);
        JCheckBoxMenuItem fasaBV = new JCheckBoxMenuItem("Show Fasa-BV Ratio");
        fasaBV.setMnemonic('F');
        MechDetailDisplay.SHOW_BV_RATIO = this.mwclient.getConfig().isFASABVRation();
        fasaBV.setState(MechDetailDisplay.SHOW_BV_RATIO);
        fasaBV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MechDetailDisplay.SHOW_BV_RATIO = !MechDetailDisplay.SHOW_BV_RATIO;
            }
        });
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuHelp.addSeparator();
        this.jMenuHelp.add(this.jMenuHelpViewUnit);
        this.jMenuHelp.add(this.jMenuHelpViewBuildTables);
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforTNforMek")) > 0) {
            this.jMenuHelp.add(this.jMenuHelpViewTraits);
        }
        this.jMenuHelp.add(this.jMenuHelpHelp);
        this.jMenuHelp.addSeparator();
        this.jMenuHelp.add(jMenuMekwarsBug);
        this.jMenuHelp.add(jMenuMegamekBug);
        this.jMenuHelp.addSeparator();
        this.jMenuHelp.add(jMenuMekwarsRFE);
        this.jMenuHelp.add(jMenuMegamekRFE);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuCampaign);
        this.jMenuBar1.add(this.jMenuAttackMenu);
        this.jMenuBar1.add(this.jMenuHost);
        this.jMenuBar1.add(this.jMenuOptions);
        this.jMenuBar1.add(this.jMenuHelp);
        this.jMenuBar1.add(this.jMenuMod);
    }

    public void jMenuFileNick_actionPerformed(ActionEvent e) {
        String NewNick = JOptionPane.showInputDialog(this.getContentPane(), (Object)"NewNick");
        if (NewNick == null) {
            return;
        }
        String Password = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Message");
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "nick " + NewNick + "," + Password);
    }

    public void jMenuFileConnect_actionPerformed(ActionEvent e) {
        this.mwclient.connectToServer();
    }

    public void jMenuFileSwitchAccount_actionPerformed(ActionEvent e) {
        this.mwclient.connectionSwitch();
    }

    public void jMenuFileConnectTo_actionPerformed(ActionEvent e) {
    }

    public void jMenuFileRegister_actionPerformed(ActionEvent e) {
        String Nickname = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Nickname");
        if (Nickname == null) {
            return;
        }
        String Password = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Password");
        if (Password == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "register " + Nickname + "," + Password);
    }

    public void jMenuFileMail_actionPerformed(ActionEvent e, String Nickname) {
        if (Nickname == null && (Nickname = JOptionPane.showInputDialog(this.getContentPane(), "Nickname", "Send mail to whom?", -1)) == null) {
            return;
        }
        String message = JOptionPane.showInputDialog(this.getContentPane(), "message", "Send mail to " + Nickname, -1);
        if (message == null) {
            return;
        }
        this.mwclient.processGUIInput(MWClient.GUI_PREFIX + "mail " + Nickname + "," + message);
    }

    public void jMenuFileLastOnline_actionPerformed(ActionEvent e) {
        String Nickname = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Playername?");
        if (Nickname == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c lastonline#" + Nickname);
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        this.mwclient.goodbye();
        System.exit(0);
    }

    public void jMenuCampaignISStatus_actionPerformed(ActionEvent e) {
        String House2 = "";
        String House22 = "";
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", true);
        factionDialog.setVisible(true);
        House2 = factionDialog.getHouseName();
        factionDialog.dispose();
        if (House2 == null) {
            return;
        }
        if (!House2.equals("")) {
            factionDialog = new HouseNameDialog(this.mwclient, "Secondary Faction", true);
            factionDialog.setVisible(true);
            House22 = factionDialog.getHouseName();
            factionDialog.dispose();
            this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c isstatus#" + House2 + "#" + House22);
        } else {
            this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c isstatus");
        }
    }

    public void jMenuMercStatus_actionPerformed(ActionEvent e) {
        String Merc = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Which Mercenary do you want your contracts to find?");
        if (Merc == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c mstatus#" + Merc);
    }

    public void jMenuCampaignEnroll_actionPerformed(ActionEvent e) {
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c enroll#");
    }

    public void jMenuCampaignUnenroll_actionPerformed(ActionEvent e) {
        String Confirmation = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Enter \"CONFIRM\" to confirm it");
        if (Confirmation == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c unenroll#" + Confirmation);
    }

    public void jMenuCommanderCheckAttack_actionPerformed(ActionEvent e, int lid) {
        if (lid == -1) {
            String Lances = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Any Specfic Army? (leave blank for all)");
            if (Lances != null) {
                this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c ca#" + Lances);
            }
        } else {
            this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c ca#" + lid);
        }
    }

    public void jMenuCommanderRange_actionPerformed(ActionEvent e) {
        String range = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Max distance in Lightyears?");
        if (range == null) {
            return;
        }
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false);
        factionDialog.setVisible(true);
        String faction = factionDialog.getHouseName();
        factionDialog.dispose();
        if (faction == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c range#" + range + "#" + faction);
    }

    public void jMenuCommanderHouseMail_actionPerformed(ActionEvent e) {
        String Housemail = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Housemail");
        if (Housemail == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c HouseMail#" + Housemail);
    }

    public void jMenuCommanderSendMoney_actionPerformed(ActionEvent e, String name) {
        String targetPlayer;
        if (name == null || name.trim().equals("")) {
            PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Transfer Recipient", true);
            pnd.setVisible(true);
            targetPlayer = pnd.getPlayerName();
            pnd.dispose();
        } else {
            targetPlayer = name;
        }
        if (targetPlayer == null) {
            return;
        }
        String Amount = JOptionPane.showInputDialog(this.getContentPane(), "Amount", "Send " + this.mwclient.moneyOrFluMessage(true, true, -2) + " to " + targetPlayer, -1);
        if (Amount == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c transfermoney#" + targetPlayer + "#" + Amount);
    }

    public void jMenuCommanderSendMek_actionPerformed(ActionEvent e, String name, int mid) {
        String targetPlayer;
        if (name == null || name.trim().equals("")) {
            PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Transfer Recipient", true);
            pnd.setVisible(true);
            targetPlayer = pnd.getPlayerName();
            pnd.dispose();
        } else {
            targetPlayer = name;
        }
        if (targetPlayer == null) {
            return;
        }
        if (mid == -1) {
            UnitSelectionDialog usd = new UnitSelectionDialog(this.mwclient, "Transfer Unit", "Select unit to transfer:");
            usd.setVisible(true);
            mid = Integer.parseInt(usd.getUnitID());
            usd.dispose();
        }
        if (mid == -1) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c transferunit#" + targetPlayer + "#" + mid);
    }

    public void jMenuCommanderAddToBM_actionPerformed(ActionEvent e, int mid) {
        Vector<CUnit> toSell = new Vector<CUnit>();
        toSell.add(this.mwclient.getPlayer().getUnit(mid));
        SellUnitDialog sud = new SellUnitDialog(this, this.mwclient, toSell);
        sud.setVisible(true);
    }

    public void jMenuCommanderRemoveLance_actionPerformed(ActionEvent e, int lid) {
        if (lid == -1) {
            String LanceID = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Army ID?");
            if (LanceID == null) {
                return;
            }
            lid = Integer.parseInt(LanceID);
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c rma#" + lid);
    }

    public void jMenuCommanderNamePilot_actionPerformed(ActionEvent e, int mid) {
        String newName;
        if (mid == -1) {
            String mechid = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Mech ID?");
            if (mechid == null) {
                return;
            }
            mid = Integer.parseInt(mechid);
        }
        if ((newName = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Pilots Name?")) == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c namepilot#" + mid + "#" + newName);
    }

    public void jMenuCommanderNameArmy_actionPerformed(ActionEvent e, int mid) {
        if (mid == -1) {
            String mechid = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Army ID?");
            if (mechid == null) {
                return;
            }
            mid = Integer.parseInt(mechid);
        }
        CArmy selectedArmy = this.mwclient.getPlayer().getArmies().get(mid);
        String newName = JOptionPane.showInputDialog(this.getContentPane(), "New army name?", selectedArmy.getName());
        if (newName == null) {
            newName = " ";
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c namearmy#" + mid + "#" + newName);
    }

    public void jMenuCommanderSetLowerUnitLimit_actionPerformed(int lid) {
        int newLimit = -1;
        if (lid == -1) {
            String id = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Army Number?");
            if (id == null) {
                return;
            }
            lid = Integer.parseInt(id);
        }
        CArmy selectedArmy = this.mwclient.getPlayer().getArmies().get(lid);
        String example = "Example: An Army of 8 units with a Lower Limit of<br>4 will not be able to fight an Army with only 3 units.<br>This can be useful if you want to avoid fighting a<br>small number of super heavy/levelled units.";
        String limit = JOptionPane.showInputDialog(this.getContentPane(), "<HTML>Lower Limit? [-1 to disable the limit]<i><br><br>" + example + "<br></i></HTML>", Integer.toString(selectedArmy.getLowerLimiter()), -1);
        if (limit == null) {
            return;
        }
        newLimit = Integer.parseInt(limit);
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c all#" + lid + "#" + newLimit);
    }

    public void jMenuCommanderSetUpperUnitLimit_actionPerformed(int lid) {
        int newLimit = -1;
        if (lid == -1) {
            String id = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Army Number?");
            if (id == null) {
                return;
            }
            lid = Integer.parseInt(id);
        }
        CArmy selectedArmy = this.mwclient.getPlayer().getArmies().get(lid);
        String example = "Example: An Army of 4 units with an Upper Limit of 5<br>will not be able to fight againt Armies with more than<br>9 units. This can be useful if you don't want to play<br>againts swarms";
        String limit = JOptionPane.showInputDialog(this.getContentPane(), "<HTML>Upper Limit? [-1 to disable the limit]<i><br><br>" + example + "<br></i></HTML>", Integer.toString(selectedArmy.getLowerLimiter()).toString(), -1);
        if (limit == null) {
            return;
        }
        newLimit = Integer.parseInt(limit);
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c aul#" + lid + "#" + newLimit);
    }

    public void jMenuCommanderRetirePilot_actionPerformed(int mid) {
        if (mid == -1) {
            String mechid = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Mech ID?");
            if (mechid == null) {
                return;
            }
            mid = Integer.parseInt(mechid);
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c retirepilot#" + mid);
    }

    public void jMenuCommanderLogo_actionPerformed(ActionEvent e) {
        String LogoURL = JOptionPane.showInputDialog(this.getContentPane(), (Object)"URL? (terrainID.e. http://www.mysite.com/mypic.jpg)");
        if (LogoURL == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c setmylogo#" + LogoURL);
    }

    public void jMenuCommanderPersonalPilotQueue_actionPerformed(ActionEvent e) {
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c displayplayerpersonalpilotqueue");
    }

    public void jMenuCommanderTransferPilot_actionPerformed(ActionEvent e, String name) {
        String targetPlayer;
        if (name == null || name.trim().equals("")) {
            PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Transfer Recipient", true);
            pnd.setVisible(true);
            targetPlayer = pnd.getPlayerName();
            pnd.dispose();
        } else {
            targetPlayer = name;
        }
        if (targetPlayer == null) {
            return;
        }
        Object[] pSize = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        Object[] pClass = new Object[]{"Mek", "Proto"};
        int sizeType = 0;
        int classType = 0;
        String pClassstr = (String)JOptionPane.showInputDialog(null, "Select a pilot unit class", "Pilot Class", 1, null, pClass, pClass[0]);
        if (pClassstr == null || pClassstr.length() == 0) {
            return;
        }
        classType = pClassstr.equals("Mek") ? 0 : 3;
        String pSizestr = (String)JOptionPane.showInputDialog(null, "Select a pilot unit size", "Pilot Size", 1, null, pSize, pSize[0]);
        if (pSizestr == null || pSizestr.length() == 0) {
            return;
        }
        sizeType = CUnit.getWeightIDForName(pSizestr);
        if (this.mwclient.getPlayer().getPlayerPersonalPilotQueue().getQueueSize(classType, sizeType) < 1) {
            JOptionPane.showMessageDialog(null, "You do not have any pilots for " + AorAn.check(pSizestr, true) + " " + pSizestr + " " + pClassstr, "No Pilots!", -1);
            return;
        }
        Object[] pilots = this.mwclient.getPlayer().getPlayerPersonalPilotQueue().getPilotQueue(classType, sizeType).toArray();
        JComboBox<String> combo = new JComboBox<String>();
        for (int i = 0; i < pilots.length; ++i) {
            Pilot mm = (Pilot)pilots[i];
            if (classType == 0) {
                combo.addItem(mm.getName() + " (" + mm.getGunnery() + "/" + mm.getPiloting() + ")[" + mm.getSkillString(true) + "]");
                continue;
            }
            combo.addItem(mm.getName() + " (" + mm.getGunnery() + ")[" + mm.getSkillString(true) + "]");
        }
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select a pilot.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        int position = combo.getSelectedIndex();
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c transferpilot#" + targetPlayer + "#" + classType + "#" + sizeType + "#" + position);
    }

    public void jMenuCommanderDonatePersonalPilot_actionPerformed(ActionEvent e) {
        Object[] pSize = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        Object[] pClass = new Object[]{"Mek", "Proto"};
        int sizeType = 0;
        int classType = 0;
        String pClassstr = (String)JOptionPane.showInputDialog(null, "Select a pilot unit class", "Pilot Class", 1, null, pClass, pClass[0]);
        if (pClassstr == null || pClassstr.length() == 0) {
            return;
        }
        classType = pClassstr.equals("Mek") ? 0 : 3;
        String pSizestr = (String)JOptionPane.showInputDialog(null, "Select a pilot unit size", "Pilot Size", 1, null, pSize, pSize[0]);
        if (pSizestr == null || pSizestr.length() == 0) {
            return;
        }
        sizeType = CUnit.getWeightIDForName(pSizestr);
        if (this.mwclient.getPlayer().getPlayerPersonalPilotQueue().getQueueSize(classType, sizeType) < 1) {
            JOptionPane.showMessageDialog(null, "You do not have any pilots for " + AorAn.check(pSizestr, true) + " " + pSizestr + " " + pClassstr, "No Pilots!", -1);
            return;
        }
        Object[] pilots = this.mwclient.getPlayer().getPlayerPersonalPilotQueue().getPilotQueue(classType, sizeType).toArray();
        JComboBox<String> combo = new JComboBox<String>();
        for (int i = 0; i < pilots.length; ++i) {
            Pilot mm = (Pilot)pilots[i];
            if (classType == 0) {
                combo.addItem(mm.getName() + " (" + mm.getGunnery() + "/" + mm.getPiloting() + ")[" + mm.getSkillString(true) + "]");
                continue;
            }
            combo.addItem(mm.getName() + " (" + mm.getGunnery() + ")[" + mm.getSkillString(true) + "]");
        }
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select a pilot.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        int position = combo.getSelectedIndex();
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c donatepilot#" + classType + "#" + sizeType + "#" + position);
    }

    public void jMenuCommanderDirectSell_actionPerformed(ActionEvent e, String name, String id) {
        String unitID;
        String buyer;
        if (name == null || name.trim().equals("")) {
            PlayerNameDialog pnd = new PlayerNameDialog(this.mwclient, "Buyer", false);
            pnd.setVisible(true);
            buyer = pnd.getPlayerName();
            pnd.dispose();
        } else {
            buyer = name;
        }
        if (buyer == null) {
            return;
        }
        if (id == null || id.trim().equals("")) {
            UnitSelectionDialog usd = new UnitSelectionDialog(this.mwclient, "Unit", "Select a unit to sell");
            usd.setVisible(true);
            unitID = usd.getUnitID();
            usd.dispose();
        } else {
            unitID = id;
        }
        CUnit unit = this.mwclient.getPlayer().getUnit(Integer.parseInt(unitID));
        String serviceFee = "SellDirect" + CUnit.getWeightClassDesc(unit.getWeightclass()) + CUnit.getTypeClassDesc(unit.getType()) + "Price";
        String price = JOptionPane.showInputDialog(this.getContentPane(), (Object)("How much do you wish to offer? (" + this.mwclient.moneyOrFluMessage(true, true, -2) + ")\n\r" + "Please note a service charge of " + this.mwclient.moneyOrFluMessage(true, true, Integer.parseInt(this.mwclient.getserverConfigs(serviceFee))) + " will be added."));
        if (price == null || price.length() < 1) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c directsellunit#" + buyer + "#" + this.mwclient.getPlayer().getName() + "#" + unitID + "#" + price);
    }

    public void jMenuMercOfferContract_actionPerformed(ActionEvent e) {
        String Player2 = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Which Mercenary do you want to contact?");
        String Amount = JOptionPane.showInputDialog(this.getContentPane(), (Object)("How much do you wish to offer? (" + this.mwclient.moneyOrFluMessage(true, true, -2) + ")"));
        String Duration2 = JOptionPane.showInputDialog(this.getContentPane(), (Object)"How would you like him to fight for your (EXP)");
        if (Player2 == null || Amount == null | Duration2 == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c offercontract#" + Player2 + "#" + Amount + "#" + Duration2);
    }

    public void jMenuCommanderDefect_actionPerformed(ActionEvent e) {
        String House2 = "";
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Defect to faction:", false);
        factionDialog.setVisible(true);
        House2 = factionDialog.getHouseName();
        factionDialog.dispose();
        if (House2 == null) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c defect#" + House2);
    }

    public void jMenuCommanderBVCalc_actionPerformed(ActionEvent e) {
        String enteredBVStr = JOptionPane.showInputDialog(this.getContentPane(), (Object)"BV to reach");
        String numberUnitsStr = JOptionPane.showInputDialog(this.getContentPane(), (Object)"To reach with how many Units");
        String rangeStr = JOptionPane.showInputDialog(this.getContentPane(), (Object)"Range to check");
        int option = JOptionPane.showConfirmDialog(null, "Use C3 Linked units?", "C3", 0);
        try {
            int enteredBV = Integer.parseInt(enteredBVStr);
            int numberUnits = numberUnitsStr.length() == 0 ? 4 : Integer.parseInt(numberUnitsStr);
            int range = rangeStr.length() == 0 ? 150 : Integer.parseInt(rangeStr);
            boolean c3 = false;
            if (option == 0) {
                c3 = true;
            }
            this.mwclient.addToChat(this.mwclient.getPlayer().getPossibleLances(enteredBV, numberUnits, range, c3), CCommPanel.CHANNEL_MISC);
        }
        catch (NumberFormatException ex) {
            this.mwclient.addToChat("<font color=\"#ff0000\"> BV-Calculator Error: Argument is not a number! </font> <br>");
        }
    }

    public void jMenuCommanderFireTechs_actionPerformed(ActionEvent e) {
        String techsToFire = JOptionPane.showInputDialog(this.getContentPane(), (Object)"How many techs do you want to fire?");
        if (techsToFire == null || techsToFire.length() == 0) {
            return;
        }
        int techs = Integer.parseInt(techsToFire);
        if (this.thePlayer.getTechs() <= 0) {
            this.mwclient.addToChat("<b>You have no hired techs to fire.<b>");
            return;
        }
        if (techs < 1 || techs > this.thePlayer.getTechs()) {
            this.mwclient.addToChat("<b>Try picking a number between 1 and " + this.thePlayer.getTechs() + "<b>");
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c firetechs#" + techs);
    }

    public void jMenuCommanderHireTechs_actionPerformed(ActionEvent e) {
        String techsToHire = JOptionPane.showInputDialog(this.getContentPane(), (Object)"How many techs do you want to hire?");
        if (techsToHire == null || techsToHire.length() == 0) {
            return;
        }
        int techs = Integer.parseInt(techsToHire);
        if (techs < 1) {
            this.mwclient.addToChat("Try picking a number greater then 0");
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c hiretechs#" + techs);
    }

    public void jMenuHelpViewUnit_actionPerformed(ActionEvent e) {
        UnitLoadingDialog unitLoadingDialog = new UnitLoadingDialog(this.mwclient.getMainFrame());
        UnitViewerDialog unitSelector = new UnitViewerDialog(this.mwclient.getMainFrame(), unitLoadingDialog, this.mwclient, 0);
        new Thread(unitSelector).start();
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        JDialog dlg = new JDialog((Frame)this, "MekWars Client Info");
        JPanel child = new JPanel();
        child.setLayout(new BoxLayout(child, 1));
        JLabel mekwars = new JLabel("MekWars Client Version: " + MWClient.CLIENT_VERSION);
        JLabel version = new JLabel("MegaMek Version: " + MegaMek.VERSION);
        JLabel license1 = new JLabel("MekWars Client software is under GPL. See");
        JLabel license2 = new JLabel("license.txt in ./MekWars Docs/ for details.");
        JLabel license3 = new JLabel("Project Info and Server Packages:");
        JLabel license4 = new JLabel("       http://www.sourceforge.net/projects/mekwars       ");
        JLabel data1 = new JLabel("       Datasets are prepared by server operators.       ");
        JLabel data2 = new JLabel("       Contact a server administrator for information       ");
        JLabel data3 = new JLabel("       regarding data use and redistribution.       ");
        mekwars.setAlignmentX(0.5f);
        version.setAlignmentX(0.5f);
        license1.setAlignmentX(0.5f);
        license2.setAlignmentX(0.5f);
        license3.setAlignmentX(0.5f);
        license4.setAlignmentX(0.5f);
        data1.setAlignmentX(0.5f);
        data2.setAlignmentX(0.5f);
        data3.setAlignmentX(0.5f);
        child.add(new JLabel("\n"));
        child.add(mekwars);
        child.add(version);
        child.add(new JLabel("\n"));
        child.add(license1);
        child.add(license2);
        child.add(new JLabel("\n"));
        child.add(license3);
        child.add(license4);
        child.add(new JLabel("\n"));
        child.add(data1);
        child.add(data2);
        child.add(data3);
        child.add(new JLabel("\n"));
        dlg.getContentPane().add(child);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setResizable(false);
        dlg.pack();
        dlg.setVisible(true);
    }

    public void jMenuHelpHelp_actionPerformed(ActionEvent e) {
        int type;
        CPlayer p = this.mwclient.getPlayer();
        boolean trueCost = Boolean.valueOf(this.mwclient.getserverConfigs("UseCalculatedCosts"));
        String result = "";
        result = result + "<font color=\"black\">";
        result = result + "MEKWARS ONLINE HELP<br>";
        result = result + "Interesting facts:";
        result = result + "<table><tr><th>Name</th><th>" + this.mwclient.moneyOrFluMessage(true, false, -2) + "</th><th>" + this.mwclient.moneyOrFluMessage(false, false, -2) + "</th><th>Components</th><th>Techs</th></tr>";
        int typeamount = 5;
        for (type = 0; type < typeamount; ++type) {
            String useIt = "Use" + CUnit.getDescriptionForID(type);
            if (!Boolean.valueOf(this.mwclient.getserverConfigs(useIt)).booleanValue()) continue;
            for (int weight = 0; weight < 4; ++weight) {
                if (!Boolean.valueOf(this.mwclient.getserverConfigs("UseOnlyLightInfantry")).booleanValue() || type != 2 || weight == 0) {
                    result = result + "<tr><td>" + CUnit.getWeightClassDesc(weight) + " " + CUnit.getTypeClassDesc(type) + "</td><td>";
                }
                result = trueCost ? result + "See Unit Viwer" : result + p.getPriceForUnit(weight, type);
                result = result + "</td><td>" + p.getInfluenceForUnit(weight, type) + "</td><td>" + p.getPPCost(weight, type) + "</td>";
                result = type == 3 ? result + "<td>" + this.mwclient.getserverConfigs("TechsToProtoPointRatio") + " per 5</td>" : result + "<td>" + p.getHangarSpaceRequired(type, weight, 0, "") + "</td>";
                result = result + "</tr>";
            }
        }
        result = result + "</table>";
        result = result + "<br>Repoding facts:";
        result = result + "<table><tr><th>Class</th><th>" + this.mwclient.moneyOrFluMessage(true, false, -2) + "</th><th>" + this.mwclient.moneyOrFluMessage(false, false, -2) + "</th><th>Components</th></tr>";
        typeamount = 1;
        for (type = 0; type < typeamount; ++type) {
            for (int weight = 0; weight < 4; ++weight) {
                String repodFlu = "RepodFlu" + CUnit.getWeightClassDesc(weight);
                String repodCost = "RepodCost" + CUnit.getWeightClassDesc(weight);
                String repodComponents = "RepodComp" + CUnit.getWeightClassDesc(weight);
                int repodCostInt = Integer.parseInt(this.mwclient.getserverConfigs(repodCost));
                int repodComponentsInt = Integer.parseInt(this.mwclient.getserverConfigs(repodComponents));
                if (!Boolean.valueOf(this.mwclient.getserverConfigs("DoesRepodCost")).booleanValue()) {
                    repodCostInt = 0;
                }
                if (!Boolean.valueOf(this.mwclient.getserverConfigs("RepodUsesComp")).booleanValue()) {
                    repodComponentsInt = 0;
                }
                result = result + "<tr><td>" + CUnit.getWeightClassDesc(weight) + "</td><td>" + repodCostInt + "</td><td>" + this.mwclient.getserverConfigs(repodFlu) + "</td><td>" + repodComponentsInt + "</td></tr>";
            }
        }
        result = result + "</table><br>";
        result = result + "<table><tr><th>Size of Unit</th><th>EXP needed</th></tr>";
        result = result + "<tr><td>Medium</td><td>" + this.mwclient.getserverConfigs("MinEXPforMedium") + "</td></tr>";
        result = result + "<tr><td>Heavy</td><td>" + this.mwclient.getserverConfigs("MinEXPforHeavy") + "</td></tr>";
        result = result + "<tr><td>Assault</td><td>" + this.mwclient.getserverConfigs("MinEXPforAssault") + "</td></tr>";
        result = result + "</table>";
        result = result + "EXP needed to Buy/Sell on the Black Market: " + this.mwclient.getserverConfigs("MinEXPforBMBuying") + "/" + this.mwclient.getserverConfigs("MinEXPforBMSelling") + "<br>";
        result = result + "EXP needed to defect from " + this.mwclient.getserverConfigs("NewbieHouseName") + " to a Faction: " + this.mwclient.getserverConfigs("MinEXPforDefecting") + "<br>";
        this.mwclient.addToChat(result, CCommPanel.CHANNEL_MISC);
    }

    public void refreshBattleTable() {
        this.MainPanel.refreshBattleTable();
    }

    void this_componentResized(ComponentEvent e) {
    }

    public void setSoundMuted(boolean b) {
        this.jMenuOptionsMute.setState(b);
    }

    public void updateAttackMenu() {
        if (this.jMenuAttackMenu == null) {
            MWClient.mwClientLog.clientErrLog("Attack Menu is Null!");
            return;
        }
        this.jMenuAttackMenu.updateMenuItems(true);
    }

    public void startHost() {
        this.jMenuHost.setForeground(Color.red);
        this.jMenuCSHostAndJoin.setEnabled(false);
        this.jMenuCSHostDedicated.setEnabled(false);
        this.jMenuCSHostStop.setEnabled(true);
        this.jMenuCSHostAndJoin.setVisible(false);
        this.jMenuCSHostDedicated.setVisible(false);
        this.jMenuCSHostLoad.setVisible(false);
        this.jMenuCSHostLoadAndJoin.setVisible(false);
        this.jMenuCSHostStop.setVisible(true);
    }

    public void stopHost() {
        this.jMenuHost.setForeground(Color.black);
        this.jMenuCSHostAndJoin.setEnabled(true);
        this.jMenuCSHostDedicated.setEnabled(true);
        this.jMenuCSHostStop.setEnabled(false);
        this.jMenuCSHostAndJoin.setVisible(true);
        this.jMenuCSHostDedicated.setVisible(true);
        this.jMenuCSHostLoad.setVisible(true);
        this.jMenuCSHostLoadAndJoin.setVisible(true);
        this.jMenuCSHostStop.setVisible(false);
    }

    public void changeStatus(int status, int laststatus) {
        if (this.mwclient.getConfig().isParam("MENUCOLOR")) {
            if (!this.colorblind) {
                if (status == MWClient.STATUS_LOGGEDIN) {
                    this.jMenuCampaign.setForeground(Color.green);
                } else if (status == MWClient.STATUS_ACTIVE) {
                    this.jMenuCampaign.setForeground(Color.orange);
                } else if (status == MWClient.STATUS_FIGHTING) {
                    this.jMenuCampaign.setForeground(Color.red);
                } else if (status == MWClient.STATUS_LOGGEDOUT || status == MWClient.STATUS_DISCONNECTED) {
                    this.jMenuCampaign.setForeground(Color.black);
                }
            } else if (status == MWClient.STATUS_LOGGEDIN) {
                this.jMenuCampaign.setForeground(Color.cyan);
            } else if (status == MWClient.STATUS_ACTIVE) {
                this.jMenuCampaign.setForeground(Color.yellow);
            } else if (status == MWClient.STATUS_FIGHTING) {
                this.jMenuCampaign.setForeground(Color.darkGray);
            } else if (status == MWClient.STATUS_LOGGEDOUT || status == MWClient.STATUS_DISCONNECTED) {
                this.jMenuCampaign.setForeground(Color.black);
            }
        }
        if (this.mwclient.getConfig().isParam("STATUSINTRAYICON")) {
            if (status == MWClient.STATUS_LOGGEDIN) {
                try {
                    this.setIconImage(this.mwclient.getConfig().getReserveImage().getImage());
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
            if (status == MWClient.STATUS_ACTIVE) {
                try {
                    this.setIconImage(this.mwclient.getConfig().getActiveImage().getImage());
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
            if (status == MWClient.STATUS_FIGHTING) {
                try {
                    this.setIconImage(this.mwclient.getConfig().getFightImage().getImage());
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
            if (status == MWClient.STATUS_LOGGEDOUT) {
                try {
                    this.setIconImage(this.mwclient.getConfig().getLogoutImage().getImage());
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
            if (status == MWClient.STATUS_DISCONNECTED) {
                try {
                    this.setIconImage(this.mwclient.getConfig().getDiscdImage().getImage());
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
        } else {
            try {
                this.setIconImage(this.mwclient.getConfig().getTrayImage().getImage());
            }
            catch (Exception ex) {
                MWClient.mwClientLog.clientErrLog(ex);
            }
        }
        this.MainPanel.changeStatus(status, laststatus);
        this.enableMenu();
        this.repaint();
    }
}

