/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MMGame;
import client.MWClient;
import client.gui.CBMPanel;
import client.gui.CBattlePanel;
import client.gui.CCommPanel;
import client.gui.CHQPanel;
import client.gui.CHSPanel;
import client.gui.CMainFrame;
import client.gui.CMapPanel;
import client.gui.CPlayerPanel;
import client.gui.CUserListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CMainPanel
extends JPanel
implements ChangeListener,
ComponentListener {
    JSplitPane MainSPane;
    JSplitPane TabSPane;
    JSplitPane SideSPane;
    CPlayerPanel PlayerPanel;
    CUserListPanel UserListPanel;
    JTabbedPane MainTPane = new JTabbedPane(3);
    JTabbedPane CommTPane = new JTabbedPane(3);
    CCommPanel CommPanel;
    CSelectTabAction CommSelect;
    CHQPanel HQPanel;
    CBMPanel BMPanel;
    CHSPanel HSPanel;
    CSelectTabAction HQSelect;
    CSelectTabAction BMSelect;
    CSelectTabAction HSSelect;
    CBattlePanel BattlePanel;
    CSelectTabAction BattleSelect;
    CMapPanel MapPanel;
    CSelectTabAction MapSelect;
    MWClient mwclient;
    CTabForwardAction ForwardMainTab;
    CTabBackwardAction BackwardMainTab;
    int panelDividerInt;
    int sPanelDividerInt = 0;
    double panelDivider;

    public CMainPanel(MWClient client, CMainFrame mainFrame) {
        this.mwclient = client;
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(620, 400));
        this.addComponentListener(this);
        this.createMainTPane(mainFrame);
        this.PlayerPanel = new CPlayerPanel(this.mwclient);
        this.UserListPanel = new CUserListPanel(this.mwclient);
        this.add((Component)this.PlayerPanel, "North");
        this.panelDividerInt = this.mwclient.getConfig().getIntParam("PANELDIVIDER");
        this.panelDivider = (double)this.panelDividerInt / 100.0;
        this.sPanelDividerInt = this.mwclient.getConfig().getIntParam("SPLITTERSIZE");
        this.TabSPane = new JSplitPane(0, this.MainTPane, this.CommPanel);
        this.TabSPane.setOneTouchExpandable(true);
        this.TabSPane.setDividerLocation(0.2);
        this.TabSPane.setDividerSize(this.sPanelDividerInt);
        this.SideSPane = new JSplitPane(0, this.PlayerPanel, this.UserListPanel);
        this.SideSPane.setOneTouchExpandable(true);
        this.SideSPane.setDividerLocation(-1);
        this.SideSPane.setDividerSize(this.sPanelDividerInt);
        this.MainSPane = new JSplitPane(1, this.TabSPane, this.SideSPane);
        this.MainSPane.setOneTouchExpandable(true);
        this.MainSPane.setDividerLocation(0.8);
        this.MainSPane.setDividerSize(this.sPanelDividerInt);
        this.add((Component)this.MainSPane, "Center");
        this.ForwardMainTab = new CTabForwardAction();
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt X"), "TabForward");
        this.getActionMap().put("TabForward", this.ForwardMainTab);
        this.BackwardMainTab = new CTabBackwardAction();
        this.getInputMap(2).put(KeyStroke.getKeyStroke("shift alt X"), "TabBackward");
        this.getActionMap().put("TabBackward", this.BackwardMainTab);
        this.revalidate();
    }

    private void addPanelMain(JPanel panel, CSelectTabAction select, String name, String tooltip, String mnemostr, String commandStr) {
        this.MainTPane.addTab(name, null, panel, tooltip);
        int index = this.MainTPane.indexOfComponent(panel);
        int mnemo = this.MainTPane.getTitleAt(index).indexOf(mnemostr.toUpperCase());
        if (mnemo == -1) {
            mnemo = this.MainTPane.getTitleAt(index).indexOf(mnemostr.toLowerCase());
        }
        this.MainTPane.setDisplayedMnemonicIndexAt(index, mnemo);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt " + mnemostr), commandStr);
        this.getActionMap().put(commandStr, select);
    }

    private void addPanelCComm(JPanel panel, CSelectTabAction select, String name, String tooltip, String mnemostr, String commandStr, CCommPanel CommPanel) {
        CommPanel.CommTPane.addTab(name, null, panel, tooltip);
        int index = CommPanel.CommTPane.indexOfComponent(panel);
        int mnemo = CommPanel.CommTPane.getTitleAt(index).indexOf(mnemostr.toUpperCase());
        if (mnemo == -1) {
            mnemo = CommPanel.CommTPane.getTitleAt(index).indexOf(mnemostr.toLowerCase());
        }
        CommPanel.CommTPane.setDisplayedMnemonicIndexAt(index, mnemo);
        CommPanel.CommTPane.getInputMap(2).put(KeyStroke.getKeyStroke("alt " + mnemostr), commandStr);
        CommPanel.CommTPane.getActionMap().put(commandStr, select);
    }

    private void createMainTPane(CMainFrame mainFrame) {
        this.CommPanel = new CCommPanel(this.mwclient);
        String tabText = "";
        String mnemonicText = "";
        if (this.mwclient.getConfig().isParam("HQTABVISIBLE")) {
            this.HQPanel = new CHQPanel(this.mwclient);
            this.HQSelect = new CSelectTabAction(this.HQPanel);
            tabText = this.mwclient.getConfig().getParam("HQTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("HQMNEMONIC");
            if (this.mwclient.getConfig().isParam("HQINTOPROW")) {
                this.addPanelMain(this.HQPanel, this.HQSelect, tabText, "Command Center and Hangars (Alt + " + mnemonicText + ")", mnemonicText, "HQSelect");
            } else {
                this.addPanelCComm(this.HQPanel, this.HQSelect, tabText, "Command Center and Hangars (Alt + " + mnemonicText + ")", mnemonicText, "HQSelect", this.CommPanel);
            }
        }
        if (this.mwclient.getConfig().isParam("BMTABVISIBLE")) {
            this.BMPanel = new CBMPanel(this.mwclient);
            this.BMSelect = new CSelectTabAction(this.BMPanel);
            tabText = this.mwclient.getConfig().getParam("BMTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("BMMNEMONIC");
            if (this.mwclient.getConfig().isParam("BMINTOPROW")) {
                this.addPanelMain(this.BMPanel, this.BMSelect, tabText, "Buy and Sell Units (Alt + " + mnemonicText + ")", mnemonicText, "BMSelect");
            } else {
                this.addPanelCComm(this.BMPanel, this.BMSelect, tabText, "Buy and Sell Units (Alt + " + mnemonicText + ")", mnemonicText, "BMSelect", this.CommPanel);
            }
        }
        if (this.mwclient.getConfig().isParam("HSTATUSTABVISIBLE")) {
            this.HSPanel = new CHSPanel(this.mwclient);
            this.HSSelect = new CSelectTabAction(this.HSPanel);
            tabText = this.mwclient.getConfig().getParam("HSTATUSTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("HSTATUSMNEMONIC");
            if (this.mwclient.getConfig().isParam("HSTATUSINTOPROW")) {
                this.addPanelMain(this.HSPanel, this.HSSelect, tabText, "Show current House Status (Alt + " + mnemonicText + ")", mnemonicText, "HSSelect");
            } else {
                this.addPanelCComm(this.HSPanel, this.HSSelect, tabText, "Show current House Status (Alt + " + mnemonicText + ")", mnemonicText, "HSSelect", this.CommPanel);
            }
        }
        if (this.mwclient.getConfig().isParam("BATTLETABVISIBLE")) {
            this.BattlePanel = new CBattlePanel(this.mwclient);
            this.BattleSelect = new CSelectTabAction(this.BattlePanel);
            tabText = this.mwclient.getConfig().getParam("BATTLETABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("BATTLEMNEMONIC");
            if (this.mwclient.getConfig().isParam("BATTLEINTOPROW")) {
                this.addPanelMain(this.BattlePanel, this.BattleSelect, tabText, "Battles Intelligence Data (Alt + " + mnemonicText + ")", mnemonicText, "BattleSelect");
            } else {
                this.addPanelCComm(this.BattlePanel, this.BattleSelect, tabText, "Battles Intelligence Data (Alt + " + mnemonicText + ")", mnemonicText, "BattleSelect", this.CommPanel);
            }
        }
        this.MapPanel = new CMapPanel(this.mwclient, mainFrame, this.CommPanel.getWidth(), this.CommPanel.getHeight());
        if (this.mwclient.getConfig().isParam("MAPTABVISIBLE")) {
            this.MapSelect = new CSelectTabAction(this.MapPanel);
            tabText = this.mwclient.getConfig().getParam("MAPTABNAME");
            mnemonicText = this.mwclient.getConfig().getParam("MAPMNEMONIC");
            if (this.mwclient.getConfig().isParam("MAPINTOPROW")) {
                this.addPanelMain(this.MapPanel, this.MapSelect, tabText, "Star Map (Alt + " + mnemonicText + ")", mnemonicText, "MapSelect");
            } else {
                this.addPanelCComm(this.MapPanel, this.MapSelect, tabText, "Star Map (Alt + " + mnemonicText + ")", mnemonicText, "MapSelect", this.CommPanel);
            }
        }
        this.MainTPane.addChangeListener(this);
    }

    public void changeStatus(int status, int laststatus) {
        if (status == MWClient.STATUS_LOGGEDIN && laststatus == MWClient.STATUS_LOGGEDOUT) {
            this.UserListPanel.setLoggedIn(true);
            this.UserListPanel.getUsers().getRenderer().setLoggedIn(true);
            if (this.mwclient.getConfig().isParam("PLAYERPANEL")) {
                this.PlayerPanel.setVisible(true);
            }
            this.TabSPane.setDividerLocation(this.panelDivider);
            this.SideSPane.setDividerLocation(-1);
        }
        if (status == MWClient.STATUS_DISCONNECTED || status == MWClient.STATUS_LOGGEDOUT) {
            this.UserListPanel.setLoggedIn(false);
            this.UserListPanel.getUsers().getRenderer().setLoggedIn(false);
            this.PlayerPanel.setVisible(false);
        }
        if (status == MWClient.STATUS_DISCONNECTED) {
            this.MainTPane.setVisible(false);
        } else {
            this.MainTPane.setVisible(true);
        }
        this.CommPanel.changeStatus(status);
    }

    public void selectFirstTab() {
        try {
            this.MainTPane.setSelectedIndex(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CPlayerPanel getPlayerPanel() {
        return this.PlayerPanel;
    }

    public CMapPanel getMapPanel() {
        return this.MapPanel;
    }

    public CUserListPanel getUserListPanel() {
        return this.UserListPanel;
    }

    public CCommPanel getCommPanel() {
        return this.CommPanel;
    }

    public CHQPanel getHQPanel() {
        return this.HQPanel;
    }

    public CBMPanel getBMPanel() {
        return this.BMPanel;
    }

    public CHSPanel getHSPanel() {
        return this.HSPanel;
    }

    public JTable getBattleTable() {
        return this.BattlePanel.getBattleTable();
    }

    public void refreshBattleTable() {
        this.BattlePanel.getBattleTableModel().refreshModel();
    }

    public void stateChanged(ChangeEvent e) {
        if (this.MainTPane.getSelectedIndex() == -1) {
            return;
        }
        if (this.MainTPane.getSelectedComponent() == this.CommPanel) {
            this.CommPanel.getInputField().requestFocusInWindow();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.TabSPane.setDividerLocation(this.panelDivider);
        this.SideSPane.setDividerLocation(-1);
        this.MainSPane.setDividerLocation(0.8);
    }

    public void componentShown(ComponentEvent e) {
        this.TabSPane.setDividerLocation(this.panelDivider);
        this.SideSPane.setDividerLocation(-1);
        this.MainSPane.setDividerLocation(0.8);
    }

    private class CSelectTabAction
    extends AbstractAction {
        Component Tab = null;

        public CSelectTabAction(Component tab) {
            this.Tab = tab;
        }

        public void actionPerformed(ActionEvent e) {
            block3: {
                try {
                    if (CMainPanel.this.MainTPane.isEnabledAt(CMainPanel.this.MainTPane.indexOfComponent(this.Tab))) {
                        CMainPanel.this.MainTPane.setSelectedComponent(this.Tab);
                    }
                }
                catch (Exception ex) {
                    if (!CMainPanel.this.CommPanel.CommTPane.isEnabledAt(CMainPanel.this.CommPanel.CommTPane.indexOfComponent(this.Tab))) break block3;
                    CMainPanel.this.CommPanel.CommTPane.setSelectedComponent(this.Tab);
                }
            }
        }
    }

    private class CTabBackwardAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            int count = CMainPanel.this.MainTPane.getTabCount();
            if (count < 2) {
                return;
            }
            int index = CMainPanel.this.MainTPane.getSelectedIndex();
            if (--index == -1) {
                index = count - 1;
            }
            while (!CMainPanel.this.MainTPane.isEnabledAt(index)) {
                if (--index != -1) continue;
                index = count - 1;
            }
            CMainPanel.this.MainTPane.setSelectedIndex(index);
        }
    }

    private class CTabForwardAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            int count = CMainPanel.this.MainTPane.getTabCount();
            if (count < 2) {
                return;
            }
            int index = CMainPanel.this.MainTPane.getSelectedIndex();
            if (++index == count) {
                index = 0;
            }
            while (!CMainPanel.this.MainTPane.isEnabledAt(index)) {
                if (++index != count) continue;
                index = 0;
            }
            CMainPanel.this.MainTPane.setSelectedIndex(index);
        }
    }

    class BattlePopupListener
    extends MouseAdapter
    implements ActionListener {
        BattlePopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            if (e.isPopupTrigger()) {
                JMenuItem menuItem;
                MMGame curGame = (MMGame)CMainPanel.this.BattlePanel.getBattleTableModel().data.elementAt(CMainPanel.this.BattlePanel.getBattleTable().rowAtPoint(e.getPoint()));
                if (curGame.getCurrentPlayers().size() < curGame.getMaxPlayers()) {
                    menuItem = new JMenuItem("View game");
                    menuItem.setActionCommand("V|" + CMainPanel.this.BattlePanel.getBattleTable().rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    popup.add(menuItem);
                    if (curGame.getStatus().equals("Open")) {
                        menuItem = new JMenuItem("Join game");
                        menuItem.setActionCommand("J|" + CMainPanel.this.BattlePanel.getBattleTable().rowAtPoint(e.getPoint()));
                        menuItem.addActionListener(this);
                        popup.add(menuItem);
                    }
                } else {
                    menuItem = new JMenuItem("Game is full");
                    popup.add(menuItem);
                }
                if (curGame.getPlayerName().equals(CMainPanel.this.mwclient.getUsername())) {
                    menuItem = new JMenuItem("Stop Hosting");
                    menuItem.setActionCommand("S|" + CMainPanel.this.BattlePanel.getBattleTable().rowAtPoint(e.getPoint()));
                    menuItem.addActionListener(this);
                    popup.add(menuItem);
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String s = actionEvent.getActionCommand();
            if (s.startsWith("V|")) {
                CMainPanel.this.mwclient.startClient(Integer.parseInt(s.substring(s.indexOf(124) + 1)), false);
            }
            if (s.startsWith("J|")) {
                CMainPanel.this.mwclient.startClient(Integer.parseInt(s.substring(s.indexOf(124) + 1)), true);
            }
            if (s.startsWith("S|")) {
                CMainPanel.this.mwclient.getMainFrame().stopHost();
                CMainPanel.this.mwclient.stopHost();
            }
        }
    }
}

