/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.CConfig;
import client.MWClient;
import client.campaign.CPlayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;

public class CPlayerPanel
extends JScrollPane {
    MWClient mwclient;
    CPlayer player;
    CConfig config;
    protected JPanel PlayerPanel = new JPanel();
    protected JLabel lblLogo = new JLabel();
    protected JPanel InfoPanel = new JPanel();
    protected JLabel lblName = new JLabel();
    protected JLabel lblStatus = new JLabel();
    protected JLabel lblProfession = new JLabel();
    protected JLabel lblExp = new JLabel();
    protected JLabel lblRating = new JLabel();
    protected JLabel lblMoney = new JLabel();
    protected JLabel lblInfluence = new JLabel();
    protected JLabel lblMekbay = new JLabel();
    protected JLabel lblTechs = new JLabel();
    protected JLabel lblRewardPoints = new JLabel();
    protected JLabel lblNextTick = new JLabel();
    protected long nextTick = System.currentTimeMillis();

    public CPlayerPanel(MWClient client) {
        Insets insets = new Insets(0, 0, 0, 0);
        int center = 10;
        int none = 0;
        String endtag = "";
        String tag = "";
        this.mwclient = client;
        this.player = client.getPlayer();
        this.config = client.getConfig();
        boolean logo = client.getConfig().isParam("LOGO");
        int height = client.getConfig().getIntParam("PLAYERPANELHEIGHT");
        this.setMinimumSize(new Dimension(0, 0));
        Dimension dimension = logo ? new Dimension(140, height + 130) : new Dimension(140, height);
        this.PlayerPanel.setLayout(new GridBagLayout());
        this.PlayerPanel.setMinimumSize(dimension);
        this.PlayerPanel.setPreferredSize(dimension);
        dimension = new Dimension(140, 130);
        this.lblLogo.setHorizontalAlignment(0);
        this.lblLogo.setVerticalAlignment(0);
        this.lblLogo.setIcon(client.getConfig().getLogoImage());
        this.lblLogo.setPreferredSize(dimension);
        this.lblLogo.setMinimumSize(dimension);
        this.lblLogo.setMaximumSize(dimension);
        if (logo) {
            this.PlayerPanel.add((Component)this.lblLogo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, center, none, insets, 0, 0));
        }
        dimension = new Dimension(140, height + 30);
        this.InfoPanel.setLayout(new BoxLayout(this.InfoPanel, 1));
        this.InfoPanel.setPreferredSize(dimension);
        this.InfoPanel.setMinimumSize(dimension);
        this.InfoPanel.setMaximumSize(dimension);
        this.lblName.setText(tag + this.config.getText("PP.NA") + endtag);
        this.lblProfession.setText(tag + this.config.getText("PP.PR") + endtag);
        this.lblStatus.setText(tag + this.config.getText("PP.ST") + endtag);
        this.lblExp.setText(tag + this.config.getText("PP.EX") + endtag);
        this.lblRating.setText(tag + this.config.getText("PP.RA") + endtag);
        this.lblMoney.setText(tag + client.moneyOrFluMessage(true, false, -2) + ": " + endtag);
        this.lblInfluence.setText(tag + client.moneyOrFluMessage(false, true, -2) + endtag);
        this.lblMekbay.setText(tag + this.config.getText("PP.ME") + endtag);
        this.lblTechs.setText(tag + this.config.getText("PP.TH") + endtag);
        this.lblRewardPoints.setText(tag + this.config.getText("PP.RP") + endtag);
        this.lblNextTick.setText("Next Tick: N/A");
        this.InfoPanel.add(this.lblName);
        this.InfoPanel.add(this.lblStatus);
        this.InfoPanel.add(this.lblExp);
        if (!Boolean.valueOf(client.getserverConfigs("HideELO")).booleanValue()) {
            this.InfoPanel.add(this.lblRating);
        }
        this.InfoPanel.add(this.lblMoney);
        this.InfoPanel.add(this.lblInfluence);
        this.InfoPanel.add(this.lblMekbay);
        this.InfoPanel.add(this.lblTechs);
        if (Boolean.valueOf(client.getserverConfigs("ShowReward")).booleanValue()) {
            this.InfoPanel.add(this.lblRewardPoints);
        }
        this.InfoPanel.add(this.lblNextTick);
        if (logo) {
            this.PlayerPanel.add((Component)this.InfoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, center, none, insets, 0, 0));
        } else {
            this.PlayerPanel.add((Component)this.InfoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, center, none, insets, 0, 0));
        }
        if (logo) {
            this.setPreferredSize(new Dimension(130, height + 140));
            this.setMinimumSize(new Dimension(140, height + 140));
            this.setMaximumSize(new Dimension(140, height + 140));
        } else {
            this.setPreferredSize(new Dimension(130, height + 40));
            this.setMinimumSize(new Dimension(140, height + 40));
            this.setMaximumSize(new Dimension(140, height + 40));
        }
        this.setBorder(new LineBorder(Color.black));
        this.setViewportView(this.PlayerPanel);
        TThread clockT = new TThread(this);
        clockT.start();
    }

    public void refresh() {
        String endtag = "";
        String tag = "";
        if (this.mwclient.getConfig().isParam("LOGO")) {
            this.lblLogo.setIcon(this.mwclient.getConfig().getLogoImage());
        }
        this.lblName.setText(tag + this.player.getName());
        this.lblProfession.setText(tag + this.player.getProfession());
        this.lblStatus.setText(tag + this.config.getText("PP.ST") + " " + this.mwclient.getStatus() + endtag);
        this.lblExp.setText(tag + this.config.getText("PP.EX") + " " + this.player.getExp() + endtag);
        DecimalFormat myFormatter = new DecimalFormat("###.##");
        String ratingStr = myFormatter.format(this.player.getRating());
        this.lblRating.setText(tag + this.config.getText("PP.RA") + " " + ratingStr + endtag);
        if (this.player.getMoney() == 0) {
            this.lblMoney.setText(tag + this.mwclient.moneyOrFluMessage(true, false, -2) + ": " + this.player.getMoney() + endtag);
        } else {
            this.lblMoney.setText(tag + this.mwclient.moneyOrFluMessage(true, false, -this.player.getMoney()) + ": " + this.player.getMoney() + endtag);
        }
        if (this.player.getInfluence() == 0) {
            this.lblInfluence.setText(tag + this.mwclient.moneyOrFluMessage(false, false, -2) + ": " + this.player.getInfluence() + endtag);
        } else {
            this.lblInfluence.setText(tag + this.mwclient.moneyOrFluMessage(false, false, -this.player.getInfluence()) + ": " + this.player.getInfluence() + endtag);
        }
        this.lblMekbay.setText(tag + this.config.getText("PP.ME") + " " + this.player.getFreeBays() + "/" + this.player.getBays() + endtag);
        this.lblTechs.setText(tag + this.config.getText("PP.TH") + " " + this.player.getTechs() + " (" + this.mwclient.moneyOrFluMessage(true, true, this.player.getTechCost()) + ")" + endtag);
        this.lblRewardPoints.setText(tag + this.config.getText("PP.RP") + " " + this.player.getRewardPoints() + "/" + this.mwclient.getserverConfigs("XPRewardCap"));
    }

    public void setNextTick(long nextTick) {
        this.nextTick = nextTick;
    }

    public void updateClock() {
        this.lblNextTick.setText("Next Tick: " + (this.nextTick - System.currentTimeMillis()) / 1000L + " s");
    }

    private class TThread
    extends Thread {
        CPlayerPanel myPanel;

        public TThread(CPlayerPanel p) {
            this.myPanel = p;
        }

        public synchronized void run() {
            while (true) {
                this.myPanel.updateClock();
                try {
                    this.wait(1000L);
                    continue;
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                    continue;
                }
                break;
            }
        }
    }
}

